/* ------------------------------ For MsDos -------------------------------*/

/*

    These routines are written for opening and searching the font
    substitute file pointed to by the environmental variable "TEXFONTSUB"

    10/OCT/1992   Eric Ho   9041477@SSCVAX.MCMASTER.CA

*/

#ifdef FONTSUB

#include <stdio.h>
#include <stdlib.h>

FILE *openfontsubfile (void);
char *subfont (FILE *,char *);


char *subfont (fptr,font)
FILE *fptr;
char *font;
{
  char  ofont[30],      /* original font        */
        sfont[30];      /* font to be substitute */

  rewind (fptr);
  while (!feof (fptr)) {
    fscanf (fptr,"%s -> %s",ofont,sfont);
    if (strcmp (ofont,font) == 0) {
/*      fprintf (stderr,"Replacing %s with %s\n",font,sfont); */
      return (sfont);
    }
  }
  return (NULL);
}



FILE *openfontsubfile (void)
{
  FILE *fptr;
  char fontsfname[64],
       *sptr;             /* font substitue file name */

  if ((sptr = (char *) getenv ("TEXFONTSUB")) != (char *) NULL) {
    (void) strcpy (fontsfname,sptr);
    if ((fptr = fopen (fontsfname,"r")) != (FILE *) NULL) {
      return ((FILE *) fptr);
    } else {
      fprintf (stderr,"\n\nFont substitute file not found!\n");
      fprintf (stderr,"Check environmental variable TEXFONTSUB!\n\n");
      return ((FILE *) NULL);
    }
  } else {
    fprintf (stderr,"\n\nCheck environmental variable TEXFONTSUB!\n\n");
    return ((FILE *) NULL);
  }
}

#endif
