Program WordPerfect_to_LaTeX;

{           Version 1.0
            Date 27-1-1990
}

{$R+}       { Range check error }

Uses Crt;   { Clearscreen }

CONST tex_TABBING=FALSE;

Type  Bin = file of byte;

Var
   wpd_fn,
   strip_fn,
   tabel_fn,
   latex_fn  : String;

   wpd,
   tabel : Bin;
   strip,
   latex : Text;

   num_of_lines_stripfile : Word;

   open_com,
   close_com : Array [$0..$10] of String;

   Exitsave : pointer;


Procedure Rd_word(Var f:Bin; Var w:Word);
{ Deze procedure leest een woord uit de opgegeven binaire file. }

Var
   b : Byte;

Begin
   Read(f,b);
   w:=b;
   Read(f,b);
   w:=w+256*b
End;


Procedure Wr_word(Var f:Bin; w:Word);
{ Deze procedure schrijft een woord in de opgegeven binaire file. }

Var
   b : Byte;

Begin
   b:=w mod 256;
   Write(f,b);
   b:=w div 256;
   Write(f,b);
End;


Procedure Jump_in_file(Var f:Bin; dis:Longint);
{ Deze procedure springt in een binaire file het aantal opgegeven bytes. }

Var
   cur_pos : Longint;

Begin
   cur_pos := Filepos(f);
   Seek(f,cur_pos+dis);
End;



Procedure Wpd_check;
{ Kontroleert of de opgegeven WP-document wel daadwerkelijk een   }
{ WP5.0-document is.                                              }

Var id1,id2,std1,std2,filetype,dmp1,dmp2,dmp3 : Word;
    Startdoc, Pointer : Longint;
    b:Byte;

Begin
   Rd_word(wpd,id1); Rd_word(wpd,id2);
   Rd_word(wpd,std1); Rd_word(wpd,std2);
   Rd_word(wpd,filetype);
   Rd_word(wpd,dmp1); Rd_word(wpd,dmp2); Rd_word(wpd,dmp3);

   Startdoc:=std2*65536+std1;

   If (id1=$57ff) and (id2=$4350) and
      (filetype=$0A01)  {and (dmp1=$0) and (dmp2=$0) and (dmp3=$0)}

   Then Seek(wpd,startdoc)    { Het is een WP5.0-document}
   Else RunError($0201)       { Het is geen WP5.0-document}
End;




Procedure Filenames;
{ Deze procedure handelt het opgeven van de filenamen af. }

Var
   name,
   invoer,
   wpdef,
   latdef,
   filename,
   ext           : String;
   l,p           : Integer;

Begin
   If ParamCount<1
   Then wpdef:=''
   Else wpdef:=Paramstr(1);

   Writeln;
   Writeln;
   Write('WordPerfect-filename [',wpdef,'] : ');
   Readln(invoer);
   If invoer=''
   Then wpd_fn:=wpdef
   Else wpd_fn:=invoer;

   If wpd_fn=''                 { No filename entered }
   Then RunError($200);

   name:=wpd_fn;
   l:=Length(name);
   p:=Pos('.',name);
   if p=0 then p:=l+1;
   filename:=copy(name,1,p-1);

   strip_fn:=concat(filename,'.STR');
   tabel_fn:=concat(filename,'.TBL');
   latdef:=concat(filename,'.TEX');

   Write('LaTeX-filename [',latdef,'] : ');
   Readln(invoer);
   Writeln;
   If invoer=''
   Then latex_fn:=latdef
   Else latex_fn:=invoer;

   Assign(wpd,wpd_fn);
   Assign(strip,strip_fn);
   Assign(tabel,tabel_fn);
   Assign(latex,latex_fn);

End;


{$F+}
Procedure Einde_prog;
{ Deze procedure wordt aan het einde van het programma aangeroepen. }
{ Er wordt gekeken of er zich Run-Time error heeft voor gedaan.     }

Var
   save_ErrorAddr : Pointer;

Begin
   Writeln;

   ExitProc:=Exitsave;
   save_ErrorAddr := ErrorAddr;
   ErrorAddr := nil;

   If save_ErrorAddr <> nil
   Then Case Exitcode of
               $0002 : Writeln('File not found.');
               $0003 : Writeln('Path not found.');
               $0100 : Writeln('Program Error.');
               $0200 : Writeln('No filename entered !');
               $0201 : Writeln('Not a WordPerfect 5.0 document !');

             Else ErrorAddr := save_ErrorAddr;
        End

   Else Begin
           Writeln('Conversion completed.');
           Writeln;
        End;

   Writeln;
End;
{$F-}


Procedure Init_commando;
Begin
   Open_com[$0]:='{\LARGE ';
   Open_com[$1]:='{\Large ';
   Open_com[$2]:='{\large ';
   Open_com[$3]:='{\small ';
   Open_com[$4]:='{\footnotesize ';
   Open_com[$5]:='$^{\rm ';
   Open_com[$6]:='$_{\rm ';
   Open_com[$7]:='';
   Open_com[$8]:='{\it ';
   Open_com[$9]:='';
   Open_com[$A]:='';
   Open_com[$B]:='\underline{\Underline{';
   Open_com[$C]:='{\bf ';
   Open_com[$D]:='';
   Open_com[$E]:='\Underline{';
   Open_com[$F]:='{\sc ';

   Close_com[$0]:='}';
   Close_com[$1]:='}';
   Close_com[$2]:='}';
   Close_com[$3]:='}';
   Close_com[$4]:='}';
   Close_com[$5]:='}$';
   Close_com[$6]:='}$';
   Close_com[$7]:='';
   Close_com[$8]:='\/}';
   Close_com[$9]:='';
   Close_com[$A]:='';
   Close_com[$B]:='}}';
   Close_com[$C]:='}';
   Close_com[$D]:='';
   Close_com[$E]:='}';
   Close_com[$F]:='}';
End;


{---SLAG1----}

Procedure Convert_first_strike;
{ Dit is de komplete procedure van de eerste slag met zijn eigen proc.'s. }

Var
   by  : Byte;
   wo,
   regelnum  : Word;

   convperc,
   i     : Integer;

   srtdocpos,
   fsize,
   fpos,
   nextdocpos : longint;

   lat    : Array[$20..$7F] of String[25];
   char_set  : Array[$80..$FE] of Integer;
   char_code : Array[$80..$FE] of Integer;
   ext_lat   : Array[$80..$FE] of String[25];


   leegptr,
   openptr               : Array [0..1] of Integer;
   attr_rij              : Array [0..1,0..16] of Byte;
   open_attr_rij         : Array [0..1] of Boolean;
   depth                 : Integer;

   envir,
   line_term      : Char;

   char_on_line,
   nomore_valid_tabs,
   indenting,
   indent_end,
   ind_text1,
   ind_text2  : Boolean;

   ind_leftmargin,
   ind_rightmargin : Word;

   num_of_tabs,
   latex_tabpos : Integer;
   tabpos       : Array [1..40] of Word;
   right_tab,
   align_tab,
   center_tab   : Boolean;

   WP_sidemargin  : Integer;




Procedure WP_Default;
Var
   j : Integer;

Begin
   WP_sidemargin := 1200;

   tabpos[1]:=$02c5;                      { 1e WP-tab is kantlijn --> }
   For j:=2 to 10
   Do tabpos[j]:=tabpos[j-1]+$02c5;       { Volgende tabs 1,5  cm     }
   For j:=11 to 40                        { ($02c5 wpu) verder        }
   Do tabpos[j]:=$FFFF;

   num_of_tabs:=10;
End;


Procedure Table_Init;
Begin
   lat[$20]:=' ';                        {Space}
   lat[$21]:='!';                        {!}
   lat[$22]:='"';                        {"}
   lat[$23]:='\#';                       {#}
   lat[$24]:='\$';                       {dollar}
   lat[$25]:='\%';                       {%}
   lat[$26]:='\&';                       {&}
   lat[$27]:='''';                        {'}
   lat[$28]:='(';                        {(}
   lat[$29]:=')';                        {)}
   lat[$2A]:='*';                        {*}
   lat[$2B]:='+';                        {+}
   lat[$2C]:=',';                        {,}
   lat[$2D]:='-';                        {-}
   lat[$2E]:='.';                        {.}
   lat[$2F]:='/';                        {/}
   lat[$30]:='0';                        {0}
   lat[$31]:='1';                        {1}
   lat[$32]:='2';                        {2}
   lat[$33]:='3';                        {3}
   lat[$34]:='4';                        {4}
   lat[$35]:='5';                        {5}
   lat[$36]:='6';                        {6}
   lat[$37]:='7';                        {7}
   lat[$38]:='8';                        {8}
   lat[$39]:='9';                        {9}
   lat[$3A]:=':';                        {:}
   lat[$3B]:=';';                        {;}
   lat[$3C]:='$<$';                      {<}
   lat[$3D]:='=';                        {=}
   lat[$3E]:='$>$';                      {>}
   lat[$3F]:='?';                        {?}
   lat[$40]:='@';                        {@}
   lat[$41]:='A';                        {A}
   lat[$42]:='B';                        {B}
   lat[$43]:='C';                        {C}
   lat[$44]:='D';                        {D}
   lat[$45]:='E';                        {E}
   lat[$46]:='F';                        {F}
   lat[$47]:='G';                        {G}
   lat[$48]:='H';                        {H}
   lat[$49]:='I';                        {I}
   lat[$4A]:='J';                        {J}
   lat[$4B]:='K';                        {K}
   lat[$4C]:='L';                        {L}
   lat[$4D]:='M';                        {M}
   lat[$4E]:='N';                        {N}
   lat[$4F]:='O';                        {O}
   lat[$50]:='P';                        {P}
   lat[$51]:='Q';                        {Q}
   lat[$52]:='R';                        {R}
   lat[$53]:='S';                        {S}
   lat[$54]:='T';                        {T}
   lat[$55]:='U';                        {U}
   lat[$56]:='V';                        {V}
   lat[$57]:='W';                        {W}
   lat[$58]:='X';                        {X}
   lat[$59]:='Y';                        {Y}
   lat[$5A]:='Z';                        {Z}
   lat[$5B]:='[';                        {[}
   lat[$5C]:='$\tt\backslash$';          {\}
   lat[$5D]:=']';                        {]}
   lat[$5E]:='\^{';                      {^}
   lat[$5F]:='\_';                       {_}
   lat[$60]:='`';                        {`}
   lat[$61]:='a';                        {a}
   lat[$62]:='b';                        {b}
   lat[$63]:='c';                        {c}
   lat[$64]:='d';                        {d}
   lat[$65]:='e';                        {e}
   lat[$66]:='f';                        {f}
   lat[$67]:='g';                        {g}
   lat[$68]:='h';                        {h}
   lat[$69]:='i';                        {i}
   lat[$6A]:='j';                        {j}
   lat[$6B]:='k';                        {k}
   lat[$6C]:='l';                        {l}
   lat[$6D]:='m';                        {m}
   lat[$6E]:='n';                        {n}
   lat[$6F]:='o';                        {o}
   lat[$70]:='p';                        {p}
   lat[$71]:='q';                        {q}
   lat[$72]:='r';                        {r}
   lat[$73]:='s';                        {s}
   lat[$74]:='t';                        {t}
   lat[$75]:='u';                        {u}
   lat[$76]:='v';                        {v}
   lat[$77]:='w';                        {w}
   lat[$78]:='x';                        {x}
   lat[$79]:='y';                        {y}
   lat[$7A]:='z';                        {z}
   lat[$7B]:='\{';                       {{}
   lat[$7C]:='$|$';                      {|}
   lat[$7D]:='\}';                       { }
   lat[$7E]:='\tidle{';                  {~}
   lat[$7F]:=' ';                        {Don't exsist}
End;


Procedure Ext_chr_init;
Begin
   char_set[$80]:=$01;  char_code[$80]:=$26;  ext_lat[$80]:='\c{C}';
   char_set[$81]:=$01;  char_code[$81]:=$47;  ext_lat[$81]:='\"{u}';
   char_set[$82]:=$01;  char_code[$82]:=$29;  ext_lat[$82]:='\''{e}';
   char_set[$83]:=$01;  char_code[$83]:=$1D;  ext_lat[$83]:='\^{a}';
   char_set[$84]:=$01;  char_code[$84]:=$1F;  ext_lat[$84]:='\"{a}';
   char_set[$85]:=$01;  char_code[$85]:=$21;  ext_lat[$85]:='\`{a}';
   char_set[$86]:=$01;  char_code[$86]:=$23;  ext_lat[$86]:='\aa ';
   char_set[$87]:=$01;  char_code[$87]:=$27;  ext_lat[$87]:='\c{c}';
   char_set[$88]:=$01;  char_code[$88]:=$2B;  ext_lat[$88]:='\^{e}';
   char_set[$89]:=$01;  char_code[$89]:=$2D;  ext_lat[$89]:='\"{e}';
   char_set[$8A]:=$01;  char_code[$8A]:=$2F;  ext_lat[$8A]:='\`{e}';
   char_set[$8B]:=$01;  char_code[$8B]:=$35;  ext_lat[$8B]:='\"{\i}';
   char_set[$8C]:=$01;  char_code[$8C]:=$33;  ext_lat[$8C]:='\^{\i}';
   char_set[$8D]:=$01;  char_code[$8D]:=$37;  ext_lat[$8D]:='\`{\i}';
   char_set[$8E]:=$01;  char_code[$8E]:=$1E;  ext_lat[$8E]:='\"{A}';
   char_set[$8F]:=$01;  char_code[$8F]:=$22;  ext_lat[$8F]:='\AA ';
   char_set[$90]:=$01;  char_code[$90]:=$28;  ext_lat[$90]:='\''{E}';
   char_set[$91]:=$01;  char_code[$91]:=$25;  ext_lat[$91]:='\ae ';
   char_set[$92]:=$01;  char_code[$92]:=$24;  ext_lat[$92]:='\AE ';
   char_set[$93]:=$01;  char_code[$93]:=$3D;  ext_lat[$93]:='\^{o}';
   char_set[$94]:=$01;  char_code[$94]:=$3F;  ext_lat[$94]:='\"{o}';
   char_set[$95]:=$01;  char_code[$95]:=$41;  ext_lat[$95]:='\`{o}';
   char_set[$96]:=$01;  char_code[$96]:=$45;  ext_lat[$96]:='\^{u}';
   char_set[$97]:=$01;  char_code[$97]:=$49;  ext_lat[$97]:='\`{u}';
   char_set[$98]:=$01;  char_code[$98]:=$8B;  ext_lat[$98]:='\"{y}';
   char_set[$99]:=$01;  char_code[$99]:=$3E;  ext_lat[$99]:='\"{O}';
   char_set[$9A]:=$01;  char_code[$9A]:=$46;  ext_lat[$9A]:='\"{U}';
   char_set[$9B]:=$04;  char_code[$9B]:=$13;  ext_lat[$9B]:='\ ';
   char_set[$9C]:=$04;  char_code[$9C]:=$0B;  ext_lat[$9C]:='\pounds ';
   char_set[$9D]:=$04;  char_code[$9D]:=$0C;  ext_lat[$9D]:='\ ';
   char_set[$9E]:=$04;  char_code[$9E]:=$0D;  ext_lat[$9E]:='\ ';
   char_set[$9F]:=$04;  char_code[$9F]:=$0E;  ext_lat[$9F]:='{\it f}\/';
   char_set[$A0]:=$01;  char_code[$A0]:=$1B;  ext_lat[$A0]:='\''{a}';
   char_set[$A1]:=$01;  char_code[$A1]:=$31;  ext_lat[$A1]:='\''{\i}';
   char_set[$A2]:=$01;  char_code[$A2]:=$3B;  ext_lat[$A2]:='\''{o}';
   char_set[$A3]:=$01;  char_code[$A3]:=$43;  ext_lat[$A3]:='\''{u}';
   char_set[$A4]:=$01;  char_code[$A4]:=$39;  ext_lat[$A4]:='\~{n}';
   char_set[$A5]:=$01;  char_code[$A5]:=$38;  ext_lat[$A5]:='\~{N}';
   char_set[$A6]:=$04;  char_code[$A6]:=$0F;  ext_lat[$A6]:='\astrike ';
   char_set[$A7]:=$04;  char_code[$A7]:=$10;  ext_lat[$A7]:='\ostrike ';
   char_set[$A8]:=$04;  char_code[$A8]:=$08;  ext_lat[$A8]:='?`';
   char_set[$A9]:=$05;  char_code[$A9]:=$10;  ext_lat[$A9]:='~';
   char_set[$AA]:=$06;  char_code[$AA]:=$14;  ext_lat[$AA]:='~';
   char_set[$AB]:=$04;  char_code[$AB]:=$11;  ext_lat[$AB]:='$\frac{1}{2}$';
   char_set[$AC]:=$04;  char_code[$AC]:=$12;  ext_lat[$AC]:='$\frac{1}{4}$';
   char_set[$AD]:=$04;  char_code[$AD]:=$07;  ext_lat[$AD]:='!`';
   char_set[$AE]:=$04;  char_code[$AE]:=$09;  ext_lat[$AE]:='$\ll$';
   char_set[$AF]:=$04;  char_code[$AF]:=$0A;  ext_lat[$AF]:='$\gg$';
   char_set[$E0]:=$08;  char_code[$E0]:=$01;  ext_lat[$E0]:='$\alpha$';
   char_set[$E1]:=$01;  char_code[$E1]:=$17;  ext_lat[$E1]:='$\beta$';
   char_set[$E2]:=$08;  char_code[$E2]:=$06;  ext_lat[$E2]:='$\Gamma$';
   char_set[$E3]:=$08;  char_code[$E3]:=$21;  ext_lat[$E3]:='$\pi$';
   char_set[$E4]:=$08;  char_code[$E4]:=$24;  ext_lat[$E4]:='$\Sigma$';
   char_set[$E5]:=$08;  char_code[$E5]:=$25;  ext_lat[$E5]:='$\sigma$';
   char_set[$E6]:=$08;  char_code[$E6]:=$19;  ext_lat[$E6]:='$\mu$';
   char_set[$E7]:=$08;  char_code[$E7]:=$29;  ext_lat[$E7]:='$\tau$';
   char_set[$E8]:=$08;  char_code[$E8]:=$2C;  ext_lat[$E8]:='$\Phi$';
   char_set[$E9]:=$08;  char_code[$E9]:=$10;  ext_lat[$E9]:='$\theta$';
   char_set[$EA]:=$08;  char_code[$EA]:=$32;  ext_lat[$EA]:='$\Omega$';
   char_set[$EB]:=$08;  char_code[$EB]:=$09;  ext_lat[$EB]:='$\delta$';
   char_set[$EC]:=$06;  char_code[$EC]:=$13;  ext_lat[$EC]:='$\infty$';
   char_set[$ED]:=$08;  char_code[$ED]:=$2D;  ext_lat[$ED]:='$\emptyset$';
   char_set[$EE]:=$08;  char_code[$EE]:=$0B;  ext_lat[$EE]:='$\epsilon$';
   char_set[$EF]:=$06;  char_code[$EF]:=$10;  ext_lat[$EF]:='$\cap$';
   char_set[$F0]:=$06;  char_code[$F0]:=$0E;  ext_lat[$F0]:='$\equiv$';
   char_set[$F1]:=$06;  char_code[$F1]:=$01;  ext_lat[$F1]:='$\pm$';
   char_set[$F2]:=$06;  char_code[$F2]:=$03;  ext_lat[$F2]:='$\geq$';
   char_set[$F3]:=$06;  char_code[$F3]:=$02;  ext_lat[$F3]:='$\leq$';
   char_set[$F4]:=$07;  char_code[$F4]:=$00;  ext_lat[$F4]:='~';
   char_set[$F5]:=$07;  char_code[$F5]:=$01;  ext_lat[$F5]:='~';
   char_set[$F6]:=$06;  char_code[$F6]:=$08;  ext_lat[$F6]:='$\div$';
   char_set[$F7]:=$06;  char_code[$F7]:=$0D;  ext_lat[$F7]:='$\approx$';
   char_set[$F8]:=$06;  char_code[$F8]:=$24;  ext_lat[$F8]:='\degrees ';
   char_set[$F9]:=$06;  char_code[$F9]:=$1F;  ext_lat[$F9]:='~';
   char_set[$FA]:=$06;  char_code[$FA]:=$20;  ext_lat[$FA]:='~';
   char_set[$FB]:=$07;  char_code[$FB]:=$04;  ext_lat[$FB]:='$\surd$';
   char_set[$FC]:=$04;  char_code[$FC]:=$15;  ext_lat[$FC]:='$^{n}$';
   char_set[$FD]:=$04;  char_code[$FD]:=$14;  ext_lat[$FD]:='$^{2}$';
   char_set[$FE]:=$04;  char_code[$FE]:=$02;  ext_lat[$FE]:='~';
End;


Procedure Make_tabelentry_attr;
Var
   b,
   num_of_attr : Byte;
   j : Integer;

Begin
   num_of_attr := openptr[depth];
   Write(tabel,num_of_attr);

   For j:=1 to num_of_attr
   Do Write(tabel,attr_rij[depth,j]);

End;



Procedure Make_tabelentry_tabset;
Var
   b : Byte;
   j : Integer;

Begin
   b := ord('S');
   Write(tabel,b);

   b:=num_of_tabs;
   Write(tabel,b);

   For j:=1 to num_of_tabs
   Do Wr_word(tabel,tabpos[j]);
End;


Procedure Make_tabelentry_rightjustification;
Var
   b : Byte;

Begin
   b := Ord('U');
   Write(tabel,b);

   If by=$81
   Then b:=01                            { regels WEL uitvullen }
   Else b:=00;                           { regels NIET uitvullen }
   Write(tabel,b);
End;




Procedure Make_tabelentry_envir_extra_end;
Var
   b : Byte;

Begin

   Case envir of
      'C' : Begin
               b:=ord('C');
               Write(tabel,b);
            End;

      'T' : Begin
               b:=ord('T');
               Write(tabel,b);
            End;

      'I' : Begin
               b:=ord('I');
               Write(tabel,b);
               Wr_word(tabel,ind_leftmargin);
               Wr_word(tabel,ind_rightmargin);

               If ind_text2
               Then Begin
                       b:=01;
                       Write(tabel,b)
                    End
               Else Begin
                       b:=00;
                       Write(tabel,b)
                    End;

            End;

   End;  {Case}

   b := Ord(line_term);
   write(tabel,b);

   b:=$FF;
   Write(tabel,b);

End;


Procedure Reset_attr_rij(d : Integer);
Var
   j : Integer;

Begin
   For j:=0 to 16
   Do attr_rij[d,j]:=$00;
   leegptr[d]:=1;
   openptr[d]:=0;
End;



Procedure Open_all_attr;
{ -- Open alle commando's door de Attributen-rij af te lopen -- }

Var j:Integer;
Begin
  For j:=(openptr[depth]+1) to (leegptr[depth]-1)
  Do Begin
         Write(strip,Open_com[attr_rij[depth,j]]);
         openptr[depth]:=openptr[depth]+1;
      End;

  open_attr_rij[depth]:=False            { Alle attributen staan weer goed }
End;



Procedure Close_all_attr;
{ -- Sluit alle commando's door de Attributen-rij af te lopen -- }
Var j:Integer;
Begin
  For j:=openptr[depth] Downto 1
  Do Begin
        Write(strip,Close_com[attr_rij[depth,j]]);
        openptr[depth]:=openptr[depth]-1;
     End;
  open_attr_rij[depth] := True;
End;



Procedure Attr_ON;
{ Deze procedure plaatst een attribuut (lettertype) in de attribuut-rij }

Var
   b : Byte;

Begin
   Read(wpd,b);                             { lees attribuut-code }

   attr_rij[depth,leegptr[depth]]:=b;       { attribuut in attr-rij }
   leegptr[depth]:=leegptr[depth]+1;        { plaats 1 verder. }
   open_attr_rij[depth]:=True;              { openstaande attr-rij }

   Read(wpd,b);                             { lees voorbij afsluitcode }
End;



Procedure Attr_OFF;
{ Deze procedure haalt een uit een attribuut (lettertype) uit de }
{ attribuut-rij door middel van een stack principe omdat binnen  }
{ LaTeX de later geopende kommando's eerst afgesloten te worden  }

Var
   b       : Byte;
   found   : Boolean;
   j,
   codeptr : Integer;

Begin
   Read(wpd,b);                             { lees attribuut-code }

   j:=leegptr[depth];                       { zoek vanaf top attr-rij }
   found:=False;                            { nog niet gevonden }

   While (j>1) and (Not found)              { zoek attr-code in attr-rij }
   Do Begin
        j:=j-1;
        found:=(attr_rij[depth,j]=b)
      End;

   If j<=0 Then RunError($0100);            { Moet nooit kunnen voorkomen }
   codeptr:=j;                              { plaats van attr-code in rij }

{ Sluit alle commando's t/m de desbetreffende code als deze nog niet }
{ gesloten zijn.                                                     }

   If codeptr<=openptr[depth]
   Then Begin
           For j:=openptr[depth] downto codeptr
           Do Begin
                 Write(strip,Close_com[attr_rij[depth,j]]);
                 openptr[depth]:=openptr[depth]-1;
              End;
        End;

{ Haal de desbetreffende attribuut uit de rij en werk pointers bij }

   For j:=codeptr to (leegptr[depth]-1)
   Do attr_rij[depth,j]:=attr_rij[depth,j+1];
   leegptr[depth]:=leegptr[depth]-1;

   open_attr_rij[depth]:=True;                { openstaande attr-rij }

   Read(wpd,b);                               { lees voorbij afsluitcode }
End;



Procedure Center;
{ Deze procedure zorgt voor center environment zolang er nog geen }
{ andere environment is begonnen.                                 }

Begin
   If envir=' '
   Then envir:='C';                    { environment = center }

   Jump_in_file(wpd,7);                { rest van code overslaan }
End;



Procedure End_Align;
Begin
   If align_tab
   Then Begin
           Close_all_attr;
           Write(strip,'\''');
           align_tab := False;
           Open_all_attr;
        End;

   If right_tab
   Then Begin
           Close_all_attr;
           Write(strip,'\''');
           right_tab := False;
           Open_all_attr;
        End;

   If center_tab
   Then Begin
           Close_all_attr;
           Write(strip,'}');
           center_tab := False;
           Open_all_attr;
        End;
End;



Procedure Tab;
Var
   j : integer;
   wpu : word;
   tabnum,
   new_tabs : Integer;

Begin
   If (envir<>'I') and Not Nomore_valid_tabs      { Noggeen indent --> normaal tab }
   Then Begin
           If by=$48
           Then right_tab := True;

           If by=$40
           Then align_tab := True;

           If by=$C8
           Then center_tab := True;

           Jump_in_file(wpd,2);

           Rd_word(wpd,wpu);                       { Lees abs.-indent [wpu] }
           wpu := wpu - WP_sidemargin;             { Correctie ivm WP kantlijn }

           tabnum:=0;
           For j:=1 to num_of_tabs                 { Bepaal welke tabpos }
           Do If wpu>=tabpos[j]
              Then tabnum:=j;

           new_tabs := tabnum - latex_tabpos;

           If new_tabs>0
           Then Begin
                   Close_all_attr;

                   For j:=1 to new_tabs
                   Do  {****** Modify } Write(strip,' ');
                       {Write(strip,'\>')}

                   If center_tab
                   Then Write(strip,'\ctab{');

                   Open_all_attr;
                End;

           latex_tabpos:=tabnum;

           Jump_in_file(wpd,3);

           envir:='T';                              { Er zit een tab in deze regel }
        End

   Else Jump_in_file(wpd,7);

End;



Procedure Flush_right_tab;
Begin
   If envir<>'I'
   Then Begin
           Close_all_attr;
           Write(strip,'\`');
           Open_all_attr;

           Nomore_valid_tabs := True;

           envir:='T';
        End;

   Jump_in_file(wpd,7);
End;



Procedure Indent;
Var
   dif,
   abs        : Word;
   b          : Byte;

Begin
   If envir<>'T'
   Then Begin       {Al een tabcommando gezet dus er mag geen insp }
           Envir:='I';
           indenting:=True;

           If Not ind_text2
           Then Begin
                   Read(wpd,b);
                   b:=b And $01;

                   Rd_word(wpd,dif);
                   Rd_word(wpd,abs); { Eigenlijk Old current column }
                   Rd_word(wpd,abs);

                   ind_leftmargin:=abs-WP_sidemargin;

                   If b=1
                   Then ind_rightmargin:=ind_rightmargin+dif;
                   {Margins bepaald lees voorby rest van functie-codes }
                   Jump_in_file(wpd,3);

                   If Not ind_text1
                   Then Begin
                           If char_on_line
                           Then Begin
                                   Write(strip,'}');
                                   ind_text1:=True;
                                End;
                         End;
                 End
           Else Jump_in_file(wpd,10);
        End
   Else Jump_in_file(wpd,10);
End;


Procedure End_of_indent;
Begin
   indent_end := True;
   Jump_in_file(wpd,5);
End;



Procedure Tabset;
Var
   j           : Integer;
   w           : Word;
   b           : Byte;

Begin
   Jump_in_file(wpd,102);        { Ga naar TAB-info }

   num_of_tabs:=0;

   For j:=1 to 40
   Do Begin
         Rd_word(wpd,w);
         If (w>WP_sidemargin) and (w<>$FFFF)
         Then Begin
                 num_of_tabs:=num_of_tabs+1;
                 tabpos[num_of_tabs] := w - WP_sidemargin;
              End;
      End;

   Jump_in_file(wpd,24);

   Make_tabelentry_tabset;
End;



Procedure Page_number_position;
Var
   position_code : Byte;

Begin
   Jump_in_file(wpd,5);            {Skip length of code; always 10}
                                   { + old information }
   Read(wpd,position_code);

   Write(strip,'\pagenumpos');
   Case position_code of
     $01 : Write(strip,'{\pntl}');
     $02 : Write(strip,'{\pntc}');
     $03 : Write(strip,'{\pntr}');
     $05 : Write(strip,'{\pnbl}');
     $06 : Write(strip,'{\pnbc}');
     $07 : Write(strip,'{\pnbr}');
     Else  Write(strip,'{\pnno}');
   End;

   Jump_in_file(wpd,6);
End;

 

Procedure Character;
Var
   ch          : String;

   j           : Integer;
   chr_code,
   chr_set,
   b           : Byte;
   found       : Boolean;


Begin
   If open_attr_rij[depth]
   Then Open_all_attr;

   Case by of
      $20..$7F : { Normal_char  }
                 Begin
                    ch := lat[by];
                 End;

      $A9      : { Special_char }
                 Begin
                    If by=$A9
                    Then ch:='-'
                    Else ch:='\ ';
                 End;

      $C0      : { Extended_char }
                 Begin
                    j:=127;
                    found:=false;

                    Read(wpd,chr_code);
                    Read(wpd,chr_set);

                    While (j<254) and not found
                    Do Begin
                          j:=j+1;
                          If (chr_code=char_code[j]) and (chr_set=char_set[j])
                          Then found:=True;
                       End;

                    If found
                    Then ch:=ext_lat[j]
                    Else ch:='\ ';

                    Read(wpd,b);
                 End;

      End;

   Write(strip,ch);

End;



Procedure Return_Page;
Var
   j :Integer;
   ond : Boolean;

Begin

   Case by of
    $0A,$8C : line_term := 'R';     { Hard return }
      $0D   : line_term := 'r';     { Soft return }
      $0C   : line_term := 'P';     { Hard page }
      $0B   : line_term := 'p';     { Soft page }
   End;

   Writeln(strip);

   Make_Tabelentry_envir_extra_end;

   If indent_end
   Then Begin
           envir:=' ';
           indenting:=False;
           ind_text1:=False;
           ind_text2:=False;
           ind_leftmargin:=0;
           ind_rightmargin:=0;

           indent_end:=False;
        End

   Else If envir<>'I'
        Then envir:=' ';

   char_on_line:=False;
   nomore_valid_tabs := False;

   regelnum:=regelnum+1;

   Make_tabelentry_attr;

   latex_tabpos:=0;
End;


Procedure Nop80;
Begin
   { Om dat het een 1-byte funktie is hoeft er niks overgeslagen }
   { te worden.                                                  }
End;



Procedure NopC0;
Begin
   If by=$C0 Then Jump_in_file(wpd,3);
   If by=$C1 Then Jump_in_file(wpd,8);
   If by=$C2 Then Jump_in_file(wpd,10);
   If by=$C3 Then Jump_in_file(wpd,2);
   If by=$C4 Then Jump_in_file(wpd,2);
   If by=$C5 Then Jump_in_file(wpd,4);
   If by=$C6 Then Jump_in_file(wpd,5);
   If by=$C7 Then Jump_in_file(wpd,6);
End;



Procedure NopD0(already_read_subfunc_code : Boolean);
Var
   b : Byte;
   w : Word;

Begin
   If Not already_read_subfunc_code
   Then Read(wpd,b);      { Lees subfunctioncode }

   Rd_word(wpd,w);       { Lees lengte 'die nog volgt ' }
   Seek(wpd,filepos(wpd)+w);
End;



Procedure Overstrike;

Var
   first_char_os    : Boolean;

   char_width_os,
   len_of_code      : Word;
   end_of_code      : LongInt;

Begin
   Rd_word(wpd,len_of_code);             { Lees lengte }
   end_of_code := filepos(wpd) + len_of_code - 4;

   Rd_word(wpd,char_width_os);

   first_char_os := True;

   While FilePos(wpd) < end_of_code
   Do Begin
         Read(wpd,by);

         Case by of
           $20..$7F,
           $A9,$C0  : If first_char_os
                      Then Begin
                              Character;
                              first_char_os := False;
                           End
                      Else Begin
                              Write(strip,'\llap{');
                              Character;
                              Write(strip,'}');
                           End;

           $00..$BF : Nop80;
           $C0..$CF : NopC0;
           $D0..$FE : NopD0(False);
         End;

      End;

   Jump_in_file(wpd,4);

End;



Procedure Footnote;
Var
   flags,
   num_of_pages     : Byte;

   fn_num,
   len_of_code      : Word;
   end_of_code      : LongInt;

Begin
   Rd_word(wpd,len_of_code);             { Lees lengte }
   end_of_code := filepos(wpd) + len_of_code - 4;

   Read(wpd,flags);

   Rd_word(wpd,fn_num);

{ Skip all the shit }

   Read(wpd,num_of_pages);
   Jump_in_file(wpd,2*(num_of_pages+1)+9);

   Close_all_attr;

   depth := 1;
   Reset_attr_rij(depth);

   Write(strip,'\footnote[',fn_num:1,']{');

   While FilePos(wpd) < end_of_code
   Do Begin
         Read(wpd,by);

         Case by of
           $20..$7F,
           $A9,$C0  : Character;

           $0A,$0C  : Write(strip,'\\ ');

           $0B,$0D  : Write(strip,' ');

            $C3     : Attr_ON;

            $C4     : Attr_OFF;

           $00..$BF : Nop80;
           $C0..$CF : NopC0;
           $D0..$FE : NopD0(False);
         End;

      End;

   Close_all_attr;      { Echt nodig ? }
   Write(strip,'}');

   Jump_in_file(wpd,4);

   depth := 0;
   Open_all_attr;

End;



Procedure Header_Footer;
Var
   subfunc,
   occurance : Byte;
   len_of_code : Word;
   end_of_code : LongInt;

   hf_left,
   hf_center,
   hf_right  : Boolean;

   j : Integer;

Begin
   Read(wpd,subfunc);
   Rd_word(wpd,len_of_code);

   If len_of_code > 22
   Then Begin
           end_of_code := FilePos(wpd) + len_of_code - 4;

           Jump_in_file(wpd,7);

           Read(wpd,occurance);

           Jump_in_file(wpd,10);

           Close_all_attr;
           depth := 1;

{ Geen schone attr._lei; Kopieer attributen uit Niveau 0;  Fout in WP 5.0 ? }

           For j:=0 to 15
           Do attr_rij[1,j] := attr_rij[0,j];

           leegptr[1]:=leegptr[0];
           openptr[1]:=openptr[0];

           Case subfunc of
             00,01 : Write(strip,'\headtext');
             02,03 : Write(strip,'\foottext');
           End;

           Case occurance of
             00 : Write(strip,'{\neverpages}{');
             01 : Write(strip,'{\allpages}{');
             02 : Write(strip,'{\oddpages}{');
             03 : Write(strip,'{\evenpages}{');
           End;

           Open_all_attr;
           hf_left   := True;           { Beginnen met de linkerkant }
           hf_center := False;
           hf_right  := False;

           While FilePos(wpd) < end_of_code
           Do Begin
                 Read(wpd,by);

                 Case by of
                   $20..$7F,
                   $A9,$C0  : Character;


                     $C1    : Begin
                                 Read(wpd,by);
                                 by := by and $E0;
                                 Jump_in_file(wpd,7);

                                 If by=$E0
                                 Then Begin
                                         If hf_left
                                         Then Begin
                                                 Close_all_attr;
                                                 Write(strip,'}{');
                                                 Open_all_attr;

                                                 hf_left   := False;
                                                 hf_center := True;
                                              End;
                                      End;

                                 If by=$60
                                 Then Begin
                                         If hf_left
                                         Then Begin
                                                 Close_all_attr;
                                                 Write(strip,'}{}{');
                                                 Open_all_attr;

                                                 hf_left  := False;
                                                 hf_right := True;
                                              End;

                                         If hf_center
                                         Then Begin
                                                 Close_all_attr;
                                                 Write(strip,'}{');
                                                 Open_all_attr;

                                                 hf_center := False;
                                                 hf_right  := True;
                                              End;
                                      End;
                              End;

                     $C3    : Attr_ON;

                     $C4    : Attr_OFF;

                   $00..$BF : Nop80;
                   $C0..$CF : NopC0;
                   $D0..$FE : NopD0(False);

                 End;
              End;

           Close_all_attr;      { Echt nodig ? }

           Jump_in_file(wpd,4);

           If hf_left   Then Write(strip,'}{}{}');
           If hf_center Then Write(strip,'}{}');
           If hf_right  Then Write(strip,'}');

           depth := 0;
           Open_all_attr;

        End

   Else Jump_in_file(wpd,len_of_code);

End;


Begin
   Table_Init;
   Ext_chr_init;

   Reset_attr_rij(0);
   Reset_attr_rij(1);
   depth := 0;

   WP_default;

   latex_tabpos:=0;
   right_tab := False;
   align_tab := False;
   center_tab := False;

   indenting:=False;
   indent_end:=False;
   ind_text1:=False;
   ind_text2:=False;
   ind_leftmargin:=0;
   ind_rightmargin:=0;

   envir:=' ';

   nomore_valid_tabs := False;

   Writeln('First strike :');
   Write('Converting-percentage :     ');

   srtdocpos:=filepos(wpd);
   fsize:=FileSize(wpd);

   regelnum := 0;

   Make_tabelentry_attr;           { attribuut instelling }

   Make_tabelentry_tabset;         { Geef de defaulttabinstelling door }
                                   { aan de 2e slag }

  

   While (FilePos(wpd)<fsize)
   Do Begin
        convperc:=round((FilePos(wpd)-srtdocpos)/(fsize-srtdocpos)*100);
        Write(chr(8),chr(8),chr(8),chr(8),convperc:3,'%');

        Read(wpd,by);

        Case by of
          $20..$7F,
          $A9,$C0  : Begin
                         char_on_line:=True;            {Er (al) is een karakter op deze regel }
                         If indenting                   {Als er is ingeprongen er na een stuk }
                         Then If ind_text1              {tekst is weer ingesprongen (ind_text1) }
                              Then ind_text2:=True;     {dan hoort dit char bij het ind_txt-blok }

                         Character;
                      End;

          $0A,$0D,
          $0B,$0C,
          $8C      : Return_Page;

          $C1      : Begin
                        Read(wpd,by);
                        by:=by and $E8;

                        Case by of
                          $00,$C8,
                          $48,$40     : Tab;
                          $60         : Flush_right_tab;
                          $E0         : Center;
                          Else          Jump_in_file(wpd,7);
                        End;
                     End;
          $81,$82  : Make_tabelentry_rightjustification;
          $83      : End_Align;
          $C3      : Attr_ON;
          $C4      : Attr_OFF;
          $C2      : Indent;
          $C6      : End_of_indent;
          $C5,$C7  : NopC0;

          $D0      : Begin
                        Read(wpd,by);
                        Case by of
                          $04 : Tabset;
                          $08 : Page_number_position;
                          Else  NopD0(True);
                        End;
                     End;

          $D5      : Header_Footer;

          $D6      : Begin
                        Read(wpd,by);
                        Case by of
                          $00 : Footnote;
                          Else NopD0(True);
                        End;
                     End;

          $D8      : Begin
                        Read(wpd,by);
                        Case by of
                          $02 : Overstrike;
                          Else NopD0(True);
                        End;
                     End;

          $00..$1F,
          $80..$BF : Nop80;

          $D0..$FF : NopD0(False);

        End;
      End;

   Writeln;
   Make_tabelentry_envir_extra_end;

   num_of_lines_stripfile := regelnum;

End;


{---SLAG2---}

Procedure Convert_second_strike;
Var
   regelnum : Word;
   convperc : Integer;

   underline,
   illegal_argument,
   just_envir_closed      : Boolean;

   i     : Integer;

   regel,
   hulp_regel            : String;
   len_reg               : Integer;

   num_of_tabs           : Integer;
   tabpos                : Array [1..40] of Word;

   tabent_num_of_tabs    : Array [0..2] of Integer;
   tabent_tabpos         : Array [0..2,1..40] of Word;

   ind_leftmargin,
   ind_rightmargin       : Array [0..2] of Word;
   ind_label             : Array [0..2] of Byte;

   pre,
   cur,
   next     : Integer;

   envir,
   line_term  : Array [0..2] of Char;
   new_tabset : Array [0..2] of Boolean;

   rightjust,
   new_rightjust         : Boolean;
   new_tabent_rightjust,
   tabent_rightjust      : Array [0..2] of Boolean;

   num_of_attr : Array[0..2] of Integer;
   attr_BOL    : Array[0..2,$00..$10] of Byte;
   attr_closed : Boolean;



Procedure Read_tabelentry(n:Integer);
Var
   w  : Word;
   b  : Byte;
   j  : Integer;

Begin
   { Begin met een schone lei die dan door deze procedure verder wordt }
   { opgevuld. }

   envir[n]:=' ';
   new_tabset[n]:=False;
   new_tabent_rightjust[n]:=False;

   num_of_attr[n] := 0;
   For j:=1 to 16
   Do attr_BOL[n,j]:=0;

   If filepos(tabel)<filesize(tabel)
   Then Begin

           Read(tabel,b);
           num_of_attr[n] := b;
           For j:=1 to num_of_attr[n]
           Do Read(tabel,Attr_BOL[n,j]);

           b:=$00;
           While b<>$FF
           Do Begin
                 Read(tabel,b);

                 Case chr(b) Of
                   'C' : envir[n]:='C';
                   'T' : envir[n]:='T';
                   'I' : Begin
                            envir[n]:='I';
                            Rd_word(tabel,ind_leftmargin[n]);
                            Rd_word(tabel,ind_rightmargin[n]);
                            Read(tabel,ind_label[n]);
                         End;

                   'S' : Begin
                            new_tabset[n]:=True;
                            Read(tabel,b);
                            tabent_num_of_tabs[n]:=b;

                            For j:=1 to tabent_num_of_tabs[n]
                            Do Begin
                                  Rd_word(tabel,w);
                                  tabent_tabpos[n,j]:=w;
                               End;
                         End;

                   'U' : Begin
                            new_tabent_rightjust[n]:=True;
                            Read(tabel,b);
                            If b=0
                            Then tabent_rightjust[n]:=False
                            Else tabent_rightjust[n]:=True;
                         End;

                   'R','r','P','p' : line_term[n]:=chr(b);

                End {Case};
              End;
        End

{ Er is geen volgende tabelentry dus ook geen volgende regel }
{ De tabelentry is 'schoon'.                                 }
{ Zodat het document 'schoon' wordt afgesloten.              }

End;



Procedure Open_all_attr_BOL;
{ -- Open alle commando's door de Attributen-rij af te lopen -- }
Var
   j:Integer;
Begin
   For j:=$01 to num_of_attr[cur]
   Do Write(latex,Open_com[attr_BOL[cur,j]]);

   attr_closed := False;
End;


Procedure Close_all_attr_BOL;
{ -- Sluit alle commando's door de Attributen-rij af te lopen -- }
Var
   j:Integer;
Begin
   For j:=num_of_attr[cur] Downto $01
   Do Write(latex,Close_com[Attr_BOL[cur,j]]);

   attr_closed := True;
End;



Procedure Open_all_attr_EOL;
{ -- Open alle commando's door de Attributen-rij af te lopen -- }
Var j:Integer;
Begin
  For j:=$01 to num_of_attr[next]
  Do Write(latex,Open_com[Attr_BOL[next,j]]);

  attr_closed := False;
End;



Procedure Close_all_attr_EOL;
{ -- Sluit alle commando's door de Attributen-rij af te lopen -- }
Var j:Integer;
Begin
  For j:=num_of_attr[next] Downto $01
  Do Write(latex,Close_com[Attr_BOL[next,j]]);

  attr_closed := True;
End;



Procedure Latex_head;
{ -- Maak het de standard-heading voor een latex-file aan -- }
Begin
  Writeln(latex,'\documentstyle[11pt,wp2latex]{report}');
  Writeln(latex,'\begin{document}')
End;



Procedure Latex_foot;
{ -- Sluit de latex-file op de juiste wijze af -- }
Begin
  Writeln(latex,'\end{document}')
End;



Procedure Latex_tabset;
Var
   atpr,j    : Integer;
   l,ol : Real;

Begin
   atpr:=0;                  { Huiding aantal tabs per regel }
   ol:=0;
   For j:=1 to num_of_tabs
   Do Begin
         l:=tabpos[j]/1200 * 2.54;
         Write(latex,'\hspace{', l-ol :3:2,'cm}\=');
         atpr:=atpr+1;
         If atpr>=4
         Then Begin
                 Writeln(latex,'%');
                 atpr:=0;
              End;
         ol:=l;
      End;
   Writeln(latex,'\kill');
End;



Function Change_envir_BOL : Boolean;
Var
   hulp : Boolean;

Begin
   hulp := False;

   hulp := ((envir[cur]='C') And Not (envir[pre]='C')) Or hulp;
   hulp := ((envir[cur]='T') And Not (envir[pre]='T')) Or hulp;
   hulp := ((envir[cur]='I') And Not (envir[pre]='I')) Or hulp;

   change_envir_BOL := hulp;
End;



Function Change_envir_EOL : Boolean;
Var
   hulp : Boolean;

Begin
   hulp := False;

   hulp := ((envir[next]='C') Xor (envir[cur]='C')) Or hulp;
   hulp := ((envir[next]='T') Xor (envir[cur]='T')) Or hulp;
   hulp := ((envir[next]='I') Xor (envir[cur]='I')) Or hulp;

   change_envir_EOL := hulp;
End;




Procedure Open_environment;

Begin
   If change_envir_BOL                 { andere environment ? }
   Then Begin
           If Not attr_closed
           Then Close_all_attr_BOL;

           Case envir[cur] of
              'C' : Begin
                       Writeln(latex,'\begin{center}');
                    End;

              'T' : IF TeX_Tabbing THEN Begin
                       Writeln(latex,'\begin{tabbing}');
                       Latex_tabset;
                    End;

              'I' : Begin
                       Write(latex,'\begin{indenting}');
                       Write(latex,'{',ind_leftmargin[cur]/1200*2.54:3:2,'cm}');
                       Write(latex,'{',ind_rightmargin[cur]/1200*2.54:3:2,'cm}');
                       If ind_label[cur]=1
                       Then Begin
                               Writeln(latex,'%');
                               Write(latex,'{');
                            End
                       Else Writeln(latex,'{}');
                    End
           End;

        End

   Else If new_tabset[cur] and (envir[cur]='T')
        Then Latex_tabset;

End;



Procedure Close_environment;

Begin

           Case envir[cur] of
              'C' : Begin
                       Writeln(latex,'\end{center}');
                    End;


                   'T' :
                    IF TeX_Tabbing THEN
                    Begin
                       Writeln(latex,'\end{tabbing}');
                    End;

              'I' : Begin
                       Writeln(latex,'\end{indenting}');
                    End;
           End;

           just_envir_closed := True;

End;



Procedure Update_global_information;
Var
   j : Integer;

Begin
   If new_tabset[cur]
   Then Begin
           num_of_tabs:=tabent_num_of_tabs[cur];
           For j:=1 to num_of_tabs
           Do tabpos[j]:=tabent_tabpos[cur,j]
        End;

   If new_tabent_rightjust[cur]
   Then new_rightjust := tabent_rightjust[cur];

End;


Procedure Change_tabelentry;
Var
   help : Integer;

Begin
   help:=pre;
   pre:=cur;
   cur:=next;
   next:=help;
   Read_tabelentry(next);
End;


Begin
   pre:=0;
   cur:=1;
   next:=2;

   envir[pre]:=' ';
   new_tabset[pre]:=False;

   just_envir_closed:=True;
   attr_closed := False;

   rightjust:=True;
   new_rightjust:=True;
   For i:=0 to 2
   Do Begin
         new_tabent_rightjust[i]:=False;
         tabent_rightjust[i]:=False;
      End;

   Read_tabelentry(cur);
   Read_tabelentry(next);

   regelnum:=1;

   Writeln;
   Writeln('Second strike :');
   Write('Converting-percentage :     ');

  

   Latex_head;

   While (Not Eof(strip)) and (not keypressed)
   Do Begin
         Update_global_information;

         convperc := round(100*regelnum/num_of_lines_stripfile);
         if convperc>100 then convperc:=100;
         Write(chr(8),chr(8),chr(8),chr(8),convperc:3,'%');

         Readln(strip,regel);

{ Werk eventueel de regel bij d.m.v. een hulp regel. }

         hulp_regel := regel;
         len_reg := length(hulp_regel);

{ Meerdere spaties achter elkaar vervangen door harde spaties. }

         For i:=1 to len_reg-1
         Do If (regel[i]=' ') and (regel[i+1]=' ')
            Then hulp_regel[i+1]:='~';

{ Zoek naar een illegaal argument en zet hier accolades voor. }

         If ((len_reg>=1) and (hulp_regel[1]='[')) or
            ((len_reg>=2) and (hulp_regel[1]=' ') and (hulp_regel[2]='['))
         Then hulp_regel:='{}' + hulp_regel;

{ De regel is verwerkt. }

         regel := hulp_regel;
         len_reg := length(regel);

         If new_rightjust xor rightjust
         Then Begin
                 rightjust := new_rightjust;
                 If rightjust
                 Then Writeln(latex,'\justified')
                 Else Writeln(latex,'\raggedright');
              End;

         Open_environment;

         If len_reg>0
         Then Begin
                 If attr_closed
                 Then Open_all_attr_BOL;

                 Write(latex,regel);

                 just_envir_closed := False;
              End;

         Case line_term[cur] of

          'r','p' : Begin
                       Writeln(latex);
                       If Change_envir_EOL
                       Then Begin
                               If Not attr_closed
                               Then Close_all_attr_EOL;

                               Close_environment;
                            End;
                    End;

              'R' : Begin

                       If envir[cur]='I'
                       Then Begin
                               If Not attr_closed
                               Then Close_all_attr_EOL;

                               Writeln(latex);
                               Close_environment;
                               envir[cur]:=' ';
                            End

                       Else Begin
                               underline:=False;
                               For i:=$01 to $10
                               Do underline := underline
                                               Or (Attr_Bol[next,i]=$B)
                                               Or (Attr_bol[next,i]=$E);

                               If underline and Not attr_closed
                               Then Close_all_attr_EOL;

                       { Elke Indent-environment moet na een harde Return}
                       { Afgesloten worden.}


                               If Change_envir_EOL
                               Then Begin
                                       If just_envir_closed
                                       Then Writeln(latex,'\nwln')
                                       Else Writeln(latex);

                                       If Not attr_closed
                                       Then Close_all_attr_EOL;

                                       Close_environment;
                                    End
                               Else Begin
                                       If just_envir_closed
                                       Then Writeln(latex,'\nwln')
                                       Else Writeln(latex,'\\');
                                     End;
                            End;
                    End;

              'P' : Begin
                       If Not attr_closed
                       Then Close_all_attr_EOL;

                       Writeln(latex);
                       Close_environment;
                       Writeln(latex,'\newpage');
                       envir[cur]:=' ';
                    End;

         End {Case};



         Change_tabelentry;

         regelnum:=regelnum+1;
      End;

   Latex_foot;
   Writeln;
End;


{---HOOFDPROG---}


Begin
   Exitsave:=Exitproc;                { Bewaar de orginele exit-pointer }
   Exitproc:=@Einde_prog;             { Spring bij Exit naar Proc. Einde_prog }

   Init_commando;

   ClrScr;
   Writeln;
   Writeln('     Conversionprogram : From Wordperfect 5.0 to LaTeX  (WP2latEX)');
   Writeln;
   Writeln('  (c) TUE-Eindhoven ---- Made by R.C.Houtepen ---- Date : 24 Jan 1990');

   Filenames;

   Reset(wpd);
   Wpd_check;

   Rewrite(strip);
   Rewrite(tabel);

   Writeln('Converting ...');
   Writeln;

   Convert_first_strike;

   Close(wpd);
   Close(strip);
   Close(tabel);

   Reset(strip);
   Reset(tabel);
   Rewrite(latex);

   Convert_second_strike;

   Close(strip);
   Close(tabel);
   Close(latex);

   Erase(strip);
   Erase(tabel);

End.

