#include "externs.h"

BOOLEAN F43_aopenin (f, pathspecifier)
/**********************************/
T23_alphafile * f;
int   pathspecifier;
{

  if (testaccess (4, pathspecifier))
  {
    RESET_1 ((*f), realnameoffile);
    return(TRUE);
  }
  else
    return(FALSE);
}

BOOLEAN F44_aopenout (f)
/*********************/
T23_alphafile * f;
{

  if (testaccess (2, 0))
  {
    REWRIT_1 ((*f), realnameoffile);
    return(TRUE);
  }
  else
    return(FALSE);
}


BOOLEAN F45_bopenin (f)
/********************/
T24_ubytefile * f;
{

  if (testaccess (4, 3))
  {
    RESET_3 ((*f), realnameoffile);
    return(TRUE);
  }
  else
    return(FALSE);
}

BOOLEAN F46_bopenout (f)
/*********************/
T24_bytefile * f;
{

  if (testaccess (2, 0))
  {
    REWRIT_2 ((*f), realnameoffile);
    return(TRUE);
  }
  else
    return(FALSE);
}

BOOLEAN F47_wopenin (f)
/********************/
T38_wordfile * f;
{

  if (testaccess (4, 4))
  {
#ifdef M_XENIX
    f->fp=open(realnameoffile,0);
    f->eof=(read((int)f->fp,&(f->buffer),sizeof(f->buffer))<sizeof(f->buffer));
#else
    RESET_3 ((*f), realnameoffile);
#endif
    return(TRUE);
  }
  else
    return(FALSE);
}

BOOLEAN F48_wopenout (f)
/*********************/
T38_wordfile * f;
{

  if (testaccess (2, 0))
  {
    REWRIT_2 ((*f), nameoffile);
    return(TRUE);
  }
  else
    return(FALSE);
}

BOOLEAN F52_inputln (fp)
/**********************/
register FILE *fp;
{
  register int c;
  register char
#ifdef M_XENIX
near
#endif
*cs;

  last = first;

  if ((c=getc(fp))==EOF)
    return(FALSE);
  else
  {
    cs = &buffer[first];
    if ((char)c!='\n')
    {
      do
	*cs++ = c;
      while (++last<=C3_bufsize && (c=getc(fp))!=EOF && c!='\n');
    }
    *cs=' ';
    if (last >= maxbufstack)
    {
      maxbufstack = last + 1;
      if (maxbufstack >= C3_bufsize)
	F41_overflow (128, (long)C3_bufsize);
    }
    return(TRUE);
  }
}

BOOLEAN F53_initterminal ()
/************************/
{
  char  arg[100];
  register int   i;
  register int   j;

  if (argc > 1)
  {
    last = first;
    for (i = 1; i < argc; i++)
    {
      strncpy(arg,argv[i],100); /* UNIX's way to get arguments */
      j = 0;
      while ((j < 100) && (arg[j] != '\0')) /* was blank, but pc3 wants 0 */
      {
	buffer[last++] = arg[j++];
      }
      if (j > 0)
      {
	buffer[last++] = ' '; /* for catenating arguments */
      }
    }
    buffer[--last]=' '; /* after input line */
    if (last > first)
    {
      curinput.locfield = first;
      return(TRUE);
    }
  }
  while (TRUE)
  {
    printf ("%s", "**");

    fflush(stdout);
    if (!F52_inputln(INPUT.fp))
    {
      printf ("\n%s", "! End of file on the terminal... why?");
      return(FALSE);
    }
    curinput.locfield = first;
    /* skip blanks at end of buffer */
    while ((curinput.locfield < last) && (buffer[curinput.locfield] == 32))
      curinput.locfield++;
    if (curinput.locfield < last)
    {
      return(TRUE);
    }
    printf ("\n%s", "Please type the name of your input file.");
  }
}

T26_strnumber F54_makestring ()
/****************************/
{
  if (strptr == C13_maxstrings)
    F41_overflow (130, (long)C13_maxstrings - initstrptr);
  strstart[++strptr] = poolptr;
  return(strptr - 1);
}

BOOLEAN F56_streqstr (s, t)
/***********************/
#ifdef VAX
register int s,t;
#else
register T26_strnumber s;
register T26_strnumber t;
#endif
{
  register long /* T25_poolpointer */ j;
  register long /* T25_poolpointer */ k;
  register long /* T25_poolpointer */ help;

  if ((strstart[s + 1] - strstart[s]) != (strstart[t + 1] - strstart[t]))
    return(FALSE);
  j = strstart[s];
  k = strstart[t];
  help = strstart[s + 1];
  while (j < help)
  {
    if (strpool[j] != strpool[k])
      return(FALSE);
    j++;
    k++;
  }
  return(TRUE);
}

# if defined(INITEX) || defined(TRIPTEX)
BOOLEAN F57_getstringsstarted ()
/*****************************/
{
  long int   a;
  BOOLEAN c;
  T26_strnumber g;
  int   k;
  int   l;
  char  m;
  char  n;

  poolptr = 0;
  strptr = 0;
  strstart[0] = 0;
  for (k = 64; k <= 95; k++)
  {
    strpool[poolptr++] = 94;
    strpool[poolptr++] = 94;
    strpool[poolptr++] = k;
    g = F54_makestring ();
  }
  for (k = 32; k <=126; k++)
  {
    strpool[poolptr++] = k;
    g = F54_makestring ();
  }
  strpool[poolptr++] = 94;
  strpool[poolptr++] = 94;
  strpool[poolptr++] = 63;
  g = F54_makestring ();
  strcpy (nameoffile, C20_poolname);
  if (F43_aopenin (&poolfile, 5))
  {
    c = FALSE;
    do
    {
      {
	if ((k=getc(poolfile.fp))==EOF)
	{
	  printf ("%s", "! tex.pool has no check sum.");
	  printf ("\n");
	  CLOSE_2(poolfile);
	  return(FALSE);
	}
	m=(char)k;
	n=(char)getc(poolfile.fp);
	if (m == '*')
	{
	  a = 0;
	  k = 1;
	  while (TRUE)
	  {
	    if ((n < 48) || (n > 57))
	    {
	      printf ("%s", "! tex.pool check sum doesn\'t have nine digits.");
	      printf ("\n");
	      CLOSE_2(poolfile);
	      return(FALSE);
	    }
	    a = ((10 * a) + n) - 48;
	    if (k == 9)
	      goto _30;
	    k++;
	    n=(char)getc(poolfile.fp);
	  }
      _30: 
	  if (a != 315565539)
	  {
	    printf ("%s", "! tex.pool doesn\'t match; tangle me again.");
	    printf ("\n");
	    CLOSE_2(poolfile);
	    return(FALSE);
	  }
	  c = TRUE;
	}
	else
	{
	  if ((((m < 48) || (m > 57)) || (n < 48)) || (n > 57))
	  {
	    printf ("%s", "! tex.pool line doesn\'t begin with two digits.");
	    printf ("\n");
	    CLOSE_2(poolfile);
	    return(FALSE);
	  }
	  l = ((m * 10) + n) - (48 * 11);
	  if (((poolptr + l) + C14_stringvacancies) > C15_poolsize)
	  {
	    printf ("%s", "! You have to increase POOLSIZE.");
	    printf ("\n");
	    CLOSE_2(poolfile);
	    return(FALSE);
	  }
	  m=32;
	  for (k = 1; k <= l; k++)
	  {
	    if (m!='\n');
	    {
	      m=(char)getc(poolfile.fp);
	    }
	    if (m!='\n')
	      strpool[poolptr++] = m;
	    else
	      strpool[poolptr++] = ' ';
	  }
	  if (m!='\n')
	  {
	    do;
	    while((k=getc(poolfile.fp))!=EOF && k!='\n');
	  }
	  g = F54_makestring ();
	}
      }
    }
    while (!(c));
    CLOSE_2(poolfile);
    return(TRUE);
  }
  else
  {
    printf ("%s", "! I can\'t read tex.pool.");
    printf ("\n");
    CLOSE_2(poolfile);
    return(FALSE);
  }
}
# endif

void F58_printtwo (n)
/*************/
register long int   n;
{
  n = (n>0L)?(n%100L):((-n)%100L);
  F16_printchar ((char)(48 + (n / 10)));
  F16_printchar ((char)(48 + (n % 10)));
}

void F59_printhex (n)
/*************/
register long int   n;
{
  register int   k;

  k = 0;
  F16_printchar ((char)34);
  do
  {
    dig[k] = n & 15;
    n >>= 4;
    k++;
  }
  while (n != 0L);
  F21_printthedigs ((T22_eightbits)k);
}

void F60_printascii (c)
/***************/
register int   c;
{
  if ((c >= 0) && (c <= 127))
    F17_print (c);
  else
  {
    F16_printchar ((char)91);
    if (c < 0)
      F22_printint ((long)c);
    else
      F59_printhex ((long)c);
    F16_printchar ((char)93);
  }
}

void F61_printromanint (n)
/******************/
register long int   n;
{
#ifdef VAX
register int j,k,u,v;
#else
  T25_poolpointer j;
  T25_poolpointer k;
  T28_nonnegativeinteger u;
  T28_nonnegativeinteger v;
#endif

  j = strstart[132];
  v = 1000;
  while (TRUE)
  {
    while (n >= (long)v)
    {
      F16_printchar (strpool[j]);
      n -= v;
    }
    if (n <= 0L)
      return;
    k = j + 2;
    u = v / (strpool[k - 1] - 48);
    if (strpool[k - 1] == 50)
    {
      k += 2;
      u /= (strpool[k - 1] - 48);
    }
    if ((n + u) >= v)
    {
      F16_printchar (strpool[k]);
      n += u;
    }
    else
    {
      j += 2;
      v /=  (strpool[j - 1] - 48);
    }
  }
}

void F62_printcurrentstring ()
/**********************/
{
#ifdef VAX
  register int j;
#else
  register T25_poolpointer j;
#endif

  j = strstart[strptr];
  while (j < poolptr)
    F16_printchar (strpool[j++]);
}

void F30_terminput ()
/*************/
{
  register int   k;

  fflush(stdout);
  if (!F52_inputln (INPUT.fp))
    F40_fatalerror (133);
  termoffset = 0;
  selector--;
  if (last != first)
    for (k = first; k < last; k++)
      F17_print ((int)buffer[k]);
  F15_println ();
  selector++;
}

void F63_interror (n)
/*************/
long int   n;
{
  F17_print (156);
  F22_printint (n);
  F16_printchar ((char)41);
  F39_error ();
}

void F28_normalizeselector ()
/*********************/
{
  if (jobname > 0)
    selector = 19;
  else
    selector = 17;
  if (jobname == 0)
    F33_openlogfile ();
  if (interaction == 0)
    selector--;
}

void F64_pauseforinstructions ()
/************************/
{
  if (oktointerrupt)
  {
    interaction=3;
    if ((selector == 18) || (selector == 16))
      selector++;
    F19_printnl (134);
    F17_print (166);
    helpptr = 3;
    helpline[2] = 167;
    helpline[1] = 168;
    helpline[0] = 169;
    deletionsallowed = FALSE;
    F39_error ();
    deletionsallowed = TRUE;
    interrupt = 0;
  }
}

#ifdef NOSHIFT
/* some stupid compilers do not provide arithmetic shifts (Unix version 9...) */
long int   F65_half(x)
/***************/
#ifdef VAX
register int x
#else
register long int x;
#endif
{
  if ODD(x)
    return((x+1)/2);
  else
    return(x/2);
}
#endif

long int   F66_rounddecimals (k)
/**********************/
#ifdef VAX
register int k;
#else
register T29_smallnumber k;
#endif
{
#ifdef VAX
  register int a;
#else
  register long int   a;
#endif

  a = 0;
  while (k > 0)
    a = (a + (dig[--k] * 131072)) / 10;
  return((a + 1) >> 1);
}

void F67_printscaled (s)
/****************/
register long int   s;
{
  register long int   delta;

  if (s < 0L)
  {
    F16_printchar ((char)45);
    s = -s;
  }
  F22_printint (s >> 16);
  F16_printchar ((char)46);
  s = (10 * (s & 65535L)) + 5;
  delta = 10;
  do
  {
    if (delta > 65536)
      s += 32768L - (delta >> 1);
    F16_printchar ((char)(48 + (s >> 16)));
    s = 10 * (s & 65535L);
    delta *= 10;
  }
  while (s > delta);
}

long int   F68_nxplusy (n, x, y)
/********************/
register long int   n;
register long int   x;
register long int   y;
{
  if (n < 0L)
  {
    x = -x;
    n = -n;
  }
  if (n == 0L)
    return(y);
  else
    if ((x <= ((1073741823 - y) / n)) && ((-x) <= ((1073741823 + y) / n)))
      return((n * x) + y);
    else
    {
      aritherror = TRUE;
      return(0L);
    }
}

long int   F70_xnoverd (x, n, d)
/********************/
register long int   x;
register long int   n;
register long int   d;
{
  BOOLEAN positive;
#ifdef VAX
register int t,u,v;
#else
  T28_nonnegativeinteger t;
  T28_nonnegativeinteger u;
  T28_nonnegativeinteger v;
#endif

  if (x >= 0)
    positive = TRUE;
  else
  {
    x = -x;
    positive = FALSE;
  }
  t = (x & 32767L) * n;
  u = ((x >> 15) * n) + (t >> 15);
  v = ((u % d) << 15) + (t & 32767L);
  if ((u / d) >= 32768L)
    aritherror = TRUE;
  else
    u = ((u / d) << 15) + (v / d);
  if (positive)
  {
    remainder = v % d;
    return(u);
  }
  else
  {
    remainder = -(v % d);
    return(-u);
  }
}

int /* was T32_halfword */ F71_badness (t, s)
/***************************/
register long int   t;
register long int   s;
{
  register long int   r;

  if (t == 0L)
    return(0);
  else
    if (s <= 0L)
      return(10000);
    else
    {
      if (t <= 7230584)
	r = (t * 297) / s;
      else
	if (s >= 1663497)
	  r = t / (s / 297);
	else
	  r = t;
      if (r > 1290)
	return(10000);
      else
      {
#ifdef NOSHIFT
	return((int)((long)(((r * r) * r) + 131072) / 262144));
#else
	return((int)((long)(((r * r) * r) + 131072) >> 18));
#endif
      }
    }
}

# if defined(INITEX) || defined(TRIPTEX)
void F72_printword (w)
/**************/
register T37_memoryword w;
{
  F22_printint (w._TAG._TAG1._int);
  F16_printchar ((char)32);
  F67_printscaled (w._TAG._TAG1._int);
  F16_printchar ((char)32);
  F67_printscaled ((long int)ROUND(65536.0 * w._TAG._TAG2.gr));
  F15_println ();
  F22_printint ((long)w._TAG._TAG3.hh._TAG._TAG1.lh);
  F16_printchar ((char)61);
  F22_printint ((long)w._TAG._TAG3.hh._TAG._TAG2.b0);
  F16_printchar ((char)58);
  F22_printint ((long)w._TAG._TAG3.hh._TAG._TAG2.b1);
  F16_printchar ((char)59);
  F22_printint ((long)w._TAG._TAG3.hh.rh);
  F16_printchar ((char)32);
  F22_printint ((long)w._TAG._TAG4.qqqq.b0);
  F16_printchar ((char)58);
  F22_printint ((long)w._TAG._TAG4.qqqq.b1);
  F16_printchar ((char)58);
  F22_printint ((long)w._TAG._TAG4.qqqq.b2);
  F16_printchar ((char)58);
  F22_printint ((long)w._TAG._TAG4.qqqq.b3);
}
# endif

void F73_showtokenlist (p, q, l)
/**********************/
register int   p;
int   q;
long int   l;
{
  register int   c;
  register int   m;
#ifdef VAX
register int matchchr,n;
#else
  T21_asciicode matchchr;
  T21_asciicode n;
#endif
  register int shelp;

  matchchr = 35;
  n = 48;
  tally = 0;
  while ((p != ((int)(-32768))) && (tally < l))
  {
    if (p == q)
    {
      firstcount = tally;
      trickcount = ((tally + 1) + C4_errorline) - C5_halferrorline;
      if (trickcount < (long)C4_errorline)
	trickcount = C4_errorline;
    }
    if ((p < himemmin) || (p > memend))
    {
      F20_printesc (179);
      return;
    }
    shelp = mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh;
    if (shelp >= 4096)
      F23_printcs (shelp - 4096);
    else
    {
      m = shelp >> 8;
      c = shelp & 255;
      if ((shelp < 0) || (c > 127))
	F20_printesc (414);
      else
	switch (m)
	{
	  case 1: 
	  case 2: 
	  case 3: 
	  case 4: 
	  case 7: 
	  case 8: 
	  case 10: 
	  case 11: 
	  case 12: 
	    F17_print (c);
	    break;
	  case 6: 
	    F17_print (c);
	    F17_print (c);
	    break;
	  case 5: 
	    F17_print ((int)matchchr);
	    if (c <= 9)
	      F16_printchar ((char)(c + 48));
	    else
	    {
	      F16_printchar ((char)33);
	      return;
	    }
	    break;
	  case 13: 
	    matchchr = c;
	    F17_print (c);
	    n++;
	    F16_printchar ((char)n);
	    if (n > 57)
	      return;
	    break;
	  case 14: 
	    F17_print (415);
	    break;
	  default: 
	    F20_printesc (414);
	    break;
	}
    }
    p = mem[p - C2_memmin]._TAG._TAG3.hh.rh;
  }
  if (p != ((int)(-32768)))
    F20_printesc (413);
}

void F74_runaway ()
/***********/
{
  register int /* was T32_halfword */ p;

  if (scannerstatus > 1)
  {
    F19_printnl (428);
    switch (scannerstatus)
    {
      case 2: 
	F17_print (429);
	p = defref;
	break;
      case 3: 
	F17_print (430);
#ifdef TRIPTEX
	p = 2997;
#else
	p = 29997;
#endif
	break;
      case 4: 
	F17_print (431);
#ifdef TRIPTEX
	p = 2996;
#else
	p = 29996;
#endif
	break;
      case 5: 
	F17_print (432);
	p = defref;
	break;
    }
    F16_printchar ((char)63);
    F15_println ();
    F73_showtokenlist (mem[p - C2_memmin]._TAG._TAG3.hh.rh, (int)(-32768), (long)C4_errorline - 10);
  }
}

int /* was T32_halfword */ F75_getavail ()
/*************************/
{
  register int /* was T32_halfword */ p;

  p = avail;
  if (p != -32768)
    avail = mem[avail - C2_memmin]._TAG._TAG3.hh.rh;
  else
    if (memend < (int)C1_memmax)
      p = ++memend;
    else
    {
      p = --himemmin;
      if (himemmin <= lomemmax)
      {
	F74_runaway ();
	F41_overflow (170, (long)(C1_memmax + 1 - C2_memmin));
      }
    }
  mem[p - C2_memmin]._TAG._TAG3.hh.rh = -32768;
#if defined(INITEX) || defined(TRIPTEX)
  dynused++;
# endif
  return(p);
}

void F76_flushlist (p)
/**************/
register int /* was T32_halfword */ p;
{
  register int /* was T32_halfword */ r;
  register int /* was T32_halfword */ q;

  if (p != -32768)
  {
    r = p;
    do
    {
      q = r;
      r = mem[r - C2_memmin]._TAG._TAG3.hh.rh;
# if defined(INITEX) || defined(TRIPTEX)
      dynused--;
# endif
    }
    while (r != -32768);
    mem[q - C2_memmin]._TAG._TAG3.hh.rh = avail;
    avail = p;
  }
}

int /* was T32_halfword */ F77_getnode (s)
/*************************/
register long int   s;
{
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  T37_memoryword *memptr;
#endif
  register int /* was T32_halfword */ p;
  register int /* was T32_halfword */ q;
  register long int   r;
  register long int   t;
  register int shelp;
  T37_memoryword memhelp;

_20: 
  p = rover;
  do
  {
    q = p + mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh;
    while (mem[q - C2_memmin]._TAG._TAG3.hh.rh == 32767)
    {
      memhelp = mem[q + 1 - C2_memmin];
      t = memhelp._TAG._TAG3.hh.rh;
      if (q == rover)
	rover = t;
      mem[t + 1 - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh = memhelp._TAG._TAG3.hh._TAG._TAG1.lh;
      mem[memhelp._TAG._TAG3.hh._TAG._TAG1.lh + 1 - C2_memmin]._TAG._TAG3.hh.rh = t;
      q += mem[q - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh;
    }
    r = q - s;
    if (r > (p + 1))
    {
      mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh = r - p;
      rover = p;
      goto _40;
    }
    if (r == p)
    {
      memhelp = mem[p + 1 - C2_memmin];
      if ((memhelp._TAG._TAG3.hh.rh != rover) || (memhelp._TAG._TAG3.hh._TAG._TAG1.lh != rover))
      {
	rover = memhelp._TAG._TAG3.hh.rh;
	t = memhelp._TAG._TAG3.hh._TAG._TAG1.lh;
	mem[rover + 1 - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh = t;
	mem[t + 1 - C2_memmin]._TAG._TAG3.hh.rh = rover;
	goto _40;
      }
    }
    memptr = &mem[p - C2_memmin];
    memptr->_TAG._TAG3.hh._TAG._TAG1.lh = q - p;
    p = (memptr+1)->_TAG._TAG3.hh.rh;
  }
  while (p != rover);
  if (s == 1073741824)
    return(32767);
  if (lomemmax + 2 < himemmin)
# ifdef TRIPTEX
    if (((long)lomemmax + 2) <= 32768L)
# else
    if (lomemmax + 2 <= 2767)
# endif
    {
      if ((lomemmax + 1000) < himemmin)
	t = lomemmax + 1000;
      else
	t = (long)(((long)lomemmax + himemmin) + 2) >> 1;
      memptr = &mem[rover + 1 - C2_memmin];
      p = memptr->_TAG._TAG3.hh._TAG._TAG1.lh;
      q = lomemmax;
      mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh = q;
      memptr->_TAG._TAG3.hh._TAG._TAG1.lh = q;
# ifdef TRIPTEX
      if ((long)t > 32768L)
	t = 32768;
# else
      if (t > 2767)
	t = 2767;
# endif
      memptr = &mem[q - C2_memmin];
      (memptr+1)->_TAG._TAG3.hh.rh = rover;
      (memptr+1)->_TAG._TAG3.hh._TAG._TAG1.lh = p;
      memptr->_TAG._TAG3.hh.rh = 32767;
      memptr->_TAG._TAG3.hh._TAG._TAG1.lh = t - lomemmax;
      lomemmax = t;
      memhelp._TAG._TAG3.hh.rh = -32768;
      memhelp._TAG._TAG3.hh._TAG._TAG1.lh = -32768;
      mem[lomemmax - C2_memmin] = memhelp;
      rover = q;
      goto _20;
    }
   F41_overflow (170, (long)(C1_memmax + 1) - C2_memmin);
_40: 
  mem[r - C2_memmin]._TAG._TAG3.hh.rh = -32768;
# if defined(INITEX) || defined(TRIPTEX)
  varused+=s;
# endif
  return(r);
}

void F78_freenode (p, s)
/***************/
register int /* was T32_halfword */ p;
int /* was T32_halfword */ s;
{
  register int /* was T32_halfword */ q;
#ifdef M_XENIX
  T37_memoryword huge *memptr, huge *memptr1;
#else
  T37_memoryword *memptr,*memptr1;
#endif

  memptr= &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG1.lh = s;
  memptr->_TAG._TAG3.hh.rh = 32767;
  memptr1= &mem[rover + 1 - C2_memmin];
  q = memptr1->_TAG._TAG3.hh._TAG._TAG1.lh;
  (memptr+1)->_TAG._TAG3.hh._TAG._TAG1.lh = q;
  (memptr+1)->_TAG._TAG3.hh.rh = rover;
  memptr1->_TAG._TAG3.hh._TAG._TAG1.lh = p;
  mem[q + 1 - C2_memmin]._TAG._TAG3.hh.rh = p;
# if defined(INITEX) || defined(TRIPTEX)
  varused -= s;
# endif
}

# if defined(INITEX) || defined(TRIPTEX)
void F79_sortavail ()
/*************/
{
#ifdef M_XENIX
  T37_memoryword huge *memptr, huge *memptr1;
#else
  T37_memoryword *memptr,*memptr1;
#endif
  int /* was T32_halfword */ oldrover;
  int /* was T32_halfword */ p;
  int /* was T32_halfword */ q;
  int /* was T32_halfword */ r;
  int shelp;

  p = F77_getnode (1073741824);
  memptr = &mem[rover + 1 - C2_memmin];
  p = memptr->_TAG._TAG3.hh.rh;
  memptr->_TAG._TAG3.hh.rh = 32767;
  oldrover = rover;
  while (p != oldrover)
    if (p < rover)
    {
      q = p;
      memptr = &mem[q + 1 - C2_memmin];
      p = memptr->_TAG._TAG3.hh.rh;
      memptr->_TAG._TAG3.hh.rh = rover;
      rover = q;
    }
    else
    {
      q = rover;
      while ((shelp=mem[q + 1 - C2_memmin]._TAG._TAG3.hh.rh) < p)
	q = shelp;
      memptr1 = &mem[q + 1 - C2_memmin];
      memptr = &mem[p + 1 - C2_memmin];
      r = memptr->_TAG._TAG3.hh.rh;
      memptr->_TAG._TAG3.hh.rh = memptr1->_TAG._TAG3.hh.rh;
      memptr1->_TAG._TAG3.hh.rh = p;
      p = r;
    }
  p = rover;
  while ((shelp=mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh) != 32767)
  {
    mem[shelp + 1 - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh = p;
    p = mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh;
  }
  mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh = rover;
  mem[rover + 1 - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh = p;
}
# endif

int /* was T32_halfword */ F80_newnullbox ()
/***************************/
{
  register int /* was T32_halfword */ p;
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  register T37_memoryword *memptr;
#endif

  p = F77_getnode (7L);
  memptr = &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG2.b0 = 0;
  memptr->_TAG._TAG3.hh._TAG._TAG2.b1 = -128;
  (memptr+1)->_TAG._TAG1._int = (memptr+2)->_TAG._TAG1._int = (memptr+3)->_TAG._TAG1._int = (memptr+4)->_TAG._TAG1._int = 0;
  (memptr+5)->_TAG._TAG3.hh.rh = (int)(-32768);
  (memptr+5)->_TAG._TAG3.hh._TAG._TAG2.b0 = (memptr+5)->_TAG._TAG3.hh._TAG._TAG2.b1 = 0;
#ifdef M_XENIX
  (memptr+6)->_TAG._TAG1._int = 0;
#else
  (memptr+6)->_TAG._TAG2.gr = (float)0.0;
#endif
  return(p);
}

int /* was T32_halfword */ F81_newrule ()
/************************/
{
  register int /* was T32_halfword */ p;
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  register T37_memoryword *memptr;
#endif

  p = F77_getnode (4L);
  memptr= &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG2.b0 = 2;
  memptr->_TAG._TAG3.hh._TAG._TAG2.b1 = 0;
  (memptr+1)->_TAG._TAG1._int = (memptr+2)->_TAG._TAG1._int = (memptr+3)->_TAG._TAG1._int = -1073741824;
  return(p);
}

int /* was T32_halfword */ F82_newligature (f, c, q)
/*********************************/
T31_quarterword f;
T31_quarterword c;
int /* was T32_halfword */ q;
{
  register int /* was T32_halfword */ p;
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  register T37_memoryword *memptr;
#endif

  p = F77_getnode (2L);
  memptr = &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG2.b0 = 6;
  memptr->_TAG._TAG3.hh._TAG._TAG2.b1 = 0;
  (memptr+1)->_TAG._TAG3.hh._TAG._TAG2.b0 = f;
  (memptr+1)->_TAG._TAG3.hh._TAG._TAG2.b1 = c;
  (memptr+1)->_TAG._TAG3.hh.rh = q;
  return(p);
}

int /* was T32_halfword */ F83_newdisc ()
/************************/
{
  register int /* was T32_halfword */ p;
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  register T37_memoryword *memptr;
#endif

  p = F77_getnode (2L);
  memptr = &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG2.b0 = 7;
  memptr->_TAG._TAG3.hh._TAG._TAG2.b1 = 0;
  (memptr+1)->_TAG._TAG3.hh._TAG._TAG1.lh = (int)(-32768);
  (memptr+1)->_TAG._TAG3.hh.rh = (int)(-32768);
  return(p);
}

int /* was T32_halfword */ F84_newmath (w, s)
/***************************/
long int   w;
T29_smallnumber s;
{
  register int /* was T32_halfword */ p;
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  register T37_memoryword *memptr;
#endif

  p = F77_getnode (2L);
  memptr = &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG2.b0 = 9;
  memptr->_TAG._TAG3.hh._TAG._TAG2.b1 = s;
  (memptr+1)->_TAG._TAG1._int = w;
  return(p);
}

int /* was T32_halfword */ F85_newspec (p)
/*************************/
register int /* was T32_halfword */ p;
{
  register int /* was T32_halfword */ q;
#ifdef M_XENIX
  T37_memoryword huge *memptr, huge *memptr1;
#else
  register T37_memoryword *memptr,*memptr1;
#endif

  q = F77_getnode (4L);
  memptr = &mem[p - C2_memmin];
  memptr1 = &mem[q - C2_memmin];
  *memptr1 = *memptr;
  memptr1->_TAG._TAG3.hh.rh = (int)(-32768);
  (memptr1+1)->_TAG._TAG1._int = (memptr+1)->_TAG._TAG1._int;
  (memptr1+2)->_TAG._TAG1._int = (memptr+2)->_TAG._TAG1._int;
  (memptr1+3)->_TAG._TAG1._int = (memptr+3)->_TAG._TAG1._int;
  return(q);
}

int /* was T32_halfword */ F86_newparamglue (n)
/******************************/
T29_smallnumber n;
{
  register int /* was T32_halfword */ p;
  register int /* was T32_halfword */ q;
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  register T37_memoryword *memptr;
#endif

  p = F77_getnode (2L);
  memptr = &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG2.b0 = 10;
  memptr->_TAG._TAG3.hh._TAG._TAG2.b1 = n + 1;
  q = eqtb[3526 + n]._TAG._TAG3.hh.rh;
  (memptr+1)->_TAG._TAG3.hh.rh = (int)(-32768);
  (memptr+1)->_TAG._TAG3.hh._TAG._TAG1.lh = q;
  mem[q - C2_memmin]._TAG._TAG3.hh.rh++;
  return(p);
}

int /* was T32_halfword */ F87_newglue (q)
/*************************/
int /* was T32_halfword */ q;
{
  register int /* was T32_halfword */ p;
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  register T37_memoryword *memptr;
#endif

  p = F77_getnode (2L);
  memptr = &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG2.b0 = 10;
  memptr->_TAG._TAG3.hh._TAG._TAG2.b1 = 0;
  (memptr+1)->_TAG._TAG3.hh.rh = (int)(-32768);
  (memptr+1)->_TAG._TAG3.hh._TAG._TAG1.lh = q;
  mem[q - C2_memmin]._TAG._TAG3.hh.rh++;
  return(p);
}

int /* was T32_halfword */ F88_newskipparam (n)
/******************************/
T29_smallnumber n;
{
  register int /* was T32_halfword */ p;

  tempptr = F85_newspec (eqtb[3526 + n]._TAG._TAG3.hh.rh);
  p = F87_newglue (tempptr);
  mem[tempptr - C2_memmin]._TAG._TAG3.hh.rh = (int)(-32768);
  mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG2.b1 = n + 1;
  return(p);
}

int /* was T32_halfword */ F89_newkern (w)
/*************************/
long int   w;
{
  register int /* was T32_halfword */ p;
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  register T37_memoryword *memptr;
#endif

  p = F77_getnode (2L);
  memptr = &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG2.b0 = 11;
  memptr->_TAG._TAG3.hh._TAG._TAG2.b1 = 0;
  (memptr+1)->_TAG._TAG1._int = w;
  return(p);
}

int /* was T32_halfword */ F90_newpenalty (m)
/****************************/
long int   m;
{
  register int /* was T32_halfword */ p;
#ifdef M_XENIX
  T37_memoryword huge *memptr;
#else
  register T37_memoryword *memptr;
#endif

  p = F77_getnode (2L);
  memptr = &mem[p - C2_memmin];
  memptr->_TAG._TAG3.hh._TAG._TAG2.b0 = 12;
  memptr->_TAG._TAG3.hh._TAG._TAG2.b1 = 0;
  (memptr+1)->_TAG._TAG1._int = m;
  return(p);
}

# if defined(INITEX) || defined(TRIPTEX)
void F91_checkmem (printlocs)
/*********************/
BOOLEAN printlocs;
{
  register BOOLEAN clobbered;
  register int /* was T32_halfword */ p;
  register int /* was T32_halfword */ q;
  register int help;

  for (p = C2_memmin; p <= lomemmax; p++)
    freearr[p - C2_memmin] = FALSE;
  for (p = himemmin; p <= memend; p++)
    freearr[p - C2_memmin] = FALSE;
  p = avail;
  q = (int)(-32768);
  clobbered = FALSE;
  while (p != ((int)(-32768)))
  {
    if ((p > memend) || (p < himemmin))
      clobbered = TRUE;
    else
      if (freearr[p - C2_memmin])
	clobbered = TRUE;
    if (clobbered)
    {
      F19_printnl (171);
      F22_printint ((long)q);
      goto _31;
    }
    freearr[p - C2_memmin] = TRUE;
    q = p;
    p = mem[q - C2_memmin]._TAG._TAG3.hh.rh;
  }
_31: 
  p = rover;
  q = (int)(-32768);
  clobbered = FALSE;
  do
  {
    if ((p >= lomemmax) || (p < C2_memmin))
      clobbered = TRUE;
    else
      if ((mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh >= lomemmax) || (mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh < C2_memmin))
	clobbered = TRUE;
      else
	if ((((mem[p - C2_memmin]._TAG._TAG3.hh.rh != 32767) || (mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh < 2))
	  || ((p + mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh) > lomemmax)) ||
	  (mem[mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh + 1 - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh != p))
	  clobbered = TRUE;
    if (clobbered)
    {
      F19_printnl (172);
      F22_printint ((long)q);
      goto _32;
    }
    help = p + mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh;
    for (q = p; q < help; q++)
    {
      if (freearr[q - C2_memmin])
      {
	F19_printnl (173);
	F22_printint ((long)q);
	goto _32;
      }
      freearr[q - C2_memmin] = TRUE;
    }
    q = p;
    p = mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh;
  }
  while (p != rover);
_32: 
  p = C2_memmin;
  while (p <= lomemmax)
  {
    if (mem[p - C2_memmin]._TAG._TAG3.hh.rh == 32767)
    {
      F19_printnl (174);
      F22_printint ((long)p);
    }
    while ((p <= lomemmax) && (!freearr[p - C2_memmin]))
      p++;
    while ((p <= lomemmax) && freearr[p - C2_memmin])
      p++;
  }
  if (printlocs)
  {
    F19_printnl (175);
    for (p = C2_memmin; p <= lomemmax; p++)
      if ((!freearr[p - C2_memmin]) && ((p > waslomax) || wasfree[p - C2_memmin]))
      {
	F16_printchar ((char)32);
	F22_printint ((long)p);
      }
    for (p = himemmin; p <= memend; p++)
      if ((!freearr[p - C2_memmin]) && (((p < washimin) || (p > wasmemend)) || wasfree[p - C2_memmin]))
      {
	F16_printchar ((char)32);
	F22_printint ((long)p);
      }
  }
  for (p = C2_memmin; p <= lomemmax; p++)
    wasfree[p - C2_memmin] = freearr[p - C2_memmin];
  for (p = himemmin; p <= memend; p++)
    wasfree[p - C2_memmin] = freearr[p - C2_memmin];
  wasmemend = memend;
  waslomax = lomemmax;
  washimin = himemmin;
}
# endif

# if defined(INITEX) || defined(TRIPTEX)
void F92_searchmem (p)
/**************/
register int /* was T32_halfword */ p;
{
  register int   q;

  for (q = C2_memmin; q <= lomemmax; q++)
  {
    if (mem[q - C2_memmin]._TAG._TAG3.hh.rh == p)
    {
      F19_printnl (176);
      F22_printint ((long)q);
      F16_printchar ((char)41);
    }
    if (mem[q - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh == p)
    {
      F19_printnl (177);
      F22_printint ((long)q);
      F16_printchar ((char)41);
    }
  }
  for (q = himemmin; q <= memend; q++)
  {
    if (mem[q - C2_memmin]._TAG._TAG3.hh.rh == p)
    {
      F19_printnl (176);
      F22_printint ((long)q);
      F16_printchar ((char)41);
    }
    if (mem[q - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh == p)
    {
      F19_printnl (177);
      F22_printint ((long)q);
      F16_printchar ((char)41);
    }
  }
  for (q = 1; q <= 4577; q++)
  {
    if (eqtb[q]._TAG._TAG3.hh.rh == p)
    {
      F19_printnl (361);
      F22_printint ((long)q);
      F16_printchar ((char)41);
    }
  }
  if (saveptr > 0)
    for (q = 0; q < saveptr; q++)
    {
      if (savestack[q]._TAG._TAG3.hh.rh == p)
      {
	F19_printnl (405);
	F22_printint ((long)q);
	F16_printchar ((char)41);
      }
    }
  for (q = 0; q <= 307; q++)
  {
    if (hyphlist[q] == p)
    {
      F19_printnl (792);
      F22_printint ((long)q);
      F16_printchar ((char)41);
    }
  }
}
# endif

void F93_shortdisplay (p)
/*****************/
register int   p;
{
  register int   n;
  register T37_memoryword memhelp;

  while (p > ((int)(-32768)))
  {
    memhelp = mem[p - C2_memmin];
    if (p >= himemmin)
    {
      if (p <= memend)
      {
	if (memhelp._TAG._TAG3.hh._TAG._TAG2.b0 != fontinshortdisplay)
	{
	  if ((memhelp._TAG._TAG3.hh._TAG._TAG2.b0 < 0) || (memhelp._TAG._TAG3.hh._TAG._TAG2.b0 > C9_fontmax))
	    F16_printchar ((char)42);
	  else
	    F20_printesc (hash[3010 + memhelp._TAG._TAG3.hh._TAG._TAG2.b0].rh);
	  F16_printchar ((char)32);
	  fontinshortdisplay = memhelp._TAG._TAG3.hh._TAG._TAG2.b0;
	}
	F60_printascii (memhelp._TAG._TAG3.hh._TAG._TAG2.b1 + 128);
      }
    }
    else
      switch (memhelp._TAG._TAG3.hh._TAG._TAG2.b0)
      {
	case 0: 
	case 1: 
	case 3: 
	case 4: 
	case 5: 
	case 8: 
	case 13: 
	  F17_print (178);
	  break;
	case 2: 
	  F16_printchar ((char)124);
	  break;
	case 10: 
# ifdef TRIPTEX
	  if (mem[p + 1 - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh != 1)
# else
	  if (mem[p + 1 - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh != (-30000))
# endif
	    F16_printchar ((char)32);
	  break;
	case 9: 
	  F16_printchar ((char)36);
	  break;
	case 6: 
	  F93_shortdisplay (mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh);
	  break;
	case 7: 
	  F93_shortdisplay (mem[p + 1 - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh);
	  F93_shortdisplay (mem[p + 1 - C2_memmin]._TAG._TAG3.hh.rh);
	  n = memhelp._TAG._TAG3.hh._TAG._TAG2.b1;
	  while (n > 0)
	  {
	    register int shelp;
	    if ((shelp=mem[p - C2_memmin]._TAG._TAG3.hh.rh) != ((int)(-32768)))
	      p = shelp;
	    n--;
	  }
	  break;
	default: 
	  break;
      }
    p = mem[p - C2_memmin]._TAG._TAG3.hh.rh;
  }
}

void F94_printfontandchar (p)
/*********************/
register int   p;
{
  register T37_memoryword memhelp;
  if (p > memend)
    F20_printesc (179);
  else
  {
    memhelp = mem[p - C2_memmin];
    if ((memhelp._TAG._TAG3.hh._TAG._TAG2.b0 < 0) || (memhelp._TAG._TAG3.hh._TAG._TAG2.b0 > C9_fontmax))
      F16_printchar ((char)42);
    else
      F20_printesc (hash[3010 + memhelp._TAG._TAG3.hh._TAG._TAG2.b0].rh);
    F16_printchar ((char)32);
    F60_printascii (memhelp._TAG._TAG3.hh._TAG._TAG2.b1 + 128);
  }
}

void F95_printmark (p)
/**************/
register long int   p;
{
  F16_printchar ((char)123);
  if ((p < himemmin) || (p > memend))
    F20_printesc (179);
  else
  {
    F73_showtokenlist (mem[p - C2_memmin]._TAG._TAG3.hh.rh, (int)(-32768), (long)(C6_maxprintline - 10));
  }
  F16_printchar ((char)125);
}

void F96_printruledimen (d)
/*******************/
long int   d;
{
  if (d == (-1073741824))
    F16_printchar ((char)42);
  else
    F67_printscaled (d);
}

void F97_printglue (d, order, s)
/**********************/
long int   d;
#ifdef VAX
register int order;
#else
T31_quarterword   order;
#endif
T26_strnumber s;
{
  F67_printscaled (d);
  if ((order < 0) || (order > 3))
    F17_print (180);
  else
    if (order > 0)
    {
      F17_print (181);
      while (order > 1)
      {
	F16_printchar ((char)108);
	order--;
      }
    }
    else
      if (s != 0)
	F17_print (s);
}

void F98_printspec (p, s)
/****************/
register long int   p;
#ifdef VAX
register int s;
#else
T26_strnumber s;
#endif
{
  if ((p < C2_memmin) || (p >= lomemmax))
    F16_printchar ((char)42);
  else
  {
    F67_printscaled (mem[p + 1 - C2_memmin]._TAG._TAG1._int);
    if (s != 0)
      F17_print (s);
    if (mem[p + 2 - C2_memmin]._TAG._TAG1._int != 0)
    {
      F17_print (182);
      F97_printglue (mem[p + 2 - C2_memmin]._TAG._TAG1._int, mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG2.b0, s);
    }
    if (mem[p + 3 - C2_memmin]._TAG._TAG1._int != 0)
    {
      F17_print (183);
      F97_printglue (mem[p + 3 - C2_memmin]._TAG._TAG1._int, mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG2.b1, s);
    }
  }
}

void F99_printfamandchar (p)
/********************/
int /* was T32_halfword */ p;
{
  F20_printesc (330);
  F22_printint ((long)mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG2.b0);
  F16_printchar ((char)32);
  F60_printascii (mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG2.b1 + 128);
}

void F100_printdelimiter (p)
/********************/
register int /* was T32_halfword */ p;
{
  register long int   a;
  register T37_memoryword memhelp;

  memhelp = mem[p - C2_memmin];
  a = ((memhelp._TAG._TAG4.qqqq.b0 << 8) + memhelp._TAG._TAG4.qqqq.b1) + 128;
  a = (((a << 12) + (memhelp._TAG._TAG4.qqqq.b2 << 8)) + memhelp._TAG._TAG4.qqqq.b3) + 128;
  if (a < 0)
    F22_printint (a);
  else
    F59_printhex (a);
}

void F102_printsubsidiarydata (p, c)
/***************************/
register int /* was T32_halfword */ p;
T21_asciicode c;
{
  if ((poolptr - strstart[strptr]) >= depththreshold)
  {
    if (mem[p - C2_memmin]._TAG._TAG3.hh.rh != 0)
      F17_print (184);
  }
  else
  {
    strpool[poolptr++] = c;
    tempptr = p;
    switch (mem[p - C2_memmin]._TAG._TAG3.hh.rh)
    {
      case 1: 
	F15_println ();
	F62_printcurrentstring ();
	F99_printfamandchar (p);
	break;
      case 2: 
	F105_shownodelist (mem[tempptr - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh);
	break;
      case 3: 
	if (mem[p - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh == ((int)(-32768)))
	{
	  F15_println ();
	  F62_printcurrentstring ();
	  F17_print (713);
	}
	else
	  F105_shownodelist (mem[tempptr - C2_memmin]._TAG._TAG3.hh._TAG._TAG1.lh);
	break;
      default: 
	break;
    }
    poolptr--;
  }
}

void F103_printstyle (c)
/****************/
int   c;
{
  switch (c >> 1)
  {
    case 0: 
      F20_printesc (714);
      break;
    case 1: 
      F20_printesc (715);
      break;
    case 2: 
      F20_printesc (716);
      break;
    case 3: 
      F20_printesc (717);
      break;
    default: 
      F17_print (718);
      break;
  }
}

void F104_printskipparam (n)
/********************/
int   n;
{
  if ((n >= 0) && (n < 18))
    F20_printesc(n + 242);
  else
    F17_print (260);
}
