/* This is the C-version of TeX for Xenix machines (large model
   with some huge arrays) */

/* File: virtex.c, contains only the type- and variable declarations */

# include <stdio.h>
# include "pc3.lib.h"
# include <setjmp.h>
#ifdef gould
# include <sys/time.h>
# include <sys/resource.h>
#endif

/* UIA modif to pc3 I/O */
#undef GET_2
#undef PUT_2
#undef RESET_3
# define GET_2(F)	if (fread(&F.buffer,sizeof(F.buffer),1,F.fp)<1) F.eof=TRUE;

# define PUT_2(F)	fwrite(&F.buffer,sizeof(F.buffer),1,F.fp);

# define RESET_3(F,N)	F.fp=fopen(N,"r"); \
			F.eof= (fread(&F.buffer,sizeof(F.buffer),1,F.fp)<1);
			    
/* end UIA modif */

jmp_buf L_9998;
int argc;
char **argv;

# ifdef INITEX
# define C1_memmax           		30000L
# define C17_triesize        		8000L
# endif
# ifdef TRIPTEX
# define C1_memmax			3000L
# define C17_triesize			8000L
# endif
# if !(defined(INITEX) || defined(TRIPTEX))
# define C1_memmax			32700L
# define C17_triesize        		6500L
# endif

# ifdef TRIPTEX
# define C2_memmin			1L
# else
# define C2_memmin           		(-30000L)
# endif

# define C3_bufsize          		1024

# if defined(TRIPTEX) || defined(INITEX)
# define C4_errorline			64
# define C5_halferrorline    		32
# define C6_maxprintline     		72
# else
# define C4_errorline        		79
# define C5_halferrorline    		50
# define C6_maxprintline     		79
# endif


# define C7_stacksize        		200

# define C8_maxinopen        		15

# define C9_fontmax          		100

# define C10_fontmemsize     		25000

# define C11_paramsize       		60

# define C12_nestsize        		40

# define C13_maxstrings      		4400

# define C14_stringvacancies 		15000

# define C15_poolsize        		45000

/* # define C16_savesize        		600 */
# define C16_savesize        		2000

# define C18_dvibufsize      		1024
# define C18_halfbufsize		512

# define C19_filenamesize    		1024

# ifdef INITEX
# define C20_poolname			"initex.pool"
# endif
# ifdef TRIPTEX
# define C20_poolname			"triptex.pool"
# endif
# if !(defined(INITEX)||defined(TRIPTEX))
# define C20_poolname        		"tex.pool"
# endif

typedef char T21_asciicode; /* was declared int by pc3. values 0..127 */

typedef unsigned char T22_eightbits; /* was declared int by pc3. 0..255 */

typedef struct
{
  FILE * fp;
  BOOLEAN eof, eoln, validbuffer;
  char  buffer;
}               T23_alphafile; /* this is a textfile */

typedef struct
{
  FILE * fp;
  BOOLEAN eof;
  unsigned char buffer;
}               T24_ubytefile;

typedef struct
{
  FILE * fp;
  BOOLEAN eof;
  char buffer;
}               T24_bytefile; /* this is a file of -128..127 */

#ifdef M_XENIX
typedef unsigned int T25_poolpointer; /* 0..poolsize */
#else
typedef int T25_poolpointer; /* 0..poolsize */
#endif

typedef int T26_strnumber; /* 0..maxstrings */

typedef long int T27_scaled; /* integer */

typedef unsigned long int T28_nonnegativeinteger; /* 0..maxint */

typedef int T29_smallnumber; /* 0..63 */

typedef long int T30_glueratio; /* integer */

typedef char T31_quarterword; /* was int for pc3, range -128..127 */

typedef short int T32_halfword; /* was int for pc3, range -32768..32767 */

typedef int T33_twochoices; /* 1..2 */

typedef int T34_fourchoices; /* 1..4 */

typedef struct
{
  T32_halfword rh;
  union
  {
    struct
    {
      T32_halfword lh;
    }       _TAG1;
    struct
    {
      T31_quarterword b0;
      T31_quarterword b1;
    }       _TAG2;
  }               _TAG;
} T35_twohalves;

typedef struct
{
  T31_quarterword b0;
  T31_quarterword b1;
  T31_quarterword b2;
  T31_quarterword b3;
}               T36_fourquarters;

typedef struct
{
  union
  {
    struct
    {
      long int   _int;
    }       _TAG1;
    struct
    {
      float gr;
    }       _TAG2;
    struct
    {
      T35_twohalves hh;
    }       _TAG3;
    struct
    {
      T36_fourquarters qqqq;
    }       _TAG4;
  } _TAG;
}               T37_memoryword;

typedef struct
{
  FILE * fp;
  BOOLEAN eof;
  T37_memoryword buffer;
}               T38_wordfile;

typedef int T39_glueord; /* 0..3 */

typedef struct
{
  long int   auxfield;
        int /* was T32_halfword */ headfield;
  long int   mlfield;
  int   modefield;
  long int   pgfield;
        int /* was T32_halfword */ tailfield;
}               T40_liststaterecord;

typedef int T41_groupcode; /* 0..16 */

typedef struct
{
  T31_quarterword indexfield;
  int /* was T32_halfword */ limitfield;
  int /* was T32_halfword */ locfield;
  int /* was T32_halfword */ namefield;
  int /* was T32_halfword */ startfield;
  T31_quarterword statefield;
}               T42_instaterecord;

typedef int T43_internalfontnumber; /* 0..100 */

typedef int T44_dviindex; /* 0..C18_dvibufsize */

typedef int T45_triepointer; /* 0..8000 */

typedef int T46_hyphpointer; /* 0..307 */

#ifdef gould
/*NOBASE*/T37_memoryword mem[C1_memmax - C2_memmin + 1];
#else
#ifdef M_XENIX
#ifdef TRIPTEX
T37_memoryword huge mem[C1_memmax - C2_memmin + 1];
#else
T37_memoryword huge mem[C1_memmax - C2_memmin + 1];
#endif
#else
T37_memoryword mem[C1_memmax - C2_memmin + 1];
#endif
#endif
int initialized=0;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29975;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29976;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29977;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29978;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29979;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29980;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29981;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29982;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29983;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29984;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29985;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29986;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29987;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29988;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29989;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29990;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29991;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29992;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29993;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29994;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29995;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29996;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29997;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29998;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m29999;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m30000;
T37_memoryword
#ifdef M_XENIX
huge
#endif
*
#ifdef M_XENIX
near
#endif
m_30000;

long int  
#ifdef M_XENIX
near
#endif
activewidth[6];
long int  
#ifdef M_XENIX
near
#endif
actuallooseness;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
adjusttail;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
aftertoken;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
alignptr;
long int  
#ifdef M_XENIX
near
#endif
alignstate;
T25_poolpointer
#ifdef M_XENIX
near
#endif
areadelimiter;
BOOLEAN
#ifdef M_XENIX
near
#endif
aritherror;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
avail;
long int  
#ifdef M_XENIX
near
#endif
background[6];
int  
#ifdef M_XENIX
near
#endif
bad;
int  
#ifdef M_XENIX
near
#endif
baseptr;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
bestbet;
long int  
#ifdef M_XENIX
near
#endif
bestheightplusdepth;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
bestline;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
bestpagebreak;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
bestplace[4];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
bestplline[4];
long int  
#ifdef M_XENIX
near
#endif
bestsize;
long int  
#ifdef M_XENIX
near
#endif
breadthmax;
long int  
#ifdef M_XENIX
near
#endif
breakwidth[6];
T21_asciicode
#ifdef M_XENIX
near
#endif
buffer[C3_bufsize + 1];
T31_quarterword
#ifdef M_XENIX
near
#endif
c;
int  
#ifdef M_XENIX
near
#endif
charbase[C9_fontmax + 1];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
condptr;
long int  
#ifdef M_XENIX
near
#endif
cscount;
long int  
#ifdef M_XENIX
near
#endif
curactivewidth[6];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curalign;
T26_strnumber
#ifdef M_XENIX
near
#endif
curarea;
int  
#ifdef M_XENIX
near
#endif
curboundary;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curbox;
T31_quarterword
#ifdef M_XENIX
near
#endif
curc;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curchr;
T22_eightbits
#ifdef M_XENIX
near
#endif
curcmd;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curcs;
T26_strnumber
#ifdef M_XENIX
near
#endif
curext;
T43_internalfontnumber
#ifdef M_XENIX
near
#endif
curf;
T41_groupcode
#ifdef M_XENIX
near
#endif
curgroup;
long int  
#ifdef M_XENIX
near
#endif
curh;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curhead;
T36_fourquarters
#ifdef M_XENIX
near
#endif
curi;
T29_smallnumber
#ifdef M_XENIX
near
#endif
curif;
T42_instaterecord
#ifdef M_XENIX
near
#endif
curinput;
T31_quarterword
#ifdef M_XENIX
near
#endif
curlevel;
T40_liststaterecord
#ifdef M_XENIX
near
#endif
curlist;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curloop;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curmark[5];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curmlist;
long int  
#ifdef M_XENIX
near
#endif
curmu;
T26_strnumber
#ifdef M_XENIX
near
#endif
curname;
T39_glueord
#ifdef M_XENIX
near
#endif
curorder;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curp;
long int  
#ifdef M_XENIX
near
#endif
curs;
T29_smallnumber
#ifdef M_XENIX
near
#endif
cursize;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curspan;
T29_smallnumber
#ifdef M_XENIX
near
#endif
curstyle;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curtail;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
curtok;
long int  
#ifdef M_XENIX
near
#endif
curv;
long int  
#ifdef M_XENIX
near
#endif
curval;
int  
#ifdef M_XENIX
near
#endif
curvallevel;
long int  
#ifdef M_XENIX
near
#endif
deadcycles;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
defref;
BOOLEAN
#ifdef M_XENIX
near
#endif
deletionsallowed;
int  
#ifdef M_XENIX
near
#endif
depthbase[C9_fontmax + 1];
long int  
#ifdef M_XENIX
near
#endif
depththreshold;
int  
#ifdef M_XENIX
near
#endif
dig[23]; /* 0..15 */
long int  
#ifdef M_XENIX
near
#endif
discwidth;
BOOLEAN
#ifdef M_XENIX
near
#endif
doingleaders;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
downptr;
T22_eightbits dvibuf[C18_dvibufsize + 1];
T43_internalfontnumber
#ifdef M_XENIX
near
#endif
dvif;
int
#ifdef M_XENIX
near
#endif
dvifile;
long int  
#ifdef M_XENIX
near
#endif
dvigone;
long int  
#ifdef M_XENIX
near
#endif
dvih;
T44_dviindex
#ifdef M_XENIX
near
#endif
dvilimit;
long int  
#ifdef M_XENIX
near
#endif
dvioffset;
T44_dviindex
#ifdef M_XENIX
near
#endif
dviptr;
long int  
#ifdef M_XENIX
near
#endif
dviv;
long int  
#ifdef M_XENIX
near
#endif
dynused;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
easyline;
long int  
#ifdef M_XENIX
near
#endif
editline;
int  
#ifdef M_XENIX
near
#endif
V47_editnamelength;
T25_poolpointer
#ifdef M_XENIX
near
#endif
editnamestart;
T35_twohalves
#ifdef M_XENIX
near
#endif
emptyfield;
T37_memoryword
#ifdef M_XENIX
near
#endif
eqtb[5976 + 2];
int  
#ifdef M_XENIX
near
#endif
errorcount;
T25_poolpointer
#ifdef M_XENIX
near
#endif
extdelimiter;
int  
#ifdef M_XENIX
near
#endif
extenbase[C9_fontmax + 1];
T31_quarterword
#ifdef M_XENIX
near
#endif
f;
long int  
#ifdef M_XENIX
near
#endif
fewestdemerits;
int   fileoffset;
int  
#ifdef M_XENIX
near
#endif
first;
long int  
#ifdef M_XENIX
near
#endif
firstcount;
long int  
#ifdef M_XENIX
near
#endif
firstindent;
long int  
#ifdef M_XENIX
near
#endif
firstwidth;
int  
#ifdef M_XENIX
near
#endif
fmemptr;
T38_wordfile
#ifdef M_XENIX
near
#endif
fmtfile;
T26_strnumber
#ifdef M_XENIX
near
#endif
fontarea[C9_fontmax + 1];
T22_eightbits
#ifdef M_XENIX
near
#endif
fontbc[C9_fontmax + 1];
T36_fourquarters fontcheck[C9_fontmax + 1];
long int  
#ifdef M_XENIX
near
#endif
fontdsize[C9_fontmax + 1];
T22_eightbits
#ifdef M_XENIX
near
#endif
fontec[C9_fontmax + 1];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
fontglue[C9_fontmax + 1];
#ifdef M_XENIX
T37_memoryword huge fontinfo[C10_fontmemsize + 1];
#else
T37_memoryword fontinfo[C10_fontmemsize + 1];
#endif
long int  
#ifdef M_XENIX
near
#endif
fontinshortdisplay;
T26_strnumber fontname[C9_fontmax + 1];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
fontparams[C9_fontmax + 1];
T43_internalfontnumber
#ifdef M_XENIX
near
#endif
fontptr;
long int  
#ifdef M_XENIX
near
#endif
fontsize[C9_fontmax + 1];
BOOLEAN fontused[C9_fontmax + 1];
BOOLEAN
#ifdef M_XENIX
near
#endif
forceeof;
T26_strnumber
#ifdef M_XENIX
near
#endif
formatident;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
g;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
ha;
T35_twohalves
#ifdef M_XENIX
near
#endif
hash[3267+1];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
hashused;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
hb;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
hc[66];
int  
#ifdef M_XENIX
near
#endif
heightbase[C9_fontmax + 1];
T26_strnumber helpline[6];
int   helpptr;
T43_internalfontnumber
#ifdef M_XENIX
near
#endif
hf;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
himemmin;
int  
#ifdef M_XENIX
near
#endif
history;
T29_smallnumber
#ifdef M_XENIX
near
#endif
hn;
T21_asciicode
#ifdef M_XENIX
near
#endif
hu[63+1];
int  
#ifdef M_XENIX
near
#endif
hyf[65];
long int  
#ifdef M_XENIX
near
#endif
hyfchar;
T29_smallnumber hyfdistance[256];
T31_quarterword hyfnext[256];
T29_smallnumber hyfnum[256];
T46_hyphpointer
#ifdef M_XENIX
near
#endif
hyphcount;
long int   hyphenchar[C9_fontmax + 1];
T29_smallnumber
#ifdef M_XENIX
near
#endif
hyphenpassed;
int /* was T32_halfword */ hyphlist[308];
T26_strnumber hyphword[308];
int  
#ifdef M_XENIX
near
#endif
iflimit;
long int  
#ifdef M_XENIX
near
#endif
ifline;
T25_poolpointer
#ifdef M_XENIX
near
#endif
initpoolptr;
T26_strnumber
#ifdef M_XENIX
near
#endif
initstrptr;
int  
#ifdef M_XENIX
near
#endif
inopen;
T23_alphafile
#ifdef M_XENIX
near
#endif
inputfile[C8_maxinopen+1];
int  
#ifdef M_XENIX
near
#endif
inputptr;
T42_instaterecord
#ifdef M_XENIX
near
#endif
inputstack[C7_stacksize + 1];
long int  
#ifdef M_XENIX
near
#endif
insertpenalties;
int  
#ifdef M_XENIX
near
#endif
interaction;
int  
#ifdef M_XENIX
near
#endif
interrupt;
int  
#ifdef M_XENIX
near
#endif
italicbase[C9_fontmax + 1];
T26_strnumber
#ifdef M_XENIX
near
#endif
jobname;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
justbox;
int  
#ifdef M_XENIX
near
#endif
kernbase[C9_fontmax + 1];
int  
#ifdef M_XENIX
near
#endif
last;
long int  
#ifdef M_XENIX
near
#endif
lastbop;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
lastglue;
long int  
#ifdef M_XENIX
near
#endif
lastkern;
long int  
#ifdef M_XENIX
near
#endif
lastpenalty;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
lastspecialline;
long int  
#ifdef M_XENIX
near
#endif
leastpagecost;
int  
#ifdef M_XENIX
near
#endif
ligkernbase[C9_fontmax + 1];
long int  
#ifdef M_XENIX
near
#endif
line;
long int  
#ifdef M_XENIX
near
#endif
linediff;
long int  
#ifdef M_XENIX
near
#endif
linestack[C8_maxinopen+1];
T23_alphafile
#ifdef M_XENIX
near
#endif
logfile;
T26_strnumber logname;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
lomemmax;
BOOLEAN
#ifdef M_XENIX
near
#endif
longhelpseen;
int  
#ifdef M_XENIX
near
#endif
longstate;
long int  
#ifdef M_XENIX
near
#endif
lq;
long int  
#ifdef M_XENIX
near
#endif
lr;
long int  
#ifdef M_XENIX
near
#endif
magicoffset;
long int  
#ifdef M_XENIX
near
#endif
magset;
int  
#ifdef M_XENIX
near
#endif
maxbufstack;
long int  
#ifdef M_XENIX
near
#endif
maxh;
int  
#ifdef M_XENIX
near
#endif
maxinstack;
long int  
#ifdef M_XENIX
near
#endif
maxneststack;
long int  
#ifdef M_XENIX
near
#endif
maxparamstack;
long int  
#ifdef M_XENIX
near
#endif
maxpush;
int  
#ifdef M_XENIX
near
#endif
maxsavestack;
long int  
#ifdef M_XENIX
near
#endif
maxv;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
memend;
long int  
#ifdef M_XENIX
near
#endif
minimaldemerits[4];
long int  
#ifdef M_XENIX
near
#endif
minimumdemerits;
BOOLEAN
#ifdef M_XENIX
near
#endif
mlistpenalties;
BOOLEAN
#ifdef M_XENIX
near
#endif
nameinprogress;
int  
#ifdef M_XENIX
near
#endif
namelength; /* 0..1024 */
char  nameoffile[1024 + 1];
T40_liststaterecord
#ifdef M_XENIX
near
#endif
nest[C12_nestsize + 1];
int  
#ifdef M_XENIX
near
#endif
nestptr;
BOOLEAN
#ifdef M_XENIX
near
#endif
nonewcontrolsequence;
BOOLEAN
#ifdef M_XENIX
near
#endif
noshrinkerroryet;
T36_fourquarters
#ifdef M_XENIX
near
#endif
nullcharacter;
T36_fourquarters
#ifdef M_XENIX
near
#endif
nulldelimiter;
BOOLEAN
#ifdef M_XENIX
near
#endif
oktointerrupt;
int  
#ifdef M_XENIX
near
#endif
oldsetting;
BOOLEAN
#ifdef M_XENIX
near
#endif
outputactive;
T26_strnumber
#ifdef M_XENIX
near
#endif
outputfilename;
long int  
#ifdef M_XENIX
near
#endif
packbeginline;
int  
#ifdef M_XENIX
near
#endif
pagecontents;
long int  
#ifdef M_XENIX
near
#endif
pagemaxdepth;
long int  
#ifdef M_XENIX
near
#endif
pagesofar[8];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
pagetail;
BOOLEAN
#ifdef M_XENIX
near
#endif
panicking;
int  
#ifdef M_XENIX
near
#endif
parambase[C9_fontmax + 1];
int  
#ifdef M_XENIX
near
#endif
paramptr;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
paramstack[C11_paramsize + 1];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
parloc;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
partoken;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
passive;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
passnumber;
T25_poolpointer
#ifdef M_XENIX
near
#endif
poolptr;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
printednode;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
pstack[9];
T29_smallnumber
#ifdef M_XENIX
near
#endif
radix;
T23_alphafile
#ifdef M_XENIX
near
#endif
readfile[16];
long int  
#ifdef M_XENIX
near
#endif
readopen[17];
long int  
#ifdef M_XENIX
near
#endif
readyalready;
char  realnameoffile[1024 + 1];
long int  
#ifdef M_XENIX
near
#endif
remainder;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
rightptr;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
rover;
long int  
#ifdef M_XENIX
near
#endif
ruledp;
long int  
#ifdef M_XENIX
near
#endif
ruleht;
long int  
#ifdef M_XENIX
near
#endif
rulewd;
int  
#ifdef M_XENIX
near
#endif
saveptr;
T37_memoryword savestack[C16_savesize + 1];
int  
#ifdef M_XENIX
near
#endif
scannerstatus;
long int  
#ifdef M_XENIX
near
#endif
secondindent;
BOOLEAN
#ifdef M_XENIX
near
#endif
secondpass;
long int  
#ifdef M_XENIX
near
#endif
secondwidth;
int  
#ifdef M_XENIX
near
#endif
selector;
int  
#ifdef M_XENIX
near
#endif
shownmode;
long int  
#ifdef M_XENIX
near
#endif
skewchar[C9_fontmax + 1];
long int  
#ifdef M_XENIX
near
#endif
skipline;
T21_asciicode strpool[C15_poolsize + 1];
T26_strnumber
#ifdef M_XENIX
near
#endif
strptr;
T25_poolpointer strstart[C13_maxstrings + 1];
long int  
#ifdef M_XENIX
near
#endif
tally;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
tempptr;
int   termoffset;
char  texformatdefault[10];
T24_ubytefile
#ifdef M_XENIX
near
#endif
tfmfile;
long int  
#ifdef M_XENIX
near
#endif
threshold;
long int  
#ifdef M_XENIX
near
#endif
totalpages;
long int  
#ifdef M_XENIX
near
#endif
totalshrink[4];
long int  
#ifdef M_XENIX
near
#endif
totalstretch[4];
T21_asciicode trickbuf[C4_errorline + 1];
long int   trickcount;
T35_twohalves trie[C17_triesize + 1];
T45_triepointer
#ifdef M_XENIX
near
#endif
triemax;
T31_quarterword
#ifdef M_XENIX
near
#endif
trieopptr;
T45_triepointer
#ifdef M_XENIX
near
#endif
trieptr;
BOOLEAN
#ifdef M_XENIX
near
#endif
useerrhelp;
long int  
#ifdef M_XENIX
near
#endif
varused;
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
warningindex;
int  
#ifdef M_XENIX
near
#endif
widthbase[C9_fontmax + 1];
T23_alphafile
#ifdef M_XENIX
near
#endif
writefile[16];
int /* was T32_halfword */
#ifdef M_XENIX
near
#endif
writeloc;
BOOLEAN
#ifdef M_XENIX
near
#endif
writeopen[18];
T31_quarterword
#ifdef M_XENIX
near
#endif
xeqlevel[710];
# if defined(INITEX) || defined(TRIPTEX)
T45_triepointer triemin;
int /* was T32_halfword */ washimin;
int /* was T32_halfword */ waslomax;
int /* was T32_halfword */ wasmemend;
T23_alphafile poolfile;
#ifdef gould
/* allocate dynamically in main */
BOOLEAN *wasfree=(BOOLEAN *)0; /* size must be C1_memmax - C2_memmin + 1; */
BOOLEAN *freearr=(BOOLEAN *)0; /* size must be C1_memmax - C2_memmin + 1; */
T45_triepointer *triehash=(T45_triepointer *)0; /* size must be C17_triesize + 1; */
T21_asciicode *triec=(T21_asciicode *)0; /* size must be C17_triesize + 1; */
T31_quarterword *trieo=(T31_quarterword *)0; /* size must be C17_triesize + 1; */
T45_triepointer *triel=(T45_triepointer *)0; /* size must be C17_triesize + 1; */
T45_triepointer *trier=(T45_triepointer *)0; /* size must be C17_triesize + 1; */
BOOLEAN *trietaken=(BOOLEAN *)0; /* size must be C17_triesize + 1; */
T31_quarterword *trieophash=(T31_quarterword *)0; /* size must be 511; */
#else
#ifdef M_XENIX
BOOLEAN huge wasfree[C1_memmax - C2_memmin + 1];
BOOLEAN huge freearr[C1_memmax - C2_memmin + 1];
#else
BOOLEAN wasfree[C1_memmax - C2_memmin + 1];
BOOLEAN freearr[C1_memmax - C2_memmin + 1];
#endif
T45_triepointer triehash[C17_triesize + 1];
T21_asciicode triec[C17_triesize + 1];
T31_quarterword trieo[C17_triesize + 1];
T45_triepointer triel[C17_triesize + 1];
T45_triepointer trier[C17_triesize + 1];
BOOLEAN trietaken[C17_triesize + 1];
T31_quarterword trieophash[511];
#endif
# endif
