#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include "common.h"

static char	par_dat[300];

FILE		*t_par;

void
save_rc(out,defaults)
TeXshell_DATA *out,*defaults;
{
/*
 *		Speichern der Defaults
 */
if(out==0){
	remove( par_dat );
	return;
}
	t_par = fopen( par_dat, "w" );

if( memcmp(out->input_dir,defaults->input_dir,strlen(out->input_dir)) )
	fprintf( t_par, "Input_Directory:\t%s\n",	out->input_dir);

if( memcmp(out->input_file,defaults->input_file,strlen(out->input_file)) )
	fprintf( t_par, "Input_File:\t%s\n",		out->input_file);


if( memcmp(out->edi1_dir,defaults->edi1_dir,strlen(out->edi1_dir)) )
	fprintf( t_par, "Edit1_Directory:\t%s\n",	out->edi1_dir);

if( memcmp(out->edi1_file,defaults->edi1_file,strlen(out->edi1_file)) )
	fprintf( t_par, "Edit1_File:\t%s\n",		out->edi1_file);


if( memcmp(out->edi2_dir,defaults->edi2_dir,strlen(out->edi2_dir)) )
	fprintf( t_par, "Edit2_Directory:\t%s\n",	out->edi2_dir);

if( memcmp(out->edi2_file,defaults->edi2_file,strlen(out->edi2_file)) )
	fprintf( t_par, "Edit2_File:\t%s\n",		out->edi2_file);


if( memcmp(out->edi3_dir,defaults->edi3_dir,strlen(out->edi3_dir)) )
	fprintf( t_par, "Edit3_Directory:\t%s\n",	out->edi3_dir);

if( memcmp(out->edi3_file,defaults->edi3_file,strlen(out->edi3_file)) )
	fprintf( t_par, "Edit3_File:\t%s\n",		out->edi3_file);


if( memcmp(out->edi4_dir,defaults->edi4_dir,strlen(out->edi4_dir)) )
	fprintf( t_par, "Edit4_Directory:\t%s\n",	out->edi4_dir);

if( memcmp(out->edi1_file,defaults->edi4_file,strlen(out->edi4_file)) )
	fprintf( t_par, "Edit4_File:\t%s\n",		out->edi4_file);

if( memcmp(out->eig_TeX,defaults->eig_TeX,strlen(out->eig_TeX)) )
	fprintf( t_par, "TeX_eigene_Wahl:\t%s\n",	out->eig_TeX);


if( memcmp(out->Edit_font,defaults->Edit_font,strlen(out->Edit_font)) )
	fprintf( t_par, "Edit_font:\t%s\n",		out->Edit_font);

if( out->i_previewer!=defaults->i_previewer )
	fprintf( t_par, "Previewer_Wahl:\t%d\n",	out->i_previewer);

if( out->i_resolution!=defaults->i_resolution )
	fprintf( t_par, "Previewer_Aufloesung:\t%d\n",	out->i_resolution);

if( out->i_leaves!=defaults->i_leaves )
	fprintf( t_par, "Previewer_Blattzahl:\t%d\n",	out->i_leaves);

if( out->i_begin_pageno!=defaults->i_begin_pageno )
	fprintf( t_par, "Drucker_AnfangsBlatt:\t%d\n",	out->i_begin_pageno);

if( out->i_end_pageno!=defaults->i_end_pageno )
	fprintf( t_par, "Drucker_EndBlatt:\t%d\n",	out->i_end_pageno);

if( out->i_shrink_factor!=defaults->i_shrink_factor )
	fprintf( t_par, "Previewer_Shrinkfactor:\t%d\n",	out->i_shrink_factor);

if( out->x_home!=defaults->x_home )
	fprintf( t_par, "Previewer_x_Home:\t%f\n",	out->x_home);

if( out->y_home!=defaults->y_home )
	fprintf( t_par, "Previewer_y_Home:\t%f\n",	out->y_home);

if( out->eig_dpi!=defaults->eig_dpi )
	fprintf( t_par, "Previewer_eigene_Aufloesung:\t%d\n",out->eig_dpi);

if( out->TeXlanguage!=defaults->TeXlanguage )
	fprintf( t_par, "TeX_Sprache:\t%d\n",		out->TeXlanguage);

if( out->TeXformat!=defaults->TeXformat )
	fprintf( t_par, "TeX_Format:\t%d\n",		out->TeXformat);

if( out->TeXrun!=defaults->TeXrun )
	fprintf( t_par, "TeX_zus._Durchlaeufe:\t%d\n",	out->TeXrun);

if( out->breite!=defaults->breite )
	fprintf( t_par, "Breite:\t%d\n",	out->breite);

if( out->hoehe!=defaults->hoehe )
	fprintf( t_par, "Hoehe:\t%d\n",	out->hoehe);

if( out->printresolution!=defaults->printresolution )
	fprintf( t_par, "Printer_Aufloesung:\t%d\n",	out->printresolution);

if( out->printlanguage!=defaults->printlanguage )
	fprintf( t_par, "Printer_Sprache:\t%d\n",	out->printlanguage);

if( out->printdevice!=defaults->printdevice )
	fprintf( t_par, "Printer_Geraet:\t%d\n",	out->printdevice);

if( out->EvenPages!=defaults->EvenPages )
	fprintf( t_par, "Printer_gerade_Seiten:\t%d\n",	out->EvenPages);

if( out->OddPages!=defaults->OddPages )
	fprintf( t_par, "Printer_ungerade_Seiten:\t%d\n",out->OddPages);

if( out->BiBTeX!=defaults->BiBTeX )
	fprintf( t_par, "BiBTeX:\t%d\n",		out->BiBTeX);

if( out->MakeIndex!=defaults->MakeIndex )
	fprintf( t_par, "MakeIndex:\t%d\n",		out->MakeIndex);


	fclose( t_par );
}


void
get_rc(in)
TeXshell_DATA *in;
{
#define LINESIZE 300

  char	line[LINESIZE],*data,*getword();
  int	ll;

  sprintf( par_dat, "%s/.xtexshellrc",   getenv("HOME") );

  if( !(t_par = fopen( par_dat, "r" )) )return;

  while( fgets(line,LINESIZE, t_par) ){

	data=getword(line,LINESIZE);
	ll=strlen(line);

	if( !data ){;}
	else
	if( !memcmp(line,"Input_Directory",ll) )
		sscanf( data, "%s", in->input_dir );
	else
	if( !memcmp(line,"Input_File",ll) )
		sscanf( data, "%s", in->input_file );
	else
	if( !memcmp(line,"Edit1_Directory",ll) )
		sscanf( data, "%s", in->edi1_dir );
	else
	if( !memcmp(line,"Edit1_File",ll) )
		sscanf( data, "%s", in->edi1_file );
	else
	if( !memcmp(line,"Edit2_Directory",ll) )
		sscanf( data, "%s", in->edi2_dir );
	else
	if( !memcmp(line,"Edit2_File",ll) )
		sscanf( data, "%s", in->edi2_file );
	else
	if( !memcmp(line,"Edit3_Directory",ll) )
		sscanf( data, "%s", in->edi3_dir );
	else
	if( !memcmp(line,"Edit3_File",ll) )
		sscanf( data, "%s", in->edi3_file );
	else
	if( !memcmp(line,"Edit4_Directory",ll) )
		sscanf( data, "%s", in->edi4_dir );
	else
	if( !memcmp(line,"Edit4_File",ll) )
		sscanf( data, "%s", in->edi4_file );
	else
	if( !memcmp(line,"TeX_eigene_Wahl",ll) )
		sscanf( data, "%s", in->eig_TeX );
	else
	if( !memcmp(line,"Edit_font",ll) )
		sscanf( data, "%s", in->Edit_font );
	else
	if( !memcmp(line,"Previewer_Wahl",ll) )
		sscanf( data, "%d", &(in->i_previewer) );
	else
	if( !memcmp(line,"Previewer_Aufloesung",ll) )
		sscanf( data, "%d", &(in->i_resolution) );
	else
	if( !memcmp(line,"Previewer_Blattzahl",ll) )
		sscanf( data, "%d", &(in->i_leaves) );
	else
	if( !memcmp(line,"Drucker_AnfangsBlatt",ll) )
		sscanf( data, "%d", &(in->i_begin_pageno) );
	else
	if( !memcmp(line,"Drucker_EndBlatt",ll) )
		sscanf( data, "%d", &(in->i_end_pageno) );
	else
	if( !memcmp(line,"Previewer_Shrinkfactor",ll) )
		sscanf( data, "%d", &(in->i_shrink_factor) );
	else
	if( !memcmp(line,"Previewer_x_Home",ll) )
		sscanf( data, "%f", &(in->x_home) );
	else
	if( !memcmp(line,"Previewer_y_Home",ll) )
		sscanf( data, "%f", &(in->y_home) );
	else
	if( !memcmp(line,"Previewer_eigene_Aufloesung",ll) )
		sscanf( data, "%d", &(in->eig_dpi) );
	else
	if( !memcmp(line,"TeX_Sprache",ll) )
		sscanf( data, "%d", &(in->TeXlanguage) );
	else
	if( !memcmp(line,"TeX_Format",ll) )
		sscanf( data, "%d", &(in->TeXformat) );
	else
	if( !memcmp(line,"TeX_zus._Durchlaeufe",ll) )
		sscanf( data, "%d", &(in->TeXrun) );
	else
	if( !memcmp(line,"Breite",ll) )
		sscanf( data, "%d", &(in->breite) );
	else
	if( !memcmp(line,"Hoehe",ll) )
		sscanf( data, "%d", &(in->hoehe) );
	else
	if( !memcmp(line,"Printer_Aufloesung",ll) )
		sscanf( data, "%d", &(in->printresolution) );
	else
	if( !memcmp(line,"Printer_Sprache",ll) )
		sscanf( data, "%d", &(in->printlanguage) );
	else
	if( !memcmp(line,"Printer_Geraet",ll) )
		sscanf( data, "%d", &(in->printdevice) );
	else
	if( !memcmp(line,"Printer_gerade_Seiten",ll) ){
		sscanf( data, "%d", &ll );
		in->EvenPages=ll;
	} else
	if( !memcmp(line,"Printer_ungerade_Seiten",ll) ){
		sscanf( data, "%d", &ll );
		in->OddPages=ll;
	} else
	if( !memcmp(line,"BiBTeX",ll) ){
		sscanf( data, "%d", &ll );
		in->BiBTeX=ll;
	} else
	if( !memcmp(line,"MakeIndex",ll) ){
		sscanf( data, "%d", &ll );
		in->MakeIndex=ll;
	}

  }
  fclose( t_par );
}

char *getword(line,n)
char	*line;
int	n;
{
 char	*end=line+n, *word;

 word=line;
 while( word<end && word[0]!=0 ){
 	if( word[0]==':' ){word[0]=0;break;}
 	word++;
 }
 if( word >= end ) return 0;
 word++;
 while( word<end && word[0]!=0 ){
 	if( word[0]!=' ' && word[0]!='\t'  )break;
 	word++;
 }

 if( word >= end ) return 0;

 return( word );
 
}
