/* options.h - 19:01 GMT +10:00 Fri 25 Jun 1993 - modifier Geoffrey Tobin */

#ifndef OPTIONS_H
#define OPTIONS_H

/* Include file ../include/options.h from dvitovdu.c */

/*
   Units of measure:
       inch, centimetre, millimetre, big point, pica, TeX point,
       scaled point, paper pixel.
*/

typedef enum
{
  ic, cm, mm, bp, pc, pt, sp, px
} units;

#ifndef Extern
#define Extern extern
#endif
Extern double xres;        /* X resolution in pixels per inch   */
Extern double yres;        /* Y resolution in pixels per inch   */
Extern int mag;            /* override DVI mag; 0 = use DVI mag */
Extern int hoffset;        /* horizontal margin shift in pixels */
Extern int voffset;        /* vertical   margin shift in pixels */
Extern int paperwd;        /* paper width in pixels             */
Extern int paperht;        /* paper height in pixels            */
Extern string vdu;         /* type of terminal                  */
Extern string tfmdir;      /* location of TFM files             */
Extern string pkdir;       /* location of PK  files             */
Extern string dummy_tfm;   /* dummy TFM file                    */
Extern string dummy_pk;    /* dummy PK  file                    */
Extern string psprefix;    /* Prefix for PS & pure TFM fonts    */
Extern string immed_help;  /* immediate help file name          */
Extern string cmd_help;    /* command   help file name          */
Extern string DVIname;     /* DVI file name                     */


extern Void InitOptions (VOID);

extern int Len __((Char *str));

extern Char * stringcopy __((string s, const Char * ct));
extern Char * strMcpy __((Char * s, const Char * ct, size_t maxlen));

extern Void WriteReal __((Char * name, double value));

#endif /* OPTIONS_H */

/* end options.h */
