/*******************************************************/
/* Linux  GNU     C++ Compiler                         */
/* Name : fastpictex.h                                 */
/* Autor: Harald Stauss                                */
/*******************************************************/

#ifndef FPICTEX
#define FPICTEX
#define MAX_FIELD_LENGTH 256
#define WHITE_SPACE " \t\n\0"
#define NSYMBOL 10    /* number of different plot symbols          */
#define N_XTICKS 5    /* number of ticks on x-scale                */
#define N_YTICKS 5    /* number of ticks on y-scale                */
#define BARWIDTH 0.8  /* How much space is used for bar graphs 0-1 */

#include <string.h>

class FASTPICTEX {

  typedef struct {
    short         type;                    /* type of graph: 0:ndef, 1:xy, 2:line, 3:bar */
    unsigned long ndata, nx, ny, ndx, ndy; /* number of data points   */
    float         *x;                      /* pointer to x values     */
    float         *y;                      /* pointer to y values     */
    float         *dx;                     /* pointer to x-errors     */
    float         *dy;                     /* pointer to y-errors     */
    char          **sig;                   /* pointer to sig. signs   */
  }
  SERIES;

  /* holds plot symbols */
  char  plotsym[NSYMBOL][80];
  char  linesym[NSYMBOL][80];
  short need_errorbarmacros;

  /* To add a new series */
  int AddSeries();  

  /* Get Extrema */
  int GetExtrema(float *xmin, float *xmax, float *ymin, float *ymax);

public:

  float   width, height;              /* width and height of graph */
  short   nofseries;                  /* number of series */
  short   nofbar;                     /* number of bar graph series */
  short   firstlinenox;               /* fist line graph without x-values */
  short   xgrid, ygrid;               /* if 1 draw x/y-gridlines */
  char    *xlabel, *ylabel, *heading; /* various labels */
  unsigned long nxticlabels;          /* number of ticlabels     */
  char    **xticlabels;               /* pointers to x tic labels */
  SERIES  *series;                    /* pointer to an array of SERIES */

  /* Initialisierung der Registrierung */
  FASTPICTEX();   // Constructor;
  ~FASTPICTEX();  // Destructor;

  /* function to read input file */
  int Read(char *fname);

  /* function to write PicTeX file */
  int Write(char *fname);
  
}; /* Ende der Klassendefinition */

#endif
