/* SIMPLE - Simple Is a Macro Processing Language Element */
/* Copyright (c) 1998 David A. Madore (david.madore@ens.fr) */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This file takes care of turning names into command numbers.  */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "simple.h"

typedef struct command_dict_entry {
  command cmd;
  char *name;
} command_dict_entry;

command_dict_entry builtins_dict[] = {
  {BI_VOID,"void"},
  {BI_IDENTITY,"id"},
  {BI_OUTPUT,"out"},
  {BI_DEFINE,"def"},
  {BI_INCLUDE,"include"},
  {BI_IT,""},
  {BI_QUOTE,"quote"},
  {BI_DQUOTE,"dquote"},
  {BI_INPUTFORM,"inputform"},
  {BI_IF,"if"},
  {BI_DEFOF,"defof"},
  {BI_QDEFOF,"qdefof"},
  {BI_QUIT,"quit"},
  {BI_ERROR,"error"},
  {BI_HEAD,"head"},
  {BI_TAIL,"tail"},
  {BI_AHEAD,"ahead"},
  {BI_ATAIL,"atail"},
  {BI_LEN,"len"},
  {BI_PUSH,"push"},
  {BI_LAST,"last"},
  {BI_POP,"pop"},
  {BI_POPLAST,"poplast"},
  {BI_DEPTH,"depth"},
  {BI_PLUS,"+"},
  {BI_MINUS,"-"},
  {BI_TIMES,"*"},
  {BI_DIV,"div"},
  {BI_MOD,"mod"},
  {BI_EQ,"eq"},
  {BI_NEQ,"neq"},
  {BI_GT,"gt"},
  {BI_GE,"ge"},
  {BI_LT,"lt"},
  {BI_LE,"le"},
  {BI_AND,"and"},
  {BI_OR,"or"},
  {BI_NOT,"not"},
  {BI_BAND,"band"},
  {BI_BOR,"bor"},
  {BI_BNOT,"bnot"},
  {BI_CARTYPE_ORDINARY,"cartype_ordinary"},
  {BI_CARTYPE_ESCAPE_NEXT,"cartype_escape_next"},
  {BI_CARTYPE_ESCAPE_STRING,"cartype_escape_string"},
  {BI_CARTYPE_COMMENT,"cartype_comment"},
  {BI_CARTYPE_ACTIVE,"cartype_active"},
  {BI_TRANSLATE,"translate"},
  {BI_FIND,"find"},
  {BI_SUBSTR,"substr"},
  {0,NULL}
};

command_dict_entry *user_dict = NULL;
int user_dict_len = 0;

static int firstfree = 1;

command
identify_command(char *name)
     /* Identify a command name and turn it into a command number. */
{
  int i;
  for (i=0;builtins_dict[i].cmd;i++) {
    if (strcmp(name,builtins_dict[i].name)==0)
      return builtins_dict[i].cmd;
  }
  for (i=0;i<user_dict_len;i++) {
    if (strcmp(name,user_dict[i].name)==0)
      return user_dict[i].cmd;
  }
  if ((user_dict=REALLOC(user_dict,((++user_dict_len)
				    *sizeof(command_dict_entry))))
      ==NULL)
    fatal(0,"Out of memory!");
  user_dict[user_dict_len-1].cmd=firstfree++;
  user_dict[user_dict_len-1].name=malloc(strlen(name)+1);
  strcpy(user_dict[user_dict_len-1].name,name);
  return user_dict[user_dict_len-1].cmd;
}
