%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 						Octave Syntax Highlight
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 			Andre Hentz (andre@lcmi.ufsc.br) 		Mar 26, 1995

variable JMAX_COLORS = 10;
variable JNORMAL_COLOR = 1;
variable JCURSOR_COLOR = 2;
variable JSTATUS_COLOR = 3;
variable JREGION_COLOR = 4;
variable JOP_COLOR = 5;
variable JNUM_COLOR = 6;
variable JSTR_COLOR = 7;
variable JCOM_COLOR = 8;
variable JKEY_COLOR = 9;
variable JDELIM_COLOR = 10;

variable str_len;
variable index;
variable str;
variable attr;

define oct_setattr_and_advance(color)
{
	index++;
	attr = strsub(attr, index, color);
}

define get_oct_keywords_af(n)
{
	switch(n)
	{ () == 2: "cd";}
    { () == 3: "absallanyargclccosdetdireigendexpeyefftfixfor";}
    { () == 4: "acosasinatanceilcholconjcoshdatediagdispelseevalexitexpmfindfsqp";}
    { () == 5: "acoshangleasinhatanhbreakclearclockdasslendiferrorexistfevalfgetsfloorflopsfopenfseekftell";}
    { () == 6: "colloccumsumelseifendforfclosefflushfiniteformatfscanffsolve";}
    { () == 7: "balancecasesencumprodfprintffreportfrewind";}
    { () == 8: "continuedocumentendwhilefunction";}
    { () == 9: "closeplot";}
    { () == 11: "endfunction";}
    { () == 12: "edit_historyfsqp_options";}
    { () == 13: "dassl_options";}
    { () == 14: "fsolve_options";}
	{ pop(); "";}
}

define get_oct_keywords_gz(n)
{
	switch(n)
	{ () == 2: "iflsluqr";}
    { () == 3: "invlogmaxminpwdsetsinsumsvdsyltanwho";}
    { () == 4: "helphesshomeifftimagloadlogmonesprodquadquitrandrealsaveshowsignsinhsizesortsqrttanh";}
    { () == 5: "gplotinputisinfisnanisstrlog10lsodenpsolpauseqpsolqzvalroundscanfschursqrtmsumsqwhilezeros";}
    { () == 6: "getenvgivensglobalgsplotprintfreplotreturnsetstrsscanfva_arg";}
    { () == 7: "historyinversesprintf";}
    { () == 8: "keyboardlp_solveva_startwarranty";}
    { () == 9: "is_globalshell_cmd";}
    { () == 11: "run_history";}
    { () == 12: "quad_options";}
    { () == 13: "lsode_optionsnpsol_optionsqpsol_options";}
    { () == 15: "purge_tmp_files";}
    { () == 16: "lp_solve_options";}
	{ pop(); "";}
}


define oct_highlight_token()
{
	variable i, n, t;
	variable ch, keywords;
	variable key_len;
	variable skip = 0;

	% identify a word
	i = index;
	while (i < str_len)
	{
		ch = str[i];
		if (is_one_of("0123456789", ch)) skip = 1;
		else !if (is_one_of("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$@_`", ch))
			break;
		i++;
    }

	if (skip)
	{
		index = i;
		return;
	}

	n =  i - index;
	if (str[index] < 'g')
		keywords = get_oct_keywords_af(n);
	else
		keywords = get_oct_keywords_gz(n);
	t = 0;
	key_len = strlen(keywords);
	while (t < key_len)
    {
		index = i - n;
		while ((index < i) and (keywords[t] == str[index]))
		{
	    	index++; t++;
		}
		if (index == i) %  keyword matched
	  	{
	    	index = i - n;
	     	while (index < i)
				oct_setattr_and_advance(JKEY_COLOR);
			return;
		}
		if (keywords[t] > str[index])
			break;	% alphabetical ordering of keywords
		t += (i - index);
	}
	index = i;
}

define oct_highlight_string()
{
	variable ch, first_ch;

	first_ch = str[index];
	oct_setattr_and_advance(JSTR_COLOR);
	while (index < str_len)
    {
		ch = str[index];
		oct_setattr_and_advance(JSTR_COLOR);
		if (ch == first_ch)
			break;
		if ((ch == '\\') and (index < str_len))
			oct_setattr_and_advance(JSTR_COLOR);
	}
}

define oct_highlight_number()
{
	variable len;

	len = number_length(str, index);
	if (len == 0)
	{
		oct_setattr_and_advance(JDELIM_COLOR);
		return;
	}	

	while (len)
	{
		len--;			
		oct_setattr_and_advance(JNUM_COLOR);
	}		
}

define oct_highlight_comment()
{
   while (index < str_len)
		oct_setattr_and_advance(JCOM_COLOR);
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%						Octave Syntax Highlight						%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
define octave_syntax_highlight ()
{
	variable ch;

	=attr; =str;

    str_len = strlen(str);
	index = 0;

   	while (index < str_len)
    {
		ch = str[index];
    	if (is_one_of("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$@_`", ch)) 
			oct_highlight_token();
    	else if (is_one_of("0123456789.", ch)) 
			oct_highlight_number();
    	else if (is_one_of("{}[]();,\\", ch))
			oct_setattr_and_advance(JDELIM_COLOR);
    	else if (is_one_of("!&*+-/:<=>?^|~.'", ch))
			oct_setattr_and_advance(JOP_COLOR);
    	else if ( (ch == '%') or (ch == '#') )
     		oct_highlight_comment();
    	else if ( ch == '"' ) 
			oct_highlight_string();
		else
			index++;
	}
	attr;
}
