/* pbmfont.h - header file for font routines in libpbm
*/

struct glyph {
	int width, height;
	int x, y;
	int xadd;
	const char* bmap;
};

struct font {
	int maxwidth, maxheight;
	int x, y;
	struct glyph* glyph[256];
	/* for compatibility with old pbmtext routines */
	/* oldfont is 0 if the font is BDF derived */
	bit** oldfont;
	int fcols, frows;
};

NETPBMDLL struct font* pbm_defaultfont (const char* const which);
NETPBMDLL struct font* pbm_dissectfont ARGS(( bit** font, int frows, int fcols ));
NETPBMDLL struct font* pbm_loadfont ARGS(( char* filename ));
NETPBMDLL struct font* pbm_loadpbmfont ARGS(( char* filename ));
NETPBMDLL struct font* pbm_loadbdffont ARGS(( char* filename ));
NETPBMDLL void pbm_dumpfont ARGS(( struct font* fn ));
NETPBMDLL int mk_argvn ARGS(( char* s, char* vec[], int max ));
