program pgn2tex;
{$m 65520,0,600000}


uses
  ch_ppgn, ch_files, ch_parse, ch_tex, crt, dos, jalfiles;

VAR
  isfile : BOOLEAN;

procedure OpenOFiles(target : sourcetype; fc : longint; VAR f1 : text);

var
  mname : string;

begin

    if target.name='' then
      assign(f1,'')
    else
    if pos(copy(target.name,1,3),' prn PRN')>0 then
      assign(f1,'PRN')
    else
    begin
      mname := jalfiles.Generate_FileName(target.name,fc);
      isfile := TRUE;
      assign(f1,target.path+mname);
      if file_exist(target.path+mname) then
        erase(f1);
    end;
    io_test;
    rewrite(f1);
    io_test;
end; (* OpenOFiles *)

var
  t_game_numb, print_games, game_numb, not_printed_games : longint;
  f1 : filetype;
  f2 : text;
  target, target2, source : sourcetype;
  game : gametype;
  target_idx, file_count : longint;
  i : integer;
  short : boolean;


begin
  isfile := FALSE;
  io_test;
  writeln;
  writeln('Carsten Hansen, CH0506@HDC.HHA.DK, any comment welcome');
  writeln('adapted by Jrgen A.Lamers, jaloma@wuivendriet.fido.de');
  writeln;
  writeln('SYNTAX: PGN2TEX source-file target-file');
  writeln;
  if paramcount=0 then
  begin
    write('Type name of PGN-file:         ');
    readln(source.name);
    target.name:=source.name;
    write('Name of new TeX file :         ');
    readln(target.name);
  end
  else
  if paramcount=1 then
  begin
    source.name:=paramstr(1);
    target.name:=source.name;
  end
  else
  begin
    source.name:=paramstr(1);
    target.name:=paramstr(2);
    short := (paramstr(3)='-s') OR (paramstr(3)='-S');
  end;
  if not file_exist(source.name) then
  begin
    remove_ext(source.name);
    source.name:=source.name+'.pgn';
  end;

  if file_exist(source.name) then
  begin
(*    remove_ext(target.name);*)
    find_path(target.name,target.path);
    open_file_for_read(f1,source.name);
    io_test;
    file_count := 0;
    OpenOFiles(target,file_count,f2);

    io_test;  io_error:=not(copyerror=0);
    game_numb:=0;
    t_game_numb:=0;
    target_idx:=0;
    not_printed_games:=0;
    writeln;
    if not io_error then
    begin
      while (not io_error) and (not f1.eof) and (not keypressed) do
      begin
        read_pgn(f1,game);
        if (not game.illegal_move) and (game.numb_of_moves>0) then
        begin
          inc(t_game_numb);
          if short then
            short_print_tex(f2,game)
          else
            print_tex(f2,game);
          INC(print_games);
          inc(game_numb);
          if (print_games>=10) then begin
            close(f2);
            inc(file_count);
            OpenOFiles(target,file_count,f2);
            print_games :=0;
          end;
        end
        else
        begin
          if not (f1.eof and (game.numb_of_moves=0)) then
          begin
            inc(not_printed_games);
            inc(game_numb);
          end;
        end;
        gotoxy(10,wherey);
        write(game_numb,'  Games examined  ',
              not_printed_games,'  Games omitted');
      end;
    end
    else
    begin
      writeln('IO-error while opening ',source.name);
    end;

    close_read_file(f1);
    if isfile and (print_games=0) then begin
      erase(f2);
      dec(file_count);
      end
    else
      close(f2);
    writeln;
    writeln('Create ',file_count+1,' files from the source-file!');
  end
  else
  begin
    writeln(source.name,' Does not exist');
  end;
end.

