unit ch_files;

interface

uses
  crt,dos, ch_chess;

const
  optionstr = '-SHORT -LONG';
  copyerror : integer = 0;
  bufmax = 10000;
  bitval : array [0..15] of word =(1,2,4,8,16,32,64,128,256,512,1024,
                                   2048,4096,8192,16384,32768);
  io_error : boolean = false;

  file_max = 100;
  source_max = 100;

type
  w_nametype = string[25];

  buffertype = array[0..bufmax-1] of byte;
  filetype = record
               buf : ^buffertype;
               bckbeg, bckend : longint;
               pos : longint;
               f : file;
               eof : boolean;
             end;


  sourcetype = record
                 name : pathstr;
                 path: pathstr;
                 index : filetype;
                 game : filetype;
               end;

  gametype = record
               beg : longint;
               beg_next : longint;
               len : longint;
               numb_of_moves : integer;
               w_name, b_name: w_nametype;
               place : string[20];
               event : string[20];
               site : string[20];
               cb_players: string[46];
               cb_players_len : byte;
               cb_source: string[46];
               cb_source_len : byte;
               cb_bytes_on_moves : integer;
               annotator : string[15];
               source : string[20];
               info : string[12];
               w_elo, b_elo : integer;
               w_title, b_title : string[3];
               result : string[3];
               nic_opening : string[20];
               year : integer;
               round : integer;
               numb_of_w_moves : integer;
               move: move_histtype;
               deleted : boolean;
               overwritten : boolean;
               comment : boolean;
               quiz : boolean;
               alternatives : boolean;
               normal_game : boolean;
               position : boolean;
               illegal_move : boolean;
               skip: boolean;
               nictools_used_to_convert : boolean;
               game_format: string[3];
               bitnumb : longint;
               bytes : array[0..10000] of integer;
             end;

  filelist = array[1..file_max] of pathstr;
  sourcelisttype = array[0..source_max] of sourcetype;





procedure io_test;

function aktual_disk: byte;

function byte2hex(b: byte):string;

function upcasestr(s1: string) : string;

function file_exist (file_name : string): boolean;

procedure erase_file(filename : string);

procedure remove_ext(VAR s1 : pathstr);

procedure plus_backslash(var path: pathstr);

procedure find_path(VAR search_files, path: pathstr);

procedure open_file_for_read(VAR fil : filetype; name : string);

procedure open_file_for_write(VAR fil : filetype; name : string);

procedure close_read_file(VAR fil: filetype);

procedure close_write_file(VAR fil: filetype);

function get_next_byte(VAR fil : filetype): longint;

procedure put_next_byte(VAR fil : filetype; a : longint);

function get_index_val(VAR fil : filetype) : longint;

procedure put_index_val(VAR fil : filetype; p: longint);

procedure init_game(VAR game : gametype);

procedure getdirlist(searchstr : string; var dirlist : filelist);

procedure select_source_files(VAR source : sourcelisttype);

function total_numb_of_games(VAR source:sourcelisttype) : longint;

procedure remove_spaces(VAR line: string);

procedure remove_spaces_in_name(VAR line: w_nametype);

function all_params: string;

function get_paramcount: byte;

function get_paramstr(j: byte): string;

implementation

function aktual_disk: byte;
var
  regs : registers;
begin
  regs.ah:=$19;
  msdos(regs);
  aktual_disk:=regs.al+1;
end;

function upcasestr(s1: string) : string;
var
  s2: string;
  i : integer;

begin
  s2:='';
  for i:=1 to length(s1) do
    s2:=s2+upcase(s1[i]);
  upcasestr:=s2;
end;

function byte2hex(b: byte):string;
const
  hex_val : string[16]= '0123456789ABCDEF';

var
  s: string;

begin
  s:=hex_val[(b and 240 div 16)+1]+hex_val[(b and 15)+1];
  byte2hex:=s;
end;



function file_exist (file_name : string): boolean;
var
  f : file;

begin
  {$i-}
  assign(f, file_name);
  reset(f);
  close(f);
  {i+}
  file_exist:=((ioresult=0) and (file_name<>''));
end;



procedure remove_ext(VAR s1 : pathstr);
begin
  while pos('.',s1)>0 do
    s1:=copy(s1,1,length(s1)-1);
end;

procedure io_test;
begin
  copyerror:=ioresult;
  if copyerror=0 then
    if doserror<>0 then
      copyerror:=doserror;
  doserror:=0;
end; {io_test}

procedure erase_file(filename : string);
var
  f1 : file;

begin
  assign(f1,filename);
  if file_exist(filename) then
    erase(f1);
  io_test;
end;

procedure plus_backslash(var path: pathstr);
begin
  if path[length(path)]<>'\' then
    path:=path+'\';
end; {plus_backslash}

procedure find_path(VAR search_files, path: pathstr);
var
  drive : byte;

begin
  if pos('\',search_files)>0 then
  begin
    path:=search_files;
    while path[length(path)]<>'\' do
      path:=copy(path,1,length(path)-1);
  end
  else
  if pos(':',search_files)>0 then
  begin
    drive:=ord(search_files[1])-64;
    getdir(drive,path);
  end
  else
    getdir(aktual_disk,path);

  plus_backslash(path);
  while (pos(':',search_files)>0) or (pos('\',search_files)>0) do
    search_files:=copy(search_files,2,length(search_files)-1);
  search_files:=upcasestr(search_files);
  path:=upcasestr(path);
end;

procedure open_file_for_read(VAR fil : filetype; name : string);
begin
  assign(fil.f,name);
  io_error:=false;
  if not file_exist(name) then
  begin
    io_error:=true;
  end
  else
  begin
    reset(fil.f,1);
    io_test; io_error:=io_error or (copyerror<>0);
  end;
  fil.bckbeg:=0;
  fil.bckend:=-1;
  fil.pos:=-1;
  fil.buf:=nil;
  fil.eof:=false;
  new(fil.buf);
end;

procedure open_file_for_write(VAR fil : filetype; name : string);
begin
  assign(fil.f,name);
  io_error:=false;
  if file_exist(name) then
  begin
    erase(fil.f);
    io_test;
  end;
  io_error:=false;
  rewrite(fil.f,1);
  io_test; io_error:=io_error or (copyerror<>0);
  fil.bckbeg:=0;
  fil.bckend:=-1;
  fil.pos:=-1;
  fil.buf:=nil;
  new(fil.buf);
end;

procedure close_read_file(VAR fil: filetype);
begin
  close(fil.f);
  io_test;
  dispose(fil.buf);
  fil.bckbeg:=-1;
  fil.bckend:=-1;
  fil.pos:=-1;
  fil.buf:=nil;
end;

procedure close_write_file(VAR fil: filetype);
var
  bytes_written : integer;

begin
  blockwrite(fil.f,fil.buf^,fil.bckend-fil.bckbeg+1,bytes_written);
  io_error:=false; io_test;
  io_error:=io_error or (copyerror<>0) or
            (bytes_written<>fil.bckend-fil.bckbeg+1);
  close(fil.f);
  io_test;
  dispose(fil.buf);
  fil.bckbeg:=-1;
  fil.bckend:=-1;
  fil.pos:=-1;
  fil.buf:=nil;
end;


function get_next_byte(VAR fil : filetype): longint;
var
  b : longint;
  bytes_read : integer;

begin
  inc(fil.pos);
  if (fil.pos<=fil.bckend) then
  begin
    b:=fil.buf^[fil.pos-fil.bckbeg];
  end
  else
  begin
    fil.bckbeg:=fil.bckend+1;
    blockread(fil.f,fil.buf^,bufmax,bytes_read);
    io_error:=false; io_test;
    io_error:=io_error or (copyerror<>0);
    fil.bckend:=fil.bckend+bytes_read;
    b:=fil.buf^[0];
    fil.eof:=(bytes_read=0);
  end;
  get_next_byte:=b;
end;

procedure put_next_byte(VAR fil : filetype; a : longint);
var
  b : byte;
  bytes_written : integer;

begin
  b:=a and 255;
  inc(fil.pos);
  inc(fil.bckend);
  if (fil.bckend-fil.bckbeg+1)<=bufmax then
  begin
    fil.buf^[fil.bckend-fil.bckbeg]:=b;
  end
  else
  begin
    blockwrite(fil.f,fil.buf^,fil.bckend-fil.bckbeg,bytes_written);
    io_error:=false; io_test;
    io_error:=io_error or (copyerror<>0) or
              (bytes_written<>fil.bckend-fil.bckbeg);
    fil.bckbeg:=fil.bckbeg+bytes_written;
    fil.bckend:=fil.bckbeg;
    fil.buf^[0]:=b;
  end;
end;

function get_index_val(VAR fil : filetype) : longint;
var
  byte_numb : array[0..3] of longint;
  i : integer;
  p : longint;

begin
  for i:=0 to 3 do
  begin
    byte_numb[i]:=get_next_byte(fil);
  end;
  p:=byte_numb[0]*256*256*256+
     byte_numb[1]*256*256 +
     byte_numb[2]*256 +
     byte_numb[3];
  get_index_val:=p;
end;

procedure put_index_val(VAR fil : filetype; p: longint);
var
  byte_numb : array[0..3] of longint;
  i : integer;

begin
  byte_numb[3]:=p mod 256;
  p:=p div 256;
  byte_numb[2]:=p mod 256;
  p:=p div 256;
  byte_numb[1]:=p mod 256;
  p:=p div 256;
  byte_numb[0]:=p mod 256;
  put_next_byte(fil,byte_numb[0]);
  put_next_byte(fil,byte_numb[1]);
  put_next_byte(fil,byte_numb[2]);
  put_next_byte(fil,byte_numb[3]);
end;

procedure init_game(VAR game : gametype);
var
  i : integer;

begin
  game.numb_of_moves:=0;
  game.w_name:='';
  game.b_name:='';
  game.place:='';
  game.cb_players:='';
  game.event:='';
  game.site:='';
  game.cb_source:='';
  game.annotator:='';
  game.source:='';
  game.info:='';
  game.cb_source_len:=0;
  game.cb_players_len:=0;
  game.cb_bytes_on_moves:=0;
  game.w_elo:=0;
  game.b_elo:=0;
  game.w_title:='';
  game.b_title:='';
  game.result:='';
  game.nic_opening:='';
  game.year:=0;
  game.round:=0;
  game.numb_of_w_moves:=0;
  for i:=0 to 10 do
  begin
    game.move[i]:='';
  end;
  game.deleted:=false;
  game.overwritten:=false;
  game.comment:=false;
  game.quiz:=false;
  game.alternatives:=false;
  game.normal_game:=true;
  game.position:=false;
  game.illegal_move:=false;
  game.skip:=false;
  game.game_format:='';
  game.bitnumb:=0;
end;

procedure getdirlist(searchstr : string; var dirlist : filelist);
const
  search_attr =$2f;

var
  nr : word;
  one_entry : searchrec;

begin
  nr :=1;
  findfirst(searchstr,search_attr,one_entry);
  io_test;
  while (copyerror=0) do
  begin
    dirlist[nr] := one_entry.name;
    nr := succ(nr);
    findnext(one_entry);
    io_test;
  end; {while}
  repeat
    dirlist[nr] := '';
    nr:=succ(nr);
  until nr = file_max;
end;  {getdirlist}

procedure select_source_files(VAR source : sourcelisttype);
var
  i, numb_of_source : integer;
  dir_list : filelist;
  choice : string;

begin
  getdirlist(source[0].path+source[0].name+'.CBI',dir_list);
  for i:=2 to source_max do
  begin
    source[i].name:='';
    source[i].path:='';
  end;
  i:=1;
  while dir_list[i]<>'' do
  begin
    source[i+1].name:=upcasestr(source[0].path+
                                copy(dir_list[i],1,pos('.',dir_list[i])-1));
    inc(i);
    find_path(source[i].name, source[i].path);
  end;

  numb_of_source:= i;
  i:=2;
  while (i<=numb_of_source) and (numb_of_source>1) do
  begin
    if not ((source[i].name=upcasestr(source[1].name)) and
            (source[i].path=upcasestr(source[1].path))) then
    begin
      write(source[i].name);
      gotoxy(65,wherey);
      write('INCLUDE Y/N? ');
      readln(choice);
      choice:=upcasestr(copy(choice,1,1));
      if choice='N' then
        source[i].name:='';
    end
    else
      source[i].name:='';
    inc(i);
  end;
end;

function total_numb_of_games(VAR source:sourcelisttype) : longint;
var
  t : longint;
  i : integer;
begin
  t:=0;
  i:=1;
  while (i<=source_max) and (not io_error) do
  begin
    if (source[i].name<>'') and
       file_exist(source[i].path+source[i].name+'.CBI') and
       file_exist(source[i].path+source[i].name+'.CBF') then
    begin
      open_file_for_read(source[i].index,
                         source[i].path+source[i].name+'.CBI');

      inc(t,get_index_val(source[i].index)-1);
      close_read_file(source[i].index);
    end;
    inc(i);
  end;
  total_numb_of_games:=t;
end;

procedure remove_spaces(VAR line: string);
begin
  while (length(line)>0) and (pos(' ',line)=1) do
    line:=copy(line,2,length(line)-1);

  while (length(line)>0) and (pos(' ',line)=length(line)) do
    line:=copy(line,1,length(line)-1);
end;

procedure remove_spaces_in_name(VAR line: w_nametype);
begin
  while (length(line)>0) and (pos(' ',line)=1) do
    line:=copy(line,2,length(line)-1);

  while (length(line)>0) and (pos(' ',line)=length(line)) do
    line:=copy(line,1,length(line)-1);
end;

function all_params : string;
var
  out_str: string;
  i : integer;

begin
  out_str:='';
  for i:=1 to paramcount do
    out_str:=out_str+paramstr(i);
  all_params:=out_str;
end;

function get_paramcount: byte;
var
  i, numb_of_params : byte;

begin
  numb_of_params:=0;
  for i:=1 to paramcount do
  begin
    if pos(upcasestr(paramstr(i)),optionstr)=0 then
      inc(numb_of_params);
  end;
  get_paramcount:=numb_of_params;
end;

function get_paramstr(j: byte): string;
var
  i, param_numb : byte;
  out_str, last_param : string;

begin
  i:=0;
  param_numb:=0;
  last_param:='';
  while (i<paramcount) and (param_numb<j) do
  begin
    inc(i);
    if pos(upcasestr(paramstr(i)),optionstr)=0 then
    begin
      inc(param_numb);
      last_param:=paramstr(i);
    end;
  end;
  if param_numb=j then
    out_str:=last_param
  else
    out_str:='';
  get_paramstr:=out_str;
end;


begin
end.
