/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.licence;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.LayoutManager2;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public abstract class AbstractLicencePanel
extends IzPanel {
    private static final Logger logger = Logger.getLogger(AbstractLicencePanel.class.getName());
    private static final String DEFAULT_SUFFIX = ".licence";
    private static final long serialVersionUID = 1483930095144726447L;

    public AbstractLicencePanel(Panel panel, InstallerFrame parent, GUIInstallData installData, LayoutManager2 layoutManager, Resources resources) {
        super(panel, parent, installData, layoutManager, resources);
    }

    protected URL loadLicence() {
        String panelId;
        String resNamePrefix = this.getClass().getSimpleName();
        String resNameStr = resNamePrefix + DEFAULT_SUFFIX;
        Panel panel = this.getMetadata();
        Resources resources = this.getResources();
        URL url = null;
        if (panel != null && (panelId = panel.getPanelId()) != null) {
            String panelSpecificResName = resNamePrefix + '.' + panelId;
            try {
                url = resources.getURL(panelSpecificResName);
            }
            catch (ResourceNotFoundException e) {
                try {
                    url = resources.getURL(resNameStr);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        if (url == null) {
            panelId = panel != null ? panel.getPanelId() : null;
            logger.warning("Cannot open any of the possible license document resources (" + (panelId != null ? resNamePrefix + '.' + panelId + ", " : "") + resNamePrefix + DEFAULT_SUFFIX + ") for panel type '" + resNamePrefix + "");
        }
        return url;
    }

    protected String loadLicenceAsString() {
        return this.loadLicenceAsString("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadLicenceAsString(String encoding) {
        URL url = null;
        String result = null;
        try {
            url = this.loadLicence();
            InputStream in = url.openStream();
            try {
                result = IOUtils.toString(in, Charsets.toCharset(encoding));
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        catch (IOException e) {
            logger.warning("Cannot convert license document from resource " + url.getFile() + " to text: " + e.getMessage());
        }
        return result;
    }
}

