/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.variable.ConfigFileValue;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipEntryConfigFileValue
extends ConfigFileValue {
    private String filename;
    private String entryname;

    public ZipEntryConfigFileValue(String filename, String entryname, int type, String section, String key, boolean escape) {
        super(type, section, key, escape);
        this.filename = filename;
        this.entryname = entryname;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getEntryname() {
        return this.entryname;
    }

    public void setEntryname(String entryname) {
        this.entryname = entryname;
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        if (this.filename == null || this.filename.length() <= 0) {
            throw new Exception("No or empty file path given to read entry from");
        }
        if (this.entryname == null || this.entryname.length() <= 0) {
            throw new Exception("No or empty file entry given to read entry from");
        }
    }

    @Override
    public String resolve() throws Exception {
        return super.resolve(this.getZipEntryInputStream(this.getFilename(), this.getEntryname()));
    }

    @Override
    public String resolve(VariableSubstitutor ... substitutors) throws Exception {
        String _filename_ = this.filename;
        String _entryname_ = this.entryname;
        for (VariableSubstitutor substitutor : substitutors) {
            _filename_ = substitutor.substitute(_filename_);
        }
        for (VariableSubstitutor substitutor : substitutors) {
            _entryname_ = substitutor.substitute(_entryname_);
        }
        return super.resolve(this.getZipEntryInputStream(_filename_, _entryname_), substitutors);
    }

    private InputStream getZipEntryInputStream(String filename, String entryname) throws Exception {
        try {
            ZipFile zipfile = new ZipFile(filename);
            ZipEntry entry = zipfile.getEntry(entryname);
            if (entry == null) {
                throw new Exception("Zip file entry " + entryname + " not found in " + zipfile.getName());
            }
            return zipfile.getInputStream(entry);
        }
        catch (ZipException ze) {
            throw new Exception("Error opening zip file " + filename, ze);
        }
    }
}

