#!/usr/bin/perl



$TESTFILES_DIRNAME = 'testFiles';


#echo \*\*\* You should see nothing below except for lines starting with \*\*\*:


opendir(TESTFILESDIR, "$TESTFILES_DIRNAME") || die "can't opendir $TESTFILES_DIRNAME. Aborting.";

@tests = readdir(TESTFILESDIR);
closedir(TESTFILESDIR);

%tests = {};
foreach $test (@tests) { 
    if ($test =~ /.*\.txt$/) {
	$test =~ s/\.txt$//; 
	$test =~ s/.*\///;
	#print "$test\n";
	$tests{$test} = 1;
    }
}


foreach $test (keys %tests) {
    #if (string($test)) 
    #{print "$test\n";}

    print "Comparing $test...";
    #print "Comparing the results of ./easylatex testFiles/$test.txt to testFiles/$test.tex.correct\n";
    unlink "$test.tex";
    #print STDERR "perl easylatex.pl -e testFiles/$test.txt";
    system("perl easylatex.pl -e testFiles/$test.txt\n");
    
    #print STDERR "results: $test.tex vs. testFiles/$test.tex.correct\n";
    open(RESULTFILE, "$test.tex");
    undef $/;
    $result = <RESULTFILE>;
    close RESULTFILE;

    $result =~ s/easyLatexGraph\d+/easyLatexGraph/g;

    open(GOALFILE, "testFiles/$test.tex.correct");
    $goal = <GOALFILE>;
    close GOALFILE;

    #print $result;

    if ($result ne $goal) {
	print "DIFFERENCES!...";
    }

    print "done\n";

}


 

  
