/* Stack.h
 *
 * Adjusting the look and feel of the document in a recursive way is done
 * with a stack of Environments, where each environment holds variables such
 * as the current font and margin sizes. This describes the stack.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

#include "Environment.h"
#include "Length.h"

const MAXNESTING = 100;
class Stack {
   static int level;
   static Environment *environments[MAXNESTING];

 public:
   Stack();
   static void push(int, int, float, char *);
   static void pop(int, int, float, char *);
   static void set(int, int, float, char *);
   static void relative_set(int, int, float, char *);

   static float get(int, int, char*);
   static void shutdown();
   Length *get_length();
};
