/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : note.cc
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/

#define max( a, b )            ( ( ( a ) > ( b ) ) ? ( a ) : ( b ) )
#define min( a, b )            ( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )
#define abs( a )               ( ( ( a ) > 0 ) ? ( a ) : ( - ( a ) ) )
#define sign( a )              ( ( ( a ) > 0 ) ? ( 1 ) : ( - 1 ) )

#include "beamlist.h"
#include "maclist.h"
#include "slurlist.h"
#include "simpnote.h"
#include "noteslis.h"
//#include "snotelis.h"
#include "chord.h"
#include "init.h"
#include "staff.h"
#include "mpp.h"

//#define TRIPLET 1

/****************************************************************************
  class Note
--*/

int Note::stemLength = 6;

Note::Note( const Note& note ) :
    chord( note.chord ),
    macroList( *new MacroList( note.macroList ) ),
    staff( note.staff )    
{
}

Note::Note( Staff& s ) :
    chord( FALSE ),
    macroList( *new MacroList() ),
    staff( s )    
{
}

int Note::operator ==( const Sortable& test ) const
{
    return ( pitch() == ( (Note&)test ).pitch() );
}

int Note::operator >( const Sortable& test ) const
{
    return ( pitch() > ( (Note&)test ).pitch() );
}

Note& Note::getNote( Staff& staff, MacroList& macroList )
{
    Note* note;
    SimpleNote* simpleNote;

    staff.noteCount++;

    BeamList beamList( staff );
    macroList.putList( MacroList( staff ) );
    SlurList slurList( staff );
    macroList.putList( MacroList( staff ) );

    istream& is = *staff.is;
    char c = is.peek();
    if ( c == '{' )				  // chord
        {
        Chord& chord = Chord::getChord( staff );
                               // this *should* be, the first note encounterd
        simpleNote = &chord.top(); 
        note = &chord;
        }
    else					  // no chord, then it is simplenote
        {
        simpleNote = &SimpleNote::getSimpleNote( staff );
        note = simpleNote;
        }
        
#ifdef TRIPLET                 // nasty [ 4 4 r ]/3 patch
    beamList.putList( simpleNote->beamList );
    simpleNote->beamList.putList( beamList );
#else
    simpleNote->beamList.putList( beamList );
#endif
    simpleNote->macroList.putList( macroList );
    simpleNote->slurList.putList( slurList );
    
    return *note;    
}

Note::~Note()
{
    ;// monitor << "~Note";
#if 1
    delete &macroList;
    ;// monitor << ".";
#endif
    ;// monitor << "~Note end" << endl;
}

//-- class Note //
