/*
 * Decompiled with CFR 0.152.
 */
package pdbf.compilers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.postgresql.util.PSQLException;
import pdbf.PDBF_Compiler;
import pdbf.json.Database;
import pdbf.json.Dimension;
import pdbf.json.PDBFelement;
import pdbf.json.PDBFelementContainer;
import pdbf.json.PDBFelementTypeAdapter;
import pdbf.json.Text;
import pdbf.json.TextualPDBFelement;
import pdbf.json.VisualPDBFelement;
import pdbf.json.alasql.Alasql;
import pdbf.json.alasql.Column;
import pdbf.json.alasql.Data;
import pdbf.json.alasql.DatabaseContainer;
import pdbf.json.alasql.Table;
import pdbf.misc.Tools;

public class Pre_Compiler {
    private static String[] pathToLaTeXScript = new String[0];
    private static ArrayList<Process> processes = new ArrayList();
    private static ArrayList<String> cleanupfiles = new ArrayList();
    private static ArrayList<String> copyfiles = new ArrayList();
    private static ArrayList<String> preloadfiles = new ArrayList();
    private static ArrayList<String> dataFiles = new ArrayList();
    private static Gson gson;
    public static String suffix;
    private static Dimension dimOrg;
    private static float dpiScalingFactor;
    private static String latexFolder;
    private static String latexDir;
    private static String baseDir;
    private static String baseDirData;
    private static String arg0;
    public static boolean pdfProtect;

    static {
        pdfProtect = true;
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping().serializeNulls();
        builder.registerTypeAdapter((Type)((Object)PDBFelement.class), new PDBFelementTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)Alasql.class), new Alasql());
        builder.registerTypeAdapter((Type)((Object)Table.class), new Table());
        gson = builder.create();
    }

    public static void cleanup(String filename) {
        String s;
        new File(String.valueOf(baseDir) + filename + ".pdf").delete();
        new File(String.valueOf(baseDir) + filename + "Embed.pdf").delete();
        new File(String.valueOf(latexDir) + filename + ".pdf").delete();
        String[] stringArray = new File(baseDir).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (Pattern.matches("Overlay\\d+(Tmp|).(pdf|json|data)", s)) {
                new File(String.valueOf(baseDir) + s).delete();
            }
            ++n2;
        }
        stringArray = new File(latexDir).list();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (Pattern.matches("Overlay\\d+(Tmp|).(pdf|json|data)", s)) {
                new File(String.valueOf(latexDir) + s).delete();
            }
            ++n2;
        }
        new File(String.valueOf(baseDir) + "pdbf-dim.json").delete();
        new File(String.valueOf(baseDir) + "pdbf-config.json").delete();
        new File(String.valueOf(baseDir) + "pdbf-db.sql").delete();
        new File(String.valueOf(baseDir) + "pdbf-db.json").delete();
        new File(String.valueOf(baseDir) + "pdbf-preload").delete();
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        Object p;
        ProcessBuilder pb;
        void var17_34;
        baseDir = Tools.getBaseDir();
        baseDirData = Tools.getBaseDirData();
        String texFilename = new File(args[0]).getName();
        String baseFilename = texFilename.substring(0, texFilename.length() - 4);
        String pdfname = String.valueOf(baseDir) + baseFilename + ".pdf";
        String latexPath = args[0];
        arg0 = args[0];
        File latex = new File(latexPath);
        if (!latex.exists()) {
            System.err.println("Error: LaTeX file does not exist!");
            System.exit(1);
        }
        latexFolder = latex.getAbsoluteFile().getParent();
        latexDir = String.valueOf(latexFolder) + File.separator;
        Pre_Compiler.cleanup(baseFilename);
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(String.valueOf(baseDir) + "config.cfg");
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            ArrayList<String> tmp = new ArrayList<String>();
            while ((strLine = br.readLine()) != null) {
                if ((strLine = strLine.trim()).startsWith("dpiScalingFactor")) {
                    StringTokenizer stok = new StringTokenizer(strLine, ":");
                    stok.nextToken();
                    dpiScalingFactor = Float.parseFloat(stok.nextToken());
                    continue;
                }
                if (strLine.startsWith("#") || strLine.equals("")) continue;
                tmp.add(strLine);
            }
            if (tmp.size() == 0 || ((String)tmp.get(tmp.size() - 1)).equals("DELETE ME")) {
                System.err.println("Warning: You have to first adjust the config.cfg file before you can use this tool.\nDid you forgot to remove the \"DELETE ME\" at the end of the config file? Exiting...");
                System.exit(1);
            }
            br.close();
            pathToLaTeXScript = tmp.toArray(pathToLaTeXScript);
        }
        catch (IOException e4) {
            e4.printStackTrace();
            System.exit(1);
        }
        if (pathToLaTeXScript[0].contains("texi2") && args[0].contains(" ")) {
            System.err.println("WARNING: Specified path to texfile contains spaces and you are using texi2pdf or texi2dvi which does not support spaces in file paths!");
        }
        if (!latexPath.endsWith(".tex")) {
            System.err.println("Error: Specified file has the wrong extension. Only .tex is supported!");
            System.exit(1);
        }
        ArrayList<String> commands = new ArrayList<String>(Arrays.asList(pathToLaTeXScript));
        commands.add(latex.getAbsolutePath());
        try {
            ProcessBuilder pb2 = new ProcessBuilder(String.valueOf(baseDir) + "external-tools" + File.separator + "phantomjs-" + suffix, "--version");
            Process p2 = pb2.start();
            p2.waitFor();
            if (p2.exitValue() != 0) {
                System.err.println("Error! Your system can't run the supplied binary of phantom-js. This means that you have to upgrade your system to 64-bit or you have to compile phantom-js yourself and then replace the binary for your system in the external-tools folder. Instructions on how to compile phantom-js you can find here: http://phantomjs.org/build.html.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File fi1 = new File(String.valueOf(baseDir) + "pdbf.sty").getAbsoluteFile();
        File fi11 = new File(String.valueOf(baseDir) + "dummy.pdf").getAbsoluteFile();
        File fi2 = new File(String.valueOf(latexDir) + "pdbf.sty").getAbsoluteFile();
        File fi22 = new File(String.valueOf(latexDir) + "dummy.pdf").getAbsoluteFile();
        if (!fi1.equals(fi2)) {
            try {
                FileUtils.copyFile(fi1, fi2);
                FileUtils.copyFile(fi11, fi22);
            }
            catch (IOException e3) {
                e3.printStackTrace();
                System.exit(1);
            }
        }
        System.out.println("Compiling LaTeX (1/3)...");
        try {
            ProcessBuilder pb3 = new ProcessBuilder(commands);
            pb3.inheritIO();
            pb3.directory(new File(baseDir));
            Process p3 = pb3.start();
            p3.waitFor();
            if (p3.exitValue() != 0) {
                System.err.println("Latex compiler exited with error!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Error: LaTeX compilation failed! Reason: \n" + e.getMessage());
            System.exit(1);
        }
        PDBFelementContainer[] pdbfElementContainers = new File(String.valueOf(baseDir) + "pdbf-config.json").exists() ? Pre_Compiler.readJSONconfig() : new PDBFelementContainer[]{};
        System.out.println("Generating database...");
        File f = new File(String.valueOf(baseDir) + "pdbf-db.sql");
        File f2 = new File(String.valueOf(baseDir) + "pdbf-db.json");
        if (f.exists() && !f.delete()) {
            System.out.println("pdbf-db.sql could not be deleted! Exiting...");
            System.exit(1);
        }
        if (f2.exists() && !f2.delete()) {
            System.out.println("pdbf-db.json could not be deleted! Exiting...");
            System.exit(1);
        }
        try {
            f.createNewFile();
            f2.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        DatabaseContainer dbc = new DatabaseContainer();
        int i = 0;
        while (i < pdbfElementContainers.length) {
            if (pdbfElementContainers[i].type instanceof Database) {
                Pre_Compiler.processDatabase(pdbfElementContainers[i], dbc);
            }
            ++i;
        }
        try {
            File tmp_f = new File(String.valueOf(baseDir) + "pdbf-db.json");
            FileUtils.writeStringToFile(tmp_f, gson.toJson(dbc), Tools.utf8, true);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        Pre_Compiler.getFinalDatabase();
        int count = 0;
        int i2 = 0;
        while (i2 < pdbfElementContainers.length) {
            if (pdbfElementContainers[i2].type instanceof VisualPDBFelement || pdbfElementContainers[i2].type instanceof TextualPDBFelement) {
                ++count;
            }
            ++i2;
        }
        System.out.println("Generating images, latex tables, and text...\n" + count + " PDBF elements to process");
        int i3 = 0;
        while (i3 < pdbfElementContainers.length) {
            if (pdbfElementContainers[i3].type instanceof VisualPDBFelement && pdbfElementContainers[i3].type.customImage == null) {
                Pre_Compiler.processVisual(pdbfElementContainers[i3]);
            } else if (pdbfElementContainers[i3].type instanceof Text) {
                System.out.println("Finished " + pdbfElementContainers[i3].name);
            } else if (pdbfElementContainers[i3].type instanceof TextualPDBFelement) {
                Pre_Compiler.processData(pdbfElementContainers[i3]);
            }
            if (processes.size() >= Runtime.getRuntime().availableProcessors()) {
                for (Process process : processes) {
                    try {
                        process.waitFor();
                        if (process.exitValue() == 0) continue;
                        System.err.println("Phantomjs exited with error!");
                        for (Process p2 : processes) {
                            p2.destroy();
                        }
                        System.exit(1);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                processes.clear();
            }
            ++i3;
        }
        for (Process p5 : processes) {
            try {
                p5.waitFor();
                if (p5.exitValue() == 0) continue;
                System.err.println("Phantomjs exited with error!");
                for (Process p2 : processes) {
                    p2.destroy();
                }
                System.exit(1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String preload = "";
        for (String string : preloadfiles) {
            String pre = new File(string).getName();
            try {
                preload = String.valueOf(preload) + "var " + pre.substring(0, pre.length() - 5) + " = " + FileUtils.readFileToString(new File(string)) + ";\n";
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileUtils.writeStringToFile(new File(String.valueOf(baseDir) + "pdbf-preload"), preload);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string = "";
        for (String dataTmp : dataFiles) {
            String data = new File(dataTmp).getName();
            try {
                String string2 = String.valueOf(var17_34) + "\\expandafter\\gdef\\csname pdbf@" + data.substring(0, data.length() - 5) + "\\endcsname{" + FileUtils.readFileToString(new File(dataTmp)) + "}\n";
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            File auxfile = new File(String.valueOf(latexPath.substring(0, latexPath.length() - 4)) + ".aux");
            FileUtils.writeStringToFile(auxfile, (String)var17_34, true);
            FileUtils.writeStringToFile(new File(String.valueOf(baseDir) + auxfile.getName()), (String)var17_34, true);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        System.out.println("Compiling LaTeX (2/3)...");
        try {
            pb = new ProcessBuilder(commands);
            pb.inheritIO();
            pb.directory(new File(baseDir));
            p = pb.start();
            ((Process)p).waitFor();
            if (((Process)p).exitValue() != 0) {
                System.err.println("Latex compiler exited with error!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Error: LaTeX compilation failed! Reason: \n" + e.getMessage());
            System.exit(1);
        }
        try {
            FileUtils.moveFile(new File(pdfname), new File(String.valueOf(pdfname.substring(0, pdfname.length() - 4)) + "Embed.pdf"));
        }
        catch (IOException e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        for (String s : copyfiles) {
            File target;
            File source = new File(String.valueOf(s.substring(0, s.length() - 4)) + "Tmp.pdf").getAbsoluteFile();
            if (source.equals(target = new File(String.valueOf(latexDir) + new File(s).getName()).getAbsoluteFile())) continue;
            try {
                FileUtils.copyFile(source, target);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Compiling LaTeX (3/3)...");
        try {
            pb = new ProcessBuilder(commands);
            pb.inheritIO();
            pb.directory(new File(baseDir));
            p = pb.start();
            ((Process)p).waitFor();
            if (((Process)p).exitValue() != 0) {
                System.err.println("Latex compiler exited with error!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Error: LaTeX compilation failed! Reason: \n" + e.getMessage());
            System.exit(1);
        }
        pdbfElementContainers = new File(String.valueOf(baseDir) + "pdbf-config.json").exists() ? Pre_Compiler.readJSONconfig() : new PDBFelementContainer[]{};
        ArrayList<PDBFelementContainer> olist = new ArrayList<PDBFelementContainer>(Arrays.asList(pdbfElementContainers));
        int i32 = olist.size() - 1;
        while (i32 >= 0) {
            if (olist.get((int)i32).type instanceof Database) {
                olist.remove(i32);
            }
            --i32;
        }
        pdbfElementContainers = new PDBFelementContainer[olist.size()];
        pdbfElementContainers = olist.toArray(pdbfElementContainers);
        try {
            String json = gson.toJson(pdbfElementContainers);
            FileUtils.writeStringToFile(new File(String.valueOf(baseDir) + "pdbf-config.json"), json, Tools.utf8);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (String s : cleanupfiles) {
            new File(s).delete();
        }
        if (pdfProtect) {
            System.out.println("Adding write protection to the pdf...");
            try {
                System.setProperty("org.apache.pdfbox.baseParser.pushBackSize", "2024768");
                FileInputStream dataStream = new FileInputStream(new File(pdfname));
                PDDocument doc = PDDocument.load(dataStream);
                ((InputStream)dataStream).close();
                AccessPermission ap = new AccessPermission();
                ap.setCanModify(false);
                ap.setCanExtractContent(true);
                ap.setCanPrint(true);
                ap.setCanPrintDegraded(true);
                ap.setReadOnly();
                StandardProtectionPolicy spp = new StandardProtectionPolicy(UUID.randomUUID().toString(), "", ap);
                doc.protect(spp);
                FileOutputStream out = new FileOutputStream(new File(pdfname));
                doc.save(out);
                doc.close();
                ((OutputStream)out).close();
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.println("Setting write protect to the pdf failed");
                System.exit(1);
            }
        }
    }

    private static PDBFelementContainer[] readJSONconfig() {
        PDBFelementContainer[] pdbfElementContainers = null;
        try {
            String json = FileUtils.readFileToString(new File(String.valueOf(baseDir) + "pdbf-config.json"), Tools.utf8);
            pdbfElementContainers = gson.fromJson(json, PDBFelementContainer[].class);
            String json2 = FileUtils.readFileToString(new File(String.valueOf(baseDir) + "pdbf-dim.json"), Tools.utf8);
            dimOrg = gson.fromJson(json2, Dimension.class);
            int i = 0;
            while (i < pdbfElementContainers.length) {
                PDBFelement v = pdbfElementContainers[i].type;
                if (v instanceof TextualPDBFelement) {
                    PDBFelement t = pdbfElementContainers[i].type;
                    t.x1 /= Pre_Compiler.dimOrg.width;
                    t.x2 /= Pre_Compiler.dimOrg.width;
                    t.y1 = (t.y1 + 65536.0 * t.fontsize) / Pre_Compiler.dimOrg.height;
                    t.y2 /= Pre_Compiler.dimOrg.height;
                } else if (v instanceof VisualPDBFelement) {
                    VisualPDBFelement c = (VisualPDBFelement)pdbfElementContainers[i].type;
                    c.x1 /= Pre_Compiler.dimOrg.width;
                    c.x2 /= Pre_Compiler.dimOrg.width;
                    c.y1 /= Pre_Compiler.dimOrg.height;
                    c.y2 /= Pre_Compiler.dimOrg.height;
                }
                if (!(v instanceof Database)) {
                    v.quality *= 4.0;
                    if (v.aggregationattributeBig.equals("")) {
                        v.aggregationattributeBig = v.aggregationattribute;
                    }
                    if (v.aggregationBig.equals("")) {
                        v.aggregationBig = v.aggregation;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pdbfElementContainers == null) {
            System.err.println("Error: Deserialization failed!");
            System.exit(1);
        }
        return pdbfElementContainers;
    }

    /*
     * Unable to fully structure code
     */
    private static void processDatabase(PDBFelementContainer pdbfElementContainer, DatabaseContainer dbc) {
        try {
            db = (Database)pdbfElementContainer.type;
            f = new File(String.valueOf(Pre_Compiler.baseDir) + "pdbf-db.sql");
            alasql = dbc.alasql;
            switch (db.type) {
                case 1: {
                    FileUtils.writeStringToFile(f, String.valueOf(db.value1) + System.lineSeparator(), Tools.utf8, true);
                    break;
                }
                case 2: {
                    inF = new File(db.value1);
                    if (!inF.isAbsolute()) {
                        inF = new File(String.valueOf(Pre_Compiler.latexFolder) + File.separator + db.value1);
                    }
                    in = FileUtils.readFileToString(inF, Tools.utf8);
                    FileUtils.writeStringToFile(f, String.valueOf(in) + System.lineSeparator(), Tools.utf8, true);
                    break;
                }
                case 3: {
                    Class.forName("org.mariadb.jdbc.Driver");
                    Class.forName("org.postgresql.Driver");
                    conn = DriverManager.getConnection(db.value1, db.value2, db.value3);
                    stok = new StringTokenizer(db.value4, ",");
                    while (stok.hasMoreTokens()) {
                        table = new Table();
                        curTable = stok.nextToken().trim();
                        if (alasql.containsTable(curTable)) {
                            System.err.println("Error: Database already contains a table with name \"" + curTable + "\"");
                            System.exit(1);
                        }
                        try {
                            stmt = conn.createStatement();
                            rs = stmt.executeQuery("SELECT * FROM \"" + curTable + "\"");
                            rsmd = rs.getMetaData();
                            cols = rsmd.getColumnCount();
                            i = 1;
                            while (i <= cols) {
                                table.columns.add(new Column(rsmd.getColumnName(i), rsmd.getColumnTypeName(i).toUpperCase()));
                                ++i;
                            }
                            if (cols > 0) {
                                while (rs.next()) {
                                    data = new Object[cols];
                                    i = 1;
                                    while (i <= cols) {
                                        data[i - 1] = rs.getObject(i);
                                        ++i;
                                    }
                                    table.data.add(new Data(data));
                                }
                            }
                            rs.close();
                            alasql.addTable(table, curTable);
                        }
                        catch (PSQLException e) {
                            System.err.println(e.getMessage());
                            System.exit(1);
                        }
                    }
                    conn.close();
                    break;
                }
                case 4: {
                    csvData = new File(db.value1);
                    if (!csvData.isAbsolute()) {
                        csvData = new File(String.valueOf(Pre_Compiler.latexFolder) + File.separator + db.value1);
                    }
                    csvformat = CSVFormat.RFC4180.withDelimiter(db.seperator).withQuote(db.quote);
                    csvformat = db.headers.length > 0 ? csvformat.withHeader(db.headers) : csvformat.withHeader(new String[0]);
                    parser = CSVParser.parse(csvData, Tools.utf8, csvformat);
                    table = new Table();
                    curTable = db.value2;
                    if (alasql.containsTable(curTable)) {
                        System.err.println("Error: Database already contains a table with name \"" + curTable + "\"");
                        System.exit(1);
                    }
                    cols = parser.getHeaderMap().size();
                    csvRecords = parser.getRecords();
                    types = new ArrayList<String>();
                    i = 0;
                    while (i < cols) {
                        isParsable = true;
                        for (CSVRecord csvRecord : csvRecords) {
                            cur = csvRecord.get(i);
                            try {
                                Double.parseDouble(cur);
                            }
                            catch (NumberFormatException e) {
                                if (cur.toLowerCase().equals("null")) continue;
                                isParsable = false;
                                break;
                            }
                        }
                        if (isParsable) {
                            types.add("FLOAT");
                        } else {
                            isParsable = true;
                            for (CSVRecord csvRecord : csvRecords) {
                                cur = csvRecord.get(i).toLowerCase();
                                if (cur.equals("true") || cur.equals("false") || cur.equals("null")) continue;
                                isParsable = false;
                                break;
                            }
                            if (isParsable) {
                                types.add("BOOLEAN");
                            } else {
                                isParsable = true;
                                for (CSVRecord csvRecord : csvRecords) {
                                    cur = csvRecord.get(i);
                                    try {
                                        new Date(cur);
                                    }
                                    catch (IllegalArgumentException e) {
                                        if (cur.toLowerCase().equals("null")) continue;
                                        isParsable = false;
                                        break;
                                    }
                                }
                                if (isParsable) {
                                    types.add("TIMESTAMP");
                                } else {
                                    isParsable = true;
                                    types.add("STRING");
                                }
                            }
                        }
                        ++i;
                    }
                    tmp = 0;
                    for (String colname : parser.getHeaderMap().keySet()) {
                        table.columns.add(new Column(colname, (String)types.get(tmp++)));
                    }
                    if (cols <= 0) ** GOTO lbl171
                    for (CSVRecord csvRecord : csvRecords) {
                        data = new Object[cols];
                        i = 0;
                        while (i < cols) {
                            cur = csvRecord.get(i);
                            if (!cur.toLowerCase().equals("null")) ** GOTO lbl135
                            data[i] = null;
                            ** GOTO lbl166
lbl135:
                            // 1 sources

                            var23_41 = (String)types.get(i);
                            tmp = -1;
                            switch (var23_41.hashCode()) {
                                case -1453246218: {
                                    if (var23_41.equals("TIMESTAMP")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                                case 66988604: {
                                    if (var23_41.equals("FLOAT")) {
                                        tmp = 2;
                                    }
                                    break;
                                }
                                case 782694408: {
                                    if (var23_41.equals("BOOLEAN")) {
                                        tmp = 3;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 2: {
                                    data[i] = Double.parseDouble(cur);
                                    break;
                                }
                                case 3: {
                                    data[i] = Boolean.parseBoolean(cur);
                                    break;
                                }
                                case 1: {
                                    data[i] = new Date(cur);
                                    break;
                                }
                                default: {
                                    data[i] = cur;
                                }
                            }
lbl166:
                            // 5 sources

                            ++i;
                        }
                        table.data.add(new Data(data));
                    }
lbl171:
                    // 2 sources

                    alasql.addTable(table, curTable);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processVisual(PDBFelementContainer o) {
        if (PDBF_Compiler.includeRes) {
            VisualPDBFelement c = (VisualPDBFelement)o.type;
            cleanupfiles.add(String.valueOf(baseDirData) + o.name + ".html");
            cleanupfiles.add(String.valueOf(baseDir) + o.name + ".json");
            preloadfiles.add(String.valueOf(baseDir) + o.name + ".json");
            copyfiles.add(String.valueOf(baseDir) + o.name + ".pdf");
            String a = new File(arg0).getName();
            String filename = a.substring(0, a.length() - 4);
            String pdfname = String.valueOf(baseDir) + filename + ".pdf";
            try {
                Dimension dim = new Dimension(Pre_Compiler.dimOrg.width * c.quality, Pre_Compiler.dimOrg.height * c.quality);
                String viewerHEAD = FileUtils.readFileToString(new File(String.valueOf(baseDirData) + "template-head-images.html"), Tools.utf8);
                String viewerTAIL = FileUtils.readFileToString(new File(String.valueOf(baseDirData) + "template-tail-images.html"), Tools.utf8);
                String viewer = String.valueOf(viewerHEAD) + "pdf_base64 = \"" + Tools.encodeFileToBase64Binary(new File(pdfname)) + "\";\r\n" + "dim_base64 = \"" + Tools.encodeStringToBase64Binary(gson.toJson(dim)) + "\";\r\n" + "json_base64 = \"" + Tools.encodeStringToBase64Binary(gson.toJson(o)) + "\";\r\n" + "db_base64 = \"\";\r\n" + "dbjson_base64 = \"" + Tools.escapeSpecialChars(new File(String.valueOf(baseDir) + "pdbf-db.json")) + "\";\r\n" + viewerTAIL;
                FileUtils.writeStringToFile(new File(String.valueOf(baseDirData) + o.name + ".html"), viewer, Tools.utf8);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ProcessBuilder pb = new ProcessBuilder(String.valueOf(baseDir) + "external-tools" + File.separator + "phantomjs-" + suffix, String.valueOf(baseDir) + "external-tools" + File.separator + "capture.js", String.valueOf(o.name) + ".html", baseDirData, "" + dpiScalingFactor);
                pb.inheritIO();
                Process p = pb.start();
                processes.add(p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                FileUtils.copyFile(new File(String.valueOf(baseDir) + "dummy.pdf"), new File(String.valueOf(baseDir) + o.name + ".pdf"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void processData(PDBFelementContainer o) {
        PDBFelement c = o.type;
        cleanupfiles.add(String.valueOf(baseDirData) + o.name + ".html");
        cleanupfiles.add(String.valueOf(baseDir) + o.name + ".data");
        dataFiles.add(String.valueOf(baseDir) + o.name + ".data");
        try {
            Dimension dim = new Dimension(Pre_Compiler.dimOrg.width * c.quality, Pre_Compiler.dimOrg.height * c.quality);
            String viewerHEAD = FileUtils.readFileToString(new File(String.valueOf(baseDirData) + "template-head-images.html"), Tools.utf8);
            String viewerTAIL = FileUtils.readFileToString(new File(String.valueOf(baseDirData) + "template-tail-images.html"), Tools.utf8);
            String viewer = String.valueOf(viewerHEAD) + "dim_base64 = \"" + Tools.encodeStringToBase64Binary(gson.toJson(dim)) + "\";\r\n" + "json_base64 = \"" + Tools.encodeStringToBase64Binary(gson.toJson(o)) + "\";\r\n" + "db_base64 = \"\";\r\n" + "dbjson_base64 = \"" + Tools.escapeSpecialChars(new File(String.valueOf(baseDir) + "pdbf-db.json")) + "\";\r\n" + viewerTAIL;
            FileUtils.writeStringToFile(new File(String.valueOf(baseDirData) + o.name + ".html"), viewer, Tools.utf8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(String.valueOf(baseDir) + "external-tools" + File.separator + "phantomjs-" + suffix, String.valueOf(baseDir) + "external-tools" + File.separator + "captureData.js", String.valueOf(o.name) + ".html", baseDirData);
            pb.inheritIO();
            Process p = pb.start();
            processes.add(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getFinalDatabase() {
        cleanupfiles.add(String.valueOf(baseDirData) + "pdbfDatabase.html");
        try {
            Dimension dim = new Dimension(1.0, 1.0);
            String viewerHEAD = FileUtils.readFileToString(new File(String.valueOf(baseDirData) + "template-head-images.html"), Tools.utf8);
            String viewerTAIL = FileUtils.readFileToString(new File(String.valueOf(baseDirData) + "template-tail-images.html"), Tools.utf8);
            String viewer = String.valueOf(viewerHEAD) + "dim_base64 = \"" + Tools.encodeStringToBase64Binary(gson.toJson(dim)) + "\";\r\n" + "json_base64 = \"eyAidHlwZSIgOiB7ICJJIiA6IHsgIngxIiA6IDEsICJ4MiIgOiAyLCAieTEiIDogMywgInkyIiA6IDQgfSB9IH0=\";\r\n" + "db_base64 = \"" + Tools.encodeFileToBase64Binary(new File(String.valueOf(baseDir) + "pdbf-db.sql")) + "\";\r\n" + "dbjson_base64 = \"" + Tools.escapeSpecialChars(new File(String.valueOf(baseDir) + "pdbf-db.json")) + "\";\r\nvar notCompressed = true;\r\n" + viewerTAIL;
            FileUtils.writeStringToFile(new File(String.valueOf(baseDirData) + "pdbfDatabase.html"), viewer, Tools.utf8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(String.valueOf(baseDir) + "external-tools" + File.separator + "phantomjs-" + suffix, String.valueOf(baseDir) + "external-tools" + File.separator + "captureDatabase.js", "pdbfDatabase.html", baseDirData);
            pb.inheritIO();
            Process p = pb.start();
            p.waitFor();
            if (p.exitValue() != 0) {
                System.err.println("Phantomjs exited with error!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

