/*
 * File: pssplit.c
 *
 * (c) Peter Kleiweg 1998
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifdef __MSDOS__
#define strcasecmp(A, B) (stricmp(A, B))
#endif

#define BUFSIZE 2048

char
    buffer [BUFSIZE + 1],
    *programname;

void
    syntax (void),
    errit (char const *format, ...);

int main (int argc, char *argv [])
{
    FILE
        *fp;
    int
        page = 0,
        prpage = 0,
        doclevel = 0,
        trailer = 0,
        even = 0,
        odd = 0,
        beginpage,
        endpage,
        retval = 1;

    programname = argv [0];

    if (argc != 5)
        syntax ();

    beginpage = atoi (argv [2]);
    endpage = atoi (argv [3]);
    if (beginpage < 1 || endpage < beginpage)
        syntax ();

    if (! strcasecmp (argv [4], "all")) {
        even = 1;
        odd = 1;
    } else if (! strcasecmp (argv [4], "even"))
        even = 1;
    else if (! strcasecmp (argv [4], "odd"))
        odd = 1;
    else
        syntax ();

    fp = fopen (argv [1], "r");
    if (! fp)
	errit ("Opening file \"%s\": %s", argv [1], strerror (errno));

    while (fgets (buffer, BUFSIZE, fp)) {
        if (! memcmp (buffer, "%%Page:", 7)) {
            if (! doclevel) {
                page++;
                prpage = (
                    page >= beginpage && page <= endpage
                 && ((odd && (page % 2)) || (even && ! (page % 2)))
                );
                if (prpage) {
                    retval = 0;
                    fputs (buffer, stderr);
                }
            }
        } else if (! memcmp (buffer, "%%BeginDocument", 15))
            doclevel++;
        else if (! memcmp (buffer, "%%EndDocument", 13))
            doclevel--;
        else if (! memcmp (buffer, "%%Trailer", 9)) {
            if (! doclevel)
                trailer = 1;
        }

	if ((page == 0) || prpage || trailer)
            fputs (buffer, stdout);
    }

    fclose (fp);

    if (retval)
        fprintf (stderr, "\n%s: No pages found\n\n", programname);
    
    return retval;
}

void errit (char const *format, ...)
{
    va_list
	list;

    fprintf (stderr, "\nError %s: ", programname);

    va_start (list, format);
    vfprintf (stderr, format, list);

    fprintf (stderr, "\n\n");

    exit (2);
}

void syntax ()
{
    fprintf (
	stderr,
	"\nUsage: %s file.ps beginpage endpage all|even|odd\n"
	"Return value:\n"
	"\t0 - ok\n"
	"\t1 - no pages found\n"
	"\t2 - error\n",
	programname
    );
    exit (2);
}
