/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "initial.h"
#include "str_fun.h"
#include "refs.h"
#include "interf.h"
#include "fl_ut.h"

#define LOG_DATEI_NAME "refs.log" 

// #if defined(REFS_USES_MINGW)
//   #define REFS_CFG_NAME "refs.cfg"
// #endif
// #if defined(REFS_USES_LINUXGCC)
//   #define REFS_CFG_NAME ".refscfg"
// #endif


// #define REFSRUN_DOLLAR "refsrun.$"

 extern char cfgpfad[PFAD_LEN+1];
 /* current working directory */
 extern char textpfad[PFAD_LEN+1];
 /* the ..\rdb directory below the current working directory  */
 extern char rdbpfad[PFAD_LEN+1];
 extern char wrtxtbu[WRTXTBU_LEN+1];
 extern config_set one_config_set;
 

 extern char journal_pix_name[PFAD_LEN+1];
 extern char journal_name[PFAD_LEN+1];
 extern char desc_name[PFAD_LEN+1];
 extern char book_name[PFAD_LEN+1];
 extern char autorjl_name[PFAD_LEN+1];
 extern char autorbu_name[PFAD_LEN+1];
 extern char quell_pix_name[PFAD_LEN+1];
 extern char quell_name[PFAD_LEN+1];
 extern char stichw_name[PFAD_LEN+1];
 extern char stichw_pix_name[PFAD_LEN+1];
 extern char abstr_pix_name[PFAD_LEN+1];
 extern char abstr_dat_name[PFAD_LEN+1];
 extern char formdef_name[PFAD_LEN+1];
 extern char log_name[PFAD_LEN+1];
 extern char tempt_name[PFAD_LEN+1];
 extern char cfg_name[PFAD_LEN+1];
 extern char refsrun_name[PFAD_LEN+1];

 extern char dir_kat_name[PFAD_LEN+1];
 extern char abst_text_temp[PFAD_LEN+1];
 extern char kennziff_temp_name[PFAD_LEN+1];

 extern FILE * fplog;
 extern FILE * fptemptext;

 
int initialisieren(void)
{
  char * ep;

  /* Assertions */
  assert(KUERZEL_LEN==QUELLKUERZEL_LEN);
  
  /* Initializations */
#if defined(REFS_USES_MINGW)
  ep = getenv("REFS_CFG_PATH");
  if (ep!=NULL)
  {
     strlimcpy(cfgpfad,ep,PFAD_LEN);
  } else
  {
    strcpy(cfgpfad,"c:\\refs43\\bin\\");
  }
  rtrim(cfgpfad,'\\');
  rtrim(cfgpfad,'/');
  strlimcat(cfgpfad,"\\",PFAD_LEN);

  strlimcpy(cfg_name,cfgpfad,PFAD_LEN);
  strlimcat(cfg_name,REFS_CFG_NAME,PFAD_LEN);

  aktuelles_verzeichnis(textpfad);
  strcpy(rdbpfad,textpfad);
  strlimcat(rdbpfad,"rdb\\",PFAD_LEN);
#endif
#if defined(REFS_USES_LINUXGCC)
  ep = getenv("HOME");
  if (ep!=NULL)
  {
     strlimcpy(cfgpfad,ep,PFAD_LEN);
     strlimcat(cfgpfad,"/",PFAD_LEN);
  } else
  {
     // strcpy(cfgpfad,ep);
     wrtxt("\nProblem: cannot find configuration file!\n");
  }
  strlimcpy(cfg_name,cfgpfad,PFAD_LEN);
  strlimcat(cfg_name,REFS_CFG_NAME,PFAD_LEN);
  aktuelles_verzeichnis(textpfad);
  strcpy(rdbpfad,textpfad);
  strlimcat(rdbpfad,"rdb/",PFAD_LEN);
#endif
//// hier weiter 
  /* file names */
  strlimcpy(journal_pix_name,rdbpfad,PFAD_LEN);
  strlimcat(journal_pix_name,"journal.ix",PFAD_LEN);
  /* wrtxt(journal_pix_name); wrtxt("\n"); */

  strlimcpy(journal_name,rdbpfad,PFAD_LEN);
  strlimcat(journal_name,"journal.dat",PFAD_LEN);
  /* wrtxt(journal_name); wrtxt("\n"); */

  strlimcpy(desc_name,rdbpfad,PFAD_LEN);
  strlimcat(desc_name,"desc.dat",PFAD_LEN);
  /* wrtxt(desc_name); wrtxt("\n"); */

  strlimcpy(book_name,rdbpfad,PFAD_LEN);
  strlimcat(book_name,"book.dat",PFAD_LEN);
  /* wrtxt(book_name); wrtxt("\n"); */

  strlimcpy(autorjl_name,rdbpfad,PFAD_LEN);
  strlimcat(autorjl_name,"autorjl.dat",PFAD_LEN);
  /* wrtxt(autorjl_name); wrtxt("\n"); */

  strlimcpy(autorbu_name,rdbpfad,PFAD_LEN);
  strlimcat(autorbu_name,"autorbo.dat",PFAD_LEN);
  /* wrtxt(autorbu_name); wrtxt("\n"); */

  strlimcpy(quell_pix_name,rdbpfad,PFAD_LEN);
  strlimcat(quell_pix_name,"source.ix",PFAD_LEN);
  /* wrtxt(quell_pix_name); wrtxt("\n"); */

  strlimcpy(quell_name,rdbpfad,PFAD_LEN);
  strlimcat(quell_name,"source.dat",PFAD_LEN);
  /* wrtxt(quell_name); wrtxt("\n"); */

  strlimcpy(stichw_pix_name,rdbpfad,PFAD_LEN);
  strlimcat(stichw_pix_name,"keyw.ix",PFAD_LEN);
  /* wrtxt(stichw_pix_name); wrtxt("\n"); */

  strlimcpy(stichw_name,rdbpfad,PFAD_LEN);
  strlimcat(stichw_name,"keyw.dat",PFAD_LEN);
  /* wrtxt(stichw_name); wrtxt("\n"); */

  strlimcpy(abstr_pix_name,rdbpfad,PFAD_LEN);
  strlimcat(abstr_pix_name,"abst.ix",PFAD_LEN);
  /* wrtxt(abstr_pix_name); wrtxt("\n"); */

  strlimcpy(abstr_dat_name,rdbpfad,PFAD_LEN);
  strlimcat(abstr_dat_name,"abst.dat",PFAD_LEN);
  /* wrtxt(abstr_dat_name); wrtxt("\n"); */
  
  strlimcpy(formdef_name,rdbpfad,PFAD_LEN);
  strlimcat(formdef_name,"formdef.dat",PFAD_LEN);
  /* wrtxt(formdef_name); wrtxt("\n"); */
  
  strlimcpy(dir_kat_name,rdbpfad,PFAD_LEN);
  strlimcat(dir_kat_name,"dir_kat.$$1",PFAD_LEN);
  /*    wrtxt(dir_kat_name); wrtxt("\n"); */
  
  strlimcpy(abst_text_temp,rdbpfad,PFAD_LEN);
  strlimcat(abst_text_temp,"ABSTRACT.TMP",PFAD_LEN);
  /*    wrtxt(abst_text_temp); wrtxt("\n"); */

  strlimcpy(kennziff_temp_name,rdbpfad,PFAD_LEN);
  strlimcat(kennziff_temp_name,"R_KEY.T",PFAD_LEN);
  /*    wrtxt(kennziff_temp_name); wrtxt("\n"); */
  
  strlimcpy(log_name,textpfad,PFAD_LEN);
  strlimcat(log_name,LOG_DATEI_NAME,PFAD_LEN);
  /*    wrtxt(log_name); wrtxt("\n"); */
  
#if defined(REFS_USES_MINGW)
  // strlimcpy(refsrun_name,cfgpfad,PFAD_LEN);
  strlimcpy(refsrun_name,".\\",PFAD_LEN);
#endif
#if defined(REFS_USES_LINUXGCC)
  strlimcpy(refsrun_name,"./",PFAD_LEN);
#endif
  strlimcat(refsrun_name,REFSRUN_DOLLAR,PFAD_LEN);

  return 1;
}

int weiter_initialisieren(void)
{
  strlimcpy(tempt_name,textpfad,PFAD_LEN);
  strlimcat(tempt_name,one_config_set.temptext_name,PFAD_LEN);
  /* dateien_und_pfade_anzeigen(); */

  return 1;
}



int cfg_datei_lesen(void)
{
   FILE * fpcfg;
   char zeile[CFG_ZEILE_LEN+4];
   char ex_zeile[CFG_ZEILE_LEN+4];
   /* char exex_zeile[CFG_ZEILE_LEN+4]; */
   int ok;
   long zahl;

#if defined(REFS_USES_MINGW)
   strcpy(one_config_set.prompt,": ");
   strcpy(one_config_set.editor_name,"notepad.exe");
   strcpy(one_config_set.awk_name,"c:\\refs43\\bin\\awk.exe");
   strcpy(one_config_set.path_to_scripts,"c:\\refs43\\bin\\");
   strcpy(one_config_set.help_file,"..\\doc\\refsdok.pdf");
#endif   
#if defined(REFS_USES_LINUXGCC)
   strcpy(one_config_set.prompt,": ");
   strcpy(one_config_set.editor_name,"vim");
   strcpy(one_config_set.awk_name,"awk");
   strcpy(one_config_set.path_to_scripts,"../bin/");
   strcpy(one_config_set.help_file,"../doc/refsdok.pdf");
#endif   
   strcpy(one_config_set.form_name,"in_form.txt");
   strcpy(one_config_set.ky_form_name,"ky_form.txt");
   strcpy(one_config_set.jn_form_name,"jn_form.txt");
   strcpy(one_config_set.search_form_name,"sr_form.txt");
   // strcpy(one_config_set.fdef_form_name,"fd_form.txt");
   strcpy(one_config_set.form_label,"----");
   strcpy(one_config_set.temptext_name,"temp.txt");
#if defined(REFS_USES_MINGW)
   strcpy(one_config_set.pdf_viewer,"");
   one_config_set.sl = 25;
#endif
#if defined(REFS_USES_LINUXGCC)
   one_config_set.sl = 24;
   strcpy(one_config_set.pdf_viewer,"xpdf");
#endif

   one_config_set.open_editor_yn = 0;
#if defined(REFS_USES_MINGW)
   strcpy(one_config_set.textfile_encoding,"");
#endif   
#if defined(REFS_USES_LINUXGCC)
   strcpy(one_config_set.textfile_encoding,ENC_UTF8);
#endif
#if defined(REFS_USES_LINUXGCC)
   one_config_set.uses_less=0;
   strlimcpy(one_config_set.less_options,"",PFAD_LEN);
   strlimcpy(one_config_set.enable_hl,"0",ENABLE_HL_LEN);
#endif
   
   if ((fpcfg=fopen(cfg_name,"r"))==NULL)
   {
     wrtxt("\nProblem: cannot read configuration file\n");
     return 0;
   }
   while ((fgets(zeile,CFG_ZEILE_LEN,fpcfg)!=NULL))
   {
     zahl = 0;
     rtrim(zeile,'\n');
     trim(zeile,' ');
     return_uncommented_portion(ex_zeile,zeile,'#');
     strcpy(zeile,ex_zeile);
     extractitem(1,zeile,"=",ex_zeile);
     upper(ex_zeile);
     if (strcmp(ex_zeile,"LINES_OF_SCREEN")==0)
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
            string_in_long(ex_zeile,&zahl,&ok);
            if (ok)
            {
               if (zahl < 24 || zahl > 90)
               {
                  one_config_set.sl=24;
               }
               else
               {
                  one_config_set.sl=zahl;
               }
            }
        }
     }
     if (strcmp(ex_zeile,"OPEN_EDITOR_YN")==0)
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
            string_in_long(ex_zeile,&zahl,&ok);
            if (ok)
            {
               one_config_set.open_editor_yn=zahl;
            }
        }
     }

#if defined(REFS_USES_LINUXGCC)
     if (strcmp(ex_zeile,"TEXTFILE_ENCODING")==0)
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           if (strcmp(ex_zeile,"LATIN-1")==0)
           {
              strlimcpy(one_config_set.textfile_encoding,ENC_ISO8859,
                 TEXTFILE_ENCODING_LEN);
           }
           if (strcmp(ex_zeile,"LATIN1")==0)
           {
              strlimcpy(one_config_set.textfile_encoding,ENC_ISO8859,
                 TEXTFILE_ENCODING_LEN);
           }
           if (strcmp(ex_zeile,"LATIN-9")==0)
           {
              strlimcpy(one_config_set.textfile_encoding,ENC_ISO8859,
                 TEXTFILE_ENCODING_LEN);
           }
           if (strcmp(ex_zeile,"LATIN9")==0)
           {
              strlimcpy(one_config_set.textfile_encoding,ENC_ISO8859,
                 TEXTFILE_ENCODING_LEN);
           }
           if (strcmp(ex_zeile,ENC_ISO8859)==0)
           {
              strlimcpy(one_config_set.textfile_encoding,ENC_ISO8859,
                 TEXTFILE_ENCODING_LEN);
           }
        }
     }
#endif
     if (!strcmp(ex_zeile,"PROMPT"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           trim(ex_zeile,'\"');
           strlimcpy(one_config_set.prompt,ex_zeile,PROMPT_LEN);
        }
     }
     if (!strcmp(ex_zeile,"TEXT_EDITOR"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           // trim(ex_zeile,'\"');
           strlimcpy(one_config_set.editor_name,ex_zeile,PFAD_LEN);
        }
     }
     if (!strcmp(ex_zeile,"PATH_TO_SCRIPTS"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           rtrim(ex_zeile,'\\');
           rtrim(ex_zeile,'/');
#if defined(REFS_USES_MINGW)
           strlimcat(ex_zeile,"\\",PFAD_LEN); 
#endif
#if defined(REFS_USES_LINUXGCC)
           strlimcat(ex_zeile,"/",PFAD_LEN); 
#endif
           strlimcpy(one_config_set.path_to_scripts,ex_zeile,PFAD_LEN);
        }
     }
     if (!strcmp(ex_zeile,"AWK"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           strlimcpy(one_config_set.awk_name,ex_zeile,PFAD_LEN);
        }
     }
     if (!strcmp(ex_zeile,"INPUT_FORM"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           // trim(ex_zeile,'\"');
           strlimcpy(one_config_set.form_name,ex_zeile,PFAD_LEN);
        }
     }
     if (!strcmp(ex_zeile,"KEYW_FORM"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           // trim(ex_zeile,'\"');
           if (isvalidfilename2(ex_zeile))
           {
             strlimcpy(one_config_set.ky_form_name,ex_zeile,PFAD_LEN);
           } else
           {
              wrtxt("\n*** Warning: No valid file name for KEYW_FORM\n");
              // wrtxt(ex_zeile);
           }
        }
     }
     if (!strcmp(ex_zeile,"JOURN_FORM"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           // trim(ex_zeile,'\"');
           strlimcpy(one_config_set.jn_form_name,ex_zeile,PFAD_LEN);
        }
     }
     if (!strcmp(ex_zeile,"SEARCH_FORM"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           strlimcpy(one_config_set.search_form_name,ex_zeile,PFAD_LEN);
        }
     }
     if (!strcmp(ex_zeile,"FORM_LABEL"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        trim(ex_zeile,'\"');
        if (strlen(ex_zeile)>0)
        {
           strlimcpy(one_config_set.form_label,ex_zeile,FORM_LABEL_LEN);
        }
     }
     if (!strcmp(ex_zeile,"PDF_VIEWER"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        /* trim(ex_zeile,'\"'); */
        if (strlen(ex_zeile)>0)
        {
           strlimcpy(one_config_set.pdf_viewer,ex_zeile,PFAD_LEN);
        }
     }
     if (!strcmp(ex_zeile,"HELP_FILE"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        /* trim(ex_zeile,'\"'); */
        if (strlen(ex_zeile)>0)
        {
           strlimcpy(one_config_set.help_file,ex_zeile,PFAD_LEN);
        }
     }
     if (!strcmp(ex_zeile,"TEMP_TEXT"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        if (strlen(ex_zeile)>0)
        {
           strlimcpy(one_config_set.temptext_name,ex_zeile,PFAD_LEN);
        }
     }
#if defined(REFS_USES_LINUXGCC)
     if (!strcmp(ex_zeile,"USES_LESS"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        trim(ex_zeile,' ');
        if (strcmp(ex_zeile,"1")==0)
        {
           one_config_set.uses_less=1;
        }
     }
     if (!strcmp(ex_zeile,"LESS_OPTIONS"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        trim(ex_zeile,' ');
        if (strlen(ex_zeile)>0)
        {
           strlimcpy(one_config_set.less_options,ex_zeile,PFAD_LEN);
        }
     }
     if (!strcmp(ex_zeile,"ENABLE_HL"))
     {
        extractitem(2,zeile,"=",ex_zeile);
        trim(ex_zeile,' ');
        if (strlen(ex_zeile)>0)
        {
           strlimcpy(one_config_set.enable_hl,ex_zeile,ENABLE_HL_LEN);
        }
     }
#endif
   } /* while ((fgets(zeile,CFG_ZEILE_LEN,fpcfg)!=NULL)) */
   
   fclose(fpcfg);
#if defined(REFS_USES_LINUXGCC)
   if (strlen(one_config_set.textfile_encoding)>0)
   {
      sprintf(wrtxtbu,"\n(Encoding of text files: %s)\n",
          one_config_set.textfile_encoding);
      wrtxt(wrtxtbu);
   }
#endif    
   return 0;
}

int logdatei_oeffnen(void)
{
   if ((fplog=fopen(log_name,"a"))==NULL)
   {
     return 0;
   }
   return 1;
}

int logdatei_schliessen(void)
{
   fclose(fplog);
   return 1;
}

int logdatei_schreiben(char * text)
{
   char textkopie[WRTXTBU_LEN + 1];

   strlimcpy(textkopie,text,WRTXTBU_LEN);
   trim(textkopie,'\n');
   fprintf(fplog,"\n%s",textkopie); 
   return 1;
}

int protokollieren(char * text)
{
  logdatei_oeffnen();
  logdatei_schreiben(text);
  logdatei_schliessen();
  return 1;
}

int temptextdatei_oeffnen(void)
{
   if ((fptemptext=fopen(tempt_name,"w"))==NULL)
   {
     return 0;
   }
   return 1;
}

int temptextdatei_schliessen(void)
{
   fclose(fptemptext);
   return 1;
}

int temptextdatei_schreiben(char * text)
{
   fprintf(fptemptext,"%s",text); 
   return 1;
}

void dateien_und_pfade_anzeigen(void)
{
  wrtxt("\nCURRENT WORKING DIRECTORIES AND FILES:\n\n"); 
  wrtxt("Configuration-file:  `");
  wrtxt(cfg_name);
  wrtxt("'\n");
  wrtxt("Text file directory: `");
  wrtxt(textpfad);
  wrtxt("'\n");
  wrtxt("Database directory:  `");
  wrtxt(rdbpfad);
  wrtxt("'\n");
  /* */
  wrtxt("AWK script directory `");
  wrtxt(one_config_set.path_to_scripts);
  wrtxt("'\n");
  wrtxt("AWK executable       `");
  wrtxt(one_config_set.awk_name);
  wrtxt("'\n");
  wrtxt("Text editor          `");
  wrtxt(one_config_set.editor_name);
  wrtxt("'\n");
  /* */
  wrtxt("Form for references: `");
  wrtxt(one_config_set.form_name);
  wrtxt("'\n");
  wrtxt("Form for keywords:   `");
  wrtxt(one_config_set.ky_form_name);
  wrtxt("'\n");
  wrtxt("Journal names form:  `");
  wrtxt(one_config_set.jn_form_name);
  wrtxt("'\n");
  wrtxt("Search commands:     `");
  wrtxt(one_config_set.search_form_name);
  wrtxt("'\n");
  wrtxt("Lines of screen:     `");
  sprintf(wrtxtbu,"%i",one_config_set.sl);
  wrtxt(wrtxtbu);
  wrtxt("'\n");

  return;
}
