/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.bibeditor.AbbrevManager;
import net.sourceforge.texlipse.bibeditor.BibEditor;
import net.sourceforge.texlipse.bibparser.BibOutlineContainer;
import net.sourceforge.texlipse.bibparser.BibParser;
import net.sourceforge.texlipse.editor.TexDocumentParseException;
import net.sourceforge.texlipse.model.MarkerHandler;
import net.sourceforge.texlipse.model.ParseErrorMessage;
import net.sourceforge.texlipse.model.ReferenceContainer;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class BibDocumentModel {
    private BibEditor editor;
    private List entryList;
    private List abbrevs;
    private AbbrevManager abbrManager;
    private ReferenceContainer bibContainer;

    public BibDocumentModel(BibEditor editor) {
        this.editor = editor;
        this.abbrManager = new AbbrevManager();
    }

    public AbbrevManager getAbbrManager() {
        return this.abbrManager;
    }

    private void doParse() throws TexDocumentParseException {
        try {
            BibParser parser = new BibParser(new StringReader(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get()));
            this.entryList = parser.getEntries();
            List<ParseErrorMessage> parseErrors = parser.getErrors();
            List parseWarnings = parser.getWarnings();
            List tasks = parser.getTasks();
            MarkerHandler marker = MarkerHandler.getInstance();
            marker.clearErrorMarkers((ITextEditor)this.editor);
            if (parseErrors.size() > 0) {
                marker.createErrorMarkers((ITextEditor)this.editor, parseErrors);
                throw new TexDocumentParseException("Fatal errors in file");
            }
            if (parseWarnings.size() > 0) {
                marker.createErrorMarkers((ITextEditor)this.editor, parseWarnings);
            }
            if (tasks.size() > 0) {
                marker.createTaskMarkers((ITextEditor)this.editor, tasks);
            }
            this.abbrevs = parser.getAbbrevs();
        }
        catch (IOException e) {
            TexlipsePlugin.log("Can't read file.", e);
            throw new TexDocumentParseException(e);
        }
    }

    private void updateAbbrManager() {
        Object[] esar = new ReferenceEntry[this.abbrevs.size()];
        this.abbrevs.toArray(esar);
        Arrays.sort(esar);
        this.abbrManager.setAbbrevs((ReferenceEntry[])esar);
    }

    private void updateBibContainer() {
        boolean changed;
        IProject project = this.editor.getProject();
        if (project == null) {
            return;
        }
        IFile resource = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        if (this.bibContainer == null) {
            ReferenceContainer refCon = (ReferenceContainer)TexlipseProperties.getSessionProperty((IResource)project, "bibContainer");
            if (refCon != null) {
                this.bibContainer = refCon;
            } else {
                return;
            }
        }
        if (changed = this.bibContainer.updateRefSource(resource.getFullPath().removeFirstSegments(1).toString(), this.entryList)) {
            TexlipseProperties.setSessionProperty((IResource)project, "bibFilesChanged", new Boolean(true));
        }
    }

    private void updateOutline() {
        BibOutlineContainer boc = new BibOutlineContainer(this.entryList, true);
        this.editor.getOutlinePage().update(boc);
    }

    private void updateDocumentPositions() {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        try {
            document.removePositionCategory("__bib_segments");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        document.addPositionCategory("__bib_segments");
        try {
            if (this.entryList.isEmpty()) {
                return;
            }
            int lastLine = document.getNumberOfLines();
            ReferenceEntry rel = (ReferenceEntry)this.entryList.get(this.entryList.size() - 1);
            if (rel.endLine == lastLine) {
                --rel.endLine;
            }
            for (ReferenceEntry re : this.entryList) {
                int beginOffset = document.getLineOffset(re.startLine - 1);
                int length = document.getLineOffset(re.endLine) - beginOffset;
                re.setPosition(beginOffset, length);
                document.addPosition("__bib_segments", re.position);
            }
        }
        catch (BadPositionCategoryException bpce) {
            TexlipsePlugin.log("BibDocumentModel.updateDocumentPositions: bad position category ", bpce);
        }
        catch (BadLocationException ble) {
            TexlipsePlugin.log("BibDocumentModel.updateDocumentPositions: bad position ", ble);
        }
    }

    public void update() {
        try {
            this.doParse();
            this.updateDocumentPositions();
            this.updateBibContainer();
            if (this.editor.getOutlinePage() != null) {
                this.updateOutline();
            }
            this.updateAbbrManager();
            this.editor.updateCodeFolder(this.entryList);
        }
        catch (TexDocumentParseException texDocumentParseException) {}
    }
}

