/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class BracketInserter
implements VerifyKeyListener,
ILinkedModeListener {
    private final String CATEGORY = this.toString();
    private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
    private Stack<BracketLevel> fBracketLevelStack = new Stack();
    private final ISourceViewer sourceViewer;
    private final IEditorPart editor;
    private static HashMap<String, String> quotes;
    private static final Pattern SIMPLE_COMMAND_PATTERN;

    static {
        SIMPLE_COMMAND_PATTERN = Pattern.compile("\\\\.\\{\\\\?\\w\\}");
    }

    public BracketInserter(ISourceViewer viewer, IEditorPart editor) {
        this.sourceViewer = viewer;
        this.editor = editor;
        if (quotes == null) {
            quotes = new HashMap();
            quotes.put("eno", "``");
            quotes.put("enc", "''");
            quotes.put("fio", "''");
            quotes.put("fic", "''");
            quotes.put("fro", "\"<");
            quotes.put("frc", "\">");
            quotes.put("deo", "\"`");
            quotes.put("dec", "\"'");
        }
    }

    private static boolean isClosingBracket(char c) {
        return c == ')' || c == '}' || c == ']' || c == '$';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '[': {
                return ']';
            }
            case '$': {
                return '$';
            }
            case ']': {
                return '[';
            }
        }
        return '\u0000';
    }

    private boolean isLikePunctuationMark(char next) {
        switch (next) {
            case '!': 
            case ')': 
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case ']': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private boolean isLikeOpeningBrace(char next) {
        switch (next) {
            case '(': 
            case ':': 
            case '=': 
            case '[': 
            case '{': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private String getQuotes(boolean opening) {
        IProject project = ((FileEditorInput)this.editor.getEditorInput()).getFile().getProject();
        String lang = TexlipseProperties.getProjectProperty((IResource)project, "langSpell");
        String postfix = opening ? "o" : "c";
        String replacement = quotes.get(String.valueOf(lang) + postfix);
        return replacement != null ? replacement : quotes.get("en" + postfix);
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        switch (event.character) {
            case '\b': 
            case '\"': 
            case '$': 
            case '(': 
            case '.': 
            case '[': 
            case '{': {
                break;
            }
            default: {
                return;
            }
        }
        IDocument document = this.sourceViewer.getDocument();
        Point selection = this.sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        char character = event.character;
        try {
            if (document instanceof IDocumentExtension3) {
                try {
                    String contentType = ((IDocumentExtension3)document).getContentType("__tex_partitioning", offset, false);
                    if ("__tex_VerbatimPartition".equals(contentType)) {
                        return;
                    }
                }
                catch (BadPartitioningException e) {
                    TexlipsePlugin.log("Bad partitioning", e);
                }
            }
            char next = ' ';
            char last = ' ';
            try {
                if (offset > 0) {
                    last = document.getChar(offset - 1);
                }
                next = document.getChar(offset);
            }
            catch (BadLocationException badLocationException) {}
            if (last == '\\') {
                return;
            }
            if (character == '\"') {
                String mark;
                if (!TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("texReplaceQuotes")) {
                    return;
                }
                if (Character.isWhitespace(last) || this.isLikeOpeningBrace(last)) {
                    mark = this.getQuotes(true);
                } else if (Character.isWhitespace(next) || this.isLikePunctuationMark(next)) {
                    mark = this.getQuotes(false);
                } else {
                    return;
                }
                document.replace(offset, length, mark);
                this.sourceViewer.setSelectedRange(offset + mark.length(), 0);
                event.doit = false;
                return;
            }
            if (character == '\b') {
                if (!TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("smartBackspace")) {
                    return;
                }
                if (last == '}' && offset > 4) {
                    int distance;
                    if (document.getChar(offset - 5) == '\\') {
                        distance = 5;
                    } else if (offset > 5 && document.getChar(offset - 6) == '\\') {
                        distance = 6;
                    } else {
                        return;
                    }
                    String deletion = document.get(offset - distance, distance);
                    Matcher m = SIMPLE_COMMAND_PATTERN.matcher(deletion);
                    if (m.matches()) {
                        document.replace(offset - distance, distance, "");
                        event.doit = false;
                    }
                } else if (Character.isLetter(last) && offset > 2 && document.getChar(offset - 3) == '\\' && !Character.isLetter(document.getChar(offset - 2))) {
                    document.replace(offset - 3, 3, "");
                    event.doit = false;
                }
                return;
            }
            if (character == '.') {
                if (!TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("smartLdots")) {
                    return;
                }
                if (last == '.' && document.getChar(offset - 2) == '.') {
                    String replacement = "\\ldots";
                    document.replace(offset - 2, length + 2, replacement);
                    this.sourceViewer.setSelectedRange(offset + replacement.length() - 2, 0);
                    event.doit = false;
                }
                return;
            }
            if (!TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("texBracketCompletion")) {
                return;
            }
            if (Character.isWhitespace(next) || BracketInserter.isClosingBracket(next)) {
                if (character == '$' && !Character.isWhitespace(last)) {
                    return;
                }
            } else {
                return;
            }
            boolean left = false;
            if (last == 't') {
                try {
                    String prev = document.get(offset - 6, 6);
                    if (prev.charAt(0) != '\\' && "\\left".equals(prev.substring(1))) {
                        left = true;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            char closingCharacter = BracketInserter.getPeerCharacter(character);
            StringBuffer buffer = new StringBuffer();
            buffer.append(character);
            if (left) {
                buffer.append("\\right");
            }
            buffer.append(closingCharacter);
            document.replace(offset, length, buffer.toString());
            BracketLevel level = new BracketLevel();
            this.fBracketLevelStack.push(level);
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
            LinkedModeModel model = new LinkedModeModel();
            model.addLinkingListener((ILinkedModeListener)this);
            model.addGroup(group);
            model.forceInstall();
            level.fOffset = offset;
            level.fLength = 2;
            if (left) {
                level.fLength += 6;
            }
            if (this.fBracketLevelStack.size() == 1) {
                document.addPositionCategory(this.CATEGORY);
                document.addPositionUpdater(this.fUpdater);
            }
            level.fFirstPosition = new Position(offset, 1);
            level.fSecondPosition = new Position(offset + 1, level.fLength - 1);
            document.addPosition(this.CATEGORY, level.fFirstPosition);
            document.addPosition(this.CATEGORY, level.fSecondPosition);
            level.fUI = new EditorLinkedModeUI(model, (ITextViewer)this.sourceViewer);
            level.fUI.setSimpleMode(true);
            level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, '\u0000', this.fBracketLevelStack, this.sourceViewer));
            level.fUI.setExitPosition((ITextViewer)this.sourceViewer, offset + level.fLength, 0, Integer.MAX_VALUE);
            level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            level.fUI.enter();
            IRegion newSelection = level.fUI.getSelectedRegion();
            this.sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
            event.doit = false;
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void left(LinkedModeModel environment, int flags) {
        final BracketLevel level = this.fBracketLevelStack.pop();
        if (flags != 8) {
            return;
        }
        final IDocument document = this.sourceViewer.getDocument();
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                public void perform(IDocument d, IDocumentListener owner) {
                    if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                        try {
                            document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, null);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    if (BracketInserter.this.fBracketLevelStack.size() == 0) {
                        document.removePositionUpdater(BracketInserter.this.fUpdater);
                        try {
                            document.removePositionCategory(BracketInserter.this.CATEGORY);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {}
                    }
                }
            });
        }
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }

    private static class BracketLevel {
        int fOffset;
        int fLength;
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private BracketLevel() {
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack<BracketLevel> fStack;
        final int fSize;
        final ISourceViewer sourceViewer;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack<BracketLevel> stack, ISourceViewer viewer) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
            this.sourceViewer = viewer;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (event.character == this.fExitCharacter) {
                    BracketLevel level = this.fStack.peek();
                    if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                        return null;
                    }
                    if (level.fSecondPosition.offset == offset && length == 0) {
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (event.character == '\r' && offset > 0) {
                    IDocument document = this.sourceViewer.getDocument();
                    try {
                        if (document.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = this.sourceViewer.getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }
}

