/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.Arrays;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.HardLineWrap;
import net.sourceforge.texlipse.texparser.LatexParserUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TexAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String indentationString = "";
    private String[] indentationItems;
    private int lineLength;
    private static boolean hardWrap = false;
    private boolean indent;
    private HardLineWrap hlw;
    private boolean autoItem = true;
    private boolean itemSetted = false;
    private int itemAtLine = 0;
    private final IPreferenceStore fPreferenceStore = TexlipsePlugin.getDefault().getPreferenceStore();

    public TexAutoIndentStrategy() {
        this.fPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String ev = event.getProperty();
                if ("lineLength".equals(ev)) {
                    TexAutoIndentStrategy.this.lineLength = TexAutoIndentStrategy.this.fPreferenceStore.getInt("lineLength");
                } else if ("texItemCompletion".equals(ev)) {
                    TexAutoIndentStrategy.this.autoItem = TexAutoIndentStrategy.this.fPreferenceStore.getBoolean("texItemCompletion");
                } else if ("indentLevel".equals(ev) || "indentTabs".equals(ev) || "indent".equals(ev) || "indentEnvs".equals(ev)) {
                    TexAutoIndentStrategy.this.setIndetationPreferenceInfo();
                }
            }
        });
        this.hlw = new HardLineWrap();
        this.setIndetationPreferenceInfo();
    }

    public static String getIndentationString() {
        String indentationString = "";
        if (TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("indentTabs")) {
            indentationString = "\t";
        } else {
            int indentationLevel = TexlipsePlugin.getDefault().getPreferenceStore().getInt("indentLevel");
            int i = 0;
            while (i < indentationLevel) {
                indentationString = String.valueOf(indentationString) + " ";
                ++i;
            }
        }
        return indentationString;
    }

    private void setIndetationPreferenceInfo() {
        this.indentationItems = TexlipsePlugin.getPreferenceArray("indentEnvs");
        Arrays.sort(this.indentationItems);
        this.indentationString = TexAutoIndentStrategy.getIndentationString();
        this.indent = Boolean.parseBoolean(TexlipsePlugin.getPreference("indent"));
        this.lineLength = this.fPreferenceStore.getInt("lineLength");
        this.autoItem = this.fPreferenceStore.getBoolean("texItemCompletion");
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (this.indent) {
            if (this.itemSetted && this.autoItem && command.length == 0 && command.text != null && TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1) {
                this.dropItem(document, command);
            } else if (command.length == 0 && command.text != null && TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1) {
                this.smartIndentAfterNewLine(document, command);
            } else if ("}".equals(command.text)) {
                this.smartIndentAfterBrace(document, command);
            } else {
                this.itemSetted = false;
            }
        }
        if (hardWrap && command.length == 0 && command.text != null) {
            this.hlw.doWrapB(document, command, this.lineLength);
        }
    }

    public static boolean needsEnd(String environment, String docString, int coffset) {
        int counter = 1;
        int offset = coffset;
        while (counter > 0) {
            IRegion end = LatexParserUtils.findEndEnvironment(docString, environment, offset + 5);
            if (end == null) {
                return true;
            }
            IRegion start = LatexParserUtils.findBeginEnvironment(docString, environment, offset + 7);
            if (start == null) {
                --counter;
                offset = end.getOffset();
                continue;
            }
            if (end.getOffset() > start.getOffset()) {
                ++counter;
                offset = start.getOffset();
                continue;
            }
            --counter;
            offset = end.getOffset();
        }
        return false;
    }

    public static String getIndentation(String line) {
        int offset = 0;
        while (offset < line.length() && (line.charAt(offset) == ' ' || line.charAt(offset) == '\t')) {
            ++offset;
        }
        return line.substring(0, offset);
    }

    private void smartIndentAfterNewLine(IDocument document, DocumentCommand command) {
        try {
            this.itemSetted = false;
            int commandOffset = command.offset;
            int line = document.getLineOfOffset(commandOffset);
            int lineOffset = document.getLineOffset(line);
            String startLine = document.get(lineOffset, commandOffset - lineOffset);
            String lineDelimiter = document.getLegalLineDelimiters()[TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text)];
            int beginIndex = LatexParserUtils.findCommand(startLine, "\\begin", 0);
            if (beginIndex != -1) {
                IRegion r = LatexParserUtils.getCommandArgument(startLine, beginIndex);
                if (r == null) {
                    super.customizeDocumentCommand(document, command);
                    return;
                }
                String envName = startLine.substring(r.getOffset(), r.getOffset() + r.getLength());
                StringBuilder buf = new StringBuilder(command.text);
                String prevIndentation = TexAutoIndentStrategy.getIndentation(startLine);
                if (Arrays.binarySearch(this.indentationItems, envName) >= 0) {
                    buf.append(prevIndentation);
                    buf.append(this.indentationString);
                } else {
                    buf.append(prevIndentation);
                }
                if (this.autoItem && (envName.equals("itemize") || envName.equals("enumerate"))) {
                    buf.append("\\item ");
                    this.itemSetted = true;
                    this.itemAtLine = document.getLineOfOffset(command.offset);
                } else if (this.autoItem && envName.equals("description")) {
                    buf.append("\\item[]");
                    this.itemSetted = true;
                    this.itemAtLine = document.getLineOfOffset(command.offset);
                }
                command.caretOffset = command.offset + buf.length();
                command.shiftsCaret = false;
                if (this.autoItem && envName.equals("description")) {
                    --command.caretOffset;
                }
                if (TexAutoIndentStrategy.needsEnd(envName, document.get(), lineOffset)) {
                    buf.append(lineDelimiter);
                    buf.append(prevIndentation);
                    buf.append("\\end{" + envName + "}");
                }
                command.text = buf.toString();
            } else if (this.autoItem && !this.itemInserted(document, command)) {
                super.customizeDocumentCommand(document, command);
            } else {
                super.customizeDocumentCommand(document, command);
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexAutoIndentStrategy:SmartIndentAfterNewLine", e);
        }
    }

    private void smartIndentAfterBrace(IDocument document, DocumentCommand command) {
        try {
            int commandOffset = command.offset;
            int line = document.getLineOfOffset(commandOffset);
            int lineOffset = document.getLineOffset(line);
            int lineLength = document.getLineLength(line);
            String lineText = document.get(lineOffset, lineLength);
            String text = lineText.trim().concat(command.text);
            if (text.startsWith("\\end")) {
                IRegion r = LatexParserUtils.getCommandArgument(text, 0);
                if (r == null) {
                    super.customizeDocumentCommand(document, command);
                    return;
                }
                String envName = text.substring(r.getOffset(), r.getOffset() + r.getLength());
                String docText = document.get();
                IRegion rBegin = LatexParserUtils.findMatchingBeginEnvironment(docText, envName, lineOffset);
                int beginLineNr = document.getLineOfOffset(rBegin.getOffset());
                int beginLineLength = document.getLineLength(beginLineNr);
                int beginLineStart = document.getLineOffset(beginLineNr);
                String beginLine = document.get(beginLineStart, beginLineLength);
                String beginInd = TexAutoIndentStrategy.getIndentation(beginLine);
                command.text = String.valueOf(beginInd) + text;
                command.length = commandOffset - lineOffset;
                command.offset = lineOffset;
            } else {
                super.customizeDocumentCommand(document, command);
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexAutoIndentStrategy:SmartIndentAfterBracket", e);
        }
    }

    private void dropItem(IDocument d, DocumentCommand c) {
        try {
            IRegion r;
            String line;
            if (this.itemSetted && this.itemAtLine == d.getLineOfOffset(c.offset) - 1 && ("\\item".equals((line = d.get((r = d.getLineInformationOfOffset(c.offset)).getOffset(), r.getLength())).trim()) || "\\item[]".equals(line.trim()))) {
                c.shiftsCaret = false;
                c.length = line.length();
                c.offset = r.getOffset();
                c.text = TexAutoIndentStrategy.getIndentation(line);
                c.caretOffset = c.offset + c.text.length();
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexAutoIndentStrategy:dropItem", e);
        }
        this.itemSetted = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean itemInserted(IDocument d, DocumentCommand c) {
        this.itemSetted = false;
        try {
            int lineNr = d.getLineOfOffset(c.offset);
            int lineEnd = d.getLineOffset(lineNr) + d.getLineLength(lineNr);
            if (c.offset < lineEnd - 1) {
                return false;
            }
            int currentLineNr = lineNr;
            String indentation = null;
            while (true) {
                if (lineNr < 0) {
                    return false;
                }
                IRegion r = d.getLineInformation(lineNr);
                String prevLine = d.get(r.getOffset(), r.getLength());
                if (indentation == null) {
                    indentation = TexAutoIndentStrategy.getIndentation(prevLine);
                }
                if (prevLine.trim().startsWith("\\item")) {
                    StringBuilder buf = new StringBuilder(c.text);
                    buf.append(indentation);
                    if (prevLine.trim().startsWith("\\item[")) {
                        c.shiftsCaret = false;
                        c.caretOffset = c.offset + buf.length() + 5 + c.text.length();
                        buf.append("\\item[]");
                    } else {
                        buf.append("\\item ");
                    }
                    this.itemSetted = true;
                    this.itemAtLine = currentLineNr;
                    c.text = buf.toString();
                    return true;
                }
                if (prevLine.trim().startsWith("\\begin")) return false;
                if (prevLine.trim().startsWith("\\end")) {
                    return false;
                }
                --lineNr;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public static void setHardWrap(boolean hardWrap) {
        TexAutoIndentStrategy.hardWrap = hardWrap;
    }
}

