##############################################################################
##############################################################################
##
##  ARCHIVE HEADER INFORMATION
##
##  @MMS-Description-File{
##      FILENAME    = "descrip.mms",
##      VERSION     = "1.00",
##      DATE        = "",
##      TIME        = "",
##
##      AUTHOR      = "Niel Kempson",
##      ADDRESS     = "25 Whitethorn Drive
##                     Cheltenham
##                     GL52 5LL
##                     England",
##      TELEPHONE   = "+44-242 579105",
##      EMAIL       = "kempson@tex.ac.uk (Internet)",
##
##      SUPPORTED   = "yes",
##      ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
##      KEYWORDS    = "VVcode",
##
##      CODETABLE   = "ISO/ASCII",
##      CHECKSUM    = "51492 1481 5732 57976",
##
##      DOCSTRING   = { This is the VVCODE description file for use with
##                      the VAX/VMS Module Management System (MMS) - DEC's
##                      equivalent to Make.
##                  }
##  }
##
##  MODULE CONTENTS
##
##      [tbs]
##
##  COPYRIGHT
##
##      Written 1991-1992 by Niel Kempson <kempson@tex.ac.uk> who claims
##      no copyright over this program - you are free to use it as you wish.
##
##  CHANGE LOG
##
##############################################################################
##############################################################################


##############################################################################
#
# Local definitions for file types and compilation / linking.
#
# If your system is already supported it should not be necessary to modify
# any part of the description file except the local definitions below.	 
#
# COMPILER/LINKER
#
#   CC		    the command used to invoke the C compiler
#   CFLAGS	    compiler command line flags to be used
#   CCDEFINES	    symbols to be #defined when compiling
#
#   LINK	    the command used to invoke the linker
#   LINKFLAGS       linker command line flags to be used
#
# The definitions are used to compile and link as shown below:
#
#   Compiling C programs (e.g. xx.c)
#
#	$(CC)  $(CFLAGS)  $(CCDEFINES)  xx.c
#
#   Linking object files (e.g. xx.obj, yy.obj & zz.obj)
#
#	$(LINK)  $(LINKFLAGS)  xx.obj,yy.obj,zz.obj,vvcode.opt/OPTION
#
#       where vvcode.opt contains the single line:
#
#           SYS$LIBRARY:VAXCRTL/SHAREABLE
#
#   Here are some examples known to work.
#
#   VAX/VMS C v3.1
#
#       CC	    = cc
#       CFLAGS      = /WARNINGS /STANDARD=PORTABLE /DEBUG /NOOPTIMIZE
#       CCDEFINES   =
#       
#       LINK        = LINK /TRACEBACK /NODEBUG
#       LINKFLAGS   = /TRACEBACK
#
##############################################################################
# Start of local definitions.
##############################################################################
CC	    = cc
CFLAGS      = /WARNINGS /STANDARD=PORTABLE /DEBUG /NOOPTIMIZE
CCDEFINES   =

LINK        = LINK /TRACEBACK /NODEBUG
LINKFLAGS   = /TRACEBACK
##############################################################################
# End of local definitions.
##############################################################################


#############################################################################=
# File types and default rule for compilation
##############################################################################
EXE		= .exe
OBJ		= .obj

.SUFFIXES       .c .h $(OBJ) $(EXE)

.c.obj:
	$(CC)  $(CFLAGS)  $*.c    	

##############################################################################
# Target Groupings
##############################################################################
HDRFILES	= checkos.h machine.h local.h globals.h specific.h vvutils.h

OBJFILES	= vvencode$(OBJ) vvdecode$(OBJ) vveparse$(OBJ) -
                  vvutils$(OBJ) vaxvms$(OBJ)

EXEFILES	= vvencode$(EXE)  vvdecode$(EXE)


##############################################################################
# Top level targets
##############################################################################
vvcode :		$(EXEFILES)
    	@ WRITE SYS$OUTPUT "VVcode built at ''F$TIME()'"
    
clean :
	@ WRITE SYS$OUTPUT "Cleaning up at ''F$TIME()'"
	PURGE
	IF F$SEARCH ("*.dia;*") .NES. "" THEN $ DELETE *.dia;*
	IF F$SEARCH ("*.exe;*") .NES. "" THEN $ DELETE *.exe;*
	IF F$SEARCH ("*.lis;*") .NES. "" THEN $ DELETE *.lis;*
	IF F$SEARCH ("*.obj;*") .NES. "" THEN $ DELETE *.obj;*


##############################################################################
# Dependencies for executables
##############################################################################
vvencode$(EXE) :    vvencode$(OBJ) vvutils$(OBJ) vaxvms$(OBJ) vvcode.opt
    	$(LINK)  $(LINKFLAGS) vvencode$(OBJ), vvutils$(OBJ), vaxvms$(OBJ), -
                              vvcode.opt/OPTION

vvdecode$(EXE) :    vvdecode$(OBJ) vveparse$(OBJ) vvutils$(OBJ) -
                    vaxvms$(OBJ) vvcode.opt
    	$(LINK)  $(LINKFLAGS)  vvdecode$(OBJ), vveparse$(OBJ), -
                               vvutils$(OBJ), vaxvms$(OBJ), -
                               vvcode.opt/OPTION

##############################################################################
# Dependencies for the linker option file
##############################################################################
vvcode.opt :
        OPEN /WRITE options_file vvcode.opt
        WRITE options_file "SYS$LIBRARY:VAXCRTL /SHAREABLE"
        CLOSE options_file
                
##############################################################################
# Dependencies for object files
##############################################################################
vvencode$(OBJ) :    vvencode.c  $(HDRFILES)

vvdecode$(OBJ) :    vvdecode.c  $(HDRFILES) vveparse.h

vveparse$(OBJ) :    vveparse.c  $(HDRFILES) vveparse.h

vvutils$(OBJ) :     vvutils.c  $(HDRFILES)

vaxvms$(OBJ) :      vaxvms.c  $(HDRFILES)
