(******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       wp2lfir.c                                                     *
 * description: This modul contains functions for first pass. In the first    *
 *              pass information of the WP binary file will splitted in two   *
 *              parts:                                                        *
 *              1) A text file containing the whole text. The special WP      *
 *                 characters are translated.                                 *
 *              2) A binary file which contains information about             *
 *                 environments, tabbings, line endings                       *
 ******************************************************************************)
unit Pass1;

interface
uses common,strings,charactr,formulas;

Procedure Convert_first_pass(var FileIn,Tabel:bin;var StripOut:text;LogFile:Ptext);


Procedure Make_tabelentry_envir_extra_end(var cq:TconvertedPass1);
Procedure Make_tabelentry_attr(var cq:TconvertedPass1);
Procedure Make_tabelentry_tabset(var cq:TconvertedPass1);
Procedure Reset_attr_rij(d : Integer;var cq:TconvertedPass1);
Procedure WP_Default(var cq:TconvertedPass1);
Procedure Terminate_Line(var cq:TconvertedPass1; line_term: char);

Procedure CrackObject(var cq:TconvertedPass1;end_of_code:longint);

const NormalText=0;
      HeaderText=1;
      CharsOnly=2;
      Nothing=3;

Procedure ProcessKey(var cq:TconvertedPass1);

implementation



const filter:Array[0..3] of set of byte=(
                   [0..$FF],
		   [0..$BF,$C0,$D1,$D2,$D4..$FF],
                   [$20..$7F,$A9,$C0],
		   []);
      EqSeparator=['^','_','*','/','+','-',' ','~','\'];

      SizesC0:array[$C0..$CF] of Byte=
      	{	(3,8,10,2,2,4,5,6,0,0,0,0,0,0,0,0);}
        	(4,9,11,3,3,5,6,7,0,0,0,0,0,0,0,0);


{this procedure isn't called now. It can be used for exploration of new objects}
Procedure CrackObject(var cq:TconvertedPass1;end_of_code:longint);
var txt:text;
    i:word;
    a:array[0..1000] of byte;
    pos:longint;
    len:word;
const ss:string[8]='00__.txt';
Begin                           { less length }
  pos:=Filepos(cq.wpd^);

  fillchar(a,sizeof(a),0);
  len:=end_of_code-Filepos(cq.wpd^);
  blockread(file(cq.wpd^),a,len);

  if ss[2]>'9' then
     begin
     ss[2]:='0';
     inc(ss[1]);
     end;
  assign(txt,ss);
  rewrite(txt);
    for i:=0 to len do
	begin
	write(txt,i:2,' ');
	writeXbyte(a[i],txt);
        if chr(a[i]) in [' '..'z'] then write(txt,' ',chr(a[i]));
	writeln(txt);
	end;

  close(txt);
  inc(ss[2]); {}

  seek(cq.wpd^,pos);
end;


Procedure Make_tabelentry_envir_extra_end(var cq:TconvertedPass1);
Var b : Byte;

Begin

 Case cq.envir of
      'B' : Begin
	       b:=ord('B');
	       Write(cq.tabel^,b);
	    End;

      'C','c' : Begin
	       b:=ord('C');
	       Write(cq.tabel^,b);
	    End;

      'L' : Begin
	       b:=ord('L');
	       Write(cq.tabel^,b);
	    End;

      'R' : Begin
	       b:=ord('R');
	       Write(cq.tabel^,b);
	    End;

      'Q' : Begin
	       b:=ord('Q');
	       Write(cq.tabel^,b);
	    End;

      'T' : Begin
	       b:=ord('T');
	       Write(cq.tabel^,b);
	    End;
      't' : Begin
	       b:=ord('t');
	       Write(cq.tabel^,b);
	    End;

  'i','I' : Begin
	       b:=ord(cq.envir);
	       Write(cq.tabel^,b);
	       Wr_word(cq.tabel^,cq.ind_leftmargin);

	       Write(cq.tabel^,cq.indenting)
	    End;

   End;  {Case}

   b := Ord(cq.line_term);
   write(cq.tabel^,b);

   b:=$FF;
   Write(cq.tabel^,b);

{  b:=13;
   Write(cq.tabel^,b); {---Vyhodit----}
End;

Procedure Make_tabelentry_attr(var cq:TconvertedPass1);
Var
   b,
   num_of_attr : Byte;
   j : Integer;

Begin
   num_of_attr := cq.openptr[cq.depth];
   Write(cq.tabel^,num_of_attr);

   For j:=1 to num_of_attr Do
            Write(cq.tabel^,cq.attr_rij[cq.depth,j]);
End;


Procedure Make_tabelentry_tabset(var cq:TconvertedPass1);
Var
   b : Byte;
   j : Integer;

Begin
   b := ord('S');
   Write(cq.tabel^,b);

   b:=cq.num_of_tabs;
   Write(cq.tabel^,b);

   For j:=1 to cq.num_of_tabs Do Wr_word(cq.tabel^,cq.tabpos[j]);
End;


Procedure Make_tabelentry_rightjustification(var cq:TconvertedPass1);
Var b : Byte;

Begin
   b := Ord('U');
   Write(cq.tabel^,b);

   If cq.by=$81 Then b:=01                 { rows WEL uitvullen }
		Else b:=00;                { rows NIET uitvullen }
   Write(cq.tabel^,b);
End;


Procedure DoCaption(var cq:TconvertedPass1; CaptionSize : word);
var end_of_code:Longint;
    OldFlag:Byte;
    OldEnvir:Char;

Begin       	     { less length }
   if CaptionSize=0 then exit;

   cq.ActualPos:=Filepos(cq.wpd^);
   end_of_code:=cq.ActualPos+CaptionSize;
   OldFlag:=cq.Flag;
   OldEnvir:=cq.Envir;

   cq.Flag:=HeaderText;

   write(cq.strip^,'\caption{');
   While cq.ActualPos < end_of_code Do
	 Begin
         Read(cq.wpd^,cq.by);

         ProcessKey(cq);
         cq.Envir:=OldEnvir;
         End;
  writeln(cq.strip^,'}');

  cq.line_term := 'p';     { Soft return }
  Make_tabelentry_envir_extra_end(cq);

  cq.Flag:=OldFlag;
  cq.Envir:=OldEnvir;
  cq.char_on_line:=False;
  cq.nomore_valid_tabs := False;
  cq.rownum:=cq.rownum+1;
  Make_tabelentry_attr(cq);
  cq.latex_tabpos:=0;
End;



Procedure StartSection(var cq:TconvertedPass1);
Var b : byte;
Begin
   Read(cq.wpd^,b);                             { less attribuut-code }
   if cq.FirstSection>100 then	{setup for 1'st section in the document}
   	begin
        cq.FirstSection:=0;
        if b=1 then cq.FirstSection:=1;
        end;
   if b>0 then b:=b-cq.FirstSection;
   if(b>2) then exit;
   b:=b+$10;

   writeln(cq.strip^);
   cq.line_term := 'p';     { Soft return }
   Make_tabelentry_envir_extra_end(cq);

   cq.char_on_line:=False;
   cq.nomore_valid_tabs := False;
   cq.rownum:=cq.rownum+1;
   Make_tabelentry_attr(cq);
   cq.latex_tabpos:=0;


   cq.attr_rij[cq.depth,cq.leegptr[cq.depth]]:=b;       { attribuut in attr-rij }
   cq.leegptr[cq.depth]:=cq.leegptr[cq.depth]+1;        { plaats 1 verder. }
   cq.open_attr_rij[cq.depth]:=True;              { openstaande attr-rij }
   cq.ObjType:='Start Section';
End;

Procedure EndSection(var cq:TconvertedPass1);
Var b       : Byte;
    found   : Boolean;
    j,codeptr: Integer;

Begin
   Read(cq.wpd^,b);                             { less attribuut-code }
   if(b>2) then exit;
   b:=b+$10;

   j:=cq.leegptr[cq.depth];                       { zoek vanaf top attr-rij }
   found:=False;                            { nog niet gevonden }

   While (j>1) and (Not found)              { zoek attr-code in attr-rij }
   Do Begin
        j:=j-1;
	found:=(cq.attr_rij[cq.depth,j]=b)
      End;

   If j<=0 Then RunError($0100);            { Moet nooit kunnen voorkomen }
   codeptr:=j;                              { plaats van attr-code in rij }

{ Sluit all command's t/m the desbetreffende code als This nog niet }
{ gesloten zijn.                                                     }

   If codeptr<=cq.openptr[cq.depth]
   Then Begin
	   For j:=cq.openptr[cq.depth] downto codeptr
           Do Begin
		 Write(cq.strip^,Close_com[cq.attr_rij[cq.depth,j]]);
		 cq.openptr[cq.depth]:=cq.openptr[cq.depth]-1;
              End;
        End;

{ Haal the desbetreffende attribuut from the rij en werk pointers bij }

   For j:=codeptr to (cq.leegptr[cq.depth]-1)
   Do cq.attr_rij[cq.depth,j]:=cq.attr_rij[cq.depth,j+1];
   cq.leegptr[cq.depth]:=cq.leegptr[cq.depth]-1;

   cq.open_attr_rij[cq.depth]:=True;                { openstaande attr-rij }

   cq.ObjType:='End Section';
End;


{ This procedure plaatst one attribuut (lettertype) in the attribuut-rij }
Procedure Attr_ON(var cq:TconvertedPass1);
Var b : Byte;
Begin
   Read(cq.wpd^,b);                             { less attribuut-code }

   cq.attr_rij[cq.depth,cq.leegptr[cq.depth]]:=b;       { attribuut in attr-rij }
   cq.leegptr[cq.depth]:=cq.leegptr[cq.depth]+1;        { plaats 1 verder. }
   cq.open_attr_rij[cq.depth]:=True;              { openstaande attr-rij }

   cq.ObjType:='Attr On';
End;


Procedure Attr_OFF(var cq:TconvertedPass1);
{ This procedure haalt one from one attribuut (lettertype) from the }
{ attribuut-rij door middel van one stack principe omdat binnen  }
{ LaTeX the later geopende kommando's eerst afgesloten te worden  }
Var b       : Byte;
    found   : Boolean;
    j,codeptr: Integer;

Begin
   Read(cq.wpd^,b);                             { less attribuut-code }

   j:=cq.leegptr[cq.depth];                       { zoek vanaf top attr-rij }
   found:=False;                            { nog niet gevonden }

   While (j>1) and (Not found)              { zoek attr-code in attr-rij }
   Do Begin
        j:=j-1;
	found:=(cq.attr_rij[cq.depth,j]=b)
      End;

   If j<=0 Then RunError($0100);            { Moet nooit kunnen voorkomen }
   codeptr:=j;                              { plaats van attr-code in rij }

{ Sluit all command's t/m the desbetreffende code als This nog niet }
{ gesloten zijn.                                                     }

   If codeptr<=cq.openptr[cq.depth]
   Then Begin
	   For j:=cq.openptr[cq.depth] downto codeptr
           Do Begin
		 Write(cq.strip^,Close_com[cq.attr_rij[cq.depth,j]]);
		 cq.openptr[cq.depth]:=cq.openptr[cq.depth]-1;
              End;
        End;

{ Haal the desbetreffende attribuut from the rij en werk pointers bij }

   For j:=codeptr to (cq.leegptr[cq.depth]-1)
   Do cq.attr_rij[cq.depth,j]:=cq.attr_rij[cq.depth,j+1];
   cq.leegptr[cq.depth]:=cq.leegptr[cq.depth]-1;

   cq.open_attr_rij[cq.depth]:=True;                { openstaande attr-rij }

   cq.ObjType:='Attr Off';
End;


Procedure Close_all_attr(var cq:TconvertedPass1);
{ -- Sluit all command's door the Attributen-rij af te lopen -- }
Var j:Integer;
Begin
  For j:=cq.openptr[cq.depth] Downto 1 Do
     Begin
	Write(cq.strip^,Close_com[cq.attr_rij[cq.depth,j]]);
	cq.openptr[cq.depth]:=cq.openptr[cq.depth]-1;
     End;
  cq.open_attr_rij[cq.depth] := True;
End;

Procedure Open_all_attr(var cq:TconvertedPass1);
{ -- Open all command's door the Attributen-rij af te lopen -- }

Var j:Integer;
Begin
  For j:=(cq.openptr[cq.depth]+1) to (cq.leegptr[cq.depth]-1) Do
     Begin
	 Write(cq.strip^,Open_com[cq.attr_rij[cq.depth,j]]);
	 cq.openptr[cq.depth]:=cq.openptr[cq.depth]+1;
      End;

  cq.open_attr_rij[cq.depth]:=False            { all attributen staan weer goed }
End;


Procedure Character(var cq:TconvertedPass1);
Var ch          : String;
    chr_code,chr_set,b: Byte;

Begin
   If cq.open_attr_rij[cq.depth] Then Open_all_attr(cq);

   Case cq.by of
      $20..$7F : begin
                 ch := StrPas((addr(lat[cq.by])));	{ Normal_char  }
                 if cq.Font<>0 then
                    	begin
                        if not(chr(cq.by) in [' '..';','?']) then
                        	begin
                                cq.Font:=0;
                                write(cq.strip^,'\em ');
                                end;
                        end;
                 end;

      $A9      : Begin		{ Special_char }
		    If cq.by=$A9 Then ch:='-'
                                 Else ch:='\ ';
		 End;

      $C0      : Begin		{ Extended_char }
		    Read(cq.wpd^,chr_code);
		    Read(cq.wpd^,chr_set);

		    ch:=StrPas(ext_chr_str(chr_set,chr_code,cq));


                    if cq.Font<>0 then
                    	begin
                        if chr_set<>10 then
                        	begin
                                cq.Font:=0;
                                write(cq.strip^,'\em ');
                                end;
                        end;

                    if chr_set=10 then
                      begin
                      if cq.Font=0 then
                    	  begin
                          cq.Font:=1;
                          write(cq.strip^,'\bukvy ');
                          end;

                      end;

		    Read(cq.wpd^,b);
		 End;

      End;

   Write(cq.strip^,ch);
End;


Procedure Header_Footer(var cq:TconvertedPass1;end_of_code: Longint);
Var
   occurance : Byte;
   HorizontalPos:Byte;
   j : Integer;

   OldFlag:Byte;
   OldCharOnLine:Boolean;

Begin
   OldFlag:=cq.Flag;
   OldCharOnLine:=cq.Char_On_Line;
   inc(cq.recursion);

   end_of_code := end_of_code - 4;

   If end_of_code-FilePos(cq.wpd^) > 18 Then
	   Begin
           Jump_in_file(cq.wpd^,7);
	   Read(cq.wpd^,occurance);

	   Jump_in_file(cq.wpd^,10);

           Close_all_attr(cq);
	   cq.depth := 1;

{ Geen schone attr._lei; Kopieer attributen from Niveau 0;  Fout in WP 5.0 ? }

           For j:=0 to 15 Do cq.attr_rij[1,j] := cq.attr_rij[0,j];

           cq.leegptr[1]:=cq.leegptr[0];
           cq.openptr[1]:=cq.openptr[0];

           Case cq.subby of
                00,01 : Write(cq.strip^,'\headtext');
                02,03 : Write(cq.strip^,'\foottext');
              End;

           Case occurance of
                00 : Write(cq.strip^,'{\neverpages}{');
                01 : Write(cq.strip^,'{\allpages}{');
                02 : Write(cq.strip^,'{\oddpages}{');
                04 : Write(cq.strip^,'{\evenpages}{');
                else Write(cq.strip^,'{');
              End;

           Open_all_attr(cq);
           HorizontalPos:=0;          { Begin met de linkerkant }

           cq.Flag:=HeaderText;

           cq.ActualPos:=FilePos(cq.wpd^);
	   While cq.ActualPos < end_of_code Do
                 Begin
                 Read(cq.wpd^,cq.by);

                 if cq.by<>$C1 then ProcessKey(cq)
                              else
                              Begin
                              Read(cq.wpd^,cq.subby);
                              cq.subby := cq.subby and $E0;
                              Jump_in_file(cq.wpd^,7);

                              If cq.subby=$E0 Then
                                    Begin
                                    If HorizontalPos=0 Then
                                           Begin
                                              Close_all_attr(cq);
                                              Write(cq.strip^,'}{');
                                              Open_all_attr(cq);

					      HorizontalPos:=1; {center}
                                           End;
                                   End;

                              If cq.subby=$60 Then
                                      Begin
                                      If HorizontalPos=0 Then
                                           Begin
                                            Close_all_attr(cq);
                                            Write(cq.strip^,'}{}{');
                                           End;
                                      If HorizontalPos=1 Then
                                           Begin
                                             Close_all_attr(cq);
                                             Write(cq.strip^,'}{');
                                           End;
                                      Open_all_attr(cq);
                                      HorizontalPos:=2;  {right}
                                   End;
                             End;
              End;

           Close_all_attr(cq);      { Echt nodig ? }

           case HorizontalPos of 0:Write(cq.strip^,'}{}{}');
                                 1:Write(cq.strip^,'}{}');
                                 2:Write(cq.strip^,'}');
                             end;
	   cq.depth := 0;
           Open_all_attr(cq);

        End;

cq.Flag:=OldFlag;
cq.Char_On_Line:=OldCharOnLine;
dec(cq.recursion);
cq.ObjType:='Header Footer';
End;

Procedure TableBox(var cq:TconvertedPass1;end_of_code: Longint);
Var first_char_os  : Boolean;
    char_width_os  : Word;

    OldFlag:Byte;
    captionLen:word;
    CaptionPos:Longint;
Begin       	     { less length }
   OldFlag:=cq.flag;
   cq.flag:=HeaderText;
   inc(cq.recursion);
   end_of_code := end_of_code - 4;

   Rd_word(cq.wpd^,char_width_os);

   Jump_in_file(cq.wpd^,113);
   Rd_word(cq.wpd^,captionLen);
   CaptionPos:=Filepos(cq.wpd^);

   first_char_os := True;

   Jump_in_file(cq.wpd^,captionLen);
   cq.actualpos:=CaptionPos+CaptionLen;

   writeln(cq.strip^,'\begin{table}[htbp]');
   cq.line_term := 'p';     { Soft return }
   Make_tabelentry_envir_extra_end(cq);
   cq.char_on_line:=False;
   cq.nomore_valid_tabs := False;
   cq.rownum:=cq.rownum+1;
   Make_tabelentry_attr(cq);
   cq.latex_tabpos:=0;

   While cq.actualpos < end_of_code  Do
	 Begin
         Read(cq.wpd^,cq.by);

         ProcessKey(cq);
         End;

   if cq.char_on_line then
   	begin
        writeln(cq.strip^);
	cq.line_term := 'p';     { Soft return }
	Make_tabelentry_envir_extra_end(cq);
	cq.char_on_line:=False;
	cq.nomore_valid_tabs := False;
	cq.rownum:=cq.rownum+1;
	Make_tabelentry_attr(cq);
	cq.latex_tabpos:=0;
        end;
  if(CaptionLen>0) then
  	  begin
          seek(cq.wpd^,CaptionPos);
          DoCaption(cq,CaptionLen);
          end;
  write(cq.strip^,'\end{table}');

  dec(cq.recursion);
  cq.ObjType:='Table Box';
  cq.flag:=OldFlag;
  cq.char_on_line:=True;
End;


Procedure TextBox(var cq:TconvertedPass1;end_of_code: Longint);
Var first_char_os  : Boolean;
    minipage_width : Word;

    OldFlag:Byte;
    captionLen:word;
    CaptionPos:Longint;
Begin       	     { less length }
{   crackobject(cq,end_of_code);{}
   OldFlag:=cq.flag;
   cq.flag:=HeaderText;
   inc(cq.recursion);
   end_of_code := end_of_code - 4;

   Jump_in_file(cq.wpd^,103);
   Rd_word(cq.wpd^,minipage_width);

   Jump_in_file(cq.wpd^,10);
   Rd_word(cq.wpd^,captionLen);
   CaptionPos:=Filepos(cq.wpd^);

   first_char_os := True;

   Jump_in_file(cq.wpd^,captionLen);
   cq.actualpos:=CaptionPos+CaptionLen;

   writeln(cq.strip^,'\begin{minipage}{',minipage_width/470:2:2,'cm}');
   cq.line_term := 's';     { Soft return }
   Make_tabelentry_envir_extra_end(cq);
   cq.char_on_line:=False;
   cq.nomore_valid_tabs := False;
   cq.rownum:=cq.rownum+1;
   Make_tabelentry_attr(cq);
   cq.latex_tabpos:=0;

   While cq.actualpos < end_of_code  Do
	 Begin
         Read(cq.wpd^,cq.by);

         ProcessKey(cq);
         End;

   if cq.char_on_line then
   	begin
        writeln(cq.strip^);
	cq.line_term := 'p';     { Soft return }
	Make_tabelentry_envir_extra_end(cq);
	cq.char_on_line:=False;
	cq.nomore_valid_tabs := False;
	cq.rownum:=cq.rownum+1;
	Make_tabelentry_attr(cq);
	cq.latex_tabpos:=0;
        end;
  write(cq.strip^,'\end{minipage}');

  dec(cq.recursion);
  cq.ObjType:='Text Box';
  cq.flag:=OldFlag;
  cq.char_on_line:=True;
End;



Procedure WP_Default(var cq:TconvertedPass1);
Var j : Integer;
const L1_5cm=709;               {length of 1.5 cm}
      L1_27cm=600;              {length of 1.27 cm}
Begin
   cq.WP_sidemargin := 1200;

   cq.tabpos[1]:=L1_27cm;                      { 1e WP-tab is kantlijn --> }
   For j:=2 to 10 Do
           cq.tabpos[j]:=cq.tabpos[j-1]+L1_27cm;       { Size of tabs is 1,27  cm  }
   For j:=11 to 40 Do                                 { ($02c5 wpu) verder        }
	   cq.tabpos[j]:=$FFFF;

   cq.num_of_tabs:=10;
End;


Procedure Reset_attr_rij(d : Integer;var cq:TconvertedPass1);
Var j : Integer;

Begin
   For j:=0 to 16
   Do cq.attr_rij[d,j]:=$00;
   cq.leegptr[d]:=1;
   cq.openptr[d]:=0;
End;


{ This procedure set on the center environment if there is no }
{ currently active environment .                              }
Procedure Center(var cq:TconvertedPass1);
Begin
   If cq.envir=' ' Then cq.envir:='c';        { environment = center }

   cq.ObjType:='Center'
End;


Procedure End_Align(var cq:TconvertedPass1);
Begin
   If cq.align_tab
   Then Begin
           Close_all_attr(cq);
           Write(cq.strip^,'\''');
           cq.align_tab := False;
           Open_all_attr(cq);
        End;

   If cq.right_tab
   Then Begin
           Close_all_attr(cq);
           Write(cq.strip^,'\''');
           cq.right_tab := False;
           Open_all_attr(cq);
        End;

   If cq.center_tab
   Then Begin
           Close_all_attr(cq);
           Write(cq.strip^,'}');
	   cq.center_tab := False;
           Open_all_attr(cq);
        End;
End;



Procedure Tab(var cq:TconvertedPass1);
Var j : integer;
    wpu : word;
    tabnum,new_tabs : Integer;

Begin
   If ((upcase(cq.envir)<>'I'))and(cq.envir<>'B')
      and Not cq.Nomore_valid_tabs      { No indent or table --> normal tab }
	   Then
	   Begin
	   If cq.by=$48 Then cq.right_tab := True;

	   If cq.by=$40 Then cq.align_tab := True;

	   If cq.by=$C8 Then cq.center_tab := True;

	   Jump_in_file(cq.wpd^,2);

	   Rd_word(cq.wpd^,wpu);                       { less abs.-indent [wpu] }
           if wpu<=cq.WP_sidemargin
	   		then begin
                             if cq.log<>nil then
                                begin
		                writeln(cq.log^);
                                write(cq.log^,'Warning: negative tabular');
                                end;
			     wpu:=cq.TabPos[1];      	{fix negative value}
                             end
  			else wpu:=wpu-cq.WP_sidemargin; { Correctie ivm WP kantlijn }

	   tabnum:=0;
	   For j:=1 to cq.num_of_tabs Do              { Bepaal welke tabpos }
		If wpu>=cq.tabpos[j] Then tabnum:=j;

	   new_tabs := tabnum - cq.latex_tabpos;

	   if not(cq.char_on_line) and (cq.envir<>'T') then
		begin
		Write(cq.strip^,'\hspace*{',wpu/470:2:2,'cm} '); {Right}(**)
		cq.char_on_line:=True;
		new_tabs:=0;
		end
		else cq.envir:='T';	     { Er zit one tab in This row }

	   If new_tabs>0 Then
		   Begin
		   Close_all_attr(cq);
		   For j:=1 to new_tabs Do Write(cq.strip^,'\>');
		   If cq.center_tab Then Write(cq.strip^,'\ctab{');
		   Open_all_attr(cq);
		End;

	   cq.latex_tabpos:=tabnum;
	End
	Else write(cq.strip^,' ');


  cq.ObjType:='Tab';
End;


Procedure Flush_right_tab(var cq:TconvertedPass1);
Begin
   If cq.envir<>'I'
   Then Begin
           Close_all_attr(cq);
           Write(cq.strip^,'\`');
           Open_all_attr(cq);

           cq.Nomore_valid_tabs := True;

           cq.envir:='T';
        End;

   Jump_in_file(cq.wpd^,7);
End;



Procedure Indent(var cq:TconvertedPass1);
Var dif,abs  : Word;
    b        : Byte;

Begin
   If cq.envir<>'T' Then
        Begin       {Al one tabcommand gezet dus er mag geen insp }
           writeln(cq.strip^);
           cq.line_term := 's';     { Soft return }

           Make_tabelentry_envir_extra_end(cq);

           if cq.envir='I' then cq.envir:='i'
           		   else cq.envir:='I';
	   inc(cq.indenting);

           Make_tabelentry_attr(cq);


           Read(cq.wpd^,b);
           b:=b And $01;

           Rd_word(cq.wpd^,dif);
           Rd_word(cq.wpd^,abs); { Eigenlijk Old current column }
           Rd_word(cq.wpd^,abs);

           if abs<=cq.WP_sidemargin
                   	then begin
                             if cq.log<>nil then
                                begin
		                writeln(cq.log^);
                                write(cq.log^,'Warning: negative tabular');
                                end;
			     cq.ind_leftmargin:=cq.TabPos[1];
                             end
                         else cq.ind_leftmargin:=abs-cq.WP_sidemargin;

{                   If b=1 Then cq.ind_rightmargin:=cq.ind_rightmargin+dif;
		   {Margins bepaald less voorby rest van functie-codes }

        End;

   cq.ObjType:='Indent';
End;


Procedure End_of_indent(var cq:TconvertedPass1);
Begin
   cq.indent_end := True;
   cq.ObjType:='End Indent';
End;

Procedure LineSpacing(var cq:TconvertedPass1); {!!!!!!!!!!}
var LastSpacing:Word;
    CurrentSpacing:Word;
    Var b : Byte;

begin
  Rd_word(cq.wpd^,LastSpacing);
  Rd_word(cq.wpd^,CurrentSpacing);

  b := Ord('l');Write(cq.tabel^,b);
  Wr_Word(cq.tabel^,CurrentSpacing);

  cq.ObjType:='Line Spacing';
end;


Procedure Tabset(var cq:TconvertedPass1);
Var j  : Integer;
    w  : Word;
    b  : Byte;

Begin
   Jump_in_file(cq.wpd^,100);        { Ga naar TAB-info }

   cq.num_of_tabs:=0;

   For j:=1 to 40 Do
     Begin
         Rd_word(cq.wpd^,w);
	 If (w>cq.WP_sidemargin) and (w<>$FFFF) Then
	      Begin
		 cq.num_of_tabs:=cq.num_of_tabs+1;
		 cq.tabpos[cq.num_of_tabs] := w - cq.WP_sidemargin;
              End;
      End;

   Make_tabelentry_tabset(cq);
   cq.ObjType:='TabSet';
End;


Procedure Page_number_position(var cq:TconvertedPass1);
Var position_code : Byte;

Begin
   Jump_in_file(cq.wpd^,3);            {Skip length of code; always 10}
				   { + old information }
   Read(cq.wpd^,position_code);

   Write(cq.strip^,'\pagenumpos');
   Case position_code of
      $01 : Write(cq.strip^,'{\pntl}');
      $02 : Write(cq.strip^,'{\pntc}');
      $03 : Write(cq.strip^,'{\pntr}');
      $05 : Write(cq.strip^,'{\pnbl}');
      $06 : Write(cq.strip^,'{\pnbc}');
      $07 : Write(cq.strip^,'{\pnbr}');
      Else  Write(cq.strip^,'{\pnno}');
   End;

cq.ObjType:='Page Num Position';
End;


Procedure Terminate_Line(var cq:TconvertedPass1; line_term: char);
Var j:  Integer;
    ond:Boolean;

Begin
  cq.line_term := line_term;     { return }
                  {'h';   Hard return }
                  {'s';   Soft return }
                  {'P';   Hard page }
                  {'p';   Soft page }

   Writeln(cq.strip^);

   Make_Tabelentry_envir_extra_end(cq);

   If cq.indent_end Then
        Begin
	   cq.envir:=' ';
	   cq.indenting:=0;		{!!!!!!}
	   cq.ind_text1:=False;
	   cq.ind_text2:=False;
	   cq.ind_leftmargin:=0;

	   cq.indent_end:=False;
	End
	Else If not(cq.envir in ['B','I','i','C','L','R']) Then cq.envir:=' ';

   cq.char_on_line:=False;
   cq.nomore_valid_tabs := False;

   cq.rownum:=cq.rownum+1;

   Make_tabelentry_attr(cq);

   cq.latex_tabpos:=0;
End;


Procedure Overstrike(var cq:TconvertedPass1; end_of_code : Longint);
Var first_char_os  : Boolean;
    char_width_os  : Word;

    OldFlag:Byte;
Begin       	     { less length }
   OldFlag:=cq.flag;
   cq.flag:=CharsOnly;
   inc(cq.recursion);
   end_of_code := end_of_code - 4;

   Rd_word(cq.wpd^,char_width_os);

   first_char_os := True;

   cq.actualpos:=FilePos(cq.wpd^);
   While cq.actualpos < end_of_code  Do
	 Begin
         Read(cq.wpd^,cq.by);

         if cq.by in [$20..$7F,$A9,$C0] then
                  begin
                  If first_char_os Then
                              Begin
                               ProcessKey(cq);
                               first_char_os := False;
			      End
		      Else Begin
			      Write(cq.strip^,'\llap{');
                              ProcessKey(cq);
			      Write(cq.strip^,'}');
                           End;

                  end
                  else ProcessKey(cq);
         End;

  dec(cq.recursion);
  cq.ObjType:='Overstrike';
  cq.flag:=OldFlag;
  cq.char_on_line:=True;
End;


Procedure MakeLabel(var cq:TconvertedPass1; end_of_code : Longint);
Var OldFlag:Byte;
Begin       	     { less length }
   OldFlag:=cq.flag;
   cq.flag:=CharsOnly;
   end_of_code := end_of_code - 4;

   cq.actualpos:=FilePos(cq.wpd^);
   Write(cq.strip^,' \label{');
   While cq.actualpos < end_of_code  Do
	 Begin
         Read(cq.wpd^,cq.by);
         if cq.by=0 then break;

         ProcessKey(cq);
         End;
  Write(cq.strip^,'}');

  cq.flag:=OldFlag;
  cq.char_on_line:=True;
  cq.ObjType:='Label';
End;

Procedure MakeRef(var cq:TconvertedPass1; end_of_code : Longint);
Var OldFlag:Byte;
Begin       	     { less length }
   OldFlag:=cq.flag;
   cq.flag:=HeaderText;
   end_of_code := end_of_code - 4;

   Read(cq.wpd^,cq.by);	{dummy read}

   cq.actualpos:=FilePos(cq.wpd^);
   Write(cq.strip^,' \ref{');
   While cq.actualpos < end_of_code  Do
	 Begin
         Read(cq.wpd^,cq.by);
         if cq.by=0 then break;

         ProcessKey(cq);
         End;
  Write(cq.strip^,'}');

  cq.flag:=OldFlag;
  cq.char_on_line:=True;
  cq.ObjType:='Reference';
End;

Procedure TableOfContents(var cq:TconvertedPass1);
Begin       	     { less length }
 if cq.char_on_line then
	begin
        writeln(cq.strip^);
        cq.line_term := 'p';     { Soft return }
        Make_tabelentry_envir_extra_end(cq);

        cq.char_on_line:=False;
        cq.nomore_valid_tabs := False;
        cq.rownum:=cq.rownum+1;
        Make_tabelentry_attr(cq);
        cq.latex_tabpos:=0;
        end;

  Writeln(cq.strip^,'\tableofcontents ');

  cq.line_term := 'p';     { Soft return }
  Make_tabelentry_envir_extra_end(cq);

  cq.char_on_line:=False;
  cq.nomore_valid_tabs := False;
  cq.rownum:=cq.rownum+1;
  Make_tabelentry_attr(cq);
  cq.latex_tabpos:=0;
  cq.ObjType:='Table Of Contents';
End;


Procedure StartTable(var cq:TconvertedPass1;len:word);
type WPTab=record
	len:word;
	attribute:byte;
	dummy:byte;
	justification:byte;
       end;
var colums,i:word;
    b:byte;
    Atbl:array[1..100] of WPTab;

begin
  rd_word(cq.wpd^,i);
  if (i<>$A00)and(i<>$A02) then exit;

  read(cq.wpd^,b);
  colums:=0;
  i:=48+5*b;
  Jump_in_file(cq.wpd^,i-3);
  if odd(b) then inc(i,6)
	    else inc(i,1);
  colums:=(len-i) div 5;
  if (len-i) mod 5 <> 0 then
			exit;
  if (colums>100)or(colums<=0) then exit;

  for i:=1 to colums do rd_word(cq.wpd^,Atbl[i].len);
  for i:=1 to colums do read(cq.wpd^,Atbl[i].attribute);
  for i:=1 to colums do read(cq.wpd^,Atbl[i].dummy);
  for i:=1 to colums do read(cq.wpd^,Atbl[i].justification);


  cq.line_term := 's';     { Soft return }
  Make_tabelentry_envir_extra_end(cq);
  cq.Envir:='B';

  writeln(cq.strip^);
  write(cq.strip^,'{|');
  for i:=1 to colums do
	begin
	case Atbl[i].justification and $0F of
		0:write(cq.strip^,'l|');		{left}
		1:write(cq.strip^,'c|');		{full}
		2:write(cq.strip^,'c|');         {center}
		3:write(cq.strip^,'r|');		{right}
	      else write(cq.strip^,'c|'); {I don`t know}
	      end;
	end;
  write(cq.strip^,'}');

  cq.char_on_line:=False;
  cq.nomore_valid_tabs := False;
  cq.rownum:=cq.rownum+1;
  Make_tabelentry_attr(cq);
  cq.latex_tabpos:=0;
  cq.ObjType:='Table Start';
End;

Procedure RowTable(var cq:TconvertedPass1);
Begin

   if cq.Envir='B' then
	  begin
	  if cq.Char_On_Line then write(cq.strip^,' \\');
	  writeln(cq.strip^,' \hline');
	  cq.line_term := 's';     { Soft return }
	  end
	  else begin
	       cq.line_term := 'h';     { Hard return }
	       writeln(cq.strip^);
	       end;

   Make_tabelentry_envir_extra_end(cq);

   cq.char_on_line:=False;
   cq.nomore_valid_tabs := False;
   cq.rownum:=cq.rownum+1;
   Make_tabelentry_attr(cq);
   cq.latex_tabpos:=0;

   cq.ObjType:='Row'
End;


Procedure EndTable(var cq:TconvertedPass1);
Begin
  if cq.Envir='B' then writeln(cq.strip^,' \\ \hline')
		  else writeln(cq.strip^,' ');
  cq.line_term := 's';     { Soft return }
  Make_tabelentry_envir_extra_end(cq);

  if cq.Envir='B' then
	begin
	cq.Envir:=' ';
	cq.line_term := 's';

{       Make_tabelentry_attr(cq);
	writeln(cq.strip^);
	Make_tabelentry_envir_extra_end(cq);
	inc(cq.rownum);}
	end;

  cq.char_on_line:=False;
  cq.nomore_valid_tabs := False;
  cq.rownum:=cq.rownum+1;
  Make_tabelentry_attr(cq);
  cq.latex_tabpos:=0;
  cq.ObjType:='End Table'
End;



Procedure Footnote(var cq:TconvertedPass1; end_of_code : Longint);
Var flags,
    num_of_pages : Byte;
    fn_num	:Word;

    OldFlag:Byte;
Begin                           { less length }
   end_of_code := end_of_code - 4;
   OldFlag:=cq.flag;
   cq.flag:=HeaderText;
   inc(cq.recursion);


   Read(cq.wpd^,flags);

   Rd_word(cq.wpd^,fn_num);

   Read(cq.wpd^,num_of_pages);                   { Skip all the shit }
   Jump_in_file(cq.wpd^,2*(num_of_pages+1)+9);

   Close_all_attr(cq);

   cq.depth := 1;
   Reset_attr_rij(cq.depth,cq);

   Write(cq.strip^,'\footnote[',fn_num:1,']{');

   cq.ActualPos:=FilePos(cq.wpd^);
   While cq.ActualPos < end_of_code Do
         Begin
         Read(cq.wpd^,cq.by);

         Case cq.by of $0A,$0C: Write(cq.strip^,'\\ ');
                       $0B,$0D: Write(cq.strip^,' ');
                    else ProcessKey(cq);
                  end;

         cq.ActualPos:=FilePos(cq.wpd^);
         End;


   Close_all_attr(cq);      { Echt nodig ? }
   Write(cq.strip^,'}');

   cq.depth := 0;
   Open_all_attr(cq);

   dec(cq.recursion);
   cq.ObjType:='Footnote';
   cq.flag:=OldFlag;
End;




Procedure Advance(var cq:TconvertedPass1);
var w:integer;
    b:byte;
begin
 read(cq.wpd^,b);
 Jump_in_file(cq.wpd^,2);
 blockread(file(cq.wpd^),w,2);
 if b=0 then Write(cq.strip^,'{\vskip ',w/470:2:2,'cm}'); {Up/Down}
 if b=2 then Write(cq.strip^,'{\hskip ',w/470:2:2,'cm}'); {Left/Right}
 cq.ObjType:='Advance';
end;

Procedure Justifikation(var cq:TconvertedPass1);
var w:word;
    b:byte;
begin
 rd_Word(cq.wpd^,w);

 if cq.char_on_line then write(cq.strip^,'\\');
 writeln(cq.strip^);
 cq.line_term := 'h';     { Hard return }

 Make_tabelentry_envir_extra_end(cq);

 cq.char_on_line:=False;
 cq.nomore_valid_tabs := False;
 cq.rownum:=cq.rownum+1;
 Make_tabelentry_attr(cq);
 cq.latex_tabpos:=0;
 cq.envir:=' ';

 if (w=$0203)or(w=$0201) then cq.envir:='C';		{ environment = center }
 if w=$0001 then cq.envir:='L';		{ environment = left }
 if w=$0300 then cq.envir:='R';		{ environment = right }
 if w=$0102 then cq.envir:=' ';		{ environment = full }

 cq.ObjType:='Justification';
end;

Function CheckConzistency(var cq:TconvertedPass1; NewPos:Longint):Boolean;
var TestedBy:byte;
    Pos:longint;
begin
 CheckConzistency:=True;
 Pos:=filepos(cq.wpd^);

 seek(cq.wpd^,NewPos-1);
 read(cq.wpd^,TestedBy);
 if TestedBy<>cq.By then
        begin
        if cq.log<>nil then
		begin
		writeln(cq.log^);
                write(cq.log^,'Error: Object consistency failed. Trying to ignore.');
                end;
        CheckConzistency:=False;
{ 	asm int 3; end;}
        end;

 seek(cq.wpd^,Pos);
end;

{This is main procedure for processing one key. It is recursivelly called.}
Procedure ProcessKey(var cq:TconvertedPass1);
var w:Word;
    NewPos:Longint;
    by,subby:byte;
Label ObjectError;
begin
NewPos:=0;
if cq.by=0 then Read(cq.wpd^,cq.by);

cq.ObjType:='';
{Guessing end position of the object}
Case cq.by of
   $00..$BF:;      {these functions has size only 1 byte - all OK}
   $C0..$CF:begin  {these functions has fixed size - see table SizesC0}
            if SizesC0[cq.by]<>0 then
               begin
               NewPos:=SizesC0[cq.by] + cq.ActualPos;
               end;
            cq.SubBy:=$FF; {ignored subcommand}
            end;
   $d0..$FF:begin
              Read(cq.wpd^,cq.subby);
              Rd_word(cq.wpd^,w);
              NewPos:=4+ cq.ActualPos+w;
              cq.LineBegin:=False;
{             if cq.by=$DB then
		      begin
		      seek(cq.wpd^,newpos-1);
	              read(cq.wpd^,by);
                      end;}
             end;
   end;

if ExtendedCheck and (NewPos<>0) then
	if not(CheckConzistency(cq,NewPos)) then
        	begin
                NewPos:=0;
                Goto ObjectError;
                end;

by:=cq.by;
subby:=cq.subby;


if by in filter[cq.flag] then
     Case by of
	$20..$7F,
	$A9,$C0  :Begin
		    cq.char_on_line:=True;                {Er (al) is one character op This row }
{		    If cq.indenting>0 Then  {!!!!!!}      {Als er is ingeprongen er na one stuk }
{		     If cq.ind_text1 Then cq.ind_text2:=True;{tekst is weer ingesprongen (ind_text1) }
						{dan hoort this char bij het ind_txt-blok }
		    Character(cq);
		  End;

	     $0A: Terminate_Line(cq,'h');		{ Hard return }
	     $0D: Terminate_Line(cq,'s');		{ Soft return }
	     $0B: Terminate_Line(cq,'p');		{ Soft page }
	     $0C: Terminate_Line(cq,'P');		{ Hard page }
	     $8C: Terminate_Line(cq,'h');		{ Hard return }
	$81,$82  :Make_tabelentry_rightjustification(cq);
	$83      :End_Align(cq);

	$A0:     Write(cq.strip^,'~');
	$AC:     begin
		 write(cq.strip^,'\-');
		 cq.ObjType:='- Soft Hyphen';
		 end;
	$C1     :Begin
		 Read(cq.wpd^,cq.subby);
		 cq.subby:=cq.subby and $E8;

		 Case cq.subby of
		      $00,$C8,
		      $48,$40     : Tab(cq);
		      $60         : Flush_right_tab(cq);
		      $E0         : Center(cq);
		      Else Jump_in_file(cq.wpd^,7);
		    End;
		 End;
       $C3      :Attr_ON(cq);
       $C4      :Attr_OFF(cq);
       $C2      :Indent(cq);
       $C6      :End_of_indent(cq);

       $D0:Begin
	   Case subby of
		  $02 : LineSpacing(cq);
		  $04 : Tabset(cq);
		  $06 : Justifikation(cq);
		  $08 : Page_number_position(cq);
		End;
	    End;
       $D2: if subby=$0B then StartTable(cq,w);
       $D3: if subby=6 then Advance(cq);
       $D5: Header_Footer(cq,NewPos);
       $D6: Begin
	    Case subby of
		 $00 : Footnote(cq,NewPos);
	      End;
	    End;
       $D7: Begin
	    Case subby of
		 $00 : StartSection(cq);
		 $01 : EndSection(cq);
		 $02 : TableOfContents(cq);
		 $07 : MakeRef(cq,NewPos);
		 $08 : MakeLabel(cq,NewPos);
	      End;
	    End;
       $D8:Begin
	   Case subby of
		 $02 : Overstrike(cq,NewPos);
	      End;
	   End;
       $DA:begin
	   if subby=1 then TableBox(cq,NewPos);
	   if subby=2 then TextBox(cq,NewPos);
	   if subby=4 then Equation(cq,NewPos);
	   end;
{      $DB:if subby=0 then StyleInsides(cq,NewPos);}
       $DC:case subby of
	      $00:if cq.Envir='B' then   {cell}
		    begin
		    if cq.Char_On_Line then write(cq.strip^,' & ');
		    cq.Char_On_Line:=True;
		    cq.ObjType:='Cell'
		    end;
	      $01:if cq.Envir='B' then RowTable(cq);
	      $02:if cq.Envir='B' then EndTable(cq);
	    end;
       $DD:begin
	   if subby=$1 then
		if cq.Envir='B' then RowTable(cq);
	   if subby=$2 then
		if cq.Envir='B' then EndTable(cq);
	   end;

     End;

ObjectError:
if cq.log<>nil then
  if by in [$C0..$FF] then
	begin
	writeln(cq.log^);
        write(cq.log^,'':2*cq.recursion,'Object type:',by:3,' subtype:',subby:3,' length:',w:4);
	if cq.ObjType<>'' then write(cq.log^,' [',cq.ObjType,'] ')
                          else write(cq.log^,'    ');
        end
   else if chr(by) in [' '..'z'] then write(cq.log^,chr(by));{}

cq.ActualPos:=FilePos(cq.wpd^);
if (NewPos<>0) then
  if (NewPos<>cq.ActualPos) then
           begin
           seek(cq.wpd^,newpos);
           cq.ActualPos:=NewPos;
           NewPos:=0;
           end;

end;



{*************************************}
{ This procedure provides all needed processing for the first pass}
Procedure Convert_first_pass(var FileIn,Tabel:bin;var StripOut:text;LogFile:Ptext);
Var wo : Word;
   convperc,lastconvperc,i: Integer;
   srtdocpos,fsize: longint;

   cq:TconvertedPass1;
Begin
   Table_Init(Lat);

   Reset_attr_rij(0,cq);
   Reset_attr_rij(1,cq);

   cq.wpd:=addr(FileIn);
   cq.tabel:=addr(Tabel);
   cq.Strip:=addr(StripOut);
   cq.Log:=LogFile;

   cq.font:=0;
   cq.depth := 0;
   cq.FirstSection:=120;
   cq.Recursion := 0;
   cq.Flag:=NormalText;

   WP_default(cq);

   cq.latex_tabpos:=0;
   cq.right_tab := False;
   cq.align_tab := False;
   cq.center_tab := False;

   cq.indenting:=0;		{!!!!!!}
   cq.indent_end:=False;
   cq.ind_text1:=False;
   cq.ind_text2:=False;
   cq.ind_leftmargin:=0;

   cq.envir:=' ';

   cq.nomore_valid_tabs := False;

   if Verbosing>=1 then
   	begin
	Writeln('First pass :');
	Write('Converting-percentage :     ');
        end;

   srtdocpos:=filepos(cq.wpd^);
   fsize:=FileSize(cq.wpd^);

   cq.rownum := 0;

   Make_tabelentry_attr(cq);           { attribuut instelling }

   Make_tabelentry_tabset(cq);         { Geef the defaulttabinstelling door }
				   { tied the 2e pass }

   
   cq.ActualPos:=FilePos(cq.wpd^);
   lastconvperc:=200;
   While (cq.ActualPos<fsize) Do
        Begin
        convperc:=round((cq.ActualPos-srtdocpos)/(fsize-srtdocpos)*100);
        if (lastconvperc<>convperc)and(Verbosing>=1) then
            begin
            Write(chr(8),chr(8),chr(8),chr(8),convperc:3,'%');
            lastconvperc:=convperc;
            end;

        cq.by:=0;
        ProcessKey(cq);
        End;

   Writeln;
   Make_tabelentry_envir_extra_end(cq);

   num_of_lines_stripfile := cq.rownum;

End;


end.
{--------------------End of PASS1--------------------}


