# call of the spelling check program  $spcmd  for the file  $efile$spsuff
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc spellcheck {f austext} {

  upvar 1 $austext a

  global  vv spcmd splang spoptions spselect efile spsuff main_file xtermcall xtem_path
  global  dirprefix

  if {$dirprefix==""} {set mainfile $main_file} else {set mainfile [fileName $main_file]} 

  if { $spoptions != "" } {
    # Substitution von $HOME (und ggfs. weiteren $-Variablen im Optionenstring)
    global env
    set HOME $env(HOME)
    set spoptions "[eval concat $spoptions]"
  }

  set a "";  writescr0 $f ""; set m ""; set res ""

  if {$efile==""} {set a "${a}***** $vv(ea1)\n"; mybell 2; return}

  if ![file exists $efile$spsuff] {# file not found! 
    set a "${a}\n\n***** $vv(aus5)   $efile$spsuff   $vv(ea4)\n"; mybell 2; return
  }

  writescr0 $f "[datime] $vv(re1) \"$efile$spsuff\"\n$spcmd $spoptions $efile$spsuff\n"


  if { $spcmd == "spell" } {# translate, as <spell> is sensitive to special characters!

    writescr $f "$vv(re2)\n"

    # Umlaute -> ae oe ue Ae Oe Ue ss
    set efs $efile$spsuff
    SigChldB; eval set res [catch "exec changecode -ascii7 $efs $efs-sp1" message]; SigChldU
    TestPut 4 "<$res><$message>"
    if {"$res"!="0"} {writescr0 $f "$message\n$vv(re3) $res\n\n"; mybell 2}
    # replace all "non-7Bit-Alpha-Num-characters"  by blanks
    ######     12 chars    6 chars     6 chars     4 chars
    ######    [\041-\057] [\072-\077] [\133-\140] [\173-\176]
    SigChldB; exec tr	{"[\041-\057][\072-\077][\133-\140]"} \
			{"                        "}		< $efs-sp1 > $efs-sp; SigChldU
    unlink -nocomplain $efs-sp1
    SigChldB; exec tr	{"[\173-\176]\344\366\374\304\326\334\337[0-9]"} \
			{"    aouAOUs          "}		< $efs-sp > $efs-spl; SigChldU
    unlink -nocomplain $efs-sp

    set zusatzwb ""
    if [file exists $main_file.wb]	{set zusatzwb "+$main_file.wb"}
    if [file exists $efile.wb]		{set zusatzwb "+$efile.wb"}

    writescr $f  "$vv(re4)\n"
    eval mkCmd_wait $f $spcmd [list "$spoptions $zusatzwb $efile$spsuff-spl"]
    unlink -nocomplain $efile$spsuff-spl

    # words not found in the dictionary --> $efile.wb-erg
    if {"$res"=="0"} {write_file $efile.wb-erg $message}
    set a "${a}$vv(re5) \"$efile.wb-erg\".\n"

  } elseif { $spcmd == "ispell" } {

    set res 0; set m ""

    TestPut 4 "<$xtermcall><$xtem_path/xtem_prog $spcmd $spoptions $efile$spsuff>"
    # select one of the following 4 exec-lines to execute a program via an xterm window:
    # (don't use SigChld... here)!
    # xtem_prog shell-script prevents xterm-window to be discarded immediately after execution
    # variable xtermcall can be set in xteminstall (installation procedure)
    #
    # 1.call (after eval) via $xtermcall and xtem_prog (shell script)
    # eval exec $xtermcall -e $xtem_path/xtem_prog $spcmd $spoptions $efile$spsuff
    #
    # 2.call (with catch and eval) via $xtermcall and xtem_prog (shell script)
    #   (catch needed for some platforms, e.g. Solaris2.6/INTEL
      catch "eval exec $xtermcall -e $xtem_path/xtem_prog $spcmd $spoptions $efile$spsuff"
    #
    # 3. call via xterm and xtem_prog (shell script)
    # exec xterm -e $xtem_path/xtem_prog $spcmd $spoptions $efile$spsuff
    #
    # 4. call (after eval) via $xtermcall and error-catching
    # eval set res [catch "exec $xtermcall -e $spcmd $spoptions $efile$spsuff" m]
    #
    # 5. call (after eval) via xterm and error-catching
    # eval set res [catch "exec xterm -e $spcmd $spoptions $efile$spsuff" m]

    set a "${a}\n$vv(re6)\n\n"
    if {"$res" != "0"} { set a "${a}$vv(re7) $spcmd: $res\n$m\n"; mybell 2}

  } elseif { $spcmd == "spellfilter" } {

    set res 0; set m ""
    eval set res [catch "eval exec $spcmd $spoptions $efile" m]
    set a "${a}\n$vv(re6)\n\n$vv(re7) $spcmd: $res\n$m\n"
    if {"$res" != "0"} {mybell 2}

  } else {

    set a "${a}\n***** $vv(re8) $spcmd $vv(re9)\n"

  }

}
