/*
** AREXX $VER: TeX-server.rexx1.44 (22.11.1992)
**
** This script creates an ARexx port, by the name of
**
**    Port Name = "Start_TeX"
**
** and waits there for the commands
**
**    - compile <format-file> <TeX-file including-absolute-path>
**      - the filename *must* have an extension.
**      - if <format-file>=='&', use tex'es default format.
**    - quit
**      - exits the server.
**
** It may be called with one parameter: the name of the public screen
** (OS 2.0) in which this server runs.
**
** AUTHORS:
**    April 1991 Jrg Hhle
**    Before     Georg Hessmann
**
** CHANGES:
**    1992       Andreas Scherer
**
** NOTES: An `absolute path' is given if you use a volume, device or
**    assign'ed name like TeX_Disk1:, RAM: or TeX:.
**
**    Make virtex resident (ARP or AmigaDOS, depending on your shell), or
**    include it in your shell path. However the default of 'virtex' may be
**    overridden at any time by the ARexx variable virtex (see further below).
**    This has been implemented to be able to switch between smallTeX and
**    BigTeX on the fly.
**
** BUGS: Does not allow blanks in filenames and directories, because
**    neither ARexx nor TeX are happy with them.
**
** FILES:
**    Rexx:NameStruc : namestruc is a function, and must stay in REXX:
**                     for now. Sorry about that.
**    Libs:rexxsupport.library
*/

/*
** The Name of the Game
*/
PORTNAME = "Start_TeX"

Options Results

Parse Arg PUBSCREEN .
If PUBSCREEN = "" Then
  PUBSCREEN = "Workbench"

If ~Show('Libraries','rexxsupport.library') Then
  If ~Addlib('rexxsupport.library',0,-30,0) Then Do
    Say "Konnte 'rexxsupport.library' nicht ffnen!"
    Exit 20
  End

/*
** ARexx V1.10 sets RC to RESULT * 65536 + RESULT2
**       V1.14 and 1.15 set RC to RESULT on a shell command call.
*/
Parse Version . REXXVER .
FILTER2 = REXXVER < "V1.14"
/*
** Say 'ver'REXXVER 'filter 'FILTER2
*/

Signal On BREAK_C
Signal On BREAK_D

FALSE = 0
TRUE = 1

Say
Say "        ********************************************************"
Say "        *                                                      *"
Say "        *   Wilkommen zur ARexx - Passauer TeX Schnittstelle   *"
Say "        *                                                      *"
Say "        ********************************************************"

Call SetClip("TEXQUERY")

Options Prompt "? >"

Say
Say "- ffne Port "PORTNAME"."

If ~OpenPort(PORTNAME) Then Do
  Say
  Say "- konnte nicht geffnet werden!"
  Exit 20
End

EMPTY = FALSE

/*
** Main Loop. To begin with we set ERRORCODE to it's default. Later when
** there are TeX errors an ERRORCODE ~= 0 will suppress the activation of
** ShowDVI, which we want to be activated in a normal run.
*/
ERRORCODE = 0

Address 'showdvi' toBack

Do Until COMTEX = 'quit'

  If ~EMPTY Then Do
    Call SetClip("TEXTIME")
    Say "- Warte auf Befehle (Compile/Quit) fr Port "PORTNAME"."
  End

  If ERRORCODE = 0 Then
    Address 'showdvi' Activate

  Call WaitPkt(PORTNAME)

  PACKET = GetPkt(PORTNAME)
  If PACKET == NULL() Then
    EMPTY = TRUE
/*
** Say "- Received NULL packet."
**
** ARexx 1.14 and 1.15 tend to send *lots* of NULL packets
*/
  Else Do
    EMPTY = FALSE

    Parse Value GetArg(PACKET) With COMTEX FORMAT FULLNAME

    Call Reply(PACKET,0)

    If COMTEX = 'compile' Then Do
/*
** And now, Server-to-front
*/
      Address COMMAND PToFront PUBSCREEN
/*
** Result:  5: not OS 2.0
**         10: PubScreen not found,
**         15: no Intuition.library.
*/
      If '&' ~= Left(FORMAT,1) Then
        FORMAT = '&'||FORMAT
      Else If '&' = FORMAT Then
/*
** Use virtex default FORMAT
*/
        FORMAT = ""

/*
** Beware of blanks (eg RAM DISK:)
*/
      FULLNAME = Strip(FULLNAME)

/*
** Make RAM DISK: a special case
*/
      If "RAM DISK:" = Upper(Left(FULLNAME,9)) Then
        FULLNAME="RAM:"||SUBSTR(FULLNAME,10)

/*
** KLUDGE: Do NOT accept names with blanks, I could do a better job here
*/
      If 0 ~= Index(FULLNAME," ") Then
        Say "- Bitte keine Leerzeichen in Dateinamen :"FULLNAME
      Else Do
        Parse Value NameStruc(FULLNAME) With IVOL IDIR INAME .

/*
** The following four commands produce the respective results from the input
**
**     (TeX:doc/sample.tex) -> (TeX:doc/)
**                             (sample.tex)
**                             (sample)
**                             (TeX:doc/sample)
*/
        TEXDIR   = Left(FULLNAME,    IVOL+IDIR)
        NAMEONLY = SubStr(FULLNAME,1+IVOL+IDIR)
        BASEONLY = SubStr(FULLNAME,1+IVOL+IDIR,INAME)
        FULLBASE = Left(FULLNAME,    IVOL+IDIR+INAME)

        If 0 = IVOL Then
          Say "- Ein absoluter Pfad mu benutzt werden (z. B. <device|volumename>:...)!"
        Else If SubStr(FULLNAME,1+IVOL+IDIR+INAME,1) ~= "." Then
          Say "- Fehler, Dateiname mu eine Endung .<extension> haben: "FULLNAME
        Else Do
          If ~Exists(FULLNAME) Then
            Say "- Konnte "FULLNAME" nicht finden! Fehlt ein Pfad?"
          Else Do
            Call Delete(FULLBASE||".log")
/*
** I feel there's no need to delete the .dvi file.
*/

/*
** Get TeX or BigTeX
*/
            VIRTEX = GetClip("VIRTEX")
            If "" = VIRTEX Then
              VIRTEX = 'virtex'

            Say '- Starte 'VIRTEX FORMAT NAMEONLY
            Say '  im Pfad 'TEXDIR
            Call Pragma('directory',TEXDIR)
            Call SetClip("TEXFILE",FULLNAME)
            NOW = TIME('s')
            Call SetClip("TEXTIME",NOW)

/*
** The "< *" is a hack, no ?
*/
            Address COMMAND VIRTEX' < * 'FORMAT NAMEONLY

/*
** How can I get rid of the Rexx message "+++ Command returned >=65536"
** with versions of ARexx <= V1.10 ?
*/
            If FILTER2 Then
              ERRORCODE = RC % 65536 /* ARexx V1.10 */
            Else
              ERRORCODE = RC         /* ARexx V1.14, V1.15 */

/*
** Ignore TeX's warning messages like `Overfull \hbox...' and show
** the document for visual control.
*/
            If ERRORCODE <= 5 Then Do
              If ERRORCODE > 0 Then Do
                Say
                Say "- Problem beim bersetzen, Fehlercode "ERRORCODE"."
              End; Else Do
                Say
                Say "- "FULLNAME" wurde fehlerfrei bersetzt."
              End;

/*
** Now start the previewer.
*/
              If Show('Port','showdvi') Then Do
                Address "showdvi"

                Options Results

                GetFile
                LOADEDFILE = RESULT

                GetDir
                LOADEDDIR = RESULT

                If Right(LOADEDDIR,1)~=':' & Right(LOADEDDIR,1)~='/' THEN
                  LOADEDDIR = LOADEDDIR||'/'

                If TEXDIR = LOADEDDIR & 1 = Index(Upper(LOADEDFILE||".dvi"),Upper(BASEONLY||".dvi")) Then Do
                  Say "- Datei in ShowDVI wird erneuert."
                  LoadAgain
                End; Else Do
                  Say "- Lade Datei "FULLBASE".dvi in ShowDVI."
                  LoadNew FULLBASE||".dvi"
                End

                toFront
                Activate
              End; Else
                Say "- ShowDVI luft nicht."
            End; Else Do
              Say
              Say "- Fehler beim bersetzen, Fehlercode "ERRORCODE"."
              If GetClip("TEXTIME") == NOW & Exists(FULLBASE||".log") Then Do
                EDITSCRIPT = Word(MyGetEnv("TEXREXXEDIT"),1)
                If "" = EDITSCRIPT Then
                  EDITSCRIPT = 'TeXedit.rexx'
                Say "- Starte den Editor fr die Datei "FULLNAME" mittels "EDITSCRIPT"."
                EDITSCRIPT FULLNAME 0
              End
            End
          End /* Exists */
        End   /* !IVOL, "." */
      End     /* !Index */
    End       /* Compile */
  End         /* !NULL() */
End           /* Do */

/*
** Finish
*/
Address COMMAND PToFront PUBSCREEN
/*
** Result:  5: not OS 2.0
**         10: PubScreen not found
**         15: no Intuition.library
*/

Say "- Beende den Port "PORTNAME
Call ClosePort PORTNAME

If PUBSCREEN ~= "Workbench" Then
  Say "  Window wird automatisch geschlossen."
/*
** Nur mittels des TeX:rexx/TeX-Server-startup Skriptes
*/

Signal CleanUp

BREAK_C:
BREAK_D:
Say
Say "- Abbruchmeldung empfangen."

CleanUp:
Call SetClip("TEXFILE")
Call SetClip("TEXTIME")
Call SetClip("TEXQUERY")
Exit

MyGetEnv: PROCEDURE
/*
** when will ARexx supply GetEnv/SetEnv ?
*/
Parse Arg NAME

If Open(TEMPFILE,"ENV:"||NAME,'r') Then Do
  GIVES = Readln(TEMPFILE)
  Call Close TEMPFILE
End; Else
  GIVES = ""

Return GIVES

MySetEnv: PROCEDURE
Parse Arg NAME,CONTENT

Address COMMAND "SetEnv" NAME CONTENT

Return
