//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 25th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.SparseArray;
import android.util.SparseBooleanArray;

public class Parseverbatim {
	
	public static volatile SparseArray<Float> thisypos = new SparseArray<Float>();
	public static volatile SparseBooleanArray error = new SparseBooleanArray();
	public static volatile SparseArray<String> errormessage = new SparseArray<String>();
        
	public void parseverbatim(Canvas canvas, Block block, Integer tid, Integer containerwidth, Integer containerheight, int superblocknumber, SuperBlock superblock, SparseArray<ArrayList<String>> superblockline,float referencex, float referencey, ArrayList<Typeface> tf ,String attribute1) {
	    
		int fontsize = Header.fontsize;
		
		int ii;
		error.put(tid,false);
		errormessage.put(tid,"");
		    
		Paint textpaint = new Paint();
		Rect textbounds = new Rect();
		textpaint.setTextSize(Header.fontsize);
		textpaint.setTypeface(tf.get(Header.defaultfont));
		textpaint.getTextBounds("A",0,"A".length(),textbounds);	
		referencey=referencey+textbounds.height()+Header.linegap;

		ArrayList<String> subblock = new ArrayList<String>();
		ArrayList<Float> subblockxpos = new ArrayList<Float>();
		ArrayList<Float> subblockypos = new ArrayList<Float>();    	
		ArrayList<String> subblockattribute = new ArrayList<String>(); 
		    
		textpaint.getTextBounds("j",0,"j".length(),textbounds);
		for (ii=0;ii<=superblockline.get(superblocknumber).size()-1;ii++){                         // First parse
			synchronized(this){superblock.create(tid);} 	            		  
			subblock.add(superblockline.get(superblocknumber).get(ii).substring(0,superblockline.get(superblocknumber).get(ii).length()-2)); 
			textpaint.getTextBounds(subblock.get(0),0,subblock.get(0).length(),textbounds);
			subblockxpos.add((float) Header.leftsidemargin);
			subblockypos.add(referencey);   			            		  
			subblockattribute.add(attribute1);
			            	  		            	 
			referencey=referencey+(float)fontsize; 
			synchronized(this){
				superblock.add(tid,subblock,subblockxpos, subblockypos, subblockattribute,(float) textbounds.width() , (float) fontsize, (float)textbounds.bottom, 'v',0);}
			subblock.clear();
			subblockxpos.clear();subblockypos.clear();subblockattribute.clear();
		}
	            		            	 	            	  
		thisypos.put(tid, referencey-(float)fontsize+textbounds.bottom);
		error.put(tid, false);
		errormessage.put(tid, "");
	};                  
}                 
	          
	    
	    