#include <caml/mlvalues.h>
#include <caml/misc.h>
#include <caml/alloc.h>
#include <caml/memory.h>

#define Lu  0
#define Ll  1
#define Lt  2
#define Lm  3
#define Lo  4
#define Mn  5
#define Mc  6
#define Me  7
#define Nd  8
#define Nl  9
#define No 10
#define Pc 11
#define Pd 12
#define Ps 13
#define Pe 14
#define Pi 15
#define Pf 16
#define Po 17
#define Sm 18
#define Sc 19
#define Sk 20
#define So 21
#define Zs 22
#define Zl 23
#define Zp 24
#define Cc 25
#define Cf 26
#define Cs 27
#define Co 28
#define Cn 29

#define L    0
#define LRE  1
#define LRO  2
#define R    3
#define AL   4
#define RLE  5
#define RLO  6
#define PDF  7
#define EN   8
#define ES   9
#define ET  10
#define AN  11
#define CS  12
#define NSM 13
#define BN  14
#define B   15
#define S   16
#define WS  17
#define ON  18

/* vim:set ft=c: */
static const char name_reserved[] = "<reserved>";
static const char * name_0000[256] =
{
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"SPACE",
"EXCLAMATION MARK",
"QUOTATION MARK",
"NUMBER SIGN",
"DOLLAR SIGN",
"PERCENT SIGN",
"AMPERSAND",
"APOSTROPHE",
"LEFT PARENTHESIS",
"RIGHT PARENTHESIS",
"ASTERISK",
"PLUS SIGN",
"COMMA",
"HYPHEN-MINUS",
"FULL STOP",
"SOLIDUS",
"DIGIT ZERO",
"DIGIT ONE",
"DIGIT TWO",
"DIGIT THREE",
"DIGIT FOUR",
"DIGIT FIVE",
"DIGIT SIX",
"DIGIT SEVEN",
"DIGIT EIGHT",
"DIGIT NINE",
"COLON",
"SEMICOLON",
"LESS-THAN SIGN",
"EQUALS SIGN",
"GREATER-THAN SIGN",
"QUESTION MARK",
"COMMERCIAL AT",
"LATIN CAPITAL LETTER A",
"LATIN CAPITAL LETTER B",
"LATIN CAPITAL LETTER C",
"LATIN CAPITAL LETTER D",
"LATIN CAPITAL LETTER E",
"LATIN CAPITAL LETTER F",
"LATIN CAPITAL LETTER G",
"LATIN CAPITAL LETTER H",
"LATIN CAPITAL LETTER I",
"LATIN CAPITAL LETTER J",
"LATIN CAPITAL LETTER K",
"LATIN CAPITAL LETTER L",
"LATIN CAPITAL LETTER M",
"LATIN CAPITAL LETTER N",
"LATIN CAPITAL LETTER O",
"LATIN CAPITAL LETTER P",
"LATIN CAPITAL LETTER Q",
"LATIN CAPITAL LETTER R",
"LATIN CAPITAL LETTER S",
"LATIN CAPITAL LETTER T",
"LATIN CAPITAL LETTER U",
"LATIN CAPITAL LETTER V",
"LATIN CAPITAL LETTER W",
"LATIN CAPITAL LETTER X",
"LATIN CAPITAL LETTER Y",
"LATIN CAPITAL LETTER Z",
"LEFT SQUARE BRACKET",
"REVERSE SOLIDUS",
"RIGHT SQUARE BRACKET",
"CIRCUMFLEX ACCENT",
"LOW LINE",
"GRAVE ACCENT",
"LATIN SMALL LETTER A",
"LATIN SMALL LETTER B",
"LATIN SMALL LETTER C",
"LATIN SMALL LETTER D",
"LATIN SMALL LETTER E",
"LATIN SMALL LETTER F",
"LATIN SMALL LETTER G",
"LATIN SMALL LETTER H",
"LATIN SMALL LETTER I",
"LATIN SMALL LETTER J",
"LATIN SMALL LETTER K",
"LATIN SMALL LETTER L",
"LATIN SMALL LETTER M",
"LATIN SMALL LETTER N",
"LATIN SMALL LETTER O",
"LATIN SMALL LETTER P",
"LATIN SMALL LETTER Q",
"LATIN SMALL LETTER R",
"LATIN SMALL LETTER S",
"LATIN SMALL LETTER T",
"LATIN SMALL LETTER U",
"LATIN SMALL LETTER V",
"LATIN SMALL LETTER W",
"LATIN SMALL LETTER X",
"LATIN SMALL LETTER Y",
"LATIN SMALL LETTER Z",
"LEFT CURLY BRACKET",
"VERTICAL LINE",
"RIGHT CURLY BRACKET",
"TILDE",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"<control>",
"NO-BREAK SPACE",
"INVERTED EXCLAMATION MARK",
"CENT SIGN",
"POUND SIGN",
"CURRENCY SIGN",
"YEN SIGN",
"BROKEN BAR",
"SECTION SIGN",
"DIAERESIS",
"COPYRIGHT SIGN",
"FEMININE ORDINAL INDICATOR",
"LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",
"NOT SIGN",
"SOFT HYPHEN",
"REGISTERED SIGN",
"MACRON",
"DEGREE SIGN",
"PLUS-MINUS SIGN",
"SUPERSCRIPT TWO",
"SUPERSCRIPT THREE",
"ACUTE ACCENT",
"MICRO SIGN",
"PILCROW SIGN",
"MIDDLE DOT",
"CEDILLA",
"SUPERSCRIPT ONE",
"MASCULINE ORDINAL INDICATOR",
"RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK",
"VULGAR FRACTION ONE QUARTER",
"VULGAR FRACTION ONE HALF",
"VULGAR FRACTION THREE QUARTERS",
"INVERTED QUESTION MARK",
"LATIN CAPITAL LETTER A WITH GRAVE",
"LATIN CAPITAL LETTER A WITH ACUTE",
"LATIN CAPITAL LETTER A WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER A WITH TILDE",
"LATIN CAPITAL LETTER A WITH DIAERESIS",
"LATIN CAPITAL LETTER A WITH RING ABOVE",
"LATIN CAPITAL LETTER AE",
"LATIN CAPITAL LETTER C WITH CEDILLA",
"LATIN CAPITAL LETTER E WITH GRAVE",
"LATIN CAPITAL LETTER E WITH ACUTE",
"LATIN CAPITAL LETTER E WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER E WITH DIAERESIS",
"LATIN CAPITAL LETTER I WITH GRAVE",
"LATIN CAPITAL LETTER I WITH ACUTE",
"LATIN CAPITAL LETTER I WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER I WITH DIAERESIS",
"LATIN CAPITAL LETTER ETH",
"LATIN CAPITAL LETTER N WITH TILDE",
"LATIN CAPITAL LETTER O WITH GRAVE",
"LATIN CAPITAL LETTER O WITH ACUTE",
"LATIN CAPITAL LETTER O WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER O WITH TILDE",
"LATIN CAPITAL LETTER O WITH DIAERESIS",
"MULTIPLICATION SIGN",
"LATIN CAPITAL LETTER O WITH STROKE",
"LATIN CAPITAL LETTER U WITH GRAVE",
"LATIN CAPITAL LETTER U WITH ACUTE",
"LATIN CAPITAL LETTER U WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER U WITH DIAERESIS",
"LATIN CAPITAL LETTER Y WITH ACUTE",
"LATIN CAPITAL LETTER THORN",
"LATIN SMALL LETTER SHARP S",
"LATIN SMALL LETTER A WITH GRAVE",
"LATIN SMALL LETTER A WITH ACUTE",
"LATIN SMALL LETTER A WITH CIRCUMFLEX",
"LATIN SMALL LETTER A WITH TILDE",
"LATIN SMALL LETTER A WITH DIAERESIS",
"LATIN SMALL LETTER A WITH RING ABOVE",
"LATIN SMALL LETTER AE",
"LATIN SMALL LETTER C WITH CEDILLA",
"LATIN SMALL LETTER E WITH GRAVE",
"LATIN SMALL LETTER E WITH ACUTE",
"LATIN SMALL LETTER E WITH CIRCUMFLEX",
"LATIN SMALL LETTER E WITH DIAERESIS",
"LATIN SMALL LETTER I WITH GRAVE",
"LATIN SMALL LETTER I WITH ACUTE",
"LATIN SMALL LETTER I WITH CIRCUMFLEX",
"LATIN SMALL LETTER I WITH DIAERESIS",
"LATIN SMALL LETTER ETH",
"LATIN SMALL LETTER N WITH TILDE",
"LATIN SMALL LETTER O WITH GRAVE",
"LATIN SMALL LETTER O WITH ACUTE",
"LATIN SMALL LETTER O WITH CIRCUMFLEX",
"LATIN SMALL LETTER O WITH TILDE",
"LATIN SMALL LETTER O WITH DIAERESIS",
"DIVISION SIGN",
"LATIN SMALL LETTER O WITH STROKE",
"LATIN SMALL LETTER U WITH GRAVE",
"LATIN SMALL LETTER U WITH ACUTE",
"LATIN SMALL LETTER U WITH CIRCUMFLEX",
"LATIN SMALL LETTER U WITH DIAERESIS",
"LATIN SMALL LETTER Y WITH ACUTE",
"LATIN SMALL LETTER THORN",
"LATIN SMALL LETTER Y WITH DIAERESIS"};
static const char * name_0001[256] =
{
"LATIN CAPITAL LETTER A WITH MACRON",
"LATIN SMALL LETTER A WITH MACRON",
"LATIN CAPITAL LETTER A WITH BREVE",
"LATIN SMALL LETTER A WITH BREVE",
"LATIN CAPITAL LETTER A WITH OGONEK",
"LATIN SMALL LETTER A WITH OGONEK",
"LATIN CAPITAL LETTER C WITH ACUTE",
"LATIN SMALL LETTER C WITH ACUTE",
"LATIN CAPITAL LETTER C WITH CIRCUMFLEX",
"LATIN SMALL LETTER C WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER C WITH DOT ABOVE",
"LATIN SMALL LETTER C WITH DOT ABOVE",
"LATIN CAPITAL LETTER C WITH CARON",
"LATIN SMALL LETTER C WITH CARON",
"LATIN CAPITAL LETTER D WITH CARON",
"LATIN SMALL LETTER D WITH CARON",
"LATIN CAPITAL LETTER D WITH STROKE",
"LATIN SMALL LETTER D WITH STROKE",
"LATIN CAPITAL LETTER E WITH MACRON",
"LATIN SMALL LETTER E WITH MACRON",
"LATIN CAPITAL LETTER E WITH BREVE",
"LATIN SMALL LETTER E WITH BREVE",
"LATIN CAPITAL LETTER E WITH DOT ABOVE",
"LATIN SMALL LETTER E WITH DOT ABOVE",
"LATIN CAPITAL LETTER E WITH OGONEK",
"LATIN SMALL LETTER E WITH OGONEK",
"LATIN CAPITAL LETTER E WITH CARON",
"LATIN SMALL LETTER E WITH CARON",
"LATIN CAPITAL LETTER G WITH CIRCUMFLEX",
"LATIN SMALL LETTER G WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER G WITH BREVE",
"LATIN SMALL LETTER G WITH BREVE",
"LATIN CAPITAL LETTER G WITH DOT ABOVE",
"LATIN SMALL LETTER G WITH DOT ABOVE",
"LATIN CAPITAL LETTER G WITH CEDILLA",
"LATIN SMALL LETTER G WITH CEDILLA",
"LATIN CAPITAL LETTER H WITH CIRCUMFLEX",
"LATIN SMALL LETTER H WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER H WITH STROKE",
"LATIN SMALL LETTER H WITH STROKE",
"LATIN CAPITAL LETTER I WITH TILDE",
"LATIN SMALL LETTER I WITH TILDE",
"LATIN CAPITAL LETTER I WITH MACRON",
"LATIN SMALL LETTER I WITH MACRON",
"LATIN CAPITAL LETTER I WITH BREVE",
"LATIN SMALL LETTER I WITH BREVE",
"LATIN CAPITAL LETTER I WITH OGONEK",
"LATIN SMALL LETTER I WITH OGONEK",
"LATIN CAPITAL LETTER I WITH DOT ABOVE",
"LATIN SMALL LETTER DOTLESS I",
"LATIN CAPITAL LIGATURE IJ",
"LATIN SMALL LIGATURE IJ",
"LATIN CAPITAL LETTER J WITH CIRCUMFLEX",
"LATIN SMALL LETTER J WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER K WITH CEDILLA",
"LATIN SMALL LETTER K WITH CEDILLA",
"LATIN SMALL LETTER KRA",
"LATIN CAPITAL LETTER L WITH ACUTE",
"LATIN SMALL LETTER L WITH ACUTE",
"LATIN CAPITAL LETTER L WITH CEDILLA",
"LATIN SMALL LETTER L WITH CEDILLA",
"LATIN CAPITAL LETTER L WITH CARON",
"LATIN SMALL LETTER L WITH CARON",
"LATIN CAPITAL LETTER L WITH MIDDLE DOT",
"LATIN SMALL LETTER L WITH MIDDLE DOT",
"LATIN CAPITAL LETTER L WITH STROKE",
"LATIN SMALL LETTER L WITH STROKE",
"LATIN CAPITAL LETTER N WITH ACUTE",
"LATIN SMALL LETTER N WITH ACUTE",
"LATIN CAPITAL LETTER N WITH CEDILLA",
"LATIN SMALL LETTER N WITH CEDILLA",
"LATIN CAPITAL LETTER N WITH CARON",
"LATIN SMALL LETTER N WITH CARON",
"LATIN SMALL LETTER N PRECEDED BY APOSTROPHE",
"LATIN CAPITAL LETTER ENG",
"LATIN SMALL LETTER ENG",
"LATIN CAPITAL LETTER O WITH MACRON",
"LATIN SMALL LETTER O WITH MACRON",
"LATIN CAPITAL LETTER O WITH BREVE",
"LATIN SMALL LETTER O WITH BREVE",
"LATIN CAPITAL LETTER O WITH DOUBLE ACUTE",
"LATIN SMALL LETTER O WITH DOUBLE ACUTE",
"LATIN CAPITAL LIGATURE OE",
"LATIN SMALL LIGATURE OE",
"LATIN CAPITAL LETTER R WITH ACUTE",
"LATIN SMALL LETTER R WITH ACUTE",
"LATIN CAPITAL LETTER R WITH CEDILLA",
"LATIN SMALL LETTER R WITH CEDILLA",
"LATIN CAPITAL LETTER R WITH CARON",
"LATIN SMALL LETTER R WITH CARON",
"LATIN CAPITAL LETTER S WITH ACUTE",
"LATIN SMALL LETTER S WITH ACUTE",
"LATIN CAPITAL LETTER S WITH CIRCUMFLEX",
"LATIN SMALL LETTER S WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER S WITH CEDILLA",
"LATIN SMALL LETTER S WITH CEDILLA",
"LATIN CAPITAL LETTER S WITH CARON",
"LATIN SMALL LETTER S WITH CARON",
"LATIN CAPITAL LETTER T WITH CEDILLA",
"LATIN SMALL LETTER T WITH CEDILLA",
"LATIN CAPITAL LETTER T WITH CARON",
"LATIN SMALL LETTER T WITH CARON",
"LATIN CAPITAL LETTER T WITH STROKE",
"LATIN SMALL LETTER T WITH STROKE",
"LATIN CAPITAL LETTER U WITH TILDE",
"LATIN SMALL LETTER U WITH TILDE",
"LATIN CAPITAL LETTER U WITH MACRON",
"LATIN SMALL LETTER U WITH MACRON",
"LATIN CAPITAL LETTER U WITH BREVE",
"LATIN SMALL LETTER U WITH BREVE",
"LATIN CAPITAL LETTER U WITH RING ABOVE",
"LATIN SMALL LETTER U WITH RING ABOVE",
"LATIN CAPITAL LETTER U WITH DOUBLE ACUTE",
"LATIN SMALL LETTER U WITH DOUBLE ACUTE",
"LATIN CAPITAL LETTER U WITH OGONEK",
"LATIN SMALL LETTER U WITH OGONEK",
"LATIN CAPITAL LETTER W WITH CIRCUMFLEX",
"LATIN SMALL LETTER W WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER Y WITH CIRCUMFLEX",
"LATIN SMALL LETTER Y WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER Y WITH DIAERESIS",
"LATIN CAPITAL LETTER Z WITH ACUTE",
"LATIN SMALL LETTER Z WITH ACUTE",
"LATIN CAPITAL LETTER Z WITH DOT ABOVE",
"LATIN SMALL LETTER Z WITH DOT ABOVE",
"LATIN CAPITAL LETTER Z WITH CARON",
"LATIN SMALL LETTER Z WITH CARON",
"LATIN SMALL LETTER LONG S",
"LATIN SMALL LETTER B WITH STROKE",
"LATIN CAPITAL LETTER B WITH HOOK",
"LATIN CAPITAL LETTER B WITH TOPBAR",
"LATIN SMALL LETTER B WITH TOPBAR",
"LATIN CAPITAL LETTER TONE SIX",
"LATIN SMALL LETTER TONE SIX",
"LATIN CAPITAL LETTER OPEN O",
"LATIN CAPITAL LETTER C WITH HOOK",
"LATIN SMALL LETTER C WITH HOOK",
"LATIN CAPITAL LETTER AFRICAN D",
"LATIN CAPITAL LETTER D WITH HOOK",
"LATIN CAPITAL LETTER D WITH TOPBAR",
"LATIN SMALL LETTER D WITH TOPBAR",
"LATIN SMALL LETTER TURNED DELTA",
"LATIN CAPITAL LETTER REVERSED E",
"LATIN CAPITAL LETTER SCHWA",
"LATIN CAPITAL LETTER OPEN E",
"LATIN CAPITAL LETTER F WITH HOOK",
"LATIN SMALL LETTER F WITH HOOK",
"LATIN CAPITAL LETTER G WITH HOOK",
"LATIN CAPITAL LETTER GAMMA",
"LATIN SMALL LETTER HV",
"LATIN CAPITAL LETTER IOTA",
"LATIN CAPITAL LETTER I WITH STROKE",
"LATIN CAPITAL LETTER K WITH HOOK",
"LATIN SMALL LETTER K WITH HOOK",
"LATIN SMALL LETTER L WITH BAR",
"LATIN SMALL LETTER LAMBDA WITH STROKE",
"LATIN CAPITAL LETTER TURNED M",
"LATIN CAPITAL LETTER N WITH LEFT HOOK",
"LATIN SMALL LETTER N WITH LONG RIGHT LEG",
"LATIN CAPITAL LETTER O WITH MIDDLE TILDE",
"LATIN CAPITAL LETTER O WITH HORN",
"LATIN SMALL LETTER O WITH HORN",
"LATIN CAPITAL LETTER OI",
"LATIN SMALL LETTER OI",
"LATIN CAPITAL LETTER P WITH HOOK",
"LATIN SMALL LETTER P WITH HOOK",
"LATIN LETTER YR",
"LATIN CAPITAL LETTER TONE TWO",
"LATIN SMALL LETTER TONE TWO",
"LATIN CAPITAL LETTER ESH",
"LATIN LETTER REVERSED ESH LOOP",
"LATIN SMALL LETTER T WITH PALATAL HOOK",
"LATIN CAPITAL LETTER T WITH HOOK",
"LATIN SMALL LETTER T WITH HOOK",
"LATIN CAPITAL LETTER T WITH RETROFLEX HOOK",
"LATIN CAPITAL LETTER U WITH HORN",
"LATIN SMALL LETTER U WITH HORN",
"LATIN CAPITAL LETTER UPSILON",
"LATIN CAPITAL LETTER V WITH HOOK",
"LATIN CAPITAL LETTER Y WITH HOOK",
"LATIN SMALL LETTER Y WITH HOOK",
"LATIN CAPITAL LETTER Z WITH STROKE",
"LATIN SMALL LETTER Z WITH STROKE",
"LATIN CAPITAL LETTER EZH",
"LATIN CAPITAL LETTER EZH REVERSED",
"LATIN SMALL LETTER EZH REVERSED",
"LATIN SMALL LETTER EZH WITH TAIL",
"LATIN LETTER TWO WITH STROKE",
"LATIN CAPITAL LETTER TONE FIVE",
"LATIN SMALL LETTER TONE FIVE",
"LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE",
"LATIN LETTER WYNN",
"LATIN LETTER DENTAL CLICK",
"LATIN LETTER LATERAL CLICK",
"LATIN LETTER ALVEOLAR CLICK",
"LATIN LETTER RETROFLEX CLICK",
"LATIN CAPITAL LETTER DZ WITH CARON",
"LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON",
"LATIN SMALL LETTER DZ WITH CARON",
"LATIN CAPITAL LETTER LJ",
"LATIN CAPITAL LETTER L WITH SMALL LETTER J",
"LATIN SMALL LETTER LJ",
"LATIN CAPITAL LETTER NJ",
"LATIN CAPITAL LETTER N WITH SMALL LETTER J",
"LATIN SMALL LETTER NJ",
"LATIN CAPITAL LETTER A WITH CARON",
"LATIN SMALL LETTER A WITH CARON",
"LATIN CAPITAL LETTER I WITH CARON",
"LATIN SMALL LETTER I WITH CARON",
"LATIN CAPITAL LETTER O WITH CARON",
"LATIN SMALL LETTER O WITH CARON",
"LATIN CAPITAL LETTER U WITH CARON",
"LATIN SMALL LETTER U WITH CARON",
"LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON",
"LATIN SMALL LETTER U WITH DIAERESIS AND MACRON",
"LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE",
"LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE",
"LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON",
"LATIN SMALL LETTER U WITH DIAERESIS AND CARON",
"LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE",
"LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE",
"LATIN SMALL LETTER TURNED E",
"LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON",
"LATIN SMALL LETTER A WITH DIAERESIS AND MACRON",
"LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON",
"LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON",
"LATIN CAPITAL LETTER AE WITH MACRON",
"LATIN SMALL LETTER AE WITH MACRON",
"LATIN CAPITAL LETTER G WITH STROKE",
"LATIN SMALL LETTER G WITH STROKE",
"LATIN CAPITAL LETTER G WITH CARON",
"LATIN SMALL LETTER G WITH CARON",
"LATIN CAPITAL LETTER K WITH CARON",
"LATIN SMALL LETTER K WITH CARON",
"LATIN CAPITAL LETTER O WITH OGONEK",
"LATIN SMALL LETTER O WITH OGONEK",
"LATIN CAPITAL LETTER O WITH OGONEK AND MACRON",
"LATIN SMALL LETTER O WITH OGONEK AND MACRON",
"LATIN CAPITAL LETTER EZH WITH CARON",
"LATIN SMALL LETTER EZH WITH CARON",
"LATIN SMALL LETTER J WITH CARON",
"LATIN CAPITAL LETTER DZ",
"LATIN CAPITAL LETTER D WITH SMALL LETTER Z",
"LATIN SMALL LETTER DZ",
"LATIN CAPITAL LETTER G WITH ACUTE",
"LATIN SMALL LETTER G WITH ACUTE",
"LATIN CAPITAL LETTER HWAIR",
"LATIN CAPITAL LETTER WYNN",
"LATIN CAPITAL LETTER N WITH GRAVE",
"LATIN SMALL LETTER N WITH GRAVE",
"LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE",
"LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE",
"LATIN CAPITAL LETTER AE WITH ACUTE",
"LATIN SMALL LETTER AE WITH ACUTE",
"LATIN CAPITAL LETTER O WITH STROKE AND ACUTE",
"LATIN SMALL LETTER O WITH STROKE AND ACUTE"};
static const char * name_0002[256] =
{
"LATIN CAPITAL LETTER A WITH DOUBLE GRAVE",
"LATIN SMALL LETTER A WITH DOUBLE GRAVE",
"LATIN CAPITAL LETTER A WITH INVERTED BREVE",
"LATIN SMALL LETTER A WITH INVERTED BREVE",
"LATIN CAPITAL LETTER E WITH DOUBLE GRAVE",
"LATIN SMALL LETTER E WITH DOUBLE GRAVE",
"LATIN CAPITAL LETTER E WITH INVERTED BREVE",
"LATIN SMALL LETTER E WITH INVERTED BREVE",
"LATIN CAPITAL LETTER I WITH DOUBLE GRAVE",
"LATIN SMALL LETTER I WITH DOUBLE GRAVE",
"LATIN CAPITAL LETTER I WITH INVERTED BREVE",
"LATIN SMALL LETTER I WITH INVERTED BREVE",
"LATIN CAPITAL LETTER O WITH DOUBLE GRAVE",
"LATIN SMALL LETTER O WITH DOUBLE GRAVE",
"LATIN CAPITAL LETTER O WITH INVERTED BREVE",
"LATIN SMALL LETTER O WITH INVERTED BREVE",
"LATIN CAPITAL LETTER R WITH DOUBLE GRAVE",
"LATIN SMALL LETTER R WITH DOUBLE GRAVE",
"LATIN CAPITAL LETTER R WITH INVERTED BREVE",
"LATIN SMALL LETTER R WITH INVERTED BREVE",
"LATIN CAPITAL LETTER U WITH DOUBLE GRAVE",
"LATIN SMALL LETTER U WITH DOUBLE GRAVE",
"LATIN CAPITAL LETTER U WITH INVERTED BREVE",
"LATIN SMALL LETTER U WITH INVERTED BREVE",
"LATIN CAPITAL LETTER S WITH COMMA BELOW",
"LATIN SMALL LETTER S WITH COMMA BELOW",
"LATIN CAPITAL LETTER T WITH COMMA BELOW",
"LATIN SMALL LETTER T WITH COMMA BELOW",
"LATIN CAPITAL LETTER YOGH",
"LATIN SMALL LETTER YOGH",
"LATIN CAPITAL LETTER H WITH CARON",
"LATIN SMALL LETTER H WITH CARON",
"LATIN CAPITAL LETTER N WITH LONG RIGHT LEG",
"LATIN SMALL LETTER D WITH CURL",
"LATIN CAPITAL LETTER OU",
"LATIN SMALL LETTER OU",
"LATIN CAPITAL LETTER Z WITH HOOK",
"LATIN SMALL LETTER Z WITH HOOK",
"LATIN CAPITAL LETTER A WITH DOT ABOVE",
"LATIN SMALL LETTER A WITH DOT ABOVE",
"LATIN CAPITAL LETTER E WITH CEDILLA",
"LATIN SMALL LETTER E WITH CEDILLA",
"LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON",
"LATIN SMALL LETTER O WITH DIAERESIS AND MACRON",
"LATIN CAPITAL LETTER O WITH TILDE AND MACRON",
"LATIN SMALL LETTER O WITH TILDE AND MACRON",
"LATIN CAPITAL LETTER O WITH DOT ABOVE",
"LATIN SMALL LETTER O WITH DOT ABOVE",
"LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON",
"LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON",
"LATIN CAPITAL LETTER Y WITH MACRON",
"LATIN SMALL LETTER Y WITH MACRON",
"LATIN SMALL LETTER L WITH CURL",
"LATIN SMALL LETTER N WITH CURL",
"LATIN SMALL LETTER T WITH CURL",
"LATIN SMALL LETTER DOTLESS J",
"LATIN SMALL LETTER DB DIGRAPH",
"LATIN SMALL LETTER QP DIGRAPH",
"LATIN CAPITAL LETTER A WITH STROKE",
"LATIN CAPITAL LETTER C WITH STROKE",
"LATIN SMALL LETTER C WITH STROKE",
"LATIN CAPITAL LETTER L WITH BAR",
"LATIN CAPITAL LETTER T WITH DIAGONAL STROKE",
"LATIN SMALL LETTER S WITH SWASH TAIL",
"LATIN SMALL LETTER Z WITH SWASH TAIL",
"LATIN CAPITAL LETTER GLOTTAL STOP",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"LATIN SMALL LETTER TURNED A",
"LATIN SMALL LETTER ALPHA",
"LATIN SMALL LETTER TURNED ALPHA",
"LATIN SMALL LETTER B WITH HOOK",
"LATIN SMALL LETTER OPEN O",
"LATIN SMALL LETTER C WITH CURL",
"LATIN SMALL LETTER D WITH TAIL",
"LATIN SMALL LETTER D WITH HOOK",
"LATIN SMALL LETTER REVERSED E",
"LATIN SMALL LETTER SCHWA",
"LATIN SMALL LETTER SCHWA WITH HOOK",
"LATIN SMALL LETTER OPEN E",
"LATIN SMALL LETTER REVERSED OPEN E",
"LATIN SMALL LETTER REVERSED OPEN E WITH HOOK",
"LATIN SMALL LETTER CLOSED REVERSED OPEN E",
"LATIN SMALL LETTER DOTLESS J WITH STROKE",
"LATIN SMALL LETTER G WITH HOOK",
"LATIN SMALL LETTER SCRIPT G",
"LATIN LETTER SMALL CAPITAL G",
"LATIN SMALL LETTER GAMMA",
"LATIN SMALL LETTER RAMS HORN",
"LATIN SMALL LETTER TURNED H",
"LATIN SMALL LETTER H WITH HOOK",
"LATIN SMALL LETTER HENG WITH HOOK",
"LATIN SMALL LETTER I WITH STROKE",
"LATIN SMALL LETTER IOTA",
"LATIN LETTER SMALL CAPITAL I",
"LATIN SMALL LETTER L WITH MIDDLE TILDE",
"LATIN SMALL LETTER L WITH BELT",
"LATIN SMALL LETTER L WITH RETROFLEX HOOK",
"LATIN SMALL LETTER LEZH",
"LATIN SMALL LETTER TURNED M",
"LATIN SMALL LETTER TURNED M WITH LONG LEG",
"LATIN SMALL LETTER M WITH HOOK",
"LATIN SMALL LETTER N WITH LEFT HOOK",
"LATIN SMALL LETTER N WITH RETROFLEX HOOK",
"LATIN LETTER SMALL CAPITAL N",
"LATIN SMALL LETTER BARRED O",
"LATIN LETTER SMALL CAPITAL OE",
"LATIN SMALL LETTER CLOSED OMEGA",
"LATIN SMALL LETTER PHI",
"LATIN SMALL LETTER TURNED R",
"LATIN SMALL LETTER TURNED R WITH LONG LEG",
"LATIN SMALL LETTER TURNED R WITH HOOK",
"LATIN SMALL LETTER R WITH LONG LEG",
"LATIN SMALL LETTER R WITH TAIL",
"LATIN SMALL LETTER R WITH FISHHOOK",
"LATIN SMALL LETTER REVERSED R WITH FISHHOOK",
"LATIN LETTER SMALL CAPITAL R",
"LATIN LETTER SMALL CAPITAL INVERTED R",
"LATIN SMALL LETTER S WITH HOOK",
"LATIN SMALL LETTER ESH",
"LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK",
"LATIN SMALL LETTER SQUAT REVERSED ESH",
"LATIN SMALL LETTER ESH WITH CURL",
"LATIN SMALL LETTER TURNED T",
"LATIN SMALL LETTER T WITH RETROFLEX HOOK",
"LATIN SMALL LETTER U BAR",
"LATIN SMALL LETTER UPSILON",
"LATIN SMALL LETTER V WITH HOOK",
"LATIN SMALL LETTER TURNED V",
"LATIN SMALL LETTER TURNED W",
"LATIN SMALL LETTER TURNED Y",
"LATIN LETTER SMALL CAPITAL Y",
"LATIN SMALL LETTER Z WITH RETROFLEX HOOK",
"LATIN SMALL LETTER Z WITH CURL",
"LATIN SMALL LETTER EZH",
"LATIN SMALL LETTER EZH WITH CURL",
"LATIN LETTER GLOTTAL STOP",
"LATIN LETTER PHARYNGEAL VOICED FRICATIVE",
"LATIN LETTER INVERTED GLOTTAL STOP",
"LATIN LETTER STRETCHED C",
"LATIN LETTER BILABIAL CLICK",
"LATIN LETTER SMALL CAPITAL B",
"LATIN SMALL LETTER CLOSED OPEN E",
"LATIN LETTER SMALL CAPITAL G WITH HOOK",
"LATIN LETTER SMALL CAPITAL H",
"LATIN SMALL LETTER J WITH CROSSED-TAIL",
"LATIN SMALL LETTER TURNED K",
"LATIN LETTER SMALL CAPITAL L",
"LATIN SMALL LETTER Q WITH HOOK",
"LATIN LETTER GLOTTAL STOP WITH STROKE",
"LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE",
"LATIN SMALL LETTER DZ DIGRAPH",
"LATIN SMALL LETTER DEZH DIGRAPH",
"LATIN SMALL LETTER DZ DIGRAPH WITH CURL",
"LATIN SMALL LETTER TS DIGRAPH",
"LATIN SMALL LETTER TESH DIGRAPH",
"LATIN SMALL LETTER TC DIGRAPH WITH CURL",
"LATIN SMALL LETTER FENG DIGRAPH",
"LATIN SMALL LETTER LS DIGRAPH",
"LATIN SMALL LETTER LZ DIGRAPH",
"LATIN LETTER BILABIAL PERCUSSIVE",
"LATIN LETTER BIDENTAL PERCUSSIVE",
"LATIN SMALL LETTER TURNED H WITH FISHHOOK",
"LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL",
"MODIFIER LETTER SMALL H",
"MODIFIER LETTER SMALL H WITH HOOK",
"MODIFIER LETTER SMALL J",
"MODIFIER LETTER SMALL R",
"MODIFIER LETTER SMALL TURNED R",
"MODIFIER LETTER SMALL TURNED R WITH HOOK",
"MODIFIER LETTER SMALL CAPITAL INVERTED R",
"MODIFIER LETTER SMALL W",
"MODIFIER LETTER SMALL Y",
"MODIFIER LETTER PRIME",
"MODIFIER LETTER DOUBLE PRIME",
"MODIFIER LETTER TURNED COMMA",
"MODIFIER LETTER APOSTROPHE",
"MODIFIER LETTER REVERSED COMMA",
"MODIFIER LETTER RIGHT HALF RING",
"MODIFIER LETTER LEFT HALF RING",
"MODIFIER LETTER GLOTTAL STOP",
"MODIFIER LETTER REVERSED GLOTTAL STOP",
"MODIFIER LETTER LEFT ARROWHEAD",
"MODIFIER LETTER RIGHT ARROWHEAD",
"MODIFIER LETTER UP ARROWHEAD",
"MODIFIER LETTER DOWN ARROWHEAD",
"MODIFIER LETTER CIRCUMFLEX ACCENT",
"CARON",
"MODIFIER LETTER VERTICAL LINE",
"MODIFIER LETTER MACRON",
"MODIFIER LETTER ACUTE ACCENT",
"MODIFIER LETTER GRAVE ACCENT",
"MODIFIER LETTER LOW VERTICAL LINE",
"MODIFIER LETTER LOW MACRON",
"MODIFIER LETTER LOW GRAVE ACCENT",
"MODIFIER LETTER LOW ACUTE ACCENT",
"MODIFIER LETTER TRIANGULAR COLON",
"MODIFIER LETTER HALF TRIANGULAR COLON",
"MODIFIER LETTER CENTRED RIGHT HALF RING",
"MODIFIER LETTER CENTRED LEFT HALF RING",
"MODIFIER LETTER UP TACK",
"MODIFIER LETTER DOWN TACK",
"MODIFIER LETTER PLUS SIGN",
"MODIFIER LETTER MINUS SIGN",
"BREVE",
"DOT ABOVE",
"RING ABOVE",
"OGONEK",
"SMALL TILDE",
"DOUBLE ACUTE ACCENT",
"MODIFIER LETTER RHOTIC HOOK",
"MODIFIER LETTER CROSS ACCENT",
"MODIFIER LETTER SMALL GAMMA",
"MODIFIER LETTER SMALL L",
"MODIFIER LETTER SMALL S",
"MODIFIER LETTER SMALL X",
"MODIFIER LETTER SMALL REVERSED GLOTTAL STOP",
"MODIFIER LETTER EXTRA-HIGH TONE BAR",
"MODIFIER LETTER HIGH TONE BAR",
"MODIFIER LETTER MID TONE BAR",
"MODIFIER LETTER LOW TONE BAR",
"MODIFIER LETTER EXTRA-LOW TONE BAR",
"MODIFIER LETTER YIN DEPARTING TONE MARK",
"MODIFIER LETTER YANG DEPARTING TONE MARK",
"MODIFIER LETTER VOICING",
"MODIFIER LETTER UNASPIRATED",
"MODIFIER LETTER DOUBLE APOSTROPHE",
"MODIFIER LETTER LOW DOWN ARROWHEAD",
"MODIFIER LETTER LOW UP ARROWHEAD",
"MODIFIER LETTER LOW LEFT ARROWHEAD",
"MODIFIER LETTER LOW RIGHT ARROWHEAD",
"MODIFIER LETTER LOW RING",
"MODIFIER LETTER MIDDLE GRAVE ACCENT",
"MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT",
"MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT",
"MODIFIER LETTER LOW TILDE",
"MODIFIER LETTER RAISED COLON",
"MODIFIER LETTER BEGIN HIGH TONE",
"MODIFIER LETTER END HIGH TONE",
"MODIFIER LETTER BEGIN LOW TONE",
"MODIFIER LETTER END LOW TONE",
"MODIFIER LETTER SHELF",
"MODIFIER LETTER OPEN SHELF",
"MODIFIER LETTER LOW LEFT ARROW"};
static const char * name_0003[256] =
{
"COMBINING GRAVE ACCENT",
"COMBINING ACUTE ACCENT",
"COMBINING CIRCUMFLEX ACCENT",
"COMBINING TILDE",
"COMBINING MACRON",
"COMBINING OVERLINE",
"COMBINING BREVE",
"COMBINING DOT ABOVE",
"COMBINING DIAERESIS",
"COMBINING HOOK ABOVE",
"COMBINING RING ABOVE",
"COMBINING DOUBLE ACUTE ACCENT",
"COMBINING CARON",
"COMBINING VERTICAL LINE ABOVE",
"COMBINING DOUBLE VERTICAL LINE ABOVE",
"COMBINING DOUBLE GRAVE ACCENT",
"COMBINING CANDRABINDU",
"COMBINING INVERTED BREVE",
"COMBINING TURNED COMMA ABOVE",
"COMBINING COMMA ABOVE",
"COMBINING REVERSED COMMA ABOVE",
"COMBINING COMMA ABOVE RIGHT",
"COMBINING GRAVE ACCENT BELOW",
"COMBINING ACUTE ACCENT BELOW",
"COMBINING LEFT TACK BELOW",
"COMBINING RIGHT TACK BELOW",
"COMBINING LEFT ANGLE ABOVE",
"COMBINING HORN",
"COMBINING LEFT HALF RING BELOW",
"COMBINING UP TACK BELOW",
"COMBINING DOWN TACK BELOW",
"COMBINING PLUS SIGN BELOW",
"COMBINING MINUS SIGN BELOW",
"COMBINING PALATALIZED HOOK BELOW",
"COMBINING RETROFLEX HOOK BELOW",
"COMBINING DOT BELOW",
"COMBINING DIAERESIS BELOW",
"COMBINING RING BELOW",
"COMBINING COMMA BELOW",
"COMBINING CEDILLA",
"COMBINING OGONEK",
"COMBINING VERTICAL LINE BELOW",
"COMBINING BRIDGE BELOW",
"COMBINING INVERTED DOUBLE ARCH BELOW",
"COMBINING CARON BELOW",
"COMBINING CIRCUMFLEX ACCENT BELOW",
"COMBINING BREVE BELOW",
"COMBINING INVERTED BREVE BELOW",
"COMBINING TILDE BELOW",
"COMBINING MACRON BELOW",
"COMBINING LOW LINE",
"COMBINING DOUBLE LOW LINE",
"COMBINING TILDE OVERLAY",
"COMBINING SHORT STROKE OVERLAY",
"COMBINING LONG STROKE OVERLAY",
"COMBINING SHORT SOLIDUS OVERLAY",
"COMBINING LONG SOLIDUS OVERLAY",
"COMBINING RIGHT HALF RING BELOW",
"COMBINING INVERTED BRIDGE BELOW",
"COMBINING SQUARE BELOW",
"COMBINING SEAGULL BELOW",
"COMBINING X ABOVE",
"COMBINING VERTICAL TILDE",
"COMBINING DOUBLE OVERLINE",
"COMBINING GRAVE TONE MARK",
"COMBINING ACUTE TONE MARK",
"COMBINING GREEK PERISPOMENI",
"COMBINING GREEK KORONIS",
"COMBINING GREEK DIALYTIKA TONOS",
"COMBINING GREEK YPOGEGRAMMENI",
"COMBINING BRIDGE ABOVE",
"COMBINING EQUALS SIGN BELOW",
"COMBINING DOUBLE VERTICAL LINE BELOW",
"COMBINING LEFT ANGLE BELOW",
"COMBINING NOT TILDE ABOVE",
"COMBINING HOMOTHETIC ABOVE",
"COMBINING ALMOST EQUAL TO ABOVE",
"COMBINING LEFT RIGHT ARROW BELOW",
"COMBINING UPWARDS ARROW BELOW",
"COMBINING GRAPHEME JOINER",
"COMBINING RIGHT ARROWHEAD ABOVE",
"COMBINING LEFT HALF RING ABOVE",
"COMBINING FERMATA",
"COMBINING X BELOW",
"COMBINING LEFT ARROWHEAD BELOW",
"COMBINING RIGHT ARROWHEAD BELOW",
"COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW",
"COMBINING RIGHT HALF RING ABOVE",
"COMBINING DOT ABOVE RIGHT",
"COMBINING ASTERISK BELOW",
"COMBINING DOUBLE RING BELOW",
"COMBINING ZIGZAG ABOVE",
"COMBINING DOUBLE BREVE BELOW",
"COMBINING DOUBLE BREVE",
"COMBINING DOUBLE MACRON",
"COMBINING DOUBLE MACRON BELOW",
"COMBINING DOUBLE TILDE",
"COMBINING DOUBLE INVERTED BREVE",
"COMBINING DOUBLE RIGHTWARDS ARROW BELOW",
"COMBINING LATIN SMALL LETTER A",
"COMBINING LATIN SMALL LETTER E",
"COMBINING LATIN SMALL LETTER I",
"COMBINING LATIN SMALL LETTER O",
"COMBINING LATIN SMALL LETTER U",
"COMBINING LATIN SMALL LETTER C",
"COMBINING LATIN SMALL LETTER D",
"COMBINING LATIN SMALL LETTER H",
"COMBINING LATIN SMALL LETTER M",
"COMBINING LATIN SMALL LETTER R",
"COMBINING LATIN SMALL LETTER T",
"COMBINING LATIN SMALL LETTER V",
"COMBINING LATIN SMALL LETTER X",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GREEK NUMERAL SIGN",
"GREEK LOWER NUMERAL SIGN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GREEK YPOGEGRAMMENI",
name_reserved,
name_reserved,
name_reserved,
"GREEK QUESTION MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GREEK TONOS",
"GREEK DIALYTIKA TONOS",
"GREEK CAPITAL LETTER ALPHA WITH TONOS",
"GREEK ANO TELEIA",
"GREEK CAPITAL LETTER EPSILON WITH TONOS",
"GREEK CAPITAL LETTER ETA WITH TONOS",
"GREEK CAPITAL LETTER IOTA WITH TONOS",
name_reserved,
"GREEK CAPITAL LETTER OMICRON WITH TONOS",
name_reserved,
"GREEK CAPITAL LETTER UPSILON WITH TONOS",
"GREEK CAPITAL LETTER OMEGA WITH TONOS",
"GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS",
"GREEK CAPITAL LETTER ALPHA",
"GREEK CAPITAL LETTER BETA",
"GREEK CAPITAL LETTER GAMMA",
"GREEK CAPITAL LETTER DELTA",
"GREEK CAPITAL LETTER EPSILON",
"GREEK CAPITAL LETTER ZETA",
"GREEK CAPITAL LETTER ETA",
"GREEK CAPITAL LETTER THETA",
"GREEK CAPITAL LETTER IOTA",
"GREEK CAPITAL LETTER KAPPA",
"GREEK CAPITAL LETTER LAMDA",
"GREEK CAPITAL LETTER MU",
"GREEK CAPITAL LETTER NU",
"GREEK CAPITAL LETTER XI",
"GREEK CAPITAL LETTER OMICRON",
"GREEK CAPITAL LETTER PI",
"GREEK CAPITAL LETTER RHO",
name_reserved,
"GREEK CAPITAL LETTER SIGMA",
"GREEK CAPITAL LETTER TAU",
"GREEK CAPITAL LETTER UPSILON",
"GREEK CAPITAL LETTER PHI",
"GREEK CAPITAL LETTER CHI",
"GREEK CAPITAL LETTER PSI",
"GREEK CAPITAL LETTER OMEGA",
"GREEK CAPITAL LETTER IOTA WITH DIALYTIKA",
"GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA",
"GREEK SMALL LETTER ALPHA WITH TONOS",
"GREEK SMALL LETTER EPSILON WITH TONOS",
"GREEK SMALL LETTER ETA WITH TONOS",
"GREEK SMALL LETTER IOTA WITH TONOS",
"GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS",
"GREEK SMALL LETTER ALPHA",
"GREEK SMALL LETTER BETA",
"GREEK SMALL LETTER GAMMA",
"GREEK SMALL LETTER DELTA",
"GREEK SMALL LETTER EPSILON",
"GREEK SMALL LETTER ZETA",
"GREEK SMALL LETTER ETA",
"GREEK SMALL LETTER THETA",
"GREEK SMALL LETTER IOTA",
"GREEK SMALL LETTER KAPPA",
"GREEK SMALL LETTER LAMDA",
"GREEK SMALL LETTER MU",
"GREEK SMALL LETTER NU",
"GREEK SMALL LETTER XI",
"GREEK SMALL LETTER OMICRON",
"GREEK SMALL LETTER PI",
"GREEK SMALL LETTER RHO",
"GREEK SMALL LETTER FINAL SIGMA",
"GREEK SMALL LETTER SIGMA",
"GREEK SMALL LETTER TAU",
"GREEK SMALL LETTER UPSILON",
"GREEK SMALL LETTER PHI",
"GREEK SMALL LETTER CHI",
"GREEK SMALL LETTER PSI",
"GREEK SMALL LETTER OMEGA",
"GREEK SMALL LETTER IOTA WITH DIALYTIKA",
"GREEK SMALL LETTER UPSILON WITH DIALYTIKA",
"GREEK SMALL LETTER OMICRON WITH TONOS",
"GREEK SMALL LETTER UPSILON WITH TONOS",
"GREEK SMALL LETTER OMEGA WITH TONOS",
name_reserved,
"GREEK BETA SYMBOL",
"GREEK THETA SYMBOL",
"GREEK UPSILON WITH HOOK SYMBOL",
"GREEK UPSILON WITH ACUTE AND HOOK SYMBOL",
"GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL",
"GREEK PHI SYMBOL",
"GREEK PI SYMBOL",
"GREEK KAI SYMBOL",
"GREEK LETTER ARCHAIC KOPPA",
"GREEK SMALL LETTER ARCHAIC KOPPA",
"GREEK LETTER STIGMA",
"GREEK SMALL LETTER STIGMA",
"GREEK LETTER DIGAMMA",
"GREEK SMALL LETTER DIGAMMA",
"GREEK LETTER KOPPA",
"GREEK SMALL LETTER KOPPA",
"GREEK LETTER SAMPI",
"GREEK SMALL LETTER SAMPI",
"COPTIC CAPITAL LETTER SHEI",
"COPTIC SMALL LETTER SHEI",
"COPTIC CAPITAL LETTER FEI",
"COPTIC SMALL LETTER FEI",
"COPTIC CAPITAL LETTER KHEI",
"COPTIC SMALL LETTER KHEI",
"COPTIC CAPITAL LETTER HORI",
"COPTIC SMALL LETTER HORI",
"COPTIC CAPITAL LETTER GANGIA",
"COPTIC SMALL LETTER GANGIA",
"COPTIC CAPITAL LETTER SHIMA",
"COPTIC SMALL LETTER SHIMA",
"COPTIC CAPITAL LETTER DEI",
"COPTIC SMALL LETTER DEI",
"GREEK KAPPA SYMBOL",
"GREEK RHO SYMBOL",
"GREEK LUNATE SIGMA SYMBOL",
"GREEK LETTER YOT",
"GREEK CAPITAL THETA SYMBOL",
"GREEK LUNATE EPSILON SYMBOL",
"GREEK REVERSED LUNATE EPSILON SYMBOL",
"GREEK CAPITAL LETTER SHO",
"GREEK SMALL LETTER SHO",
"GREEK CAPITAL LUNATE SIGMA SYMBOL",
"GREEK CAPITAL LETTER SAN",
"GREEK SMALL LETTER SAN",
"GREEK RHO WITH STROKE SYMBOL",
"GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL",
"GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL",
"GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL"};
static const char * name_0004[256] =
{
"CYRILLIC CAPITAL LETTER IE WITH GRAVE",
"CYRILLIC CAPITAL LETTER IO",
"CYRILLIC CAPITAL LETTER DJE",
"CYRILLIC CAPITAL LETTER GJE",
"CYRILLIC CAPITAL LETTER UKRAINIAN IE",
"CYRILLIC CAPITAL LETTER DZE",
"CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I",
"CYRILLIC CAPITAL LETTER YI",
"CYRILLIC CAPITAL LETTER JE",
"CYRILLIC CAPITAL LETTER LJE",
"CYRILLIC CAPITAL LETTER NJE",
"CYRILLIC CAPITAL LETTER TSHE",
"CYRILLIC CAPITAL LETTER KJE",
"CYRILLIC CAPITAL LETTER I WITH GRAVE",
"CYRILLIC CAPITAL LETTER SHORT U",
"CYRILLIC CAPITAL LETTER DZHE",
"CYRILLIC CAPITAL LETTER A",
"CYRILLIC CAPITAL LETTER BE",
"CYRILLIC CAPITAL LETTER VE",
"CYRILLIC CAPITAL LETTER GHE",
"CYRILLIC CAPITAL LETTER DE",
"CYRILLIC CAPITAL LETTER IE",
"CYRILLIC CAPITAL LETTER ZHE",
"CYRILLIC CAPITAL LETTER ZE",
"CYRILLIC CAPITAL LETTER I",
"CYRILLIC CAPITAL LETTER SHORT I",
"CYRILLIC CAPITAL LETTER KA",
"CYRILLIC CAPITAL LETTER EL",
"CYRILLIC CAPITAL LETTER EM",
"CYRILLIC CAPITAL LETTER EN",
"CYRILLIC CAPITAL LETTER O",
"CYRILLIC CAPITAL LETTER PE",
"CYRILLIC CAPITAL LETTER ER",
"CYRILLIC CAPITAL LETTER ES",
"CYRILLIC CAPITAL LETTER TE",
"CYRILLIC CAPITAL LETTER U",
"CYRILLIC CAPITAL LETTER EF",
"CYRILLIC CAPITAL LETTER HA",
"CYRILLIC CAPITAL LETTER TSE",
"CYRILLIC CAPITAL LETTER CHE",
"CYRILLIC CAPITAL LETTER SHA",
"CYRILLIC CAPITAL LETTER SHCHA",
"CYRILLIC CAPITAL LETTER HARD SIGN",
"CYRILLIC CAPITAL LETTER YERU",
"CYRILLIC CAPITAL LETTER SOFT SIGN",
"CYRILLIC CAPITAL LETTER E",
"CYRILLIC CAPITAL LETTER YU",
"CYRILLIC CAPITAL LETTER YA",
"CYRILLIC SMALL LETTER A",
"CYRILLIC SMALL LETTER BE",
"CYRILLIC SMALL LETTER VE",
"CYRILLIC SMALL LETTER GHE",
"CYRILLIC SMALL LETTER DE",
"CYRILLIC SMALL LETTER IE",
"CYRILLIC SMALL LETTER ZHE",
"CYRILLIC SMALL LETTER ZE",
"CYRILLIC SMALL LETTER I",
"CYRILLIC SMALL LETTER SHORT I",
"CYRILLIC SMALL LETTER KA",
"CYRILLIC SMALL LETTER EL",
"CYRILLIC SMALL LETTER EM",
"CYRILLIC SMALL LETTER EN",
"CYRILLIC SMALL LETTER O",
"CYRILLIC SMALL LETTER PE",
"CYRILLIC SMALL LETTER ER",
"CYRILLIC SMALL LETTER ES",
"CYRILLIC SMALL LETTER TE",
"CYRILLIC SMALL LETTER U",
"CYRILLIC SMALL LETTER EF",
"CYRILLIC SMALL LETTER HA",
"CYRILLIC SMALL LETTER TSE",
"CYRILLIC SMALL LETTER CHE",
"CYRILLIC SMALL LETTER SHA",
"CYRILLIC SMALL LETTER SHCHA",
"CYRILLIC SMALL LETTER HARD SIGN",
"CYRILLIC SMALL LETTER YERU",
"CYRILLIC SMALL LETTER SOFT SIGN",
"CYRILLIC SMALL LETTER E",
"CYRILLIC SMALL LETTER YU",
"CYRILLIC SMALL LETTER YA",
"CYRILLIC SMALL LETTER IE WITH GRAVE",
"CYRILLIC SMALL LETTER IO",
"CYRILLIC SMALL LETTER DJE",
"CYRILLIC SMALL LETTER GJE",
"CYRILLIC SMALL LETTER UKRAINIAN IE",
"CYRILLIC SMALL LETTER DZE",
"CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I",
"CYRILLIC SMALL LETTER YI",
"CYRILLIC SMALL LETTER JE",
"CYRILLIC SMALL LETTER LJE",
"CYRILLIC SMALL LETTER NJE",
"CYRILLIC SMALL LETTER TSHE",
"CYRILLIC SMALL LETTER KJE",
"CYRILLIC SMALL LETTER I WITH GRAVE",
"CYRILLIC SMALL LETTER SHORT U",
"CYRILLIC SMALL LETTER DZHE",
"CYRILLIC CAPITAL LETTER OMEGA",
"CYRILLIC SMALL LETTER OMEGA",
"CYRILLIC CAPITAL LETTER YAT",
"CYRILLIC SMALL LETTER YAT",
"CYRILLIC CAPITAL LETTER IOTIFIED E",
"CYRILLIC SMALL LETTER IOTIFIED E",
"CYRILLIC CAPITAL LETTER LITTLE YUS",
"CYRILLIC SMALL LETTER LITTLE YUS",
"CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS",
"CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS",
"CYRILLIC CAPITAL LETTER BIG YUS",
"CYRILLIC SMALL LETTER BIG YUS",
"CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS",
"CYRILLIC SMALL LETTER IOTIFIED BIG YUS",
"CYRILLIC CAPITAL LETTER KSI",
"CYRILLIC SMALL LETTER KSI",
"CYRILLIC CAPITAL LETTER PSI",
"CYRILLIC SMALL LETTER PSI",
"CYRILLIC CAPITAL LETTER FITA",
"CYRILLIC SMALL LETTER FITA",
"CYRILLIC CAPITAL LETTER IZHITSA",
"CYRILLIC SMALL LETTER IZHITSA",
"CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
"CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
"CYRILLIC CAPITAL LETTER UK",
"CYRILLIC SMALL LETTER UK",
"CYRILLIC CAPITAL LETTER ROUND OMEGA",
"CYRILLIC SMALL LETTER ROUND OMEGA",
"CYRILLIC CAPITAL LETTER OMEGA WITH TITLO",
"CYRILLIC SMALL LETTER OMEGA WITH TITLO",
"CYRILLIC CAPITAL LETTER OT",
"CYRILLIC SMALL LETTER OT",
"CYRILLIC CAPITAL LETTER KOPPA",
"CYRILLIC SMALL LETTER KOPPA",
"CYRILLIC THOUSANDS SIGN",
"COMBINING CYRILLIC TITLO",
"COMBINING CYRILLIC PALATALIZATION",
"COMBINING CYRILLIC DASIA PNEUMATA",
"COMBINING CYRILLIC PSILI PNEUMATA",
name_reserved,
"COMBINING CYRILLIC HUNDRED THOUSANDS SIGN",
"COMBINING CYRILLIC MILLIONS SIGN",
"CYRILLIC CAPITAL LETTER SHORT I WITH TAIL",
"CYRILLIC SMALL LETTER SHORT I WITH TAIL",
"CYRILLIC CAPITAL LETTER SEMISOFT SIGN",
"CYRILLIC SMALL LETTER SEMISOFT SIGN",
"CYRILLIC CAPITAL LETTER ER WITH TICK",
"CYRILLIC SMALL LETTER ER WITH TICK",
"CYRILLIC CAPITAL LETTER GHE WITH UPTURN",
"CYRILLIC SMALL LETTER GHE WITH UPTURN",
"CYRILLIC CAPITAL LETTER GHE WITH STROKE",
"CYRILLIC SMALL LETTER GHE WITH STROKE",
"CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK",
"CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK",
"CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER",
"CYRILLIC SMALL LETTER ZHE WITH DESCENDER",
"CYRILLIC CAPITAL LETTER ZE WITH DESCENDER",
"CYRILLIC SMALL LETTER ZE WITH DESCENDER",
"CYRILLIC CAPITAL LETTER KA WITH DESCENDER",
"CYRILLIC SMALL LETTER KA WITH DESCENDER",
"CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE",
"CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE",
"CYRILLIC CAPITAL LETTER KA WITH STROKE",
"CYRILLIC SMALL LETTER KA WITH STROKE",
"CYRILLIC CAPITAL LETTER BASHKIR KA",
"CYRILLIC SMALL LETTER BASHKIR KA",
"CYRILLIC CAPITAL LETTER EN WITH DESCENDER",
"CYRILLIC SMALL LETTER EN WITH DESCENDER",
"CYRILLIC CAPITAL LIGATURE EN GHE",
"CYRILLIC SMALL LIGATURE EN GHE",
"CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK",
"CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK",
"CYRILLIC CAPITAL LETTER ABKHASIAN HA",
"CYRILLIC SMALL LETTER ABKHASIAN HA",
"CYRILLIC CAPITAL LETTER ES WITH DESCENDER",
"CYRILLIC SMALL LETTER ES WITH DESCENDER",
"CYRILLIC CAPITAL LETTER TE WITH DESCENDER",
"CYRILLIC SMALL LETTER TE WITH DESCENDER",
"CYRILLIC CAPITAL LETTER STRAIGHT U",
"CYRILLIC SMALL LETTER STRAIGHT U",
"CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE",
"CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE",
"CYRILLIC CAPITAL LETTER HA WITH DESCENDER",
"CYRILLIC SMALL LETTER HA WITH DESCENDER",
"CYRILLIC CAPITAL LIGATURE TE TSE",
"CYRILLIC SMALL LIGATURE TE TSE",
"CYRILLIC CAPITAL LETTER CHE WITH DESCENDER",
"CYRILLIC SMALL LETTER CHE WITH DESCENDER",
"CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE",
"CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE",
"CYRILLIC CAPITAL LETTER SHHA",
"CYRILLIC SMALL LETTER SHHA",
"CYRILLIC CAPITAL LETTER ABKHASIAN CHE",
"CYRILLIC SMALL LETTER ABKHASIAN CHE",
"CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER",
"CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER",
"CYRILLIC LETTER PALOCHKA",
"CYRILLIC CAPITAL LETTER ZHE WITH BREVE",
"CYRILLIC SMALL LETTER ZHE WITH BREVE",
"CYRILLIC CAPITAL LETTER KA WITH HOOK",
"CYRILLIC SMALL LETTER KA WITH HOOK",
"CYRILLIC CAPITAL LETTER EL WITH TAIL",
"CYRILLIC SMALL LETTER EL WITH TAIL",
"CYRILLIC CAPITAL LETTER EN WITH HOOK",
"CYRILLIC SMALL LETTER EN WITH HOOK",
"CYRILLIC CAPITAL LETTER EN WITH TAIL",
"CYRILLIC SMALL LETTER EN WITH TAIL",
"CYRILLIC CAPITAL LETTER KHAKASSIAN CHE",
"CYRILLIC SMALL LETTER KHAKASSIAN CHE",
"CYRILLIC CAPITAL LETTER EM WITH TAIL",
"CYRILLIC SMALL LETTER EM WITH TAIL",
name_reserved,
"CYRILLIC CAPITAL LETTER A WITH BREVE",
"CYRILLIC SMALL LETTER A WITH BREVE",
"CYRILLIC CAPITAL LETTER A WITH DIAERESIS",
"CYRILLIC SMALL LETTER A WITH DIAERESIS",
"CYRILLIC CAPITAL LIGATURE A IE",
"CYRILLIC SMALL LIGATURE A IE",
"CYRILLIC CAPITAL LETTER IE WITH BREVE",
"CYRILLIC SMALL LETTER IE WITH BREVE",
"CYRILLIC CAPITAL LETTER SCHWA",
"CYRILLIC SMALL LETTER SCHWA",
"CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS",
"CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS",
"CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS",
"CYRILLIC SMALL LETTER ZHE WITH DIAERESIS",
"CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS",
"CYRILLIC SMALL LETTER ZE WITH DIAERESIS",
"CYRILLIC CAPITAL LETTER ABKHASIAN DZE",
"CYRILLIC SMALL LETTER ABKHASIAN DZE",
"CYRILLIC CAPITAL LETTER I WITH MACRON",
"CYRILLIC SMALL LETTER I WITH MACRON",
"CYRILLIC CAPITAL LETTER I WITH DIAERESIS",
"CYRILLIC SMALL LETTER I WITH DIAERESIS",
"CYRILLIC CAPITAL LETTER O WITH DIAERESIS",
"CYRILLIC SMALL LETTER O WITH DIAERESIS",
"CYRILLIC CAPITAL LETTER BARRED O",
"CYRILLIC SMALL LETTER BARRED O",
"CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS",
"CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS",
"CYRILLIC CAPITAL LETTER E WITH DIAERESIS",
"CYRILLIC SMALL LETTER E WITH DIAERESIS",
"CYRILLIC CAPITAL LETTER U WITH MACRON",
"CYRILLIC SMALL LETTER U WITH MACRON",
"CYRILLIC CAPITAL LETTER U WITH DIAERESIS",
"CYRILLIC SMALL LETTER U WITH DIAERESIS",
"CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE",
"CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE",
"CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS",
"CYRILLIC SMALL LETTER CHE WITH DIAERESIS",
"CYRILLIC CAPITAL LETTER GHE WITH DESCENDER",
"CYRILLIC SMALL LETTER GHE WITH DESCENDER",
"CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS",
"CYRILLIC SMALL LETTER YERU WITH DIAERESIS",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0005[256] =
{
"CYRILLIC CAPITAL LETTER KOMI DE",
"CYRILLIC SMALL LETTER KOMI DE",
"CYRILLIC CAPITAL LETTER KOMI DJE",
"CYRILLIC SMALL LETTER KOMI DJE",
"CYRILLIC CAPITAL LETTER KOMI ZJE",
"CYRILLIC SMALL LETTER KOMI ZJE",
"CYRILLIC CAPITAL LETTER KOMI DZJE",
"CYRILLIC SMALL LETTER KOMI DZJE",
"CYRILLIC CAPITAL LETTER KOMI LJE",
"CYRILLIC SMALL LETTER KOMI LJE",
"CYRILLIC CAPITAL LETTER KOMI NJE",
"CYRILLIC SMALL LETTER KOMI NJE",
"CYRILLIC CAPITAL LETTER KOMI SJE",
"CYRILLIC SMALL LETTER KOMI SJE",
"CYRILLIC CAPITAL LETTER KOMI TJE",
"CYRILLIC SMALL LETTER KOMI TJE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ARMENIAN CAPITAL LETTER AYB",
"ARMENIAN CAPITAL LETTER BEN",
"ARMENIAN CAPITAL LETTER GIM",
"ARMENIAN CAPITAL LETTER DA",
"ARMENIAN CAPITAL LETTER ECH",
"ARMENIAN CAPITAL LETTER ZA",
"ARMENIAN CAPITAL LETTER EH",
"ARMENIAN CAPITAL LETTER ET",
"ARMENIAN CAPITAL LETTER TO",
"ARMENIAN CAPITAL LETTER ZHE",
"ARMENIAN CAPITAL LETTER INI",
"ARMENIAN CAPITAL LETTER LIWN",
"ARMENIAN CAPITAL LETTER XEH",
"ARMENIAN CAPITAL LETTER CA",
"ARMENIAN CAPITAL LETTER KEN",
"ARMENIAN CAPITAL LETTER HO",
"ARMENIAN CAPITAL LETTER JA",
"ARMENIAN CAPITAL LETTER GHAD",
"ARMENIAN CAPITAL LETTER CHEH",
"ARMENIAN CAPITAL LETTER MEN",
"ARMENIAN CAPITAL LETTER YI",
"ARMENIAN CAPITAL LETTER NOW",
"ARMENIAN CAPITAL LETTER SHA",
"ARMENIAN CAPITAL LETTER VO",
"ARMENIAN CAPITAL LETTER CHA",
"ARMENIAN CAPITAL LETTER PEH",
"ARMENIAN CAPITAL LETTER JHEH",
"ARMENIAN CAPITAL LETTER RA",
"ARMENIAN CAPITAL LETTER SEH",
"ARMENIAN CAPITAL LETTER VEW",
"ARMENIAN CAPITAL LETTER TIWN",
"ARMENIAN CAPITAL LETTER REH",
"ARMENIAN CAPITAL LETTER CO",
"ARMENIAN CAPITAL LETTER YIWN",
"ARMENIAN CAPITAL LETTER PIWR",
"ARMENIAN CAPITAL LETTER KEH",
"ARMENIAN CAPITAL LETTER OH",
"ARMENIAN CAPITAL LETTER FEH",
name_reserved,
name_reserved,
"ARMENIAN MODIFIER LETTER LEFT HALF RING",
"ARMENIAN APOSTROPHE",
"ARMENIAN EMPHASIS MARK",
"ARMENIAN EXCLAMATION MARK",
"ARMENIAN COMMA",
"ARMENIAN QUESTION MARK",
"ARMENIAN ABBREVIATION MARK",
name_reserved,
"ARMENIAN SMALL LETTER AYB",
"ARMENIAN SMALL LETTER BEN",
"ARMENIAN SMALL LETTER GIM",
"ARMENIAN SMALL LETTER DA",
"ARMENIAN SMALL LETTER ECH",
"ARMENIAN SMALL LETTER ZA",
"ARMENIAN SMALL LETTER EH",
"ARMENIAN SMALL LETTER ET",
"ARMENIAN SMALL LETTER TO",
"ARMENIAN SMALL LETTER ZHE",
"ARMENIAN SMALL LETTER INI",
"ARMENIAN SMALL LETTER LIWN",
"ARMENIAN SMALL LETTER XEH",
"ARMENIAN SMALL LETTER CA",
"ARMENIAN SMALL LETTER KEN",
"ARMENIAN SMALL LETTER HO",
"ARMENIAN SMALL LETTER JA",
"ARMENIAN SMALL LETTER GHAD",
"ARMENIAN SMALL LETTER CHEH",
"ARMENIAN SMALL LETTER MEN",
"ARMENIAN SMALL LETTER YI",
"ARMENIAN SMALL LETTER NOW",
"ARMENIAN SMALL LETTER SHA",
"ARMENIAN SMALL LETTER VO",
"ARMENIAN SMALL LETTER CHA",
"ARMENIAN SMALL LETTER PEH",
"ARMENIAN SMALL LETTER JHEH",
"ARMENIAN SMALL LETTER RA",
"ARMENIAN SMALL LETTER SEH",
"ARMENIAN SMALL LETTER VEW",
"ARMENIAN SMALL LETTER TIWN",
"ARMENIAN SMALL LETTER REH",
"ARMENIAN SMALL LETTER CO",
"ARMENIAN SMALL LETTER YIWN",
"ARMENIAN SMALL LETTER PIWR",
"ARMENIAN SMALL LETTER KEH",
"ARMENIAN SMALL LETTER OH",
"ARMENIAN SMALL LETTER FEH",
"ARMENIAN SMALL LIGATURE ECH YIWN",
name_reserved,
"ARMENIAN FULL STOP",
"ARMENIAN HYPHEN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"HEBREW ACCENT ETNAHTA",
"HEBREW ACCENT SEGOL",
"HEBREW ACCENT SHALSHELET",
"HEBREW ACCENT ZAQEF QATAN",
"HEBREW ACCENT ZAQEF GADOL",
"HEBREW ACCENT TIPEHA",
"HEBREW ACCENT REVIA",
"HEBREW ACCENT ZARQA",
"HEBREW ACCENT PASHTA",
"HEBREW ACCENT YETIV",
"HEBREW ACCENT TEVIR",
"HEBREW ACCENT GERESH",
"HEBREW ACCENT GERESH MUQDAM",
"HEBREW ACCENT GERSHAYIM",
"HEBREW ACCENT QARNEY PARA",
"HEBREW ACCENT TELISHA GEDOLA",
"HEBREW ACCENT PAZER",
"HEBREW ACCENT ATNAH HAFUKH",
"HEBREW ACCENT MUNAH",
"HEBREW ACCENT MAHAPAKH",
"HEBREW ACCENT MERKHA",
"HEBREW ACCENT MERKHA KEFULA",
"HEBREW ACCENT DARGA",
"HEBREW ACCENT QADMA",
"HEBREW ACCENT TELISHA QETANA",
"HEBREW ACCENT YERAH BEN YOMO",
"HEBREW ACCENT OLE",
"HEBREW ACCENT ILUY",
"HEBREW ACCENT DEHI",
"HEBREW ACCENT ZINOR",
"HEBREW MARK MASORA CIRCLE",
"HEBREW POINT SHEVA",
"HEBREW POINT HATAF SEGOL",
"HEBREW POINT HATAF PATAH",
"HEBREW POINT HATAF QAMATS",
"HEBREW POINT HIRIQ",
"HEBREW POINT TSERE",
"HEBREW POINT SEGOL",
"HEBREW POINT PATAH",
"HEBREW POINT QAMATS",
"HEBREW POINT HOLAM",
name_reserved,
"HEBREW POINT QUBUTS",
"HEBREW POINT DAGESH OR MAPIQ",
"HEBREW POINT METEG",
"HEBREW PUNCTUATION MAQAF",
"HEBREW POINT RAFE",
"HEBREW PUNCTUATION PASEQ",
"HEBREW POINT SHIN DOT",
"HEBREW POINT SIN DOT",
"HEBREW PUNCTUATION SOF PASUQ",
"HEBREW MARK UPPER DOT",
"HEBREW MARK LOWER DOT",
"HEBREW PUNCTUATION NUN HAFUKHA",
"HEBREW POINT QAMATS QATAN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"HEBREW LETTER ALEF",
"HEBREW LETTER BET",
"HEBREW LETTER GIMEL",
"HEBREW LETTER DALET",
"HEBREW LETTER HE",
"HEBREW LETTER VAV",
"HEBREW LETTER ZAYIN",
"HEBREW LETTER HET",
"HEBREW LETTER TET",
"HEBREW LETTER YOD",
"HEBREW LETTER FINAL KAF",
"HEBREW LETTER KAF",
"HEBREW LETTER LAMED",
"HEBREW LETTER FINAL MEM",
"HEBREW LETTER MEM",
"HEBREW LETTER FINAL NUN",
"HEBREW LETTER NUN",
"HEBREW LETTER SAMEKH",
"HEBREW LETTER AYIN",
"HEBREW LETTER FINAL PE",
"HEBREW LETTER PE",
"HEBREW LETTER FINAL TSADI",
"HEBREW LETTER TSADI",
"HEBREW LETTER QOF",
"HEBREW LETTER RESH",
"HEBREW LETTER SHIN",
"HEBREW LETTER TAV",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"HEBREW LIGATURE YIDDISH DOUBLE VAV",
"HEBREW LIGATURE YIDDISH VAV YOD",
"HEBREW LIGATURE YIDDISH DOUBLE YOD",
"HEBREW PUNCTUATION GERESH",
"HEBREW PUNCTUATION GERSHAYIM",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0006[256] =
{
"ARABIC NUMBER SIGN",
"ARABIC SIGN SANAH",
"ARABIC FOOTNOTE MARKER",
"ARABIC SIGN SAFHA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"AFGHANI SIGN",
"ARABIC COMMA",
"ARABIC DATE SEPARATOR",
"ARABIC POETIC VERSE SIGN",
"ARABIC SIGN MISRA",
"ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM",
"ARABIC SIGN ALAYHE ASSALLAM",
"ARABIC SIGN RAHMATULLAH ALAYHE",
"ARABIC SIGN RADI ALLAHOU ANHU",
"ARABIC SIGN TAKHALLUS",
"ARABIC SMALL HIGH TAH",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ARABIC SEMICOLON",
name_reserved,
name_reserved,
"ARABIC TRIPLE DOT PUNCTUATION MARK",
"ARABIC QUESTION MARK",
name_reserved,
"ARABIC LETTER HAMZA",
"ARABIC LETTER ALEF WITH MADDA ABOVE",
"ARABIC LETTER ALEF WITH HAMZA ABOVE",
"ARABIC LETTER WAW WITH HAMZA ABOVE",
"ARABIC LETTER ALEF WITH HAMZA BELOW",
"ARABIC LETTER YEH WITH HAMZA ABOVE",
"ARABIC LETTER ALEF",
"ARABIC LETTER BEH",
"ARABIC LETTER TEH MARBUTA",
"ARABIC LETTER TEH",
"ARABIC LETTER THEH",
"ARABIC LETTER JEEM",
"ARABIC LETTER HAH",
"ARABIC LETTER KHAH",
"ARABIC LETTER DAL",
"ARABIC LETTER THAL",
"ARABIC LETTER REH",
"ARABIC LETTER ZAIN",
"ARABIC LETTER SEEN",
"ARABIC LETTER SHEEN",
"ARABIC LETTER SAD",
"ARABIC LETTER DAD",
"ARABIC LETTER TAH",
"ARABIC LETTER ZAH",
"ARABIC LETTER AIN",
"ARABIC LETTER GHAIN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ARABIC TATWEEL",
"ARABIC LETTER FEH",
"ARABIC LETTER QAF",
"ARABIC LETTER KAF",
"ARABIC LETTER LAM",
"ARABIC LETTER MEEM",
"ARABIC LETTER NOON",
"ARABIC LETTER HEH",
"ARABIC LETTER WAW",
"ARABIC LETTER ALEF MAKSURA",
"ARABIC LETTER YEH",
"ARABIC FATHATAN",
"ARABIC DAMMATAN",
"ARABIC KASRATAN",
"ARABIC FATHA",
"ARABIC DAMMA",
"ARABIC KASRA",
"ARABIC SHADDA",
"ARABIC SUKUN",
"ARABIC MADDAH ABOVE",
"ARABIC HAMZA ABOVE",
"ARABIC HAMZA BELOW",
"ARABIC SUBSCRIPT ALEF",
"ARABIC INVERTED DAMMA",
"ARABIC MARK NOON GHUNNA",
"ARABIC ZWARAKAY",
"ARABIC VOWEL SIGN SMALL V ABOVE",
"ARABIC VOWEL SIGN INVERTED SMALL V ABOVE",
"ARABIC VOWEL SIGN DOT BELOW",
"ARABIC REVERSED DAMMA",
"ARABIC FATHA WITH TWO DOTS",
name_reserved,
"ARABIC-INDIC DIGIT ZERO",
"ARABIC-INDIC DIGIT ONE",
"ARABIC-INDIC DIGIT TWO",
"ARABIC-INDIC DIGIT THREE",
"ARABIC-INDIC DIGIT FOUR",
"ARABIC-INDIC DIGIT FIVE",
"ARABIC-INDIC DIGIT SIX",
"ARABIC-INDIC DIGIT SEVEN",
"ARABIC-INDIC DIGIT EIGHT",
"ARABIC-INDIC DIGIT NINE",
"ARABIC PERCENT SIGN",
"ARABIC DECIMAL SEPARATOR",
"ARABIC THOUSANDS SEPARATOR",
"ARABIC FIVE POINTED STAR",
"ARABIC LETTER DOTLESS BEH",
"ARABIC LETTER DOTLESS QAF",
"ARABIC LETTER SUPERSCRIPT ALEF",
"ARABIC LETTER ALEF WASLA",
"ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE",
"ARABIC LETTER ALEF WITH WAVY HAMZA BELOW",
"ARABIC LETTER HIGH HAMZA",
"ARABIC LETTER HIGH HAMZA ALEF",
"ARABIC LETTER HIGH HAMZA WAW",
"ARABIC LETTER U WITH HAMZA ABOVE",
"ARABIC LETTER HIGH HAMZA YEH",
"ARABIC LETTER TTEH",
"ARABIC LETTER TTEHEH",
"ARABIC LETTER BEEH",
"ARABIC LETTER TEH WITH RING",
"ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS",
"ARABIC LETTER PEH",
"ARABIC LETTER TEHEH",
"ARABIC LETTER BEHEH",
"ARABIC LETTER HAH WITH HAMZA ABOVE",
"ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE",
"ARABIC LETTER NYEH",
"ARABIC LETTER DYEH",
"ARABIC LETTER HAH WITH THREE DOTS ABOVE",
"ARABIC LETTER TCHEH",
"ARABIC LETTER TCHEHEH",
"ARABIC LETTER DDAL",
"ARABIC LETTER DAL WITH RING",
"ARABIC LETTER DAL WITH DOT BELOW",
"ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH",
"ARABIC LETTER DAHAL",
"ARABIC LETTER DDAHAL",
"ARABIC LETTER DUL",
"ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS",
"ARABIC LETTER DAL WITH FOUR DOTS ABOVE",
"ARABIC LETTER RREH",
"ARABIC LETTER REH WITH SMALL V",
"ARABIC LETTER REH WITH RING",
"ARABIC LETTER REH WITH DOT BELOW",
"ARABIC LETTER REH WITH SMALL V BELOW",
"ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE",
"ARABIC LETTER REH WITH TWO DOTS ABOVE",
"ARABIC LETTER JEH",
"ARABIC LETTER REH WITH FOUR DOTS ABOVE",
"ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE",
"ARABIC LETTER SEEN WITH THREE DOTS BELOW",
"ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE",
"ARABIC LETTER SAD WITH TWO DOTS BELOW",
"ARABIC LETTER SAD WITH THREE DOTS ABOVE",
"ARABIC LETTER TAH WITH THREE DOTS ABOVE",
"ARABIC LETTER AIN WITH THREE DOTS ABOVE",
"ARABIC LETTER DOTLESS FEH",
"ARABIC LETTER FEH WITH DOT MOVED BELOW",
"ARABIC LETTER FEH WITH DOT BELOW",
"ARABIC LETTER VEH",
"ARABIC LETTER FEH WITH THREE DOTS BELOW",
"ARABIC LETTER PEHEH",
"ARABIC LETTER QAF WITH DOT ABOVE",
"ARABIC LETTER QAF WITH THREE DOTS ABOVE",
"ARABIC LETTER KEHEH",
"ARABIC LETTER SWASH KAF",
"ARABIC LETTER KAF WITH RING",
"ARABIC LETTER KAF WITH DOT ABOVE",
"ARABIC LETTER NG",
"ARABIC LETTER KAF WITH THREE DOTS BELOW",
"ARABIC LETTER GAF",
"ARABIC LETTER GAF WITH RING",
"ARABIC LETTER NGOEH",
"ARABIC LETTER GAF WITH TWO DOTS BELOW",
"ARABIC LETTER GUEH",
"ARABIC LETTER GAF WITH THREE DOTS ABOVE",
"ARABIC LETTER LAM WITH SMALL V",
"ARABIC LETTER LAM WITH DOT ABOVE",
"ARABIC LETTER LAM WITH THREE DOTS ABOVE",
"ARABIC LETTER LAM WITH THREE DOTS BELOW",
"ARABIC LETTER NOON WITH DOT BELOW",
"ARABIC LETTER NOON GHUNNA",
"ARABIC LETTER RNOON",
"ARABIC LETTER NOON WITH RING",
"ARABIC LETTER NOON WITH THREE DOTS ABOVE",
"ARABIC LETTER HEH DOACHASHMEE",
"ARABIC LETTER TCHEH WITH DOT ABOVE",
"ARABIC LETTER HEH WITH YEH ABOVE",
"ARABIC LETTER HEH GOAL",
"ARABIC LETTER HEH GOAL WITH HAMZA ABOVE",
"ARABIC LETTER TEH MARBUTA GOAL",
"ARABIC LETTER WAW WITH RING",
"ARABIC LETTER KIRGHIZ OE",
"ARABIC LETTER OE",
"ARABIC LETTER U",
"ARABIC LETTER YU",
"ARABIC LETTER KIRGHIZ YU",
"ARABIC LETTER WAW WITH TWO DOTS ABOVE",
"ARABIC LETTER VE",
"ARABIC LETTER FARSI YEH",
"ARABIC LETTER YEH WITH TAIL",
"ARABIC LETTER YEH WITH SMALL V",
"ARABIC LETTER WAW WITH DOT ABOVE",
"ARABIC LETTER E",
"ARABIC LETTER YEH WITH THREE DOTS BELOW",
"ARABIC LETTER YEH BARREE",
"ARABIC LETTER YEH BARREE WITH HAMZA ABOVE",
"ARABIC FULL STOP",
"ARABIC LETTER AE",
"ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA",
"ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA",
"ARABIC SMALL HIGH MEEM INITIAL FORM",
"ARABIC SMALL HIGH LAM ALEF",
"ARABIC SMALL HIGH JEEM",
"ARABIC SMALL HIGH THREE DOTS",
"ARABIC SMALL HIGH SEEN",
"ARABIC END OF AYAH",
"ARABIC START OF RUB EL HIZB",
"ARABIC SMALL HIGH ROUNDED ZERO",
"ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO",
"ARABIC SMALL HIGH DOTLESS HEAD OF KHAH",
"ARABIC SMALL HIGH MEEM ISOLATED FORM",
"ARABIC SMALL LOW SEEN",
"ARABIC SMALL HIGH MADDA",
"ARABIC SMALL WAW",
"ARABIC SMALL YEH",
"ARABIC SMALL HIGH YEH",
"ARABIC SMALL HIGH NOON",
"ARABIC PLACE OF SAJDAH",
"ARABIC EMPTY CENTRE LOW STOP",
"ARABIC EMPTY CENTRE HIGH STOP",
"ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE",
"ARABIC SMALL LOW MEEM",
"ARABIC LETTER DAL WITH INVERTED V",
"ARABIC LETTER REH WITH INVERTED V",
"EXTENDED ARABIC-INDIC DIGIT ZERO",
"EXTENDED ARABIC-INDIC DIGIT ONE",
"EXTENDED ARABIC-INDIC DIGIT TWO",
"EXTENDED ARABIC-INDIC DIGIT THREE",
"EXTENDED ARABIC-INDIC DIGIT FOUR",
"EXTENDED ARABIC-INDIC DIGIT FIVE",
"EXTENDED ARABIC-INDIC DIGIT SIX",
"EXTENDED ARABIC-INDIC DIGIT SEVEN",
"EXTENDED ARABIC-INDIC DIGIT EIGHT",
"EXTENDED ARABIC-INDIC DIGIT NINE",
"ARABIC LETTER SHEEN WITH DOT BELOW",
"ARABIC LETTER DAD WITH DOT BELOW",
"ARABIC LETTER GHAIN WITH DOT BELOW",
"ARABIC SIGN SINDHI AMPERSAND",
"ARABIC SIGN SINDHI POSTPOSITION MEN",
"ARABIC LETTER HEH WITH INVERTED V"};
static const char * name_0007[256] =
{
"SYRIAC END OF PARAGRAPH",
"SYRIAC SUPRALINEAR FULL STOP",
"SYRIAC SUBLINEAR FULL STOP",
"SYRIAC SUPRALINEAR COLON",
"SYRIAC SUBLINEAR COLON",
"SYRIAC HORIZONTAL COLON",
"SYRIAC COLON SKEWED LEFT",
"SYRIAC COLON SKEWED RIGHT",
"SYRIAC SUPRALINEAR COLON SKEWED LEFT",
"SYRIAC SUBLINEAR COLON SKEWED RIGHT",
"SYRIAC CONTRACTION",
"SYRIAC HARKLEAN OBELUS",
"SYRIAC HARKLEAN METOBELUS",
"SYRIAC HARKLEAN ASTERISCUS",
name_reserved,
"SYRIAC ABBREVIATION MARK",
"SYRIAC LETTER ALAPH",
"SYRIAC LETTER SUPERSCRIPT ALAPH",
"SYRIAC LETTER BETH",
"SYRIAC LETTER GAMAL",
"SYRIAC LETTER GAMAL GARSHUNI",
"SYRIAC LETTER DALATH",
"SYRIAC LETTER DOTLESS DALATH RISH",
"SYRIAC LETTER HE",
"SYRIAC LETTER WAW",
"SYRIAC LETTER ZAIN",
"SYRIAC LETTER HETH",
"SYRIAC LETTER TETH",
"SYRIAC LETTER TETH GARSHUNI",
"SYRIAC LETTER YUDH",
"SYRIAC LETTER YUDH HE",
"SYRIAC LETTER KAPH",
"SYRIAC LETTER LAMADH",
"SYRIAC LETTER MIM",
"SYRIAC LETTER NUN",
"SYRIAC LETTER SEMKATH",
"SYRIAC LETTER FINAL SEMKATH",
"SYRIAC LETTER E",
"SYRIAC LETTER PE",
"SYRIAC LETTER REVERSED PE",
"SYRIAC LETTER SADHE",
"SYRIAC LETTER QAPH",
"SYRIAC LETTER RISH",
"SYRIAC LETTER SHIN",
"SYRIAC LETTER TAW",
"SYRIAC LETTER PERSIAN BHETH",
"SYRIAC LETTER PERSIAN GHAMAL",
"SYRIAC LETTER PERSIAN DHALATH",
"SYRIAC PTHAHA ABOVE",
"SYRIAC PTHAHA BELOW",
"SYRIAC PTHAHA DOTTED",
"SYRIAC ZQAPHA ABOVE",
"SYRIAC ZQAPHA BELOW",
"SYRIAC ZQAPHA DOTTED",
"SYRIAC RBASA ABOVE",
"SYRIAC RBASA BELOW",
"SYRIAC DOTTED ZLAMA HORIZONTAL",
"SYRIAC DOTTED ZLAMA ANGULAR",
"SYRIAC HBASA ABOVE",
"SYRIAC HBASA BELOW",
"SYRIAC HBASA-ESASA DOTTED",
"SYRIAC ESASA ABOVE",
"SYRIAC ESASA BELOW",
"SYRIAC RWAHA",
"SYRIAC FEMININE DOT",
"SYRIAC QUSHSHAYA",
"SYRIAC RUKKAKHA",
"SYRIAC TWO VERTICAL DOTS ABOVE",
"SYRIAC TWO VERTICAL DOTS BELOW",
"SYRIAC THREE DOTS ABOVE",
"SYRIAC THREE DOTS BELOW",
"SYRIAC OBLIQUE LINE ABOVE",
"SYRIAC OBLIQUE LINE BELOW",
"SYRIAC MUSIC",
"SYRIAC BARREKH",
name_reserved,
name_reserved,
"SYRIAC LETTER SOGDIAN ZHAIN",
"SYRIAC LETTER SOGDIAN KHAPH",
"SYRIAC LETTER SOGDIAN FE",
"ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW",
"ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE",
"ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW",
"ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE",
"ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE",
"ARABIC LETTER BEH WITH INVERTED SMALL V BELOW",
"ARABIC LETTER BEH WITH SMALL V",
"ARABIC LETTER HAH WITH TWO DOTS ABOVE",
"ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW",
"ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH",
"ARABIC LETTER DAL WITH INVERTED SMALL V BELOW",
"ARABIC LETTER REH WITH STROKE",
"ARABIC LETTER SEEN WITH FOUR DOTS ABOVE",
"ARABIC LETTER AIN WITH TWO DOTS ABOVE",
"ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE",
"ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE",
"ARABIC LETTER FEH WITH TWO DOTS BELOW",
"ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW",
"ARABIC LETTER KEHEH WITH DOT ABOVE",
"ARABIC LETTER KEHEH WITH THREE DOTS ABOVE",
"ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW",
"ARABIC LETTER MEEM WITH DOT ABOVE",
"ARABIC LETTER MEEM WITH DOT BELOW",
"ARABIC LETTER NOON WITH TWO DOTS BELOW",
"ARABIC LETTER NOON WITH SMALL TAH",
"ARABIC LETTER NOON WITH SMALL V",
"ARABIC LETTER LAM WITH BAR",
"ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE",
"ARABIC LETTER REH WITH HAMZA ABOVE",
"ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"THAANA LETTER HAA",
"THAANA LETTER SHAVIYANI",
"THAANA LETTER NOONU",
"THAANA LETTER RAA",
"THAANA LETTER BAA",
"THAANA LETTER LHAVIYANI",
"THAANA LETTER KAAFU",
"THAANA LETTER ALIFU",
"THAANA LETTER VAAVU",
"THAANA LETTER MEEMU",
"THAANA LETTER FAAFU",
"THAANA LETTER DHAALU",
"THAANA LETTER THAA",
"THAANA LETTER LAAMU",
"THAANA LETTER GAAFU",
"THAANA LETTER GNAVIYANI",
"THAANA LETTER SEENU",
"THAANA LETTER DAVIYANI",
"THAANA LETTER ZAVIYANI",
"THAANA LETTER TAVIYANI",
"THAANA LETTER YAA",
"THAANA LETTER PAVIYANI",
"THAANA LETTER JAVIYANI",
"THAANA LETTER CHAVIYANI",
"THAANA LETTER TTAA",
"THAANA LETTER HHAA",
"THAANA LETTER KHAA",
"THAANA LETTER THAALU",
"THAANA LETTER ZAA",
"THAANA LETTER SHEENU",
"THAANA LETTER SAADHU",
"THAANA LETTER DAADHU",
"THAANA LETTER TO",
"THAANA LETTER ZO",
"THAANA LETTER AINU",
"THAANA LETTER GHAINU",
"THAANA LETTER QAAFU",
"THAANA LETTER WAAVU",
"THAANA ABAFILI",
"THAANA AABAAFILI",
"THAANA IBIFILI",
"THAANA EEBEEFILI",
"THAANA UBUFILI",
"THAANA OOBOOFILI",
"THAANA EBEFILI",
"THAANA EYBEYFILI",
"THAANA OBOFILI",
"THAANA OABOAFILI",
"THAANA SUKUN",
"THAANA LETTER NAA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0009[256] =
{
name_reserved,
"DEVANAGARI SIGN CANDRABINDU",
"DEVANAGARI SIGN ANUSVARA",
"DEVANAGARI SIGN VISARGA",
"DEVANAGARI LETTER SHORT A",
"DEVANAGARI LETTER A",
"DEVANAGARI LETTER AA",
"DEVANAGARI LETTER I",
"DEVANAGARI LETTER II",
"DEVANAGARI LETTER U",
"DEVANAGARI LETTER UU",
"DEVANAGARI LETTER VOCALIC R",
"DEVANAGARI LETTER VOCALIC L",
"DEVANAGARI LETTER CANDRA E",
"DEVANAGARI LETTER SHORT E",
"DEVANAGARI LETTER E",
"DEVANAGARI LETTER AI",
"DEVANAGARI LETTER CANDRA O",
"DEVANAGARI LETTER SHORT O",
"DEVANAGARI LETTER O",
"DEVANAGARI LETTER AU",
"DEVANAGARI LETTER KA",
"DEVANAGARI LETTER KHA",
"DEVANAGARI LETTER GA",
"DEVANAGARI LETTER GHA",
"DEVANAGARI LETTER NGA",
"DEVANAGARI LETTER CA",
"DEVANAGARI LETTER CHA",
"DEVANAGARI LETTER JA",
"DEVANAGARI LETTER JHA",
"DEVANAGARI LETTER NYA",
"DEVANAGARI LETTER TTA",
"DEVANAGARI LETTER TTHA",
"DEVANAGARI LETTER DDA",
"DEVANAGARI LETTER DDHA",
"DEVANAGARI LETTER NNA",
"DEVANAGARI LETTER TA",
"DEVANAGARI LETTER THA",
"DEVANAGARI LETTER DA",
"DEVANAGARI LETTER DHA",
"DEVANAGARI LETTER NA",
"DEVANAGARI LETTER NNNA",
"DEVANAGARI LETTER PA",
"DEVANAGARI LETTER PHA",
"DEVANAGARI LETTER BA",
"DEVANAGARI LETTER BHA",
"DEVANAGARI LETTER MA",
"DEVANAGARI LETTER YA",
"DEVANAGARI LETTER RA",
"DEVANAGARI LETTER RRA",
"DEVANAGARI LETTER LA",
"DEVANAGARI LETTER LLA",
"DEVANAGARI LETTER LLLA",
"DEVANAGARI LETTER VA",
"DEVANAGARI LETTER SHA",
"DEVANAGARI LETTER SSA",
"DEVANAGARI LETTER SA",
"DEVANAGARI LETTER HA",
name_reserved,
name_reserved,
"DEVANAGARI SIGN NUKTA",
"DEVANAGARI SIGN AVAGRAHA",
"DEVANAGARI VOWEL SIGN AA",
"DEVANAGARI VOWEL SIGN I",
"DEVANAGARI VOWEL SIGN II",
"DEVANAGARI VOWEL SIGN U",
"DEVANAGARI VOWEL SIGN UU",
"DEVANAGARI VOWEL SIGN VOCALIC R",
"DEVANAGARI VOWEL SIGN VOCALIC RR",
"DEVANAGARI VOWEL SIGN CANDRA E",
"DEVANAGARI VOWEL SIGN SHORT E",
"DEVANAGARI VOWEL SIGN E",
"DEVANAGARI VOWEL SIGN AI",
"DEVANAGARI VOWEL SIGN CANDRA O",
"DEVANAGARI VOWEL SIGN SHORT O",
"DEVANAGARI VOWEL SIGN O",
"DEVANAGARI VOWEL SIGN AU",
"DEVANAGARI SIGN VIRAMA",
name_reserved,
name_reserved,
"DEVANAGARI OM",
"DEVANAGARI STRESS SIGN UDATTA",
"DEVANAGARI STRESS SIGN ANUDATTA",
"DEVANAGARI GRAVE ACCENT",
"DEVANAGARI ACUTE ACCENT",
name_reserved,
name_reserved,
name_reserved,
"DEVANAGARI LETTER QA",
"DEVANAGARI LETTER KHHA",
"DEVANAGARI LETTER GHHA",
"DEVANAGARI LETTER ZA",
"DEVANAGARI LETTER DDDHA",
"DEVANAGARI LETTER RHA",
"DEVANAGARI LETTER FA",
"DEVANAGARI LETTER YYA",
"DEVANAGARI LETTER VOCALIC RR",
"DEVANAGARI LETTER VOCALIC LL",
"DEVANAGARI VOWEL SIGN VOCALIC L",
"DEVANAGARI VOWEL SIGN VOCALIC LL",
"DEVANAGARI DANDA",
"DEVANAGARI DOUBLE DANDA",
"DEVANAGARI DIGIT ZERO",
"DEVANAGARI DIGIT ONE",
"DEVANAGARI DIGIT TWO",
"DEVANAGARI DIGIT THREE",
"DEVANAGARI DIGIT FOUR",
"DEVANAGARI DIGIT FIVE",
"DEVANAGARI DIGIT SIX",
"DEVANAGARI DIGIT SEVEN",
"DEVANAGARI DIGIT EIGHT",
"DEVANAGARI DIGIT NINE",
"DEVANAGARI ABBREVIATION SIGN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"DEVANAGARI LETTER GLOTTAL STOP",
name_reserved,
name_reserved,
name_reserved,
"BENGALI SIGN CANDRABINDU",
"BENGALI SIGN ANUSVARA",
"BENGALI SIGN VISARGA",
name_reserved,
"BENGALI LETTER A",
"BENGALI LETTER AA",
"BENGALI LETTER I",
"BENGALI LETTER II",
"BENGALI LETTER U",
"BENGALI LETTER UU",
"BENGALI LETTER VOCALIC R",
"BENGALI LETTER VOCALIC L",
name_reserved,
name_reserved,
"BENGALI LETTER E",
"BENGALI LETTER AI",
name_reserved,
name_reserved,
"BENGALI LETTER O",
"BENGALI LETTER AU",
"BENGALI LETTER KA",
"BENGALI LETTER KHA",
"BENGALI LETTER GA",
"BENGALI LETTER GHA",
"BENGALI LETTER NGA",
"BENGALI LETTER CA",
"BENGALI LETTER CHA",
"BENGALI LETTER JA",
"BENGALI LETTER JHA",
"BENGALI LETTER NYA",
"BENGALI LETTER TTA",
"BENGALI LETTER TTHA",
"BENGALI LETTER DDA",
"BENGALI LETTER DDHA",
"BENGALI LETTER NNA",
"BENGALI LETTER TA",
"BENGALI LETTER THA",
"BENGALI LETTER DA",
"BENGALI LETTER DHA",
"BENGALI LETTER NA",
name_reserved,
"BENGALI LETTER PA",
"BENGALI LETTER PHA",
"BENGALI LETTER BA",
"BENGALI LETTER BHA",
"BENGALI LETTER MA",
"BENGALI LETTER YA",
"BENGALI LETTER RA",
name_reserved,
"BENGALI LETTER LA",
name_reserved,
name_reserved,
name_reserved,
"BENGALI LETTER SHA",
"BENGALI LETTER SSA",
"BENGALI LETTER SA",
"BENGALI LETTER HA",
name_reserved,
name_reserved,
"BENGALI SIGN NUKTA",
"BENGALI SIGN AVAGRAHA",
"BENGALI VOWEL SIGN AA",
"BENGALI VOWEL SIGN I",
"BENGALI VOWEL SIGN II",
"BENGALI VOWEL SIGN U",
"BENGALI VOWEL SIGN UU",
"BENGALI VOWEL SIGN VOCALIC R",
"BENGALI VOWEL SIGN VOCALIC RR",
name_reserved,
name_reserved,
"BENGALI VOWEL SIGN E",
"BENGALI VOWEL SIGN AI",
name_reserved,
name_reserved,
"BENGALI VOWEL SIGN O",
"BENGALI VOWEL SIGN AU",
"BENGALI SIGN VIRAMA",
"BENGALI LETTER KHANDA TA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"BENGALI AU LENGTH MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"BENGALI LETTER RRA",
"BENGALI LETTER RHA",
name_reserved,
"BENGALI LETTER YYA",
"BENGALI LETTER VOCALIC RR",
"BENGALI LETTER VOCALIC LL",
"BENGALI VOWEL SIGN VOCALIC L",
"BENGALI VOWEL SIGN VOCALIC LL",
name_reserved,
name_reserved,
"BENGALI DIGIT ZERO",
"BENGALI DIGIT ONE",
"BENGALI DIGIT TWO",
"BENGALI DIGIT THREE",
"BENGALI DIGIT FOUR",
"BENGALI DIGIT FIVE",
"BENGALI DIGIT SIX",
"BENGALI DIGIT SEVEN",
"BENGALI DIGIT EIGHT",
"BENGALI DIGIT NINE",
"BENGALI LETTER RA WITH MIDDLE DIAGONAL",
"BENGALI LETTER RA WITH LOWER DIAGONAL",
"BENGALI RUPEE MARK",
"BENGALI RUPEE SIGN",
"BENGALI CURRENCY NUMERATOR ONE",
"BENGALI CURRENCY NUMERATOR TWO",
"BENGALI CURRENCY NUMERATOR THREE",
"BENGALI CURRENCY NUMERATOR FOUR",
"BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR",
"BENGALI CURRENCY DENOMINATOR SIXTEEN",
"BENGALI ISSHAR",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_000a[256] =
{
name_reserved,
"GURMUKHI SIGN ADAK BINDI",
"GURMUKHI SIGN BINDI",
"GURMUKHI SIGN VISARGA",
name_reserved,
"GURMUKHI LETTER A",
"GURMUKHI LETTER AA",
"GURMUKHI LETTER I",
"GURMUKHI LETTER II",
"GURMUKHI LETTER U",
"GURMUKHI LETTER UU",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GURMUKHI LETTER EE",
"GURMUKHI LETTER AI",
name_reserved,
name_reserved,
"GURMUKHI LETTER OO",
"GURMUKHI LETTER AU",
"GURMUKHI LETTER KA",
"GURMUKHI LETTER KHA",
"GURMUKHI LETTER GA",
"GURMUKHI LETTER GHA",
"GURMUKHI LETTER NGA",
"GURMUKHI LETTER CA",
"GURMUKHI LETTER CHA",
"GURMUKHI LETTER JA",
"GURMUKHI LETTER JHA",
"GURMUKHI LETTER NYA",
"GURMUKHI LETTER TTA",
"GURMUKHI LETTER TTHA",
"GURMUKHI LETTER DDA",
"GURMUKHI LETTER DDHA",
"GURMUKHI LETTER NNA",
"GURMUKHI LETTER TA",
"GURMUKHI LETTER THA",
"GURMUKHI LETTER DA",
"GURMUKHI LETTER DHA",
"GURMUKHI LETTER NA",
name_reserved,
"GURMUKHI LETTER PA",
"GURMUKHI LETTER PHA",
"GURMUKHI LETTER BA",
"GURMUKHI LETTER BHA",
"GURMUKHI LETTER MA",
"GURMUKHI LETTER YA",
"GURMUKHI LETTER RA",
name_reserved,
"GURMUKHI LETTER LA",
"GURMUKHI LETTER LLA",
name_reserved,
"GURMUKHI LETTER VA",
"GURMUKHI LETTER SHA",
name_reserved,
"GURMUKHI LETTER SA",
"GURMUKHI LETTER HA",
name_reserved,
name_reserved,
"GURMUKHI SIGN NUKTA",
name_reserved,
"GURMUKHI VOWEL SIGN AA",
"GURMUKHI VOWEL SIGN I",
"GURMUKHI VOWEL SIGN II",
"GURMUKHI VOWEL SIGN U",
"GURMUKHI VOWEL SIGN UU",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GURMUKHI VOWEL SIGN EE",
"GURMUKHI VOWEL SIGN AI",
name_reserved,
name_reserved,
"GURMUKHI VOWEL SIGN OO",
"GURMUKHI VOWEL SIGN AU",
"GURMUKHI SIGN VIRAMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GURMUKHI LETTER KHHA",
"GURMUKHI LETTER GHHA",
"GURMUKHI LETTER ZA",
"GURMUKHI LETTER RRA",
name_reserved,
"GURMUKHI LETTER FA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GURMUKHI DIGIT ZERO",
"GURMUKHI DIGIT ONE",
"GURMUKHI DIGIT TWO",
"GURMUKHI DIGIT THREE",
"GURMUKHI DIGIT FOUR",
"GURMUKHI DIGIT FIVE",
"GURMUKHI DIGIT SIX",
"GURMUKHI DIGIT SEVEN",
"GURMUKHI DIGIT EIGHT",
"GURMUKHI DIGIT NINE",
"GURMUKHI TIPPI",
"GURMUKHI ADDAK",
"GURMUKHI IRI",
"GURMUKHI URA",
"GURMUKHI EK ONKAR",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GUJARATI SIGN CANDRABINDU",
"GUJARATI SIGN ANUSVARA",
"GUJARATI SIGN VISARGA",
name_reserved,
"GUJARATI LETTER A",
"GUJARATI LETTER AA",
"GUJARATI LETTER I",
"GUJARATI LETTER II",
"GUJARATI LETTER U",
"GUJARATI LETTER UU",
"GUJARATI LETTER VOCALIC R",
"GUJARATI LETTER VOCALIC L",
"GUJARATI VOWEL CANDRA E",
name_reserved,
"GUJARATI LETTER E",
"GUJARATI LETTER AI",
"GUJARATI VOWEL CANDRA O",
name_reserved,
"GUJARATI LETTER O",
"GUJARATI LETTER AU",
"GUJARATI LETTER KA",
"GUJARATI LETTER KHA",
"GUJARATI LETTER GA",
"GUJARATI LETTER GHA",
"GUJARATI LETTER NGA",
"GUJARATI LETTER CA",
"GUJARATI LETTER CHA",
"GUJARATI LETTER JA",
"GUJARATI LETTER JHA",
"GUJARATI LETTER NYA",
"GUJARATI LETTER TTA",
"GUJARATI LETTER TTHA",
"GUJARATI LETTER DDA",
"GUJARATI LETTER DDHA",
"GUJARATI LETTER NNA",
"GUJARATI LETTER TA",
"GUJARATI LETTER THA",
"GUJARATI LETTER DA",
"GUJARATI LETTER DHA",
"GUJARATI LETTER NA",
name_reserved,
"GUJARATI LETTER PA",
"GUJARATI LETTER PHA",
"GUJARATI LETTER BA",
"GUJARATI LETTER BHA",
"GUJARATI LETTER MA",
"GUJARATI LETTER YA",
"GUJARATI LETTER RA",
name_reserved,
"GUJARATI LETTER LA",
"GUJARATI LETTER LLA",
name_reserved,
"GUJARATI LETTER VA",
"GUJARATI LETTER SHA",
"GUJARATI LETTER SSA",
"GUJARATI LETTER SA",
"GUJARATI LETTER HA",
name_reserved,
name_reserved,
"GUJARATI SIGN NUKTA",
"GUJARATI SIGN AVAGRAHA",
"GUJARATI VOWEL SIGN AA",
"GUJARATI VOWEL SIGN I",
"GUJARATI VOWEL SIGN II",
"GUJARATI VOWEL SIGN U",
"GUJARATI VOWEL SIGN UU",
"GUJARATI VOWEL SIGN VOCALIC R",
"GUJARATI VOWEL SIGN VOCALIC RR",
"GUJARATI VOWEL SIGN CANDRA E",
name_reserved,
"GUJARATI VOWEL SIGN E",
"GUJARATI VOWEL SIGN AI",
"GUJARATI VOWEL SIGN CANDRA O",
name_reserved,
"GUJARATI VOWEL SIGN O",
"GUJARATI VOWEL SIGN AU",
"GUJARATI SIGN VIRAMA",
name_reserved,
name_reserved,
"GUJARATI OM",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GUJARATI LETTER VOCALIC RR",
"GUJARATI LETTER VOCALIC LL",
"GUJARATI VOWEL SIGN VOCALIC L",
"GUJARATI VOWEL SIGN VOCALIC LL",
name_reserved,
name_reserved,
"GUJARATI DIGIT ZERO",
"GUJARATI DIGIT ONE",
"GUJARATI DIGIT TWO",
"GUJARATI DIGIT THREE",
"GUJARATI DIGIT FOUR",
"GUJARATI DIGIT FIVE",
"GUJARATI DIGIT SIX",
"GUJARATI DIGIT SEVEN",
"GUJARATI DIGIT EIGHT",
"GUJARATI DIGIT NINE",
name_reserved,
"GUJARATI RUPEE SIGN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_000b[256] =
{
name_reserved,
"ORIYA SIGN CANDRABINDU",
"ORIYA SIGN ANUSVARA",
"ORIYA SIGN VISARGA",
name_reserved,
"ORIYA LETTER A",
"ORIYA LETTER AA",
"ORIYA LETTER I",
"ORIYA LETTER II",
"ORIYA LETTER U",
"ORIYA LETTER UU",
"ORIYA LETTER VOCALIC R",
"ORIYA LETTER VOCALIC L",
name_reserved,
name_reserved,
"ORIYA LETTER E",
"ORIYA LETTER AI",
name_reserved,
name_reserved,
"ORIYA LETTER O",
"ORIYA LETTER AU",
"ORIYA LETTER KA",
"ORIYA LETTER KHA",
"ORIYA LETTER GA",
"ORIYA LETTER GHA",
"ORIYA LETTER NGA",
"ORIYA LETTER CA",
"ORIYA LETTER CHA",
"ORIYA LETTER JA",
"ORIYA LETTER JHA",
"ORIYA LETTER NYA",
"ORIYA LETTER TTA",
"ORIYA LETTER TTHA",
"ORIYA LETTER DDA",
"ORIYA LETTER DDHA",
"ORIYA LETTER NNA",
"ORIYA LETTER TA",
"ORIYA LETTER THA",
"ORIYA LETTER DA",
"ORIYA LETTER DHA",
"ORIYA LETTER NA",
name_reserved,
"ORIYA LETTER PA",
"ORIYA LETTER PHA",
"ORIYA LETTER BA",
"ORIYA LETTER BHA",
"ORIYA LETTER MA",
"ORIYA LETTER YA",
"ORIYA LETTER RA",
name_reserved,
"ORIYA LETTER LA",
"ORIYA LETTER LLA",
name_reserved,
"ORIYA LETTER VA",
"ORIYA LETTER SHA",
"ORIYA LETTER SSA",
"ORIYA LETTER SA",
"ORIYA LETTER HA",
name_reserved,
name_reserved,
"ORIYA SIGN NUKTA",
"ORIYA SIGN AVAGRAHA",
"ORIYA VOWEL SIGN AA",
"ORIYA VOWEL SIGN I",
"ORIYA VOWEL SIGN II",
"ORIYA VOWEL SIGN U",
"ORIYA VOWEL SIGN UU",
"ORIYA VOWEL SIGN VOCALIC R",
name_reserved,
name_reserved,
name_reserved,
"ORIYA VOWEL SIGN E",
"ORIYA VOWEL SIGN AI",
name_reserved,
name_reserved,
"ORIYA VOWEL SIGN O",
"ORIYA VOWEL SIGN AU",
"ORIYA SIGN VIRAMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ORIYA AI LENGTH MARK",
"ORIYA AU LENGTH MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ORIYA LETTER RRA",
"ORIYA LETTER RHA",
name_reserved,
"ORIYA LETTER YYA",
"ORIYA LETTER VOCALIC RR",
"ORIYA LETTER VOCALIC LL",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ORIYA DIGIT ZERO",
"ORIYA DIGIT ONE",
"ORIYA DIGIT TWO",
"ORIYA DIGIT THREE",
"ORIYA DIGIT FOUR",
"ORIYA DIGIT FIVE",
"ORIYA DIGIT SIX",
"ORIYA DIGIT SEVEN",
"ORIYA DIGIT EIGHT",
"ORIYA DIGIT NINE",
"ORIYA ISSHAR",
"ORIYA LETTER WA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TAMIL SIGN ANUSVARA",
"TAMIL SIGN VISARGA",
name_reserved,
"TAMIL LETTER A",
"TAMIL LETTER AA",
"TAMIL LETTER I",
"TAMIL LETTER II",
"TAMIL LETTER U",
"TAMIL LETTER UU",
name_reserved,
name_reserved,
name_reserved,
"TAMIL LETTER E",
"TAMIL LETTER EE",
"TAMIL LETTER AI",
name_reserved,
"TAMIL LETTER O",
"TAMIL LETTER OO",
"TAMIL LETTER AU",
"TAMIL LETTER KA",
name_reserved,
name_reserved,
name_reserved,
"TAMIL LETTER NGA",
"TAMIL LETTER CA",
name_reserved,
"TAMIL LETTER JA",
name_reserved,
"TAMIL LETTER NYA",
"TAMIL LETTER TTA",
name_reserved,
name_reserved,
name_reserved,
"TAMIL LETTER NNA",
"TAMIL LETTER TA",
name_reserved,
name_reserved,
name_reserved,
"TAMIL LETTER NA",
"TAMIL LETTER NNNA",
"TAMIL LETTER PA",
name_reserved,
name_reserved,
name_reserved,
"TAMIL LETTER MA",
"TAMIL LETTER YA",
"TAMIL LETTER RA",
"TAMIL LETTER RRA",
"TAMIL LETTER LA",
"TAMIL LETTER LLA",
"TAMIL LETTER LLLA",
"TAMIL LETTER VA",
"TAMIL LETTER SHA",
"TAMIL LETTER SSA",
"TAMIL LETTER SA",
"TAMIL LETTER HA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TAMIL VOWEL SIGN AA",
"TAMIL VOWEL SIGN I",
"TAMIL VOWEL SIGN II",
"TAMIL VOWEL SIGN U",
"TAMIL VOWEL SIGN UU",
name_reserved,
name_reserved,
name_reserved,
"TAMIL VOWEL SIGN E",
"TAMIL VOWEL SIGN EE",
"TAMIL VOWEL SIGN AI",
name_reserved,
"TAMIL VOWEL SIGN O",
"TAMIL VOWEL SIGN OO",
"TAMIL VOWEL SIGN AU",
"TAMIL SIGN VIRAMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TAMIL AU LENGTH MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TAMIL DIGIT ZERO",
"TAMIL DIGIT ONE",
"TAMIL DIGIT TWO",
"TAMIL DIGIT THREE",
"TAMIL DIGIT FOUR",
"TAMIL DIGIT FIVE",
"TAMIL DIGIT SIX",
"TAMIL DIGIT SEVEN",
"TAMIL DIGIT EIGHT",
"TAMIL DIGIT NINE",
"TAMIL NUMBER TEN",
"TAMIL NUMBER ONE HUNDRED",
"TAMIL NUMBER ONE THOUSAND",
"TAMIL DAY SIGN",
"TAMIL MONTH SIGN",
"TAMIL YEAR SIGN",
"TAMIL DEBIT SIGN",
"TAMIL CREDIT SIGN",
"TAMIL AS ABOVE SIGN",
"TAMIL RUPEE SIGN",
"TAMIL NUMBER SIGN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_000c[256] =
{
name_reserved,
"TELUGU SIGN CANDRABINDU",
"TELUGU SIGN ANUSVARA",
"TELUGU SIGN VISARGA",
name_reserved,
"TELUGU LETTER A",
"TELUGU LETTER AA",
"TELUGU LETTER I",
"TELUGU LETTER II",
"TELUGU LETTER U",
"TELUGU LETTER UU",
"TELUGU LETTER VOCALIC R",
"TELUGU LETTER VOCALIC L",
name_reserved,
"TELUGU LETTER E",
"TELUGU LETTER EE",
"TELUGU LETTER AI",
name_reserved,
"TELUGU LETTER O",
"TELUGU LETTER OO",
"TELUGU LETTER AU",
"TELUGU LETTER KA",
"TELUGU LETTER KHA",
"TELUGU LETTER GA",
"TELUGU LETTER GHA",
"TELUGU LETTER NGA",
"TELUGU LETTER CA",
"TELUGU LETTER CHA",
"TELUGU LETTER JA",
"TELUGU LETTER JHA",
"TELUGU LETTER NYA",
"TELUGU LETTER TTA",
"TELUGU LETTER TTHA",
"TELUGU LETTER DDA",
"TELUGU LETTER DDHA",
"TELUGU LETTER NNA",
"TELUGU LETTER TA",
"TELUGU LETTER THA",
"TELUGU LETTER DA",
"TELUGU LETTER DHA",
"TELUGU LETTER NA",
name_reserved,
"TELUGU LETTER PA",
"TELUGU LETTER PHA",
"TELUGU LETTER BA",
"TELUGU LETTER BHA",
"TELUGU LETTER MA",
"TELUGU LETTER YA",
"TELUGU LETTER RA",
"TELUGU LETTER RRA",
"TELUGU LETTER LA",
"TELUGU LETTER LLA",
name_reserved,
"TELUGU LETTER VA",
"TELUGU LETTER SHA",
"TELUGU LETTER SSA",
"TELUGU LETTER SA",
"TELUGU LETTER HA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TELUGU VOWEL SIGN AA",
"TELUGU VOWEL SIGN I",
"TELUGU VOWEL SIGN II",
"TELUGU VOWEL SIGN U",
"TELUGU VOWEL SIGN UU",
"TELUGU VOWEL SIGN VOCALIC R",
"TELUGU VOWEL SIGN VOCALIC RR",
name_reserved,
"TELUGU VOWEL SIGN E",
"TELUGU VOWEL SIGN EE",
"TELUGU VOWEL SIGN AI",
name_reserved,
"TELUGU VOWEL SIGN O",
"TELUGU VOWEL SIGN OO",
"TELUGU VOWEL SIGN AU",
"TELUGU SIGN VIRAMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TELUGU LENGTH MARK",
"TELUGU AI LENGTH MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TELUGU LETTER VOCALIC RR",
"TELUGU LETTER VOCALIC LL",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TELUGU DIGIT ZERO",
"TELUGU DIGIT ONE",
"TELUGU DIGIT TWO",
"TELUGU DIGIT THREE",
"TELUGU DIGIT FOUR",
"TELUGU DIGIT FIVE",
"TELUGU DIGIT SIX",
"TELUGU DIGIT SEVEN",
"TELUGU DIGIT EIGHT",
"TELUGU DIGIT NINE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KANNADA SIGN ANUSVARA",
"KANNADA SIGN VISARGA",
name_reserved,
"KANNADA LETTER A",
"KANNADA LETTER AA",
"KANNADA LETTER I",
"KANNADA LETTER II",
"KANNADA LETTER U",
"KANNADA LETTER UU",
"KANNADA LETTER VOCALIC R",
"KANNADA LETTER VOCALIC L",
name_reserved,
"KANNADA LETTER E",
"KANNADA LETTER EE",
"KANNADA LETTER AI",
name_reserved,
"KANNADA LETTER O",
"KANNADA LETTER OO",
"KANNADA LETTER AU",
"KANNADA LETTER KA",
"KANNADA LETTER KHA",
"KANNADA LETTER GA",
"KANNADA LETTER GHA",
"KANNADA LETTER NGA",
"KANNADA LETTER CA",
"KANNADA LETTER CHA",
"KANNADA LETTER JA",
"KANNADA LETTER JHA",
"KANNADA LETTER NYA",
"KANNADA LETTER TTA",
"KANNADA LETTER TTHA",
"KANNADA LETTER DDA",
"KANNADA LETTER DDHA",
"KANNADA LETTER NNA",
"KANNADA LETTER TA",
"KANNADA LETTER THA",
"KANNADA LETTER DA",
"KANNADA LETTER DHA",
"KANNADA LETTER NA",
name_reserved,
"KANNADA LETTER PA",
"KANNADA LETTER PHA",
"KANNADA LETTER BA",
"KANNADA LETTER BHA",
"KANNADA LETTER MA",
"KANNADA LETTER YA",
"KANNADA LETTER RA",
"KANNADA LETTER RRA",
"KANNADA LETTER LA",
"KANNADA LETTER LLA",
name_reserved,
"KANNADA LETTER VA",
"KANNADA LETTER SHA",
"KANNADA LETTER SSA",
"KANNADA LETTER SA",
"KANNADA LETTER HA",
name_reserved,
name_reserved,
"KANNADA SIGN NUKTA",
"KANNADA SIGN AVAGRAHA",
"KANNADA VOWEL SIGN AA",
"KANNADA VOWEL SIGN I",
"KANNADA VOWEL SIGN II",
"KANNADA VOWEL SIGN U",
"KANNADA VOWEL SIGN UU",
"KANNADA VOWEL SIGN VOCALIC R",
"KANNADA VOWEL SIGN VOCALIC RR",
name_reserved,
"KANNADA VOWEL SIGN E",
"KANNADA VOWEL SIGN EE",
"KANNADA VOWEL SIGN AI",
name_reserved,
"KANNADA VOWEL SIGN O",
"KANNADA VOWEL SIGN OO",
"KANNADA VOWEL SIGN AU",
"KANNADA SIGN VIRAMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KANNADA LENGTH MARK",
"KANNADA AI LENGTH MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KANNADA LETTER FA",
name_reserved,
"KANNADA LETTER VOCALIC RR",
"KANNADA LETTER VOCALIC LL",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KANNADA DIGIT ZERO",
"KANNADA DIGIT ONE",
"KANNADA DIGIT TWO",
"KANNADA DIGIT THREE",
"KANNADA DIGIT FOUR",
"KANNADA DIGIT FIVE",
"KANNADA DIGIT SIX",
"KANNADA DIGIT SEVEN",
"KANNADA DIGIT EIGHT",
"KANNADA DIGIT NINE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_000d[256] =
{
name_reserved,
name_reserved,
"MALAYALAM SIGN ANUSVARA",
"MALAYALAM SIGN VISARGA",
name_reserved,
"MALAYALAM LETTER A",
"MALAYALAM LETTER AA",
"MALAYALAM LETTER I",
"MALAYALAM LETTER II",
"MALAYALAM LETTER U",
"MALAYALAM LETTER UU",
"MALAYALAM LETTER VOCALIC R",
"MALAYALAM LETTER VOCALIC L",
name_reserved,
"MALAYALAM LETTER E",
"MALAYALAM LETTER EE",
"MALAYALAM LETTER AI",
name_reserved,
"MALAYALAM LETTER O",
"MALAYALAM LETTER OO",
"MALAYALAM LETTER AU",
"MALAYALAM LETTER KA",
"MALAYALAM LETTER KHA",
"MALAYALAM LETTER GA",
"MALAYALAM LETTER GHA",
"MALAYALAM LETTER NGA",
"MALAYALAM LETTER CA",
"MALAYALAM LETTER CHA",
"MALAYALAM LETTER JA",
"MALAYALAM LETTER JHA",
"MALAYALAM LETTER NYA",
"MALAYALAM LETTER TTA",
"MALAYALAM LETTER TTHA",
"MALAYALAM LETTER DDA",
"MALAYALAM LETTER DDHA",
"MALAYALAM LETTER NNA",
"MALAYALAM LETTER TA",
"MALAYALAM LETTER THA",
"MALAYALAM LETTER DA",
"MALAYALAM LETTER DHA",
"MALAYALAM LETTER NA",
name_reserved,
"MALAYALAM LETTER PA",
"MALAYALAM LETTER PHA",
"MALAYALAM LETTER BA",
"MALAYALAM LETTER BHA",
"MALAYALAM LETTER MA",
"MALAYALAM LETTER YA",
"MALAYALAM LETTER RA",
"MALAYALAM LETTER RRA",
"MALAYALAM LETTER LA",
"MALAYALAM LETTER LLA",
"MALAYALAM LETTER LLLA",
"MALAYALAM LETTER VA",
"MALAYALAM LETTER SHA",
"MALAYALAM LETTER SSA",
"MALAYALAM LETTER SA",
"MALAYALAM LETTER HA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"MALAYALAM VOWEL SIGN AA",
"MALAYALAM VOWEL SIGN I",
"MALAYALAM VOWEL SIGN II",
"MALAYALAM VOWEL SIGN U",
"MALAYALAM VOWEL SIGN UU",
"MALAYALAM VOWEL SIGN VOCALIC R",
name_reserved,
name_reserved,
"MALAYALAM VOWEL SIGN E",
"MALAYALAM VOWEL SIGN EE",
"MALAYALAM VOWEL SIGN AI",
name_reserved,
"MALAYALAM VOWEL SIGN O",
"MALAYALAM VOWEL SIGN OO",
"MALAYALAM VOWEL SIGN AU",
"MALAYALAM SIGN VIRAMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"MALAYALAM AU LENGTH MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"MALAYALAM LETTER VOCALIC RR",
"MALAYALAM LETTER VOCALIC LL",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"MALAYALAM DIGIT ZERO",
"MALAYALAM DIGIT ONE",
"MALAYALAM DIGIT TWO",
"MALAYALAM DIGIT THREE",
"MALAYALAM DIGIT FOUR",
"MALAYALAM DIGIT FIVE",
"MALAYALAM DIGIT SIX",
"MALAYALAM DIGIT SEVEN",
"MALAYALAM DIGIT EIGHT",
"MALAYALAM DIGIT NINE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"SINHALA SIGN ANUSVARAYA",
"SINHALA SIGN VISARGAYA",
name_reserved,
"SINHALA LETTER AYANNA",
"SINHALA LETTER AAYANNA",
"SINHALA LETTER AEYANNA",
"SINHALA LETTER AEEYANNA",
"SINHALA LETTER IYANNA",
"SINHALA LETTER IIYANNA",
"SINHALA LETTER UYANNA",
"SINHALA LETTER UUYANNA",
"SINHALA LETTER IRUYANNA",
"SINHALA LETTER IRUUYANNA",
"SINHALA LETTER ILUYANNA",
"SINHALA LETTER ILUUYANNA",
"SINHALA LETTER EYANNA",
"SINHALA LETTER EEYANNA",
"SINHALA LETTER AIYANNA",
"SINHALA LETTER OYANNA",
"SINHALA LETTER OOYANNA",
"SINHALA LETTER AUYANNA",
name_reserved,
name_reserved,
name_reserved,
"SINHALA LETTER ALPAPRAANA KAYANNA",
"SINHALA LETTER MAHAAPRAANA KAYANNA",
"SINHALA LETTER ALPAPRAANA GAYANNA",
"SINHALA LETTER MAHAAPRAANA GAYANNA",
"SINHALA LETTER KANTAJA NAASIKYAYA",
"SINHALA LETTER SANYAKA GAYANNA",
"SINHALA LETTER ALPAPRAANA CAYANNA",
"SINHALA LETTER MAHAAPRAANA CAYANNA",
"SINHALA LETTER ALPAPRAANA JAYANNA",
"SINHALA LETTER MAHAAPRAANA JAYANNA",
"SINHALA LETTER TAALUJA NAASIKYAYA",
"SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA",
"SINHALA LETTER SANYAKA JAYANNA",
"SINHALA LETTER ALPAPRAANA TTAYANNA",
"SINHALA LETTER MAHAAPRAANA TTAYANNA",
"SINHALA LETTER ALPAPRAANA DDAYANNA",
"SINHALA LETTER MAHAAPRAANA DDAYANNA",
"SINHALA LETTER MUURDHAJA NAYANNA",
"SINHALA LETTER SANYAKA DDAYANNA",
"SINHALA LETTER ALPAPRAANA TAYANNA",
"SINHALA LETTER MAHAAPRAANA TAYANNA",
"SINHALA LETTER ALPAPRAANA DAYANNA",
"SINHALA LETTER MAHAAPRAANA DAYANNA",
"SINHALA LETTER DANTAJA NAYANNA",
name_reserved,
"SINHALA LETTER SANYAKA DAYANNA",
"SINHALA LETTER ALPAPRAANA PAYANNA",
"SINHALA LETTER MAHAAPRAANA PAYANNA",
"SINHALA LETTER ALPAPRAANA BAYANNA",
"SINHALA LETTER MAHAAPRAANA BAYANNA",
"SINHALA LETTER MAYANNA",
"SINHALA LETTER AMBA BAYANNA",
"SINHALA LETTER YAYANNA",
"SINHALA LETTER RAYANNA",
name_reserved,
"SINHALA LETTER DANTAJA LAYANNA",
name_reserved,
name_reserved,
"SINHALA LETTER VAYANNA",
"SINHALA LETTER TAALUJA SAYANNA",
"SINHALA LETTER MUURDHAJA SAYANNA",
"SINHALA LETTER DANTAJA SAYANNA",
"SINHALA LETTER HAYANNA",
"SINHALA LETTER MUURDHAJA LAYANNA",
"SINHALA LETTER FAYANNA",
name_reserved,
name_reserved,
name_reserved,
"SINHALA SIGN AL-LAKUNA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"SINHALA VOWEL SIGN AELA-PILLA",
"SINHALA VOWEL SIGN KETTI AEDA-PILLA",
"SINHALA VOWEL SIGN DIGA AEDA-PILLA",
"SINHALA VOWEL SIGN KETTI IS-PILLA",
"SINHALA VOWEL SIGN DIGA IS-PILLA",
"SINHALA VOWEL SIGN KETTI PAA-PILLA",
name_reserved,
"SINHALA VOWEL SIGN DIGA PAA-PILLA",
name_reserved,
"SINHALA VOWEL SIGN GAETTA-PILLA",
"SINHALA VOWEL SIGN KOMBUVA",
"SINHALA VOWEL SIGN DIGA KOMBUVA",
"SINHALA VOWEL SIGN KOMBU DEKA",
"SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA",
"SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA",
"SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA",
"SINHALA VOWEL SIGN GAYANUKITTA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"SINHALA VOWEL SIGN DIGA GAETTA-PILLA",
"SINHALA VOWEL SIGN DIGA GAYANUKITTA",
"SINHALA PUNCTUATION KUNDDALIYA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_000e[256] =
{
name_reserved,
"THAI CHARACTER KO KAI",
"THAI CHARACTER KHO KHAI",
"THAI CHARACTER KHO KHUAT",
"THAI CHARACTER KHO KHWAI",
"THAI CHARACTER KHO KHON",
"THAI CHARACTER KHO RAKHANG",
"THAI CHARACTER NGO NGU",
"THAI CHARACTER CHO CHAN",
"THAI CHARACTER CHO CHING",
"THAI CHARACTER CHO CHANG",
"THAI CHARACTER SO SO",
"THAI CHARACTER CHO CHOE",
"THAI CHARACTER YO YING",
"THAI CHARACTER DO CHADA",
"THAI CHARACTER TO PATAK",
"THAI CHARACTER THO THAN",
"THAI CHARACTER THO NANGMONTHO",
"THAI CHARACTER THO PHUTHAO",
"THAI CHARACTER NO NEN",
"THAI CHARACTER DO DEK",
"THAI CHARACTER TO TAO",
"THAI CHARACTER THO THUNG",
"THAI CHARACTER THO THAHAN",
"THAI CHARACTER THO THONG",
"THAI CHARACTER NO NU",
"THAI CHARACTER BO BAIMAI",
"THAI CHARACTER PO PLA",
"THAI CHARACTER PHO PHUNG",
"THAI CHARACTER FO FA",
"THAI CHARACTER PHO PHAN",
"THAI CHARACTER FO FAN",
"THAI CHARACTER PHO SAMPHAO",
"THAI CHARACTER MO MA",
"THAI CHARACTER YO YAK",
"THAI CHARACTER RO RUA",
"THAI CHARACTER RU",
"THAI CHARACTER LO LING",
"THAI CHARACTER LU",
"THAI CHARACTER WO WAEN",
"THAI CHARACTER SO SALA",
"THAI CHARACTER SO RUSI",
"THAI CHARACTER SO SUA",
"THAI CHARACTER HO HIP",
"THAI CHARACTER LO CHULA",
"THAI CHARACTER O ANG",
"THAI CHARACTER HO NOKHUK",
"THAI CHARACTER PAIYANNOI",
"THAI CHARACTER SARA A",
"THAI CHARACTER MAI HAN-AKAT",
"THAI CHARACTER SARA AA",
"THAI CHARACTER SARA AM",
"THAI CHARACTER SARA I",
"THAI CHARACTER SARA II",
"THAI CHARACTER SARA UE",
"THAI CHARACTER SARA UEE",
"THAI CHARACTER SARA U",
"THAI CHARACTER SARA UU",
"THAI CHARACTER PHINTHU",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"THAI CURRENCY SYMBOL BAHT",
"THAI CHARACTER SARA E",
"THAI CHARACTER SARA AE",
"THAI CHARACTER SARA O",
"THAI CHARACTER SARA AI MAIMUAN",
"THAI CHARACTER SARA AI MAIMALAI",
"THAI CHARACTER LAKKHANGYAO",
"THAI CHARACTER MAIYAMOK",
"THAI CHARACTER MAITAIKHU",
"THAI CHARACTER MAI EK",
"THAI CHARACTER MAI THO",
"THAI CHARACTER MAI TRI",
"THAI CHARACTER MAI CHATTAWA",
"THAI CHARACTER THANTHAKHAT",
"THAI CHARACTER NIKHAHIT",
"THAI CHARACTER YAMAKKAN",
"THAI CHARACTER FONGMAN",
"THAI DIGIT ZERO",
"THAI DIGIT ONE",
"THAI DIGIT TWO",
"THAI DIGIT THREE",
"THAI DIGIT FOUR",
"THAI DIGIT FIVE",
"THAI DIGIT SIX",
"THAI DIGIT SEVEN",
"THAI DIGIT EIGHT",
"THAI DIGIT NINE",
"THAI CHARACTER ANGKHANKHU",
"THAI CHARACTER KHOMUT",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"LAO LETTER KO",
"LAO LETTER KHO SUNG",
name_reserved,
"LAO LETTER KHO TAM",
name_reserved,
name_reserved,
"LAO LETTER NGO",
"LAO LETTER CO",
name_reserved,
"LAO LETTER SO TAM",
name_reserved,
name_reserved,
"LAO LETTER NYO",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"LAO LETTER DO",
"LAO LETTER TO",
"LAO LETTER THO SUNG",
"LAO LETTER THO TAM",
name_reserved,
"LAO LETTER NO",
"LAO LETTER BO",
"LAO LETTER PO",
"LAO LETTER PHO SUNG",
"LAO LETTER FO TAM",
"LAO LETTER PHO TAM",
"LAO LETTER FO SUNG",
name_reserved,
"LAO LETTER MO",
"LAO LETTER YO",
"LAO LETTER LO LING",
name_reserved,
"LAO LETTER LO LOOT",
name_reserved,
"LAO LETTER WO",
name_reserved,
name_reserved,
"LAO LETTER SO SUNG",
"LAO LETTER HO SUNG",
name_reserved,
"LAO LETTER O",
"LAO LETTER HO TAM",
"LAO ELLIPSIS",
"LAO VOWEL SIGN A",
"LAO VOWEL SIGN MAI KAN",
"LAO VOWEL SIGN AA",
"LAO VOWEL SIGN AM",
"LAO VOWEL SIGN I",
"LAO VOWEL SIGN II",
"LAO VOWEL SIGN Y",
"LAO VOWEL SIGN YY",
"LAO VOWEL SIGN U",
"LAO VOWEL SIGN UU",
name_reserved,
"LAO VOWEL SIGN MAI KON",
"LAO SEMIVOWEL SIGN LO",
"LAO SEMIVOWEL SIGN NYO",
name_reserved,
name_reserved,
"LAO VOWEL SIGN E",
"LAO VOWEL SIGN EI",
"LAO VOWEL SIGN O",
"LAO VOWEL SIGN AY",
"LAO VOWEL SIGN AI",
name_reserved,
"LAO KO LA",
name_reserved,
"LAO TONE MAI EK",
"LAO TONE MAI THO",
"LAO TONE MAI TI",
"LAO TONE MAI CATAWA",
"LAO CANCELLATION MARK",
"LAO NIGGAHITA",
name_reserved,
name_reserved,
"LAO DIGIT ZERO",
"LAO DIGIT ONE",
"LAO DIGIT TWO",
"LAO DIGIT THREE",
"LAO DIGIT FOUR",
"LAO DIGIT FIVE",
"LAO DIGIT SIX",
"LAO DIGIT SEVEN",
"LAO DIGIT EIGHT",
"LAO DIGIT NINE",
name_reserved,
name_reserved,
"LAO HO NO",
"LAO HO MO",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_000f[256] =
{
"TIBETAN SYLLABLE OM",
"TIBETAN MARK GTER YIG MGO TRUNCATED A",
"TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA",
"TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA",
"TIBETAN MARK INITIAL YIG MGO MDUN MA",
"TIBETAN MARK CLOSING YIG MGO SGAB MA",
"TIBETAN MARK CARET YIG MGO PHUR SHAD MA",
"TIBETAN MARK YIG MGO TSHEG SHAD MA",
"TIBETAN MARK SBRUL SHAD",
"TIBETAN MARK BSKUR YIG MGO",
"TIBETAN MARK BKA- SHOG YIG MGO",
"TIBETAN MARK INTERSYLLABIC TSHEG",
"TIBETAN MARK DELIMITER TSHEG BSTAR",
"TIBETAN MARK SHAD",
"TIBETAN MARK NYIS SHAD",
"TIBETAN MARK TSHEG SHAD",
"TIBETAN MARK NYIS TSHEG SHAD",
"TIBETAN MARK RIN CHEN SPUNGS SHAD",
"TIBETAN MARK RGYA GRAM SHAD",
"TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN",
"TIBETAN MARK GTER TSHEG",
"TIBETAN LOGOTYPE SIGN CHAD RTAGS",
"TIBETAN LOGOTYPE SIGN LHAG RTAGS",
"TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS",
"TIBETAN ASTROLOGICAL SIGN -KHYUD PA",
"TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS",
"TIBETAN SIGN RDEL DKAR GCIG",
"TIBETAN SIGN RDEL DKAR GNYIS",
"TIBETAN SIGN RDEL DKAR GSUM",
"TIBETAN SIGN RDEL NAG GCIG",
"TIBETAN SIGN RDEL NAG GNYIS",
"TIBETAN SIGN RDEL DKAR RDEL NAG",
"TIBETAN DIGIT ZERO",
"TIBETAN DIGIT ONE",
"TIBETAN DIGIT TWO",
"TIBETAN DIGIT THREE",
"TIBETAN DIGIT FOUR",
"TIBETAN DIGIT FIVE",
"TIBETAN DIGIT SIX",
"TIBETAN DIGIT SEVEN",
"TIBETAN DIGIT EIGHT",
"TIBETAN DIGIT NINE",
"TIBETAN DIGIT HALF ONE",
"TIBETAN DIGIT HALF TWO",
"TIBETAN DIGIT HALF THREE",
"TIBETAN DIGIT HALF FOUR",
"TIBETAN DIGIT HALF FIVE",
"TIBETAN DIGIT HALF SIX",
"TIBETAN DIGIT HALF SEVEN",
"TIBETAN DIGIT HALF EIGHT",
"TIBETAN DIGIT HALF NINE",
"TIBETAN DIGIT HALF ZERO",
"TIBETAN MARK BSDUS RTAGS",
"TIBETAN MARK NGAS BZUNG NYI ZLA",
"TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN",
"TIBETAN MARK NGAS BZUNG SGOR RTAGS",
"TIBETAN MARK CHE MGO",
"TIBETAN MARK TSA -PHRU",
"TIBETAN MARK GUG RTAGS GYON",
"TIBETAN MARK GUG RTAGS GYAS",
"TIBETAN MARK ANG KHANG GYON",
"TIBETAN MARK ANG KHANG GYAS",
"TIBETAN SIGN YAR TSHES",
"TIBETAN SIGN MAR TSHES",
"TIBETAN LETTER KA",
"TIBETAN LETTER KHA",
"TIBETAN LETTER GA",
"TIBETAN LETTER GHA",
"TIBETAN LETTER NGA",
"TIBETAN LETTER CA",
"TIBETAN LETTER CHA",
"TIBETAN LETTER JA",
name_reserved,
"TIBETAN LETTER NYA",
"TIBETAN LETTER TTA",
"TIBETAN LETTER TTHA",
"TIBETAN LETTER DDA",
"TIBETAN LETTER DDHA",
"TIBETAN LETTER NNA",
"TIBETAN LETTER TA",
"TIBETAN LETTER THA",
"TIBETAN LETTER DA",
"TIBETAN LETTER DHA",
"TIBETAN LETTER NA",
"TIBETAN LETTER PA",
"TIBETAN LETTER PHA",
"TIBETAN LETTER BA",
"TIBETAN LETTER BHA",
"TIBETAN LETTER MA",
"TIBETAN LETTER TSA",
"TIBETAN LETTER TSHA",
"TIBETAN LETTER DZA",
"TIBETAN LETTER DZHA",
"TIBETAN LETTER WA",
"TIBETAN LETTER ZHA",
"TIBETAN LETTER ZA",
"TIBETAN LETTER -A",
"TIBETAN LETTER YA",
"TIBETAN LETTER RA",
"TIBETAN LETTER LA",
"TIBETAN LETTER SHA",
"TIBETAN LETTER SSA",
"TIBETAN LETTER SA",
"TIBETAN LETTER HA",
"TIBETAN LETTER A",
"TIBETAN LETTER KSSA",
"TIBETAN LETTER FIXED-FORM RA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TIBETAN VOWEL SIGN AA",
"TIBETAN VOWEL SIGN I",
"TIBETAN VOWEL SIGN II",
"TIBETAN VOWEL SIGN U",
"TIBETAN VOWEL SIGN UU",
"TIBETAN VOWEL SIGN VOCALIC R",
"TIBETAN VOWEL SIGN VOCALIC RR",
"TIBETAN VOWEL SIGN VOCALIC L",
"TIBETAN VOWEL SIGN VOCALIC LL",
"TIBETAN VOWEL SIGN E",
"TIBETAN VOWEL SIGN EE",
"TIBETAN VOWEL SIGN O",
"TIBETAN VOWEL SIGN OO",
"TIBETAN SIGN RJES SU NGA RO",
"TIBETAN SIGN RNAM BCAD",
"TIBETAN VOWEL SIGN REVERSED I",
"TIBETAN VOWEL SIGN REVERSED II",
"TIBETAN SIGN NYI ZLA NAA DA",
"TIBETAN SIGN SNA LDAN",
"TIBETAN MARK HALANTA",
"TIBETAN MARK PALUTA",
"TIBETAN SIGN LCI RTAGS",
"TIBETAN SIGN YANG RTAGS",
"TIBETAN SIGN LCE TSA CAN",
"TIBETAN SIGN MCHU CAN",
"TIBETAN SIGN GRU CAN RGYINGS",
"TIBETAN SIGN GRU MED RGYINGS",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TIBETAN SUBJOINED LETTER KA",
"TIBETAN SUBJOINED LETTER KHA",
"TIBETAN SUBJOINED LETTER GA",
"TIBETAN SUBJOINED LETTER GHA",
"TIBETAN SUBJOINED LETTER NGA",
"TIBETAN SUBJOINED LETTER CA",
"TIBETAN SUBJOINED LETTER CHA",
"TIBETAN SUBJOINED LETTER JA",
name_reserved,
"TIBETAN SUBJOINED LETTER NYA",
"TIBETAN SUBJOINED LETTER TTA",
"TIBETAN SUBJOINED LETTER TTHA",
"TIBETAN SUBJOINED LETTER DDA",
"TIBETAN SUBJOINED LETTER DDHA",
"TIBETAN SUBJOINED LETTER NNA",
"TIBETAN SUBJOINED LETTER TA",
"TIBETAN SUBJOINED LETTER THA",
"TIBETAN SUBJOINED LETTER DA",
"TIBETAN SUBJOINED LETTER DHA",
"TIBETAN SUBJOINED LETTER NA",
"TIBETAN SUBJOINED LETTER PA",
"TIBETAN SUBJOINED LETTER PHA",
"TIBETAN SUBJOINED LETTER BA",
"TIBETAN SUBJOINED LETTER BHA",
"TIBETAN SUBJOINED LETTER MA",
"TIBETAN SUBJOINED LETTER TSA",
"TIBETAN SUBJOINED LETTER TSHA",
"TIBETAN SUBJOINED LETTER DZA",
"TIBETAN SUBJOINED LETTER DZHA",
"TIBETAN SUBJOINED LETTER WA",
"TIBETAN SUBJOINED LETTER ZHA",
"TIBETAN SUBJOINED LETTER ZA",
"TIBETAN SUBJOINED LETTER -A",
"TIBETAN SUBJOINED LETTER YA",
"TIBETAN SUBJOINED LETTER RA",
"TIBETAN SUBJOINED LETTER LA",
"TIBETAN SUBJOINED LETTER SHA",
"TIBETAN SUBJOINED LETTER SSA",
"TIBETAN SUBJOINED LETTER SA",
"TIBETAN SUBJOINED LETTER HA",
"TIBETAN SUBJOINED LETTER A",
"TIBETAN SUBJOINED LETTER KSSA",
"TIBETAN SUBJOINED LETTER FIXED-FORM WA",
"TIBETAN SUBJOINED LETTER FIXED-FORM YA",
"TIBETAN SUBJOINED LETTER FIXED-FORM RA",
name_reserved,
"TIBETAN KU RU KHA",
"TIBETAN KU RU KHA BZHI MIG CAN",
"TIBETAN CANTILLATION SIGN HEAVY BEAT",
"TIBETAN CANTILLATION SIGN LIGHT BEAT",
"TIBETAN CANTILLATION SIGN CANG TE-U",
"TIBETAN CANTILLATION SIGN SBUB -CHAL",
"TIBETAN SYMBOL DRIL BU",
"TIBETAN SYMBOL RDO RJE",
"TIBETAN SYMBOL PADMA GDAN",
"TIBETAN SYMBOL RDO RJE RGYA GRAM",
"TIBETAN SYMBOL PHUR PA",
"TIBETAN SYMBOL NOR BU",
"TIBETAN SYMBOL NOR BU NYIS -KHYIL",
"TIBETAN SYMBOL NOR BU GSUM -KHYIL",
"TIBETAN SYMBOL NOR BU BZHI -KHYIL",
name_reserved,
name_reserved,
"TIBETAN SIGN RDEL NAG GSUM",
"TIBETAN MARK BSKA- SHOG GI MGO RGYAN",
"TIBETAN MARK MNYAM YIG GI MGO RGYAN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0010[256] =
{
"MYANMAR LETTER KA",
"MYANMAR LETTER KHA",
"MYANMAR LETTER GA",
"MYANMAR LETTER GHA",
"MYANMAR LETTER NGA",
"MYANMAR LETTER CA",
"MYANMAR LETTER CHA",
"MYANMAR LETTER JA",
"MYANMAR LETTER JHA",
"MYANMAR LETTER NYA",
"MYANMAR LETTER NNYA",
"MYANMAR LETTER TTA",
"MYANMAR LETTER TTHA",
"MYANMAR LETTER DDA",
"MYANMAR LETTER DDHA",
"MYANMAR LETTER NNA",
"MYANMAR LETTER TA",
"MYANMAR LETTER THA",
"MYANMAR LETTER DA",
"MYANMAR LETTER DHA",
"MYANMAR LETTER NA",
"MYANMAR LETTER PA",
"MYANMAR LETTER PHA",
"MYANMAR LETTER BA",
"MYANMAR LETTER BHA",
"MYANMAR LETTER MA",
"MYANMAR LETTER YA",
"MYANMAR LETTER RA",
"MYANMAR LETTER LA",
"MYANMAR LETTER WA",
"MYANMAR LETTER SA",
"MYANMAR LETTER HA",
"MYANMAR LETTER LLA",
"MYANMAR LETTER A",
name_reserved,
"MYANMAR LETTER I",
"MYANMAR LETTER II",
"MYANMAR LETTER U",
"MYANMAR LETTER UU",
"MYANMAR LETTER E",
name_reserved,
"MYANMAR LETTER O",
"MYANMAR LETTER AU",
name_reserved,
"MYANMAR VOWEL SIGN AA",
"MYANMAR VOWEL SIGN I",
"MYANMAR VOWEL SIGN II",
"MYANMAR VOWEL SIGN U",
"MYANMAR VOWEL SIGN UU",
"MYANMAR VOWEL SIGN E",
"MYANMAR VOWEL SIGN AI",
name_reserved,
name_reserved,
name_reserved,
"MYANMAR SIGN ANUSVARA",
"MYANMAR SIGN DOT BELOW",
"MYANMAR SIGN VISARGA",
"MYANMAR SIGN VIRAMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"MYANMAR DIGIT ZERO",
"MYANMAR DIGIT ONE",
"MYANMAR DIGIT TWO",
"MYANMAR DIGIT THREE",
"MYANMAR DIGIT FOUR",
"MYANMAR DIGIT FIVE",
"MYANMAR DIGIT SIX",
"MYANMAR DIGIT SEVEN",
"MYANMAR DIGIT EIGHT",
"MYANMAR DIGIT NINE",
"MYANMAR SIGN LITTLE SECTION",
"MYANMAR SIGN SECTION",
"MYANMAR SYMBOL LOCATIVE",
"MYANMAR SYMBOL COMPLETED",
"MYANMAR SYMBOL AFOREMENTIONED",
"MYANMAR SYMBOL GENITIVE",
"MYANMAR LETTER SHA",
"MYANMAR LETTER SSA",
"MYANMAR LETTER VOCALIC R",
"MYANMAR LETTER VOCALIC RR",
"MYANMAR LETTER VOCALIC L",
"MYANMAR LETTER VOCALIC LL",
"MYANMAR VOWEL SIGN VOCALIC R",
"MYANMAR VOWEL SIGN VOCALIC RR",
"MYANMAR VOWEL SIGN VOCALIC L",
"MYANMAR VOWEL SIGN VOCALIC LL",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GEORGIAN CAPITAL LETTER AN",
"GEORGIAN CAPITAL LETTER BAN",
"GEORGIAN CAPITAL LETTER GAN",
"GEORGIAN CAPITAL LETTER DON",
"GEORGIAN CAPITAL LETTER EN",
"GEORGIAN CAPITAL LETTER VIN",
"GEORGIAN CAPITAL LETTER ZEN",
"GEORGIAN CAPITAL LETTER TAN",
"GEORGIAN CAPITAL LETTER IN",
"GEORGIAN CAPITAL LETTER KAN",
"GEORGIAN CAPITAL LETTER LAS",
"GEORGIAN CAPITAL LETTER MAN",
"GEORGIAN CAPITAL LETTER NAR",
"GEORGIAN CAPITAL LETTER ON",
"GEORGIAN CAPITAL LETTER PAR",
"GEORGIAN CAPITAL LETTER ZHAR",
"GEORGIAN CAPITAL LETTER RAE",
"GEORGIAN CAPITAL LETTER SAN",
"GEORGIAN CAPITAL LETTER TAR",
"GEORGIAN CAPITAL LETTER UN",
"GEORGIAN CAPITAL LETTER PHAR",
"GEORGIAN CAPITAL LETTER KHAR",
"GEORGIAN CAPITAL LETTER GHAN",
"GEORGIAN CAPITAL LETTER QAR",
"GEORGIAN CAPITAL LETTER SHIN",
"GEORGIAN CAPITAL LETTER CHIN",
"GEORGIAN CAPITAL LETTER CAN",
"GEORGIAN CAPITAL LETTER JIL",
"GEORGIAN CAPITAL LETTER CIL",
"GEORGIAN CAPITAL LETTER CHAR",
"GEORGIAN CAPITAL LETTER XAN",
"GEORGIAN CAPITAL LETTER JHAN",
"GEORGIAN CAPITAL LETTER HAE",
"GEORGIAN CAPITAL LETTER HE",
"GEORGIAN CAPITAL LETTER HIE",
"GEORGIAN CAPITAL LETTER WE",
"GEORGIAN CAPITAL LETTER HAR",
"GEORGIAN CAPITAL LETTER HOE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GEORGIAN LETTER AN",
"GEORGIAN LETTER BAN",
"GEORGIAN LETTER GAN",
"GEORGIAN LETTER DON",
"GEORGIAN LETTER EN",
"GEORGIAN LETTER VIN",
"GEORGIAN LETTER ZEN",
"GEORGIAN LETTER TAN",
"GEORGIAN LETTER IN",
"GEORGIAN LETTER KAN",
"GEORGIAN LETTER LAS",
"GEORGIAN LETTER MAN",
"GEORGIAN LETTER NAR",
"GEORGIAN LETTER ON",
"GEORGIAN LETTER PAR",
"GEORGIAN LETTER ZHAR",
"GEORGIAN LETTER RAE",
"GEORGIAN LETTER SAN",
"GEORGIAN LETTER TAR",
"GEORGIAN LETTER UN",
"GEORGIAN LETTER PHAR",
"GEORGIAN LETTER KHAR",
"GEORGIAN LETTER GHAN",
"GEORGIAN LETTER QAR",
"GEORGIAN LETTER SHIN",
"GEORGIAN LETTER CHIN",
"GEORGIAN LETTER CAN",
"GEORGIAN LETTER JIL",
"GEORGIAN LETTER CIL",
"GEORGIAN LETTER CHAR",
"GEORGIAN LETTER XAN",
"GEORGIAN LETTER JHAN",
"GEORGIAN LETTER HAE",
"GEORGIAN LETTER HE",
"GEORGIAN LETTER HIE",
"GEORGIAN LETTER WE",
"GEORGIAN LETTER HAR",
"GEORGIAN LETTER HOE",
"GEORGIAN LETTER FI",
"GEORGIAN LETTER YN",
"GEORGIAN LETTER ELIFI",
"GEORGIAN LETTER TURNED GAN",
"GEORGIAN LETTER AIN",
"GEORGIAN PARAGRAPH SEPARATOR",
"MODIFIER LETTER GEORGIAN NAR",
name_reserved,
name_reserved,
name_reserved};
static const char * name_0011[256] =
{
"HANGUL CHOSEONG KIYEOK",
"HANGUL CHOSEONG SSANGKIYEOK",
"HANGUL CHOSEONG NIEUN",
"HANGUL CHOSEONG TIKEUT",
"HANGUL CHOSEONG SSANGTIKEUT",
"HANGUL CHOSEONG RIEUL",
"HANGUL CHOSEONG MIEUM",
"HANGUL CHOSEONG PIEUP",
"HANGUL CHOSEONG SSANGPIEUP",
"HANGUL CHOSEONG SIOS",
"HANGUL CHOSEONG SSANGSIOS",
"HANGUL CHOSEONG IEUNG",
"HANGUL CHOSEONG CIEUC",
"HANGUL CHOSEONG SSANGCIEUC",
"HANGUL CHOSEONG CHIEUCH",
"HANGUL CHOSEONG KHIEUKH",
"HANGUL CHOSEONG THIEUTH",
"HANGUL CHOSEONG PHIEUPH",
"HANGUL CHOSEONG HIEUH",
"HANGUL CHOSEONG NIEUN-KIYEOK",
"HANGUL CHOSEONG SSANGNIEUN",
"HANGUL CHOSEONG NIEUN-TIKEUT",
"HANGUL CHOSEONG NIEUN-PIEUP",
"HANGUL CHOSEONG TIKEUT-KIYEOK",
"HANGUL CHOSEONG RIEUL-NIEUN",
"HANGUL CHOSEONG SSANGRIEUL",
"HANGUL CHOSEONG RIEUL-HIEUH",
"HANGUL CHOSEONG KAPYEOUNRIEUL",
"HANGUL CHOSEONG MIEUM-PIEUP",
"HANGUL CHOSEONG KAPYEOUNMIEUM",
"HANGUL CHOSEONG PIEUP-KIYEOK",
"HANGUL CHOSEONG PIEUP-NIEUN",
"HANGUL CHOSEONG PIEUP-TIKEUT",
"HANGUL CHOSEONG PIEUP-SIOS",
"HANGUL CHOSEONG PIEUP-SIOS-KIYEOK",
"HANGUL CHOSEONG PIEUP-SIOS-TIKEUT",
"HANGUL CHOSEONG PIEUP-SIOS-PIEUP",
"HANGUL CHOSEONG PIEUP-SSANGSIOS",
"HANGUL CHOSEONG PIEUP-SIOS-CIEUC",
"HANGUL CHOSEONG PIEUP-CIEUC",
"HANGUL CHOSEONG PIEUP-CHIEUCH",
"HANGUL CHOSEONG PIEUP-THIEUTH",
"HANGUL CHOSEONG PIEUP-PHIEUPH",
"HANGUL CHOSEONG KAPYEOUNPIEUP",
"HANGUL CHOSEONG KAPYEOUNSSANGPIEUP",
"HANGUL CHOSEONG SIOS-KIYEOK",
"HANGUL CHOSEONG SIOS-NIEUN",
"HANGUL CHOSEONG SIOS-TIKEUT",
"HANGUL CHOSEONG SIOS-RIEUL",
"HANGUL CHOSEONG SIOS-MIEUM",
"HANGUL CHOSEONG SIOS-PIEUP",
"HANGUL CHOSEONG SIOS-PIEUP-KIYEOK",
"HANGUL CHOSEONG SIOS-SSANGSIOS",
"HANGUL CHOSEONG SIOS-IEUNG",
"HANGUL CHOSEONG SIOS-CIEUC",
"HANGUL CHOSEONG SIOS-CHIEUCH",
"HANGUL CHOSEONG SIOS-KHIEUKH",
"HANGUL CHOSEONG SIOS-THIEUTH",
"HANGUL CHOSEONG SIOS-PHIEUPH",
"HANGUL CHOSEONG SIOS-HIEUH",
"HANGUL CHOSEONG CHITUEUMSIOS",
"HANGUL CHOSEONG CHITUEUMSSANGSIOS",
"HANGUL CHOSEONG CEONGCHIEUMSIOS",
"HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS",
"HANGUL CHOSEONG PANSIOS",
"HANGUL CHOSEONG IEUNG-KIYEOK",
"HANGUL CHOSEONG IEUNG-TIKEUT",
"HANGUL CHOSEONG IEUNG-MIEUM",
"HANGUL CHOSEONG IEUNG-PIEUP",
"HANGUL CHOSEONG IEUNG-SIOS",
"HANGUL CHOSEONG IEUNG-PANSIOS",
"HANGUL CHOSEONG SSANGIEUNG",
"HANGUL CHOSEONG IEUNG-CIEUC",
"HANGUL CHOSEONG IEUNG-CHIEUCH",
"HANGUL CHOSEONG IEUNG-THIEUTH",
"HANGUL CHOSEONG IEUNG-PHIEUPH",
"HANGUL CHOSEONG YESIEUNG",
"HANGUL CHOSEONG CIEUC-IEUNG",
"HANGUL CHOSEONG CHITUEUMCIEUC",
"HANGUL CHOSEONG CHITUEUMSSANGCIEUC",
"HANGUL CHOSEONG CEONGCHIEUMCIEUC",
"HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC",
"HANGUL CHOSEONG CHIEUCH-KHIEUKH",
"HANGUL CHOSEONG CHIEUCH-HIEUH",
"HANGUL CHOSEONG CHITUEUMCHIEUCH",
"HANGUL CHOSEONG CEONGCHIEUMCHIEUCH",
"HANGUL CHOSEONG PHIEUPH-PIEUP",
"HANGUL CHOSEONG KAPYEOUNPHIEUPH",
"HANGUL CHOSEONG SSANGHIEUH",
"HANGUL CHOSEONG YEORINHIEUH",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"HANGUL CHOSEONG FILLER",
"HANGUL JUNGSEONG FILLER",
"HANGUL JUNGSEONG A",
"HANGUL JUNGSEONG AE",
"HANGUL JUNGSEONG YA",
"HANGUL JUNGSEONG YAE",
"HANGUL JUNGSEONG EO",
"HANGUL JUNGSEONG E",
"HANGUL JUNGSEONG YEO",
"HANGUL JUNGSEONG YE",
"HANGUL JUNGSEONG O",
"HANGUL JUNGSEONG WA",
"HANGUL JUNGSEONG WAE",
"HANGUL JUNGSEONG OE",
"HANGUL JUNGSEONG YO",
"HANGUL JUNGSEONG U",
"HANGUL JUNGSEONG WEO",
"HANGUL JUNGSEONG WE",
"HANGUL JUNGSEONG WI",
"HANGUL JUNGSEONG YU",
"HANGUL JUNGSEONG EU",
"HANGUL JUNGSEONG YI",
"HANGUL JUNGSEONG I",
"HANGUL JUNGSEONG A-O",
"HANGUL JUNGSEONG A-U",
"HANGUL JUNGSEONG YA-O",
"HANGUL JUNGSEONG YA-YO",
"HANGUL JUNGSEONG EO-O",
"HANGUL JUNGSEONG EO-U",
"HANGUL JUNGSEONG EO-EU",
"HANGUL JUNGSEONG YEO-O",
"HANGUL JUNGSEONG YEO-U",
"HANGUL JUNGSEONG O-EO",
"HANGUL JUNGSEONG O-E",
"HANGUL JUNGSEONG O-YE",
"HANGUL JUNGSEONG O-O",
"HANGUL JUNGSEONG O-U",
"HANGUL JUNGSEONG YO-YA",
"HANGUL JUNGSEONG YO-YAE",
"HANGUL JUNGSEONG YO-YEO",
"HANGUL JUNGSEONG YO-O",
"HANGUL JUNGSEONG YO-I",
"HANGUL JUNGSEONG U-A",
"HANGUL JUNGSEONG U-AE",
"HANGUL JUNGSEONG U-EO-EU",
"HANGUL JUNGSEONG U-YE",
"HANGUL JUNGSEONG U-U",
"HANGUL JUNGSEONG YU-A",
"HANGUL JUNGSEONG YU-EO",
"HANGUL JUNGSEONG YU-E",
"HANGUL JUNGSEONG YU-YEO",
"HANGUL JUNGSEONG YU-YE",
"HANGUL JUNGSEONG YU-U",
"HANGUL JUNGSEONG YU-I",
"HANGUL JUNGSEONG EU-U",
"HANGUL JUNGSEONG EU-EU",
"HANGUL JUNGSEONG YI-U",
"HANGUL JUNGSEONG I-A",
"HANGUL JUNGSEONG I-YA",
"HANGUL JUNGSEONG I-O",
"HANGUL JUNGSEONG I-U",
"HANGUL JUNGSEONG I-EU",
"HANGUL JUNGSEONG I-ARAEA",
"HANGUL JUNGSEONG ARAEA",
"HANGUL JUNGSEONG ARAEA-EO",
"HANGUL JUNGSEONG ARAEA-U",
"HANGUL JUNGSEONG ARAEA-I",
"HANGUL JUNGSEONG SSANGARAEA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"HANGUL JONGSEONG KIYEOK",
"HANGUL JONGSEONG SSANGKIYEOK",
"HANGUL JONGSEONG KIYEOK-SIOS",
"HANGUL JONGSEONG NIEUN",
"HANGUL JONGSEONG NIEUN-CIEUC",
"HANGUL JONGSEONG NIEUN-HIEUH",
"HANGUL JONGSEONG TIKEUT",
"HANGUL JONGSEONG RIEUL",
"HANGUL JONGSEONG RIEUL-KIYEOK",
"HANGUL JONGSEONG RIEUL-MIEUM",
"HANGUL JONGSEONG RIEUL-PIEUP",
"HANGUL JONGSEONG RIEUL-SIOS",
"HANGUL JONGSEONG RIEUL-THIEUTH",
"HANGUL JONGSEONG RIEUL-PHIEUPH",
"HANGUL JONGSEONG RIEUL-HIEUH",
"HANGUL JONGSEONG MIEUM",
"HANGUL JONGSEONG PIEUP",
"HANGUL JONGSEONG PIEUP-SIOS",
"HANGUL JONGSEONG SIOS",
"HANGUL JONGSEONG SSANGSIOS",
"HANGUL JONGSEONG IEUNG",
"HANGUL JONGSEONG CIEUC",
"HANGUL JONGSEONG CHIEUCH",
"HANGUL JONGSEONG KHIEUKH",
"HANGUL JONGSEONG THIEUTH",
"HANGUL JONGSEONG PHIEUPH",
"HANGUL JONGSEONG HIEUH",
"HANGUL JONGSEONG KIYEOK-RIEUL",
"HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK",
"HANGUL JONGSEONG NIEUN-KIYEOK",
"HANGUL JONGSEONG NIEUN-TIKEUT",
"HANGUL JONGSEONG NIEUN-SIOS",
"HANGUL JONGSEONG NIEUN-PANSIOS",
"HANGUL JONGSEONG NIEUN-THIEUTH",
"HANGUL JONGSEONG TIKEUT-KIYEOK",
"HANGUL JONGSEONG TIKEUT-RIEUL",
"HANGUL JONGSEONG RIEUL-KIYEOK-SIOS",
"HANGUL JONGSEONG RIEUL-NIEUN",
"HANGUL JONGSEONG RIEUL-TIKEUT",
"HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH",
"HANGUL JONGSEONG SSANGRIEUL",
"HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK",
"HANGUL JONGSEONG RIEUL-MIEUM-SIOS",
"HANGUL JONGSEONG RIEUL-PIEUP-SIOS",
"HANGUL JONGSEONG RIEUL-PIEUP-HIEUH",
"HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP",
"HANGUL JONGSEONG RIEUL-SSANGSIOS",
"HANGUL JONGSEONG RIEUL-PANSIOS",
"HANGUL JONGSEONG RIEUL-KHIEUKH",
"HANGUL JONGSEONG RIEUL-YEORINHIEUH",
"HANGUL JONGSEONG MIEUM-KIYEOK",
"HANGUL JONGSEONG MIEUM-RIEUL",
"HANGUL JONGSEONG MIEUM-PIEUP",
"HANGUL JONGSEONG MIEUM-SIOS",
"HANGUL JONGSEONG MIEUM-SSANGSIOS",
"HANGUL JONGSEONG MIEUM-PANSIOS",
"HANGUL JONGSEONG MIEUM-CHIEUCH",
"HANGUL JONGSEONG MIEUM-HIEUH",
"HANGUL JONGSEONG KAPYEOUNMIEUM",
"HANGUL JONGSEONG PIEUP-RIEUL",
"HANGUL JONGSEONG PIEUP-PHIEUPH",
"HANGUL JONGSEONG PIEUP-HIEUH",
"HANGUL JONGSEONG KAPYEOUNPIEUP",
"HANGUL JONGSEONG SIOS-KIYEOK",
"HANGUL JONGSEONG SIOS-TIKEUT",
"HANGUL JONGSEONG SIOS-RIEUL",
"HANGUL JONGSEONG SIOS-PIEUP",
"HANGUL JONGSEONG PANSIOS",
"HANGUL JONGSEONG IEUNG-KIYEOK",
"HANGUL JONGSEONG IEUNG-SSANGKIYEOK",
"HANGUL JONGSEONG SSANGIEUNG",
"HANGUL JONGSEONG IEUNG-KHIEUKH",
"HANGUL JONGSEONG YESIEUNG",
"HANGUL JONGSEONG YESIEUNG-SIOS",
"HANGUL JONGSEONG YESIEUNG-PANSIOS",
"HANGUL JONGSEONG PHIEUPH-PIEUP",
"HANGUL JONGSEONG KAPYEOUNPHIEUPH",
"HANGUL JONGSEONG HIEUH-NIEUN",
"HANGUL JONGSEONG HIEUH-RIEUL",
"HANGUL JONGSEONG HIEUH-MIEUM",
"HANGUL JONGSEONG HIEUH-PIEUP",
"HANGUL JONGSEONG YEORINHIEUH",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0012[256] =
{
"ETHIOPIC SYLLABLE HA",
"ETHIOPIC SYLLABLE HU",
"ETHIOPIC SYLLABLE HI",
"ETHIOPIC SYLLABLE HAA",
"ETHIOPIC SYLLABLE HEE",
"ETHIOPIC SYLLABLE HE",
"ETHIOPIC SYLLABLE HO",
"ETHIOPIC SYLLABLE HOA",
"ETHIOPIC SYLLABLE LA",
"ETHIOPIC SYLLABLE LU",
"ETHIOPIC SYLLABLE LI",
"ETHIOPIC SYLLABLE LAA",
"ETHIOPIC SYLLABLE LEE",
"ETHIOPIC SYLLABLE LE",
"ETHIOPIC SYLLABLE LO",
"ETHIOPIC SYLLABLE LWA",
"ETHIOPIC SYLLABLE HHA",
"ETHIOPIC SYLLABLE HHU",
"ETHIOPIC SYLLABLE HHI",
"ETHIOPIC SYLLABLE HHAA",
"ETHIOPIC SYLLABLE HHEE",
"ETHIOPIC SYLLABLE HHE",
"ETHIOPIC SYLLABLE HHO",
"ETHIOPIC SYLLABLE HHWA",
"ETHIOPIC SYLLABLE MA",
"ETHIOPIC SYLLABLE MU",
"ETHIOPIC SYLLABLE MI",
"ETHIOPIC SYLLABLE MAA",
"ETHIOPIC SYLLABLE MEE",
"ETHIOPIC SYLLABLE ME",
"ETHIOPIC SYLLABLE MO",
"ETHIOPIC SYLLABLE MWA",
"ETHIOPIC SYLLABLE SZA",
"ETHIOPIC SYLLABLE SZU",
"ETHIOPIC SYLLABLE SZI",
"ETHIOPIC SYLLABLE SZAA",
"ETHIOPIC SYLLABLE SZEE",
"ETHIOPIC SYLLABLE SZE",
"ETHIOPIC SYLLABLE SZO",
"ETHIOPIC SYLLABLE SZWA",
"ETHIOPIC SYLLABLE RA",
"ETHIOPIC SYLLABLE RU",
"ETHIOPIC SYLLABLE RI",
"ETHIOPIC SYLLABLE RAA",
"ETHIOPIC SYLLABLE REE",
"ETHIOPIC SYLLABLE RE",
"ETHIOPIC SYLLABLE RO",
"ETHIOPIC SYLLABLE RWA",
"ETHIOPIC SYLLABLE SA",
"ETHIOPIC SYLLABLE SU",
"ETHIOPIC SYLLABLE SI",
"ETHIOPIC SYLLABLE SAA",
"ETHIOPIC SYLLABLE SEE",
"ETHIOPIC SYLLABLE SE",
"ETHIOPIC SYLLABLE SO",
"ETHIOPIC SYLLABLE SWA",
"ETHIOPIC SYLLABLE SHA",
"ETHIOPIC SYLLABLE SHU",
"ETHIOPIC SYLLABLE SHI",
"ETHIOPIC SYLLABLE SHAA",
"ETHIOPIC SYLLABLE SHEE",
"ETHIOPIC SYLLABLE SHE",
"ETHIOPIC SYLLABLE SHO",
"ETHIOPIC SYLLABLE SHWA",
"ETHIOPIC SYLLABLE QA",
"ETHIOPIC SYLLABLE QU",
"ETHIOPIC SYLLABLE QI",
"ETHIOPIC SYLLABLE QAA",
"ETHIOPIC SYLLABLE QEE",
"ETHIOPIC SYLLABLE QE",
"ETHIOPIC SYLLABLE QO",
"ETHIOPIC SYLLABLE QOA",
"ETHIOPIC SYLLABLE QWA",
name_reserved,
"ETHIOPIC SYLLABLE QWI",
"ETHIOPIC SYLLABLE QWAA",
"ETHIOPIC SYLLABLE QWEE",
"ETHIOPIC SYLLABLE QWE",
name_reserved,
name_reserved,
"ETHIOPIC SYLLABLE QHA",
"ETHIOPIC SYLLABLE QHU",
"ETHIOPIC SYLLABLE QHI",
"ETHIOPIC SYLLABLE QHAA",
"ETHIOPIC SYLLABLE QHEE",
"ETHIOPIC SYLLABLE QHE",
"ETHIOPIC SYLLABLE QHO",
name_reserved,
"ETHIOPIC SYLLABLE QHWA",
name_reserved,
"ETHIOPIC SYLLABLE QHWI",
"ETHIOPIC SYLLABLE QHWAA",
"ETHIOPIC SYLLABLE QHWEE",
"ETHIOPIC SYLLABLE QHWE",
name_reserved,
name_reserved,
"ETHIOPIC SYLLABLE BA",
"ETHIOPIC SYLLABLE BU",
"ETHIOPIC SYLLABLE BI",
"ETHIOPIC SYLLABLE BAA",
"ETHIOPIC SYLLABLE BEE",
"ETHIOPIC SYLLABLE BE",
"ETHIOPIC SYLLABLE BO",
"ETHIOPIC SYLLABLE BWA",
"ETHIOPIC SYLLABLE VA",
"ETHIOPIC SYLLABLE VU",
"ETHIOPIC SYLLABLE VI",
"ETHIOPIC SYLLABLE VAA",
"ETHIOPIC SYLLABLE VEE",
"ETHIOPIC SYLLABLE VE",
"ETHIOPIC SYLLABLE VO",
"ETHIOPIC SYLLABLE VWA",
"ETHIOPIC SYLLABLE TA",
"ETHIOPIC SYLLABLE TU",
"ETHIOPIC SYLLABLE TI",
"ETHIOPIC SYLLABLE TAA",
"ETHIOPIC SYLLABLE TEE",
"ETHIOPIC SYLLABLE TE",
"ETHIOPIC SYLLABLE TO",
"ETHIOPIC SYLLABLE TWA",
"ETHIOPIC SYLLABLE CA",
"ETHIOPIC SYLLABLE CU",
"ETHIOPIC SYLLABLE CI",
"ETHIOPIC SYLLABLE CAA",
"ETHIOPIC SYLLABLE CEE",
"ETHIOPIC SYLLABLE CE",
"ETHIOPIC SYLLABLE CO",
"ETHIOPIC SYLLABLE CWA",
"ETHIOPIC SYLLABLE XA",
"ETHIOPIC SYLLABLE XU",
"ETHIOPIC SYLLABLE XI",
"ETHIOPIC SYLLABLE XAA",
"ETHIOPIC SYLLABLE XEE",
"ETHIOPIC SYLLABLE XE",
"ETHIOPIC SYLLABLE XO",
"ETHIOPIC SYLLABLE XOA",
"ETHIOPIC SYLLABLE XWA",
name_reserved,
"ETHIOPIC SYLLABLE XWI",
"ETHIOPIC SYLLABLE XWAA",
"ETHIOPIC SYLLABLE XWEE",
"ETHIOPIC SYLLABLE XWE",
name_reserved,
name_reserved,
"ETHIOPIC SYLLABLE NA",
"ETHIOPIC SYLLABLE NU",
"ETHIOPIC SYLLABLE NI",
"ETHIOPIC SYLLABLE NAA",
"ETHIOPIC SYLLABLE NEE",
"ETHIOPIC SYLLABLE NE",
"ETHIOPIC SYLLABLE NO",
"ETHIOPIC SYLLABLE NWA",
"ETHIOPIC SYLLABLE NYA",
"ETHIOPIC SYLLABLE NYU",
"ETHIOPIC SYLLABLE NYI",
"ETHIOPIC SYLLABLE NYAA",
"ETHIOPIC SYLLABLE NYEE",
"ETHIOPIC SYLLABLE NYE",
"ETHIOPIC SYLLABLE NYO",
"ETHIOPIC SYLLABLE NYWA",
"ETHIOPIC SYLLABLE GLOTTAL A",
"ETHIOPIC SYLLABLE GLOTTAL U",
"ETHIOPIC SYLLABLE GLOTTAL I",
"ETHIOPIC SYLLABLE GLOTTAL AA",
"ETHIOPIC SYLLABLE GLOTTAL EE",
"ETHIOPIC SYLLABLE GLOTTAL E",
"ETHIOPIC SYLLABLE GLOTTAL O",
"ETHIOPIC SYLLABLE GLOTTAL WA",
"ETHIOPIC SYLLABLE KA",
"ETHIOPIC SYLLABLE KU",
"ETHIOPIC SYLLABLE KI",
"ETHIOPIC SYLLABLE KAA",
"ETHIOPIC SYLLABLE KEE",
"ETHIOPIC SYLLABLE KE",
"ETHIOPIC SYLLABLE KO",
"ETHIOPIC SYLLABLE KOA",
"ETHIOPIC SYLLABLE KWA",
name_reserved,
"ETHIOPIC SYLLABLE KWI",
"ETHIOPIC SYLLABLE KWAA",
"ETHIOPIC SYLLABLE KWEE",
"ETHIOPIC SYLLABLE KWE",
name_reserved,
name_reserved,
"ETHIOPIC SYLLABLE KXA",
"ETHIOPIC SYLLABLE KXU",
"ETHIOPIC SYLLABLE KXI",
"ETHIOPIC SYLLABLE KXAA",
"ETHIOPIC SYLLABLE KXEE",
"ETHIOPIC SYLLABLE KXE",
"ETHIOPIC SYLLABLE KXO",
name_reserved,
"ETHIOPIC SYLLABLE KXWA",
name_reserved,
"ETHIOPIC SYLLABLE KXWI",
"ETHIOPIC SYLLABLE KXWAA",
"ETHIOPIC SYLLABLE KXWEE",
"ETHIOPIC SYLLABLE KXWE",
name_reserved,
name_reserved,
"ETHIOPIC SYLLABLE WA",
"ETHIOPIC SYLLABLE WU",
"ETHIOPIC SYLLABLE WI",
"ETHIOPIC SYLLABLE WAA",
"ETHIOPIC SYLLABLE WEE",
"ETHIOPIC SYLLABLE WE",
"ETHIOPIC SYLLABLE WO",
"ETHIOPIC SYLLABLE WOA",
"ETHIOPIC SYLLABLE PHARYNGEAL A",
"ETHIOPIC SYLLABLE PHARYNGEAL U",
"ETHIOPIC SYLLABLE PHARYNGEAL I",
"ETHIOPIC SYLLABLE PHARYNGEAL AA",
"ETHIOPIC SYLLABLE PHARYNGEAL EE",
"ETHIOPIC SYLLABLE PHARYNGEAL E",
"ETHIOPIC SYLLABLE PHARYNGEAL O",
name_reserved,
"ETHIOPIC SYLLABLE ZA",
"ETHIOPIC SYLLABLE ZU",
"ETHIOPIC SYLLABLE ZI",
"ETHIOPIC SYLLABLE ZAA",
"ETHIOPIC SYLLABLE ZEE",
"ETHIOPIC SYLLABLE ZE",
"ETHIOPIC SYLLABLE ZO",
"ETHIOPIC SYLLABLE ZWA",
"ETHIOPIC SYLLABLE ZHA",
"ETHIOPIC SYLLABLE ZHU",
"ETHIOPIC SYLLABLE ZHI",
"ETHIOPIC SYLLABLE ZHAA",
"ETHIOPIC SYLLABLE ZHEE",
"ETHIOPIC SYLLABLE ZHE",
"ETHIOPIC SYLLABLE ZHO",
"ETHIOPIC SYLLABLE ZHWA",
"ETHIOPIC SYLLABLE YA",
"ETHIOPIC SYLLABLE YU",
"ETHIOPIC SYLLABLE YI",
"ETHIOPIC SYLLABLE YAA",
"ETHIOPIC SYLLABLE YEE",
"ETHIOPIC SYLLABLE YE",
"ETHIOPIC SYLLABLE YO",
"ETHIOPIC SYLLABLE YOA",
"ETHIOPIC SYLLABLE DA",
"ETHIOPIC SYLLABLE DU",
"ETHIOPIC SYLLABLE DI",
"ETHIOPIC SYLLABLE DAA",
"ETHIOPIC SYLLABLE DEE",
"ETHIOPIC SYLLABLE DE",
"ETHIOPIC SYLLABLE DO",
"ETHIOPIC SYLLABLE DWA",
"ETHIOPIC SYLLABLE DDA",
"ETHIOPIC SYLLABLE DDU",
"ETHIOPIC SYLLABLE DDI",
"ETHIOPIC SYLLABLE DDAA",
"ETHIOPIC SYLLABLE DDEE",
"ETHIOPIC SYLLABLE DDE",
"ETHIOPIC SYLLABLE DDO",
"ETHIOPIC SYLLABLE DDWA"};
static const char * name_0013[256] =
{
"ETHIOPIC SYLLABLE JA",
"ETHIOPIC SYLLABLE JU",
"ETHIOPIC SYLLABLE JI",
"ETHIOPIC SYLLABLE JAA",
"ETHIOPIC SYLLABLE JEE",
"ETHIOPIC SYLLABLE JE",
"ETHIOPIC SYLLABLE JO",
"ETHIOPIC SYLLABLE JWA",
"ETHIOPIC SYLLABLE GA",
"ETHIOPIC SYLLABLE GU",
"ETHIOPIC SYLLABLE GI",
"ETHIOPIC SYLLABLE GAA",
"ETHIOPIC SYLLABLE GEE",
"ETHIOPIC SYLLABLE GE",
"ETHIOPIC SYLLABLE GO",
"ETHIOPIC SYLLABLE GOA",
"ETHIOPIC SYLLABLE GWA",
name_reserved,
"ETHIOPIC SYLLABLE GWI",
"ETHIOPIC SYLLABLE GWAA",
"ETHIOPIC SYLLABLE GWEE",
"ETHIOPIC SYLLABLE GWE",
name_reserved,
name_reserved,
"ETHIOPIC SYLLABLE GGA",
"ETHIOPIC SYLLABLE GGU",
"ETHIOPIC SYLLABLE GGI",
"ETHIOPIC SYLLABLE GGAA",
"ETHIOPIC SYLLABLE GGEE",
"ETHIOPIC SYLLABLE GGE",
"ETHIOPIC SYLLABLE GGO",
"ETHIOPIC SYLLABLE GGWAA",
"ETHIOPIC SYLLABLE THA",
"ETHIOPIC SYLLABLE THU",
"ETHIOPIC SYLLABLE THI",
"ETHIOPIC SYLLABLE THAA",
"ETHIOPIC SYLLABLE THEE",
"ETHIOPIC SYLLABLE THE",
"ETHIOPIC SYLLABLE THO",
"ETHIOPIC SYLLABLE THWA",
"ETHIOPIC SYLLABLE CHA",
"ETHIOPIC SYLLABLE CHU",
"ETHIOPIC SYLLABLE CHI",
"ETHIOPIC SYLLABLE CHAA",
"ETHIOPIC SYLLABLE CHEE",
"ETHIOPIC SYLLABLE CHE",
"ETHIOPIC SYLLABLE CHO",
"ETHIOPIC SYLLABLE CHWA",
"ETHIOPIC SYLLABLE PHA",
"ETHIOPIC SYLLABLE PHU",
"ETHIOPIC SYLLABLE PHI",
"ETHIOPIC SYLLABLE PHAA",
"ETHIOPIC SYLLABLE PHEE",
"ETHIOPIC SYLLABLE PHE",
"ETHIOPIC SYLLABLE PHO",
"ETHIOPIC SYLLABLE PHWA",
"ETHIOPIC SYLLABLE TSA",
"ETHIOPIC SYLLABLE TSU",
"ETHIOPIC SYLLABLE TSI",
"ETHIOPIC SYLLABLE TSAA",
"ETHIOPIC SYLLABLE TSEE",
"ETHIOPIC SYLLABLE TSE",
"ETHIOPIC SYLLABLE TSO",
"ETHIOPIC SYLLABLE TSWA",
"ETHIOPIC SYLLABLE TZA",
"ETHIOPIC SYLLABLE TZU",
"ETHIOPIC SYLLABLE TZI",
"ETHIOPIC SYLLABLE TZAA",
"ETHIOPIC SYLLABLE TZEE",
"ETHIOPIC SYLLABLE TZE",
"ETHIOPIC SYLLABLE TZO",
"ETHIOPIC SYLLABLE TZOA",
"ETHIOPIC SYLLABLE FA",
"ETHIOPIC SYLLABLE FU",
"ETHIOPIC SYLLABLE FI",
"ETHIOPIC SYLLABLE FAA",
"ETHIOPIC SYLLABLE FEE",
"ETHIOPIC SYLLABLE FE",
"ETHIOPIC SYLLABLE FO",
"ETHIOPIC SYLLABLE FWA",
"ETHIOPIC SYLLABLE PA",
"ETHIOPIC SYLLABLE PU",
"ETHIOPIC SYLLABLE PI",
"ETHIOPIC SYLLABLE PAA",
"ETHIOPIC SYLLABLE PEE",
"ETHIOPIC SYLLABLE PE",
"ETHIOPIC SYLLABLE PO",
"ETHIOPIC SYLLABLE PWA",
"ETHIOPIC SYLLABLE RYA",
"ETHIOPIC SYLLABLE MYA",
"ETHIOPIC SYLLABLE FYA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ETHIOPIC COMBINING GEMINATION MARK",
"ETHIOPIC SECTION MARK",
"ETHIOPIC WORDSPACE",
"ETHIOPIC FULL STOP",
"ETHIOPIC COMMA",
"ETHIOPIC SEMICOLON",
"ETHIOPIC COLON",
"ETHIOPIC PREFACE COLON",
"ETHIOPIC QUESTION MARK",
"ETHIOPIC PARAGRAPH SEPARATOR",
"ETHIOPIC DIGIT ONE",
"ETHIOPIC DIGIT TWO",
"ETHIOPIC DIGIT THREE",
"ETHIOPIC DIGIT FOUR",
"ETHIOPIC DIGIT FIVE",
"ETHIOPIC DIGIT SIX",
"ETHIOPIC DIGIT SEVEN",
"ETHIOPIC DIGIT EIGHT",
"ETHIOPIC DIGIT NINE",
"ETHIOPIC NUMBER TEN",
"ETHIOPIC NUMBER TWENTY",
"ETHIOPIC NUMBER THIRTY",
"ETHIOPIC NUMBER FORTY",
"ETHIOPIC NUMBER FIFTY",
"ETHIOPIC NUMBER SIXTY",
"ETHIOPIC NUMBER SEVENTY",
"ETHIOPIC NUMBER EIGHTY",
"ETHIOPIC NUMBER NINETY",
"ETHIOPIC NUMBER HUNDRED",
"ETHIOPIC NUMBER TEN THOUSAND",
name_reserved,
name_reserved,
name_reserved,
"ETHIOPIC SYLLABLE SEBATBEIT MWA",
"ETHIOPIC SYLLABLE MWI",
"ETHIOPIC SYLLABLE MWEE",
"ETHIOPIC SYLLABLE MWE",
"ETHIOPIC SYLLABLE SEBATBEIT BWA",
"ETHIOPIC SYLLABLE BWI",
"ETHIOPIC SYLLABLE BWEE",
"ETHIOPIC SYLLABLE BWE",
"ETHIOPIC SYLLABLE SEBATBEIT FWA",
"ETHIOPIC SYLLABLE FWI",
"ETHIOPIC SYLLABLE FWEE",
"ETHIOPIC SYLLABLE FWE",
"ETHIOPIC SYLLABLE SEBATBEIT PWA",
"ETHIOPIC SYLLABLE PWI",
"ETHIOPIC SYLLABLE PWEE",
"ETHIOPIC SYLLABLE PWE",
"ETHIOPIC TONAL MARK YIZET",
"ETHIOPIC TONAL MARK DERET",
"ETHIOPIC TONAL MARK RIKRIK",
"ETHIOPIC TONAL MARK SHORT RIKRIK",
"ETHIOPIC TONAL MARK DIFAT",
"ETHIOPIC TONAL MARK KENAT",
"ETHIOPIC TONAL MARK CHIRET",
"ETHIOPIC TONAL MARK HIDET",
"ETHIOPIC TONAL MARK DERET-HIDET",
"ETHIOPIC TONAL MARK KURT",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"CHEROKEE LETTER A",
"CHEROKEE LETTER E",
"CHEROKEE LETTER I",
"CHEROKEE LETTER O",
"CHEROKEE LETTER U",
"CHEROKEE LETTER V",
"CHEROKEE LETTER GA",
"CHEROKEE LETTER KA",
"CHEROKEE LETTER GE",
"CHEROKEE LETTER GI",
"CHEROKEE LETTER GO",
"CHEROKEE LETTER GU",
"CHEROKEE LETTER GV",
"CHEROKEE LETTER HA",
"CHEROKEE LETTER HE",
"CHEROKEE LETTER HI",
"CHEROKEE LETTER HO",
"CHEROKEE LETTER HU",
"CHEROKEE LETTER HV",
"CHEROKEE LETTER LA",
"CHEROKEE LETTER LE",
"CHEROKEE LETTER LI",
"CHEROKEE LETTER LO",
"CHEROKEE LETTER LU",
"CHEROKEE LETTER LV",
"CHEROKEE LETTER MA",
"CHEROKEE LETTER ME",
"CHEROKEE LETTER MI",
"CHEROKEE LETTER MO",
"CHEROKEE LETTER MU",
"CHEROKEE LETTER NA",
"CHEROKEE LETTER HNA",
"CHEROKEE LETTER NAH",
"CHEROKEE LETTER NE",
"CHEROKEE LETTER NI",
"CHEROKEE LETTER NO",
"CHEROKEE LETTER NU",
"CHEROKEE LETTER NV",
"CHEROKEE LETTER QUA",
"CHEROKEE LETTER QUE",
"CHEROKEE LETTER QUI",
"CHEROKEE LETTER QUO",
"CHEROKEE LETTER QUU",
"CHEROKEE LETTER QUV",
"CHEROKEE LETTER SA",
"CHEROKEE LETTER S",
"CHEROKEE LETTER SE",
"CHEROKEE LETTER SI",
"CHEROKEE LETTER SO",
"CHEROKEE LETTER SU",
"CHEROKEE LETTER SV",
"CHEROKEE LETTER DA",
"CHEROKEE LETTER TA",
"CHEROKEE LETTER DE",
"CHEROKEE LETTER TE",
"CHEROKEE LETTER DI",
"CHEROKEE LETTER TI",
"CHEROKEE LETTER DO",
"CHEROKEE LETTER DU",
"CHEROKEE LETTER DV",
"CHEROKEE LETTER DLA",
"CHEROKEE LETTER TLA",
"CHEROKEE LETTER TLE",
"CHEROKEE LETTER TLI",
"CHEROKEE LETTER TLO",
"CHEROKEE LETTER TLU",
"CHEROKEE LETTER TLV",
"CHEROKEE LETTER TSA",
"CHEROKEE LETTER TSE",
"CHEROKEE LETTER TSI",
"CHEROKEE LETTER TSO",
"CHEROKEE LETTER TSU",
"CHEROKEE LETTER TSV",
"CHEROKEE LETTER WA",
"CHEROKEE LETTER WE",
"CHEROKEE LETTER WI",
"CHEROKEE LETTER WO",
"CHEROKEE LETTER WU",
"CHEROKEE LETTER WV",
"CHEROKEE LETTER YA",
"CHEROKEE LETTER YE",
"CHEROKEE LETTER YI",
"CHEROKEE LETTER YO",
"CHEROKEE LETTER YU",
"CHEROKEE LETTER YV",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0014[256] =
{
name_reserved,
"CANADIAN SYLLABICS E",
"CANADIAN SYLLABICS AAI",
"CANADIAN SYLLABICS I",
"CANADIAN SYLLABICS II",
"CANADIAN SYLLABICS O",
"CANADIAN SYLLABICS OO",
"CANADIAN SYLLABICS Y-CREE OO",
"CANADIAN SYLLABICS CARRIER EE",
"CANADIAN SYLLABICS CARRIER I",
"CANADIAN SYLLABICS A",
"CANADIAN SYLLABICS AA",
"CANADIAN SYLLABICS WE",
"CANADIAN SYLLABICS WEST-CREE WE",
"CANADIAN SYLLABICS WI",
"CANADIAN SYLLABICS WEST-CREE WI",
"CANADIAN SYLLABICS WII",
"CANADIAN SYLLABICS WEST-CREE WII",
"CANADIAN SYLLABICS WO",
"CANADIAN SYLLABICS WEST-CREE WO",
"CANADIAN SYLLABICS WOO",
"CANADIAN SYLLABICS WEST-CREE WOO",
"CANADIAN SYLLABICS NASKAPI WOO",
"CANADIAN SYLLABICS WA",
"CANADIAN SYLLABICS WEST-CREE WA",
"CANADIAN SYLLABICS WAA",
"CANADIAN SYLLABICS WEST-CREE WAA",
"CANADIAN SYLLABICS NASKAPI WAA",
"CANADIAN SYLLABICS AI",
"CANADIAN SYLLABICS Y-CREE W",
"CANADIAN SYLLABICS GLOTTAL STOP",
"CANADIAN SYLLABICS FINAL ACUTE",
"CANADIAN SYLLABICS FINAL GRAVE",
"CANADIAN SYLLABICS FINAL BOTTOM HALF RING",
"CANADIAN SYLLABICS FINAL TOP HALF RING",
"CANADIAN SYLLABICS FINAL RIGHT HALF RING",
"CANADIAN SYLLABICS FINAL RING",
"CANADIAN SYLLABICS FINAL DOUBLE ACUTE",
"CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES",
"CANADIAN SYLLABICS FINAL MIDDLE DOT",
"CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE",
"CANADIAN SYLLABICS FINAL PLUS",
"CANADIAN SYLLABICS FINAL DOWN TACK",
"CANADIAN SYLLABICS EN",
"CANADIAN SYLLABICS IN",
"CANADIAN SYLLABICS ON",
"CANADIAN SYLLABICS AN",
"CANADIAN SYLLABICS PE",
"CANADIAN SYLLABICS PAAI",
"CANADIAN SYLLABICS PI",
"CANADIAN SYLLABICS PII",
"CANADIAN SYLLABICS PO",
"CANADIAN SYLLABICS POO",
"CANADIAN SYLLABICS Y-CREE POO",
"CANADIAN SYLLABICS CARRIER HEE",
"CANADIAN SYLLABICS CARRIER HI",
"CANADIAN SYLLABICS PA",
"CANADIAN SYLLABICS PAA",
"CANADIAN SYLLABICS PWE",
"CANADIAN SYLLABICS WEST-CREE PWE",
"CANADIAN SYLLABICS PWI",
"CANADIAN SYLLABICS WEST-CREE PWI",
"CANADIAN SYLLABICS PWII",
"CANADIAN SYLLABICS WEST-CREE PWII",
"CANADIAN SYLLABICS PWO",
"CANADIAN SYLLABICS WEST-CREE PWO",
"CANADIAN SYLLABICS PWOO",
"CANADIAN SYLLABICS WEST-CREE PWOO",
"CANADIAN SYLLABICS PWA",
"CANADIAN SYLLABICS WEST-CREE PWA",
"CANADIAN SYLLABICS PWAA",
"CANADIAN SYLLABICS WEST-CREE PWAA",
"CANADIAN SYLLABICS Y-CREE PWAA",
"CANADIAN SYLLABICS P",
"CANADIAN SYLLABICS WEST-CREE P",
"CANADIAN SYLLABICS CARRIER H",
"CANADIAN SYLLABICS TE",
"CANADIAN SYLLABICS TAAI",
"CANADIAN SYLLABICS TI",
"CANADIAN SYLLABICS TII",
"CANADIAN SYLLABICS TO",
"CANADIAN SYLLABICS TOO",
"CANADIAN SYLLABICS Y-CREE TOO",
"CANADIAN SYLLABICS CARRIER DEE",
"CANADIAN SYLLABICS CARRIER DI",
"CANADIAN SYLLABICS TA",
"CANADIAN SYLLABICS TAA",
"CANADIAN SYLLABICS TWE",
"CANADIAN SYLLABICS WEST-CREE TWE",
"CANADIAN SYLLABICS TWI",
"CANADIAN SYLLABICS WEST-CREE TWI",
"CANADIAN SYLLABICS TWII",
"CANADIAN SYLLABICS WEST-CREE TWII",
"CANADIAN SYLLABICS TWO",
"CANADIAN SYLLABICS WEST-CREE TWO",
"CANADIAN SYLLABICS TWOO",
"CANADIAN SYLLABICS WEST-CREE TWOO",
"CANADIAN SYLLABICS TWA",
"CANADIAN SYLLABICS WEST-CREE TWA",
"CANADIAN SYLLABICS TWAA",
"CANADIAN SYLLABICS WEST-CREE TWAA",
"CANADIAN SYLLABICS NASKAPI TWAA",
"CANADIAN SYLLABICS T",
"CANADIAN SYLLABICS TTE",
"CANADIAN SYLLABICS TTI",
"CANADIAN SYLLABICS TTO",
"CANADIAN SYLLABICS TTA",
"CANADIAN SYLLABICS KE",
"CANADIAN SYLLABICS KAAI",
"CANADIAN SYLLABICS KI",
"CANADIAN SYLLABICS KII",
"CANADIAN SYLLABICS KO",
"CANADIAN SYLLABICS KOO",
"CANADIAN SYLLABICS Y-CREE KOO",
"CANADIAN SYLLABICS KA",
"CANADIAN SYLLABICS KAA",
"CANADIAN SYLLABICS KWE",
"CANADIAN SYLLABICS WEST-CREE KWE",
"CANADIAN SYLLABICS KWI",
"CANADIAN SYLLABICS WEST-CREE KWI",
"CANADIAN SYLLABICS KWII",
"CANADIAN SYLLABICS WEST-CREE KWII",
"CANADIAN SYLLABICS KWO",
"CANADIAN SYLLABICS WEST-CREE KWO",
"CANADIAN SYLLABICS KWOO",
"CANADIAN SYLLABICS WEST-CREE KWOO",
"CANADIAN SYLLABICS KWA",
"CANADIAN SYLLABICS WEST-CREE KWA",
"CANADIAN SYLLABICS KWAA",
"CANADIAN SYLLABICS WEST-CREE KWAA",
"CANADIAN SYLLABICS NASKAPI KWAA",
"CANADIAN SYLLABICS K",
"CANADIAN SYLLABICS KW",
"CANADIAN SYLLABICS SOUTH-SLAVEY KEH",
"CANADIAN SYLLABICS SOUTH-SLAVEY KIH",
"CANADIAN SYLLABICS SOUTH-SLAVEY KOH",
"CANADIAN SYLLABICS SOUTH-SLAVEY KAH",
"CANADIAN SYLLABICS CE",
"CANADIAN SYLLABICS CAAI",
"CANADIAN SYLLABICS CI",
"CANADIAN SYLLABICS CII",
"CANADIAN SYLLABICS CO",
"CANADIAN SYLLABICS COO",
"CANADIAN SYLLABICS Y-CREE COO",
"CANADIAN SYLLABICS CA",
"CANADIAN SYLLABICS CAA",
"CANADIAN SYLLABICS CWE",
"CANADIAN SYLLABICS WEST-CREE CWE",
"CANADIAN SYLLABICS CWI",
"CANADIAN SYLLABICS WEST-CREE CWI",
"CANADIAN SYLLABICS CWII",
"CANADIAN SYLLABICS WEST-CREE CWII",
"CANADIAN SYLLABICS CWO",
"CANADIAN SYLLABICS WEST-CREE CWO",
"CANADIAN SYLLABICS CWOO",
"CANADIAN SYLLABICS WEST-CREE CWOO",
"CANADIAN SYLLABICS CWA",
"CANADIAN SYLLABICS WEST-CREE CWA",
"CANADIAN SYLLABICS CWAA",
"CANADIAN SYLLABICS WEST-CREE CWAA",
"CANADIAN SYLLABICS NASKAPI CWAA",
"CANADIAN SYLLABICS C",
"CANADIAN SYLLABICS SAYISI TH",
"CANADIAN SYLLABICS ME",
"CANADIAN SYLLABICS MAAI",
"CANADIAN SYLLABICS MI",
"CANADIAN SYLLABICS MII",
"CANADIAN SYLLABICS MO",
"CANADIAN SYLLABICS MOO",
"CANADIAN SYLLABICS Y-CREE MOO",
"CANADIAN SYLLABICS MA",
"CANADIAN SYLLABICS MAA",
"CANADIAN SYLLABICS MWE",
"CANADIAN SYLLABICS WEST-CREE MWE",
"CANADIAN SYLLABICS MWI",
"CANADIAN SYLLABICS WEST-CREE MWI",
"CANADIAN SYLLABICS MWII",
"CANADIAN SYLLABICS WEST-CREE MWII",
"CANADIAN SYLLABICS MWO",
"CANADIAN SYLLABICS WEST-CREE MWO",
"CANADIAN SYLLABICS MWOO",
"CANADIAN SYLLABICS WEST-CREE MWOO",
"CANADIAN SYLLABICS MWA",
"CANADIAN SYLLABICS WEST-CREE MWA",
"CANADIAN SYLLABICS MWAA",
"CANADIAN SYLLABICS WEST-CREE MWAA",
"CANADIAN SYLLABICS NASKAPI MWAA",
"CANADIAN SYLLABICS M",
"CANADIAN SYLLABICS WEST-CREE M",
"CANADIAN SYLLABICS MH",
"CANADIAN SYLLABICS ATHAPASCAN M",
"CANADIAN SYLLABICS SAYISI M",
"CANADIAN SYLLABICS NE",
"CANADIAN SYLLABICS NAAI",
"CANADIAN SYLLABICS NI",
"CANADIAN SYLLABICS NII",
"CANADIAN SYLLABICS NO",
"CANADIAN SYLLABICS NOO",
"CANADIAN SYLLABICS Y-CREE NOO",
"CANADIAN SYLLABICS NA",
"CANADIAN SYLLABICS NAA",
"CANADIAN SYLLABICS NWE",
"CANADIAN SYLLABICS WEST-CREE NWE",
"CANADIAN SYLLABICS NWA",
"CANADIAN SYLLABICS WEST-CREE NWA",
"CANADIAN SYLLABICS NWAA",
"CANADIAN SYLLABICS WEST-CREE NWAA",
"CANADIAN SYLLABICS NASKAPI NWAA",
"CANADIAN SYLLABICS N",
"CANADIAN SYLLABICS CARRIER NG",
"CANADIAN SYLLABICS NH",
"CANADIAN SYLLABICS LE",
"CANADIAN SYLLABICS LAAI",
"CANADIAN SYLLABICS LI",
"CANADIAN SYLLABICS LII",
"CANADIAN SYLLABICS LO",
"CANADIAN SYLLABICS LOO",
"CANADIAN SYLLABICS Y-CREE LOO",
"CANADIAN SYLLABICS LA",
"CANADIAN SYLLABICS LAA",
"CANADIAN SYLLABICS LWE",
"CANADIAN SYLLABICS WEST-CREE LWE",
"CANADIAN SYLLABICS LWI",
"CANADIAN SYLLABICS WEST-CREE LWI",
"CANADIAN SYLLABICS LWII",
"CANADIAN SYLLABICS WEST-CREE LWII",
"CANADIAN SYLLABICS LWO",
"CANADIAN SYLLABICS WEST-CREE LWO",
"CANADIAN SYLLABICS LWOO",
"CANADIAN SYLLABICS WEST-CREE LWOO",
"CANADIAN SYLLABICS LWA",
"CANADIAN SYLLABICS WEST-CREE LWA",
"CANADIAN SYLLABICS LWAA",
"CANADIAN SYLLABICS WEST-CREE LWAA",
"CANADIAN SYLLABICS L",
"CANADIAN SYLLABICS WEST-CREE L",
"CANADIAN SYLLABICS MEDIAL L",
"CANADIAN SYLLABICS SE",
"CANADIAN SYLLABICS SAAI",
"CANADIAN SYLLABICS SI",
"CANADIAN SYLLABICS SII",
"CANADIAN SYLLABICS SO",
"CANADIAN SYLLABICS SOO",
"CANADIAN SYLLABICS Y-CREE SOO",
"CANADIAN SYLLABICS SA",
"CANADIAN SYLLABICS SAA",
"CANADIAN SYLLABICS SWE",
"CANADIAN SYLLABICS WEST-CREE SWE",
"CANADIAN SYLLABICS SWI",
"CANADIAN SYLLABICS WEST-CREE SWI",
"CANADIAN SYLLABICS SWII",
"CANADIAN SYLLABICS WEST-CREE SWII",
"CANADIAN SYLLABICS SWO",
"CANADIAN SYLLABICS WEST-CREE SWO",
"CANADIAN SYLLABICS SWOO",
"CANADIAN SYLLABICS WEST-CREE SWOO"};
static const char * name_0015[256] =
{
"CANADIAN SYLLABICS SWA",
"CANADIAN SYLLABICS WEST-CREE SWA",
"CANADIAN SYLLABICS SWAA",
"CANADIAN SYLLABICS WEST-CREE SWAA",
"CANADIAN SYLLABICS NASKAPI SWAA",
"CANADIAN SYLLABICS S",
"CANADIAN SYLLABICS ATHAPASCAN S",
"CANADIAN SYLLABICS SW",
"CANADIAN SYLLABICS BLACKFOOT S",
"CANADIAN SYLLABICS MOOSE-CREE SK",
"CANADIAN SYLLABICS NASKAPI SKW",
"CANADIAN SYLLABICS NASKAPI S-W",
"CANADIAN SYLLABICS NASKAPI SPWA",
"CANADIAN SYLLABICS NASKAPI STWA",
"CANADIAN SYLLABICS NASKAPI SKWA",
"CANADIAN SYLLABICS NASKAPI SCWA",
"CANADIAN SYLLABICS SHE",
"CANADIAN SYLLABICS SHI",
"CANADIAN SYLLABICS SHII",
"CANADIAN SYLLABICS SHO",
"CANADIAN SYLLABICS SHOO",
"CANADIAN SYLLABICS SHA",
"CANADIAN SYLLABICS SHAA",
"CANADIAN SYLLABICS SHWE",
"CANADIAN SYLLABICS WEST-CREE SHWE",
"CANADIAN SYLLABICS SHWI",
"CANADIAN SYLLABICS WEST-CREE SHWI",
"CANADIAN SYLLABICS SHWII",
"CANADIAN SYLLABICS WEST-CREE SHWII",
"CANADIAN SYLLABICS SHWO",
"CANADIAN SYLLABICS WEST-CREE SHWO",
"CANADIAN SYLLABICS SHWOO",
"CANADIAN SYLLABICS WEST-CREE SHWOO",
"CANADIAN SYLLABICS SHWA",
"CANADIAN SYLLABICS WEST-CREE SHWA",
"CANADIAN SYLLABICS SHWAA",
"CANADIAN SYLLABICS WEST-CREE SHWAA",
"CANADIAN SYLLABICS SH",
"CANADIAN SYLLABICS YE",
"CANADIAN SYLLABICS YAAI",
"CANADIAN SYLLABICS YI",
"CANADIAN SYLLABICS YII",
"CANADIAN SYLLABICS YO",
"CANADIAN SYLLABICS YOO",
"CANADIAN SYLLABICS Y-CREE YOO",
"CANADIAN SYLLABICS YA",
"CANADIAN SYLLABICS YAA",
"CANADIAN SYLLABICS YWE",
"CANADIAN SYLLABICS WEST-CREE YWE",
"CANADIAN SYLLABICS YWI",
"CANADIAN SYLLABICS WEST-CREE YWI",
"CANADIAN SYLLABICS YWII",
"CANADIAN SYLLABICS WEST-CREE YWII",
"CANADIAN SYLLABICS YWO",
"CANADIAN SYLLABICS WEST-CREE YWO",
"CANADIAN SYLLABICS YWOO",
"CANADIAN SYLLABICS WEST-CREE YWOO",
"CANADIAN SYLLABICS YWA",
"CANADIAN SYLLABICS WEST-CREE YWA",
"CANADIAN SYLLABICS YWAA",
"CANADIAN SYLLABICS WEST-CREE YWAA",
"CANADIAN SYLLABICS NASKAPI YWAA",
"CANADIAN SYLLABICS Y",
"CANADIAN SYLLABICS BIBLE-CREE Y",
"CANADIAN SYLLABICS WEST-CREE Y",
"CANADIAN SYLLABICS SAYISI YI",
"CANADIAN SYLLABICS RE",
"CANADIAN SYLLABICS R-CREE RE",
"CANADIAN SYLLABICS WEST-CREE LE",
"CANADIAN SYLLABICS RAAI",
"CANADIAN SYLLABICS RI",
"CANADIAN SYLLABICS RII",
"CANADIAN SYLLABICS RO",
"CANADIAN SYLLABICS ROO",
"CANADIAN SYLLABICS WEST-CREE LO",
"CANADIAN SYLLABICS RA",
"CANADIAN SYLLABICS RAA",
"CANADIAN SYLLABICS WEST-CREE LA",
"CANADIAN SYLLABICS RWAA",
"CANADIAN SYLLABICS WEST-CREE RWAA",
"CANADIAN SYLLABICS R",
"CANADIAN SYLLABICS WEST-CREE R",
"CANADIAN SYLLABICS MEDIAL R",
"CANADIAN SYLLABICS FE",
"CANADIAN SYLLABICS FAAI",
"CANADIAN SYLLABICS FI",
"CANADIAN SYLLABICS FII",
"CANADIAN SYLLABICS FO",
"CANADIAN SYLLABICS FOO",
"CANADIAN SYLLABICS FA",
"CANADIAN SYLLABICS FAA",
"CANADIAN SYLLABICS FWAA",
"CANADIAN SYLLABICS WEST-CREE FWAA",
"CANADIAN SYLLABICS F",
"CANADIAN SYLLABICS THE",
"CANADIAN SYLLABICS N-CREE THE",
"CANADIAN SYLLABICS THI",
"CANADIAN SYLLABICS N-CREE THI",
"CANADIAN SYLLABICS THII",
"CANADIAN SYLLABICS N-CREE THII",
"CANADIAN SYLLABICS THO",
"CANADIAN SYLLABICS THOO",
"CANADIAN SYLLABICS THA",
"CANADIAN SYLLABICS THAA",
"CANADIAN SYLLABICS THWAA",
"CANADIAN SYLLABICS WEST-CREE THWAA",
"CANADIAN SYLLABICS TH",
"CANADIAN SYLLABICS TTHE",
"CANADIAN SYLLABICS TTHI",
"CANADIAN SYLLABICS TTHO",
"CANADIAN SYLLABICS TTHA",
"CANADIAN SYLLABICS TTH",
"CANADIAN SYLLABICS TYE",
"CANADIAN SYLLABICS TYI",
"CANADIAN SYLLABICS TYO",
"CANADIAN SYLLABICS TYA",
"CANADIAN SYLLABICS NUNAVIK HE",
"CANADIAN SYLLABICS NUNAVIK HI",
"CANADIAN SYLLABICS NUNAVIK HII",
"CANADIAN SYLLABICS NUNAVIK HO",
"CANADIAN SYLLABICS NUNAVIK HOO",
"CANADIAN SYLLABICS NUNAVIK HA",
"CANADIAN SYLLABICS NUNAVIK HAA",
"CANADIAN SYLLABICS NUNAVIK H",
"CANADIAN SYLLABICS NUNAVUT H",
"CANADIAN SYLLABICS HK",
"CANADIAN SYLLABICS QAAI",
"CANADIAN SYLLABICS QI",
"CANADIAN SYLLABICS QII",
"CANADIAN SYLLABICS QO",
"CANADIAN SYLLABICS QOO",
"CANADIAN SYLLABICS QA",
"CANADIAN SYLLABICS QAA",
"CANADIAN SYLLABICS Q",
"CANADIAN SYLLABICS TLHE",
"CANADIAN SYLLABICS TLHI",
"CANADIAN SYLLABICS TLHO",
"CANADIAN SYLLABICS TLHA",
"CANADIAN SYLLABICS WEST-CREE RE",
"CANADIAN SYLLABICS WEST-CREE RI",
"CANADIAN SYLLABICS WEST-CREE RO",
"CANADIAN SYLLABICS WEST-CREE RA",
"CANADIAN SYLLABICS NGAAI",
"CANADIAN SYLLABICS NGI",
"CANADIAN SYLLABICS NGII",
"CANADIAN SYLLABICS NGO",
"CANADIAN SYLLABICS NGOO",
"CANADIAN SYLLABICS NGA",
"CANADIAN SYLLABICS NGAA",
"CANADIAN SYLLABICS NG",
"CANADIAN SYLLABICS NNG",
"CANADIAN SYLLABICS SAYISI SHE",
"CANADIAN SYLLABICS SAYISI SHI",
"CANADIAN SYLLABICS SAYISI SHO",
"CANADIAN SYLLABICS SAYISI SHA",
"CANADIAN SYLLABICS WOODS-CREE THE",
"CANADIAN SYLLABICS WOODS-CREE THI",
"CANADIAN SYLLABICS WOODS-CREE THO",
"CANADIAN SYLLABICS WOODS-CREE THA",
"CANADIAN SYLLABICS WOODS-CREE TH",
"CANADIAN SYLLABICS LHI",
"CANADIAN SYLLABICS LHII",
"CANADIAN SYLLABICS LHO",
"CANADIAN SYLLABICS LHOO",
"CANADIAN SYLLABICS LHA",
"CANADIAN SYLLABICS LHAA",
"CANADIAN SYLLABICS LH",
"CANADIAN SYLLABICS TH-CREE THE",
"CANADIAN SYLLABICS TH-CREE THI",
"CANADIAN SYLLABICS TH-CREE THII",
"CANADIAN SYLLABICS TH-CREE THO",
"CANADIAN SYLLABICS TH-CREE THOO",
"CANADIAN SYLLABICS TH-CREE THA",
"CANADIAN SYLLABICS TH-CREE THAA",
"CANADIAN SYLLABICS TH-CREE TH",
"CANADIAN SYLLABICS AIVILIK B",
"CANADIAN SYLLABICS BLACKFOOT E",
"CANADIAN SYLLABICS BLACKFOOT I",
"CANADIAN SYLLABICS BLACKFOOT O",
"CANADIAN SYLLABICS BLACKFOOT A",
"CANADIAN SYLLABICS BLACKFOOT WE",
"CANADIAN SYLLABICS BLACKFOOT WI",
"CANADIAN SYLLABICS BLACKFOOT WO",
"CANADIAN SYLLABICS BLACKFOOT WA",
"CANADIAN SYLLABICS BLACKFOOT NE",
"CANADIAN SYLLABICS BLACKFOOT NI",
"CANADIAN SYLLABICS BLACKFOOT NO",
"CANADIAN SYLLABICS BLACKFOOT NA",
"CANADIAN SYLLABICS BLACKFOOT KE",
"CANADIAN SYLLABICS BLACKFOOT KI",
"CANADIAN SYLLABICS BLACKFOOT KO",
"CANADIAN SYLLABICS BLACKFOOT KA",
"CANADIAN SYLLABICS SAYISI HE",
"CANADIAN SYLLABICS SAYISI HI",
"CANADIAN SYLLABICS SAYISI HO",
"CANADIAN SYLLABICS SAYISI HA",
"CANADIAN SYLLABICS CARRIER GHU",
"CANADIAN SYLLABICS CARRIER GHO",
"CANADIAN SYLLABICS CARRIER GHE",
"CANADIAN SYLLABICS CARRIER GHEE",
"CANADIAN SYLLABICS CARRIER GHI",
"CANADIAN SYLLABICS CARRIER GHA",
"CANADIAN SYLLABICS CARRIER RU",
"CANADIAN SYLLABICS CARRIER RO",
"CANADIAN SYLLABICS CARRIER RE",
"CANADIAN SYLLABICS CARRIER REE",
"CANADIAN SYLLABICS CARRIER RI",
"CANADIAN SYLLABICS CARRIER RA",
"CANADIAN SYLLABICS CARRIER WU",
"CANADIAN SYLLABICS CARRIER WO",
"CANADIAN SYLLABICS CARRIER WE",
"CANADIAN SYLLABICS CARRIER WEE",
"CANADIAN SYLLABICS CARRIER WI",
"CANADIAN SYLLABICS CARRIER WA",
"CANADIAN SYLLABICS CARRIER HWU",
"CANADIAN SYLLABICS CARRIER HWO",
"CANADIAN SYLLABICS CARRIER HWE",
"CANADIAN SYLLABICS CARRIER HWEE",
"CANADIAN SYLLABICS CARRIER HWI",
"CANADIAN SYLLABICS CARRIER HWA",
"CANADIAN SYLLABICS CARRIER THU",
"CANADIAN SYLLABICS CARRIER THO",
"CANADIAN SYLLABICS CARRIER THE",
"CANADIAN SYLLABICS CARRIER THEE",
"CANADIAN SYLLABICS CARRIER THI",
"CANADIAN SYLLABICS CARRIER THA",
"CANADIAN SYLLABICS CARRIER TTU",
"CANADIAN SYLLABICS CARRIER TTO",
"CANADIAN SYLLABICS CARRIER TTE",
"CANADIAN SYLLABICS CARRIER TTEE",
"CANADIAN SYLLABICS CARRIER TTI",
"CANADIAN SYLLABICS CARRIER TTA",
"CANADIAN SYLLABICS CARRIER PU",
"CANADIAN SYLLABICS CARRIER PO",
"CANADIAN SYLLABICS CARRIER PE",
"CANADIAN SYLLABICS CARRIER PEE",
"CANADIAN SYLLABICS CARRIER PI",
"CANADIAN SYLLABICS CARRIER PA",
"CANADIAN SYLLABICS CARRIER P",
"CANADIAN SYLLABICS CARRIER GU",
"CANADIAN SYLLABICS CARRIER GO",
"CANADIAN SYLLABICS CARRIER GE",
"CANADIAN SYLLABICS CARRIER GEE",
"CANADIAN SYLLABICS CARRIER GI",
"CANADIAN SYLLABICS CARRIER GA",
"CANADIAN SYLLABICS CARRIER KHU",
"CANADIAN SYLLABICS CARRIER KHO",
"CANADIAN SYLLABICS CARRIER KHE",
"CANADIAN SYLLABICS CARRIER KHEE",
"CANADIAN SYLLABICS CARRIER KHI",
"CANADIAN SYLLABICS CARRIER KHA",
"CANADIAN SYLLABICS CARRIER KKU",
"CANADIAN SYLLABICS CARRIER KKO",
"CANADIAN SYLLABICS CARRIER KKE",
"CANADIAN SYLLABICS CARRIER KKEE",
"CANADIAN SYLLABICS CARRIER KKI"};
static const char * name_0016[256] =
{
"CANADIAN SYLLABICS CARRIER KKA",
"CANADIAN SYLLABICS CARRIER KK",
"CANADIAN SYLLABICS CARRIER NU",
"CANADIAN SYLLABICS CARRIER NO",
"CANADIAN SYLLABICS CARRIER NE",
"CANADIAN SYLLABICS CARRIER NEE",
"CANADIAN SYLLABICS CARRIER NI",
"CANADIAN SYLLABICS CARRIER NA",
"CANADIAN SYLLABICS CARRIER MU",
"CANADIAN SYLLABICS CARRIER MO",
"CANADIAN SYLLABICS CARRIER ME",
"CANADIAN SYLLABICS CARRIER MEE",
"CANADIAN SYLLABICS CARRIER MI",
"CANADIAN SYLLABICS CARRIER MA",
"CANADIAN SYLLABICS CARRIER YU",
"CANADIAN SYLLABICS CARRIER YO",
"CANADIAN SYLLABICS CARRIER YE",
"CANADIAN SYLLABICS CARRIER YEE",
"CANADIAN SYLLABICS CARRIER YI",
"CANADIAN SYLLABICS CARRIER YA",
"CANADIAN SYLLABICS CARRIER JU",
"CANADIAN SYLLABICS SAYISI JU",
"CANADIAN SYLLABICS CARRIER JO",
"CANADIAN SYLLABICS CARRIER JE",
"CANADIAN SYLLABICS CARRIER JEE",
"CANADIAN SYLLABICS CARRIER JI",
"CANADIAN SYLLABICS SAYISI JI",
"CANADIAN SYLLABICS CARRIER JA",
"CANADIAN SYLLABICS CARRIER JJU",
"CANADIAN SYLLABICS CARRIER JJO",
"CANADIAN SYLLABICS CARRIER JJE",
"CANADIAN SYLLABICS CARRIER JJEE",
"CANADIAN SYLLABICS CARRIER JJI",
"CANADIAN SYLLABICS CARRIER JJA",
"CANADIAN SYLLABICS CARRIER LU",
"CANADIAN SYLLABICS CARRIER LO",
"CANADIAN SYLLABICS CARRIER LE",
"CANADIAN SYLLABICS CARRIER LEE",
"CANADIAN SYLLABICS CARRIER LI",
"CANADIAN SYLLABICS CARRIER LA",
"CANADIAN SYLLABICS CARRIER DLU",
"CANADIAN SYLLABICS CARRIER DLO",
"CANADIAN SYLLABICS CARRIER DLE",
"CANADIAN SYLLABICS CARRIER DLEE",
"CANADIAN SYLLABICS CARRIER DLI",
"CANADIAN SYLLABICS CARRIER DLA",
"CANADIAN SYLLABICS CARRIER LHU",
"CANADIAN SYLLABICS CARRIER LHO",
"CANADIAN SYLLABICS CARRIER LHE",
"CANADIAN SYLLABICS CARRIER LHEE",
"CANADIAN SYLLABICS CARRIER LHI",
"CANADIAN SYLLABICS CARRIER LHA",
"CANADIAN SYLLABICS CARRIER TLHU",
"CANADIAN SYLLABICS CARRIER TLHO",
"CANADIAN SYLLABICS CARRIER TLHE",
"CANADIAN SYLLABICS CARRIER TLHEE",
"CANADIAN SYLLABICS CARRIER TLHI",
"CANADIAN SYLLABICS CARRIER TLHA",
"CANADIAN SYLLABICS CARRIER TLU",
"CANADIAN SYLLABICS CARRIER TLO",
"CANADIAN SYLLABICS CARRIER TLE",
"CANADIAN SYLLABICS CARRIER TLEE",
"CANADIAN SYLLABICS CARRIER TLI",
"CANADIAN SYLLABICS CARRIER TLA",
"CANADIAN SYLLABICS CARRIER ZU",
"CANADIAN SYLLABICS CARRIER ZO",
"CANADIAN SYLLABICS CARRIER ZE",
"CANADIAN SYLLABICS CARRIER ZEE",
"CANADIAN SYLLABICS CARRIER ZI",
"CANADIAN SYLLABICS CARRIER ZA",
"CANADIAN SYLLABICS CARRIER Z",
"CANADIAN SYLLABICS CARRIER INITIAL Z",
"CANADIAN SYLLABICS CARRIER DZU",
"CANADIAN SYLLABICS CARRIER DZO",
"CANADIAN SYLLABICS CARRIER DZE",
"CANADIAN SYLLABICS CARRIER DZEE",
"CANADIAN SYLLABICS CARRIER DZI",
"CANADIAN SYLLABICS CARRIER DZA",
"CANADIAN SYLLABICS CARRIER SU",
"CANADIAN SYLLABICS CARRIER SO",
"CANADIAN SYLLABICS CARRIER SE",
"CANADIAN SYLLABICS CARRIER SEE",
"CANADIAN SYLLABICS CARRIER SI",
"CANADIAN SYLLABICS CARRIER SA",
"CANADIAN SYLLABICS CARRIER SHU",
"CANADIAN SYLLABICS CARRIER SHO",
"CANADIAN SYLLABICS CARRIER SHE",
"CANADIAN SYLLABICS CARRIER SHEE",
"CANADIAN SYLLABICS CARRIER SHI",
"CANADIAN SYLLABICS CARRIER SHA",
"CANADIAN SYLLABICS CARRIER SH",
"CANADIAN SYLLABICS CARRIER TSU",
"CANADIAN SYLLABICS CARRIER TSO",
"CANADIAN SYLLABICS CARRIER TSE",
"CANADIAN SYLLABICS CARRIER TSEE",
"CANADIAN SYLLABICS CARRIER TSI",
"CANADIAN SYLLABICS CARRIER TSA",
"CANADIAN SYLLABICS CARRIER CHU",
"CANADIAN SYLLABICS CARRIER CHO",
"CANADIAN SYLLABICS CARRIER CHE",
"CANADIAN SYLLABICS CARRIER CHEE",
"CANADIAN SYLLABICS CARRIER CHI",
"CANADIAN SYLLABICS CARRIER CHA",
"CANADIAN SYLLABICS CARRIER TTSU",
"CANADIAN SYLLABICS CARRIER TTSO",
"CANADIAN SYLLABICS CARRIER TTSE",
"CANADIAN SYLLABICS CARRIER TTSEE",
"CANADIAN SYLLABICS CARRIER TTSI",
"CANADIAN SYLLABICS CARRIER TTSA",
"CANADIAN SYLLABICS CHI SIGN",
"CANADIAN SYLLABICS FULL STOP",
"CANADIAN SYLLABICS QAI",
"CANADIAN SYLLABICS NGAI",
"CANADIAN SYLLABICS NNGI",
"CANADIAN SYLLABICS NNGII",
"CANADIAN SYLLABICS NNGO",
"CANADIAN SYLLABICS NNGOO",
"CANADIAN SYLLABICS NNGA",
"CANADIAN SYLLABICS NNGAA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"OGHAM SPACE MARK",
"OGHAM LETTER BEITH",
"OGHAM LETTER LUIS",
"OGHAM LETTER FEARN",
"OGHAM LETTER SAIL",
"OGHAM LETTER NION",
"OGHAM LETTER UATH",
"OGHAM LETTER DAIR",
"OGHAM LETTER TINNE",
"OGHAM LETTER COLL",
"OGHAM LETTER CEIRT",
"OGHAM LETTER MUIN",
"OGHAM LETTER GORT",
"OGHAM LETTER NGEADAL",
"OGHAM LETTER STRAIF",
"OGHAM LETTER RUIS",
"OGHAM LETTER AILM",
"OGHAM LETTER ONN",
"OGHAM LETTER UR",
"OGHAM LETTER EADHADH",
"OGHAM LETTER IODHADH",
"OGHAM LETTER EABHADH",
"OGHAM LETTER OR",
"OGHAM LETTER UILLEANN",
"OGHAM LETTER IFIN",
"OGHAM LETTER EAMHANCHOLL",
"OGHAM LETTER PEITH",
"OGHAM FEATHER MARK",
"OGHAM REVERSED FEATHER MARK",
name_reserved,
name_reserved,
name_reserved,
"RUNIC LETTER FEHU FEOH FE F",
"RUNIC LETTER V",
"RUNIC LETTER URUZ UR U",
"RUNIC LETTER YR",
"RUNIC LETTER Y",
"RUNIC LETTER W",
"RUNIC LETTER THURISAZ THURS THORN",
"RUNIC LETTER ETH",
"RUNIC LETTER ANSUZ A",
"RUNIC LETTER OS O",
"RUNIC LETTER AC A",
"RUNIC LETTER AESC",
"RUNIC LETTER LONG-BRANCH-OSS O",
"RUNIC LETTER SHORT-TWIG-OSS O",
"RUNIC LETTER O",
"RUNIC LETTER OE",
"RUNIC LETTER ON",
"RUNIC LETTER RAIDO RAD REID R",
"RUNIC LETTER KAUNA",
"RUNIC LETTER CEN",
"RUNIC LETTER KAUN K",
"RUNIC LETTER G",
"RUNIC LETTER ENG",
"RUNIC LETTER GEBO GYFU G",
"RUNIC LETTER GAR",
"RUNIC LETTER WUNJO WYNN W",
"RUNIC LETTER HAGLAZ H",
"RUNIC LETTER HAEGL H",
"RUNIC LETTER LONG-BRANCH-HAGALL H",
"RUNIC LETTER SHORT-TWIG-HAGALL H",
"RUNIC LETTER NAUDIZ NYD NAUD N",
"RUNIC LETTER SHORT-TWIG-NAUD N",
"RUNIC LETTER DOTTED-N",
"RUNIC LETTER ISAZ IS ISS I",
"RUNIC LETTER E",
"RUNIC LETTER JERAN J",
"RUNIC LETTER GER",
"RUNIC LETTER LONG-BRANCH-AR AE",
"RUNIC LETTER SHORT-TWIG-AR A",
"RUNIC LETTER IWAZ EOH",
"RUNIC LETTER PERTHO PEORTH P",
"RUNIC LETTER ALGIZ EOLHX",
"RUNIC LETTER SOWILO S",
"RUNIC LETTER SIGEL LONG-BRANCH-SOL S",
"RUNIC LETTER SHORT-TWIG-SOL S",
"RUNIC LETTER C",
"RUNIC LETTER Z",
"RUNIC LETTER TIWAZ TIR TYR T",
"RUNIC LETTER SHORT-TWIG-TYR T",
"RUNIC LETTER D",
"RUNIC LETTER BERKANAN BEORC BJARKAN B",
"RUNIC LETTER SHORT-TWIG-BJARKAN B",
"RUNIC LETTER DOTTED-P",
"RUNIC LETTER OPEN-P",
"RUNIC LETTER EHWAZ EH E",
"RUNIC LETTER MANNAZ MAN M",
"RUNIC LETTER LONG-BRANCH-MADR M",
"RUNIC LETTER SHORT-TWIG-MADR M",
"RUNIC LETTER LAUKAZ LAGU LOGR L",
"RUNIC LETTER DOTTED-L",
"RUNIC LETTER INGWAZ",
"RUNIC LETTER ING",
"RUNIC LETTER DAGAZ DAEG D",
"RUNIC LETTER OTHALAN ETHEL O",
"RUNIC LETTER EAR",
"RUNIC LETTER IOR",
"RUNIC LETTER CWEORTH",
"RUNIC LETTER CALC",
"RUNIC LETTER CEALC",
"RUNIC LETTER STAN",
"RUNIC LETTER LONG-BRANCH-YR",
"RUNIC LETTER SHORT-TWIG-YR",
"RUNIC LETTER ICELANDIC-YR",
"RUNIC LETTER Q",
"RUNIC LETTER X",
"RUNIC SINGLE PUNCTUATION",
"RUNIC MULTIPLE PUNCTUATION",
"RUNIC CROSS PUNCTUATION",
"RUNIC ARLAUG SYMBOL",
"RUNIC TVIMADUR SYMBOL",
"RUNIC BELGTHOR SYMBOL",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0017[256] =
{
"TAGALOG LETTER A",
"TAGALOG LETTER I",
"TAGALOG LETTER U",
"TAGALOG LETTER KA",
"TAGALOG LETTER GA",
"TAGALOG LETTER NGA",
"TAGALOG LETTER TA",
"TAGALOG LETTER DA",
"TAGALOG LETTER NA",
"TAGALOG LETTER PA",
"TAGALOG LETTER BA",
"TAGALOG LETTER MA",
"TAGALOG LETTER YA",
name_reserved,
"TAGALOG LETTER LA",
"TAGALOG LETTER WA",
"TAGALOG LETTER SA",
"TAGALOG LETTER HA",
"TAGALOG VOWEL SIGN I",
"TAGALOG VOWEL SIGN U",
"TAGALOG SIGN VIRAMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"HANUNOO LETTER A",
"HANUNOO LETTER I",
"HANUNOO LETTER U",
"HANUNOO LETTER KA",
"HANUNOO LETTER GA",
"HANUNOO LETTER NGA",
"HANUNOO LETTER TA",
"HANUNOO LETTER DA",
"HANUNOO LETTER NA",
"HANUNOO LETTER PA",
"HANUNOO LETTER BA",
"HANUNOO LETTER MA",
"HANUNOO LETTER YA",
"HANUNOO LETTER RA",
"HANUNOO LETTER LA",
"HANUNOO LETTER WA",
"HANUNOO LETTER SA",
"HANUNOO LETTER HA",
"HANUNOO VOWEL SIGN I",
"HANUNOO VOWEL SIGN U",
"HANUNOO SIGN PAMUDPOD",
"PHILIPPINE SINGLE PUNCTUATION",
"PHILIPPINE DOUBLE PUNCTUATION",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"BUHID LETTER A",
"BUHID LETTER I",
"BUHID LETTER U",
"BUHID LETTER KA",
"BUHID LETTER GA",
"BUHID LETTER NGA",
"BUHID LETTER TA",
"BUHID LETTER DA",
"BUHID LETTER NA",
"BUHID LETTER PA",
"BUHID LETTER BA",
"BUHID LETTER MA",
"BUHID LETTER YA",
"BUHID LETTER RA",
"BUHID LETTER LA",
"BUHID LETTER WA",
"BUHID LETTER SA",
"BUHID LETTER HA",
"BUHID VOWEL SIGN I",
"BUHID VOWEL SIGN U",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TAGBANWA LETTER A",
"TAGBANWA LETTER I",
"TAGBANWA LETTER U",
"TAGBANWA LETTER KA",
"TAGBANWA LETTER GA",
"TAGBANWA LETTER NGA",
"TAGBANWA LETTER TA",
"TAGBANWA LETTER DA",
"TAGBANWA LETTER NA",
"TAGBANWA LETTER PA",
"TAGBANWA LETTER BA",
"TAGBANWA LETTER MA",
"TAGBANWA LETTER YA",
name_reserved,
"TAGBANWA LETTER LA",
"TAGBANWA LETTER WA",
"TAGBANWA LETTER SA",
name_reserved,
"TAGBANWA VOWEL SIGN I",
"TAGBANWA VOWEL SIGN U",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KHMER LETTER KA",
"KHMER LETTER KHA",
"KHMER LETTER KO",
"KHMER LETTER KHO",
"KHMER LETTER NGO",
"KHMER LETTER CA",
"KHMER LETTER CHA",
"KHMER LETTER CO",
"KHMER LETTER CHO",
"KHMER LETTER NYO",
"KHMER LETTER DA",
"KHMER LETTER TTHA",
"KHMER LETTER DO",
"KHMER LETTER TTHO",
"KHMER LETTER NNO",
"KHMER LETTER TA",
"KHMER LETTER THA",
"KHMER LETTER TO",
"KHMER LETTER THO",
"KHMER LETTER NO",
"KHMER LETTER BA",
"KHMER LETTER PHA",
"KHMER LETTER PO",
"KHMER LETTER PHO",
"KHMER LETTER MO",
"KHMER LETTER YO",
"KHMER LETTER RO",
"KHMER LETTER LO",
"KHMER LETTER VO",
"KHMER LETTER SHA",
"KHMER LETTER SSO",
"KHMER LETTER SA",
"KHMER LETTER HA",
"KHMER LETTER LA",
"KHMER LETTER QA",
"KHMER INDEPENDENT VOWEL QAQ",
"KHMER INDEPENDENT VOWEL QAA",
"KHMER INDEPENDENT VOWEL QI",
"KHMER INDEPENDENT VOWEL QII",
"KHMER INDEPENDENT VOWEL QU",
"KHMER INDEPENDENT VOWEL QUK",
"KHMER INDEPENDENT VOWEL QUU",
"KHMER INDEPENDENT VOWEL QUUV",
"KHMER INDEPENDENT VOWEL RY",
"KHMER INDEPENDENT VOWEL RYY",
"KHMER INDEPENDENT VOWEL LY",
"KHMER INDEPENDENT VOWEL LYY",
"KHMER INDEPENDENT VOWEL QE",
"KHMER INDEPENDENT VOWEL QAI",
"KHMER INDEPENDENT VOWEL QOO TYPE ONE",
"KHMER INDEPENDENT VOWEL QOO TYPE TWO",
"KHMER INDEPENDENT VOWEL QAU",
"KHMER VOWEL INHERENT AQ",
"KHMER VOWEL INHERENT AA",
"KHMER VOWEL SIGN AA",
"KHMER VOWEL SIGN I",
"KHMER VOWEL SIGN II",
"KHMER VOWEL SIGN Y",
"KHMER VOWEL SIGN YY",
"KHMER VOWEL SIGN U",
"KHMER VOWEL SIGN UU",
"KHMER VOWEL SIGN UA",
"KHMER VOWEL SIGN OE",
"KHMER VOWEL SIGN YA",
"KHMER VOWEL SIGN IE",
"KHMER VOWEL SIGN E",
"KHMER VOWEL SIGN AE",
"KHMER VOWEL SIGN AI",
"KHMER VOWEL SIGN OO",
"KHMER VOWEL SIGN AU",
"KHMER SIGN NIKAHIT",
"KHMER SIGN REAHMUK",
"KHMER SIGN YUUKALEAPINTU",
"KHMER SIGN MUUSIKATOAN",
"KHMER SIGN TRIISAP",
"KHMER SIGN BANTOC",
"KHMER SIGN ROBAT",
"KHMER SIGN TOANDAKHIAT",
"KHMER SIGN KAKABAT",
"KHMER SIGN AHSDA",
"KHMER SIGN SAMYOK SANNYA",
"KHMER SIGN VIRIAM",
"KHMER SIGN COENG",
"KHMER SIGN BATHAMASAT",
"KHMER SIGN KHAN",
"KHMER SIGN BARIYOOSAN",
"KHMER SIGN CAMNUC PII KUUH",
"KHMER SIGN LEK TOO",
"KHMER SIGN BEYYAL",
"KHMER SIGN PHNAEK MUAN",
"KHMER SIGN KOOMUUT",
"KHMER CURRENCY SYMBOL RIEL",
"KHMER SIGN AVAKRAHASANYA",
"KHMER SIGN ATTHACAN",
name_reserved,
name_reserved,
"KHMER DIGIT ZERO",
"KHMER DIGIT ONE",
"KHMER DIGIT TWO",
"KHMER DIGIT THREE",
"KHMER DIGIT FOUR",
"KHMER DIGIT FIVE",
"KHMER DIGIT SIX",
"KHMER DIGIT SEVEN",
"KHMER DIGIT EIGHT",
"KHMER DIGIT NINE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KHMER SYMBOL LEK ATTAK SON",
"KHMER SYMBOL LEK ATTAK MUOY",
"KHMER SYMBOL LEK ATTAK PII",
"KHMER SYMBOL LEK ATTAK BEI",
"KHMER SYMBOL LEK ATTAK BUON",
"KHMER SYMBOL LEK ATTAK PRAM",
"KHMER SYMBOL LEK ATTAK PRAM-MUOY",
"KHMER SYMBOL LEK ATTAK PRAM-PII",
"KHMER SYMBOL LEK ATTAK PRAM-BEI",
"KHMER SYMBOL LEK ATTAK PRAM-BUON",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0018[256] =
{
"MONGOLIAN BIRGA",
"MONGOLIAN ELLIPSIS",
"MONGOLIAN COMMA",
"MONGOLIAN FULL STOP",
"MONGOLIAN COLON",
"MONGOLIAN FOUR DOTS",
"MONGOLIAN TODO SOFT HYPHEN",
"MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER",
"MONGOLIAN MANCHU COMMA",
"MONGOLIAN MANCHU FULL STOP",
"MONGOLIAN NIRUGU",
"MONGOLIAN FREE VARIATION SELECTOR ONE",
"MONGOLIAN FREE VARIATION SELECTOR TWO",
"MONGOLIAN FREE VARIATION SELECTOR THREE",
"MONGOLIAN VOWEL SEPARATOR",
name_reserved,
"MONGOLIAN DIGIT ZERO",
"MONGOLIAN DIGIT ONE",
"MONGOLIAN DIGIT TWO",
"MONGOLIAN DIGIT THREE",
"MONGOLIAN DIGIT FOUR",
"MONGOLIAN DIGIT FIVE",
"MONGOLIAN DIGIT SIX",
"MONGOLIAN DIGIT SEVEN",
"MONGOLIAN DIGIT EIGHT",
"MONGOLIAN DIGIT NINE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"MONGOLIAN LETTER A",
"MONGOLIAN LETTER E",
"MONGOLIAN LETTER I",
"MONGOLIAN LETTER O",
"MONGOLIAN LETTER U",
"MONGOLIAN LETTER OE",
"MONGOLIAN LETTER UE",
"MONGOLIAN LETTER EE",
"MONGOLIAN LETTER NA",
"MONGOLIAN LETTER ANG",
"MONGOLIAN LETTER BA",
"MONGOLIAN LETTER PA",
"MONGOLIAN LETTER QA",
"MONGOLIAN LETTER GA",
"MONGOLIAN LETTER MA",
"MONGOLIAN LETTER LA",
"MONGOLIAN LETTER SA",
"MONGOLIAN LETTER SHA",
"MONGOLIAN LETTER TA",
"MONGOLIAN LETTER DA",
"MONGOLIAN LETTER CHA",
"MONGOLIAN LETTER JA",
"MONGOLIAN LETTER YA",
"MONGOLIAN LETTER RA",
"MONGOLIAN LETTER WA",
"MONGOLIAN LETTER FA",
"MONGOLIAN LETTER KA",
"MONGOLIAN LETTER KHA",
"MONGOLIAN LETTER TSA",
"MONGOLIAN LETTER ZA",
"MONGOLIAN LETTER HAA",
"MONGOLIAN LETTER ZRA",
"MONGOLIAN LETTER LHA",
"MONGOLIAN LETTER ZHI",
"MONGOLIAN LETTER CHI",
"MONGOLIAN LETTER TODO LONG VOWEL SIGN",
"MONGOLIAN LETTER TODO E",
"MONGOLIAN LETTER TODO I",
"MONGOLIAN LETTER TODO O",
"MONGOLIAN LETTER TODO U",
"MONGOLIAN LETTER TODO OE",
"MONGOLIAN LETTER TODO UE",
"MONGOLIAN LETTER TODO ANG",
"MONGOLIAN LETTER TODO BA",
"MONGOLIAN LETTER TODO PA",
"MONGOLIAN LETTER TODO QA",
"MONGOLIAN LETTER TODO GA",
"MONGOLIAN LETTER TODO MA",
"MONGOLIAN LETTER TODO TA",
"MONGOLIAN LETTER TODO DA",
"MONGOLIAN LETTER TODO CHA",
"MONGOLIAN LETTER TODO JA",
"MONGOLIAN LETTER TODO TSA",
"MONGOLIAN LETTER TODO YA",
"MONGOLIAN LETTER TODO WA",
"MONGOLIAN LETTER TODO KA",
"MONGOLIAN LETTER TODO GAA",
"MONGOLIAN LETTER TODO HAA",
"MONGOLIAN LETTER TODO JIA",
"MONGOLIAN LETTER TODO NIA",
"MONGOLIAN LETTER TODO DZA",
"MONGOLIAN LETTER SIBE E",
"MONGOLIAN LETTER SIBE I",
"MONGOLIAN LETTER SIBE IY",
"MONGOLIAN LETTER SIBE UE",
"MONGOLIAN LETTER SIBE U",
"MONGOLIAN LETTER SIBE ANG",
"MONGOLIAN LETTER SIBE KA",
"MONGOLIAN LETTER SIBE GA",
"MONGOLIAN LETTER SIBE HA",
"MONGOLIAN LETTER SIBE PA",
"MONGOLIAN LETTER SIBE SHA",
"MONGOLIAN LETTER SIBE TA",
"MONGOLIAN LETTER SIBE DA",
"MONGOLIAN LETTER SIBE JA",
"MONGOLIAN LETTER SIBE FA",
"MONGOLIAN LETTER SIBE GAA",
"MONGOLIAN LETTER SIBE HAA",
"MONGOLIAN LETTER SIBE TSA",
"MONGOLIAN LETTER SIBE ZA",
"MONGOLIAN LETTER SIBE RAA",
"MONGOLIAN LETTER SIBE CHA",
"MONGOLIAN LETTER SIBE ZHA",
"MONGOLIAN LETTER MANCHU I",
"MONGOLIAN LETTER MANCHU KA",
"MONGOLIAN LETTER MANCHU RA",
"MONGOLIAN LETTER MANCHU FA",
"MONGOLIAN LETTER MANCHU ZHA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"MONGOLIAN LETTER ALI GALI ANUSVARA ONE",
"MONGOLIAN LETTER ALI GALI VISARGA ONE",
"MONGOLIAN LETTER ALI GALI DAMARU",
"MONGOLIAN LETTER ALI GALI UBADAMA",
"MONGOLIAN LETTER ALI GALI INVERTED UBADAMA",
"MONGOLIAN LETTER ALI GALI BALUDA",
"MONGOLIAN LETTER ALI GALI THREE BALUDA",
"MONGOLIAN LETTER ALI GALI A",
"MONGOLIAN LETTER ALI GALI I",
"MONGOLIAN LETTER ALI GALI KA",
"MONGOLIAN LETTER ALI GALI NGA",
"MONGOLIAN LETTER ALI GALI CA",
"MONGOLIAN LETTER ALI GALI TTA",
"MONGOLIAN LETTER ALI GALI TTHA",
"MONGOLIAN LETTER ALI GALI DDA",
"MONGOLIAN LETTER ALI GALI NNA",
"MONGOLIAN LETTER ALI GALI TA",
"MONGOLIAN LETTER ALI GALI DA",
"MONGOLIAN LETTER ALI GALI PA",
"MONGOLIAN LETTER ALI GALI PHA",
"MONGOLIAN LETTER ALI GALI SSA",
"MONGOLIAN LETTER ALI GALI ZHA",
"MONGOLIAN LETTER ALI GALI ZA",
"MONGOLIAN LETTER ALI GALI AH",
"MONGOLIAN LETTER TODO ALI GALI TA",
"MONGOLIAN LETTER TODO ALI GALI ZHA",
"MONGOLIAN LETTER MANCHU ALI GALI GHA",
"MONGOLIAN LETTER MANCHU ALI GALI NGA",
"MONGOLIAN LETTER MANCHU ALI GALI CA",
"MONGOLIAN LETTER MANCHU ALI GALI JHA",
"MONGOLIAN LETTER MANCHU ALI GALI TTA",
"MONGOLIAN LETTER MANCHU ALI GALI DDHA",
"MONGOLIAN LETTER MANCHU ALI GALI TA",
"MONGOLIAN LETTER MANCHU ALI GALI DHA",
"MONGOLIAN LETTER MANCHU ALI GALI SSA",
"MONGOLIAN LETTER MANCHU ALI GALI CYA",
"MONGOLIAN LETTER MANCHU ALI GALI ZHA",
"MONGOLIAN LETTER MANCHU ALI GALI ZA",
"MONGOLIAN LETTER ALI GALI HALF U",
"MONGOLIAN LETTER ALI GALI HALF YA",
"MONGOLIAN LETTER MANCHU ALI GALI BHA",
"MONGOLIAN LETTER ALI GALI DAGALGA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0019[256] =
{
"LIMBU VOWEL-CARRIER LETTER",
"LIMBU LETTER KA",
"LIMBU LETTER KHA",
"LIMBU LETTER GA",
"LIMBU LETTER GHA",
"LIMBU LETTER NGA",
"LIMBU LETTER CA",
"LIMBU LETTER CHA",
"LIMBU LETTER JA",
"LIMBU LETTER JHA",
"LIMBU LETTER YAN",
"LIMBU LETTER TA",
"LIMBU LETTER THA",
"LIMBU LETTER DA",
"LIMBU LETTER DHA",
"LIMBU LETTER NA",
"LIMBU LETTER PA",
"LIMBU LETTER PHA",
"LIMBU LETTER BA",
"LIMBU LETTER BHA",
"LIMBU LETTER MA",
"LIMBU LETTER YA",
"LIMBU LETTER RA",
"LIMBU LETTER LA",
"LIMBU LETTER WA",
"LIMBU LETTER SHA",
"LIMBU LETTER SSA",
"LIMBU LETTER SA",
"LIMBU LETTER HA",
name_reserved,
name_reserved,
name_reserved,
"LIMBU VOWEL SIGN A",
"LIMBU VOWEL SIGN I",
"LIMBU VOWEL SIGN U",
"LIMBU VOWEL SIGN EE",
"LIMBU VOWEL SIGN AI",
"LIMBU VOWEL SIGN OO",
"LIMBU VOWEL SIGN AU",
"LIMBU VOWEL SIGN E",
"LIMBU VOWEL SIGN O",
"LIMBU SUBJOINED LETTER YA",
"LIMBU SUBJOINED LETTER RA",
"LIMBU SUBJOINED LETTER WA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"LIMBU SMALL LETTER KA",
"LIMBU SMALL LETTER NGA",
"LIMBU SMALL LETTER ANUSVARA",
"LIMBU SMALL LETTER TA",
"LIMBU SMALL LETTER NA",
"LIMBU SMALL LETTER PA",
"LIMBU SMALL LETTER MA",
"LIMBU SMALL LETTER RA",
"LIMBU SMALL LETTER LA",
"LIMBU SIGN MUKPHRENG",
"LIMBU SIGN KEMPHRENG",
"LIMBU SIGN SA-I",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"LIMBU SIGN LOO",
name_reserved,
name_reserved,
name_reserved,
"LIMBU EXCLAMATION MARK",
"LIMBU QUESTION MARK",
"LIMBU DIGIT ZERO",
"LIMBU DIGIT ONE",
"LIMBU DIGIT TWO",
"LIMBU DIGIT THREE",
"LIMBU DIGIT FOUR",
"LIMBU DIGIT FIVE",
"LIMBU DIGIT SIX",
"LIMBU DIGIT SEVEN",
"LIMBU DIGIT EIGHT",
"LIMBU DIGIT NINE",
"TAI LE LETTER KA",
"TAI LE LETTER XA",
"TAI LE LETTER NGA",
"TAI LE LETTER TSA",
"TAI LE LETTER SA",
"TAI LE LETTER YA",
"TAI LE LETTER TA",
"TAI LE LETTER THA",
"TAI LE LETTER LA",
"TAI LE LETTER PA",
"TAI LE LETTER PHA",
"TAI LE LETTER MA",
"TAI LE LETTER FA",
"TAI LE LETTER VA",
"TAI LE LETTER HA",
"TAI LE LETTER QA",
"TAI LE LETTER KHA",
"TAI LE LETTER TSHA",
"TAI LE LETTER NA",
"TAI LE LETTER A",
"TAI LE LETTER I",
"TAI LE LETTER EE",
"TAI LE LETTER EH",
"TAI LE LETTER U",
"TAI LE LETTER OO",
"TAI LE LETTER O",
"TAI LE LETTER UE",
"TAI LE LETTER E",
"TAI LE LETTER AUE",
"TAI LE LETTER AI",
name_reserved,
name_reserved,
"TAI LE LETTER TONE-2",
"TAI LE LETTER TONE-3",
"TAI LE LETTER TONE-4",
"TAI LE LETTER TONE-5",
"TAI LE LETTER TONE-6",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"NEW TAI LUE LETTER HIGH QA",
"NEW TAI LUE LETTER LOW QA",
"NEW TAI LUE LETTER HIGH KA",
"NEW TAI LUE LETTER HIGH XA",
"NEW TAI LUE LETTER HIGH NGA",
"NEW TAI LUE LETTER LOW KA",
"NEW TAI LUE LETTER LOW XA",
"NEW TAI LUE LETTER LOW NGA",
"NEW TAI LUE LETTER HIGH TSA",
"NEW TAI LUE LETTER HIGH SA",
"NEW TAI LUE LETTER HIGH YA",
"NEW TAI LUE LETTER LOW TSA",
"NEW TAI LUE LETTER LOW SA",
"NEW TAI LUE LETTER LOW YA",
"NEW TAI LUE LETTER HIGH TA",
"NEW TAI LUE LETTER HIGH THA",
"NEW TAI LUE LETTER HIGH NA",
"NEW TAI LUE LETTER LOW TA",
"NEW TAI LUE LETTER LOW THA",
"NEW TAI LUE LETTER LOW NA",
"NEW TAI LUE LETTER HIGH PA",
"NEW TAI LUE LETTER HIGH PHA",
"NEW TAI LUE LETTER HIGH MA",
"NEW TAI LUE LETTER LOW PA",
"NEW TAI LUE LETTER LOW PHA",
"NEW TAI LUE LETTER LOW MA",
"NEW TAI LUE LETTER HIGH FA",
"NEW TAI LUE LETTER HIGH VA",
"NEW TAI LUE LETTER HIGH LA",
"NEW TAI LUE LETTER LOW FA",
"NEW TAI LUE LETTER LOW VA",
"NEW TAI LUE LETTER LOW LA",
"NEW TAI LUE LETTER HIGH HA",
"NEW TAI LUE LETTER HIGH DA",
"NEW TAI LUE LETTER HIGH BA",
"NEW TAI LUE LETTER LOW HA",
"NEW TAI LUE LETTER LOW DA",
"NEW TAI LUE LETTER LOW BA",
"NEW TAI LUE LETTER HIGH KVA",
"NEW TAI LUE LETTER HIGH XVA",
"NEW TAI LUE LETTER LOW KVA",
"NEW TAI LUE LETTER LOW XVA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"NEW TAI LUE VOWEL SIGN VOWEL SHORTENER",
"NEW TAI LUE VOWEL SIGN AA",
"NEW TAI LUE VOWEL SIGN II",
"NEW TAI LUE VOWEL SIGN U",
"NEW TAI LUE VOWEL SIGN UU",
"NEW TAI LUE VOWEL SIGN E",
"NEW TAI LUE VOWEL SIGN AE",
"NEW TAI LUE VOWEL SIGN O",
"NEW TAI LUE VOWEL SIGN OA",
"NEW TAI LUE VOWEL SIGN UE",
"NEW TAI LUE VOWEL SIGN AY",
"NEW TAI LUE VOWEL SIGN AAY",
"NEW TAI LUE VOWEL SIGN UY",
"NEW TAI LUE VOWEL SIGN OY",
"NEW TAI LUE VOWEL SIGN OAY",
"NEW TAI LUE VOWEL SIGN UEY",
"NEW TAI LUE VOWEL SIGN IY",
"NEW TAI LUE LETTER FINAL V",
"NEW TAI LUE LETTER FINAL NG",
"NEW TAI LUE LETTER FINAL N",
"NEW TAI LUE LETTER FINAL M",
"NEW TAI LUE LETTER FINAL K",
"NEW TAI LUE LETTER FINAL D",
"NEW TAI LUE LETTER FINAL B",
"NEW TAI LUE TONE MARK-1",
"NEW TAI LUE TONE MARK-2",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"NEW TAI LUE DIGIT ZERO",
"NEW TAI LUE DIGIT ONE",
"NEW TAI LUE DIGIT TWO",
"NEW TAI LUE DIGIT THREE",
"NEW TAI LUE DIGIT FOUR",
"NEW TAI LUE DIGIT FIVE",
"NEW TAI LUE DIGIT SIX",
"NEW TAI LUE DIGIT SEVEN",
"NEW TAI LUE DIGIT EIGHT",
"NEW TAI LUE DIGIT NINE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"NEW TAI LUE SIGN LAE",
"NEW TAI LUE SIGN LAEV",
"KHMER SYMBOL PATHAMASAT",
"KHMER SYMBOL MUOY KOET",
"KHMER SYMBOL PII KOET",
"KHMER SYMBOL BEI KOET",
"KHMER SYMBOL BUON KOET",
"KHMER SYMBOL PRAM KOET",
"KHMER SYMBOL PRAM-MUOY KOET",
"KHMER SYMBOL PRAM-PII KOET",
"KHMER SYMBOL PRAM-BEI KOET",
"KHMER SYMBOL PRAM-BUON KOET",
"KHMER SYMBOL DAP KOET",
"KHMER SYMBOL DAP-MUOY KOET",
"KHMER SYMBOL DAP-PII KOET",
"KHMER SYMBOL DAP-BEI KOET",
"KHMER SYMBOL DAP-BUON KOET",
"KHMER SYMBOL DAP-PRAM KOET",
"KHMER SYMBOL TUTEYASAT",
"KHMER SYMBOL MUOY ROC",
"KHMER SYMBOL PII ROC",
"KHMER SYMBOL BEI ROC",
"KHMER SYMBOL BUON ROC",
"KHMER SYMBOL PRAM ROC",
"KHMER SYMBOL PRAM-MUOY ROC",
"KHMER SYMBOL PRAM-PII ROC",
"KHMER SYMBOL PRAM-BEI ROC",
"KHMER SYMBOL PRAM-BUON ROC",
"KHMER SYMBOL DAP ROC",
"KHMER SYMBOL DAP-MUOY ROC",
"KHMER SYMBOL DAP-PII ROC",
"KHMER SYMBOL DAP-BEI ROC",
"KHMER SYMBOL DAP-BUON ROC",
"KHMER SYMBOL DAP-PRAM ROC"};
static const char * name_001a[256] =
{
"BUGINESE LETTER KA",
"BUGINESE LETTER GA",
"BUGINESE LETTER NGA",
"BUGINESE LETTER NGKA",
"BUGINESE LETTER PA",
"BUGINESE LETTER BA",
"BUGINESE LETTER MA",
"BUGINESE LETTER MPA",
"BUGINESE LETTER TA",
"BUGINESE LETTER DA",
"BUGINESE LETTER NA",
"BUGINESE LETTER NRA",
"BUGINESE LETTER CA",
"BUGINESE LETTER JA",
"BUGINESE LETTER NYA",
"BUGINESE LETTER NYCA",
"BUGINESE LETTER YA",
"BUGINESE LETTER RA",
"BUGINESE LETTER LA",
"BUGINESE LETTER VA",
"BUGINESE LETTER SA",
"BUGINESE LETTER A",
"BUGINESE LETTER HA",
"BUGINESE VOWEL SIGN I",
"BUGINESE VOWEL SIGN U",
"BUGINESE VOWEL SIGN E",
"BUGINESE VOWEL SIGN O",
"BUGINESE VOWEL SIGN AE",
name_reserved,
name_reserved,
"BUGINESE PALLAWA",
"BUGINESE END OF SECTION",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_001d[256] =
{
"LATIN LETTER SMALL CAPITAL A",
"LATIN LETTER SMALL CAPITAL AE",
"LATIN SMALL LETTER TURNED AE",
"LATIN LETTER SMALL CAPITAL BARRED B",
"LATIN LETTER SMALL CAPITAL C",
"LATIN LETTER SMALL CAPITAL D",
"LATIN LETTER SMALL CAPITAL ETH",
"LATIN LETTER SMALL CAPITAL E",
"LATIN SMALL LETTER TURNED OPEN E",
"LATIN SMALL LETTER TURNED I",
"LATIN LETTER SMALL CAPITAL J",
"LATIN LETTER SMALL CAPITAL K",
"LATIN LETTER SMALL CAPITAL L WITH STROKE",
"LATIN LETTER SMALL CAPITAL M",
"LATIN LETTER SMALL CAPITAL REVERSED N",
"LATIN LETTER SMALL CAPITAL O",
"LATIN LETTER SMALL CAPITAL OPEN O",
"LATIN SMALL LETTER SIDEWAYS O",
"LATIN SMALL LETTER SIDEWAYS OPEN O",
"LATIN SMALL LETTER SIDEWAYS O WITH STROKE",
"LATIN SMALL LETTER TURNED OE",
"LATIN LETTER SMALL CAPITAL OU",
"LATIN SMALL LETTER TOP HALF O",
"LATIN SMALL LETTER BOTTOM HALF O",
"LATIN LETTER SMALL CAPITAL P",
"LATIN LETTER SMALL CAPITAL REVERSED R",
"LATIN LETTER SMALL CAPITAL TURNED R",
"LATIN LETTER SMALL CAPITAL T",
"LATIN LETTER SMALL CAPITAL U",
"LATIN SMALL LETTER SIDEWAYS U",
"LATIN SMALL LETTER SIDEWAYS DIAERESIZED U",
"LATIN SMALL LETTER SIDEWAYS TURNED M",
"LATIN LETTER SMALL CAPITAL V",
"LATIN LETTER SMALL CAPITAL W",
"LATIN LETTER SMALL CAPITAL Z",
"LATIN LETTER SMALL CAPITAL EZH",
"LATIN LETTER VOICED LARYNGEAL SPIRANT",
"LATIN LETTER AIN",
"GREEK LETTER SMALL CAPITAL GAMMA",
"GREEK LETTER SMALL CAPITAL LAMDA",
"GREEK LETTER SMALL CAPITAL PI",
"GREEK LETTER SMALL CAPITAL RHO",
"GREEK LETTER SMALL CAPITAL PSI",
"CYRILLIC LETTER SMALL CAPITAL EL",
"MODIFIER LETTER CAPITAL A",
"MODIFIER LETTER CAPITAL AE",
"MODIFIER LETTER CAPITAL B",
"MODIFIER LETTER CAPITAL BARRED B",
"MODIFIER LETTER CAPITAL D",
"MODIFIER LETTER CAPITAL E",
"MODIFIER LETTER CAPITAL REVERSED E",
"MODIFIER LETTER CAPITAL G",
"MODIFIER LETTER CAPITAL H",
"MODIFIER LETTER CAPITAL I",
"MODIFIER LETTER CAPITAL J",
"MODIFIER LETTER CAPITAL K",
"MODIFIER LETTER CAPITAL L",
"MODIFIER LETTER CAPITAL M",
"MODIFIER LETTER CAPITAL N",
"MODIFIER LETTER CAPITAL REVERSED N",
"MODIFIER LETTER CAPITAL O",
"MODIFIER LETTER CAPITAL OU",
"MODIFIER LETTER CAPITAL P",
"MODIFIER LETTER CAPITAL R",
"MODIFIER LETTER CAPITAL T",
"MODIFIER LETTER CAPITAL U",
"MODIFIER LETTER CAPITAL W",
"MODIFIER LETTER SMALL A",
"MODIFIER LETTER SMALL TURNED A",
"MODIFIER LETTER SMALL ALPHA",
"MODIFIER LETTER SMALL TURNED AE",
"MODIFIER LETTER SMALL B",
"MODIFIER LETTER SMALL D",
"MODIFIER LETTER SMALL E",
"MODIFIER LETTER SMALL SCHWA",
"MODIFIER LETTER SMALL OPEN E",
"MODIFIER LETTER SMALL TURNED OPEN E",
"MODIFIER LETTER SMALL G",
"MODIFIER LETTER SMALL TURNED I",
"MODIFIER LETTER SMALL K",
"MODIFIER LETTER SMALL M",
"MODIFIER LETTER SMALL ENG",
"MODIFIER LETTER SMALL O",
"MODIFIER LETTER SMALL OPEN O",
"MODIFIER LETTER SMALL TOP HALF O",
"MODIFIER LETTER SMALL BOTTOM HALF O",
"MODIFIER LETTER SMALL P",
"MODIFIER LETTER SMALL T",
"MODIFIER LETTER SMALL U",
"MODIFIER LETTER SMALL SIDEWAYS U",
"MODIFIER LETTER SMALL TURNED M",
"MODIFIER LETTER SMALL V",
"MODIFIER LETTER SMALL AIN",
"MODIFIER LETTER SMALL BETA",
"MODIFIER LETTER SMALL GREEK GAMMA",
"MODIFIER LETTER SMALL DELTA",
"MODIFIER LETTER SMALL GREEK PHI",
"MODIFIER LETTER SMALL CHI",
"LATIN SUBSCRIPT SMALL LETTER I",
"LATIN SUBSCRIPT SMALL LETTER R",
"LATIN SUBSCRIPT SMALL LETTER U",
"LATIN SUBSCRIPT SMALL LETTER V",
"GREEK SUBSCRIPT SMALL LETTER BETA",
"GREEK SUBSCRIPT SMALL LETTER GAMMA",
"GREEK SUBSCRIPT SMALL LETTER RHO",
"GREEK SUBSCRIPT SMALL LETTER PHI",
"GREEK SUBSCRIPT SMALL LETTER CHI",
"LATIN SMALL LETTER UE",
"LATIN SMALL LETTER B WITH MIDDLE TILDE",
"LATIN SMALL LETTER D WITH MIDDLE TILDE",
"LATIN SMALL LETTER F WITH MIDDLE TILDE",
"LATIN SMALL LETTER M WITH MIDDLE TILDE",
"LATIN SMALL LETTER N WITH MIDDLE TILDE",
"LATIN SMALL LETTER P WITH MIDDLE TILDE",
"LATIN SMALL LETTER R WITH MIDDLE TILDE",
"LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE",
"LATIN SMALL LETTER S WITH MIDDLE TILDE",
"LATIN SMALL LETTER T WITH MIDDLE TILDE",
"LATIN SMALL LETTER Z WITH MIDDLE TILDE",
"LATIN SMALL LETTER TURNED G",
"MODIFIER LETTER CYRILLIC EN",
"LATIN SMALL LETTER INSULAR G",
"LATIN SMALL LETTER TH WITH STRIKETHROUGH",
"LATIN SMALL CAPITAL LETTER I WITH STROKE",
"LATIN SMALL LETTER IOTA WITH STROKE",
"LATIN SMALL LETTER P WITH STROKE",
"LATIN SMALL CAPITAL LETTER U WITH STROKE",
"LATIN SMALL LETTER UPSILON WITH STROKE",
"LATIN SMALL LETTER B WITH PALATAL HOOK",
"LATIN SMALL LETTER D WITH PALATAL HOOK",
"LATIN SMALL LETTER F WITH PALATAL HOOK",
"LATIN SMALL LETTER G WITH PALATAL HOOK",
"LATIN SMALL LETTER K WITH PALATAL HOOK",
"LATIN SMALL LETTER L WITH PALATAL HOOK",
"LATIN SMALL LETTER M WITH PALATAL HOOK",
"LATIN SMALL LETTER N WITH PALATAL HOOK",
"LATIN SMALL LETTER P WITH PALATAL HOOK",
"LATIN SMALL LETTER R WITH PALATAL HOOK",
"LATIN SMALL LETTER S WITH PALATAL HOOK",
"LATIN SMALL LETTER ESH WITH PALATAL HOOK",
"LATIN SMALL LETTER V WITH PALATAL HOOK",
"LATIN SMALL LETTER X WITH PALATAL HOOK",
"LATIN SMALL LETTER Z WITH PALATAL HOOK",
"LATIN SMALL LETTER A WITH RETROFLEX HOOK",
"LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK",
"LATIN SMALL LETTER D WITH HOOK AND TAIL",
"LATIN SMALL LETTER E WITH RETROFLEX HOOK",
"LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK",
"LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK",
"LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK",
"LATIN SMALL LETTER I WITH RETROFLEX HOOK",
"LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK",
"LATIN SMALL LETTER ESH WITH RETROFLEX HOOK",
"LATIN SMALL LETTER U WITH RETROFLEX HOOK",
"LATIN SMALL LETTER EZH WITH RETROFLEX HOOK",
"MODIFIER LETTER SMALL TURNED ALPHA",
"MODIFIER LETTER SMALL C",
"MODIFIER LETTER SMALL C WITH CURL",
"MODIFIER LETTER SMALL ETH",
"MODIFIER LETTER SMALL REVERSED OPEN E",
"MODIFIER LETTER SMALL F",
"MODIFIER LETTER SMALL DOTLESS J WITH STROKE",
"MODIFIER LETTER SMALL SCRIPT G",
"MODIFIER LETTER SMALL TURNED H",
"MODIFIER LETTER SMALL I WITH STROKE",
"MODIFIER LETTER SMALL IOTA",
"MODIFIER LETTER SMALL CAPITAL I",
"MODIFIER LETTER SMALL CAPITAL I WITH STROKE",
"MODIFIER LETTER SMALL J WITH CROSSED-TAIL",
"MODIFIER LETTER SMALL L WITH RETROFLEX HOOK",
"MODIFIER LETTER SMALL L WITH PALATAL HOOK",
"MODIFIER LETTER SMALL CAPITAL L",
"MODIFIER LETTER SMALL M WITH HOOK",
"MODIFIER LETTER SMALL TURNED M WITH LONG LEG",
"MODIFIER LETTER SMALL N WITH LEFT HOOK",
"MODIFIER LETTER SMALL N WITH RETROFLEX HOOK",
"MODIFIER LETTER SMALL CAPITAL N",
"MODIFIER LETTER SMALL BARRED O",
"MODIFIER LETTER SMALL PHI",
"MODIFIER LETTER SMALL S WITH HOOK",
"MODIFIER LETTER SMALL ESH",
"MODIFIER LETTER SMALL T WITH PALATAL HOOK",
"MODIFIER LETTER SMALL U BAR",
"MODIFIER LETTER SMALL UPSILON",
"MODIFIER LETTER SMALL CAPITAL U",
"MODIFIER LETTER SMALL V WITH HOOK",
"MODIFIER LETTER SMALL TURNED V",
"MODIFIER LETTER SMALL Z",
"MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK",
"MODIFIER LETTER SMALL Z WITH CURL",
"MODIFIER LETTER SMALL EZH",
"MODIFIER LETTER SMALL THETA",
"COMBINING DOTTED GRAVE ACCENT",
"COMBINING DOTTED ACUTE ACCENT",
"COMBINING SNAKE BELOW",
"COMBINING SUSPENSION MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_001e[256] =
{
"LATIN CAPITAL LETTER A WITH RING BELOW",
"LATIN SMALL LETTER A WITH RING BELOW",
"LATIN CAPITAL LETTER B WITH DOT ABOVE",
"LATIN SMALL LETTER B WITH DOT ABOVE",
"LATIN CAPITAL LETTER B WITH DOT BELOW",
"LATIN SMALL LETTER B WITH DOT BELOW",
"LATIN CAPITAL LETTER B WITH LINE BELOW",
"LATIN SMALL LETTER B WITH LINE BELOW",
"LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE",
"LATIN SMALL LETTER C WITH CEDILLA AND ACUTE",
"LATIN CAPITAL LETTER D WITH DOT ABOVE",
"LATIN SMALL LETTER D WITH DOT ABOVE",
"LATIN CAPITAL LETTER D WITH DOT BELOW",
"LATIN SMALL LETTER D WITH DOT BELOW",
"LATIN CAPITAL LETTER D WITH LINE BELOW",
"LATIN SMALL LETTER D WITH LINE BELOW",
"LATIN CAPITAL LETTER D WITH CEDILLA",
"LATIN SMALL LETTER D WITH CEDILLA",
"LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW",
"LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW",
"LATIN CAPITAL LETTER E WITH MACRON AND GRAVE",
"LATIN SMALL LETTER E WITH MACRON AND GRAVE",
"LATIN CAPITAL LETTER E WITH MACRON AND ACUTE",
"LATIN SMALL LETTER E WITH MACRON AND ACUTE",
"LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW",
"LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW",
"LATIN CAPITAL LETTER E WITH TILDE BELOW",
"LATIN SMALL LETTER E WITH TILDE BELOW",
"LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE",
"LATIN SMALL LETTER E WITH CEDILLA AND BREVE",
"LATIN CAPITAL LETTER F WITH DOT ABOVE",
"LATIN SMALL LETTER F WITH DOT ABOVE",
"LATIN CAPITAL LETTER G WITH MACRON",
"LATIN SMALL LETTER G WITH MACRON",
"LATIN CAPITAL LETTER H WITH DOT ABOVE",
"LATIN SMALL LETTER H WITH DOT ABOVE",
"LATIN CAPITAL LETTER H WITH DOT BELOW",
"LATIN SMALL LETTER H WITH DOT BELOW",
"LATIN CAPITAL LETTER H WITH DIAERESIS",
"LATIN SMALL LETTER H WITH DIAERESIS",
"LATIN CAPITAL LETTER H WITH CEDILLA",
"LATIN SMALL LETTER H WITH CEDILLA",
"LATIN CAPITAL LETTER H WITH BREVE BELOW",
"LATIN SMALL LETTER H WITH BREVE BELOW",
"LATIN CAPITAL LETTER I WITH TILDE BELOW",
"LATIN SMALL LETTER I WITH TILDE BELOW",
"LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE",
"LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE",
"LATIN CAPITAL LETTER K WITH ACUTE",
"LATIN SMALL LETTER K WITH ACUTE",
"LATIN CAPITAL LETTER K WITH DOT BELOW",
"LATIN SMALL LETTER K WITH DOT BELOW",
"LATIN CAPITAL LETTER K WITH LINE BELOW",
"LATIN SMALL LETTER K WITH LINE BELOW",
"LATIN CAPITAL LETTER L WITH DOT BELOW",
"LATIN SMALL LETTER L WITH DOT BELOW",
"LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON",
"LATIN SMALL LETTER L WITH DOT BELOW AND MACRON",
"LATIN CAPITAL LETTER L WITH LINE BELOW",
"LATIN SMALL LETTER L WITH LINE BELOW",
"LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW",
"LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW",
"LATIN CAPITAL LETTER M WITH ACUTE",
"LATIN SMALL LETTER M WITH ACUTE",
"LATIN CAPITAL LETTER M WITH DOT ABOVE",
"LATIN SMALL LETTER M WITH DOT ABOVE",
"LATIN CAPITAL LETTER M WITH DOT BELOW",
"LATIN SMALL LETTER M WITH DOT BELOW",
"LATIN CAPITAL LETTER N WITH DOT ABOVE",
"LATIN SMALL LETTER N WITH DOT ABOVE",
"LATIN CAPITAL LETTER N WITH DOT BELOW",
"LATIN SMALL LETTER N WITH DOT BELOW",
"LATIN CAPITAL LETTER N WITH LINE BELOW",
"LATIN SMALL LETTER N WITH LINE BELOW",
"LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW",
"LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW",
"LATIN CAPITAL LETTER O WITH TILDE AND ACUTE",
"LATIN SMALL LETTER O WITH TILDE AND ACUTE",
"LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS",
"LATIN SMALL LETTER O WITH TILDE AND DIAERESIS",
"LATIN CAPITAL LETTER O WITH MACRON AND GRAVE",
"LATIN SMALL LETTER O WITH MACRON AND GRAVE",
"LATIN CAPITAL LETTER O WITH MACRON AND ACUTE",
"LATIN SMALL LETTER O WITH MACRON AND ACUTE",
"LATIN CAPITAL LETTER P WITH ACUTE",
"LATIN SMALL LETTER P WITH ACUTE",
"LATIN CAPITAL LETTER P WITH DOT ABOVE",
"LATIN SMALL LETTER P WITH DOT ABOVE",
"LATIN CAPITAL LETTER R WITH DOT ABOVE",
"LATIN SMALL LETTER R WITH DOT ABOVE",
"LATIN CAPITAL LETTER R WITH DOT BELOW",
"LATIN SMALL LETTER R WITH DOT BELOW",
"LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON",
"LATIN SMALL LETTER R WITH DOT BELOW AND MACRON",
"LATIN CAPITAL LETTER R WITH LINE BELOW",
"LATIN SMALL LETTER R WITH LINE BELOW",
"LATIN CAPITAL LETTER S WITH DOT ABOVE",
"LATIN SMALL LETTER S WITH DOT ABOVE",
"LATIN CAPITAL LETTER S WITH DOT BELOW",
"LATIN SMALL LETTER S WITH DOT BELOW",
"LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE",
"LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE",
"LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE",
"LATIN SMALL LETTER S WITH CARON AND DOT ABOVE",
"LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE",
"LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE",
"LATIN CAPITAL LETTER T WITH DOT ABOVE",
"LATIN SMALL LETTER T WITH DOT ABOVE",
"LATIN CAPITAL LETTER T WITH DOT BELOW",
"LATIN SMALL LETTER T WITH DOT BELOW",
"LATIN CAPITAL LETTER T WITH LINE BELOW",
"LATIN SMALL LETTER T WITH LINE BELOW",
"LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW",
"LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW",
"LATIN CAPITAL LETTER U WITH DIAERESIS BELOW",
"LATIN SMALL LETTER U WITH DIAERESIS BELOW",
"LATIN CAPITAL LETTER U WITH TILDE BELOW",
"LATIN SMALL LETTER U WITH TILDE BELOW",
"LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW",
"LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW",
"LATIN CAPITAL LETTER U WITH TILDE AND ACUTE",
"LATIN SMALL LETTER U WITH TILDE AND ACUTE",
"LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS",
"LATIN SMALL LETTER U WITH MACRON AND DIAERESIS",
"LATIN CAPITAL LETTER V WITH TILDE",
"LATIN SMALL LETTER V WITH TILDE",
"LATIN CAPITAL LETTER V WITH DOT BELOW",
"LATIN SMALL LETTER V WITH DOT BELOW",
"LATIN CAPITAL LETTER W WITH GRAVE",
"LATIN SMALL LETTER W WITH GRAVE",
"LATIN CAPITAL LETTER W WITH ACUTE",
"LATIN SMALL LETTER W WITH ACUTE",
"LATIN CAPITAL LETTER W WITH DIAERESIS",
"LATIN SMALL LETTER W WITH DIAERESIS",
"LATIN CAPITAL LETTER W WITH DOT ABOVE",
"LATIN SMALL LETTER W WITH DOT ABOVE",
"LATIN CAPITAL LETTER W WITH DOT BELOW",
"LATIN SMALL LETTER W WITH DOT BELOW",
"LATIN CAPITAL LETTER X WITH DOT ABOVE",
"LATIN SMALL LETTER X WITH DOT ABOVE",
"LATIN CAPITAL LETTER X WITH DIAERESIS",
"LATIN SMALL LETTER X WITH DIAERESIS",
"LATIN CAPITAL LETTER Y WITH DOT ABOVE",
"LATIN SMALL LETTER Y WITH DOT ABOVE",
"LATIN CAPITAL LETTER Z WITH CIRCUMFLEX",
"LATIN SMALL LETTER Z WITH CIRCUMFLEX",
"LATIN CAPITAL LETTER Z WITH DOT BELOW",
"LATIN SMALL LETTER Z WITH DOT BELOW",
"LATIN CAPITAL LETTER Z WITH LINE BELOW",
"LATIN SMALL LETTER Z WITH LINE BELOW",
"LATIN SMALL LETTER H WITH LINE BELOW",
"LATIN SMALL LETTER T WITH DIAERESIS",
"LATIN SMALL LETTER W WITH RING ABOVE",
"LATIN SMALL LETTER Y WITH RING ABOVE",
"LATIN SMALL LETTER A WITH RIGHT HALF RING",
"LATIN SMALL LETTER LONG S WITH DOT ABOVE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"LATIN CAPITAL LETTER A WITH DOT BELOW",
"LATIN SMALL LETTER A WITH DOT BELOW",
"LATIN CAPITAL LETTER A WITH HOOK ABOVE",
"LATIN SMALL LETTER A WITH HOOK ABOVE",
"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE",
"LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE",
"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE",
"LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE",
"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE",
"LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE",
"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE",
"LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE",
"LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW",
"LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW",
"LATIN CAPITAL LETTER A WITH BREVE AND ACUTE",
"LATIN SMALL LETTER A WITH BREVE AND ACUTE",
"LATIN CAPITAL LETTER A WITH BREVE AND GRAVE",
"LATIN SMALL LETTER A WITH BREVE AND GRAVE",
"LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE",
"LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE",
"LATIN CAPITAL LETTER A WITH BREVE AND TILDE",
"LATIN SMALL LETTER A WITH BREVE AND TILDE",
"LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW",
"LATIN SMALL LETTER A WITH BREVE AND DOT BELOW",
"LATIN CAPITAL LETTER E WITH DOT BELOW",
"LATIN SMALL LETTER E WITH DOT BELOW",
"LATIN CAPITAL LETTER E WITH HOOK ABOVE",
"LATIN SMALL LETTER E WITH HOOK ABOVE",
"LATIN CAPITAL LETTER E WITH TILDE",
"LATIN SMALL LETTER E WITH TILDE",
"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE",
"LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE",
"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE",
"LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE",
"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE",
"LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE",
"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE",
"LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE",
"LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW",
"LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW",
"LATIN CAPITAL LETTER I WITH HOOK ABOVE",
"LATIN SMALL LETTER I WITH HOOK ABOVE",
"LATIN CAPITAL LETTER I WITH DOT BELOW",
"LATIN SMALL LETTER I WITH DOT BELOW",
"LATIN CAPITAL LETTER O WITH DOT BELOW",
"LATIN SMALL LETTER O WITH DOT BELOW",
"LATIN CAPITAL LETTER O WITH HOOK ABOVE",
"LATIN SMALL LETTER O WITH HOOK ABOVE",
"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE",
"LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE",
"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE",
"LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE",
"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE",
"LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE",
"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE",
"LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE",
"LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW",
"LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW",
"LATIN CAPITAL LETTER O WITH HORN AND ACUTE",
"LATIN SMALL LETTER O WITH HORN AND ACUTE",
"LATIN CAPITAL LETTER O WITH HORN AND GRAVE",
"LATIN SMALL LETTER O WITH HORN AND GRAVE",
"LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE",
"LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE",
"LATIN CAPITAL LETTER O WITH HORN AND TILDE",
"LATIN SMALL LETTER O WITH HORN AND TILDE",
"LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW",
"LATIN SMALL LETTER O WITH HORN AND DOT BELOW",
"LATIN CAPITAL LETTER U WITH DOT BELOW",
"LATIN SMALL LETTER U WITH DOT BELOW",
"LATIN CAPITAL LETTER U WITH HOOK ABOVE",
"LATIN SMALL LETTER U WITH HOOK ABOVE",
"LATIN CAPITAL LETTER U WITH HORN AND ACUTE",
"LATIN SMALL LETTER U WITH HORN AND ACUTE",
"LATIN CAPITAL LETTER U WITH HORN AND GRAVE",
"LATIN SMALL LETTER U WITH HORN AND GRAVE",
"LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE",
"LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE",
"LATIN CAPITAL LETTER U WITH HORN AND TILDE",
"LATIN SMALL LETTER U WITH HORN AND TILDE",
"LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW",
"LATIN SMALL LETTER U WITH HORN AND DOT BELOW",
"LATIN CAPITAL LETTER Y WITH GRAVE",
"LATIN SMALL LETTER Y WITH GRAVE",
"LATIN CAPITAL LETTER Y WITH DOT BELOW",
"LATIN SMALL LETTER Y WITH DOT BELOW",
"LATIN CAPITAL LETTER Y WITH HOOK ABOVE",
"LATIN SMALL LETTER Y WITH HOOK ABOVE",
"LATIN CAPITAL LETTER Y WITH TILDE",
"LATIN SMALL LETTER Y WITH TILDE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_001f[256] =
{
"GREEK SMALL LETTER ALPHA WITH PSILI",
"GREEK SMALL LETTER ALPHA WITH DASIA",
"GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA",
"GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA",
"GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA",
"GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA",
"GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI",
"GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI",
"GREEK CAPITAL LETTER ALPHA WITH PSILI",
"GREEK CAPITAL LETTER ALPHA WITH DASIA",
"GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA",
"GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA",
"GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA",
"GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA",
"GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI",
"GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI",
"GREEK SMALL LETTER EPSILON WITH PSILI",
"GREEK SMALL LETTER EPSILON WITH DASIA",
"GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA",
"GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA",
"GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA",
"GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA",
name_reserved,
name_reserved,
"GREEK CAPITAL LETTER EPSILON WITH PSILI",
"GREEK CAPITAL LETTER EPSILON WITH DASIA",
"GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA",
"GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA",
"GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA",
"GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA",
name_reserved,
name_reserved,
"GREEK SMALL LETTER ETA WITH PSILI",
"GREEK SMALL LETTER ETA WITH DASIA",
"GREEK SMALL LETTER ETA WITH PSILI AND VARIA",
"GREEK SMALL LETTER ETA WITH DASIA AND VARIA",
"GREEK SMALL LETTER ETA WITH PSILI AND OXIA",
"GREEK SMALL LETTER ETA WITH DASIA AND OXIA",
"GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI",
"GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI",
"GREEK CAPITAL LETTER ETA WITH PSILI",
"GREEK CAPITAL LETTER ETA WITH DASIA",
"GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA",
"GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA",
"GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA",
"GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA",
"GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI",
"GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI",
"GREEK SMALL LETTER IOTA WITH PSILI",
"GREEK SMALL LETTER IOTA WITH DASIA",
"GREEK SMALL LETTER IOTA WITH PSILI AND VARIA",
"GREEK SMALL LETTER IOTA WITH DASIA AND VARIA",
"GREEK SMALL LETTER IOTA WITH PSILI AND OXIA",
"GREEK SMALL LETTER IOTA WITH DASIA AND OXIA",
"GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI",
"GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI",
"GREEK CAPITAL LETTER IOTA WITH PSILI",
"GREEK CAPITAL LETTER IOTA WITH DASIA",
"GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA",
"GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA",
"GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA",
"GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA",
"GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI",
"GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI",
"GREEK SMALL LETTER OMICRON WITH PSILI",
"GREEK SMALL LETTER OMICRON WITH DASIA",
"GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA",
"GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA",
"GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA",
"GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA",
name_reserved,
name_reserved,
"GREEK CAPITAL LETTER OMICRON WITH PSILI",
"GREEK CAPITAL LETTER OMICRON WITH DASIA",
"GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA",
"GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA",
"GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA",
"GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA",
name_reserved,
name_reserved,
"GREEK SMALL LETTER UPSILON WITH PSILI",
"GREEK SMALL LETTER UPSILON WITH DASIA",
"GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA",
"GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA",
"GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA",
"GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA",
"GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI",
"GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI",
name_reserved,
"GREEK CAPITAL LETTER UPSILON WITH DASIA",
name_reserved,
"GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA",
name_reserved,
"GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA",
name_reserved,
"GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI",
"GREEK SMALL LETTER OMEGA WITH PSILI",
"GREEK SMALL LETTER OMEGA WITH DASIA",
"GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA",
"GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA",
"GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA",
"GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA",
"GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI",
"GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI",
"GREEK CAPITAL LETTER OMEGA WITH PSILI",
"GREEK CAPITAL LETTER OMEGA WITH DASIA",
"GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA",
"GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA",
"GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA",
"GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA",
"GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI",
"GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI",
"GREEK SMALL LETTER ALPHA WITH VARIA",
"GREEK SMALL LETTER ALPHA WITH OXIA",
"GREEK SMALL LETTER EPSILON WITH VARIA",
"GREEK SMALL LETTER EPSILON WITH OXIA",
"GREEK SMALL LETTER ETA WITH VARIA",
"GREEK SMALL LETTER ETA WITH OXIA",
"GREEK SMALL LETTER IOTA WITH VARIA",
"GREEK SMALL LETTER IOTA WITH OXIA",
"GREEK SMALL LETTER OMICRON WITH VARIA",
"GREEK SMALL LETTER OMICRON WITH OXIA",
"GREEK SMALL LETTER UPSILON WITH VARIA",
"GREEK SMALL LETTER UPSILON WITH OXIA",
"GREEK SMALL LETTER OMEGA WITH VARIA",
"GREEK SMALL LETTER OMEGA WITH OXIA",
name_reserved,
name_reserved,
"GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
"GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
"GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
"GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
"GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH VRACHY",
"GREEK SMALL LETTER ALPHA WITH MACRON",
"GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI",
"GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI",
name_reserved,
"GREEK SMALL LETTER ALPHA WITH PERISPOMENI",
"GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI",
"GREEK CAPITAL LETTER ALPHA WITH VRACHY",
"GREEK CAPITAL LETTER ALPHA WITH MACRON",
"GREEK CAPITAL LETTER ALPHA WITH VARIA",
"GREEK CAPITAL LETTER ALPHA WITH OXIA",
"GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI",
"GREEK KORONIS",
"GREEK PROSGEGRAMMENI",
"GREEK PSILI",
"GREEK PERISPOMENI",
"GREEK DIALYTIKA AND PERISPOMENI",
"GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI",
"GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI",
name_reserved,
"GREEK SMALL LETTER ETA WITH PERISPOMENI",
"GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI",
"GREEK CAPITAL LETTER EPSILON WITH VARIA",
"GREEK CAPITAL LETTER EPSILON WITH OXIA",
"GREEK CAPITAL LETTER ETA WITH VARIA",
"GREEK CAPITAL LETTER ETA WITH OXIA",
"GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI",
"GREEK PSILI AND VARIA",
"GREEK PSILI AND OXIA",
"GREEK PSILI AND PERISPOMENI",
"GREEK SMALL LETTER IOTA WITH VRACHY",
"GREEK SMALL LETTER IOTA WITH MACRON",
"GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA",
"GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA",
name_reserved,
name_reserved,
"GREEK SMALL LETTER IOTA WITH PERISPOMENI",
"GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI",
"GREEK CAPITAL LETTER IOTA WITH VRACHY",
"GREEK CAPITAL LETTER IOTA WITH MACRON",
"GREEK CAPITAL LETTER IOTA WITH VARIA",
"GREEK CAPITAL LETTER IOTA WITH OXIA",
name_reserved,
"GREEK DASIA AND VARIA",
"GREEK DASIA AND OXIA",
"GREEK DASIA AND PERISPOMENI",
"GREEK SMALL LETTER UPSILON WITH VRACHY",
"GREEK SMALL LETTER UPSILON WITH MACRON",
"GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA",
"GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA",
"GREEK SMALL LETTER RHO WITH PSILI",
"GREEK SMALL LETTER RHO WITH DASIA",
"GREEK SMALL LETTER UPSILON WITH PERISPOMENI",
"GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI",
"GREEK CAPITAL LETTER UPSILON WITH VRACHY",
"GREEK CAPITAL LETTER UPSILON WITH MACRON",
"GREEK CAPITAL LETTER UPSILON WITH VARIA",
"GREEK CAPITAL LETTER UPSILON WITH OXIA",
"GREEK CAPITAL LETTER RHO WITH DASIA",
"GREEK DIALYTIKA AND VARIA",
"GREEK DIALYTIKA AND OXIA",
"GREEK VARIA",
name_reserved,
name_reserved,
"GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI",
"GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI",
name_reserved,
"GREEK SMALL LETTER OMEGA WITH PERISPOMENI",
"GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI",
"GREEK CAPITAL LETTER OMICRON WITH VARIA",
"GREEK CAPITAL LETTER OMICRON WITH OXIA",
"GREEK CAPITAL LETTER OMEGA WITH VARIA",
"GREEK CAPITAL LETTER OMEGA WITH OXIA",
"GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI",
"GREEK OXIA",
"GREEK DASIA",
name_reserved};
static const char * name_0020[256] =
{
"EN QUAD",
"EM QUAD",
"EN SPACE",
"EM SPACE",
"THREE-PER-EM SPACE",
"FOUR-PER-EM SPACE",
"SIX-PER-EM SPACE",
"FIGURE SPACE",
"PUNCTUATION SPACE",
"THIN SPACE",
"HAIR SPACE",
"ZERO WIDTH SPACE",
"ZERO WIDTH NON-JOINER",
"ZERO WIDTH JOINER",
"LEFT-TO-RIGHT MARK",
"RIGHT-TO-LEFT MARK",
"HYPHEN",
"NON-BREAKING HYPHEN",
"FIGURE DASH",
"EN DASH",
"EM DASH",
"HORIZONTAL BAR",
"DOUBLE VERTICAL LINE",
"DOUBLE LOW LINE",
"LEFT SINGLE QUOTATION MARK",
"RIGHT SINGLE QUOTATION MARK",
"SINGLE LOW-9 QUOTATION MARK",
"SINGLE HIGH-REVERSED-9 QUOTATION MARK",
"LEFT DOUBLE QUOTATION MARK",
"RIGHT DOUBLE QUOTATION MARK",
"DOUBLE LOW-9 QUOTATION MARK",
"DOUBLE HIGH-REVERSED-9 QUOTATION MARK",
"DAGGER",
"DOUBLE DAGGER",
"BULLET",
"TRIANGULAR BULLET",
"ONE DOT LEADER",
"TWO DOT LEADER",
"HORIZONTAL ELLIPSIS",
"HYPHENATION POINT",
"LINE SEPARATOR",
"PARAGRAPH SEPARATOR",
"LEFT-TO-RIGHT EMBEDDING",
"RIGHT-TO-LEFT EMBEDDING",
"POP DIRECTIONAL FORMATTING",
"LEFT-TO-RIGHT OVERRIDE",
"RIGHT-TO-LEFT OVERRIDE",
"NARROW NO-BREAK SPACE",
"PER MILLE SIGN",
"PER TEN THOUSAND SIGN",
"PRIME",
"DOUBLE PRIME",
"TRIPLE PRIME",
"REVERSED PRIME",
"REVERSED DOUBLE PRIME",
"REVERSED TRIPLE PRIME",
"CARET",
"SINGLE LEFT-POINTING ANGLE QUOTATION MARK",
"SINGLE RIGHT-POINTING ANGLE QUOTATION MARK",
"REFERENCE MARK",
"DOUBLE EXCLAMATION MARK",
"INTERROBANG",
"OVERLINE",
"UNDERTIE",
"CHARACTER TIE",
"CARET INSERTION POINT",
"ASTERISM",
"HYPHEN BULLET",
"FRACTION SLASH",
"LEFT SQUARE BRACKET WITH QUILL",
"RIGHT SQUARE BRACKET WITH QUILL",
"DOUBLE QUESTION MARK",
"QUESTION EXCLAMATION MARK",
"EXCLAMATION QUESTION MARK",
"TIRONIAN SIGN ET",
"REVERSED PILCROW SIGN",
"BLACK LEFTWARDS BULLET",
"BLACK RIGHTWARDS BULLET",
"LOW ASTERISK",
"REVERSED SEMICOLON",
"CLOSE UP",
"TWO ASTERISKS ALIGNED VERTICALLY",
"COMMERCIAL MINUS SIGN",
"SWUNG DASH",
"INVERTED UNDERTIE",
"FLOWER PUNCTUATION MARK",
"THREE DOT PUNCTUATION",
"QUADRUPLE PRIME",
"FOUR DOT PUNCTUATION",
"FIVE DOT PUNCTUATION",
"TWO DOT PUNCTUATION",
"FOUR DOT MARK",
"DOTTED CROSS",
"TRICOLON",
"VERTICAL FOUR DOTS",
"MEDIUM MATHEMATICAL SPACE",
"WORD JOINER",
"FUNCTION APPLICATION",
"INVISIBLE TIMES",
"INVISIBLE SEPARATOR",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"INHIBIT SYMMETRIC SWAPPING",
"ACTIVATE SYMMETRIC SWAPPING",
"INHIBIT ARABIC FORM SHAPING",
"ACTIVATE ARABIC FORM SHAPING",
"NATIONAL DIGIT SHAPES",
"NOMINAL DIGIT SHAPES",
"SUPERSCRIPT ZERO",
"SUPERSCRIPT LATIN SMALL LETTER I",
name_reserved,
name_reserved,
"SUPERSCRIPT FOUR",
"SUPERSCRIPT FIVE",
"SUPERSCRIPT SIX",
"SUPERSCRIPT SEVEN",
"SUPERSCRIPT EIGHT",
"SUPERSCRIPT NINE",
"SUPERSCRIPT PLUS SIGN",
"SUPERSCRIPT MINUS",
"SUPERSCRIPT EQUALS SIGN",
"SUPERSCRIPT LEFT PARENTHESIS",
"SUPERSCRIPT RIGHT PARENTHESIS",
"SUPERSCRIPT LATIN SMALL LETTER N",
"SUBSCRIPT ZERO",
"SUBSCRIPT ONE",
"SUBSCRIPT TWO",
"SUBSCRIPT THREE",
"SUBSCRIPT FOUR",
"SUBSCRIPT FIVE",
"SUBSCRIPT SIX",
"SUBSCRIPT SEVEN",
"SUBSCRIPT EIGHT",
"SUBSCRIPT NINE",
"SUBSCRIPT PLUS SIGN",
"SUBSCRIPT MINUS",
"SUBSCRIPT EQUALS SIGN",
"SUBSCRIPT LEFT PARENTHESIS",
"SUBSCRIPT RIGHT PARENTHESIS",
name_reserved,
"LATIN SUBSCRIPT SMALL LETTER A",
"LATIN SUBSCRIPT SMALL LETTER E",
"LATIN SUBSCRIPT SMALL LETTER O",
"LATIN SUBSCRIPT SMALL LETTER X",
"LATIN SUBSCRIPT SMALL LETTER SCHWA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"EURO-CURRENCY SIGN",
"COLON SIGN",
"CRUZEIRO SIGN",
"FRENCH FRANC SIGN",
"LIRA SIGN",
"MILL SIGN",
"NAIRA SIGN",
"PESETA SIGN",
"RUPEE SIGN",
"WON SIGN",
"NEW SHEQEL SIGN",
"DONG SIGN",
"EURO SIGN",
"KIP SIGN",
"TUGRIK SIGN",
"DRACHMA SIGN",
"GERMAN PENNY SIGN",
"PESO SIGN",
"GUARANI SIGN",
"AUSTRAL SIGN",
"HRYVNIA SIGN",
"CEDI SIGN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"COMBINING LEFT HARPOON ABOVE",
"COMBINING RIGHT HARPOON ABOVE",
"COMBINING LONG VERTICAL LINE OVERLAY",
"COMBINING SHORT VERTICAL LINE OVERLAY",
"COMBINING ANTICLOCKWISE ARROW ABOVE",
"COMBINING CLOCKWISE ARROW ABOVE",
"COMBINING LEFT ARROW ABOVE",
"COMBINING RIGHT ARROW ABOVE",
"COMBINING RING OVERLAY",
"COMBINING CLOCKWISE RING OVERLAY",
"COMBINING ANTICLOCKWISE RING OVERLAY",
"COMBINING THREE DOTS ABOVE",
"COMBINING FOUR DOTS ABOVE",
"COMBINING ENCLOSING CIRCLE",
"COMBINING ENCLOSING SQUARE",
"COMBINING ENCLOSING DIAMOND",
"COMBINING ENCLOSING CIRCLE BACKSLASH",
"COMBINING LEFT RIGHT ARROW ABOVE",
"COMBINING ENCLOSING SCREEN",
"COMBINING ENCLOSING KEYCAP",
"COMBINING ENCLOSING UPWARD POINTING TRIANGLE",
"COMBINING REVERSE SOLIDUS OVERLAY",
"COMBINING DOUBLE VERTICAL STROKE OVERLAY",
"COMBINING ANNUITY SYMBOL",
"COMBINING TRIPLE UNDERDOT",
"COMBINING WIDE BRIDGE ABOVE",
"COMBINING LEFTWARDS ARROW OVERLAY",
"COMBINING LONG DOUBLE SOLIDUS OVERLAY",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0021[256] =
{
"ACCOUNT OF",
"ADDRESSED TO THE SUBJECT",
"DOUBLE-STRUCK CAPITAL C",
"DEGREE CELSIUS",
"CENTRE LINE SYMBOL",
"CARE OF",
"CADA UNA",
"EULER CONSTANT",
"SCRUPLE",
"DEGREE FAHRENHEIT",
"SCRIPT SMALL G",
"SCRIPT CAPITAL H",
"BLACK-LETTER CAPITAL H",
"DOUBLE-STRUCK CAPITAL H",
"PLANCK CONSTANT",
"PLANCK CONSTANT OVER TWO PI",
"SCRIPT CAPITAL I",
"BLACK-LETTER CAPITAL I",
"SCRIPT CAPITAL L",
"SCRIPT SMALL L",
"L B BAR SYMBOL",
"DOUBLE-STRUCK CAPITAL N",
"NUMERO SIGN",
"SOUND RECORDING COPYRIGHT",
"SCRIPT CAPITAL P",
"DOUBLE-STRUCK CAPITAL P",
"DOUBLE-STRUCK CAPITAL Q",
"SCRIPT CAPITAL R",
"BLACK-LETTER CAPITAL R",
"DOUBLE-STRUCK CAPITAL R",
"PRESCRIPTION TAKE",
"RESPONSE",
"SERVICE MARK",
"TELEPHONE SIGN",
"TRADE MARK SIGN",
"VERSICLE",
"DOUBLE-STRUCK CAPITAL Z",
"OUNCE SIGN",
"OHM SIGN",
"INVERTED OHM SIGN",
"BLACK-LETTER CAPITAL Z",
"TURNED GREEK SMALL LETTER IOTA",
"KELVIN SIGN",
"ANGSTROM SIGN",
"SCRIPT CAPITAL B",
"BLACK-LETTER CAPITAL C",
"ESTIMATED SYMBOL",
"SCRIPT SMALL E",
"SCRIPT CAPITAL E",
"SCRIPT CAPITAL F",
"TURNED CAPITAL F",
"SCRIPT CAPITAL M",
"SCRIPT SMALL O",
"ALEF SYMBOL",
"BET SYMBOL",
"GIMEL SYMBOL",
"DALET SYMBOL",
"INFORMATION SOURCE",
"ROTATED CAPITAL Q",
"FACSIMILE SIGN",
"DOUBLE-STRUCK SMALL PI",
"DOUBLE-STRUCK SMALL GAMMA",
"DOUBLE-STRUCK CAPITAL GAMMA",
"DOUBLE-STRUCK CAPITAL PI",
"DOUBLE-STRUCK N-ARY SUMMATION",
"TURNED SANS-SERIF CAPITAL G",
"TURNED SANS-SERIF CAPITAL L",
"REVERSED SANS-SERIF CAPITAL L",
"TURNED SANS-SERIF CAPITAL Y",
"DOUBLE-STRUCK ITALIC CAPITAL D",
"DOUBLE-STRUCK ITALIC SMALL D",
"DOUBLE-STRUCK ITALIC SMALL E",
"DOUBLE-STRUCK ITALIC SMALL I",
"DOUBLE-STRUCK ITALIC SMALL J",
"PROPERTY LINE",
"TURNED AMPERSAND",
"PER SIGN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"VULGAR FRACTION ONE THIRD",
"VULGAR FRACTION TWO THIRDS",
"VULGAR FRACTION ONE FIFTH",
"VULGAR FRACTION TWO FIFTHS",
"VULGAR FRACTION THREE FIFTHS",
"VULGAR FRACTION FOUR FIFTHS",
"VULGAR FRACTION ONE SIXTH",
"VULGAR FRACTION FIVE SIXTHS",
"VULGAR FRACTION ONE EIGHTH",
"VULGAR FRACTION THREE EIGHTHS",
"VULGAR FRACTION FIVE EIGHTHS",
"VULGAR FRACTION SEVEN EIGHTHS",
"FRACTION NUMERATOR ONE",
"ROMAN NUMERAL ONE",
"ROMAN NUMERAL TWO",
"ROMAN NUMERAL THREE",
"ROMAN NUMERAL FOUR",
"ROMAN NUMERAL FIVE",
"ROMAN NUMERAL SIX",
"ROMAN NUMERAL SEVEN",
"ROMAN NUMERAL EIGHT",
"ROMAN NUMERAL NINE",
"ROMAN NUMERAL TEN",
"ROMAN NUMERAL ELEVEN",
"ROMAN NUMERAL TWELVE",
"ROMAN NUMERAL FIFTY",
"ROMAN NUMERAL ONE HUNDRED",
"ROMAN NUMERAL FIVE HUNDRED",
"ROMAN NUMERAL ONE THOUSAND",
"SMALL ROMAN NUMERAL ONE",
"SMALL ROMAN NUMERAL TWO",
"SMALL ROMAN NUMERAL THREE",
"SMALL ROMAN NUMERAL FOUR",
"SMALL ROMAN NUMERAL FIVE",
"SMALL ROMAN NUMERAL SIX",
"SMALL ROMAN NUMERAL SEVEN",
"SMALL ROMAN NUMERAL EIGHT",
"SMALL ROMAN NUMERAL NINE",
"SMALL ROMAN NUMERAL TEN",
"SMALL ROMAN NUMERAL ELEVEN",
"SMALL ROMAN NUMERAL TWELVE",
"SMALL ROMAN NUMERAL FIFTY",
"SMALL ROMAN NUMERAL ONE HUNDRED",
"SMALL ROMAN NUMERAL FIVE HUNDRED",
"SMALL ROMAN NUMERAL ONE THOUSAND",
"ROMAN NUMERAL ONE THOUSAND C D",
"ROMAN NUMERAL FIVE THOUSAND",
"ROMAN NUMERAL TEN THOUSAND",
"ROMAN NUMERAL REVERSED ONE HUNDRED",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"LEFTWARDS ARROW",
"UPWARDS ARROW",
"RIGHTWARDS ARROW",
"DOWNWARDS ARROW",
"LEFT RIGHT ARROW",
"UP DOWN ARROW",
"NORTH WEST ARROW",
"NORTH EAST ARROW",
"SOUTH EAST ARROW",
"SOUTH WEST ARROW",
"LEFTWARDS ARROW WITH STROKE",
"RIGHTWARDS ARROW WITH STROKE",
"LEFTWARDS WAVE ARROW",
"RIGHTWARDS WAVE ARROW",
"LEFTWARDS TWO HEADED ARROW",
"UPWARDS TWO HEADED ARROW",
"RIGHTWARDS TWO HEADED ARROW",
"DOWNWARDS TWO HEADED ARROW",
"LEFTWARDS ARROW WITH TAIL",
"RIGHTWARDS ARROW WITH TAIL",
"LEFTWARDS ARROW FROM BAR",
"UPWARDS ARROW FROM BAR",
"RIGHTWARDS ARROW FROM BAR",
"DOWNWARDS ARROW FROM BAR",
"UP DOWN ARROW WITH BASE",
"LEFTWARDS ARROW WITH HOOK",
"RIGHTWARDS ARROW WITH HOOK",
"LEFTWARDS ARROW WITH LOOP",
"RIGHTWARDS ARROW WITH LOOP",
"LEFT RIGHT WAVE ARROW",
"LEFT RIGHT ARROW WITH STROKE",
"DOWNWARDS ZIGZAG ARROW",
"UPWARDS ARROW WITH TIP LEFTWARDS",
"UPWARDS ARROW WITH TIP RIGHTWARDS",
"DOWNWARDS ARROW WITH TIP LEFTWARDS",
"DOWNWARDS ARROW WITH TIP RIGHTWARDS",
"RIGHTWARDS ARROW WITH CORNER DOWNWARDS",
"DOWNWARDS ARROW WITH CORNER LEFTWARDS",
"ANTICLOCKWISE TOP SEMICIRCLE ARROW",
"CLOCKWISE TOP SEMICIRCLE ARROW",
"NORTH WEST ARROW TO LONG BAR",
"LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR",
"ANTICLOCKWISE OPEN CIRCLE ARROW",
"CLOCKWISE OPEN CIRCLE ARROW",
"LEFTWARDS HARPOON WITH BARB UPWARDS",
"LEFTWARDS HARPOON WITH BARB DOWNWARDS",
"UPWARDS HARPOON WITH BARB RIGHTWARDS",
"UPWARDS HARPOON WITH BARB LEFTWARDS",
"RIGHTWARDS HARPOON WITH BARB UPWARDS",
"RIGHTWARDS HARPOON WITH BARB DOWNWARDS",
"DOWNWARDS HARPOON WITH BARB RIGHTWARDS",
"DOWNWARDS HARPOON WITH BARB LEFTWARDS",
"RIGHTWARDS ARROW OVER LEFTWARDS ARROW",
"UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW",
"LEFTWARDS ARROW OVER RIGHTWARDS ARROW",
"LEFTWARDS PAIRED ARROWS",
"UPWARDS PAIRED ARROWS",
"RIGHTWARDS PAIRED ARROWS",
"DOWNWARDS PAIRED ARROWS",
"LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON",
"RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON",
"LEFTWARDS DOUBLE ARROW WITH STROKE",
"LEFT RIGHT DOUBLE ARROW WITH STROKE",
"RIGHTWARDS DOUBLE ARROW WITH STROKE",
"LEFTWARDS DOUBLE ARROW",
"UPWARDS DOUBLE ARROW",
"RIGHTWARDS DOUBLE ARROW",
"DOWNWARDS DOUBLE ARROW",
"LEFT RIGHT DOUBLE ARROW",
"UP DOWN DOUBLE ARROW",
"NORTH WEST DOUBLE ARROW",
"NORTH EAST DOUBLE ARROW",
"SOUTH EAST DOUBLE ARROW",
"SOUTH WEST DOUBLE ARROW",
"LEFTWARDS TRIPLE ARROW",
"RIGHTWARDS TRIPLE ARROW",
"LEFTWARDS SQUIGGLE ARROW",
"RIGHTWARDS SQUIGGLE ARROW",
"UPWARDS ARROW WITH DOUBLE STROKE",
"DOWNWARDS ARROW WITH DOUBLE STROKE",
"LEFTWARDS DASHED ARROW",
"UPWARDS DASHED ARROW",
"RIGHTWARDS DASHED ARROW",
"DOWNWARDS DASHED ARROW",
"LEFTWARDS ARROW TO BAR",
"RIGHTWARDS ARROW TO BAR",
"LEFTWARDS WHITE ARROW",
"UPWARDS WHITE ARROW",
"RIGHTWARDS WHITE ARROW",
"DOWNWARDS WHITE ARROW",
"UPWARDS WHITE ARROW FROM BAR",
"UPWARDS WHITE ARROW ON PEDESTAL",
"UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR",
"UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR",
"UPWARDS WHITE DOUBLE ARROW",
"UPWARDS WHITE DOUBLE ARROW ON PEDESTAL",
"RIGHTWARDS WHITE ARROW FROM WALL",
"NORTH WEST ARROW TO CORNER",
"SOUTH EAST ARROW TO CORNER",
"UP DOWN WHITE ARROW",
"RIGHT ARROW WITH SMALL CIRCLE",
"DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW",
"THREE RIGHTWARDS ARROWS",
"LEFTWARDS ARROW WITH VERTICAL STROKE",
"RIGHTWARDS ARROW WITH VERTICAL STROKE",
"LEFT RIGHT ARROW WITH VERTICAL STROKE",
"LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE",
"RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE",
"LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE",
"LEFTWARDS OPEN-HEADED ARROW",
"RIGHTWARDS OPEN-HEADED ARROW",
"LEFT RIGHT OPEN-HEADED ARROW"};
static const char * name_0022[256] =
{
"FOR ALL",
"COMPLEMENT",
"PARTIAL DIFFERENTIAL",
"THERE EXISTS",
"THERE DOES NOT EXIST",
"EMPTY SET",
"INCREMENT",
"NABLA",
"ELEMENT OF",
"NOT AN ELEMENT OF",
"SMALL ELEMENT OF",
"CONTAINS AS MEMBER",
"DOES NOT CONTAIN AS MEMBER",
"SMALL CONTAINS AS MEMBER",
"END OF PROOF",
"N-ARY PRODUCT",
"N-ARY COPRODUCT",
"N-ARY SUMMATION",
"MINUS SIGN",
"MINUS-OR-PLUS SIGN",
"DOT PLUS",
"DIVISION SLASH",
"SET MINUS",
"ASTERISK OPERATOR",
"RING OPERATOR",
"BULLET OPERATOR",
"SQUARE ROOT",
"CUBE ROOT",
"FOURTH ROOT",
"PROPORTIONAL TO",
"INFINITY",
"RIGHT ANGLE",
"ANGLE",
"MEASURED ANGLE",
"SPHERICAL ANGLE",
"DIVIDES",
"DOES NOT DIVIDE",
"PARALLEL TO",
"NOT PARALLEL TO",
"LOGICAL AND",
"LOGICAL OR",
"INTERSECTION",
"UNION",
"INTEGRAL",
"DOUBLE INTEGRAL",
"TRIPLE INTEGRAL",
"CONTOUR INTEGRAL",
"SURFACE INTEGRAL",
"VOLUME INTEGRAL",
"CLOCKWISE INTEGRAL",
"CLOCKWISE CONTOUR INTEGRAL",
"ANTICLOCKWISE CONTOUR INTEGRAL",
"THEREFORE",
"BECAUSE",
"RATIO",
"PROPORTION",
"DOT MINUS",
"EXCESS",
"GEOMETRIC PROPORTION",
"HOMOTHETIC",
"TILDE OPERATOR",
"REVERSED TILDE",
"INVERTED LAZY S",
"SINE WAVE",
"WREATH PRODUCT",
"NOT TILDE",
"MINUS TILDE",
"ASYMPTOTICALLY EQUAL TO",
"NOT ASYMPTOTICALLY EQUAL TO",
"APPROXIMATELY EQUAL TO",
"APPROXIMATELY BUT NOT ACTUALLY EQUAL TO",
"NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO",
"ALMOST EQUAL TO",
"NOT ALMOST EQUAL TO",
"ALMOST EQUAL OR EQUAL TO",
"TRIPLE TILDE",
"ALL EQUAL TO",
"EQUIVALENT TO",
"GEOMETRICALLY EQUIVALENT TO",
"DIFFERENCE BETWEEN",
"APPROACHES THE LIMIT",
"GEOMETRICALLY EQUAL TO",
"APPROXIMATELY EQUAL TO OR THE IMAGE OF",
"IMAGE OF OR APPROXIMATELY EQUAL TO",
"COLON EQUALS",
"EQUALS COLON",
"RING IN EQUAL TO",
"RING EQUAL TO",
"CORRESPONDS TO",
"ESTIMATES",
"EQUIANGULAR TO",
"STAR EQUALS",
"DELTA EQUAL TO",
"EQUAL TO BY DEFINITION",
"MEASURED BY",
"QUESTIONED EQUAL TO",
"NOT EQUAL TO",
"IDENTICAL TO",
"NOT IDENTICAL TO",
"STRICTLY EQUIVALENT TO",
"LESS-THAN OR EQUAL TO",
"GREATER-THAN OR EQUAL TO",
"LESS-THAN OVER EQUAL TO",
"GREATER-THAN OVER EQUAL TO",
"LESS-THAN BUT NOT EQUAL TO",
"GREATER-THAN BUT NOT EQUAL TO",
"MUCH LESS-THAN",
"MUCH GREATER-THAN",
"BETWEEN",
"NOT EQUIVALENT TO",
"NOT LESS-THAN",
"NOT GREATER-THAN",
"NEITHER LESS-THAN NOR EQUAL TO",
"NEITHER GREATER-THAN NOR EQUAL TO",
"LESS-THAN OR EQUIVALENT TO",
"GREATER-THAN OR EQUIVALENT TO",
"NEITHER LESS-THAN NOR EQUIVALENT TO",
"NEITHER GREATER-THAN NOR EQUIVALENT TO",
"LESS-THAN OR GREATER-THAN",
"GREATER-THAN OR LESS-THAN",
"NEITHER LESS-THAN NOR GREATER-THAN",
"NEITHER GREATER-THAN NOR LESS-THAN",
"PRECEDES",
"SUCCEEDS",
"PRECEDES OR EQUAL TO",
"SUCCEEDS OR EQUAL TO",
"PRECEDES OR EQUIVALENT TO",
"SUCCEEDS OR EQUIVALENT TO",
"DOES NOT PRECEDE",
"DOES NOT SUCCEED",
"SUBSET OF",
"SUPERSET OF",
"NOT A SUBSET OF",
"NOT A SUPERSET OF",
"SUBSET OF OR EQUAL TO",
"SUPERSET OF OR EQUAL TO",
"NEITHER A SUBSET OF NOR EQUAL TO",
"NEITHER A SUPERSET OF NOR EQUAL TO",
"SUBSET OF WITH NOT EQUAL TO",
"SUPERSET OF WITH NOT EQUAL TO",
"MULTISET",
"MULTISET MULTIPLICATION",
"MULTISET UNION",
"SQUARE IMAGE OF",
"SQUARE ORIGINAL OF",
"SQUARE IMAGE OF OR EQUAL TO",
"SQUARE ORIGINAL OF OR EQUAL TO",
"SQUARE CAP",
"SQUARE CUP",
"CIRCLED PLUS",
"CIRCLED MINUS",
"CIRCLED TIMES",
"CIRCLED DIVISION SLASH",
"CIRCLED DOT OPERATOR",
"CIRCLED RING OPERATOR",
"CIRCLED ASTERISK OPERATOR",
"CIRCLED EQUALS",
"CIRCLED DASH",
"SQUARED PLUS",
"SQUARED MINUS",
"SQUARED TIMES",
"SQUARED DOT OPERATOR",
"RIGHT TACK",
"LEFT TACK",
"DOWN TACK",
"UP TACK",
"ASSERTION",
"MODELS",
"TRUE",
"FORCES",
"TRIPLE VERTICAL BAR RIGHT TURNSTILE",
"DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE",
"DOES NOT PROVE",
"NOT TRUE",
"DOES NOT FORCE",
"NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE",
"PRECEDES UNDER RELATION",
"SUCCEEDS UNDER RELATION",
"NORMAL SUBGROUP OF",
"CONTAINS AS NORMAL SUBGROUP",
"NORMAL SUBGROUP OF OR EQUAL TO",
"CONTAINS AS NORMAL SUBGROUP OR EQUAL TO",
"ORIGINAL OF",
"IMAGE OF",
"MULTIMAP",
"HERMITIAN CONJUGATE MATRIX",
"INTERCALATE",
"XOR",
"NAND",
"NOR",
"RIGHT ANGLE WITH ARC",
"RIGHT TRIANGLE",
"N-ARY LOGICAL AND",
"N-ARY LOGICAL OR",
"N-ARY INTERSECTION",
"N-ARY UNION",
"DIAMOND OPERATOR",
"DOT OPERATOR",
"STAR OPERATOR",
"DIVISION TIMES",
"BOWTIE",
"LEFT NORMAL FACTOR SEMIDIRECT PRODUCT",
"RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT",
"LEFT SEMIDIRECT PRODUCT",
"RIGHT SEMIDIRECT PRODUCT",
"REVERSED TILDE EQUALS",
"CURLY LOGICAL OR",
"CURLY LOGICAL AND",
"DOUBLE SUBSET",
"DOUBLE SUPERSET",
"DOUBLE INTERSECTION",
"DOUBLE UNION",
"PITCHFORK",
"EQUAL AND PARALLEL TO",
"LESS-THAN WITH DOT",
"GREATER-THAN WITH DOT",
"VERY MUCH LESS-THAN",
"VERY MUCH GREATER-THAN",
"LESS-THAN EQUAL TO OR GREATER-THAN",
"GREATER-THAN EQUAL TO OR LESS-THAN",
"EQUAL TO OR LESS-THAN",
"EQUAL TO OR GREATER-THAN",
"EQUAL TO OR PRECEDES",
"EQUAL TO OR SUCCEEDS",
"DOES NOT PRECEDE OR EQUAL",
"DOES NOT SUCCEED OR EQUAL",
"NOT SQUARE IMAGE OF OR EQUAL TO",
"NOT SQUARE ORIGINAL OF OR EQUAL TO",
"SQUARE IMAGE OF OR NOT EQUAL TO",
"SQUARE ORIGINAL OF OR NOT EQUAL TO",
"LESS-THAN BUT NOT EQUIVALENT TO",
"GREATER-THAN BUT NOT EQUIVALENT TO",
"PRECEDES BUT NOT EQUIVALENT TO",
"SUCCEEDS BUT NOT EQUIVALENT TO",
"NOT NORMAL SUBGROUP OF",
"DOES NOT CONTAIN AS NORMAL SUBGROUP",
"NOT NORMAL SUBGROUP OF OR EQUAL TO",
"DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL",
"VERTICAL ELLIPSIS",
"MIDLINE HORIZONTAL ELLIPSIS",
"UP RIGHT DIAGONAL ELLIPSIS",
"DOWN RIGHT DIAGONAL ELLIPSIS",
"ELEMENT OF WITH LONG HORIZONTAL STROKE",
"ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
"SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
"ELEMENT OF WITH DOT ABOVE",
"ELEMENT OF WITH OVERBAR",
"SMALL ELEMENT OF WITH OVERBAR",
"ELEMENT OF WITH UNDERBAR",
"ELEMENT OF WITH TWO HORIZONTAL STROKES",
"CONTAINS WITH LONG HORIZONTAL STROKE",
"CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
"SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
"CONTAINS WITH OVERBAR",
"SMALL CONTAINS WITH OVERBAR",
"Z NOTATION BAG MEMBERSHIP"};
static const char * name_0023[256] =
{
"DIAMETER SIGN",
"ELECTRIC ARROW",
"HOUSE",
"UP ARROWHEAD",
"DOWN ARROWHEAD",
"PROJECTIVE",
"PERSPECTIVE",
"WAVY LINE",
"LEFT CEILING",
"RIGHT CEILING",
"LEFT FLOOR",
"RIGHT FLOOR",
"BOTTOM RIGHT CROP",
"BOTTOM LEFT CROP",
"TOP RIGHT CROP",
"TOP LEFT CROP",
"REVERSED NOT SIGN",
"SQUARE LOZENGE",
"ARC",
"SEGMENT",
"SECTOR",
"TELEPHONE RECORDER",
"POSITION INDICATOR",
"VIEWDATA SQUARE",
"PLACE OF INTEREST SIGN",
"TURNED NOT SIGN",
"WATCH",
"HOURGLASS",
"TOP LEFT CORNER",
"TOP RIGHT CORNER",
"BOTTOM LEFT CORNER",
"BOTTOM RIGHT CORNER",
"TOP HALF INTEGRAL",
"BOTTOM HALF INTEGRAL",
"FROWN",
"SMILE",
"UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS",
"OPTION KEY",
"ERASE TO THE RIGHT",
"X IN A RECTANGLE BOX",
"KEYBOARD",
"LEFT-POINTING ANGLE BRACKET",
"RIGHT-POINTING ANGLE BRACKET",
"ERASE TO THE LEFT",
"BENZENE RING",
"CYLINDRICITY",
"ALL AROUND-PROFILE",
"SYMMETRY",
"TOTAL RUNOUT",
"DIMENSION ORIGIN",
"CONICAL TAPER",
"SLOPE",
"COUNTERBORE",
"COUNTERSINK",
"APL FUNCTIONAL SYMBOL I-BEAM",
"APL FUNCTIONAL SYMBOL SQUISH QUAD",
"APL FUNCTIONAL SYMBOL QUAD EQUAL",
"APL FUNCTIONAL SYMBOL QUAD DIVIDE",
"APL FUNCTIONAL SYMBOL QUAD DIAMOND",
"APL FUNCTIONAL SYMBOL QUAD JOT",
"APL FUNCTIONAL SYMBOL QUAD CIRCLE",
"APL FUNCTIONAL SYMBOL CIRCLE STILE",
"APL FUNCTIONAL SYMBOL CIRCLE JOT",
"APL FUNCTIONAL SYMBOL SLASH BAR",
"APL FUNCTIONAL SYMBOL BACKSLASH BAR",
"APL FUNCTIONAL SYMBOL QUAD SLASH",
"APL FUNCTIONAL SYMBOL QUAD BACKSLASH",
"APL FUNCTIONAL SYMBOL QUAD LESS-THAN",
"APL FUNCTIONAL SYMBOL QUAD GREATER-THAN",
"APL FUNCTIONAL SYMBOL LEFTWARDS VANE",
"APL FUNCTIONAL SYMBOL RIGHTWARDS VANE",
"APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW",
"APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW",
"APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH",
"APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR",
"APL FUNCTIONAL SYMBOL DELTA STILE",
"APL FUNCTIONAL SYMBOL QUAD DOWN CARET",
"APL FUNCTIONAL SYMBOL QUAD DELTA",
"APL FUNCTIONAL SYMBOL DOWN TACK JOT",
"APL FUNCTIONAL SYMBOL UPWARDS VANE",
"APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW",
"APL FUNCTIONAL SYMBOL UP TACK OVERBAR",
"APL FUNCTIONAL SYMBOL DEL STILE",
"APL FUNCTIONAL SYMBOL QUAD UP CARET",
"APL FUNCTIONAL SYMBOL QUAD DEL",
"APL FUNCTIONAL SYMBOL UP TACK JOT",
"APL FUNCTIONAL SYMBOL DOWNWARDS VANE",
"APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW",
"APL FUNCTIONAL SYMBOL QUOTE UNDERBAR",
"APL FUNCTIONAL SYMBOL DELTA UNDERBAR",
"APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR",
"APL FUNCTIONAL SYMBOL JOT UNDERBAR",
"APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR",
"APL FUNCTIONAL SYMBOL UP SHOE JOT",
"APL FUNCTIONAL SYMBOL QUOTE QUAD",
"APL FUNCTIONAL SYMBOL CIRCLE STAR",
"APL FUNCTIONAL SYMBOL QUAD COLON",
"APL FUNCTIONAL SYMBOL UP TACK DIAERESIS",
"APL FUNCTIONAL SYMBOL DEL DIAERESIS",
"APL FUNCTIONAL SYMBOL STAR DIAERESIS",
"APL FUNCTIONAL SYMBOL JOT DIAERESIS",
"APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS",
"APL FUNCTIONAL SYMBOL DOWN SHOE STILE",
"APL FUNCTIONAL SYMBOL LEFT SHOE STILE",
"APL FUNCTIONAL SYMBOL TILDE DIAERESIS",
"APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS",
"APL FUNCTIONAL SYMBOL COMMA BAR",
"APL FUNCTIONAL SYMBOL DEL TILDE",
"APL FUNCTIONAL SYMBOL ZILDE",
"APL FUNCTIONAL SYMBOL STILE TILDE",
"APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR",
"APL FUNCTIONAL SYMBOL QUAD NOT EQUAL",
"APL FUNCTIONAL SYMBOL QUAD QUESTION",
"APL FUNCTIONAL SYMBOL DOWN CARET TILDE",
"APL FUNCTIONAL SYMBOL UP CARET TILDE",
"APL FUNCTIONAL SYMBOL IOTA",
"APL FUNCTIONAL SYMBOL RHO",
"APL FUNCTIONAL SYMBOL OMEGA",
"APL FUNCTIONAL SYMBOL ALPHA UNDERBAR",
"APL FUNCTIONAL SYMBOL EPSILON UNDERBAR",
"APL FUNCTIONAL SYMBOL IOTA UNDERBAR",
"APL FUNCTIONAL SYMBOL OMEGA UNDERBAR",
"APL FUNCTIONAL SYMBOL ALPHA",
"NOT CHECK MARK",
"RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW",
"SHOULDERED OPEN BOX",
"BELL SYMBOL",
"VERTICAL LINE WITH MIDDLE DOT",
"INSERTION SYMBOL",
"CONTINUOUS UNDERLINE SYMBOL",
"DISCONTINUOUS UNDERLINE SYMBOL",
"EMPHASIS SYMBOL",
"COMPOSITION SYMBOL",
"WHITE SQUARE WITH CENTRE VERTICAL LINE",
"ENTER SYMBOL",
"ALTERNATIVE KEY SYMBOL",
"HELM SYMBOL",
"CIRCLED HORIZONTAL BAR WITH NOTCH",
"CIRCLED TRIANGLE DOWN",
"BROKEN CIRCLE WITH NORTHWEST ARROW",
"UNDO SYMBOL",
"MONOSTABLE SYMBOL",
"HYSTERESIS SYMBOL",
"OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL",
"OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL",
"PASSIVE-PULL-DOWN-OUTPUT SYMBOL",
"PASSIVE-PULL-UP-OUTPUT SYMBOL",
"DIRECT CURRENT SYMBOL FORM TWO",
"SOFTWARE-FUNCTION SYMBOL",
"APL FUNCTIONAL SYMBOL QUAD",
"DECIMAL SEPARATOR KEY SYMBOL",
"PREVIOUS PAGE",
"NEXT PAGE",
"PRINT SCREEN SYMBOL",
"CLEAR SCREEN SYMBOL",
"LEFT PARENTHESIS UPPER HOOK",
"LEFT PARENTHESIS EXTENSION",
"LEFT PARENTHESIS LOWER HOOK",
"RIGHT PARENTHESIS UPPER HOOK",
"RIGHT PARENTHESIS EXTENSION",
"RIGHT PARENTHESIS LOWER HOOK",
"LEFT SQUARE BRACKET UPPER CORNER",
"LEFT SQUARE BRACKET EXTENSION",
"LEFT SQUARE BRACKET LOWER CORNER",
"RIGHT SQUARE BRACKET UPPER CORNER",
"RIGHT SQUARE BRACKET EXTENSION",
"RIGHT SQUARE BRACKET LOWER CORNER",
"LEFT CURLY BRACKET UPPER HOOK",
"LEFT CURLY BRACKET MIDDLE PIECE",
"LEFT CURLY BRACKET LOWER HOOK",
"CURLY BRACKET EXTENSION",
"RIGHT CURLY BRACKET UPPER HOOK",
"RIGHT CURLY BRACKET MIDDLE PIECE",
"RIGHT CURLY BRACKET LOWER HOOK",
"INTEGRAL EXTENSION",
"HORIZONTAL LINE EXTENSION",
"UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION",
"UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION",
"SUMMATION TOP",
"SUMMATION BOTTOM",
"TOP SQUARE BRACKET",
"BOTTOM SQUARE BRACKET",
"BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET",
"RADICAL SYMBOL BOTTOM",
"LEFT VERTICAL BOX LINE",
"RIGHT VERTICAL BOX LINE",
"HORIZONTAL SCAN LINE-1",
"HORIZONTAL SCAN LINE-3",
"HORIZONTAL SCAN LINE-7",
"HORIZONTAL SCAN LINE-9",
"DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT",
"DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT",
"DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE",
"DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE",
"DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE",
"DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE",
"DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE",
"DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE",
"DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE",
"DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE",
"DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE",
"DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL",
"DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL",
"DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT",
"DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT",
"SQUARE FOOT",
"RETURN SYMBOL",
"EJECT SYMBOL",
"VERTICAL LINE EXTENSION",
"METRICAL BREVE",
"METRICAL LONG OVER SHORT",
"METRICAL SHORT OVER LONG",
"METRICAL LONG OVER TWO SHORTS",
"METRICAL TWO SHORTS OVER LONG",
"METRICAL TWO SHORTS JOINED",
"METRICAL TRISEME",
"METRICAL TETRASEME",
"METRICAL PENTASEME",
"EARTH GROUND",
"FUSE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0024[256] =
{
"SYMBOL FOR NULL",
"SYMBOL FOR START OF HEADING",
"SYMBOL FOR START OF TEXT",
"SYMBOL FOR END OF TEXT",
"SYMBOL FOR END OF TRANSMISSION",
"SYMBOL FOR ENQUIRY",
"SYMBOL FOR ACKNOWLEDGE",
"SYMBOL FOR BELL",
"SYMBOL FOR BACKSPACE",
"SYMBOL FOR HORIZONTAL TABULATION",
"SYMBOL FOR LINE FEED",
"SYMBOL FOR VERTICAL TABULATION",
"SYMBOL FOR FORM FEED",
"SYMBOL FOR CARRIAGE RETURN",
"SYMBOL FOR SHIFT OUT",
"SYMBOL FOR SHIFT IN",
"SYMBOL FOR DATA LINK ESCAPE",
"SYMBOL FOR DEVICE CONTROL ONE",
"SYMBOL FOR DEVICE CONTROL TWO",
"SYMBOL FOR DEVICE CONTROL THREE",
"SYMBOL FOR DEVICE CONTROL FOUR",
"SYMBOL FOR NEGATIVE ACKNOWLEDGE",
"SYMBOL FOR SYNCHRONOUS IDLE",
"SYMBOL FOR END OF TRANSMISSION BLOCK",
"SYMBOL FOR CANCEL",
"SYMBOL FOR END OF MEDIUM",
"SYMBOL FOR SUBSTITUTE",
"SYMBOL FOR ESCAPE",
"SYMBOL FOR FILE SEPARATOR",
"SYMBOL FOR GROUP SEPARATOR",
"SYMBOL FOR RECORD SEPARATOR",
"SYMBOL FOR UNIT SEPARATOR",
"SYMBOL FOR SPACE",
"SYMBOL FOR DELETE",
"BLANK SYMBOL",
"OPEN BOX",
"SYMBOL FOR NEWLINE",
"SYMBOL FOR DELETE FORM TWO",
"SYMBOL FOR SUBSTITUTE FORM TWO",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"OCR HOOK",
"OCR CHAIR",
"OCR FORK",
"OCR INVERTED FORK",
"OCR BELT BUCKLE",
"OCR BOW TIE",
"OCR BRANCH BANK IDENTIFICATION",
"OCR AMOUNT OF CHECK",
"OCR DASH",
"OCR CUSTOMER ACCOUNT NUMBER",
"OCR DOUBLE BACKSLASH",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"CIRCLED DIGIT ONE",
"CIRCLED DIGIT TWO",
"CIRCLED DIGIT THREE",
"CIRCLED DIGIT FOUR",
"CIRCLED DIGIT FIVE",
"CIRCLED DIGIT SIX",
"CIRCLED DIGIT SEVEN",
"CIRCLED DIGIT EIGHT",
"CIRCLED DIGIT NINE",
"CIRCLED NUMBER TEN",
"CIRCLED NUMBER ELEVEN",
"CIRCLED NUMBER TWELVE",
"CIRCLED NUMBER THIRTEEN",
"CIRCLED NUMBER FOURTEEN",
"CIRCLED NUMBER FIFTEEN",
"CIRCLED NUMBER SIXTEEN",
"CIRCLED NUMBER SEVENTEEN",
"CIRCLED NUMBER EIGHTEEN",
"CIRCLED NUMBER NINETEEN",
"CIRCLED NUMBER TWENTY",
"PARENTHESIZED DIGIT ONE",
"PARENTHESIZED DIGIT TWO",
"PARENTHESIZED DIGIT THREE",
"PARENTHESIZED DIGIT FOUR",
"PARENTHESIZED DIGIT FIVE",
"PARENTHESIZED DIGIT SIX",
"PARENTHESIZED DIGIT SEVEN",
"PARENTHESIZED DIGIT EIGHT",
"PARENTHESIZED DIGIT NINE",
"PARENTHESIZED NUMBER TEN",
"PARENTHESIZED NUMBER ELEVEN",
"PARENTHESIZED NUMBER TWELVE",
"PARENTHESIZED NUMBER THIRTEEN",
"PARENTHESIZED NUMBER FOURTEEN",
"PARENTHESIZED NUMBER FIFTEEN",
"PARENTHESIZED NUMBER SIXTEEN",
"PARENTHESIZED NUMBER SEVENTEEN",
"PARENTHESIZED NUMBER EIGHTEEN",
"PARENTHESIZED NUMBER NINETEEN",
"PARENTHESIZED NUMBER TWENTY",
"DIGIT ONE FULL STOP",
"DIGIT TWO FULL STOP",
"DIGIT THREE FULL STOP",
"DIGIT FOUR FULL STOP",
"DIGIT FIVE FULL STOP",
"DIGIT SIX FULL STOP",
"DIGIT SEVEN FULL STOP",
"DIGIT EIGHT FULL STOP",
"DIGIT NINE FULL STOP",
"NUMBER TEN FULL STOP",
"NUMBER ELEVEN FULL STOP",
"NUMBER TWELVE FULL STOP",
"NUMBER THIRTEEN FULL STOP",
"NUMBER FOURTEEN FULL STOP",
"NUMBER FIFTEEN FULL STOP",
"NUMBER SIXTEEN FULL STOP",
"NUMBER SEVENTEEN FULL STOP",
"NUMBER EIGHTEEN FULL STOP",
"NUMBER NINETEEN FULL STOP",
"NUMBER TWENTY FULL STOP",
"PARENTHESIZED LATIN SMALL LETTER A",
"PARENTHESIZED LATIN SMALL LETTER B",
"PARENTHESIZED LATIN SMALL LETTER C",
"PARENTHESIZED LATIN SMALL LETTER D",
"PARENTHESIZED LATIN SMALL LETTER E",
"PARENTHESIZED LATIN SMALL LETTER F",
"PARENTHESIZED LATIN SMALL LETTER G",
"PARENTHESIZED LATIN SMALL LETTER H",
"PARENTHESIZED LATIN SMALL LETTER I",
"PARENTHESIZED LATIN SMALL LETTER J",
"PARENTHESIZED LATIN SMALL LETTER K",
"PARENTHESIZED LATIN SMALL LETTER L",
"PARENTHESIZED LATIN SMALL LETTER M",
"PARENTHESIZED LATIN SMALL LETTER N",
"PARENTHESIZED LATIN SMALL LETTER O",
"PARENTHESIZED LATIN SMALL LETTER P",
"PARENTHESIZED LATIN SMALL LETTER Q",
"PARENTHESIZED LATIN SMALL LETTER R",
"PARENTHESIZED LATIN SMALL LETTER S",
"PARENTHESIZED LATIN SMALL LETTER T",
"PARENTHESIZED LATIN SMALL LETTER U",
"PARENTHESIZED LATIN SMALL LETTER V",
"PARENTHESIZED LATIN SMALL LETTER W",
"PARENTHESIZED LATIN SMALL LETTER X",
"PARENTHESIZED LATIN SMALL LETTER Y",
"PARENTHESIZED LATIN SMALL LETTER Z",
"CIRCLED LATIN CAPITAL LETTER A",
"CIRCLED LATIN CAPITAL LETTER B",
"CIRCLED LATIN CAPITAL LETTER C",
"CIRCLED LATIN CAPITAL LETTER D",
"CIRCLED LATIN CAPITAL LETTER E",
"CIRCLED LATIN CAPITAL LETTER F",
"CIRCLED LATIN CAPITAL LETTER G",
"CIRCLED LATIN CAPITAL LETTER H",
"CIRCLED LATIN CAPITAL LETTER I",
"CIRCLED LATIN CAPITAL LETTER J",
"CIRCLED LATIN CAPITAL LETTER K",
"CIRCLED LATIN CAPITAL LETTER L",
"CIRCLED LATIN CAPITAL LETTER M",
"CIRCLED LATIN CAPITAL LETTER N",
"CIRCLED LATIN CAPITAL LETTER O",
"CIRCLED LATIN CAPITAL LETTER P",
"CIRCLED LATIN CAPITAL LETTER Q",
"CIRCLED LATIN CAPITAL LETTER R",
"CIRCLED LATIN CAPITAL LETTER S",
"CIRCLED LATIN CAPITAL LETTER T",
"CIRCLED LATIN CAPITAL LETTER U",
"CIRCLED LATIN CAPITAL LETTER V",
"CIRCLED LATIN CAPITAL LETTER W",
"CIRCLED LATIN CAPITAL LETTER X",
"CIRCLED LATIN CAPITAL LETTER Y",
"CIRCLED LATIN CAPITAL LETTER Z",
"CIRCLED LATIN SMALL LETTER A",
"CIRCLED LATIN SMALL LETTER B",
"CIRCLED LATIN SMALL LETTER C",
"CIRCLED LATIN SMALL LETTER D",
"CIRCLED LATIN SMALL LETTER E",
"CIRCLED LATIN SMALL LETTER F",
"CIRCLED LATIN SMALL LETTER G",
"CIRCLED LATIN SMALL LETTER H",
"CIRCLED LATIN SMALL LETTER I",
"CIRCLED LATIN SMALL LETTER J",
"CIRCLED LATIN SMALL LETTER K",
"CIRCLED LATIN SMALL LETTER L",
"CIRCLED LATIN SMALL LETTER M",
"CIRCLED LATIN SMALL LETTER N",
"CIRCLED LATIN SMALL LETTER O",
"CIRCLED LATIN SMALL LETTER P",
"CIRCLED LATIN SMALL LETTER Q",
"CIRCLED LATIN SMALL LETTER R",
"CIRCLED LATIN SMALL LETTER S",
"CIRCLED LATIN SMALL LETTER T",
"CIRCLED LATIN SMALL LETTER U",
"CIRCLED LATIN SMALL LETTER V",
"CIRCLED LATIN SMALL LETTER W",
"CIRCLED LATIN SMALL LETTER X",
"CIRCLED LATIN SMALL LETTER Y",
"CIRCLED LATIN SMALL LETTER Z",
"CIRCLED DIGIT ZERO",
"NEGATIVE CIRCLED NUMBER ELEVEN",
"NEGATIVE CIRCLED NUMBER TWELVE",
"NEGATIVE CIRCLED NUMBER THIRTEEN",
"NEGATIVE CIRCLED NUMBER FOURTEEN",
"NEGATIVE CIRCLED NUMBER FIFTEEN",
"NEGATIVE CIRCLED NUMBER SIXTEEN",
"NEGATIVE CIRCLED NUMBER SEVENTEEN",
"NEGATIVE CIRCLED NUMBER EIGHTEEN",
"NEGATIVE CIRCLED NUMBER NINETEEN",
"NEGATIVE CIRCLED NUMBER TWENTY",
"DOUBLE CIRCLED DIGIT ONE",
"DOUBLE CIRCLED DIGIT TWO",
"DOUBLE CIRCLED DIGIT THREE",
"DOUBLE CIRCLED DIGIT FOUR",
"DOUBLE CIRCLED DIGIT FIVE",
"DOUBLE CIRCLED DIGIT SIX",
"DOUBLE CIRCLED DIGIT SEVEN",
"DOUBLE CIRCLED DIGIT EIGHT",
"DOUBLE CIRCLED DIGIT NINE",
"DOUBLE CIRCLED NUMBER TEN",
"NEGATIVE CIRCLED DIGIT ZERO"};
static const char * name_0025[256] =
{
"BOX DRAWINGS LIGHT HORIZONTAL",
"BOX DRAWINGS HEAVY HORIZONTAL",
"BOX DRAWINGS LIGHT VERTICAL",
"BOX DRAWINGS HEAVY VERTICAL",
"BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL",
"BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL",
"BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL",
"BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL",
"BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL",
"BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL",
"BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL",
"BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL",
"BOX DRAWINGS LIGHT DOWN AND RIGHT",
"BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY",
"BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT",
"BOX DRAWINGS HEAVY DOWN AND RIGHT",
"BOX DRAWINGS LIGHT DOWN AND LEFT",
"BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY",
"BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT",
"BOX DRAWINGS HEAVY DOWN AND LEFT",
"BOX DRAWINGS LIGHT UP AND RIGHT",
"BOX DRAWINGS UP LIGHT AND RIGHT HEAVY",
"BOX DRAWINGS UP HEAVY AND RIGHT LIGHT",
"BOX DRAWINGS HEAVY UP AND RIGHT",
"BOX DRAWINGS LIGHT UP AND LEFT",
"BOX DRAWINGS UP LIGHT AND LEFT HEAVY",
"BOX DRAWINGS UP HEAVY AND LEFT LIGHT",
"BOX DRAWINGS HEAVY UP AND LEFT",
"BOX DRAWINGS LIGHT VERTICAL AND RIGHT",
"BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY",
"BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT",
"BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT",
"BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT",
"BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY",
"BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY",
"BOX DRAWINGS HEAVY VERTICAL AND RIGHT",
"BOX DRAWINGS LIGHT VERTICAL AND LEFT",
"BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY",
"BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT",
"BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT",
"BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT",
"BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY",
"BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY",
"BOX DRAWINGS HEAVY VERTICAL AND LEFT",
"BOX DRAWINGS LIGHT DOWN AND HORIZONTAL",
"BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT",
"BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT",
"BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY",
"BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT",
"BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY",
"BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY",
"BOX DRAWINGS HEAVY DOWN AND HORIZONTAL",
"BOX DRAWINGS LIGHT UP AND HORIZONTAL",
"BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT",
"BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT",
"BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY",
"BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT",
"BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY",
"BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY",
"BOX DRAWINGS HEAVY UP AND HORIZONTAL",
"BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL",
"BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT",
"BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT",
"BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY",
"BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT",
"BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT",
"BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT",
"BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT",
"BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT",
"BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT",
"BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT",
"BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY",
"BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY",
"BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY",
"BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY",
"BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL",
"BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL",
"BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL",
"BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL",
"BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL",
"BOX DRAWINGS DOUBLE HORIZONTAL",
"BOX DRAWINGS DOUBLE VERTICAL",
"BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE",
"BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE",
"BOX DRAWINGS DOUBLE DOWN AND RIGHT",
"BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE",
"BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE",
"BOX DRAWINGS DOUBLE DOWN AND LEFT",
"BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE",
"BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE",
"BOX DRAWINGS DOUBLE UP AND RIGHT",
"BOX DRAWINGS UP SINGLE AND LEFT DOUBLE",
"BOX DRAWINGS UP DOUBLE AND LEFT SINGLE",
"BOX DRAWINGS DOUBLE UP AND LEFT",
"BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE",
"BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE",
"BOX DRAWINGS DOUBLE VERTICAL AND RIGHT",
"BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE",
"BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE",
"BOX DRAWINGS DOUBLE VERTICAL AND LEFT",
"BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE",
"BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE",
"BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL",
"BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE",
"BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE",
"BOX DRAWINGS DOUBLE UP AND HORIZONTAL",
"BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE",
"BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE",
"BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL",
"BOX DRAWINGS LIGHT ARC DOWN AND RIGHT",
"BOX DRAWINGS LIGHT ARC DOWN AND LEFT",
"BOX DRAWINGS LIGHT ARC UP AND LEFT",
"BOX DRAWINGS LIGHT ARC UP AND RIGHT",
"BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT",
"BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT",
"BOX DRAWINGS LIGHT DIAGONAL CROSS",
"BOX DRAWINGS LIGHT LEFT",
"BOX DRAWINGS LIGHT UP",
"BOX DRAWINGS LIGHT RIGHT",
"BOX DRAWINGS LIGHT DOWN",
"BOX DRAWINGS HEAVY LEFT",
"BOX DRAWINGS HEAVY UP",
"BOX DRAWINGS HEAVY RIGHT",
"BOX DRAWINGS HEAVY DOWN",
"BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT",
"BOX DRAWINGS LIGHT UP AND HEAVY DOWN",
"BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT",
"BOX DRAWINGS HEAVY UP AND LIGHT DOWN",
"UPPER HALF BLOCK",
"LOWER ONE EIGHTH BLOCK",
"LOWER ONE QUARTER BLOCK",
"LOWER THREE EIGHTHS BLOCK",
"LOWER HALF BLOCK",
"LOWER FIVE EIGHTHS BLOCK",
"LOWER THREE QUARTERS BLOCK",
"LOWER SEVEN EIGHTHS BLOCK",
"FULL BLOCK",
"LEFT SEVEN EIGHTHS BLOCK",
"LEFT THREE QUARTERS BLOCK",
"LEFT FIVE EIGHTHS BLOCK",
"LEFT HALF BLOCK",
"LEFT THREE EIGHTHS BLOCK",
"LEFT ONE QUARTER BLOCK",
"LEFT ONE EIGHTH BLOCK",
"RIGHT HALF BLOCK",
"LIGHT SHADE",
"MEDIUM SHADE",
"DARK SHADE",
"UPPER ONE EIGHTH BLOCK",
"RIGHT ONE EIGHTH BLOCK",
"QUADRANT LOWER LEFT",
"QUADRANT LOWER RIGHT",
"QUADRANT UPPER LEFT",
"QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT",
"QUADRANT UPPER LEFT AND LOWER RIGHT",
"QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT",
"QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT",
"QUADRANT UPPER RIGHT",
"QUADRANT UPPER RIGHT AND LOWER LEFT",
"QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT",
"BLACK SQUARE",
"WHITE SQUARE",
"WHITE SQUARE WITH ROUNDED CORNERS",
"WHITE SQUARE CONTAINING BLACK SMALL SQUARE",
"SQUARE WITH HORIZONTAL FILL",
"SQUARE WITH VERTICAL FILL",
"SQUARE WITH ORTHOGONAL CROSSHATCH FILL",
"SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL",
"SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL",
"SQUARE WITH DIAGONAL CROSSHATCH FILL",
"BLACK SMALL SQUARE",
"WHITE SMALL SQUARE",
"BLACK RECTANGLE",
"WHITE RECTANGLE",
"BLACK VERTICAL RECTANGLE",
"WHITE VERTICAL RECTANGLE",
"BLACK PARALLELOGRAM",
"WHITE PARALLELOGRAM",
"BLACK UP-POINTING TRIANGLE",
"WHITE UP-POINTING TRIANGLE",
"BLACK UP-POINTING SMALL TRIANGLE",
"WHITE UP-POINTING SMALL TRIANGLE",
"BLACK RIGHT-POINTING TRIANGLE",
"WHITE RIGHT-POINTING TRIANGLE",
"BLACK RIGHT-POINTING SMALL TRIANGLE",
"WHITE RIGHT-POINTING SMALL TRIANGLE",
"BLACK RIGHT-POINTING POINTER",
"WHITE RIGHT-POINTING POINTER",
"BLACK DOWN-POINTING TRIANGLE",
"WHITE DOWN-POINTING TRIANGLE",
"BLACK DOWN-POINTING SMALL TRIANGLE",
"WHITE DOWN-POINTING SMALL TRIANGLE",
"BLACK LEFT-POINTING TRIANGLE",
"WHITE LEFT-POINTING TRIANGLE",
"BLACK LEFT-POINTING SMALL TRIANGLE",
"WHITE LEFT-POINTING SMALL TRIANGLE",
"BLACK LEFT-POINTING POINTER",
"WHITE LEFT-POINTING POINTER",
"BLACK DIAMOND",
"WHITE DIAMOND",
"WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND",
"FISHEYE",
"LOZENGE",
"WHITE CIRCLE",
"DOTTED CIRCLE",
"CIRCLE WITH VERTICAL FILL",
"BULLSEYE",
"BLACK CIRCLE",
"CIRCLE WITH LEFT HALF BLACK",
"CIRCLE WITH RIGHT HALF BLACK",
"CIRCLE WITH LOWER HALF BLACK",
"CIRCLE WITH UPPER HALF BLACK",
"CIRCLE WITH UPPER RIGHT QUADRANT BLACK",
"CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK",
"LEFT HALF BLACK CIRCLE",
"RIGHT HALF BLACK CIRCLE",
"INVERSE BULLET",
"INVERSE WHITE CIRCLE",
"UPPER HALF INVERSE WHITE CIRCLE",
"LOWER HALF INVERSE WHITE CIRCLE",
"UPPER LEFT QUADRANT CIRCULAR ARC",
"UPPER RIGHT QUADRANT CIRCULAR ARC",
"LOWER RIGHT QUADRANT CIRCULAR ARC",
"LOWER LEFT QUADRANT CIRCULAR ARC",
"UPPER HALF CIRCLE",
"LOWER HALF CIRCLE",
"BLACK LOWER RIGHT TRIANGLE",
"BLACK LOWER LEFT TRIANGLE",
"BLACK UPPER LEFT TRIANGLE",
"BLACK UPPER RIGHT TRIANGLE",
"WHITE BULLET",
"SQUARE WITH LEFT HALF BLACK",
"SQUARE WITH RIGHT HALF BLACK",
"SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK",
"SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK",
"WHITE SQUARE WITH VERTICAL BISECTING LINE",
"WHITE UP-POINTING TRIANGLE WITH DOT",
"UP-POINTING TRIANGLE WITH LEFT HALF BLACK",
"UP-POINTING TRIANGLE WITH RIGHT HALF BLACK",
"LARGE CIRCLE",
"WHITE SQUARE WITH UPPER LEFT QUADRANT",
"WHITE SQUARE WITH LOWER LEFT QUADRANT",
"WHITE SQUARE WITH LOWER RIGHT QUADRANT",
"WHITE SQUARE WITH UPPER RIGHT QUADRANT",
"WHITE CIRCLE WITH UPPER LEFT QUADRANT",
"WHITE CIRCLE WITH LOWER LEFT QUADRANT",
"WHITE CIRCLE WITH LOWER RIGHT QUADRANT",
"WHITE CIRCLE WITH UPPER RIGHT QUADRANT",
"UPPER LEFT TRIANGLE",
"UPPER RIGHT TRIANGLE",
"LOWER LEFT TRIANGLE",
"WHITE MEDIUM SQUARE",
"BLACK MEDIUM SQUARE",
"WHITE MEDIUM SMALL SQUARE",
"BLACK MEDIUM SMALL SQUARE",
"LOWER RIGHT TRIANGLE"};
static const char * name_0026[256] =
{
"BLACK SUN WITH RAYS",
"CLOUD",
"UMBRELLA",
"SNOWMAN",
"COMET",
"BLACK STAR",
"WHITE STAR",
"LIGHTNING",
"THUNDERSTORM",
"SUN",
"ASCENDING NODE",
"DESCENDING NODE",
"CONJUNCTION",
"OPPOSITION",
"BLACK TELEPHONE",
"WHITE TELEPHONE",
"BALLOT BOX",
"BALLOT BOX WITH CHECK",
"BALLOT BOX WITH X",
"SALTIRE",
"UMBRELLA WITH RAIN DROPS",
"HOT BEVERAGE",
"WHITE SHOGI PIECE",
"BLACK SHOGI PIECE",
"SHAMROCK",
"REVERSED ROTATED FLORAL HEART BULLET",
"BLACK LEFT POINTING INDEX",
"BLACK RIGHT POINTING INDEX",
"WHITE LEFT POINTING INDEX",
"WHITE UP POINTING INDEX",
"WHITE RIGHT POINTING INDEX",
"WHITE DOWN POINTING INDEX",
"SKULL AND CROSSBONES",
"CAUTION SIGN",
"RADIOACTIVE SIGN",
"BIOHAZARD SIGN",
"CADUCEUS",
"ANKH",
"ORTHODOX CROSS",
"CHI RHO",
"CROSS OF LORRAINE",
"CROSS OF JERUSALEM",
"STAR AND CRESCENT",
"FARSI SYMBOL",
"ADI SHAKTI",
"HAMMER AND SICKLE",
"PEACE SYMBOL",
"YIN YANG",
"TRIGRAM FOR HEAVEN",
"TRIGRAM FOR LAKE",
"TRIGRAM FOR FIRE",
"TRIGRAM FOR THUNDER",
"TRIGRAM FOR WIND",
"TRIGRAM FOR WATER",
"TRIGRAM FOR MOUNTAIN",
"TRIGRAM FOR EARTH",
"WHEEL OF DHARMA",
"WHITE FROWNING FACE",
"WHITE SMILING FACE",
"BLACK SMILING FACE",
"WHITE SUN WITH RAYS",
"FIRST QUARTER MOON",
"LAST QUARTER MOON",
"MERCURY",
"FEMALE SIGN",
"EARTH",
"MALE SIGN",
"JUPITER",
"SATURN",
"URANUS",
"NEPTUNE",
"PLUTO",
"ARIES",
"TAURUS",
"GEMINI",
"CANCER",
"LEO",
"VIRGO",
"LIBRA",
"SCORPIUS",
"SAGITTARIUS",
"CAPRICORN",
"AQUARIUS",
"PISCES",
"WHITE CHESS KING",
"WHITE CHESS QUEEN",
"WHITE CHESS ROOK",
"WHITE CHESS BISHOP",
"WHITE CHESS KNIGHT",
"WHITE CHESS PAWN",
"BLACK CHESS KING",
"BLACK CHESS QUEEN",
"BLACK CHESS ROOK",
"BLACK CHESS BISHOP",
"BLACK CHESS KNIGHT",
"BLACK CHESS PAWN",
"BLACK SPADE SUIT",
"WHITE HEART SUIT",
"WHITE DIAMOND SUIT",
"BLACK CLUB SUIT",
"WHITE SPADE SUIT",
"BLACK HEART SUIT",
"BLACK DIAMOND SUIT",
"WHITE CLUB SUIT",
"HOT SPRINGS",
"QUARTER NOTE",
"EIGHTH NOTE",
"BEAMED EIGHTH NOTES",
"BEAMED SIXTEENTH NOTES",
"MUSIC FLAT SIGN",
"MUSIC NATURAL SIGN",
"MUSIC SHARP SIGN",
"WEST SYRIAC CROSS",
"EAST SYRIAC CROSS",
"UNIVERSAL RECYCLING SYMBOL",
"RECYCLING SYMBOL FOR TYPE-1 PLASTICS",
"RECYCLING SYMBOL FOR TYPE-2 PLASTICS",
"RECYCLING SYMBOL FOR TYPE-3 PLASTICS",
"RECYCLING SYMBOL FOR TYPE-4 PLASTICS",
"RECYCLING SYMBOL FOR TYPE-5 PLASTICS",
"RECYCLING SYMBOL FOR TYPE-6 PLASTICS",
"RECYCLING SYMBOL FOR TYPE-7 PLASTICS",
"RECYCLING SYMBOL FOR GENERIC MATERIALS",
"BLACK UNIVERSAL RECYCLING SYMBOL",
"RECYCLED PAPER SYMBOL",
"PARTIALLY-RECYCLED PAPER SYMBOL",
"PERMANENT PAPER SIGN",
"WHEELCHAIR SYMBOL",
"DIE FACE-1",
"DIE FACE-2",
"DIE FACE-3",
"DIE FACE-4",
"DIE FACE-5",
"DIE FACE-6",
"WHITE CIRCLE WITH DOT RIGHT",
"WHITE CIRCLE WITH TWO DOTS",
"BLACK CIRCLE WITH WHITE DOT RIGHT",
"BLACK CIRCLE WITH TWO WHITE DOTS",
"MONOGRAM FOR YANG",
"MONOGRAM FOR YIN",
"DIGRAM FOR GREATER YANG",
"DIGRAM FOR LESSER YIN",
"DIGRAM FOR LESSER YANG",
"DIGRAM FOR GREATER YIN",
"WHITE FLAG",
"BLACK FLAG",
"HAMMER AND PICK",
"ANCHOR",
"CROSSED SWORDS",
"STAFF OF AESCULAPIUS",
"SCALES",
"ALEMBIC",
"FLOWER",
"GEAR",
"STAFF OF HERMES",
"ATOM SYMBOL",
"FLEUR-DE-LIS",
name_reserved,
name_reserved,
name_reserved,
"WARNING SIGN",
"HIGH VOLTAGE SIGN",
"DOUBLED FEMALE SIGN",
"DOUBLED MALE SIGN",
"INTERLOCKED FEMALE AND MALE SIGN",
"MALE AND FEMALE SIGN",
"MALE WITH STROKE SIGN",
"MALE WITH STROKE AND MALE AND FEMALE SIGN",
"VERTICAL MALE WITH STROKE SIGN",
"HORIZONTAL MALE WITH STROKE SIGN",
"MEDIUM WHITE CIRCLE",
"MEDIUM BLACK CIRCLE",
"MEDIUM SMALL WHITE CIRCLE",
"MARRIAGE SYMBOL",
"DIVORCE SYMBOL",
"UNMARRIED PARTNERSHIP SYMBOL",
"COFFIN",
"FUNERAL URN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0027[256] =
{
name_reserved,
"UPPER BLADE SCISSORS",
"BLACK SCISSORS",
"LOWER BLADE SCISSORS",
"WHITE SCISSORS",
name_reserved,
"TELEPHONE LOCATION SIGN",
"TAPE DRIVE",
"AIRPLANE",
"ENVELOPE",
name_reserved,
name_reserved,
"VICTORY HAND",
"WRITING HAND",
"LOWER RIGHT PENCIL",
"PENCIL",
"UPPER RIGHT PENCIL",
"WHITE NIB",
"BLACK NIB",
"CHECK MARK",
"HEAVY CHECK MARK",
"MULTIPLICATION X",
"HEAVY MULTIPLICATION X",
"BALLOT X",
"HEAVY BALLOT X",
"OUTLINED GREEK CROSS",
"HEAVY GREEK CROSS",
"OPEN CENTRE CROSS",
"HEAVY OPEN CENTRE CROSS",
"LATIN CROSS",
"SHADOWED WHITE LATIN CROSS",
"OUTLINED LATIN CROSS",
"MALTESE CROSS",
"STAR OF DAVID",
"FOUR TEARDROP-SPOKED ASTERISK",
"FOUR BALLOON-SPOKED ASTERISK",
"HEAVY FOUR BALLOON-SPOKED ASTERISK",
"FOUR CLUB-SPOKED ASTERISK",
"BLACK FOUR POINTED STAR",
"WHITE FOUR POINTED STAR",
name_reserved,
"STRESS OUTLINED WHITE STAR",
"CIRCLED WHITE STAR",
"OPEN CENTRE BLACK STAR",
"BLACK CENTRE WHITE STAR",
"OUTLINED BLACK STAR",
"HEAVY OUTLINED BLACK STAR",
"PINWHEEL STAR",
"SHADOWED WHITE STAR",
"HEAVY ASTERISK",
"OPEN CENTRE ASTERISK",
"EIGHT SPOKED ASTERISK",
"EIGHT POINTED BLACK STAR",
"EIGHT POINTED PINWHEEL STAR",
"SIX POINTED BLACK STAR",
"EIGHT POINTED RECTILINEAR BLACK STAR",
"HEAVY EIGHT POINTED RECTILINEAR BLACK STAR",
"TWELVE POINTED BLACK STAR",
"SIXTEEN POINTED ASTERISK",
"TEARDROP-SPOKED ASTERISK",
"OPEN CENTRE TEARDROP-SPOKED ASTERISK",
"HEAVY TEARDROP-SPOKED ASTERISK",
"SIX PETALLED BLACK AND WHITE FLORETTE",
"BLACK FLORETTE",
"WHITE FLORETTE",
"EIGHT PETALLED OUTLINED BLACK FLORETTE",
"CIRCLED OPEN CENTRE EIGHT POINTED STAR",
"HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK",
"SNOWFLAKE",
"TIGHT TRIFOLIATE SNOWFLAKE",
"HEAVY CHEVRON SNOWFLAKE",
"SPARKLE",
"HEAVY SPARKLE",
"BALLOON-SPOKED ASTERISK",
"EIGHT TEARDROP-SPOKED PROPELLER ASTERISK",
"HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK",
name_reserved,
"SHADOWED WHITE CIRCLE",
name_reserved,
"LOWER RIGHT DROP-SHADOWED WHITE SQUARE",
"UPPER RIGHT DROP-SHADOWED WHITE SQUARE",
"LOWER RIGHT SHADOWED WHITE SQUARE",
"UPPER RIGHT SHADOWED WHITE SQUARE",
name_reserved,
name_reserved,
name_reserved,
"BLACK DIAMOND MINUS WHITE X",
name_reserved,
"LIGHT VERTICAL BAR",
"MEDIUM VERTICAL BAR",
"HEAVY VERTICAL BAR",
"HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT",
"HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT",
"HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT",
"HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT",
name_reserved,
name_reserved,
"CURVED STEM PARAGRAPH SIGN ORNAMENT",
"HEAVY EXCLAMATION MARK ORNAMENT",
"HEAVY HEART EXCLAMATION MARK ORNAMENT",
"HEAVY BLACK HEART",
"ROTATED HEAVY BLACK HEART BULLET",
"FLORAL HEART",
"ROTATED FLORAL HEART BULLET",
"MEDIUM LEFT PARENTHESIS ORNAMENT",
"MEDIUM RIGHT PARENTHESIS ORNAMENT",
"MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT",
"MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT",
"MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT",
"MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT",
"HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT",
"HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT",
"HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT",
"HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT",
"LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT",
"LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT",
"MEDIUM LEFT CURLY BRACKET ORNAMENT",
"MEDIUM RIGHT CURLY BRACKET ORNAMENT",
"DINGBAT NEGATIVE CIRCLED DIGIT ONE",
"DINGBAT NEGATIVE CIRCLED DIGIT TWO",
"DINGBAT NEGATIVE CIRCLED DIGIT THREE",
"DINGBAT NEGATIVE CIRCLED DIGIT FOUR",
"DINGBAT NEGATIVE CIRCLED DIGIT FIVE",
"DINGBAT NEGATIVE CIRCLED DIGIT SIX",
"DINGBAT NEGATIVE CIRCLED DIGIT SEVEN",
"DINGBAT NEGATIVE CIRCLED DIGIT EIGHT",
"DINGBAT NEGATIVE CIRCLED DIGIT NINE",
"DINGBAT NEGATIVE CIRCLED NUMBER TEN",
"DINGBAT CIRCLED SANS-SERIF DIGIT ONE",
"DINGBAT CIRCLED SANS-SERIF DIGIT TWO",
"DINGBAT CIRCLED SANS-SERIF DIGIT THREE",
"DINGBAT CIRCLED SANS-SERIF DIGIT FOUR",
"DINGBAT CIRCLED SANS-SERIF DIGIT FIVE",
"DINGBAT CIRCLED SANS-SERIF DIGIT SIX",
"DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN",
"DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT",
"DINGBAT CIRCLED SANS-SERIF DIGIT NINE",
"DINGBAT CIRCLED SANS-SERIF NUMBER TEN",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE",
"DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN",
"HEAVY WIDE-HEADED RIGHTWARDS ARROW",
name_reserved,
name_reserved,
name_reserved,
"HEAVY SOUTH EAST ARROW",
"HEAVY RIGHTWARDS ARROW",
"HEAVY NORTH EAST ARROW",
"DRAFTING POINT RIGHTWARDS ARROW",
"HEAVY ROUND-TIPPED RIGHTWARDS ARROW",
"TRIANGLE-HEADED RIGHTWARDS ARROW",
"HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW",
"DASHED TRIANGLE-HEADED RIGHTWARDS ARROW",
"HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW",
"BLACK RIGHTWARDS ARROW",
"THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD",
"THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD",
"BLACK RIGHTWARDS ARROWHEAD",
"HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW",
"HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW",
"SQUAT BLACK RIGHTWARDS ARROW",
"HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW",
"RIGHT-SHADED WHITE RIGHTWARDS ARROW",
"LEFT-SHADED WHITE RIGHTWARDS ARROW",
"BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW",
"FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW",
"HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
"HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
"NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
name_reserved,
"NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
"CIRCLED HEAVY WHITE RIGHTWARDS ARROW",
"WHITE-FEATHERED RIGHTWARDS ARROW",
"BLACK-FEATHERED SOUTH EAST ARROW",
"BLACK-FEATHERED RIGHTWARDS ARROW",
"BLACK-FEATHERED NORTH EAST ARROW",
"HEAVY BLACK-FEATHERED SOUTH EAST ARROW",
"HEAVY BLACK-FEATHERED RIGHTWARDS ARROW",
"HEAVY BLACK-FEATHERED NORTH EAST ARROW",
"TEARDROP-BARBED RIGHTWARDS ARROW",
"HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW",
"WEDGE-TAILED RIGHTWARDS ARROW",
"HEAVY WEDGE-TAILED RIGHTWARDS ARROW",
"OPEN-OUTLINED RIGHTWARDS ARROW",
name_reserved,
"THREE DIMENSIONAL ANGLE",
"WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE",
"PERPENDICULAR",
"OPEN SUBSET",
"OPEN SUPERSET",
"LEFT S-SHAPED BAG DELIMITER",
"RIGHT S-SHAPED BAG DELIMITER",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"WHITE DIAMOND WITH CENTRED DOT",
"AND WITH DOT",
"ELEMENT OF OPENING UPWARDS",
"LOWER RIGHT CORNER WITH DOT",
"UPPER LEFT CORNER WITH DOT",
"LEFT OUTER JOIN",
"RIGHT OUTER JOIN",
"FULL OUTER JOIN",
"LARGE UP TACK",
"LARGE DOWN TACK",
"LEFT AND RIGHT DOUBLE TURNSTILE",
"LEFT AND RIGHT TACK",
"LEFT MULTIMAP",
"LONG RIGHT TACK",
"LONG LEFT TACK",
"UP TACK WITH CIRCLE ABOVE",
"LOZENGE DIVIDED BY HORIZONTAL RULE",
"WHITE CONCAVE-SIDED DIAMOND",
"WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK",
"WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK",
"WHITE SQUARE WITH LEFTWARDS TICK",
"WHITE SQUARE WITH RIGHTWARDS TICK",
"MATHEMATICAL LEFT WHITE SQUARE BRACKET",
"MATHEMATICAL RIGHT WHITE SQUARE BRACKET",
"MATHEMATICAL LEFT ANGLE BRACKET",
"MATHEMATICAL RIGHT ANGLE BRACKET",
"MATHEMATICAL LEFT DOUBLE ANGLE BRACKET",
"MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"UPWARDS QUADRUPLE ARROW",
"DOWNWARDS QUADRUPLE ARROW",
"ANTICLOCKWISE GAPPED CIRCLE ARROW",
"CLOCKWISE GAPPED CIRCLE ARROW",
"RIGHT ARROW WITH CIRCLED PLUS",
"LONG LEFTWARDS ARROW",
"LONG RIGHTWARDS ARROW",
"LONG LEFT RIGHT ARROW",
"LONG LEFTWARDS DOUBLE ARROW",
"LONG RIGHTWARDS DOUBLE ARROW",
"LONG LEFT RIGHT DOUBLE ARROW",
"LONG LEFTWARDS ARROW FROM BAR",
"LONG RIGHTWARDS ARROW FROM BAR",
"LONG LEFTWARDS DOUBLE ARROW FROM BAR",
"LONG RIGHTWARDS DOUBLE ARROW FROM BAR",
"LONG RIGHTWARDS SQUIGGLE ARROW"};
static const char * name_0028[256] =
{
"BRAILLE PATTERN BLANK",
"BRAILLE PATTERN DOTS-1",
"BRAILLE PATTERN DOTS-2",
"BRAILLE PATTERN DOTS-12",
"BRAILLE PATTERN DOTS-3",
"BRAILLE PATTERN DOTS-13",
"BRAILLE PATTERN DOTS-23",
"BRAILLE PATTERN DOTS-123",
"BRAILLE PATTERN DOTS-4",
"BRAILLE PATTERN DOTS-14",
"BRAILLE PATTERN DOTS-24",
"BRAILLE PATTERN DOTS-124",
"BRAILLE PATTERN DOTS-34",
"BRAILLE PATTERN DOTS-134",
"BRAILLE PATTERN DOTS-234",
"BRAILLE PATTERN DOTS-1234",
"BRAILLE PATTERN DOTS-5",
"BRAILLE PATTERN DOTS-15",
"BRAILLE PATTERN DOTS-25",
"BRAILLE PATTERN DOTS-125",
"BRAILLE PATTERN DOTS-35",
"BRAILLE PATTERN DOTS-135",
"BRAILLE PATTERN DOTS-235",
"BRAILLE PATTERN DOTS-1235",
"BRAILLE PATTERN DOTS-45",
"BRAILLE PATTERN DOTS-145",
"BRAILLE PATTERN DOTS-245",
"BRAILLE PATTERN DOTS-1245",
"BRAILLE PATTERN DOTS-345",
"BRAILLE PATTERN DOTS-1345",
"BRAILLE PATTERN DOTS-2345",
"BRAILLE PATTERN DOTS-12345",
"BRAILLE PATTERN DOTS-6",
"BRAILLE PATTERN DOTS-16",
"BRAILLE PATTERN DOTS-26",
"BRAILLE PATTERN DOTS-126",
"BRAILLE PATTERN DOTS-36",
"BRAILLE PATTERN DOTS-136",
"BRAILLE PATTERN DOTS-236",
"BRAILLE PATTERN DOTS-1236",
"BRAILLE PATTERN DOTS-46",
"BRAILLE PATTERN DOTS-146",
"BRAILLE PATTERN DOTS-246",
"BRAILLE PATTERN DOTS-1246",
"BRAILLE PATTERN DOTS-346",
"BRAILLE PATTERN DOTS-1346",
"BRAILLE PATTERN DOTS-2346",
"BRAILLE PATTERN DOTS-12346",
"BRAILLE PATTERN DOTS-56",
"BRAILLE PATTERN DOTS-156",
"BRAILLE PATTERN DOTS-256",
"BRAILLE PATTERN DOTS-1256",
"BRAILLE PATTERN DOTS-356",
"BRAILLE PATTERN DOTS-1356",
"BRAILLE PATTERN DOTS-2356",
"BRAILLE PATTERN DOTS-12356",
"BRAILLE PATTERN DOTS-456",
"BRAILLE PATTERN DOTS-1456",
"BRAILLE PATTERN DOTS-2456",
"BRAILLE PATTERN DOTS-12456",
"BRAILLE PATTERN DOTS-3456",
"BRAILLE PATTERN DOTS-13456",
"BRAILLE PATTERN DOTS-23456",
"BRAILLE PATTERN DOTS-123456",
"BRAILLE PATTERN DOTS-7",
"BRAILLE PATTERN DOTS-17",
"BRAILLE PATTERN DOTS-27",
"BRAILLE PATTERN DOTS-127",
"BRAILLE PATTERN DOTS-37",
"BRAILLE PATTERN DOTS-137",
"BRAILLE PATTERN DOTS-237",
"BRAILLE PATTERN DOTS-1237",
"BRAILLE PATTERN DOTS-47",
"BRAILLE PATTERN DOTS-147",
"BRAILLE PATTERN DOTS-247",
"BRAILLE PATTERN DOTS-1247",
"BRAILLE PATTERN DOTS-347",
"BRAILLE PATTERN DOTS-1347",
"BRAILLE PATTERN DOTS-2347",
"BRAILLE PATTERN DOTS-12347",
"BRAILLE PATTERN DOTS-57",
"BRAILLE PATTERN DOTS-157",
"BRAILLE PATTERN DOTS-257",
"BRAILLE PATTERN DOTS-1257",
"BRAILLE PATTERN DOTS-357",
"BRAILLE PATTERN DOTS-1357",
"BRAILLE PATTERN DOTS-2357",
"BRAILLE PATTERN DOTS-12357",
"BRAILLE PATTERN DOTS-457",
"BRAILLE PATTERN DOTS-1457",
"BRAILLE PATTERN DOTS-2457",
"BRAILLE PATTERN DOTS-12457",
"BRAILLE PATTERN DOTS-3457",
"BRAILLE PATTERN DOTS-13457",
"BRAILLE PATTERN DOTS-23457",
"BRAILLE PATTERN DOTS-123457",
"BRAILLE PATTERN DOTS-67",
"BRAILLE PATTERN DOTS-167",
"BRAILLE PATTERN DOTS-267",
"BRAILLE PATTERN DOTS-1267",
"BRAILLE PATTERN DOTS-367",
"BRAILLE PATTERN DOTS-1367",
"BRAILLE PATTERN DOTS-2367",
"BRAILLE PATTERN DOTS-12367",
"BRAILLE PATTERN DOTS-467",
"BRAILLE PATTERN DOTS-1467",
"BRAILLE PATTERN DOTS-2467",
"BRAILLE PATTERN DOTS-12467",
"BRAILLE PATTERN DOTS-3467",
"BRAILLE PATTERN DOTS-13467",
"BRAILLE PATTERN DOTS-23467",
"BRAILLE PATTERN DOTS-123467",
"BRAILLE PATTERN DOTS-567",
"BRAILLE PATTERN DOTS-1567",
"BRAILLE PATTERN DOTS-2567",
"BRAILLE PATTERN DOTS-12567",
"BRAILLE PATTERN DOTS-3567",
"BRAILLE PATTERN DOTS-13567",
"BRAILLE PATTERN DOTS-23567",
"BRAILLE PATTERN DOTS-123567",
"BRAILLE PATTERN DOTS-4567",
"BRAILLE PATTERN DOTS-14567",
"BRAILLE PATTERN DOTS-24567",
"BRAILLE PATTERN DOTS-124567",
"BRAILLE PATTERN DOTS-34567",
"BRAILLE PATTERN DOTS-134567",
"BRAILLE PATTERN DOTS-234567",
"BRAILLE PATTERN DOTS-1234567",
"BRAILLE PATTERN DOTS-8",
"BRAILLE PATTERN DOTS-18",
"BRAILLE PATTERN DOTS-28",
"BRAILLE PATTERN DOTS-128",
"BRAILLE PATTERN DOTS-38",
"BRAILLE PATTERN DOTS-138",
"BRAILLE PATTERN DOTS-238",
"BRAILLE PATTERN DOTS-1238",
"BRAILLE PATTERN DOTS-48",
"BRAILLE PATTERN DOTS-148",
"BRAILLE PATTERN DOTS-248",
"BRAILLE PATTERN DOTS-1248",
"BRAILLE PATTERN DOTS-348",
"BRAILLE PATTERN DOTS-1348",
"BRAILLE PATTERN DOTS-2348",
"BRAILLE PATTERN DOTS-12348",
"BRAILLE PATTERN DOTS-58",
"BRAILLE PATTERN DOTS-158",
"BRAILLE PATTERN DOTS-258",
"BRAILLE PATTERN DOTS-1258",
"BRAILLE PATTERN DOTS-358",
"BRAILLE PATTERN DOTS-1358",
"BRAILLE PATTERN DOTS-2358",
"BRAILLE PATTERN DOTS-12358",
"BRAILLE PATTERN DOTS-458",
"BRAILLE PATTERN DOTS-1458",
"BRAILLE PATTERN DOTS-2458",
"BRAILLE PATTERN DOTS-12458",
"BRAILLE PATTERN DOTS-3458",
"BRAILLE PATTERN DOTS-13458",
"BRAILLE PATTERN DOTS-23458",
"BRAILLE PATTERN DOTS-123458",
"BRAILLE PATTERN DOTS-68",
"BRAILLE PATTERN DOTS-168",
"BRAILLE PATTERN DOTS-268",
"BRAILLE PATTERN DOTS-1268",
"BRAILLE PATTERN DOTS-368",
"BRAILLE PATTERN DOTS-1368",
"BRAILLE PATTERN DOTS-2368",
"BRAILLE PATTERN DOTS-12368",
"BRAILLE PATTERN DOTS-468",
"BRAILLE PATTERN DOTS-1468",
"BRAILLE PATTERN DOTS-2468",
"BRAILLE PATTERN DOTS-12468",
"BRAILLE PATTERN DOTS-3468",
"BRAILLE PATTERN DOTS-13468",
"BRAILLE PATTERN DOTS-23468",
"BRAILLE PATTERN DOTS-123468",
"BRAILLE PATTERN DOTS-568",
"BRAILLE PATTERN DOTS-1568",
"BRAILLE PATTERN DOTS-2568",
"BRAILLE PATTERN DOTS-12568",
"BRAILLE PATTERN DOTS-3568",
"BRAILLE PATTERN DOTS-13568",
"BRAILLE PATTERN DOTS-23568",
"BRAILLE PATTERN DOTS-123568",
"BRAILLE PATTERN DOTS-4568",
"BRAILLE PATTERN DOTS-14568",
"BRAILLE PATTERN DOTS-24568",
"BRAILLE PATTERN DOTS-124568",
"BRAILLE PATTERN DOTS-34568",
"BRAILLE PATTERN DOTS-134568",
"BRAILLE PATTERN DOTS-234568",
"BRAILLE PATTERN DOTS-1234568",
"BRAILLE PATTERN DOTS-78",
"BRAILLE PATTERN DOTS-178",
"BRAILLE PATTERN DOTS-278",
"BRAILLE PATTERN DOTS-1278",
"BRAILLE PATTERN DOTS-378",
"BRAILLE PATTERN DOTS-1378",
"BRAILLE PATTERN DOTS-2378",
"BRAILLE PATTERN DOTS-12378",
"BRAILLE PATTERN DOTS-478",
"BRAILLE PATTERN DOTS-1478",
"BRAILLE PATTERN DOTS-2478",
"BRAILLE PATTERN DOTS-12478",
"BRAILLE PATTERN DOTS-3478",
"BRAILLE PATTERN DOTS-13478",
"BRAILLE PATTERN DOTS-23478",
"BRAILLE PATTERN DOTS-123478",
"BRAILLE PATTERN DOTS-578",
"BRAILLE PATTERN DOTS-1578",
"BRAILLE PATTERN DOTS-2578",
"BRAILLE PATTERN DOTS-12578",
"BRAILLE PATTERN DOTS-3578",
"BRAILLE PATTERN DOTS-13578",
"BRAILLE PATTERN DOTS-23578",
"BRAILLE PATTERN DOTS-123578",
"BRAILLE PATTERN DOTS-4578",
"BRAILLE PATTERN DOTS-14578",
"BRAILLE PATTERN DOTS-24578",
"BRAILLE PATTERN DOTS-124578",
"BRAILLE PATTERN DOTS-34578",
"BRAILLE PATTERN DOTS-134578",
"BRAILLE PATTERN DOTS-234578",
"BRAILLE PATTERN DOTS-1234578",
"BRAILLE PATTERN DOTS-678",
"BRAILLE PATTERN DOTS-1678",
"BRAILLE PATTERN DOTS-2678",
"BRAILLE PATTERN DOTS-12678",
"BRAILLE PATTERN DOTS-3678",
"BRAILLE PATTERN DOTS-13678",
"BRAILLE PATTERN DOTS-23678",
"BRAILLE PATTERN DOTS-123678",
"BRAILLE PATTERN DOTS-4678",
"BRAILLE PATTERN DOTS-14678",
"BRAILLE PATTERN DOTS-24678",
"BRAILLE PATTERN DOTS-124678",
"BRAILLE PATTERN DOTS-34678",
"BRAILLE PATTERN DOTS-134678",
"BRAILLE PATTERN DOTS-234678",
"BRAILLE PATTERN DOTS-1234678",
"BRAILLE PATTERN DOTS-5678",
"BRAILLE PATTERN DOTS-15678",
"BRAILLE PATTERN DOTS-25678",
"BRAILLE PATTERN DOTS-125678",
"BRAILLE PATTERN DOTS-35678",
"BRAILLE PATTERN DOTS-135678",
"BRAILLE PATTERN DOTS-235678",
"BRAILLE PATTERN DOTS-1235678",
"BRAILLE PATTERN DOTS-45678",
"BRAILLE PATTERN DOTS-145678",
"BRAILLE PATTERN DOTS-245678",
"BRAILLE PATTERN DOTS-1245678",
"BRAILLE PATTERN DOTS-345678",
"BRAILLE PATTERN DOTS-1345678",
"BRAILLE PATTERN DOTS-2345678",
"BRAILLE PATTERN DOTS-12345678"};
static const char * name_0029[256] =
{
"RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE",
"RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE",
"LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE",
"RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE",
"LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE",
"RIGHTWARDS TWO-HEADED ARROW FROM BAR",
"LEFTWARDS DOUBLE ARROW FROM BAR",
"RIGHTWARDS DOUBLE ARROW FROM BAR",
"DOWNWARDS ARROW WITH HORIZONTAL STROKE",
"UPWARDS ARROW WITH HORIZONTAL STROKE",
"UPWARDS TRIPLE ARROW",
"DOWNWARDS TRIPLE ARROW",
"LEFTWARDS DOUBLE DASH ARROW",
"RIGHTWARDS DOUBLE DASH ARROW",
"LEFTWARDS TRIPLE DASH ARROW",
"RIGHTWARDS TRIPLE DASH ARROW",
"RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW",
"RIGHTWARDS ARROW WITH DOTTED STEM",
"UPWARDS ARROW TO BAR",
"DOWNWARDS ARROW TO BAR",
"RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE",
"RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
"RIGHTWARDS TWO-HEADED ARROW WITH TAIL",
"RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE",
"RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
"LEFTWARDS ARROW-TAIL",
"RIGHTWARDS ARROW-TAIL",
"LEFTWARDS DOUBLE ARROW-TAIL",
"RIGHTWARDS DOUBLE ARROW-TAIL",
"LEFTWARDS ARROW TO BLACK DIAMOND",
"RIGHTWARDS ARROW TO BLACK DIAMOND",
"LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND",
"RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND",
"NORTH WEST AND SOUTH EAST ARROW",
"NORTH EAST AND SOUTH WEST ARROW",
"NORTH WEST ARROW WITH HOOK",
"NORTH EAST ARROW WITH HOOK",
"SOUTH EAST ARROW WITH HOOK",
"SOUTH WEST ARROW WITH HOOK",
"NORTH WEST ARROW AND NORTH EAST ARROW",
"NORTH EAST ARROW AND SOUTH EAST ARROW",
"SOUTH EAST ARROW AND SOUTH WEST ARROW",
"SOUTH WEST ARROW AND NORTH WEST ARROW",
"RISING DIAGONAL CROSSING FALLING DIAGONAL",
"FALLING DIAGONAL CROSSING RISING DIAGONAL",
"SOUTH EAST ARROW CROSSING NORTH EAST ARROW",
"NORTH EAST ARROW CROSSING SOUTH EAST ARROW",
"FALLING DIAGONAL CROSSING NORTH EAST ARROW",
"RISING DIAGONAL CROSSING SOUTH EAST ARROW",
"NORTH EAST ARROW CROSSING NORTH WEST ARROW",
"NORTH WEST ARROW CROSSING NORTH EAST ARROW",
"WAVE ARROW POINTING DIRECTLY RIGHT",
"ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS",
"ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS",
"ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS",
"ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS",
"RIGHT-SIDE ARC CLOCKWISE ARROW",
"LEFT-SIDE ARC ANTICLOCKWISE ARROW",
"TOP ARC ANTICLOCKWISE ARROW",
"BOTTOM ARC ANTICLOCKWISE ARROW",
"TOP ARC CLOCKWISE ARROW WITH MINUS",
"TOP ARC ANTICLOCKWISE ARROW WITH PLUS",
"LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW",
"LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW",
"ANTICLOCKWISE CLOSED CIRCLE ARROW",
"CLOCKWISE CLOSED CIRCLE ARROW",
"RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW",
"LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW",
"SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW",
"RIGHTWARDS ARROW WITH PLUS BELOW",
"LEFTWARDS ARROW WITH PLUS BELOW",
"RIGHTWARDS ARROW THROUGH X",
"LEFT RIGHT ARROW THROUGH SMALL CIRCLE",
"UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE",
"LEFT BARB UP RIGHT BARB DOWN HARPOON",
"LEFT BARB DOWN RIGHT BARB UP HARPOON",
"UP BARB RIGHT DOWN BARB LEFT HARPOON",
"UP BARB LEFT DOWN BARB RIGHT HARPOON",
"LEFT BARB UP RIGHT BARB UP HARPOON",
"UP BARB RIGHT DOWN BARB RIGHT HARPOON",
"LEFT BARB DOWN RIGHT BARB DOWN HARPOON",
"UP BARB LEFT DOWN BARB LEFT HARPOON",
"LEFTWARDS HARPOON WITH BARB UP TO BAR",
"RIGHTWARDS HARPOON WITH BARB UP TO BAR",
"UPWARDS HARPOON WITH BARB RIGHT TO BAR",
"DOWNWARDS HARPOON WITH BARB RIGHT TO BAR",
"LEFTWARDS HARPOON WITH BARB DOWN TO BAR",
"RIGHTWARDS HARPOON WITH BARB DOWN TO BAR",
"UPWARDS HARPOON WITH BARB LEFT TO BAR",
"DOWNWARDS HARPOON WITH BARB LEFT TO BAR",
"LEFTWARDS HARPOON WITH BARB UP FROM BAR",
"RIGHTWARDS HARPOON WITH BARB UP FROM BAR",
"UPWARDS HARPOON WITH BARB RIGHT FROM BAR",
"DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR",
"LEFTWARDS HARPOON WITH BARB DOWN FROM BAR",
"RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR",
"UPWARDS HARPOON WITH BARB LEFT FROM BAR",
"DOWNWARDS HARPOON WITH BARB LEFT FROM BAR",
"LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN",
"UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT",
"RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN",
"DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT",
"LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP",
"LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN",
"RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP",
"RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN",
"LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH",
"LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH",
"RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH",
"RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH",
"UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT",
"DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT",
"RIGHT DOUBLE ARROW WITH ROUNDED HEAD",
"EQUALS SIGN ABOVE RIGHTWARDS ARROW",
"TILDE OPERATOR ABOVE RIGHTWARDS ARROW",
"LEFTWARDS ARROW ABOVE TILDE OPERATOR",
"RIGHTWARDS ARROW ABOVE TILDE OPERATOR",
"RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO",
"LESS-THAN ABOVE LEFTWARDS ARROW",
"LEFTWARDS ARROW THROUGH LESS-THAN",
"GREATER-THAN ABOVE RIGHTWARDS ARROW",
"SUBSET ABOVE RIGHTWARDS ARROW",
"LEFTWARDS ARROW THROUGH SUBSET",
"SUPERSET ABOVE LEFTWARDS ARROW",
"LEFT FISH TAIL",
"RIGHT FISH TAIL",
"UP FISH TAIL",
"DOWN FISH TAIL",
"TRIPLE VERTICAL BAR DELIMITER",
"Z NOTATION SPOT",
"Z NOTATION TYPE COLON",
"LEFT WHITE CURLY BRACKET",
"RIGHT WHITE CURLY BRACKET",
"LEFT WHITE PARENTHESIS",
"RIGHT WHITE PARENTHESIS",
"Z NOTATION LEFT IMAGE BRACKET",
"Z NOTATION RIGHT IMAGE BRACKET",
"Z NOTATION LEFT BINDING BRACKET",
"Z NOTATION RIGHT BINDING BRACKET",
"LEFT SQUARE BRACKET WITH UNDERBAR",
"RIGHT SQUARE BRACKET WITH UNDERBAR",
"LEFT SQUARE BRACKET WITH TICK IN TOP CORNER",
"RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER",
"LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER",
"RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER",
"LEFT ANGLE BRACKET WITH DOT",
"RIGHT ANGLE BRACKET WITH DOT",
"LEFT ARC LESS-THAN BRACKET",
"RIGHT ARC GREATER-THAN BRACKET",
"DOUBLE LEFT ARC GREATER-THAN BRACKET",
"DOUBLE RIGHT ARC LESS-THAN BRACKET",
"LEFT BLACK TORTOISE SHELL BRACKET",
"RIGHT BLACK TORTOISE SHELL BRACKET",
"DOTTED FENCE",
"VERTICAL ZIGZAG LINE",
"MEASURED ANGLE OPENING LEFT",
"RIGHT ANGLE VARIANT WITH SQUARE",
"MEASURED RIGHT ANGLE WITH DOT",
"ANGLE WITH S INSIDE",
"ACUTE ANGLE",
"SPHERICAL ANGLE OPENING LEFT",
"SPHERICAL ANGLE OPENING UP",
"TURNED ANGLE",
"REVERSED ANGLE",
"ANGLE WITH UNDERBAR",
"REVERSED ANGLE WITH UNDERBAR",
"OBLIQUE ANGLE OPENING UP",
"OBLIQUE ANGLE OPENING DOWN",
"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT",
"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT",
"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT",
"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT",
"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP",
"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP",
"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN",
"MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN",
"REVERSED EMPTY SET",
"EMPTY SET WITH OVERBAR",
"EMPTY SET WITH SMALL CIRCLE ABOVE",
"EMPTY SET WITH RIGHT ARROW ABOVE",
"EMPTY SET WITH LEFT ARROW ABOVE",
"CIRCLE WITH HORIZONTAL BAR",
"CIRCLED VERTICAL BAR",
"CIRCLED PARALLEL",
"CIRCLED REVERSE SOLIDUS",
"CIRCLED PERPENDICULAR",
"CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR",
"CIRCLE WITH SUPERIMPOSED X",
"CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN",
"UP ARROW THROUGH CIRCLE",
"CIRCLED WHITE BULLET",
"CIRCLED BULLET",
"CIRCLED LESS-THAN",
"CIRCLED GREATER-THAN",
"CIRCLE WITH SMALL CIRCLE TO THE RIGHT",
"CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT",
"SQUARED RISING DIAGONAL SLASH",
"SQUARED FALLING DIAGONAL SLASH",
"SQUARED ASTERISK",
"SQUARED SMALL CIRCLE",
"SQUARED SQUARE",
"TWO JOINED SQUARES",
"TRIANGLE WITH DOT ABOVE",
"TRIANGLE WITH UNDERBAR",
"S IN TRIANGLE",
"TRIANGLE WITH SERIFS AT BOTTOM",
"RIGHT TRIANGLE ABOVE LEFT TRIANGLE",
"LEFT TRIANGLE BESIDE VERTICAL BAR",
"VERTICAL BAR BESIDE RIGHT TRIANGLE",
"BOWTIE WITH LEFT HALF BLACK",
"BOWTIE WITH RIGHT HALF BLACK",
"BLACK BOWTIE",
"TIMES WITH LEFT HALF BLACK",
"TIMES WITH RIGHT HALF BLACK",
"WHITE HOURGLASS",
"BLACK HOURGLASS",
"LEFT WIGGLY FENCE",
"RIGHT WIGGLY FENCE",
"LEFT DOUBLE WIGGLY FENCE",
"RIGHT DOUBLE WIGGLY FENCE",
"INCOMPLETE INFINITY",
"TIE OVER INFINITY",
"INFINITY NEGATED WITH VERTICAL BAR",
"DOUBLE-ENDED MULTIMAP",
"SQUARE WITH CONTOURED OUTLINE",
"INCREASES AS",
"SHUFFLE PRODUCT",
"EQUALS SIGN AND SLANTED PARALLEL",
"EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE",
"IDENTICAL TO AND SLANTED PARALLEL",
"GLEICH STARK",
"THERMODYNAMIC",
"DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK",
"DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK",
"BLACK DIAMOND WITH DOWN ARROW",
"BLACK LOZENGE",
"WHITE CIRCLE WITH DOWN ARROW",
"BLACK CIRCLE WITH DOWN ARROW",
"ERROR-BARRED WHITE SQUARE",
"ERROR-BARRED BLACK SQUARE",
"ERROR-BARRED WHITE DIAMOND",
"ERROR-BARRED BLACK DIAMOND",
"ERROR-BARRED WHITE CIRCLE",
"ERROR-BARRED BLACK CIRCLE",
"RULE-DELAYED",
"REVERSE SOLIDUS OPERATOR",
"SOLIDUS WITH OVERBAR",
"REVERSE SOLIDUS WITH HORIZONTAL STROKE",
"BIG SOLIDUS",
"BIG REVERSE SOLIDUS",
"DOUBLE PLUS",
"TRIPLE PLUS",
"LEFT-POINTING CURVED ANGLE BRACKET",
"RIGHT-POINTING CURVED ANGLE BRACKET",
"TINY",
"MINY"};
static const char * name_002a[256] =
{
"N-ARY CIRCLED DOT OPERATOR",
"N-ARY CIRCLED PLUS OPERATOR",
"N-ARY CIRCLED TIMES OPERATOR",
"N-ARY UNION OPERATOR WITH DOT",
"N-ARY UNION OPERATOR WITH PLUS",
"N-ARY SQUARE INTERSECTION OPERATOR",
"N-ARY SQUARE UNION OPERATOR",
"TWO LOGICAL AND OPERATOR",
"TWO LOGICAL OR OPERATOR",
"N-ARY TIMES OPERATOR",
"MODULO TWO SUM",
"SUMMATION WITH INTEGRAL",
"QUADRUPLE INTEGRAL OPERATOR",
"FINITE PART INTEGRAL",
"INTEGRAL WITH DOUBLE STROKE",
"INTEGRAL AVERAGE WITH SLASH",
"CIRCULATION FUNCTION",
"ANTICLOCKWISE INTEGRATION",
"LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE",
"LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE",
"LINE INTEGRATION NOT INCLUDING THE POLE",
"INTEGRAL AROUND A POINT OPERATOR",
"QUATERNION INTEGRAL OPERATOR",
"INTEGRAL WITH LEFTWARDS ARROW WITH HOOK",
"INTEGRAL WITH TIMES SIGN",
"INTEGRAL WITH INTERSECTION",
"INTEGRAL WITH UNION",
"INTEGRAL WITH OVERBAR",
"INTEGRAL WITH UNDERBAR",
"JOIN",
"LARGE LEFT TRIANGLE OPERATOR",
"Z NOTATION SCHEMA COMPOSITION",
"Z NOTATION SCHEMA PIPING",
"Z NOTATION SCHEMA PROJECTION",
"PLUS SIGN WITH SMALL CIRCLE ABOVE",
"PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE",
"PLUS SIGN WITH TILDE ABOVE",
"PLUS SIGN WITH DOT BELOW",
"PLUS SIGN WITH TILDE BELOW",
"PLUS SIGN WITH SUBSCRIPT TWO",
"PLUS SIGN WITH BLACK TRIANGLE",
"MINUS SIGN WITH COMMA ABOVE",
"MINUS SIGN WITH DOT BELOW",
"MINUS SIGN WITH FALLING DOTS",
"MINUS SIGN WITH RISING DOTS",
"PLUS SIGN IN LEFT HALF CIRCLE",
"PLUS SIGN IN RIGHT HALF CIRCLE",
"VECTOR OR CROSS PRODUCT",
"MULTIPLICATION SIGN WITH DOT ABOVE",
"MULTIPLICATION SIGN WITH UNDERBAR",
"SEMIDIRECT PRODUCT WITH BOTTOM CLOSED",
"SMASH PRODUCT",
"MULTIPLICATION SIGN IN LEFT HALF CIRCLE",
"MULTIPLICATION SIGN IN RIGHT HALF CIRCLE",
"CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT",
"MULTIPLICATION SIGN IN DOUBLE CIRCLE",
"CIRCLED DIVISION SIGN",
"PLUS SIGN IN TRIANGLE",
"MINUS SIGN IN TRIANGLE",
"MULTIPLICATION SIGN IN TRIANGLE",
"INTERIOR PRODUCT",
"RIGHTHAND INTERIOR PRODUCT",
"Z NOTATION RELATIONAL COMPOSITION",
"AMALGAMATION OR COPRODUCT",
"INTERSECTION WITH DOT",
"UNION WITH MINUS SIGN",
"UNION WITH OVERBAR",
"INTERSECTION WITH OVERBAR",
"INTERSECTION WITH LOGICAL AND",
"UNION WITH LOGICAL OR",
"UNION ABOVE INTERSECTION",
"INTERSECTION ABOVE UNION",
"UNION ABOVE BAR ABOVE INTERSECTION",
"INTERSECTION ABOVE BAR ABOVE UNION",
"UNION BESIDE AND JOINED WITH UNION",
"INTERSECTION BESIDE AND JOINED WITH INTERSECTION",
"CLOSED UNION WITH SERIFS",
"CLOSED INTERSECTION WITH SERIFS",
"DOUBLE SQUARE INTERSECTION",
"DOUBLE SQUARE UNION",
"CLOSED UNION WITH SERIFS AND SMASH PRODUCT",
"LOGICAL AND WITH DOT ABOVE",
"LOGICAL OR WITH DOT ABOVE",
"DOUBLE LOGICAL AND",
"DOUBLE LOGICAL OR",
"TWO INTERSECTING LOGICAL AND",
"TWO INTERSECTING LOGICAL OR",
"SLOPING LARGE OR",
"SLOPING LARGE AND",
"LOGICAL OR OVERLAPPING LOGICAL AND",
"LOGICAL AND WITH MIDDLE STEM",
"LOGICAL OR WITH MIDDLE STEM",
"LOGICAL AND WITH HORIZONTAL DASH",
"LOGICAL OR WITH HORIZONTAL DASH",
"LOGICAL AND WITH DOUBLE OVERBAR",
"LOGICAL AND WITH UNDERBAR",
"LOGICAL AND WITH DOUBLE UNDERBAR",
"SMALL VEE WITH UNDERBAR",
"LOGICAL OR WITH DOUBLE OVERBAR",
"LOGICAL OR WITH DOUBLE UNDERBAR",
"Z NOTATION DOMAIN ANTIRESTRICTION",
"Z NOTATION RANGE ANTIRESTRICTION",
"EQUALS SIGN WITH DOT BELOW",
"IDENTICAL WITH DOT ABOVE",
"TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE",
"TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE",
"TILDE OPERATOR WITH DOT ABOVE",
"TILDE OPERATOR WITH RISING DOTS",
"SIMILAR MINUS SIMILAR",
"CONGRUENT WITH DOT ABOVE",
"EQUALS WITH ASTERISK",
"ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT",
"APPROXIMATELY EQUAL OR EQUAL TO",
"EQUALS SIGN ABOVE PLUS SIGN",
"PLUS SIGN ABOVE EQUALS SIGN",
"EQUALS SIGN ABOVE TILDE OPERATOR",
"DOUBLE COLON EQUAL",
"TWO CONSECUTIVE EQUALS SIGNS",
"THREE CONSECUTIVE EQUALS SIGNS",
"EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW",
"EQUIVALENT WITH FOUR DOTS ABOVE",
"LESS-THAN WITH CIRCLE INSIDE",
"GREATER-THAN WITH CIRCLE INSIDE",
"LESS-THAN WITH QUESTION MARK ABOVE",
"GREATER-THAN WITH QUESTION MARK ABOVE",
"LESS-THAN OR SLANTED EQUAL TO",
"GREATER-THAN OR SLANTED EQUAL TO",
"LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE",
"GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE",
"LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE",
"GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE",
"LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT",
"GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT",
"LESS-THAN OR APPROXIMATE",
"GREATER-THAN OR APPROXIMATE",
"LESS-THAN AND SINGLE-LINE NOT EQUAL TO",
"GREATER-THAN AND SINGLE-LINE NOT EQUAL TO",
"LESS-THAN AND NOT APPROXIMATE",
"GREATER-THAN AND NOT APPROXIMATE",
"LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN",
"GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN",
"LESS-THAN ABOVE SIMILAR OR EQUAL",
"GREATER-THAN ABOVE SIMILAR OR EQUAL",
"LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN",
"GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN",
"LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL",
"GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL",
"LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL",
"GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL",
"SLANTED EQUAL TO OR LESS-THAN",
"SLANTED EQUAL TO OR GREATER-THAN",
"SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE",
"SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE",
"DOUBLE-LINE EQUAL TO OR LESS-THAN",
"DOUBLE-LINE EQUAL TO OR GREATER-THAN",
"DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN",
"DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN",
"SIMILAR OR LESS-THAN",
"SIMILAR OR GREATER-THAN",
"SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN",
"SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN",
"DOUBLE NESTED LESS-THAN",
"DOUBLE NESTED GREATER-THAN",
"DOUBLE NESTED LESS-THAN WITH UNDERBAR",
"GREATER-THAN OVERLAPPING LESS-THAN",
"GREATER-THAN BESIDE LESS-THAN",
"LESS-THAN CLOSED BY CURVE",
"GREATER-THAN CLOSED BY CURVE",
"LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL",
"GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL",
"SMALLER THAN",
"LARGER THAN",
"SMALLER THAN OR EQUAL TO",
"LARGER THAN OR EQUAL TO",
"EQUALS SIGN WITH BUMPY ABOVE",
"PRECEDES ABOVE SINGLE-LINE EQUALS SIGN",
"SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN",
"PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO",
"SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO",
"PRECEDES ABOVE EQUALS SIGN",
"SUCCEEDS ABOVE EQUALS SIGN",
"PRECEDES ABOVE NOT EQUAL TO",
"SUCCEEDS ABOVE NOT EQUAL TO",
"PRECEDES ABOVE ALMOST EQUAL TO",
"SUCCEEDS ABOVE ALMOST EQUAL TO",
"PRECEDES ABOVE NOT ALMOST EQUAL TO",
"SUCCEEDS ABOVE NOT ALMOST EQUAL TO",
"DOUBLE PRECEDES",
"DOUBLE SUCCEEDS",
"SUBSET WITH DOT",
"SUPERSET WITH DOT",
"SUBSET WITH PLUS SIGN BELOW",
"SUPERSET WITH PLUS SIGN BELOW",
"SUBSET WITH MULTIPLICATION SIGN BELOW",
"SUPERSET WITH MULTIPLICATION SIGN BELOW",
"SUBSET OF OR EQUAL TO WITH DOT ABOVE",
"SUPERSET OF OR EQUAL TO WITH DOT ABOVE",
"SUBSET OF ABOVE EQUALS SIGN",
"SUPERSET OF ABOVE EQUALS SIGN",
"SUBSET OF ABOVE TILDE OPERATOR",
"SUPERSET OF ABOVE TILDE OPERATOR",
"SUBSET OF ABOVE ALMOST EQUAL TO",
"SUPERSET OF ABOVE ALMOST EQUAL TO",
"SUBSET OF ABOVE NOT EQUAL TO",
"SUPERSET OF ABOVE NOT EQUAL TO",
"SQUARE LEFT OPEN BOX OPERATOR",
"SQUARE RIGHT OPEN BOX OPERATOR",
"CLOSED SUBSET",
"CLOSED SUPERSET",
"CLOSED SUBSET OR EQUAL TO",
"CLOSED SUPERSET OR EQUAL TO",
"SUBSET ABOVE SUPERSET",
"SUPERSET ABOVE SUBSET",
"SUBSET ABOVE SUBSET",
"SUPERSET ABOVE SUPERSET",
"SUPERSET BESIDE SUBSET",
"SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET",
"ELEMENT OF OPENING DOWNWARDS",
"PITCHFORK WITH TEE TOP",
"TRANSVERSAL INTERSECTION",
"FORKING",
"NONFORKING",
"SHORT LEFT TACK",
"SHORT DOWN TACK",
"SHORT UP TACK",
"PERPENDICULAR WITH S",
"VERTICAL BAR TRIPLE RIGHT TURNSTILE",
"DOUBLE VERTICAL BAR LEFT TURNSTILE",
"VERTICAL BAR DOUBLE LEFT TURNSTILE",
"DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE",
"LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL",
"SHORT DOWN TACK WITH OVERBAR",
"SHORT UP TACK WITH UNDERBAR",
"SHORT UP TACK ABOVE SHORT DOWN TACK",
"DOUBLE DOWN TACK",
"DOUBLE UP TACK",
"DOUBLE STROKE NOT SIGN",
"REVERSED DOUBLE STROKE NOT SIGN",
"DOES NOT DIVIDE WITH REVERSED NEGATION SLASH",
"VERTICAL LINE WITH CIRCLE ABOVE",
"VERTICAL LINE WITH CIRCLE BELOW",
"DOWN TACK WITH CIRCLE BELOW",
"PARALLEL WITH HORIZONTAL STROKE",
"PARALLEL WITH TILDE OPERATOR",
"TRIPLE VERTICAL BAR BINARY RELATION",
"TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE",
"TRIPLE COLON OPERATOR",
"TRIPLE NESTED LESS-THAN",
"TRIPLE NESTED GREATER-THAN",
"DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO",
"DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO",
"TRIPLE SOLIDUS BINARY RELATION",
"LARGE TRIPLE VERTICAL BAR OPERATOR",
"DOUBLE SOLIDUS OPERATOR",
"WHITE VERTICAL BAR",
"N-ARY WHITE VERTICAL BAR"};
static const char * name_002b[256] =
{
"NORTH EAST WHITE ARROW",
"NORTH WEST WHITE ARROW",
"SOUTH EAST WHITE ARROW",
"SOUTH WEST WHITE ARROW",
"LEFT RIGHT WHITE ARROW",
"LEFTWARDS BLACK ARROW",
"UPWARDS BLACK ARROW",
"DOWNWARDS BLACK ARROW",
"NORTH EAST BLACK ARROW",
"NORTH WEST BLACK ARROW",
"SOUTH EAST BLACK ARROW",
"SOUTH WEST BLACK ARROW",
"LEFT RIGHT BLACK ARROW",
"UP DOWN BLACK ARROW",
"RIGHTWARDS ARROW WITH TIP DOWNWARDS",
"RIGHTWARDS ARROW WITH TIP UPWARDS",
"LEFTWARDS ARROW WITH TIP DOWNWARDS",
"LEFTWARDS ARROW WITH TIP UPWARDS",
"SQUARE WITH TOP HALF BLACK",
"SQUARE WITH BOTTOM HALF BLACK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_002c[256] =
{
"GLAGOLITIC CAPITAL LETTER AZU",
"GLAGOLITIC CAPITAL LETTER BUKY",
"GLAGOLITIC CAPITAL LETTER VEDE",
"GLAGOLITIC CAPITAL LETTER GLAGOLI",
"GLAGOLITIC CAPITAL LETTER DOBRO",
"GLAGOLITIC CAPITAL LETTER YESTU",
"GLAGOLITIC CAPITAL LETTER ZHIVETE",
"GLAGOLITIC CAPITAL LETTER DZELO",
"GLAGOLITIC CAPITAL LETTER ZEMLJA",
"GLAGOLITIC CAPITAL LETTER IZHE",
"GLAGOLITIC CAPITAL LETTER INITIAL IZHE",
"GLAGOLITIC CAPITAL LETTER I",
"GLAGOLITIC CAPITAL LETTER DJERVI",
"GLAGOLITIC CAPITAL LETTER KAKO",
"GLAGOLITIC CAPITAL LETTER LJUDIJE",
"GLAGOLITIC CAPITAL LETTER MYSLITE",
"GLAGOLITIC CAPITAL LETTER NASHI",
"GLAGOLITIC CAPITAL LETTER ONU",
"GLAGOLITIC CAPITAL LETTER POKOJI",
"GLAGOLITIC CAPITAL LETTER RITSI",
"GLAGOLITIC CAPITAL LETTER SLOVO",
"GLAGOLITIC CAPITAL LETTER TVRIDO",
"GLAGOLITIC CAPITAL LETTER UKU",
"GLAGOLITIC CAPITAL LETTER FRITU",
"GLAGOLITIC CAPITAL LETTER HERU",
"GLAGOLITIC CAPITAL LETTER OTU",
"GLAGOLITIC CAPITAL LETTER PE",
"GLAGOLITIC CAPITAL LETTER SHTA",
"GLAGOLITIC CAPITAL LETTER TSI",
"GLAGOLITIC CAPITAL LETTER CHRIVI",
"GLAGOLITIC CAPITAL LETTER SHA",
"GLAGOLITIC CAPITAL LETTER YERU",
"GLAGOLITIC CAPITAL LETTER YERI",
"GLAGOLITIC CAPITAL LETTER YATI",
"GLAGOLITIC CAPITAL LETTER SPIDERY HA",
"GLAGOLITIC CAPITAL LETTER YU",
"GLAGOLITIC CAPITAL LETTER SMALL YUS",
"GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL",
"GLAGOLITIC CAPITAL LETTER YO",
"GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS",
"GLAGOLITIC CAPITAL LETTER BIG YUS",
"GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS",
"GLAGOLITIC CAPITAL LETTER FITA",
"GLAGOLITIC CAPITAL LETTER IZHITSA",
"GLAGOLITIC CAPITAL LETTER SHTAPIC",
"GLAGOLITIC CAPITAL LETTER TROKUTASTI A",
"GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE",
name_reserved,
"GLAGOLITIC SMALL LETTER AZU",
"GLAGOLITIC SMALL LETTER BUKY",
"GLAGOLITIC SMALL LETTER VEDE",
"GLAGOLITIC SMALL LETTER GLAGOLI",
"GLAGOLITIC SMALL LETTER DOBRO",
"GLAGOLITIC SMALL LETTER YESTU",
"GLAGOLITIC SMALL LETTER ZHIVETE",
"GLAGOLITIC SMALL LETTER DZELO",
"GLAGOLITIC SMALL LETTER ZEMLJA",
"GLAGOLITIC SMALL LETTER IZHE",
"GLAGOLITIC SMALL LETTER INITIAL IZHE",
"GLAGOLITIC SMALL LETTER I",
"GLAGOLITIC SMALL LETTER DJERVI",
"GLAGOLITIC SMALL LETTER KAKO",
"GLAGOLITIC SMALL LETTER LJUDIJE",
"GLAGOLITIC SMALL LETTER MYSLITE",
"GLAGOLITIC SMALL LETTER NASHI",
"GLAGOLITIC SMALL LETTER ONU",
"GLAGOLITIC SMALL LETTER POKOJI",
"GLAGOLITIC SMALL LETTER RITSI",
"GLAGOLITIC SMALL LETTER SLOVO",
"GLAGOLITIC SMALL LETTER TVRIDO",
"GLAGOLITIC SMALL LETTER UKU",
"GLAGOLITIC SMALL LETTER FRITU",
"GLAGOLITIC SMALL LETTER HERU",
"GLAGOLITIC SMALL LETTER OTU",
"GLAGOLITIC SMALL LETTER PE",
"GLAGOLITIC SMALL LETTER SHTA",
"GLAGOLITIC SMALL LETTER TSI",
"GLAGOLITIC SMALL LETTER CHRIVI",
"GLAGOLITIC SMALL LETTER SHA",
"GLAGOLITIC SMALL LETTER YERU",
"GLAGOLITIC SMALL LETTER YERI",
"GLAGOLITIC SMALL LETTER YATI",
"GLAGOLITIC SMALL LETTER SPIDERY HA",
"GLAGOLITIC SMALL LETTER YU",
"GLAGOLITIC SMALL LETTER SMALL YUS",
"GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL",
"GLAGOLITIC SMALL LETTER YO",
"GLAGOLITIC SMALL LETTER IOTATED SMALL YUS",
"GLAGOLITIC SMALL LETTER BIG YUS",
"GLAGOLITIC SMALL LETTER IOTATED BIG YUS",
"GLAGOLITIC SMALL LETTER FITA",
"GLAGOLITIC SMALL LETTER IZHITSA",
"GLAGOLITIC SMALL LETTER SHTAPIC",
"GLAGOLITIC SMALL LETTER TROKUTASTI A",
"GLAGOLITIC SMALL LETTER LATINATE MYSLITE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"COPTIC CAPITAL LETTER ALFA",
"COPTIC SMALL LETTER ALFA",
"COPTIC CAPITAL LETTER VIDA",
"COPTIC SMALL LETTER VIDA",
"COPTIC CAPITAL LETTER GAMMA",
"COPTIC SMALL LETTER GAMMA",
"COPTIC CAPITAL LETTER DALDA",
"COPTIC SMALL LETTER DALDA",
"COPTIC CAPITAL LETTER EIE",
"COPTIC SMALL LETTER EIE",
"COPTIC CAPITAL LETTER SOU",
"COPTIC SMALL LETTER SOU",
"COPTIC CAPITAL LETTER ZATA",
"COPTIC SMALL LETTER ZATA",
"COPTIC CAPITAL LETTER HATE",
"COPTIC SMALL LETTER HATE",
"COPTIC CAPITAL LETTER THETHE",
"COPTIC SMALL LETTER THETHE",
"COPTIC CAPITAL LETTER IAUDA",
"COPTIC SMALL LETTER IAUDA",
"COPTIC CAPITAL LETTER KAPA",
"COPTIC SMALL LETTER KAPA",
"COPTIC CAPITAL LETTER LAULA",
"COPTIC SMALL LETTER LAULA",
"COPTIC CAPITAL LETTER MI",
"COPTIC SMALL LETTER MI",
"COPTIC CAPITAL LETTER NI",
"COPTIC SMALL LETTER NI",
"COPTIC CAPITAL LETTER KSI",
"COPTIC SMALL LETTER KSI",
"COPTIC CAPITAL LETTER O",
"COPTIC SMALL LETTER O",
"COPTIC CAPITAL LETTER PI",
"COPTIC SMALL LETTER PI",
"COPTIC CAPITAL LETTER RO",
"COPTIC SMALL LETTER RO",
"COPTIC CAPITAL LETTER SIMA",
"COPTIC SMALL LETTER SIMA",
"COPTIC CAPITAL LETTER TAU",
"COPTIC SMALL LETTER TAU",
"COPTIC CAPITAL LETTER UA",
"COPTIC SMALL LETTER UA",
"COPTIC CAPITAL LETTER FI",
"COPTIC SMALL LETTER FI",
"COPTIC CAPITAL LETTER KHI",
"COPTIC SMALL LETTER KHI",
"COPTIC CAPITAL LETTER PSI",
"COPTIC SMALL LETTER PSI",
"COPTIC CAPITAL LETTER OOU",
"COPTIC SMALL LETTER OOU",
"COPTIC CAPITAL LETTER DIALECT-P ALEF",
"COPTIC SMALL LETTER DIALECT-P ALEF",
"COPTIC CAPITAL LETTER OLD COPTIC AIN",
"COPTIC SMALL LETTER OLD COPTIC AIN",
"COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE",
"COPTIC SMALL LETTER CRYPTOGRAMMIC EIE",
"COPTIC CAPITAL LETTER DIALECT-P KAPA",
"COPTIC SMALL LETTER DIALECT-P KAPA",
"COPTIC CAPITAL LETTER DIALECT-P NI",
"COPTIC SMALL LETTER DIALECT-P NI",
"COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI",
"COPTIC SMALL LETTER CRYPTOGRAMMIC NI",
"COPTIC CAPITAL LETTER OLD COPTIC OOU",
"COPTIC SMALL LETTER OLD COPTIC OOU",
"COPTIC CAPITAL LETTER SAMPI",
"COPTIC SMALL LETTER SAMPI",
"COPTIC CAPITAL LETTER CROSSED SHEI",
"COPTIC SMALL LETTER CROSSED SHEI",
"COPTIC CAPITAL LETTER OLD COPTIC SHEI",
"COPTIC SMALL LETTER OLD COPTIC SHEI",
"COPTIC CAPITAL LETTER OLD COPTIC ESH",
"COPTIC SMALL LETTER OLD COPTIC ESH",
"COPTIC CAPITAL LETTER AKHMIMIC KHEI",
"COPTIC SMALL LETTER AKHMIMIC KHEI",
"COPTIC CAPITAL LETTER DIALECT-P HORI",
"COPTIC SMALL LETTER DIALECT-P HORI",
"COPTIC CAPITAL LETTER OLD COPTIC HORI",
"COPTIC SMALL LETTER OLD COPTIC HORI",
"COPTIC CAPITAL LETTER OLD COPTIC HA",
"COPTIC SMALL LETTER OLD COPTIC HA",
"COPTIC CAPITAL LETTER L-SHAPED HA",
"COPTIC SMALL LETTER L-SHAPED HA",
"COPTIC CAPITAL LETTER OLD COPTIC HEI",
"COPTIC SMALL LETTER OLD COPTIC HEI",
"COPTIC CAPITAL LETTER OLD COPTIC HAT",
"COPTIC SMALL LETTER OLD COPTIC HAT",
"COPTIC CAPITAL LETTER OLD COPTIC GANGIA",
"COPTIC SMALL LETTER OLD COPTIC GANGIA",
"COPTIC CAPITAL LETTER OLD COPTIC DJA",
"COPTIC SMALL LETTER OLD COPTIC DJA",
"COPTIC CAPITAL LETTER OLD COPTIC SHIMA",
"COPTIC SMALL LETTER OLD COPTIC SHIMA",
"COPTIC CAPITAL LETTER OLD NUBIAN SHIMA",
"COPTIC SMALL LETTER OLD NUBIAN SHIMA",
"COPTIC CAPITAL LETTER OLD NUBIAN NGI",
"COPTIC SMALL LETTER OLD NUBIAN NGI",
"COPTIC CAPITAL LETTER OLD NUBIAN NYI",
"COPTIC SMALL LETTER OLD NUBIAN NYI",
"COPTIC CAPITAL LETTER OLD NUBIAN WAU",
"COPTIC SMALL LETTER OLD NUBIAN WAU",
"COPTIC SYMBOL KAI",
"COPTIC SYMBOL MI RO",
"COPTIC SYMBOL PI RO",
"COPTIC SYMBOL STAUROS",
"COPTIC SYMBOL TAU RO",
"COPTIC SYMBOL KHI RO",
"COPTIC SYMBOL SHIMA SIMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"COPTIC OLD NUBIAN FULL STOP",
"COPTIC OLD NUBIAN DIRECT QUESTION MARK",
"COPTIC OLD NUBIAN INDIRECT QUESTION MARK",
"COPTIC OLD NUBIAN VERSE DIVIDER",
"COPTIC FRACTION ONE HALF",
"COPTIC FULL STOP",
"COPTIC MORPHOLOGICAL DIVIDER"};
static const char * name_002d[256] =
{
"GEORGIAN SMALL LETTER AN",
"GEORGIAN SMALL LETTER BAN",
"GEORGIAN SMALL LETTER GAN",
"GEORGIAN SMALL LETTER DON",
"GEORGIAN SMALL LETTER EN",
"GEORGIAN SMALL LETTER VIN",
"GEORGIAN SMALL LETTER ZEN",
"GEORGIAN SMALL LETTER TAN",
"GEORGIAN SMALL LETTER IN",
"GEORGIAN SMALL LETTER KAN",
"GEORGIAN SMALL LETTER LAS",
"GEORGIAN SMALL LETTER MAN",
"GEORGIAN SMALL LETTER NAR",
"GEORGIAN SMALL LETTER ON",
"GEORGIAN SMALL LETTER PAR",
"GEORGIAN SMALL LETTER ZHAR",
"GEORGIAN SMALL LETTER RAE",
"GEORGIAN SMALL LETTER SAN",
"GEORGIAN SMALL LETTER TAR",
"GEORGIAN SMALL LETTER UN",
"GEORGIAN SMALL LETTER PHAR",
"GEORGIAN SMALL LETTER KHAR",
"GEORGIAN SMALL LETTER GHAN",
"GEORGIAN SMALL LETTER QAR",
"GEORGIAN SMALL LETTER SHIN",
"GEORGIAN SMALL LETTER CHIN",
"GEORGIAN SMALL LETTER CAN",
"GEORGIAN SMALL LETTER JIL",
"GEORGIAN SMALL LETTER CIL",
"GEORGIAN SMALL LETTER CHAR",
"GEORGIAN SMALL LETTER XAN",
"GEORGIAN SMALL LETTER JHAN",
"GEORGIAN SMALL LETTER HAE",
"GEORGIAN SMALL LETTER HE",
"GEORGIAN SMALL LETTER HIE",
"GEORGIAN SMALL LETTER WE",
"GEORGIAN SMALL LETTER HAR",
"GEORGIAN SMALL LETTER HOE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TIFINAGH LETTER YA",
"TIFINAGH LETTER YAB",
"TIFINAGH LETTER YABH",
"TIFINAGH LETTER YAG",
"TIFINAGH LETTER YAGHH",
"TIFINAGH LETTER BERBER ACADEMY YAJ",
"TIFINAGH LETTER YAJ",
"TIFINAGH LETTER YAD",
"TIFINAGH LETTER YADH",
"TIFINAGH LETTER YADD",
"TIFINAGH LETTER YADDH",
"TIFINAGH LETTER YEY",
"TIFINAGH LETTER YAF",
"TIFINAGH LETTER YAK",
"TIFINAGH LETTER TUAREG YAK",
"TIFINAGH LETTER YAKHH",
"TIFINAGH LETTER YAH",
"TIFINAGH LETTER BERBER ACADEMY YAH",
"TIFINAGH LETTER TUAREG YAH",
"TIFINAGH LETTER YAHH",
"TIFINAGH LETTER YAA",
"TIFINAGH LETTER YAKH",
"TIFINAGH LETTER TUAREG YAKH",
"TIFINAGH LETTER YAQ",
"TIFINAGH LETTER TUAREG YAQ",
"TIFINAGH LETTER YI",
"TIFINAGH LETTER YAZH",
"TIFINAGH LETTER AHAGGAR YAZH",
"TIFINAGH LETTER TUAREG YAZH",
"TIFINAGH LETTER YAL",
"TIFINAGH LETTER YAM",
"TIFINAGH LETTER YAN",
"TIFINAGH LETTER TUAREG YAGN",
"TIFINAGH LETTER TUAREG YANG",
"TIFINAGH LETTER YAP",
"TIFINAGH LETTER YU",
"TIFINAGH LETTER YAR",
"TIFINAGH LETTER YARR",
"TIFINAGH LETTER YAGH",
"TIFINAGH LETTER TUAREG YAGH",
"TIFINAGH LETTER AYER YAGH",
"TIFINAGH LETTER YAS",
"TIFINAGH LETTER YASS",
"TIFINAGH LETTER YASH",
"TIFINAGH LETTER YAT",
"TIFINAGH LETTER YATH",
"TIFINAGH LETTER YACH",
"TIFINAGH LETTER YATT",
"TIFINAGH LETTER YAV",
"TIFINAGH LETTER YAW",
"TIFINAGH LETTER YAY",
"TIFINAGH LETTER YAZ",
"TIFINAGH LETTER TAWELLEMET YAZ",
"TIFINAGH LETTER YAZZ",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TIFINAGH MODIFIER LETTER LABIALIZATION MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ETHIOPIC SYLLABLE LOA",
"ETHIOPIC SYLLABLE MOA",
"ETHIOPIC SYLLABLE ROA",
"ETHIOPIC SYLLABLE SOA",
"ETHIOPIC SYLLABLE SHOA",
"ETHIOPIC SYLLABLE BOA",
"ETHIOPIC SYLLABLE TOA",
"ETHIOPIC SYLLABLE COA",
"ETHIOPIC SYLLABLE NOA",
"ETHIOPIC SYLLABLE NYOA",
"ETHIOPIC SYLLABLE GLOTTAL OA",
"ETHIOPIC SYLLABLE ZOA",
"ETHIOPIC SYLLABLE DOA",
"ETHIOPIC SYLLABLE DDOA",
"ETHIOPIC SYLLABLE JOA",
"ETHIOPIC SYLLABLE THOA",
"ETHIOPIC SYLLABLE CHOA",
"ETHIOPIC SYLLABLE PHOA",
"ETHIOPIC SYLLABLE POA",
"ETHIOPIC SYLLABLE GGWA",
"ETHIOPIC SYLLABLE GGWI",
"ETHIOPIC SYLLABLE GGWEE",
"ETHIOPIC SYLLABLE GGWE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ETHIOPIC SYLLABLE SSA",
"ETHIOPIC SYLLABLE SSU",
"ETHIOPIC SYLLABLE SSI",
"ETHIOPIC SYLLABLE SSAA",
"ETHIOPIC SYLLABLE SSEE",
"ETHIOPIC SYLLABLE SSE",
"ETHIOPIC SYLLABLE SSO",
name_reserved,
"ETHIOPIC SYLLABLE CCA",
"ETHIOPIC SYLLABLE CCU",
"ETHIOPIC SYLLABLE CCI",
"ETHIOPIC SYLLABLE CCAA",
"ETHIOPIC SYLLABLE CCEE",
"ETHIOPIC SYLLABLE CCE",
"ETHIOPIC SYLLABLE CCO",
name_reserved,
"ETHIOPIC SYLLABLE ZZA",
"ETHIOPIC SYLLABLE ZZU",
"ETHIOPIC SYLLABLE ZZI",
"ETHIOPIC SYLLABLE ZZAA",
"ETHIOPIC SYLLABLE ZZEE",
"ETHIOPIC SYLLABLE ZZE",
"ETHIOPIC SYLLABLE ZZO",
name_reserved,
"ETHIOPIC SYLLABLE CCHA",
"ETHIOPIC SYLLABLE CCHU",
"ETHIOPIC SYLLABLE CCHI",
"ETHIOPIC SYLLABLE CCHAA",
"ETHIOPIC SYLLABLE CCHEE",
"ETHIOPIC SYLLABLE CCHE",
"ETHIOPIC SYLLABLE CCHO",
name_reserved,
"ETHIOPIC SYLLABLE QYA",
"ETHIOPIC SYLLABLE QYU",
"ETHIOPIC SYLLABLE QYI",
"ETHIOPIC SYLLABLE QYAA",
"ETHIOPIC SYLLABLE QYEE",
"ETHIOPIC SYLLABLE QYE",
"ETHIOPIC SYLLABLE QYO",
name_reserved,
"ETHIOPIC SYLLABLE KYA",
"ETHIOPIC SYLLABLE KYU",
"ETHIOPIC SYLLABLE KYI",
"ETHIOPIC SYLLABLE KYAA",
"ETHIOPIC SYLLABLE KYEE",
"ETHIOPIC SYLLABLE KYE",
"ETHIOPIC SYLLABLE KYO",
name_reserved,
"ETHIOPIC SYLLABLE XYA",
"ETHIOPIC SYLLABLE XYU",
"ETHIOPIC SYLLABLE XYI",
"ETHIOPIC SYLLABLE XYAA",
"ETHIOPIC SYLLABLE XYEE",
"ETHIOPIC SYLLABLE XYE",
"ETHIOPIC SYLLABLE XYO",
name_reserved,
"ETHIOPIC SYLLABLE GYA",
"ETHIOPIC SYLLABLE GYU",
"ETHIOPIC SYLLABLE GYI",
"ETHIOPIC SYLLABLE GYAA",
"ETHIOPIC SYLLABLE GYEE",
"ETHIOPIC SYLLABLE GYE",
"ETHIOPIC SYLLABLE GYO",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_002e[256] =
{
"RIGHT ANGLE SUBSTITUTION MARKER",
"RIGHT ANGLE DOTTED SUBSTITUTION MARKER",
"LEFT SUBSTITUTION BRACKET",
"RIGHT SUBSTITUTION BRACKET",
"LEFT DOTTED SUBSTITUTION BRACKET",
"RIGHT DOTTED SUBSTITUTION BRACKET",
"RAISED INTERPOLATION MARKER",
"RAISED DOTTED INTERPOLATION MARKER",
"DOTTED TRANSPOSITION MARKER",
"LEFT TRANSPOSITION BRACKET",
"RIGHT TRANSPOSITION BRACKET",
"RAISED SQUARE",
"LEFT RAISED OMISSION BRACKET",
"RIGHT RAISED OMISSION BRACKET",
"EDITORIAL CORONIS",
"PARAGRAPHOS",
"FORKED PARAGRAPHOS",
"REVERSED FORKED PARAGRAPHOS",
"HYPODIASTOLE",
"DOTTED OBELOS",
"DOWNWARDS ANCORA",
"UPWARDS ANCORA",
"DOTTED RIGHT-POINTING ANGLE",
"DOUBLE OBLIQUE HYPHEN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"LEFT LOW PARAPHRASE BRACKET",
"RIGHT LOW PARAPHRASE BRACKET",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"CJK RADICAL REPEAT",
"CJK RADICAL CLIFF",
"CJK RADICAL SECOND ONE",
"CJK RADICAL SECOND TWO",
"CJK RADICAL SECOND THREE",
"CJK RADICAL PERSON",
"CJK RADICAL BOX",
"CJK RADICAL TABLE",
"CJK RADICAL KNIFE ONE",
"CJK RADICAL KNIFE TWO",
"CJK RADICAL DIVINATION",
"CJK RADICAL SEAL",
"CJK RADICAL SMALL ONE",
"CJK RADICAL SMALL TWO",
"CJK RADICAL LAME ONE",
"CJK RADICAL LAME TWO",
"CJK RADICAL LAME THREE",
"CJK RADICAL LAME FOUR",
"CJK RADICAL SNAKE",
"CJK RADICAL THREAD",
"CJK RADICAL SNOUT ONE",
"CJK RADICAL SNOUT TWO",
"CJK RADICAL HEART ONE",
"CJK RADICAL HEART TWO",
"CJK RADICAL HAND",
"CJK RADICAL RAP",
name_reserved,
"CJK RADICAL CHOKE",
"CJK RADICAL SUN",
"CJK RADICAL MOON",
"CJK RADICAL DEATH",
"CJK RADICAL MOTHER",
"CJK RADICAL CIVILIAN",
"CJK RADICAL WATER ONE",
"CJK RADICAL WATER TWO",
"CJK RADICAL FIRE",
"CJK RADICAL PAW ONE",
"CJK RADICAL PAW TWO",
"CJK RADICAL SIMPLIFIED HALF TREE TRUNK",
"CJK RADICAL COW",
"CJK RADICAL DOG",
"CJK RADICAL JADE",
"CJK RADICAL BOLT OF CLOTH",
"CJK RADICAL EYE",
"CJK RADICAL SPIRIT ONE",
"CJK RADICAL SPIRIT TWO",
"CJK RADICAL BAMBOO",
"CJK RADICAL SILK",
"CJK RADICAL C-SIMPLIFIED SILK",
"CJK RADICAL NET ONE",
"CJK RADICAL NET TWO",
"CJK RADICAL NET THREE",
"CJK RADICAL NET FOUR",
"CJK RADICAL MESH",
"CJK RADICAL SHEEP",
"CJK RADICAL RAM",
"CJK RADICAL EWE",
"CJK RADICAL OLD",
"CJK RADICAL BRUSH ONE",
"CJK RADICAL BRUSH TWO",
"CJK RADICAL MEAT",
"CJK RADICAL MORTAR",
"CJK RADICAL GRASS ONE",
"CJK RADICAL GRASS TWO",
"CJK RADICAL GRASS THREE",
"CJK RADICAL TIGER",
"CJK RADICAL CLOTHES",
"CJK RADICAL WEST ONE",
"CJK RADICAL WEST TWO",
"CJK RADICAL C-SIMPLIFIED SEE",
"CJK RADICAL SIMPLIFIED HORN",
"CJK RADICAL HORN",
"CJK RADICAL C-SIMPLIFIED SPEECH",
"CJK RADICAL C-SIMPLIFIED SHELL",
"CJK RADICAL FOOT",
"CJK RADICAL C-SIMPLIFIED CART",
"CJK RADICAL SIMPLIFIED WALK",
"CJK RADICAL WALK ONE",
"CJK RADICAL WALK TWO",
"CJK RADICAL CITY",
"CJK RADICAL C-SIMPLIFIED GOLD",
"CJK RADICAL LONG ONE",
"CJK RADICAL LONG TWO",
"CJK RADICAL C-SIMPLIFIED LONG",
"CJK RADICAL C-SIMPLIFIED GATE",
"CJK RADICAL MOUND ONE",
"CJK RADICAL MOUND TWO",
"CJK RADICAL RAIN",
"CJK RADICAL BLUE",
"CJK RADICAL C-SIMPLIFIED TANNED LEATHER",
"CJK RADICAL C-SIMPLIFIED LEAF",
"CJK RADICAL C-SIMPLIFIED WIND",
"CJK RADICAL C-SIMPLIFIED FLY",
"CJK RADICAL EAT ONE",
"CJK RADICAL EAT TWO",
"CJK RADICAL EAT THREE",
"CJK RADICAL C-SIMPLIFIED EAT",
"CJK RADICAL HEAD",
"CJK RADICAL C-SIMPLIFIED HORSE",
"CJK RADICAL BONE",
"CJK RADICAL GHOST",
"CJK RADICAL C-SIMPLIFIED FISH",
"CJK RADICAL C-SIMPLIFIED BIRD",
"CJK RADICAL C-SIMPLIFIED SALT",
"CJK RADICAL SIMPLIFIED WHEAT",
"CJK RADICAL SIMPLIFIED YELLOW",
"CJK RADICAL C-SIMPLIFIED FROG",
"CJK RADICAL J-SIMPLIFIED EVEN",
"CJK RADICAL C-SIMPLIFIED EVEN",
"CJK RADICAL J-SIMPLIFIED TOOTH",
"CJK RADICAL C-SIMPLIFIED TOOTH",
"CJK RADICAL J-SIMPLIFIED DRAGON",
"CJK RADICAL C-SIMPLIFIED DRAGON",
"CJK RADICAL TURTLE",
"CJK RADICAL J-SIMPLIFIED TURTLE",
"CJK RADICAL C-SIMPLIFIED TURTLE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_002f[256] =
{
"KANGXI RADICAL ONE",
"KANGXI RADICAL LINE",
"KANGXI RADICAL DOT",
"KANGXI RADICAL SLASH",
"KANGXI RADICAL SECOND",
"KANGXI RADICAL HOOK",
"KANGXI RADICAL TWO",
"KANGXI RADICAL LID",
"KANGXI RADICAL MAN",
"KANGXI RADICAL LEGS",
"KANGXI RADICAL ENTER",
"KANGXI RADICAL EIGHT",
"KANGXI RADICAL DOWN BOX",
"KANGXI RADICAL COVER",
"KANGXI RADICAL ICE",
"KANGXI RADICAL TABLE",
"KANGXI RADICAL OPEN BOX",
"KANGXI RADICAL KNIFE",
"KANGXI RADICAL POWER",
"KANGXI RADICAL WRAP",
"KANGXI RADICAL SPOON",
"KANGXI RADICAL RIGHT OPEN BOX",
"KANGXI RADICAL HIDING ENCLOSURE",
"KANGXI RADICAL TEN",
"KANGXI RADICAL DIVINATION",
"KANGXI RADICAL SEAL",
"KANGXI RADICAL CLIFF",
"KANGXI RADICAL PRIVATE",
"KANGXI RADICAL AGAIN",
"KANGXI RADICAL MOUTH",
"KANGXI RADICAL ENCLOSURE",
"KANGXI RADICAL EARTH",
"KANGXI RADICAL SCHOLAR",
"KANGXI RADICAL GO",
"KANGXI RADICAL GO SLOWLY",
"KANGXI RADICAL EVENING",
"KANGXI RADICAL BIG",
"KANGXI RADICAL WOMAN",
"KANGXI RADICAL CHILD",
"KANGXI RADICAL ROOF",
"KANGXI RADICAL INCH",
"KANGXI RADICAL SMALL",
"KANGXI RADICAL LAME",
"KANGXI RADICAL CORPSE",
"KANGXI RADICAL SPROUT",
"KANGXI RADICAL MOUNTAIN",
"KANGXI RADICAL RIVER",
"KANGXI RADICAL WORK",
"KANGXI RADICAL ONESELF",
"KANGXI RADICAL TURBAN",
"KANGXI RADICAL DRY",
"KANGXI RADICAL SHORT THREAD",
"KANGXI RADICAL DOTTED CLIFF",
"KANGXI RADICAL LONG STRIDE",
"KANGXI RADICAL TWO HANDS",
"KANGXI RADICAL SHOOT",
"KANGXI RADICAL BOW",
"KANGXI RADICAL SNOUT",
"KANGXI RADICAL BRISTLE",
"KANGXI RADICAL STEP",
"KANGXI RADICAL HEART",
"KANGXI RADICAL HALBERD",
"KANGXI RADICAL DOOR",
"KANGXI RADICAL HAND",
"KANGXI RADICAL BRANCH",
"KANGXI RADICAL RAP",
"KANGXI RADICAL SCRIPT",
"KANGXI RADICAL DIPPER",
"KANGXI RADICAL AXE",
"KANGXI RADICAL SQUARE",
"KANGXI RADICAL NOT",
"KANGXI RADICAL SUN",
"KANGXI RADICAL SAY",
"KANGXI RADICAL MOON",
"KANGXI RADICAL TREE",
"KANGXI RADICAL LACK",
"KANGXI RADICAL STOP",
"KANGXI RADICAL DEATH",
"KANGXI RADICAL WEAPON",
"KANGXI RADICAL DO NOT",
"KANGXI RADICAL COMPARE",
"KANGXI RADICAL FUR",
"KANGXI RADICAL CLAN",
"KANGXI RADICAL STEAM",
"KANGXI RADICAL WATER",
"KANGXI RADICAL FIRE",
"KANGXI RADICAL CLAW",
"KANGXI RADICAL FATHER",
"KANGXI RADICAL DOUBLE X",
"KANGXI RADICAL HALF TREE TRUNK",
"KANGXI RADICAL SLICE",
"KANGXI RADICAL FANG",
"KANGXI RADICAL COW",
"KANGXI RADICAL DOG",
"KANGXI RADICAL PROFOUND",
"KANGXI RADICAL JADE",
"KANGXI RADICAL MELON",
"KANGXI RADICAL TILE",
"KANGXI RADICAL SWEET",
"KANGXI RADICAL LIFE",
"KANGXI RADICAL USE",
"KANGXI RADICAL FIELD",
"KANGXI RADICAL BOLT OF CLOTH",
"KANGXI RADICAL SICKNESS",
"KANGXI RADICAL DOTTED TENT",
"KANGXI RADICAL WHITE",
"KANGXI RADICAL SKIN",
"KANGXI RADICAL DISH",
"KANGXI RADICAL EYE",
"KANGXI RADICAL SPEAR",
"KANGXI RADICAL ARROW",
"KANGXI RADICAL STONE",
"KANGXI RADICAL SPIRIT",
"KANGXI RADICAL TRACK",
"KANGXI RADICAL GRAIN",
"KANGXI RADICAL CAVE",
"KANGXI RADICAL STAND",
"KANGXI RADICAL BAMBOO",
"KANGXI RADICAL RICE",
"KANGXI RADICAL SILK",
"KANGXI RADICAL JAR",
"KANGXI RADICAL NET",
"KANGXI RADICAL SHEEP",
"KANGXI RADICAL FEATHER",
"KANGXI RADICAL OLD",
"KANGXI RADICAL AND",
"KANGXI RADICAL PLOW",
"KANGXI RADICAL EAR",
"KANGXI RADICAL BRUSH",
"KANGXI RADICAL MEAT",
"KANGXI RADICAL MINISTER",
"KANGXI RADICAL SELF",
"KANGXI RADICAL ARRIVE",
"KANGXI RADICAL MORTAR",
"KANGXI RADICAL TONGUE",
"KANGXI RADICAL OPPOSE",
"KANGXI RADICAL BOAT",
"KANGXI RADICAL STOPPING",
"KANGXI RADICAL COLOR",
"KANGXI RADICAL GRASS",
"KANGXI RADICAL TIGER",
"KANGXI RADICAL INSECT",
"KANGXI RADICAL BLOOD",
"KANGXI RADICAL WALK ENCLOSURE",
"KANGXI RADICAL CLOTHES",
"KANGXI RADICAL WEST",
"KANGXI RADICAL SEE",
"KANGXI RADICAL HORN",
"KANGXI RADICAL SPEECH",
"KANGXI RADICAL VALLEY",
"KANGXI RADICAL BEAN",
"KANGXI RADICAL PIG",
"KANGXI RADICAL BADGER",
"KANGXI RADICAL SHELL",
"KANGXI RADICAL RED",
"KANGXI RADICAL RUN",
"KANGXI RADICAL FOOT",
"KANGXI RADICAL BODY",
"KANGXI RADICAL CART",
"KANGXI RADICAL BITTER",
"KANGXI RADICAL MORNING",
"KANGXI RADICAL WALK",
"KANGXI RADICAL CITY",
"KANGXI RADICAL WINE",
"KANGXI RADICAL DISTINGUISH",
"KANGXI RADICAL VILLAGE",
"KANGXI RADICAL GOLD",
"KANGXI RADICAL LONG",
"KANGXI RADICAL GATE",
"KANGXI RADICAL MOUND",
"KANGXI RADICAL SLAVE",
"KANGXI RADICAL SHORT TAILED BIRD",
"KANGXI RADICAL RAIN",
"KANGXI RADICAL BLUE",
"KANGXI RADICAL WRONG",
"KANGXI RADICAL FACE",
"KANGXI RADICAL LEATHER",
"KANGXI RADICAL TANNED LEATHER",
"KANGXI RADICAL LEEK",
"KANGXI RADICAL SOUND",
"KANGXI RADICAL LEAF",
"KANGXI RADICAL WIND",
"KANGXI RADICAL FLY",
"KANGXI RADICAL EAT",
"KANGXI RADICAL HEAD",
"KANGXI RADICAL FRAGRANT",
"KANGXI RADICAL HORSE",
"KANGXI RADICAL BONE",
"KANGXI RADICAL TALL",
"KANGXI RADICAL HAIR",
"KANGXI RADICAL FIGHT",
"KANGXI RADICAL SACRIFICIAL WINE",
"KANGXI RADICAL CAULDRON",
"KANGXI RADICAL GHOST",
"KANGXI RADICAL FISH",
"KANGXI RADICAL BIRD",
"KANGXI RADICAL SALT",
"KANGXI RADICAL DEER",
"KANGXI RADICAL WHEAT",
"KANGXI RADICAL HEMP",
"KANGXI RADICAL YELLOW",
"KANGXI RADICAL MILLET",
"KANGXI RADICAL BLACK",
"KANGXI RADICAL EMBROIDERY",
"KANGXI RADICAL FROG",
"KANGXI RADICAL TRIPOD",
"KANGXI RADICAL DRUM",
"KANGXI RADICAL RAT",
"KANGXI RADICAL NOSE",
"KANGXI RADICAL EVEN",
"KANGXI RADICAL TOOTH",
"KANGXI RADICAL DRAGON",
"KANGXI RADICAL TURTLE",
"KANGXI RADICAL FLUTE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT",
"IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW",
"IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT",
"IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW",
"IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND",
"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE",
"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW",
"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT",
"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT",
"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT",
"IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT",
"IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID",
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0030[256] =
{
"IDEOGRAPHIC SPACE",
"IDEOGRAPHIC COMMA",
"IDEOGRAPHIC FULL STOP",
"DITTO MARK",
"JAPANESE INDUSTRIAL STANDARD SYMBOL",
"IDEOGRAPHIC ITERATION MARK",
"IDEOGRAPHIC CLOSING MARK",
"IDEOGRAPHIC NUMBER ZERO",
"LEFT ANGLE BRACKET",
"RIGHT ANGLE BRACKET",
"LEFT DOUBLE ANGLE BRACKET",
"RIGHT DOUBLE ANGLE BRACKET",
"LEFT CORNER BRACKET",
"RIGHT CORNER BRACKET",
"LEFT WHITE CORNER BRACKET",
"RIGHT WHITE CORNER BRACKET",
"LEFT BLACK LENTICULAR BRACKET",
"RIGHT BLACK LENTICULAR BRACKET",
"POSTAL MARK",
"GETA MARK",
"LEFT TORTOISE SHELL BRACKET",
"RIGHT TORTOISE SHELL BRACKET",
"LEFT WHITE LENTICULAR BRACKET",
"RIGHT WHITE LENTICULAR BRACKET",
"LEFT WHITE TORTOISE SHELL BRACKET",
"RIGHT WHITE TORTOISE SHELL BRACKET",
"LEFT WHITE SQUARE BRACKET",
"RIGHT WHITE SQUARE BRACKET",
"WAVE DASH",
"REVERSED DOUBLE PRIME QUOTATION MARK",
"DOUBLE PRIME QUOTATION MARK",
"LOW DOUBLE PRIME QUOTATION MARK",
"POSTAL MARK FACE",
"HANGZHOU NUMERAL ONE",
"HANGZHOU NUMERAL TWO",
"HANGZHOU NUMERAL THREE",
"HANGZHOU NUMERAL FOUR",
"HANGZHOU NUMERAL FIVE",
"HANGZHOU NUMERAL SIX",
"HANGZHOU NUMERAL SEVEN",
"HANGZHOU NUMERAL EIGHT",
"HANGZHOU NUMERAL NINE",
"IDEOGRAPHIC LEVEL TONE MARK",
"IDEOGRAPHIC RISING TONE MARK",
"IDEOGRAPHIC DEPARTING TONE MARK",
"IDEOGRAPHIC ENTERING TONE MARK",
"HANGUL SINGLE DOT TONE MARK",
"HANGUL DOUBLE DOT TONE MARK",
"WAVY DASH",
"VERTICAL KANA REPEAT MARK",
"VERTICAL KANA REPEAT WITH VOICED SOUND MARK",
"VERTICAL KANA REPEAT MARK UPPER HALF",
"VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF",
"VERTICAL KANA REPEAT MARK LOWER HALF",
"CIRCLED POSTAL MARK",
"IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL",
"HANGZHOU NUMERAL TEN",
"HANGZHOU NUMERAL TWENTY",
"HANGZHOU NUMERAL THIRTY",
"VERTICAL IDEOGRAPHIC ITERATION MARK",
"MASU MARK",
"PART ALTERNATION MARK",
"IDEOGRAPHIC VARIATION INDICATOR",
"IDEOGRAPHIC HALF FILL SPACE",
name_reserved,
"HIRAGANA LETTER SMALL A",
"HIRAGANA LETTER A",
"HIRAGANA LETTER SMALL I",
"HIRAGANA LETTER I",
"HIRAGANA LETTER SMALL U",
"HIRAGANA LETTER U",
"HIRAGANA LETTER SMALL E",
"HIRAGANA LETTER E",
"HIRAGANA LETTER SMALL O",
"HIRAGANA LETTER O",
"HIRAGANA LETTER KA",
"HIRAGANA LETTER GA",
"HIRAGANA LETTER KI",
"HIRAGANA LETTER GI",
"HIRAGANA LETTER KU",
"HIRAGANA LETTER GU",
"HIRAGANA LETTER KE",
"HIRAGANA LETTER GE",
"HIRAGANA LETTER KO",
"HIRAGANA LETTER GO",
"HIRAGANA LETTER SA",
"HIRAGANA LETTER ZA",
"HIRAGANA LETTER SI",
"HIRAGANA LETTER ZI",
"HIRAGANA LETTER SU",
"HIRAGANA LETTER ZU",
"HIRAGANA LETTER SE",
"HIRAGANA LETTER ZE",
"HIRAGANA LETTER SO",
"HIRAGANA LETTER ZO",
"HIRAGANA LETTER TA",
"HIRAGANA LETTER DA",
"HIRAGANA LETTER TI",
"HIRAGANA LETTER DI",
"HIRAGANA LETTER SMALL TU",
"HIRAGANA LETTER TU",
"HIRAGANA LETTER DU",
"HIRAGANA LETTER TE",
"HIRAGANA LETTER DE",
"HIRAGANA LETTER TO",
"HIRAGANA LETTER DO",
"HIRAGANA LETTER NA",
"HIRAGANA LETTER NI",
"HIRAGANA LETTER NU",
"HIRAGANA LETTER NE",
"HIRAGANA LETTER NO",
"HIRAGANA LETTER HA",
"HIRAGANA LETTER BA",
"HIRAGANA LETTER PA",
"HIRAGANA LETTER HI",
"HIRAGANA LETTER BI",
"HIRAGANA LETTER PI",
"HIRAGANA LETTER HU",
"HIRAGANA LETTER BU",
"HIRAGANA LETTER PU",
"HIRAGANA LETTER HE",
"HIRAGANA LETTER BE",
"HIRAGANA LETTER PE",
"HIRAGANA LETTER HO",
"HIRAGANA LETTER BO",
"HIRAGANA LETTER PO",
"HIRAGANA LETTER MA",
"HIRAGANA LETTER MI",
"HIRAGANA LETTER MU",
"HIRAGANA LETTER ME",
"HIRAGANA LETTER MO",
"HIRAGANA LETTER SMALL YA",
"HIRAGANA LETTER YA",
"HIRAGANA LETTER SMALL YU",
"HIRAGANA LETTER YU",
"HIRAGANA LETTER SMALL YO",
"HIRAGANA LETTER YO",
"HIRAGANA LETTER RA",
"HIRAGANA LETTER RI",
"HIRAGANA LETTER RU",
"HIRAGANA LETTER RE",
"HIRAGANA LETTER RO",
"HIRAGANA LETTER SMALL WA",
"HIRAGANA LETTER WA",
"HIRAGANA LETTER WI",
"HIRAGANA LETTER WE",
"HIRAGANA LETTER WO",
"HIRAGANA LETTER N",
"HIRAGANA LETTER VU",
"HIRAGANA LETTER SMALL KA",
"HIRAGANA LETTER SMALL KE",
name_reserved,
name_reserved,
"COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK",
"COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK",
"KATAKANA-HIRAGANA VOICED SOUND MARK",
"KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK",
"HIRAGANA ITERATION MARK",
"HIRAGANA VOICED ITERATION MARK",
"HIRAGANA DIGRAPH YORI",
"KATAKANA-HIRAGANA DOUBLE HYPHEN",
"KATAKANA LETTER SMALL A",
"KATAKANA LETTER A",
"KATAKANA LETTER SMALL I",
"KATAKANA LETTER I",
"KATAKANA LETTER SMALL U",
"KATAKANA LETTER U",
"KATAKANA LETTER SMALL E",
"KATAKANA LETTER E",
"KATAKANA LETTER SMALL O",
"KATAKANA LETTER O",
"KATAKANA LETTER KA",
"KATAKANA LETTER GA",
"KATAKANA LETTER KI",
"KATAKANA LETTER GI",
"KATAKANA LETTER KU",
"KATAKANA LETTER GU",
"KATAKANA LETTER KE",
"KATAKANA LETTER GE",
"KATAKANA LETTER KO",
"KATAKANA LETTER GO",
"KATAKANA LETTER SA",
"KATAKANA LETTER ZA",
"KATAKANA LETTER SI",
"KATAKANA LETTER ZI",
"KATAKANA LETTER SU",
"KATAKANA LETTER ZU",
"KATAKANA LETTER SE",
"KATAKANA LETTER ZE",
"KATAKANA LETTER SO",
"KATAKANA LETTER ZO",
"KATAKANA LETTER TA",
"KATAKANA LETTER DA",
"KATAKANA LETTER TI",
"KATAKANA LETTER DI",
"KATAKANA LETTER SMALL TU",
"KATAKANA LETTER TU",
"KATAKANA LETTER DU",
"KATAKANA LETTER TE",
"KATAKANA LETTER DE",
"KATAKANA LETTER TO",
"KATAKANA LETTER DO",
"KATAKANA LETTER NA",
"KATAKANA LETTER NI",
"KATAKANA LETTER NU",
"KATAKANA LETTER NE",
"KATAKANA LETTER NO",
"KATAKANA LETTER HA",
"KATAKANA LETTER BA",
"KATAKANA LETTER PA",
"KATAKANA LETTER HI",
"KATAKANA LETTER BI",
"KATAKANA LETTER PI",
"KATAKANA LETTER HU",
"KATAKANA LETTER BU",
"KATAKANA LETTER PU",
"KATAKANA LETTER HE",
"KATAKANA LETTER BE",
"KATAKANA LETTER PE",
"KATAKANA LETTER HO",
"KATAKANA LETTER BO",
"KATAKANA LETTER PO",
"KATAKANA LETTER MA",
"KATAKANA LETTER MI",
"KATAKANA LETTER MU",
"KATAKANA LETTER ME",
"KATAKANA LETTER MO",
"KATAKANA LETTER SMALL YA",
"KATAKANA LETTER YA",
"KATAKANA LETTER SMALL YU",
"KATAKANA LETTER YU",
"KATAKANA LETTER SMALL YO",
"KATAKANA LETTER YO",
"KATAKANA LETTER RA",
"KATAKANA LETTER RI",
"KATAKANA LETTER RU",
"KATAKANA LETTER RE",
"KATAKANA LETTER RO",
"KATAKANA LETTER SMALL WA",
"KATAKANA LETTER WA",
"KATAKANA LETTER WI",
"KATAKANA LETTER WE",
"KATAKANA LETTER WO",
"KATAKANA LETTER N",
"KATAKANA LETTER VU",
"KATAKANA LETTER SMALL KA",
"KATAKANA LETTER SMALL KE",
"KATAKANA LETTER VA",
"KATAKANA LETTER VI",
"KATAKANA LETTER VE",
"KATAKANA LETTER VO",
"KATAKANA MIDDLE DOT",
"KATAKANA-HIRAGANA PROLONGED SOUND MARK",
"KATAKANA ITERATION MARK",
"KATAKANA VOICED ITERATION MARK",
"KATAKANA DIGRAPH KOTO"};
static const char * name_0031[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"BOPOMOFO LETTER B",
"BOPOMOFO LETTER P",
"BOPOMOFO LETTER M",
"BOPOMOFO LETTER F",
"BOPOMOFO LETTER D",
"BOPOMOFO LETTER T",
"BOPOMOFO LETTER N",
"BOPOMOFO LETTER L",
"BOPOMOFO LETTER G",
"BOPOMOFO LETTER K",
"BOPOMOFO LETTER H",
"BOPOMOFO LETTER J",
"BOPOMOFO LETTER Q",
"BOPOMOFO LETTER X",
"BOPOMOFO LETTER ZH",
"BOPOMOFO LETTER CH",
"BOPOMOFO LETTER SH",
"BOPOMOFO LETTER R",
"BOPOMOFO LETTER Z",
"BOPOMOFO LETTER C",
"BOPOMOFO LETTER S",
"BOPOMOFO LETTER A",
"BOPOMOFO LETTER O",
"BOPOMOFO LETTER E",
"BOPOMOFO LETTER EH",
"BOPOMOFO LETTER AI",
"BOPOMOFO LETTER EI",
"BOPOMOFO LETTER AU",
"BOPOMOFO LETTER OU",
"BOPOMOFO LETTER AN",
"BOPOMOFO LETTER EN",
"BOPOMOFO LETTER ANG",
"BOPOMOFO LETTER ENG",
"BOPOMOFO LETTER ER",
"BOPOMOFO LETTER I",
"BOPOMOFO LETTER U",
"BOPOMOFO LETTER IU",
"BOPOMOFO LETTER V",
"BOPOMOFO LETTER NG",
"BOPOMOFO LETTER GN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"HANGUL LETTER KIYEOK",
"HANGUL LETTER SSANGKIYEOK",
"HANGUL LETTER KIYEOK-SIOS",
"HANGUL LETTER NIEUN",
"HANGUL LETTER NIEUN-CIEUC",
"HANGUL LETTER NIEUN-HIEUH",
"HANGUL LETTER TIKEUT",
"HANGUL LETTER SSANGTIKEUT",
"HANGUL LETTER RIEUL",
"HANGUL LETTER RIEUL-KIYEOK",
"HANGUL LETTER RIEUL-MIEUM",
"HANGUL LETTER RIEUL-PIEUP",
"HANGUL LETTER RIEUL-SIOS",
"HANGUL LETTER RIEUL-THIEUTH",
"HANGUL LETTER RIEUL-PHIEUPH",
"HANGUL LETTER RIEUL-HIEUH",
"HANGUL LETTER MIEUM",
"HANGUL LETTER PIEUP",
"HANGUL LETTER SSANGPIEUP",
"HANGUL LETTER PIEUP-SIOS",
"HANGUL LETTER SIOS",
"HANGUL LETTER SSANGSIOS",
"HANGUL LETTER IEUNG",
"HANGUL LETTER CIEUC",
"HANGUL LETTER SSANGCIEUC",
"HANGUL LETTER CHIEUCH",
"HANGUL LETTER KHIEUKH",
"HANGUL LETTER THIEUTH",
"HANGUL LETTER PHIEUPH",
"HANGUL LETTER HIEUH",
"HANGUL LETTER A",
"HANGUL LETTER AE",
"HANGUL LETTER YA",
"HANGUL LETTER YAE",
"HANGUL LETTER EO",
"HANGUL LETTER E",
"HANGUL LETTER YEO",
"HANGUL LETTER YE",
"HANGUL LETTER O",
"HANGUL LETTER WA",
"HANGUL LETTER WAE",
"HANGUL LETTER OE",
"HANGUL LETTER YO",
"HANGUL LETTER U",
"HANGUL LETTER WEO",
"HANGUL LETTER WE",
"HANGUL LETTER WI",
"HANGUL LETTER YU",
"HANGUL LETTER EU",
"HANGUL LETTER YI",
"HANGUL LETTER I",
"HANGUL FILLER",
"HANGUL LETTER SSANGNIEUN",
"HANGUL LETTER NIEUN-TIKEUT",
"HANGUL LETTER NIEUN-SIOS",
"HANGUL LETTER NIEUN-PANSIOS",
"HANGUL LETTER RIEUL-KIYEOK-SIOS",
"HANGUL LETTER RIEUL-TIKEUT",
"HANGUL LETTER RIEUL-PIEUP-SIOS",
"HANGUL LETTER RIEUL-PANSIOS",
"HANGUL LETTER RIEUL-YEORINHIEUH",
"HANGUL LETTER MIEUM-PIEUP",
"HANGUL LETTER MIEUM-SIOS",
"HANGUL LETTER MIEUM-PANSIOS",
"HANGUL LETTER KAPYEOUNMIEUM",
"HANGUL LETTER PIEUP-KIYEOK",
"HANGUL LETTER PIEUP-TIKEUT",
"HANGUL LETTER PIEUP-SIOS-KIYEOK",
"HANGUL LETTER PIEUP-SIOS-TIKEUT",
"HANGUL LETTER PIEUP-CIEUC",
"HANGUL LETTER PIEUP-THIEUTH",
"HANGUL LETTER KAPYEOUNPIEUP",
"HANGUL LETTER KAPYEOUNSSANGPIEUP",
"HANGUL LETTER SIOS-KIYEOK",
"HANGUL LETTER SIOS-NIEUN",
"HANGUL LETTER SIOS-TIKEUT",
"HANGUL LETTER SIOS-PIEUP",
"HANGUL LETTER SIOS-CIEUC",
"HANGUL LETTER PANSIOS",
"HANGUL LETTER SSANGIEUNG",
"HANGUL LETTER YESIEUNG",
"HANGUL LETTER YESIEUNG-SIOS",
"HANGUL LETTER YESIEUNG-PANSIOS",
"HANGUL LETTER KAPYEOUNPHIEUPH",
"HANGUL LETTER SSANGHIEUH",
"HANGUL LETTER YEORINHIEUH",
"HANGUL LETTER YO-YA",
"HANGUL LETTER YO-YAE",
"HANGUL LETTER YO-I",
"HANGUL LETTER YU-YEO",
"HANGUL LETTER YU-YE",
"HANGUL LETTER YU-I",
"HANGUL LETTER ARAEA",
"HANGUL LETTER ARAEAE",
name_reserved,
"IDEOGRAPHIC ANNOTATION LINKING MARK",
"IDEOGRAPHIC ANNOTATION REVERSE MARK",
"IDEOGRAPHIC ANNOTATION ONE MARK",
"IDEOGRAPHIC ANNOTATION TWO MARK",
"IDEOGRAPHIC ANNOTATION THREE MARK",
"IDEOGRAPHIC ANNOTATION FOUR MARK",
"IDEOGRAPHIC ANNOTATION TOP MARK",
"IDEOGRAPHIC ANNOTATION MIDDLE MARK",
"IDEOGRAPHIC ANNOTATION BOTTOM MARK",
"IDEOGRAPHIC ANNOTATION FIRST MARK",
"IDEOGRAPHIC ANNOTATION SECOND MARK",
"IDEOGRAPHIC ANNOTATION THIRD MARK",
"IDEOGRAPHIC ANNOTATION FOURTH MARK",
"IDEOGRAPHIC ANNOTATION HEAVEN MARK",
"IDEOGRAPHIC ANNOTATION EARTH MARK",
"IDEOGRAPHIC ANNOTATION MAN MARK",
"BOPOMOFO LETTER BU",
"BOPOMOFO LETTER ZI",
"BOPOMOFO LETTER JI",
"BOPOMOFO LETTER GU",
"BOPOMOFO LETTER EE",
"BOPOMOFO LETTER ENN",
"BOPOMOFO LETTER OO",
"BOPOMOFO LETTER ONN",
"BOPOMOFO LETTER IR",
"BOPOMOFO LETTER ANN",
"BOPOMOFO LETTER INN",
"BOPOMOFO LETTER UNN",
"BOPOMOFO LETTER IM",
"BOPOMOFO LETTER NGG",
"BOPOMOFO LETTER AINN",
"BOPOMOFO LETTER AUNN",
"BOPOMOFO LETTER AM",
"BOPOMOFO LETTER OM",
"BOPOMOFO LETTER ONG",
"BOPOMOFO LETTER INNN",
"BOPOMOFO FINAL LETTER P",
"BOPOMOFO FINAL LETTER T",
"BOPOMOFO FINAL LETTER K",
"BOPOMOFO FINAL LETTER H",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"CJK STROKE T",
"CJK STROKE WG",
"CJK STROKE XG",
"CJK STROKE BXG",
"CJK STROKE SW",
"CJK STROKE HZZ",
"CJK STROKE HZG",
"CJK STROKE HP",
"CJK STROKE HZWG",
"CJK STROKE SZWG",
"CJK STROKE HZT",
"CJK STROKE HZZP",
"CJK STROKE HPWG",
"CJK STROKE HZW",
"CJK STROKE HZZZ",
"CJK STROKE N",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KATAKANA LETTER SMALL KU",
"KATAKANA LETTER SMALL SI",
"KATAKANA LETTER SMALL SU",
"KATAKANA LETTER SMALL TO",
"KATAKANA LETTER SMALL NU",
"KATAKANA LETTER SMALL HA",
"KATAKANA LETTER SMALL HI",
"KATAKANA LETTER SMALL HU",
"KATAKANA LETTER SMALL HE",
"KATAKANA LETTER SMALL HO",
"KATAKANA LETTER SMALL MU",
"KATAKANA LETTER SMALL RA",
"KATAKANA LETTER SMALL RI",
"KATAKANA LETTER SMALL RU",
"KATAKANA LETTER SMALL RE",
"KATAKANA LETTER SMALL RO"};
static const char * name_0032[256] =
{
"PARENTHESIZED HANGUL KIYEOK",
"PARENTHESIZED HANGUL NIEUN",
"PARENTHESIZED HANGUL TIKEUT",
"PARENTHESIZED HANGUL RIEUL",
"PARENTHESIZED HANGUL MIEUM",
"PARENTHESIZED HANGUL PIEUP",
"PARENTHESIZED HANGUL SIOS",
"PARENTHESIZED HANGUL IEUNG",
"PARENTHESIZED HANGUL CIEUC",
"PARENTHESIZED HANGUL CHIEUCH",
"PARENTHESIZED HANGUL KHIEUKH",
"PARENTHESIZED HANGUL THIEUTH",
"PARENTHESIZED HANGUL PHIEUPH",
"PARENTHESIZED HANGUL HIEUH",
"PARENTHESIZED HANGUL KIYEOK A",
"PARENTHESIZED HANGUL NIEUN A",
"PARENTHESIZED HANGUL TIKEUT A",
"PARENTHESIZED HANGUL RIEUL A",
"PARENTHESIZED HANGUL MIEUM A",
"PARENTHESIZED HANGUL PIEUP A",
"PARENTHESIZED HANGUL SIOS A",
"PARENTHESIZED HANGUL IEUNG A",
"PARENTHESIZED HANGUL CIEUC A",
"PARENTHESIZED HANGUL CHIEUCH A",
"PARENTHESIZED HANGUL KHIEUKH A",
"PARENTHESIZED HANGUL THIEUTH A",
"PARENTHESIZED HANGUL PHIEUPH A",
"PARENTHESIZED HANGUL HIEUH A",
"PARENTHESIZED HANGUL CIEUC U",
"PARENTHESIZED KOREAN CHARACTER OJEON",
"PARENTHESIZED KOREAN CHARACTER O HU",
name_reserved,
"PARENTHESIZED IDEOGRAPH ONE",
"PARENTHESIZED IDEOGRAPH TWO",
"PARENTHESIZED IDEOGRAPH THREE",
"PARENTHESIZED IDEOGRAPH FOUR",
"PARENTHESIZED IDEOGRAPH FIVE",
"PARENTHESIZED IDEOGRAPH SIX",
"PARENTHESIZED IDEOGRAPH SEVEN",
"PARENTHESIZED IDEOGRAPH EIGHT",
"PARENTHESIZED IDEOGRAPH NINE",
"PARENTHESIZED IDEOGRAPH TEN",
"PARENTHESIZED IDEOGRAPH MOON",
"PARENTHESIZED IDEOGRAPH FIRE",
"PARENTHESIZED IDEOGRAPH WATER",
"PARENTHESIZED IDEOGRAPH WOOD",
"PARENTHESIZED IDEOGRAPH METAL",
"PARENTHESIZED IDEOGRAPH EARTH",
"PARENTHESIZED IDEOGRAPH SUN",
"PARENTHESIZED IDEOGRAPH STOCK",
"PARENTHESIZED IDEOGRAPH HAVE",
"PARENTHESIZED IDEOGRAPH SOCIETY",
"PARENTHESIZED IDEOGRAPH NAME",
"PARENTHESIZED IDEOGRAPH SPECIAL",
"PARENTHESIZED IDEOGRAPH FINANCIAL",
"PARENTHESIZED IDEOGRAPH CONGRATULATION",
"PARENTHESIZED IDEOGRAPH LABOR",
"PARENTHESIZED IDEOGRAPH REPRESENT",
"PARENTHESIZED IDEOGRAPH CALL",
"PARENTHESIZED IDEOGRAPH STUDY",
"PARENTHESIZED IDEOGRAPH SUPERVISE",
"PARENTHESIZED IDEOGRAPH ENTERPRISE",
"PARENTHESIZED IDEOGRAPH RESOURCE",
"PARENTHESIZED IDEOGRAPH ALLIANCE",
"PARENTHESIZED IDEOGRAPH FESTIVAL",
"PARENTHESIZED IDEOGRAPH REST",
"PARENTHESIZED IDEOGRAPH SELF",
"PARENTHESIZED IDEOGRAPH REACH",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"PARTNERSHIP SIGN",
"CIRCLED NUMBER TWENTY ONE",
"CIRCLED NUMBER TWENTY TWO",
"CIRCLED NUMBER TWENTY THREE",
"CIRCLED NUMBER TWENTY FOUR",
"CIRCLED NUMBER TWENTY FIVE",
"CIRCLED NUMBER TWENTY SIX",
"CIRCLED NUMBER TWENTY SEVEN",
"CIRCLED NUMBER TWENTY EIGHT",
"CIRCLED NUMBER TWENTY NINE",
"CIRCLED NUMBER THIRTY",
"CIRCLED NUMBER THIRTY ONE",
"CIRCLED NUMBER THIRTY TWO",
"CIRCLED NUMBER THIRTY THREE",
"CIRCLED NUMBER THIRTY FOUR",
"CIRCLED NUMBER THIRTY FIVE",
"CIRCLED HANGUL KIYEOK",
"CIRCLED HANGUL NIEUN",
"CIRCLED HANGUL TIKEUT",
"CIRCLED HANGUL RIEUL",
"CIRCLED HANGUL MIEUM",
"CIRCLED HANGUL PIEUP",
"CIRCLED HANGUL SIOS",
"CIRCLED HANGUL IEUNG",
"CIRCLED HANGUL CIEUC",
"CIRCLED HANGUL CHIEUCH",
"CIRCLED HANGUL KHIEUKH",
"CIRCLED HANGUL THIEUTH",
"CIRCLED HANGUL PHIEUPH",
"CIRCLED HANGUL HIEUH",
"CIRCLED HANGUL KIYEOK A",
"CIRCLED HANGUL NIEUN A",
"CIRCLED HANGUL TIKEUT A",
"CIRCLED HANGUL RIEUL A",
"CIRCLED HANGUL MIEUM A",
"CIRCLED HANGUL PIEUP A",
"CIRCLED HANGUL SIOS A",
"CIRCLED HANGUL IEUNG A",
"CIRCLED HANGUL CIEUC A",
"CIRCLED HANGUL CHIEUCH A",
"CIRCLED HANGUL KHIEUKH A",
"CIRCLED HANGUL THIEUTH A",
"CIRCLED HANGUL PHIEUPH A",
"CIRCLED HANGUL HIEUH A",
"CIRCLED KOREAN CHARACTER CHAMKO",
"CIRCLED KOREAN CHARACTER JUEUI",
"CIRCLED HANGUL IEUNG U",
"KOREAN STANDARD SYMBOL",
"CIRCLED IDEOGRAPH ONE",
"CIRCLED IDEOGRAPH TWO",
"CIRCLED IDEOGRAPH THREE",
"CIRCLED IDEOGRAPH FOUR",
"CIRCLED IDEOGRAPH FIVE",
"CIRCLED IDEOGRAPH SIX",
"CIRCLED IDEOGRAPH SEVEN",
"CIRCLED IDEOGRAPH EIGHT",
"CIRCLED IDEOGRAPH NINE",
"CIRCLED IDEOGRAPH TEN",
"CIRCLED IDEOGRAPH MOON",
"CIRCLED IDEOGRAPH FIRE",
"CIRCLED IDEOGRAPH WATER",
"CIRCLED IDEOGRAPH WOOD",
"CIRCLED IDEOGRAPH METAL",
"CIRCLED IDEOGRAPH EARTH",
"CIRCLED IDEOGRAPH SUN",
"CIRCLED IDEOGRAPH STOCK",
"CIRCLED IDEOGRAPH HAVE",
"CIRCLED IDEOGRAPH SOCIETY",
"CIRCLED IDEOGRAPH NAME",
"CIRCLED IDEOGRAPH SPECIAL",
"CIRCLED IDEOGRAPH FINANCIAL",
"CIRCLED IDEOGRAPH CONGRATULATION",
"CIRCLED IDEOGRAPH LABOR",
"CIRCLED IDEOGRAPH SECRET",
"CIRCLED IDEOGRAPH MALE",
"CIRCLED IDEOGRAPH FEMALE",
"CIRCLED IDEOGRAPH SUITABLE",
"CIRCLED IDEOGRAPH EXCELLENT",
"CIRCLED IDEOGRAPH PRINT",
"CIRCLED IDEOGRAPH ATTENTION",
"CIRCLED IDEOGRAPH ITEM",
"CIRCLED IDEOGRAPH REST",
"CIRCLED IDEOGRAPH COPY",
"CIRCLED IDEOGRAPH CORRECT",
"CIRCLED IDEOGRAPH HIGH",
"CIRCLED IDEOGRAPH CENTRE",
"CIRCLED IDEOGRAPH LOW",
"CIRCLED IDEOGRAPH LEFT",
"CIRCLED IDEOGRAPH RIGHT",
"CIRCLED IDEOGRAPH MEDICINE",
"CIRCLED IDEOGRAPH RELIGION",
"CIRCLED IDEOGRAPH STUDY",
"CIRCLED IDEOGRAPH SUPERVISE",
"CIRCLED IDEOGRAPH ENTERPRISE",
"CIRCLED IDEOGRAPH RESOURCE",
"CIRCLED IDEOGRAPH ALLIANCE",
"CIRCLED IDEOGRAPH NIGHT",
"CIRCLED NUMBER THIRTY SIX",
"CIRCLED NUMBER THIRTY SEVEN",
"CIRCLED NUMBER THIRTY EIGHT",
"CIRCLED NUMBER THIRTY NINE",
"CIRCLED NUMBER FORTY",
"CIRCLED NUMBER FORTY ONE",
"CIRCLED NUMBER FORTY TWO",
"CIRCLED NUMBER FORTY THREE",
"CIRCLED NUMBER FORTY FOUR",
"CIRCLED NUMBER FORTY FIVE",
"CIRCLED NUMBER FORTY SIX",
"CIRCLED NUMBER FORTY SEVEN",
"CIRCLED NUMBER FORTY EIGHT",
"CIRCLED NUMBER FORTY NINE",
"CIRCLED NUMBER FIFTY",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER",
"SQUARE HG",
"SQUARE ERG",
"SQUARE EV",
"LIMITED LIABILITY SIGN",
"CIRCLED KATAKANA A",
"CIRCLED KATAKANA I",
"CIRCLED KATAKANA U",
"CIRCLED KATAKANA E",
"CIRCLED KATAKANA O",
"CIRCLED KATAKANA KA",
"CIRCLED KATAKANA KI",
"CIRCLED KATAKANA KU",
"CIRCLED KATAKANA KE",
"CIRCLED KATAKANA KO",
"CIRCLED KATAKANA SA",
"CIRCLED KATAKANA SI",
"CIRCLED KATAKANA SU",
"CIRCLED KATAKANA SE",
"CIRCLED KATAKANA SO",
"CIRCLED KATAKANA TA",
"CIRCLED KATAKANA TI",
"CIRCLED KATAKANA TU",
"CIRCLED KATAKANA TE",
"CIRCLED KATAKANA TO",
"CIRCLED KATAKANA NA",
"CIRCLED KATAKANA NI",
"CIRCLED KATAKANA NU",
"CIRCLED KATAKANA NE",
"CIRCLED KATAKANA NO",
"CIRCLED KATAKANA HA",
"CIRCLED KATAKANA HI",
"CIRCLED KATAKANA HU",
"CIRCLED KATAKANA HE",
"CIRCLED KATAKANA HO",
"CIRCLED KATAKANA MA",
"CIRCLED KATAKANA MI",
"CIRCLED KATAKANA MU",
"CIRCLED KATAKANA ME",
"CIRCLED KATAKANA MO",
"CIRCLED KATAKANA YA",
"CIRCLED KATAKANA YU",
"CIRCLED KATAKANA YO",
"CIRCLED KATAKANA RA",
"CIRCLED KATAKANA RI",
"CIRCLED KATAKANA RU",
"CIRCLED KATAKANA RE",
"CIRCLED KATAKANA RO",
"CIRCLED KATAKANA WA",
"CIRCLED KATAKANA WI",
"CIRCLED KATAKANA WE",
"CIRCLED KATAKANA WO",
name_reserved};
static const char * name_0033[256] =
{
"SQUARE APAATO",
"SQUARE ARUHUA",
"SQUARE ANPEA",
"SQUARE AARU",
"SQUARE ININGU",
"SQUARE INTI",
"SQUARE UON",
"SQUARE ESUKUUDO",
"SQUARE EEKAA",
"SQUARE ONSU",
"SQUARE OOMU",
"SQUARE KAIRI",
"SQUARE KARATTO",
"SQUARE KARORII",
"SQUARE GARON",
"SQUARE GANMA",
"SQUARE GIGA",
"SQUARE GINII",
"SQUARE KYURII",
"SQUARE GIRUDAA",
"SQUARE KIRO",
"SQUARE KIROGURAMU",
"SQUARE KIROMEETORU",
"SQUARE KIROWATTO",
"SQUARE GURAMU",
"SQUARE GURAMUTON",
"SQUARE KURUZEIRO",
"SQUARE KUROONE",
"SQUARE KEESU",
"SQUARE KORUNA",
"SQUARE KOOPO",
"SQUARE SAIKURU",
"SQUARE SANTIIMU",
"SQUARE SIRINGU",
"SQUARE SENTI",
"SQUARE SENTO",
"SQUARE DAASU",
"SQUARE DESI",
"SQUARE DORU",
"SQUARE TON",
"SQUARE NANO",
"SQUARE NOTTO",
"SQUARE HAITU",
"SQUARE PAASENTO",
"SQUARE PAATU",
"SQUARE BAARERU",
"SQUARE PIASUTORU",
"SQUARE PIKURU",
"SQUARE PIKO",
"SQUARE BIRU",
"SQUARE HUARADDO",
"SQUARE HUIITO",
"SQUARE BUSSYERU",
"SQUARE HURAN",
"SQUARE HEKUTAARU",
"SQUARE PESO",
"SQUARE PENIHI",
"SQUARE HERUTU",
"SQUARE PENSU",
"SQUARE PEEZI",
"SQUARE BEETA",
"SQUARE POINTO",
"SQUARE BORUTO",
"SQUARE HON",
"SQUARE PONDO",
"SQUARE HOORU",
"SQUARE HOON",
"SQUARE MAIKURO",
"SQUARE MAIRU",
"SQUARE MAHHA",
"SQUARE MARUKU",
"SQUARE MANSYON",
"SQUARE MIKURON",
"SQUARE MIRI",
"SQUARE MIRIBAARU",
"SQUARE MEGA",
"SQUARE MEGATON",
"SQUARE MEETORU",
"SQUARE YAADO",
"SQUARE YAARU",
"SQUARE YUAN",
"SQUARE RITTORU",
"SQUARE RIRA",
"SQUARE RUPII",
"SQUARE RUUBURU",
"SQUARE REMU",
"SQUARE RENTOGEN",
"SQUARE WATTO",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR",
"SQUARE HPA",
"SQUARE DA",
"SQUARE AU",
"SQUARE BAR",
"SQUARE OV",
"SQUARE PC",
"SQUARE DM",
"SQUARE DM SQUARED",
"SQUARE DM CUBED",
"SQUARE IU",
"SQUARE ERA NAME HEISEI",
"SQUARE ERA NAME SYOUWA",
"SQUARE ERA NAME TAISYOU",
"SQUARE ERA NAME MEIZI",
"SQUARE CORPORATION",
"SQUARE PA AMPS",
"SQUARE NA",
"SQUARE MU A",
"SQUARE MA",
"SQUARE KA",
"SQUARE KB",
"SQUARE MB",
"SQUARE GB",
"SQUARE CAL",
"SQUARE KCAL",
"SQUARE PF",
"SQUARE NF",
"SQUARE MU F",
"SQUARE MU G",
"SQUARE MG",
"SQUARE KG",
"SQUARE HZ",
"SQUARE KHZ",
"SQUARE MHZ",
"SQUARE GHZ",
"SQUARE THZ",
"SQUARE MU L",
"SQUARE ML",
"SQUARE DL",
"SQUARE KL",
"SQUARE FM",
"SQUARE NM",
"SQUARE MU M",
"SQUARE MM",
"SQUARE CM",
"SQUARE KM",
"SQUARE MM SQUARED",
"SQUARE CM SQUARED",
"SQUARE M SQUARED",
"SQUARE KM SQUARED",
"SQUARE MM CUBED",
"SQUARE CM CUBED",
"SQUARE M CUBED",
"SQUARE KM CUBED",
"SQUARE M OVER S",
"SQUARE M OVER S SQUARED",
"SQUARE PA",
"SQUARE KPA",
"SQUARE MPA",
"SQUARE GPA",
"SQUARE RAD",
"SQUARE RAD OVER S",
"SQUARE RAD OVER S SQUARED",
"SQUARE PS",
"SQUARE NS",
"SQUARE MU S",
"SQUARE MS",
"SQUARE PV",
"SQUARE NV",
"SQUARE MU V",
"SQUARE MV",
"SQUARE KV",
"SQUARE MV MEGA",
"SQUARE PW",
"SQUARE NW",
"SQUARE MU W",
"SQUARE MW",
"SQUARE KW",
"SQUARE MW MEGA",
"SQUARE K OHM",
"SQUARE M OHM",
"SQUARE AM",
"SQUARE BQ",
"SQUARE CC",
"SQUARE CD",
"SQUARE C OVER KG",
"SQUARE CO",
"SQUARE DB",
"SQUARE GY",
"SQUARE HA",
"SQUARE HP",
"SQUARE IN",
"SQUARE KK",
"SQUARE KM CAPITAL",
"SQUARE KT",
"SQUARE LM",
"SQUARE LN",
"SQUARE LOG",
"SQUARE LX",
"SQUARE MB SMALL",
"SQUARE MIL",
"SQUARE MOL",
"SQUARE PH",
"SQUARE PM",
"SQUARE PPM",
"SQUARE PR",
"SQUARE SR",
"SQUARE SV",
"SQUARE WB",
"SQUARE V OVER M",
"SQUARE A OVER M",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY",
"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE",
"SQUARE GAL"};
static const char * name_0034[256] =
{
"<CJK Ideograph Extension A, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_004d[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<CJK Ideograph Extension A, Last>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"HEXAGRAM FOR THE CREATIVE HEAVEN",
"HEXAGRAM FOR THE RECEPTIVE EARTH",
"HEXAGRAM FOR DIFFICULTY AT THE BEGINNING",
"HEXAGRAM FOR YOUTHFUL FOLLY",
"HEXAGRAM FOR WAITING",
"HEXAGRAM FOR CONFLICT",
"HEXAGRAM FOR THE ARMY",
"HEXAGRAM FOR HOLDING TOGETHER",
"HEXAGRAM FOR SMALL TAMING",
"HEXAGRAM FOR TREADING",
"HEXAGRAM FOR PEACE",
"HEXAGRAM FOR STANDSTILL",
"HEXAGRAM FOR FELLOWSHIP",
"HEXAGRAM FOR GREAT POSSESSION",
"HEXAGRAM FOR MODESTY",
"HEXAGRAM FOR ENTHUSIASM",
"HEXAGRAM FOR FOLLOWING",
"HEXAGRAM FOR WORK ON THE DECAYED",
"HEXAGRAM FOR APPROACH",
"HEXAGRAM FOR CONTEMPLATION",
"HEXAGRAM FOR BITING THROUGH",
"HEXAGRAM FOR GRACE",
"HEXAGRAM FOR SPLITTING APART",
"HEXAGRAM FOR RETURN",
"HEXAGRAM FOR INNOCENCE",
"HEXAGRAM FOR GREAT TAMING",
"HEXAGRAM FOR MOUTH CORNERS",
"HEXAGRAM FOR GREAT PREPONDERANCE",
"HEXAGRAM FOR THE ABYSMAL WATER",
"HEXAGRAM FOR THE CLINGING FIRE",
"HEXAGRAM FOR INFLUENCE",
"HEXAGRAM FOR DURATION",
"HEXAGRAM FOR RETREAT",
"HEXAGRAM FOR GREAT POWER",
"HEXAGRAM FOR PROGRESS",
"HEXAGRAM FOR DARKENING OF THE LIGHT",
"HEXAGRAM FOR THE FAMILY",
"HEXAGRAM FOR OPPOSITION",
"HEXAGRAM FOR OBSTRUCTION",
"HEXAGRAM FOR DELIVERANCE",
"HEXAGRAM FOR DECREASE",
"HEXAGRAM FOR INCREASE",
"HEXAGRAM FOR BREAKTHROUGH",
"HEXAGRAM FOR COMING TO MEET",
"HEXAGRAM FOR GATHERING TOGETHER",
"HEXAGRAM FOR PUSHING UPWARD",
"HEXAGRAM FOR OPPRESSION",
"HEXAGRAM FOR THE WELL",
"HEXAGRAM FOR REVOLUTION",
"HEXAGRAM FOR THE CAULDRON",
"HEXAGRAM FOR THE AROUSING THUNDER",
"HEXAGRAM FOR THE KEEPING STILL MOUNTAIN",
"HEXAGRAM FOR DEVELOPMENT",
"HEXAGRAM FOR THE MARRYING MAIDEN",
"HEXAGRAM FOR ABUNDANCE",
"HEXAGRAM FOR THE WANDERER",
"HEXAGRAM FOR THE GENTLE WIND",
"HEXAGRAM FOR THE JOYOUS LAKE",
"HEXAGRAM FOR DISPERSION",
"HEXAGRAM FOR LIMITATION",
"HEXAGRAM FOR INNER TRUTH",
"HEXAGRAM FOR SMALL PREPONDERANCE",
"HEXAGRAM FOR AFTER COMPLETION",
"HEXAGRAM FOR BEFORE COMPLETION"};
static const char * name_004e[256] =
{
"<CJK Ideograph, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_009f[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<CJK Ideograph, Last>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00a0[256] =
{
"YI SYLLABLE IT",
"YI SYLLABLE IX",
"YI SYLLABLE I",
"YI SYLLABLE IP",
"YI SYLLABLE IET",
"YI SYLLABLE IEX",
"YI SYLLABLE IE",
"YI SYLLABLE IEP",
"YI SYLLABLE AT",
"YI SYLLABLE AX",
"YI SYLLABLE A",
"YI SYLLABLE AP",
"YI SYLLABLE UOX",
"YI SYLLABLE UO",
"YI SYLLABLE UOP",
"YI SYLLABLE OT",
"YI SYLLABLE OX",
"YI SYLLABLE O",
"YI SYLLABLE OP",
"YI SYLLABLE EX",
"YI SYLLABLE E",
"YI SYLLABLE WU",
"YI SYLLABLE BIT",
"YI SYLLABLE BIX",
"YI SYLLABLE BI",
"YI SYLLABLE BIP",
"YI SYLLABLE BIET",
"YI SYLLABLE BIEX",
"YI SYLLABLE BIE",
"YI SYLLABLE BIEP",
"YI SYLLABLE BAT",
"YI SYLLABLE BAX",
"YI SYLLABLE BA",
"YI SYLLABLE BAP",
"YI SYLLABLE BUOX",
"YI SYLLABLE BUO",
"YI SYLLABLE BUOP",
"YI SYLLABLE BOT",
"YI SYLLABLE BOX",
"YI SYLLABLE BO",
"YI SYLLABLE BOP",
"YI SYLLABLE BEX",
"YI SYLLABLE BE",
"YI SYLLABLE BEP",
"YI SYLLABLE BUT",
"YI SYLLABLE BUX",
"YI SYLLABLE BU",
"YI SYLLABLE BUP",
"YI SYLLABLE BURX",
"YI SYLLABLE BUR",
"YI SYLLABLE BYT",
"YI SYLLABLE BYX",
"YI SYLLABLE BY",
"YI SYLLABLE BYP",
"YI SYLLABLE BYRX",
"YI SYLLABLE BYR",
"YI SYLLABLE PIT",
"YI SYLLABLE PIX",
"YI SYLLABLE PI",
"YI SYLLABLE PIP",
"YI SYLLABLE PIEX",
"YI SYLLABLE PIE",
"YI SYLLABLE PIEP",
"YI SYLLABLE PAT",
"YI SYLLABLE PAX",
"YI SYLLABLE PA",
"YI SYLLABLE PAP",
"YI SYLLABLE PUOX",
"YI SYLLABLE PUO",
"YI SYLLABLE PUOP",
"YI SYLLABLE POT",
"YI SYLLABLE POX",
"YI SYLLABLE PO",
"YI SYLLABLE POP",
"YI SYLLABLE PUT",
"YI SYLLABLE PUX",
"YI SYLLABLE PU",
"YI SYLLABLE PUP",
"YI SYLLABLE PURX",
"YI SYLLABLE PUR",
"YI SYLLABLE PYT",
"YI SYLLABLE PYX",
"YI SYLLABLE PY",
"YI SYLLABLE PYP",
"YI SYLLABLE PYRX",
"YI SYLLABLE PYR",
"YI SYLLABLE BBIT",
"YI SYLLABLE BBIX",
"YI SYLLABLE BBI",
"YI SYLLABLE BBIP",
"YI SYLLABLE BBIET",
"YI SYLLABLE BBIEX",
"YI SYLLABLE BBIE",
"YI SYLLABLE BBIEP",
"YI SYLLABLE BBAT",
"YI SYLLABLE BBAX",
"YI SYLLABLE BBA",
"YI SYLLABLE BBAP",
"YI SYLLABLE BBUOX",
"YI SYLLABLE BBUO",
"YI SYLLABLE BBUOP",
"YI SYLLABLE BBOT",
"YI SYLLABLE BBOX",
"YI SYLLABLE BBO",
"YI SYLLABLE BBOP",
"YI SYLLABLE BBEX",
"YI SYLLABLE BBE",
"YI SYLLABLE BBEP",
"YI SYLLABLE BBUT",
"YI SYLLABLE BBUX",
"YI SYLLABLE BBU",
"YI SYLLABLE BBUP",
"YI SYLLABLE BBURX",
"YI SYLLABLE BBUR",
"YI SYLLABLE BBYT",
"YI SYLLABLE BBYX",
"YI SYLLABLE BBY",
"YI SYLLABLE BBYP",
"YI SYLLABLE NBIT",
"YI SYLLABLE NBIX",
"YI SYLLABLE NBI",
"YI SYLLABLE NBIP",
"YI SYLLABLE NBIEX",
"YI SYLLABLE NBIE",
"YI SYLLABLE NBIEP",
"YI SYLLABLE NBAT",
"YI SYLLABLE NBAX",
"YI SYLLABLE NBA",
"YI SYLLABLE NBAP",
"YI SYLLABLE NBOT",
"YI SYLLABLE NBOX",
"YI SYLLABLE NBO",
"YI SYLLABLE NBOP",
"YI SYLLABLE NBUT",
"YI SYLLABLE NBUX",
"YI SYLLABLE NBU",
"YI SYLLABLE NBUP",
"YI SYLLABLE NBURX",
"YI SYLLABLE NBUR",
"YI SYLLABLE NBYT",
"YI SYLLABLE NBYX",
"YI SYLLABLE NBY",
"YI SYLLABLE NBYP",
"YI SYLLABLE NBYRX",
"YI SYLLABLE NBYR",
"YI SYLLABLE HMIT",
"YI SYLLABLE HMIX",
"YI SYLLABLE HMI",
"YI SYLLABLE HMIP",
"YI SYLLABLE HMIEX",
"YI SYLLABLE HMIE",
"YI SYLLABLE HMIEP",
"YI SYLLABLE HMAT",
"YI SYLLABLE HMAX",
"YI SYLLABLE HMA",
"YI SYLLABLE HMAP",
"YI SYLLABLE HMUOX",
"YI SYLLABLE HMUO",
"YI SYLLABLE HMUOP",
"YI SYLLABLE HMOT",
"YI SYLLABLE HMOX",
"YI SYLLABLE HMO",
"YI SYLLABLE HMOP",
"YI SYLLABLE HMUT",
"YI SYLLABLE HMUX",
"YI SYLLABLE HMU",
"YI SYLLABLE HMUP",
"YI SYLLABLE HMURX",
"YI SYLLABLE HMUR",
"YI SYLLABLE HMYX",
"YI SYLLABLE HMY",
"YI SYLLABLE HMYP",
"YI SYLLABLE HMYRX",
"YI SYLLABLE HMYR",
"YI SYLLABLE MIT",
"YI SYLLABLE MIX",
"YI SYLLABLE MI",
"YI SYLLABLE MIP",
"YI SYLLABLE MIEX",
"YI SYLLABLE MIE",
"YI SYLLABLE MIEP",
"YI SYLLABLE MAT",
"YI SYLLABLE MAX",
"YI SYLLABLE MA",
"YI SYLLABLE MAP",
"YI SYLLABLE MUOT",
"YI SYLLABLE MUOX",
"YI SYLLABLE MUO",
"YI SYLLABLE MUOP",
"YI SYLLABLE MOT",
"YI SYLLABLE MOX",
"YI SYLLABLE MO",
"YI SYLLABLE MOP",
"YI SYLLABLE MEX",
"YI SYLLABLE ME",
"YI SYLLABLE MUT",
"YI SYLLABLE MUX",
"YI SYLLABLE MU",
"YI SYLLABLE MUP",
"YI SYLLABLE MURX",
"YI SYLLABLE MUR",
"YI SYLLABLE MYT",
"YI SYLLABLE MYX",
"YI SYLLABLE MY",
"YI SYLLABLE MYP",
"YI SYLLABLE FIT",
"YI SYLLABLE FIX",
"YI SYLLABLE FI",
"YI SYLLABLE FIP",
"YI SYLLABLE FAT",
"YI SYLLABLE FAX",
"YI SYLLABLE FA",
"YI SYLLABLE FAP",
"YI SYLLABLE FOX",
"YI SYLLABLE FO",
"YI SYLLABLE FOP",
"YI SYLLABLE FUT",
"YI SYLLABLE FUX",
"YI SYLLABLE FU",
"YI SYLLABLE FUP",
"YI SYLLABLE FURX",
"YI SYLLABLE FUR",
"YI SYLLABLE FYT",
"YI SYLLABLE FYX",
"YI SYLLABLE FY",
"YI SYLLABLE FYP",
"YI SYLLABLE VIT",
"YI SYLLABLE VIX",
"YI SYLLABLE VI",
"YI SYLLABLE VIP",
"YI SYLLABLE VIET",
"YI SYLLABLE VIEX",
"YI SYLLABLE VIE",
"YI SYLLABLE VIEP",
"YI SYLLABLE VAT",
"YI SYLLABLE VAX",
"YI SYLLABLE VA",
"YI SYLLABLE VAP",
"YI SYLLABLE VOT",
"YI SYLLABLE VOX",
"YI SYLLABLE VO",
"YI SYLLABLE VOP",
"YI SYLLABLE VEX",
"YI SYLLABLE VEP",
"YI SYLLABLE VUT",
"YI SYLLABLE VUX",
"YI SYLLABLE VU",
"YI SYLLABLE VUP",
"YI SYLLABLE VURX",
"YI SYLLABLE VUR",
"YI SYLLABLE VYT",
"YI SYLLABLE VYX",
"YI SYLLABLE VY",
"YI SYLLABLE VYP",
"YI SYLLABLE VYRX",
"YI SYLLABLE VYR"};
static const char * name_00a1[256] =
{
"YI SYLLABLE DIT",
"YI SYLLABLE DIX",
"YI SYLLABLE DI",
"YI SYLLABLE DIP",
"YI SYLLABLE DIEX",
"YI SYLLABLE DIE",
"YI SYLLABLE DIEP",
"YI SYLLABLE DAT",
"YI SYLLABLE DAX",
"YI SYLLABLE DA",
"YI SYLLABLE DAP",
"YI SYLLABLE DUOX",
"YI SYLLABLE DUO",
"YI SYLLABLE DOT",
"YI SYLLABLE DOX",
"YI SYLLABLE DO",
"YI SYLLABLE DOP",
"YI SYLLABLE DEX",
"YI SYLLABLE DE",
"YI SYLLABLE DEP",
"YI SYLLABLE DUT",
"YI SYLLABLE DUX",
"YI SYLLABLE DU",
"YI SYLLABLE DUP",
"YI SYLLABLE DURX",
"YI SYLLABLE DUR",
"YI SYLLABLE TIT",
"YI SYLLABLE TIX",
"YI SYLLABLE TI",
"YI SYLLABLE TIP",
"YI SYLLABLE TIEX",
"YI SYLLABLE TIE",
"YI SYLLABLE TIEP",
"YI SYLLABLE TAT",
"YI SYLLABLE TAX",
"YI SYLLABLE TA",
"YI SYLLABLE TAP",
"YI SYLLABLE TUOT",
"YI SYLLABLE TUOX",
"YI SYLLABLE TUO",
"YI SYLLABLE TUOP",
"YI SYLLABLE TOT",
"YI SYLLABLE TOX",
"YI SYLLABLE TO",
"YI SYLLABLE TOP",
"YI SYLLABLE TEX",
"YI SYLLABLE TE",
"YI SYLLABLE TEP",
"YI SYLLABLE TUT",
"YI SYLLABLE TUX",
"YI SYLLABLE TU",
"YI SYLLABLE TUP",
"YI SYLLABLE TURX",
"YI SYLLABLE TUR",
"YI SYLLABLE DDIT",
"YI SYLLABLE DDIX",
"YI SYLLABLE DDI",
"YI SYLLABLE DDIP",
"YI SYLLABLE DDIEX",
"YI SYLLABLE DDIE",
"YI SYLLABLE DDIEP",
"YI SYLLABLE DDAT",
"YI SYLLABLE DDAX",
"YI SYLLABLE DDA",
"YI SYLLABLE DDAP",
"YI SYLLABLE DDUOX",
"YI SYLLABLE DDUO",
"YI SYLLABLE DDUOP",
"YI SYLLABLE DDOT",
"YI SYLLABLE DDOX",
"YI SYLLABLE DDO",
"YI SYLLABLE DDOP",
"YI SYLLABLE DDEX",
"YI SYLLABLE DDE",
"YI SYLLABLE DDEP",
"YI SYLLABLE DDUT",
"YI SYLLABLE DDUX",
"YI SYLLABLE DDU",
"YI SYLLABLE DDUP",
"YI SYLLABLE DDURX",
"YI SYLLABLE DDUR",
"YI SYLLABLE NDIT",
"YI SYLLABLE NDIX",
"YI SYLLABLE NDI",
"YI SYLLABLE NDIP",
"YI SYLLABLE NDIEX",
"YI SYLLABLE NDIE",
"YI SYLLABLE NDAT",
"YI SYLLABLE NDAX",
"YI SYLLABLE NDA",
"YI SYLLABLE NDAP",
"YI SYLLABLE NDOT",
"YI SYLLABLE NDOX",
"YI SYLLABLE NDO",
"YI SYLLABLE NDOP",
"YI SYLLABLE NDEX",
"YI SYLLABLE NDE",
"YI SYLLABLE NDEP",
"YI SYLLABLE NDUT",
"YI SYLLABLE NDUX",
"YI SYLLABLE NDU",
"YI SYLLABLE NDUP",
"YI SYLLABLE NDURX",
"YI SYLLABLE NDUR",
"YI SYLLABLE HNIT",
"YI SYLLABLE HNIX",
"YI SYLLABLE HNI",
"YI SYLLABLE HNIP",
"YI SYLLABLE HNIET",
"YI SYLLABLE HNIEX",
"YI SYLLABLE HNIE",
"YI SYLLABLE HNIEP",
"YI SYLLABLE HNAT",
"YI SYLLABLE HNAX",
"YI SYLLABLE HNA",
"YI SYLLABLE HNAP",
"YI SYLLABLE HNUOX",
"YI SYLLABLE HNUO",
"YI SYLLABLE HNOT",
"YI SYLLABLE HNOX",
"YI SYLLABLE HNOP",
"YI SYLLABLE HNEX",
"YI SYLLABLE HNE",
"YI SYLLABLE HNEP",
"YI SYLLABLE HNUT",
"YI SYLLABLE NIT",
"YI SYLLABLE NIX",
"YI SYLLABLE NI",
"YI SYLLABLE NIP",
"YI SYLLABLE NIEX",
"YI SYLLABLE NIE",
"YI SYLLABLE NIEP",
"YI SYLLABLE NAX",
"YI SYLLABLE NA",
"YI SYLLABLE NAP",
"YI SYLLABLE NUOX",
"YI SYLLABLE NUO",
"YI SYLLABLE NUOP",
"YI SYLLABLE NOT",
"YI SYLLABLE NOX",
"YI SYLLABLE NO",
"YI SYLLABLE NOP",
"YI SYLLABLE NEX",
"YI SYLLABLE NE",
"YI SYLLABLE NEP",
"YI SYLLABLE NUT",
"YI SYLLABLE NUX",
"YI SYLLABLE NU",
"YI SYLLABLE NUP",
"YI SYLLABLE NURX",
"YI SYLLABLE NUR",
"YI SYLLABLE HLIT",
"YI SYLLABLE HLIX",
"YI SYLLABLE HLI",
"YI SYLLABLE HLIP",
"YI SYLLABLE HLIEX",
"YI SYLLABLE HLIE",
"YI SYLLABLE HLIEP",
"YI SYLLABLE HLAT",
"YI SYLLABLE HLAX",
"YI SYLLABLE HLA",
"YI SYLLABLE HLAP",
"YI SYLLABLE HLUOX",
"YI SYLLABLE HLUO",
"YI SYLLABLE HLUOP",
"YI SYLLABLE HLOX",
"YI SYLLABLE HLO",
"YI SYLLABLE HLOP",
"YI SYLLABLE HLEX",
"YI SYLLABLE HLE",
"YI SYLLABLE HLEP",
"YI SYLLABLE HLUT",
"YI SYLLABLE HLUX",
"YI SYLLABLE HLU",
"YI SYLLABLE HLUP",
"YI SYLLABLE HLURX",
"YI SYLLABLE HLUR",
"YI SYLLABLE HLYT",
"YI SYLLABLE HLYX",
"YI SYLLABLE HLY",
"YI SYLLABLE HLYP",
"YI SYLLABLE HLYRX",
"YI SYLLABLE HLYR",
"YI SYLLABLE LIT",
"YI SYLLABLE LIX",
"YI SYLLABLE LI",
"YI SYLLABLE LIP",
"YI SYLLABLE LIET",
"YI SYLLABLE LIEX",
"YI SYLLABLE LIE",
"YI SYLLABLE LIEP",
"YI SYLLABLE LAT",
"YI SYLLABLE LAX",
"YI SYLLABLE LA",
"YI SYLLABLE LAP",
"YI SYLLABLE LUOT",
"YI SYLLABLE LUOX",
"YI SYLLABLE LUO",
"YI SYLLABLE LUOP",
"YI SYLLABLE LOT",
"YI SYLLABLE LOX",
"YI SYLLABLE LO",
"YI SYLLABLE LOP",
"YI SYLLABLE LEX",
"YI SYLLABLE LE",
"YI SYLLABLE LEP",
"YI SYLLABLE LUT",
"YI SYLLABLE LUX",
"YI SYLLABLE LU",
"YI SYLLABLE LUP",
"YI SYLLABLE LURX",
"YI SYLLABLE LUR",
"YI SYLLABLE LYT",
"YI SYLLABLE LYX",
"YI SYLLABLE LY",
"YI SYLLABLE LYP",
"YI SYLLABLE LYRX",
"YI SYLLABLE LYR",
"YI SYLLABLE GIT",
"YI SYLLABLE GIX",
"YI SYLLABLE GI",
"YI SYLLABLE GIP",
"YI SYLLABLE GIET",
"YI SYLLABLE GIEX",
"YI SYLLABLE GIE",
"YI SYLLABLE GIEP",
"YI SYLLABLE GAT",
"YI SYLLABLE GAX",
"YI SYLLABLE GA",
"YI SYLLABLE GAP",
"YI SYLLABLE GUOT",
"YI SYLLABLE GUOX",
"YI SYLLABLE GUO",
"YI SYLLABLE GUOP",
"YI SYLLABLE GOT",
"YI SYLLABLE GOX",
"YI SYLLABLE GO",
"YI SYLLABLE GOP",
"YI SYLLABLE GET",
"YI SYLLABLE GEX",
"YI SYLLABLE GE",
"YI SYLLABLE GEP",
"YI SYLLABLE GUT",
"YI SYLLABLE GUX",
"YI SYLLABLE GU",
"YI SYLLABLE GUP",
"YI SYLLABLE GURX",
"YI SYLLABLE GUR",
"YI SYLLABLE KIT",
"YI SYLLABLE KIX",
"YI SYLLABLE KI",
"YI SYLLABLE KIP",
"YI SYLLABLE KIEX",
"YI SYLLABLE KIE",
"YI SYLLABLE KIEP",
"YI SYLLABLE KAT"};
static const char * name_00a2[256] =
{
"YI SYLLABLE KAX",
"YI SYLLABLE KA",
"YI SYLLABLE KAP",
"YI SYLLABLE KUOX",
"YI SYLLABLE KUO",
"YI SYLLABLE KUOP",
"YI SYLLABLE KOT",
"YI SYLLABLE KOX",
"YI SYLLABLE KO",
"YI SYLLABLE KOP",
"YI SYLLABLE KET",
"YI SYLLABLE KEX",
"YI SYLLABLE KE",
"YI SYLLABLE KEP",
"YI SYLLABLE KUT",
"YI SYLLABLE KUX",
"YI SYLLABLE KU",
"YI SYLLABLE KUP",
"YI SYLLABLE KURX",
"YI SYLLABLE KUR",
"YI SYLLABLE GGIT",
"YI SYLLABLE GGIX",
"YI SYLLABLE GGI",
"YI SYLLABLE GGIEX",
"YI SYLLABLE GGIE",
"YI SYLLABLE GGIEP",
"YI SYLLABLE GGAT",
"YI SYLLABLE GGAX",
"YI SYLLABLE GGA",
"YI SYLLABLE GGAP",
"YI SYLLABLE GGUOT",
"YI SYLLABLE GGUOX",
"YI SYLLABLE GGUO",
"YI SYLLABLE GGUOP",
"YI SYLLABLE GGOT",
"YI SYLLABLE GGOX",
"YI SYLLABLE GGO",
"YI SYLLABLE GGOP",
"YI SYLLABLE GGET",
"YI SYLLABLE GGEX",
"YI SYLLABLE GGE",
"YI SYLLABLE GGEP",
"YI SYLLABLE GGUT",
"YI SYLLABLE GGUX",
"YI SYLLABLE GGU",
"YI SYLLABLE GGUP",
"YI SYLLABLE GGURX",
"YI SYLLABLE GGUR",
"YI SYLLABLE MGIEX",
"YI SYLLABLE MGIE",
"YI SYLLABLE MGAT",
"YI SYLLABLE MGAX",
"YI SYLLABLE MGA",
"YI SYLLABLE MGAP",
"YI SYLLABLE MGUOX",
"YI SYLLABLE MGUO",
"YI SYLLABLE MGUOP",
"YI SYLLABLE MGOT",
"YI SYLLABLE MGOX",
"YI SYLLABLE MGO",
"YI SYLLABLE MGOP",
"YI SYLLABLE MGEX",
"YI SYLLABLE MGE",
"YI SYLLABLE MGEP",
"YI SYLLABLE MGUT",
"YI SYLLABLE MGUX",
"YI SYLLABLE MGU",
"YI SYLLABLE MGUP",
"YI SYLLABLE MGURX",
"YI SYLLABLE MGUR",
"YI SYLLABLE HXIT",
"YI SYLLABLE HXIX",
"YI SYLLABLE HXI",
"YI SYLLABLE HXIP",
"YI SYLLABLE HXIET",
"YI SYLLABLE HXIEX",
"YI SYLLABLE HXIE",
"YI SYLLABLE HXIEP",
"YI SYLLABLE HXAT",
"YI SYLLABLE HXAX",
"YI SYLLABLE HXA",
"YI SYLLABLE HXAP",
"YI SYLLABLE HXUOT",
"YI SYLLABLE HXUOX",
"YI SYLLABLE HXUO",
"YI SYLLABLE HXUOP",
"YI SYLLABLE HXOT",
"YI SYLLABLE HXOX",
"YI SYLLABLE HXO",
"YI SYLLABLE HXOP",
"YI SYLLABLE HXEX",
"YI SYLLABLE HXE",
"YI SYLLABLE HXEP",
"YI SYLLABLE NGIEX",
"YI SYLLABLE NGIE",
"YI SYLLABLE NGIEP",
"YI SYLLABLE NGAT",
"YI SYLLABLE NGAX",
"YI SYLLABLE NGA",
"YI SYLLABLE NGAP",
"YI SYLLABLE NGUOT",
"YI SYLLABLE NGUOX",
"YI SYLLABLE NGUO",
"YI SYLLABLE NGOT",
"YI SYLLABLE NGOX",
"YI SYLLABLE NGO",
"YI SYLLABLE NGOP",
"YI SYLLABLE NGEX",
"YI SYLLABLE NGE",
"YI SYLLABLE NGEP",
"YI SYLLABLE HIT",
"YI SYLLABLE HIEX",
"YI SYLLABLE HIE",
"YI SYLLABLE HAT",
"YI SYLLABLE HAX",
"YI SYLLABLE HA",
"YI SYLLABLE HAP",
"YI SYLLABLE HUOT",
"YI SYLLABLE HUOX",
"YI SYLLABLE HUO",
"YI SYLLABLE HUOP",
"YI SYLLABLE HOT",
"YI SYLLABLE HOX",
"YI SYLLABLE HO",
"YI SYLLABLE HOP",
"YI SYLLABLE HEX",
"YI SYLLABLE HE",
"YI SYLLABLE HEP",
"YI SYLLABLE WAT",
"YI SYLLABLE WAX",
"YI SYLLABLE WA",
"YI SYLLABLE WAP",
"YI SYLLABLE WUOX",
"YI SYLLABLE WUO",
"YI SYLLABLE WUOP",
"YI SYLLABLE WOX",
"YI SYLLABLE WO",
"YI SYLLABLE WOP",
"YI SYLLABLE WEX",
"YI SYLLABLE WE",
"YI SYLLABLE WEP",
"YI SYLLABLE ZIT",
"YI SYLLABLE ZIX",
"YI SYLLABLE ZI",
"YI SYLLABLE ZIP",
"YI SYLLABLE ZIEX",
"YI SYLLABLE ZIE",
"YI SYLLABLE ZIEP",
"YI SYLLABLE ZAT",
"YI SYLLABLE ZAX",
"YI SYLLABLE ZA",
"YI SYLLABLE ZAP",
"YI SYLLABLE ZUOX",
"YI SYLLABLE ZUO",
"YI SYLLABLE ZUOP",
"YI SYLLABLE ZOT",
"YI SYLLABLE ZOX",
"YI SYLLABLE ZO",
"YI SYLLABLE ZOP",
"YI SYLLABLE ZEX",
"YI SYLLABLE ZE",
"YI SYLLABLE ZEP",
"YI SYLLABLE ZUT",
"YI SYLLABLE ZUX",
"YI SYLLABLE ZU",
"YI SYLLABLE ZUP",
"YI SYLLABLE ZURX",
"YI SYLLABLE ZUR",
"YI SYLLABLE ZYT",
"YI SYLLABLE ZYX",
"YI SYLLABLE ZY",
"YI SYLLABLE ZYP",
"YI SYLLABLE ZYRX",
"YI SYLLABLE ZYR",
"YI SYLLABLE CIT",
"YI SYLLABLE CIX",
"YI SYLLABLE CI",
"YI SYLLABLE CIP",
"YI SYLLABLE CIET",
"YI SYLLABLE CIEX",
"YI SYLLABLE CIE",
"YI SYLLABLE CIEP",
"YI SYLLABLE CAT",
"YI SYLLABLE CAX",
"YI SYLLABLE CA",
"YI SYLLABLE CAP",
"YI SYLLABLE CUOX",
"YI SYLLABLE CUO",
"YI SYLLABLE CUOP",
"YI SYLLABLE COT",
"YI SYLLABLE COX",
"YI SYLLABLE CO",
"YI SYLLABLE COP",
"YI SYLLABLE CEX",
"YI SYLLABLE CE",
"YI SYLLABLE CEP",
"YI SYLLABLE CUT",
"YI SYLLABLE CUX",
"YI SYLLABLE CU",
"YI SYLLABLE CUP",
"YI SYLLABLE CURX",
"YI SYLLABLE CUR",
"YI SYLLABLE CYT",
"YI SYLLABLE CYX",
"YI SYLLABLE CY",
"YI SYLLABLE CYP",
"YI SYLLABLE CYRX",
"YI SYLLABLE CYR",
"YI SYLLABLE ZZIT",
"YI SYLLABLE ZZIX",
"YI SYLLABLE ZZI",
"YI SYLLABLE ZZIP",
"YI SYLLABLE ZZIET",
"YI SYLLABLE ZZIEX",
"YI SYLLABLE ZZIE",
"YI SYLLABLE ZZIEP",
"YI SYLLABLE ZZAT",
"YI SYLLABLE ZZAX",
"YI SYLLABLE ZZA",
"YI SYLLABLE ZZAP",
"YI SYLLABLE ZZOX",
"YI SYLLABLE ZZO",
"YI SYLLABLE ZZOP",
"YI SYLLABLE ZZEX",
"YI SYLLABLE ZZE",
"YI SYLLABLE ZZEP",
"YI SYLLABLE ZZUX",
"YI SYLLABLE ZZU",
"YI SYLLABLE ZZUP",
"YI SYLLABLE ZZURX",
"YI SYLLABLE ZZUR",
"YI SYLLABLE ZZYT",
"YI SYLLABLE ZZYX",
"YI SYLLABLE ZZY",
"YI SYLLABLE ZZYP",
"YI SYLLABLE ZZYRX",
"YI SYLLABLE ZZYR",
"YI SYLLABLE NZIT",
"YI SYLLABLE NZIX",
"YI SYLLABLE NZI",
"YI SYLLABLE NZIP",
"YI SYLLABLE NZIEX",
"YI SYLLABLE NZIE",
"YI SYLLABLE NZIEP",
"YI SYLLABLE NZAT",
"YI SYLLABLE NZAX",
"YI SYLLABLE NZA",
"YI SYLLABLE NZAP",
"YI SYLLABLE NZUOX",
"YI SYLLABLE NZUO",
"YI SYLLABLE NZOX",
"YI SYLLABLE NZOP",
"YI SYLLABLE NZEX",
"YI SYLLABLE NZE",
"YI SYLLABLE NZUX",
"YI SYLLABLE NZU"};
static const char * name_00a3[256] =
{
"YI SYLLABLE NZUP",
"YI SYLLABLE NZURX",
"YI SYLLABLE NZUR",
"YI SYLLABLE NZYT",
"YI SYLLABLE NZYX",
"YI SYLLABLE NZY",
"YI SYLLABLE NZYP",
"YI SYLLABLE NZYRX",
"YI SYLLABLE NZYR",
"YI SYLLABLE SIT",
"YI SYLLABLE SIX",
"YI SYLLABLE SI",
"YI SYLLABLE SIP",
"YI SYLLABLE SIEX",
"YI SYLLABLE SIE",
"YI SYLLABLE SIEP",
"YI SYLLABLE SAT",
"YI SYLLABLE SAX",
"YI SYLLABLE SA",
"YI SYLLABLE SAP",
"YI SYLLABLE SUOX",
"YI SYLLABLE SUO",
"YI SYLLABLE SUOP",
"YI SYLLABLE SOT",
"YI SYLLABLE SOX",
"YI SYLLABLE SO",
"YI SYLLABLE SOP",
"YI SYLLABLE SEX",
"YI SYLLABLE SE",
"YI SYLLABLE SEP",
"YI SYLLABLE SUT",
"YI SYLLABLE SUX",
"YI SYLLABLE SU",
"YI SYLLABLE SUP",
"YI SYLLABLE SURX",
"YI SYLLABLE SUR",
"YI SYLLABLE SYT",
"YI SYLLABLE SYX",
"YI SYLLABLE SY",
"YI SYLLABLE SYP",
"YI SYLLABLE SYRX",
"YI SYLLABLE SYR",
"YI SYLLABLE SSIT",
"YI SYLLABLE SSIX",
"YI SYLLABLE SSI",
"YI SYLLABLE SSIP",
"YI SYLLABLE SSIEX",
"YI SYLLABLE SSIE",
"YI SYLLABLE SSIEP",
"YI SYLLABLE SSAT",
"YI SYLLABLE SSAX",
"YI SYLLABLE SSA",
"YI SYLLABLE SSAP",
"YI SYLLABLE SSOT",
"YI SYLLABLE SSOX",
"YI SYLLABLE SSO",
"YI SYLLABLE SSOP",
"YI SYLLABLE SSEX",
"YI SYLLABLE SSE",
"YI SYLLABLE SSEP",
"YI SYLLABLE SSUT",
"YI SYLLABLE SSUX",
"YI SYLLABLE SSU",
"YI SYLLABLE SSUP",
"YI SYLLABLE SSYT",
"YI SYLLABLE SSYX",
"YI SYLLABLE SSY",
"YI SYLLABLE SSYP",
"YI SYLLABLE SSYRX",
"YI SYLLABLE SSYR",
"YI SYLLABLE ZHAT",
"YI SYLLABLE ZHAX",
"YI SYLLABLE ZHA",
"YI SYLLABLE ZHAP",
"YI SYLLABLE ZHUOX",
"YI SYLLABLE ZHUO",
"YI SYLLABLE ZHUOP",
"YI SYLLABLE ZHOT",
"YI SYLLABLE ZHOX",
"YI SYLLABLE ZHO",
"YI SYLLABLE ZHOP",
"YI SYLLABLE ZHET",
"YI SYLLABLE ZHEX",
"YI SYLLABLE ZHE",
"YI SYLLABLE ZHEP",
"YI SYLLABLE ZHUT",
"YI SYLLABLE ZHUX",
"YI SYLLABLE ZHU",
"YI SYLLABLE ZHUP",
"YI SYLLABLE ZHURX",
"YI SYLLABLE ZHUR",
"YI SYLLABLE ZHYT",
"YI SYLLABLE ZHYX",
"YI SYLLABLE ZHY",
"YI SYLLABLE ZHYP",
"YI SYLLABLE ZHYRX",
"YI SYLLABLE ZHYR",
"YI SYLLABLE CHAT",
"YI SYLLABLE CHAX",
"YI SYLLABLE CHA",
"YI SYLLABLE CHAP",
"YI SYLLABLE CHUOT",
"YI SYLLABLE CHUOX",
"YI SYLLABLE CHUO",
"YI SYLLABLE CHUOP",
"YI SYLLABLE CHOT",
"YI SYLLABLE CHOX",
"YI SYLLABLE CHO",
"YI SYLLABLE CHOP",
"YI SYLLABLE CHET",
"YI SYLLABLE CHEX",
"YI SYLLABLE CHE",
"YI SYLLABLE CHEP",
"YI SYLLABLE CHUX",
"YI SYLLABLE CHU",
"YI SYLLABLE CHUP",
"YI SYLLABLE CHURX",
"YI SYLLABLE CHUR",
"YI SYLLABLE CHYT",
"YI SYLLABLE CHYX",
"YI SYLLABLE CHY",
"YI SYLLABLE CHYP",
"YI SYLLABLE CHYRX",
"YI SYLLABLE CHYR",
"YI SYLLABLE RRAX",
"YI SYLLABLE RRA",
"YI SYLLABLE RRUOX",
"YI SYLLABLE RRUO",
"YI SYLLABLE RROT",
"YI SYLLABLE RROX",
"YI SYLLABLE RRO",
"YI SYLLABLE RROP",
"YI SYLLABLE RRET",
"YI SYLLABLE RREX",
"YI SYLLABLE RRE",
"YI SYLLABLE RREP",
"YI SYLLABLE RRUT",
"YI SYLLABLE RRUX",
"YI SYLLABLE RRU",
"YI SYLLABLE RRUP",
"YI SYLLABLE RRURX",
"YI SYLLABLE RRUR",
"YI SYLLABLE RRYT",
"YI SYLLABLE RRYX",
"YI SYLLABLE RRY",
"YI SYLLABLE RRYP",
"YI SYLLABLE RRYRX",
"YI SYLLABLE RRYR",
"YI SYLLABLE NRAT",
"YI SYLLABLE NRAX",
"YI SYLLABLE NRA",
"YI SYLLABLE NRAP",
"YI SYLLABLE NROX",
"YI SYLLABLE NRO",
"YI SYLLABLE NROP",
"YI SYLLABLE NRET",
"YI SYLLABLE NREX",
"YI SYLLABLE NRE",
"YI SYLLABLE NREP",
"YI SYLLABLE NRUT",
"YI SYLLABLE NRUX",
"YI SYLLABLE NRU",
"YI SYLLABLE NRUP",
"YI SYLLABLE NRURX",
"YI SYLLABLE NRUR",
"YI SYLLABLE NRYT",
"YI SYLLABLE NRYX",
"YI SYLLABLE NRY",
"YI SYLLABLE NRYP",
"YI SYLLABLE NRYRX",
"YI SYLLABLE NRYR",
"YI SYLLABLE SHAT",
"YI SYLLABLE SHAX",
"YI SYLLABLE SHA",
"YI SYLLABLE SHAP",
"YI SYLLABLE SHUOX",
"YI SYLLABLE SHUO",
"YI SYLLABLE SHUOP",
"YI SYLLABLE SHOT",
"YI SYLLABLE SHOX",
"YI SYLLABLE SHO",
"YI SYLLABLE SHOP",
"YI SYLLABLE SHET",
"YI SYLLABLE SHEX",
"YI SYLLABLE SHE",
"YI SYLLABLE SHEP",
"YI SYLLABLE SHUT",
"YI SYLLABLE SHUX",
"YI SYLLABLE SHU",
"YI SYLLABLE SHUP",
"YI SYLLABLE SHURX",
"YI SYLLABLE SHUR",
"YI SYLLABLE SHYT",
"YI SYLLABLE SHYX",
"YI SYLLABLE SHY",
"YI SYLLABLE SHYP",
"YI SYLLABLE SHYRX",
"YI SYLLABLE SHYR",
"YI SYLLABLE RAT",
"YI SYLLABLE RAX",
"YI SYLLABLE RA",
"YI SYLLABLE RAP",
"YI SYLLABLE RUOX",
"YI SYLLABLE RUO",
"YI SYLLABLE RUOP",
"YI SYLLABLE ROT",
"YI SYLLABLE ROX",
"YI SYLLABLE RO",
"YI SYLLABLE ROP",
"YI SYLLABLE REX",
"YI SYLLABLE RE",
"YI SYLLABLE REP",
"YI SYLLABLE RUT",
"YI SYLLABLE RUX",
"YI SYLLABLE RU",
"YI SYLLABLE RUP",
"YI SYLLABLE RURX",
"YI SYLLABLE RUR",
"YI SYLLABLE RYT",
"YI SYLLABLE RYX",
"YI SYLLABLE RY",
"YI SYLLABLE RYP",
"YI SYLLABLE RYRX",
"YI SYLLABLE RYR",
"YI SYLLABLE JIT",
"YI SYLLABLE JIX",
"YI SYLLABLE JI",
"YI SYLLABLE JIP",
"YI SYLLABLE JIET",
"YI SYLLABLE JIEX",
"YI SYLLABLE JIE",
"YI SYLLABLE JIEP",
"YI SYLLABLE JUOT",
"YI SYLLABLE JUOX",
"YI SYLLABLE JUO",
"YI SYLLABLE JUOP",
"YI SYLLABLE JOT",
"YI SYLLABLE JOX",
"YI SYLLABLE JO",
"YI SYLLABLE JOP",
"YI SYLLABLE JUT",
"YI SYLLABLE JUX",
"YI SYLLABLE JU",
"YI SYLLABLE JUP",
"YI SYLLABLE JURX",
"YI SYLLABLE JUR",
"YI SYLLABLE JYT",
"YI SYLLABLE JYX",
"YI SYLLABLE JY",
"YI SYLLABLE JYP",
"YI SYLLABLE JYRX",
"YI SYLLABLE JYR",
"YI SYLLABLE QIT",
"YI SYLLABLE QIX",
"YI SYLLABLE QI",
"YI SYLLABLE QIP"};
static const char * name_00a4[256] =
{
"YI SYLLABLE QIET",
"YI SYLLABLE QIEX",
"YI SYLLABLE QIE",
"YI SYLLABLE QIEP",
"YI SYLLABLE QUOT",
"YI SYLLABLE QUOX",
"YI SYLLABLE QUO",
"YI SYLLABLE QUOP",
"YI SYLLABLE QOT",
"YI SYLLABLE QOX",
"YI SYLLABLE QO",
"YI SYLLABLE QOP",
"YI SYLLABLE QUT",
"YI SYLLABLE QUX",
"YI SYLLABLE QU",
"YI SYLLABLE QUP",
"YI SYLLABLE QURX",
"YI SYLLABLE QUR",
"YI SYLLABLE QYT",
"YI SYLLABLE QYX",
"YI SYLLABLE QY",
"YI SYLLABLE QYP",
"YI SYLLABLE QYRX",
"YI SYLLABLE QYR",
"YI SYLLABLE JJIT",
"YI SYLLABLE JJIX",
"YI SYLLABLE JJI",
"YI SYLLABLE JJIP",
"YI SYLLABLE JJIET",
"YI SYLLABLE JJIEX",
"YI SYLLABLE JJIE",
"YI SYLLABLE JJIEP",
"YI SYLLABLE JJUOX",
"YI SYLLABLE JJUO",
"YI SYLLABLE JJUOP",
"YI SYLLABLE JJOT",
"YI SYLLABLE JJOX",
"YI SYLLABLE JJO",
"YI SYLLABLE JJOP",
"YI SYLLABLE JJUT",
"YI SYLLABLE JJUX",
"YI SYLLABLE JJU",
"YI SYLLABLE JJUP",
"YI SYLLABLE JJURX",
"YI SYLLABLE JJUR",
"YI SYLLABLE JJYT",
"YI SYLLABLE JJYX",
"YI SYLLABLE JJY",
"YI SYLLABLE JJYP",
"YI SYLLABLE NJIT",
"YI SYLLABLE NJIX",
"YI SYLLABLE NJI",
"YI SYLLABLE NJIP",
"YI SYLLABLE NJIET",
"YI SYLLABLE NJIEX",
"YI SYLLABLE NJIE",
"YI SYLLABLE NJIEP",
"YI SYLLABLE NJUOX",
"YI SYLLABLE NJUO",
"YI SYLLABLE NJOT",
"YI SYLLABLE NJOX",
"YI SYLLABLE NJO",
"YI SYLLABLE NJOP",
"YI SYLLABLE NJUX",
"YI SYLLABLE NJU",
"YI SYLLABLE NJUP",
"YI SYLLABLE NJURX",
"YI SYLLABLE NJUR",
"YI SYLLABLE NJYT",
"YI SYLLABLE NJYX",
"YI SYLLABLE NJY",
"YI SYLLABLE NJYP",
"YI SYLLABLE NJYRX",
"YI SYLLABLE NJYR",
"YI SYLLABLE NYIT",
"YI SYLLABLE NYIX",
"YI SYLLABLE NYI",
"YI SYLLABLE NYIP",
"YI SYLLABLE NYIET",
"YI SYLLABLE NYIEX",
"YI SYLLABLE NYIE",
"YI SYLLABLE NYIEP",
"YI SYLLABLE NYUOX",
"YI SYLLABLE NYUO",
"YI SYLLABLE NYUOP",
"YI SYLLABLE NYOT",
"YI SYLLABLE NYOX",
"YI SYLLABLE NYO",
"YI SYLLABLE NYOP",
"YI SYLLABLE NYUT",
"YI SYLLABLE NYUX",
"YI SYLLABLE NYU",
"YI SYLLABLE NYUP",
"YI SYLLABLE XIT",
"YI SYLLABLE XIX",
"YI SYLLABLE XI",
"YI SYLLABLE XIP",
"YI SYLLABLE XIET",
"YI SYLLABLE XIEX",
"YI SYLLABLE XIE",
"YI SYLLABLE XIEP",
"YI SYLLABLE XUOX",
"YI SYLLABLE XUO",
"YI SYLLABLE XOT",
"YI SYLLABLE XOX",
"YI SYLLABLE XO",
"YI SYLLABLE XOP",
"YI SYLLABLE XYT",
"YI SYLLABLE XYX",
"YI SYLLABLE XY",
"YI SYLLABLE XYP",
"YI SYLLABLE XYRX",
"YI SYLLABLE XYR",
"YI SYLLABLE YIT",
"YI SYLLABLE YIX",
"YI SYLLABLE YI",
"YI SYLLABLE YIP",
"YI SYLLABLE YIET",
"YI SYLLABLE YIEX",
"YI SYLLABLE YIE",
"YI SYLLABLE YIEP",
"YI SYLLABLE YUOT",
"YI SYLLABLE YUOX",
"YI SYLLABLE YUO",
"YI SYLLABLE YUOP",
"YI SYLLABLE YOT",
"YI SYLLABLE YOX",
"YI SYLLABLE YO",
"YI SYLLABLE YOP",
"YI SYLLABLE YUT",
"YI SYLLABLE YUX",
"YI SYLLABLE YU",
"YI SYLLABLE YUP",
"YI SYLLABLE YURX",
"YI SYLLABLE YUR",
"YI SYLLABLE YYT",
"YI SYLLABLE YYX",
"YI SYLLABLE YY",
"YI SYLLABLE YYP",
"YI SYLLABLE YYRX",
"YI SYLLABLE YYR",
name_reserved,
name_reserved,
name_reserved,
"YI RADICAL QOT",
"YI RADICAL LI",
"YI RADICAL KIT",
"YI RADICAL NYIP",
"YI RADICAL CYP",
"YI RADICAL SSI",
"YI RADICAL GGOP",
"YI RADICAL GEP",
"YI RADICAL MI",
"YI RADICAL HXIT",
"YI RADICAL LYR",
"YI RADICAL BBUT",
"YI RADICAL MOP",
"YI RADICAL YO",
"YI RADICAL PUT",
"YI RADICAL HXUO",
"YI RADICAL TAT",
"YI RADICAL GA",
"YI RADICAL ZUP",
"YI RADICAL CYT",
"YI RADICAL DDUR",
"YI RADICAL BUR",
"YI RADICAL GGUO",
"YI RADICAL NYOP",
"YI RADICAL TU",
"YI RADICAL OP",
"YI RADICAL JJUT",
"YI RADICAL ZOT",
"YI RADICAL PYT",
"YI RADICAL HMO",
"YI RADICAL YIT",
"YI RADICAL VUR",
"YI RADICAL SHY",
"YI RADICAL VEP",
"YI RADICAL ZA",
"YI RADICAL JO",
"YI RADICAL NZUP",
"YI RADICAL JJY",
"YI RADICAL GOT",
"YI RADICAL JJIE",
"YI RADICAL WO",
"YI RADICAL DU",
"YI RADICAL SHUR",
"YI RADICAL LIE",
"YI RADICAL CY",
"YI RADICAL CUOP",
"YI RADICAL CIP",
"YI RADICAL HXOP",
"YI RADICAL SHAT",
"YI RADICAL ZUR",
"YI RADICAL SHOP",
"YI RADICAL CHE",
"YI RADICAL ZZIET",
"YI RADICAL NBIE",
"YI RADICAL KE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00a7[256] =
{
"MODIFIER LETTER CHINESE TONE YIN PING",
"MODIFIER LETTER CHINESE TONE YANG PING",
"MODIFIER LETTER CHINESE TONE YIN SHANG",
"MODIFIER LETTER CHINESE TONE YANG SHANG",
"MODIFIER LETTER CHINESE TONE YIN QU",
"MODIFIER LETTER CHINESE TONE YANG QU",
"MODIFIER LETTER CHINESE TONE YIN RU",
"MODIFIER LETTER CHINESE TONE YANG RU",
"MODIFIER LETTER EXTRA-HIGH DOTTED TONE BAR",
"MODIFIER LETTER HIGH DOTTED TONE BAR",
"MODIFIER LETTER MID DOTTED TONE BAR",
"MODIFIER LETTER LOW DOTTED TONE BAR",
"MODIFIER LETTER EXTRA-LOW DOTTED TONE BAR",
"MODIFIER LETTER EXTRA-HIGH DOTTED LEFT-STEM TONE BAR",
"MODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BAR",
"MODIFIER LETTER MID DOTTED LEFT-STEM TONE BAR",
"MODIFIER LETTER LOW DOTTED LEFT-STEM TONE BAR",
"MODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BAR",
"MODIFIER LETTER EXTRA-HIGH LEFT-STEM TONE BAR",
"MODIFIER LETTER HIGH LEFT-STEM TONE BAR",
"MODIFIER LETTER MID LEFT-STEM TONE BAR",
"MODIFIER LETTER LOW LEFT-STEM TONE BAR",
"MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00a8[256] =
{
"SYLOTI NAGRI LETTER A",
"SYLOTI NAGRI LETTER I",
"SYLOTI NAGRI SIGN DVISVARA",
"SYLOTI NAGRI LETTER U",
"SYLOTI NAGRI LETTER E",
"SYLOTI NAGRI LETTER O",
"SYLOTI NAGRI SIGN HASANTA",
"SYLOTI NAGRI LETTER KO",
"SYLOTI NAGRI LETTER KHO",
"SYLOTI NAGRI LETTER GO",
"SYLOTI NAGRI LETTER GHO",
"SYLOTI NAGRI SIGN ANUSVARA",
"SYLOTI NAGRI LETTER CO",
"SYLOTI NAGRI LETTER CHO",
"SYLOTI NAGRI LETTER JO",
"SYLOTI NAGRI LETTER JHO",
"SYLOTI NAGRI LETTER TTO",
"SYLOTI NAGRI LETTER TTHO",
"SYLOTI NAGRI LETTER DDO",
"SYLOTI NAGRI LETTER DDHO",
"SYLOTI NAGRI LETTER TO",
"SYLOTI NAGRI LETTER THO",
"SYLOTI NAGRI LETTER DO",
"SYLOTI NAGRI LETTER DHO",
"SYLOTI NAGRI LETTER NO",
"SYLOTI NAGRI LETTER PO",
"SYLOTI NAGRI LETTER PHO",
"SYLOTI NAGRI LETTER BO",
"SYLOTI NAGRI LETTER BHO",
"SYLOTI NAGRI LETTER MO",
"SYLOTI NAGRI LETTER RO",
"SYLOTI NAGRI LETTER LO",
"SYLOTI NAGRI LETTER RRO",
"SYLOTI NAGRI LETTER SO",
"SYLOTI NAGRI LETTER HO",
"SYLOTI NAGRI VOWEL SIGN A",
"SYLOTI NAGRI VOWEL SIGN I",
"SYLOTI NAGRI VOWEL SIGN U",
"SYLOTI NAGRI VOWEL SIGN E",
"SYLOTI NAGRI VOWEL SIGN OO",
"SYLOTI NAGRI POETRY MARK-1",
"SYLOTI NAGRI POETRY MARK-2",
"SYLOTI NAGRI POETRY MARK-3",
"SYLOTI NAGRI POETRY MARK-4",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00ac[256] =
{
"<Hangul Syllable, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00d7[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<Hangul Syllable, Last>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00d8[256] =
{
"<Non Private Use High Surrogate, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00db[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<Non Private Use High Surrogate, Last>",
"<Private Use High Surrogate, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<Private Use High Surrogate, Last>"};
static const char * name_00dc[256] =
{
"<Low Surrogate, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00df[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<Low Surrogate, Last>"};
static const char * name_00e0[256] =
{
"<Private Use, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00f8[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<Private Use, Last>"};
static const char * name_00f9[256] =
{
"CJK COMPATIBILITY IDEOGRAPH-F900",
"CJK COMPATIBILITY IDEOGRAPH-F901",
"CJK COMPATIBILITY IDEOGRAPH-F902",
"CJK COMPATIBILITY IDEOGRAPH-F903",
"CJK COMPATIBILITY IDEOGRAPH-F904",
"CJK COMPATIBILITY IDEOGRAPH-F905",
"CJK COMPATIBILITY IDEOGRAPH-F906",
"CJK COMPATIBILITY IDEOGRAPH-F907",
"CJK COMPATIBILITY IDEOGRAPH-F908",
"CJK COMPATIBILITY IDEOGRAPH-F909",
"CJK COMPATIBILITY IDEOGRAPH-F90A",
"CJK COMPATIBILITY IDEOGRAPH-F90B",
"CJK COMPATIBILITY IDEOGRAPH-F90C",
"CJK COMPATIBILITY IDEOGRAPH-F90D",
"CJK COMPATIBILITY IDEOGRAPH-F90E",
"CJK COMPATIBILITY IDEOGRAPH-F90F",
"CJK COMPATIBILITY IDEOGRAPH-F910",
"CJK COMPATIBILITY IDEOGRAPH-F911",
"CJK COMPATIBILITY IDEOGRAPH-F912",
"CJK COMPATIBILITY IDEOGRAPH-F913",
"CJK COMPATIBILITY IDEOGRAPH-F914",
"CJK COMPATIBILITY IDEOGRAPH-F915",
"CJK COMPATIBILITY IDEOGRAPH-F916",
"CJK COMPATIBILITY IDEOGRAPH-F917",
"CJK COMPATIBILITY IDEOGRAPH-F918",
"CJK COMPATIBILITY IDEOGRAPH-F919",
"CJK COMPATIBILITY IDEOGRAPH-F91A",
"CJK COMPATIBILITY IDEOGRAPH-F91B",
"CJK COMPATIBILITY IDEOGRAPH-F91C",
"CJK COMPATIBILITY IDEOGRAPH-F91D",
"CJK COMPATIBILITY IDEOGRAPH-F91E",
"CJK COMPATIBILITY IDEOGRAPH-F91F",
"CJK COMPATIBILITY IDEOGRAPH-F920",
"CJK COMPATIBILITY IDEOGRAPH-F921",
"CJK COMPATIBILITY IDEOGRAPH-F922",
"CJK COMPATIBILITY IDEOGRAPH-F923",
"CJK COMPATIBILITY IDEOGRAPH-F924",
"CJK COMPATIBILITY IDEOGRAPH-F925",
"CJK COMPATIBILITY IDEOGRAPH-F926",
"CJK COMPATIBILITY IDEOGRAPH-F927",
"CJK COMPATIBILITY IDEOGRAPH-F928",
"CJK COMPATIBILITY IDEOGRAPH-F929",
"CJK COMPATIBILITY IDEOGRAPH-F92A",
"CJK COMPATIBILITY IDEOGRAPH-F92B",
"CJK COMPATIBILITY IDEOGRAPH-F92C",
"CJK COMPATIBILITY IDEOGRAPH-F92D",
"CJK COMPATIBILITY IDEOGRAPH-F92E",
"CJK COMPATIBILITY IDEOGRAPH-F92F",
"CJK COMPATIBILITY IDEOGRAPH-F930",
"CJK COMPATIBILITY IDEOGRAPH-F931",
"CJK COMPATIBILITY IDEOGRAPH-F932",
"CJK COMPATIBILITY IDEOGRAPH-F933",
"CJK COMPATIBILITY IDEOGRAPH-F934",
"CJK COMPATIBILITY IDEOGRAPH-F935",
"CJK COMPATIBILITY IDEOGRAPH-F936",
"CJK COMPATIBILITY IDEOGRAPH-F937",
"CJK COMPATIBILITY IDEOGRAPH-F938",
"CJK COMPATIBILITY IDEOGRAPH-F939",
"CJK COMPATIBILITY IDEOGRAPH-F93A",
"CJK COMPATIBILITY IDEOGRAPH-F93B",
"CJK COMPATIBILITY IDEOGRAPH-F93C",
"CJK COMPATIBILITY IDEOGRAPH-F93D",
"CJK COMPATIBILITY IDEOGRAPH-F93E",
"CJK COMPATIBILITY IDEOGRAPH-F93F",
"CJK COMPATIBILITY IDEOGRAPH-F940",
"CJK COMPATIBILITY IDEOGRAPH-F941",
"CJK COMPATIBILITY IDEOGRAPH-F942",
"CJK COMPATIBILITY IDEOGRAPH-F943",
"CJK COMPATIBILITY IDEOGRAPH-F944",
"CJK COMPATIBILITY IDEOGRAPH-F945",
"CJK COMPATIBILITY IDEOGRAPH-F946",
"CJK COMPATIBILITY IDEOGRAPH-F947",
"CJK COMPATIBILITY IDEOGRAPH-F948",
"CJK COMPATIBILITY IDEOGRAPH-F949",
"CJK COMPATIBILITY IDEOGRAPH-F94A",
"CJK COMPATIBILITY IDEOGRAPH-F94B",
"CJK COMPATIBILITY IDEOGRAPH-F94C",
"CJK COMPATIBILITY IDEOGRAPH-F94D",
"CJK COMPATIBILITY IDEOGRAPH-F94E",
"CJK COMPATIBILITY IDEOGRAPH-F94F",
"CJK COMPATIBILITY IDEOGRAPH-F950",
"CJK COMPATIBILITY IDEOGRAPH-F951",
"CJK COMPATIBILITY IDEOGRAPH-F952",
"CJK COMPATIBILITY IDEOGRAPH-F953",
"CJK COMPATIBILITY IDEOGRAPH-F954",
"CJK COMPATIBILITY IDEOGRAPH-F955",
"CJK COMPATIBILITY IDEOGRAPH-F956",
"CJK COMPATIBILITY IDEOGRAPH-F957",
"CJK COMPATIBILITY IDEOGRAPH-F958",
"CJK COMPATIBILITY IDEOGRAPH-F959",
"CJK COMPATIBILITY IDEOGRAPH-F95A",
"CJK COMPATIBILITY IDEOGRAPH-F95B",
"CJK COMPATIBILITY IDEOGRAPH-F95C",
"CJK COMPATIBILITY IDEOGRAPH-F95D",
"CJK COMPATIBILITY IDEOGRAPH-F95E",
"CJK COMPATIBILITY IDEOGRAPH-F95F",
"CJK COMPATIBILITY IDEOGRAPH-F960",
"CJK COMPATIBILITY IDEOGRAPH-F961",
"CJK COMPATIBILITY IDEOGRAPH-F962",
"CJK COMPATIBILITY IDEOGRAPH-F963",
"CJK COMPATIBILITY IDEOGRAPH-F964",
"CJK COMPATIBILITY IDEOGRAPH-F965",
"CJK COMPATIBILITY IDEOGRAPH-F966",
"CJK COMPATIBILITY IDEOGRAPH-F967",
"CJK COMPATIBILITY IDEOGRAPH-F968",
"CJK COMPATIBILITY IDEOGRAPH-F969",
"CJK COMPATIBILITY IDEOGRAPH-F96A",
"CJK COMPATIBILITY IDEOGRAPH-F96B",
"CJK COMPATIBILITY IDEOGRAPH-F96C",
"CJK COMPATIBILITY IDEOGRAPH-F96D",
"CJK COMPATIBILITY IDEOGRAPH-F96E",
"CJK COMPATIBILITY IDEOGRAPH-F96F",
"CJK COMPATIBILITY IDEOGRAPH-F970",
"CJK COMPATIBILITY IDEOGRAPH-F971",
"CJK COMPATIBILITY IDEOGRAPH-F972",
"CJK COMPATIBILITY IDEOGRAPH-F973",
"CJK COMPATIBILITY IDEOGRAPH-F974",
"CJK COMPATIBILITY IDEOGRAPH-F975",
"CJK COMPATIBILITY IDEOGRAPH-F976",
"CJK COMPATIBILITY IDEOGRAPH-F977",
"CJK COMPATIBILITY IDEOGRAPH-F978",
"CJK COMPATIBILITY IDEOGRAPH-F979",
"CJK COMPATIBILITY IDEOGRAPH-F97A",
"CJK COMPATIBILITY IDEOGRAPH-F97B",
"CJK COMPATIBILITY IDEOGRAPH-F97C",
"CJK COMPATIBILITY IDEOGRAPH-F97D",
"CJK COMPATIBILITY IDEOGRAPH-F97E",
"CJK COMPATIBILITY IDEOGRAPH-F97F",
"CJK COMPATIBILITY IDEOGRAPH-F980",
"CJK COMPATIBILITY IDEOGRAPH-F981",
"CJK COMPATIBILITY IDEOGRAPH-F982",
"CJK COMPATIBILITY IDEOGRAPH-F983",
"CJK COMPATIBILITY IDEOGRAPH-F984",
"CJK COMPATIBILITY IDEOGRAPH-F985",
"CJK COMPATIBILITY IDEOGRAPH-F986",
"CJK COMPATIBILITY IDEOGRAPH-F987",
"CJK COMPATIBILITY IDEOGRAPH-F988",
"CJK COMPATIBILITY IDEOGRAPH-F989",
"CJK COMPATIBILITY IDEOGRAPH-F98A",
"CJK COMPATIBILITY IDEOGRAPH-F98B",
"CJK COMPATIBILITY IDEOGRAPH-F98C",
"CJK COMPATIBILITY IDEOGRAPH-F98D",
"CJK COMPATIBILITY IDEOGRAPH-F98E",
"CJK COMPATIBILITY IDEOGRAPH-F98F",
"CJK COMPATIBILITY IDEOGRAPH-F990",
"CJK COMPATIBILITY IDEOGRAPH-F991",
"CJK COMPATIBILITY IDEOGRAPH-F992",
"CJK COMPATIBILITY IDEOGRAPH-F993",
"CJK COMPATIBILITY IDEOGRAPH-F994",
"CJK COMPATIBILITY IDEOGRAPH-F995",
"CJK COMPATIBILITY IDEOGRAPH-F996",
"CJK COMPATIBILITY IDEOGRAPH-F997",
"CJK COMPATIBILITY IDEOGRAPH-F998",
"CJK COMPATIBILITY IDEOGRAPH-F999",
"CJK COMPATIBILITY IDEOGRAPH-F99A",
"CJK COMPATIBILITY IDEOGRAPH-F99B",
"CJK COMPATIBILITY IDEOGRAPH-F99C",
"CJK COMPATIBILITY IDEOGRAPH-F99D",
"CJK COMPATIBILITY IDEOGRAPH-F99E",
"CJK COMPATIBILITY IDEOGRAPH-F99F",
"CJK COMPATIBILITY IDEOGRAPH-F9A0",
"CJK COMPATIBILITY IDEOGRAPH-F9A1",
"CJK COMPATIBILITY IDEOGRAPH-F9A2",
"CJK COMPATIBILITY IDEOGRAPH-F9A3",
"CJK COMPATIBILITY IDEOGRAPH-F9A4",
"CJK COMPATIBILITY IDEOGRAPH-F9A5",
"CJK COMPATIBILITY IDEOGRAPH-F9A6",
"CJK COMPATIBILITY IDEOGRAPH-F9A7",
"CJK COMPATIBILITY IDEOGRAPH-F9A8",
"CJK COMPATIBILITY IDEOGRAPH-F9A9",
"CJK COMPATIBILITY IDEOGRAPH-F9AA",
"CJK COMPATIBILITY IDEOGRAPH-F9AB",
"CJK COMPATIBILITY IDEOGRAPH-F9AC",
"CJK COMPATIBILITY IDEOGRAPH-F9AD",
"CJK COMPATIBILITY IDEOGRAPH-F9AE",
"CJK COMPATIBILITY IDEOGRAPH-F9AF",
"CJK COMPATIBILITY IDEOGRAPH-F9B0",
"CJK COMPATIBILITY IDEOGRAPH-F9B1",
"CJK COMPATIBILITY IDEOGRAPH-F9B2",
"CJK COMPATIBILITY IDEOGRAPH-F9B3",
"CJK COMPATIBILITY IDEOGRAPH-F9B4",
"CJK COMPATIBILITY IDEOGRAPH-F9B5",
"CJK COMPATIBILITY IDEOGRAPH-F9B6",
"CJK COMPATIBILITY IDEOGRAPH-F9B7",
"CJK COMPATIBILITY IDEOGRAPH-F9B8",
"CJK COMPATIBILITY IDEOGRAPH-F9B9",
"CJK COMPATIBILITY IDEOGRAPH-F9BA",
"CJK COMPATIBILITY IDEOGRAPH-F9BB",
"CJK COMPATIBILITY IDEOGRAPH-F9BC",
"CJK COMPATIBILITY IDEOGRAPH-F9BD",
"CJK COMPATIBILITY IDEOGRAPH-F9BE",
"CJK COMPATIBILITY IDEOGRAPH-F9BF",
"CJK COMPATIBILITY IDEOGRAPH-F9C0",
"CJK COMPATIBILITY IDEOGRAPH-F9C1",
"CJK COMPATIBILITY IDEOGRAPH-F9C2",
"CJK COMPATIBILITY IDEOGRAPH-F9C3",
"CJK COMPATIBILITY IDEOGRAPH-F9C4",
"CJK COMPATIBILITY IDEOGRAPH-F9C5",
"CJK COMPATIBILITY IDEOGRAPH-F9C6",
"CJK COMPATIBILITY IDEOGRAPH-F9C7",
"CJK COMPATIBILITY IDEOGRAPH-F9C8",
"CJK COMPATIBILITY IDEOGRAPH-F9C9",
"CJK COMPATIBILITY IDEOGRAPH-F9CA",
"CJK COMPATIBILITY IDEOGRAPH-F9CB",
"CJK COMPATIBILITY IDEOGRAPH-F9CC",
"CJK COMPATIBILITY IDEOGRAPH-F9CD",
"CJK COMPATIBILITY IDEOGRAPH-F9CE",
"CJK COMPATIBILITY IDEOGRAPH-F9CF",
"CJK COMPATIBILITY IDEOGRAPH-F9D0",
"CJK COMPATIBILITY IDEOGRAPH-F9D1",
"CJK COMPATIBILITY IDEOGRAPH-F9D2",
"CJK COMPATIBILITY IDEOGRAPH-F9D3",
"CJK COMPATIBILITY IDEOGRAPH-F9D4",
"CJK COMPATIBILITY IDEOGRAPH-F9D5",
"CJK COMPATIBILITY IDEOGRAPH-F9D6",
"CJK COMPATIBILITY IDEOGRAPH-F9D7",
"CJK COMPATIBILITY IDEOGRAPH-F9D8",
"CJK COMPATIBILITY IDEOGRAPH-F9D9",
"CJK COMPATIBILITY IDEOGRAPH-F9DA",
"CJK COMPATIBILITY IDEOGRAPH-F9DB",
"CJK COMPATIBILITY IDEOGRAPH-F9DC",
"CJK COMPATIBILITY IDEOGRAPH-F9DD",
"CJK COMPATIBILITY IDEOGRAPH-F9DE",
"CJK COMPATIBILITY IDEOGRAPH-F9DF",
"CJK COMPATIBILITY IDEOGRAPH-F9E0",
"CJK COMPATIBILITY IDEOGRAPH-F9E1",
"CJK COMPATIBILITY IDEOGRAPH-F9E2",
"CJK COMPATIBILITY IDEOGRAPH-F9E3",
"CJK COMPATIBILITY IDEOGRAPH-F9E4",
"CJK COMPATIBILITY IDEOGRAPH-F9E5",
"CJK COMPATIBILITY IDEOGRAPH-F9E6",
"CJK COMPATIBILITY IDEOGRAPH-F9E7",
"CJK COMPATIBILITY IDEOGRAPH-F9E8",
"CJK COMPATIBILITY IDEOGRAPH-F9E9",
"CJK COMPATIBILITY IDEOGRAPH-F9EA",
"CJK COMPATIBILITY IDEOGRAPH-F9EB",
"CJK COMPATIBILITY IDEOGRAPH-F9EC",
"CJK COMPATIBILITY IDEOGRAPH-F9ED",
"CJK COMPATIBILITY IDEOGRAPH-F9EE",
"CJK COMPATIBILITY IDEOGRAPH-F9EF",
"CJK COMPATIBILITY IDEOGRAPH-F9F0",
"CJK COMPATIBILITY IDEOGRAPH-F9F1",
"CJK COMPATIBILITY IDEOGRAPH-F9F2",
"CJK COMPATIBILITY IDEOGRAPH-F9F3",
"CJK COMPATIBILITY IDEOGRAPH-F9F4",
"CJK COMPATIBILITY IDEOGRAPH-F9F5",
"CJK COMPATIBILITY IDEOGRAPH-F9F6",
"CJK COMPATIBILITY IDEOGRAPH-F9F7",
"CJK COMPATIBILITY IDEOGRAPH-F9F8",
"CJK COMPATIBILITY IDEOGRAPH-F9F9",
"CJK COMPATIBILITY IDEOGRAPH-F9FA",
"CJK COMPATIBILITY IDEOGRAPH-F9FB",
"CJK COMPATIBILITY IDEOGRAPH-F9FC",
"CJK COMPATIBILITY IDEOGRAPH-F9FD",
"CJK COMPATIBILITY IDEOGRAPH-F9FE",
"CJK COMPATIBILITY IDEOGRAPH-F9FF"};
static const char * name_00fa[256] =
{
"CJK COMPATIBILITY IDEOGRAPH-FA00",
"CJK COMPATIBILITY IDEOGRAPH-FA01",
"CJK COMPATIBILITY IDEOGRAPH-FA02",
"CJK COMPATIBILITY IDEOGRAPH-FA03",
"CJK COMPATIBILITY IDEOGRAPH-FA04",
"CJK COMPATIBILITY IDEOGRAPH-FA05",
"CJK COMPATIBILITY IDEOGRAPH-FA06",
"CJK COMPATIBILITY IDEOGRAPH-FA07",
"CJK COMPATIBILITY IDEOGRAPH-FA08",
"CJK COMPATIBILITY IDEOGRAPH-FA09",
"CJK COMPATIBILITY IDEOGRAPH-FA0A",
"CJK COMPATIBILITY IDEOGRAPH-FA0B",
"CJK COMPATIBILITY IDEOGRAPH-FA0C",
"CJK COMPATIBILITY IDEOGRAPH-FA0D",
"CJK COMPATIBILITY IDEOGRAPH-FA0E",
"CJK COMPATIBILITY IDEOGRAPH-FA0F",
"CJK COMPATIBILITY IDEOGRAPH-FA10",
"CJK COMPATIBILITY IDEOGRAPH-FA11",
"CJK COMPATIBILITY IDEOGRAPH-FA12",
"CJK COMPATIBILITY IDEOGRAPH-FA13",
"CJK COMPATIBILITY IDEOGRAPH-FA14",
"CJK COMPATIBILITY IDEOGRAPH-FA15",
"CJK COMPATIBILITY IDEOGRAPH-FA16",
"CJK COMPATIBILITY IDEOGRAPH-FA17",
"CJK COMPATIBILITY IDEOGRAPH-FA18",
"CJK COMPATIBILITY IDEOGRAPH-FA19",
"CJK COMPATIBILITY IDEOGRAPH-FA1A",
"CJK COMPATIBILITY IDEOGRAPH-FA1B",
"CJK COMPATIBILITY IDEOGRAPH-FA1C",
"CJK COMPATIBILITY IDEOGRAPH-FA1D",
"CJK COMPATIBILITY IDEOGRAPH-FA1E",
"CJK COMPATIBILITY IDEOGRAPH-FA1F",
"CJK COMPATIBILITY IDEOGRAPH-FA20",
"CJK COMPATIBILITY IDEOGRAPH-FA21",
"CJK COMPATIBILITY IDEOGRAPH-FA22",
"CJK COMPATIBILITY IDEOGRAPH-FA23",
"CJK COMPATIBILITY IDEOGRAPH-FA24",
"CJK COMPATIBILITY IDEOGRAPH-FA25",
"CJK COMPATIBILITY IDEOGRAPH-FA26",
"CJK COMPATIBILITY IDEOGRAPH-FA27",
"CJK COMPATIBILITY IDEOGRAPH-FA28",
"CJK COMPATIBILITY IDEOGRAPH-FA29",
"CJK COMPATIBILITY IDEOGRAPH-FA2A",
"CJK COMPATIBILITY IDEOGRAPH-FA2B",
"CJK COMPATIBILITY IDEOGRAPH-FA2C",
"CJK COMPATIBILITY IDEOGRAPH-FA2D",
name_reserved,
name_reserved,
"CJK COMPATIBILITY IDEOGRAPH-FA30",
"CJK COMPATIBILITY IDEOGRAPH-FA31",
"CJK COMPATIBILITY IDEOGRAPH-FA32",
"CJK COMPATIBILITY IDEOGRAPH-FA33",
"CJK COMPATIBILITY IDEOGRAPH-FA34",
"CJK COMPATIBILITY IDEOGRAPH-FA35",
"CJK COMPATIBILITY IDEOGRAPH-FA36",
"CJK COMPATIBILITY IDEOGRAPH-FA37",
"CJK COMPATIBILITY IDEOGRAPH-FA38",
"CJK COMPATIBILITY IDEOGRAPH-FA39",
"CJK COMPATIBILITY IDEOGRAPH-FA3A",
"CJK COMPATIBILITY IDEOGRAPH-FA3B",
"CJK COMPATIBILITY IDEOGRAPH-FA3C",
"CJK COMPATIBILITY IDEOGRAPH-FA3D",
"CJK COMPATIBILITY IDEOGRAPH-FA3E",
"CJK COMPATIBILITY IDEOGRAPH-FA3F",
"CJK COMPATIBILITY IDEOGRAPH-FA40",
"CJK COMPATIBILITY IDEOGRAPH-FA41",
"CJK COMPATIBILITY IDEOGRAPH-FA42",
"CJK COMPATIBILITY IDEOGRAPH-FA43",
"CJK COMPATIBILITY IDEOGRAPH-FA44",
"CJK COMPATIBILITY IDEOGRAPH-FA45",
"CJK COMPATIBILITY IDEOGRAPH-FA46",
"CJK COMPATIBILITY IDEOGRAPH-FA47",
"CJK COMPATIBILITY IDEOGRAPH-FA48",
"CJK COMPATIBILITY IDEOGRAPH-FA49",
"CJK COMPATIBILITY IDEOGRAPH-FA4A",
"CJK COMPATIBILITY IDEOGRAPH-FA4B",
"CJK COMPATIBILITY IDEOGRAPH-FA4C",
"CJK COMPATIBILITY IDEOGRAPH-FA4D",
"CJK COMPATIBILITY IDEOGRAPH-FA4E",
"CJK COMPATIBILITY IDEOGRAPH-FA4F",
"CJK COMPATIBILITY IDEOGRAPH-FA50",
"CJK COMPATIBILITY IDEOGRAPH-FA51",
"CJK COMPATIBILITY IDEOGRAPH-FA52",
"CJK COMPATIBILITY IDEOGRAPH-FA53",
"CJK COMPATIBILITY IDEOGRAPH-FA54",
"CJK COMPATIBILITY IDEOGRAPH-FA55",
"CJK COMPATIBILITY IDEOGRAPH-FA56",
"CJK COMPATIBILITY IDEOGRAPH-FA57",
"CJK COMPATIBILITY IDEOGRAPH-FA58",
"CJK COMPATIBILITY IDEOGRAPH-FA59",
"CJK COMPATIBILITY IDEOGRAPH-FA5A",
"CJK COMPATIBILITY IDEOGRAPH-FA5B",
"CJK COMPATIBILITY IDEOGRAPH-FA5C",
"CJK COMPATIBILITY IDEOGRAPH-FA5D",
"CJK COMPATIBILITY IDEOGRAPH-FA5E",
"CJK COMPATIBILITY IDEOGRAPH-FA5F",
"CJK COMPATIBILITY IDEOGRAPH-FA60",
"CJK COMPATIBILITY IDEOGRAPH-FA61",
"CJK COMPATIBILITY IDEOGRAPH-FA62",
"CJK COMPATIBILITY IDEOGRAPH-FA63",
"CJK COMPATIBILITY IDEOGRAPH-FA64",
"CJK COMPATIBILITY IDEOGRAPH-FA65",
"CJK COMPATIBILITY IDEOGRAPH-FA66",
"CJK COMPATIBILITY IDEOGRAPH-FA67",
"CJK COMPATIBILITY IDEOGRAPH-FA68",
"CJK COMPATIBILITY IDEOGRAPH-FA69",
"CJK COMPATIBILITY IDEOGRAPH-FA6A",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"CJK COMPATIBILITY IDEOGRAPH-FA70",
"CJK COMPATIBILITY IDEOGRAPH-FA71",
"CJK COMPATIBILITY IDEOGRAPH-FA72",
"CJK COMPATIBILITY IDEOGRAPH-FA73",
"CJK COMPATIBILITY IDEOGRAPH-FA74",
"CJK COMPATIBILITY IDEOGRAPH-FA75",
"CJK COMPATIBILITY IDEOGRAPH-FA76",
"CJK COMPATIBILITY IDEOGRAPH-FA77",
"CJK COMPATIBILITY IDEOGRAPH-FA78",
"CJK COMPATIBILITY IDEOGRAPH-FA79",
"CJK COMPATIBILITY IDEOGRAPH-FA7A",
"CJK COMPATIBILITY IDEOGRAPH-FA7B",
"CJK COMPATIBILITY IDEOGRAPH-FA7C",
"CJK COMPATIBILITY IDEOGRAPH-FA7D",
"CJK COMPATIBILITY IDEOGRAPH-FA7E",
"CJK COMPATIBILITY IDEOGRAPH-FA7F",
"CJK COMPATIBILITY IDEOGRAPH-FA80",
"CJK COMPATIBILITY IDEOGRAPH-FA81",
"CJK COMPATIBILITY IDEOGRAPH-FA82",
"CJK COMPATIBILITY IDEOGRAPH-FA83",
"CJK COMPATIBILITY IDEOGRAPH-FA84",
"CJK COMPATIBILITY IDEOGRAPH-FA85",
"CJK COMPATIBILITY IDEOGRAPH-FA86",
"CJK COMPATIBILITY IDEOGRAPH-FA87",
"CJK COMPATIBILITY IDEOGRAPH-FA88",
"CJK COMPATIBILITY IDEOGRAPH-FA89",
"CJK COMPATIBILITY IDEOGRAPH-FA8A",
"CJK COMPATIBILITY IDEOGRAPH-FA8B",
"CJK COMPATIBILITY IDEOGRAPH-FA8C",
"CJK COMPATIBILITY IDEOGRAPH-FA8D",
"CJK COMPATIBILITY IDEOGRAPH-FA8E",
"CJK COMPATIBILITY IDEOGRAPH-FA8F",
"CJK COMPATIBILITY IDEOGRAPH-FA90",
"CJK COMPATIBILITY IDEOGRAPH-FA91",
"CJK COMPATIBILITY IDEOGRAPH-FA92",
"CJK COMPATIBILITY IDEOGRAPH-FA93",
"CJK COMPATIBILITY IDEOGRAPH-FA94",
"CJK COMPATIBILITY IDEOGRAPH-FA95",
"CJK COMPATIBILITY IDEOGRAPH-FA96",
"CJK COMPATIBILITY IDEOGRAPH-FA97",
"CJK COMPATIBILITY IDEOGRAPH-FA98",
"CJK COMPATIBILITY IDEOGRAPH-FA99",
"CJK COMPATIBILITY IDEOGRAPH-FA9A",
"CJK COMPATIBILITY IDEOGRAPH-FA9B",
"CJK COMPATIBILITY IDEOGRAPH-FA9C",
"CJK COMPATIBILITY IDEOGRAPH-FA9D",
"CJK COMPATIBILITY IDEOGRAPH-FA9E",
"CJK COMPATIBILITY IDEOGRAPH-FA9F",
"CJK COMPATIBILITY IDEOGRAPH-FAA0",
"CJK COMPATIBILITY IDEOGRAPH-FAA1",
"CJK COMPATIBILITY IDEOGRAPH-FAA2",
"CJK COMPATIBILITY IDEOGRAPH-FAA3",
"CJK COMPATIBILITY IDEOGRAPH-FAA4",
"CJK COMPATIBILITY IDEOGRAPH-FAA5",
"CJK COMPATIBILITY IDEOGRAPH-FAA6",
"CJK COMPATIBILITY IDEOGRAPH-FAA7",
"CJK COMPATIBILITY IDEOGRAPH-FAA8",
"CJK COMPATIBILITY IDEOGRAPH-FAA9",
"CJK COMPATIBILITY IDEOGRAPH-FAAA",
"CJK COMPATIBILITY IDEOGRAPH-FAAB",
"CJK COMPATIBILITY IDEOGRAPH-FAAC",
"CJK COMPATIBILITY IDEOGRAPH-FAAD",
"CJK COMPATIBILITY IDEOGRAPH-FAAE",
"CJK COMPATIBILITY IDEOGRAPH-FAAF",
"CJK COMPATIBILITY IDEOGRAPH-FAB0",
"CJK COMPATIBILITY IDEOGRAPH-FAB1",
"CJK COMPATIBILITY IDEOGRAPH-FAB2",
"CJK COMPATIBILITY IDEOGRAPH-FAB3",
"CJK COMPATIBILITY IDEOGRAPH-FAB4",
"CJK COMPATIBILITY IDEOGRAPH-FAB5",
"CJK COMPATIBILITY IDEOGRAPH-FAB6",
"CJK COMPATIBILITY IDEOGRAPH-FAB7",
"CJK COMPATIBILITY IDEOGRAPH-FAB8",
"CJK COMPATIBILITY IDEOGRAPH-FAB9",
"CJK COMPATIBILITY IDEOGRAPH-FABA",
"CJK COMPATIBILITY IDEOGRAPH-FABB",
"CJK COMPATIBILITY IDEOGRAPH-FABC",
"CJK COMPATIBILITY IDEOGRAPH-FABD",
"CJK COMPATIBILITY IDEOGRAPH-FABE",
"CJK COMPATIBILITY IDEOGRAPH-FABF",
"CJK COMPATIBILITY IDEOGRAPH-FAC0",
"CJK COMPATIBILITY IDEOGRAPH-FAC1",
"CJK COMPATIBILITY IDEOGRAPH-FAC2",
"CJK COMPATIBILITY IDEOGRAPH-FAC3",
"CJK COMPATIBILITY IDEOGRAPH-FAC4",
"CJK COMPATIBILITY IDEOGRAPH-FAC5",
"CJK COMPATIBILITY IDEOGRAPH-FAC6",
"CJK COMPATIBILITY IDEOGRAPH-FAC7",
"CJK COMPATIBILITY IDEOGRAPH-FAC8",
"CJK COMPATIBILITY IDEOGRAPH-FAC9",
"CJK COMPATIBILITY IDEOGRAPH-FACA",
"CJK COMPATIBILITY IDEOGRAPH-FACB",
"CJK COMPATIBILITY IDEOGRAPH-FACC",
"CJK COMPATIBILITY IDEOGRAPH-FACD",
"CJK COMPATIBILITY IDEOGRAPH-FACE",
"CJK COMPATIBILITY IDEOGRAPH-FACF",
"CJK COMPATIBILITY IDEOGRAPH-FAD0",
"CJK COMPATIBILITY IDEOGRAPH-FAD1",
"CJK COMPATIBILITY IDEOGRAPH-FAD2",
"CJK COMPATIBILITY IDEOGRAPH-FAD3",
"CJK COMPATIBILITY IDEOGRAPH-FAD4",
"CJK COMPATIBILITY IDEOGRAPH-FAD5",
"CJK COMPATIBILITY IDEOGRAPH-FAD6",
"CJK COMPATIBILITY IDEOGRAPH-FAD7",
"CJK COMPATIBILITY IDEOGRAPH-FAD8",
"CJK COMPATIBILITY IDEOGRAPH-FAD9",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_00fb[256] =
{
"LATIN SMALL LIGATURE FF",
"LATIN SMALL LIGATURE FI",
"LATIN SMALL LIGATURE FL",
"LATIN SMALL LIGATURE FFI",
"LATIN SMALL LIGATURE FFL",
"LATIN SMALL LIGATURE LONG S T",
"LATIN SMALL LIGATURE ST",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ARMENIAN SMALL LIGATURE MEN NOW",
"ARMENIAN SMALL LIGATURE MEN ECH",
"ARMENIAN SMALL LIGATURE MEN INI",
"ARMENIAN SMALL LIGATURE VEW NOW",
"ARMENIAN SMALL LIGATURE MEN XEH",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"HEBREW LETTER YOD WITH HIRIQ",
"HEBREW POINT JUDEO-SPANISH VARIKA",
"HEBREW LIGATURE YIDDISH YOD YOD PATAH",
"HEBREW LETTER ALTERNATIVE AYIN",
"HEBREW LETTER WIDE ALEF",
"HEBREW LETTER WIDE DALET",
"HEBREW LETTER WIDE HE",
"HEBREW LETTER WIDE KAF",
"HEBREW LETTER WIDE LAMED",
"HEBREW LETTER WIDE FINAL MEM",
"HEBREW LETTER WIDE RESH",
"HEBREW LETTER WIDE TAV",
"HEBREW LETTER ALTERNATIVE PLUS SIGN",
"HEBREW LETTER SHIN WITH SHIN DOT",
"HEBREW LETTER SHIN WITH SIN DOT",
"HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT",
"HEBREW LETTER SHIN WITH DAGESH AND SIN DOT",
"HEBREW LETTER ALEF WITH PATAH",
"HEBREW LETTER ALEF WITH QAMATS",
"HEBREW LETTER ALEF WITH MAPIQ",
"HEBREW LETTER BET WITH DAGESH",
"HEBREW LETTER GIMEL WITH DAGESH",
"HEBREW LETTER DALET WITH DAGESH",
"HEBREW LETTER HE WITH MAPIQ",
"HEBREW LETTER VAV WITH DAGESH",
"HEBREW LETTER ZAYIN WITH DAGESH",
name_reserved,
"HEBREW LETTER TET WITH DAGESH",
"HEBREW LETTER YOD WITH DAGESH",
"HEBREW LETTER FINAL KAF WITH DAGESH",
"HEBREW LETTER KAF WITH DAGESH",
"HEBREW LETTER LAMED WITH DAGESH",
name_reserved,
"HEBREW LETTER MEM WITH DAGESH",
name_reserved,
"HEBREW LETTER NUN WITH DAGESH",
"HEBREW LETTER SAMEKH WITH DAGESH",
name_reserved,
"HEBREW LETTER FINAL PE WITH DAGESH",
"HEBREW LETTER PE WITH DAGESH",
name_reserved,
"HEBREW LETTER TSADI WITH DAGESH",
"HEBREW LETTER QOF WITH DAGESH",
"HEBREW LETTER RESH WITH DAGESH",
"HEBREW LETTER SHIN WITH DAGESH",
"HEBREW LETTER TAV WITH DAGESH",
"HEBREW LETTER VAV WITH HOLAM",
"HEBREW LETTER BET WITH RAFE",
"HEBREW LETTER KAF WITH RAFE",
"HEBREW LETTER PE WITH RAFE",
"HEBREW LIGATURE ALEF LAMED",
"ARABIC LETTER ALEF WASLA ISOLATED FORM",
"ARABIC LETTER ALEF WASLA FINAL FORM",
"ARABIC LETTER BEEH ISOLATED FORM",
"ARABIC LETTER BEEH FINAL FORM",
"ARABIC LETTER BEEH INITIAL FORM",
"ARABIC LETTER BEEH MEDIAL FORM",
"ARABIC LETTER PEH ISOLATED FORM",
"ARABIC LETTER PEH FINAL FORM",
"ARABIC LETTER PEH INITIAL FORM",
"ARABIC LETTER PEH MEDIAL FORM",
"ARABIC LETTER BEHEH ISOLATED FORM",
"ARABIC LETTER BEHEH FINAL FORM",
"ARABIC LETTER BEHEH INITIAL FORM",
"ARABIC LETTER BEHEH MEDIAL FORM",
"ARABIC LETTER TTEHEH ISOLATED FORM",
"ARABIC LETTER TTEHEH FINAL FORM",
"ARABIC LETTER TTEHEH INITIAL FORM",
"ARABIC LETTER TTEHEH MEDIAL FORM",
"ARABIC LETTER TEHEH ISOLATED FORM",
"ARABIC LETTER TEHEH FINAL FORM",
"ARABIC LETTER TEHEH INITIAL FORM",
"ARABIC LETTER TEHEH MEDIAL FORM",
"ARABIC LETTER TTEH ISOLATED FORM",
"ARABIC LETTER TTEH FINAL FORM",
"ARABIC LETTER TTEH INITIAL FORM",
"ARABIC LETTER TTEH MEDIAL FORM",
"ARABIC LETTER VEH ISOLATED FORM",
"ARABIC LETTER VEH FINAL FORM",
"ARABIC LETTER VEH INITIAL FORM",
"ARABIC LETTER VEH MEDIAL FORM",
"ARABIC LETTER PEHEH ISOLATED FORM",
"ARABIC LETTER PEHEH FINAL FORM",
"ARABIC LETTER PEHEH INITIAL FORM",
"ARABIC LETTER PEHEH MEDIAL FORM",
"ARABIC LETTER DYEH ISOLATED FORM",
"ARABIC LETTER DYEH FINAL FORM",
"ARABIC LETTER DYEH INITIAL FORM",
"ARABIC LETTER DYEH MEDIAL FORM",
"ARABIC LETTER NYEH ISOLATED FORM",
"ARABIC LETTER NYEH FINAL FORM",
"ARABIC LETTER NYEH INITIAL FORM",
"ARABIC LETTER NYEH MEDIAL FORM",
"ARABIC LETTER TCHEH ISOLATED FORM",
"ARABIC LETTER TCHEH FINAL FORM",
"ARABIC LETTER TCHEH INITIAL FORM",
"ARABIC LETTER TCHEH MEDIAL FORM",
"ARABIC LETTER TCHEHEH ISOLATED FORM",
"ARABIC LETTER TCHEHEH FINAL FORM",
"ARABIC LETTER TCHEHEH INITIAL FORM",
"ARABIC LETTER TCHEHEH MEDIAL FORM",
"ARABIC LETTER DDAHAL ISOLATED FORM",
"ARABIC LETTER DDAHAL FINAL FORM",
"ARABIC LETTER DAHAL ISOLATED FORM",
"ARABIC LETTER DAHAL FINAL FORM",
"ARABIC LETTER DUL ISOLATED FORM",
"ARABIC LETTER DUL FINAL FORM",
"ARABIC LETTER DDAL ISOLATED FORM",
"ARABIC LETTER DDAL FINAL FORM",
"ARABIC LETTER JEH ISOLATED FORM",
"ARABIC LETTER JEH FINAL FORM",
"ARABIC LETTER RREH ISOLATED FORM",
"ARABIC LETTER RREH FINAL FORM",
"ARABIC LETTER KEHEH ISOLATED FORM",
"ARABIC LETTER KEHEH FINAL FORM",
"ARABIC LETTER KEHEH INITIAL FORM",
"ARABIC LETTER KEHEH MEDIAL FORM",
"ARABIC LETTER GAF ISOLATED FORM",
"ARABIC LETTER GAF FINAL FORM",
"ARABIC LETTER GAF INITIAL FORM",
"ARABIC LETTER GAF MEDIAL FORM",
"ARABIC LETTER GUEH ISOLATED FORM",
"ARABIC LETTER GUEH FINAL FORM",
"ARABIC LETTER GUEH INITIAL FORM",
"ARABIC LETTER GUEH MEDIAL FORM",
"ARABIC LETTER NGOEH ISOLATED FORM",
"ARABIC LETTER NGOEH FINAL FORM",
"ARABIC LETTER NGOEH INITIAL FORM",
"ARABIC LETTER NGOEH MEDIAL FORM",
"ARABIC LETTER NOON GHUNNA ISOLATED FORM",
"ARABIC LETTER NOON GHUNNA FINAL FORM",
"ARABIC LETTER RNOON ISOLATED FORM",
"ARABIC LETTER RNOON FINAL FORM",
"ARABIC LETTER RNOON INITIAL FORM",
"ARABIC LETTER RNOON MEDIAL FORM",
"ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM",
"ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM",
"ARABIC LETTER HEH GOAL ISOLATED FORM",
"ARABIC LETTER HEH GOAL FINAL FORM",
"ARABIC LETTER HEH GOAL INITIAL FORM",
"ARABIC LETTER HEH GOAL MEDIAL FORM",
"ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM",
"ARABIC LETTER HEH DOACHASHMEE FINAL FORM",
"ARABIC LETTER HEH DOACHASHMEE INITIAL FORM",
"ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM",
"ARABIC LETTER YEH BARREE ISOLATED FORM",
"ARABIC LETTER YEH BARREE FINAL FORM",
"ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM",
"ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ARABIC LETTER NG ISOLATED FORM",
"ARABIC LETTER NG FINAL FORM",
"ARABIC LETTER NG INITIAL FORM",
"ARABIC LETTER NG MEDIAL FORM",
"ARABIC LETTER U ISOLATED FORM",
"ARABIC LETTER U FINAL FORM",
"ARABIC LETTER OE ISOLATED FORM",
"ARABIC LETTER OE FINAL FORM",
"ARABIC LETTER YU ISOLATED FORM",
"ARABIC LETTER YU FINAL FORM",
"ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM",
"ARABIC LETTER VE ISOLATED FORM",
"ARABIC LETTER VE FINAL FORM",
"ARABIC LETTER KIRGHIZ OE ISOLATED FORM",
"ARABIC LETTER KIRGHIZ OE FINAL FORM",
"ARABIC LETTER KIRGHIZ YU ISOLATED FORM",
"ARABIC LETTER KIRGHIZ YU FINAL FORM",
"ARABIC LETTER E ISOLATED FORM",
"ARABIC LETTER E FINAL FORM",
"ARABIC LETTER E INITIAL FORM",
"ARABIC LETTER E MEDIAL FORM",
"ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM",
"ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM",
"ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM",
"ARABIC LETTER FARSI YEH ISOLATED FORM",
"ARABIC LETTER FARSI YEH FINAL FORM",
"ARABIC LETTER FARSI YEH INITIAL FORM",
"ARABIC LETTER FARSI YEH MEDIAL FORM"};
static const char * name_00fc[256] =
{
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM",
"ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE BEH WITH HAH ISOLATED FORM",
"ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE BEH WITH YEH ISOLATED FORM",
"ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE TEH WITH HAH ISOLATED FORM",
"ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE TEH WITH YEH ISOLATED FORM",
"ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE THEH WITH YEH ISOLATED FORM",
"ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM",
"ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM",
"ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM",
"ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE SAD WITH HAH ISOLATED FORM",
"ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE DAD WITH HAH ISOLATED FORM",
"ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE TAH WITH HAH ISOLATED FORM",
"ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE FEH WITH HAH ISOLATED FORM",
"ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE FEH WITH YEH ISOLATED FORM",
"ARABIC LIGATURE QAF WITH HAH ISOLATED FORM",
"ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE QAF WITH YEH ISOLATED FORM",
"ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM",
"ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE KAF WITH HAH ISOLATED FORM",
"ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE KAF WITH LAM ISOLATED FORM",
"ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE KAF WITH YEH ISOLATED FORM",
"ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE LAM WITH HAH ISOLATED FORM",
"ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE LAM WITH YEH ISOLATED FORM",
"ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM",
"ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM",
"ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE NOON WITH HAH ISOLATED FORM",
"ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE NOON WITH YEH ISOLATED FORM",
"ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE HEH WITH YEH ISOLATED FORM",
"ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAH ISOLATED FORM",
"ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE YEH WITH YEH ISOLATED FORM",
"ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM",
"ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM",
"ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM",
"ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM",
"ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM",
"ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM",
"ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM",
"ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM",
"ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM",
"ARABIC LIGATURE BEH WITH REH FINAL FORM",
"ARABIC LIGATURE BEH WITH ZAIN FINAL FORM",
"ARABIC LIGATURE BEH WITH MEEM FINAL FORM",
"ARABIC LIGATURE BEH WITH NOON FINAL FORM",
"ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE BEH WITH YEH FINAL FORM",
"ARABIC LIGATURE TEH WITH REH FINAL FORM",
"ARABIC LIGATURE TEH WITH ZAIN FINAL FORM",
"ARABIC LIGATURE TEH WITH MEEM FINAL FORM",
"ARABIC LIGATURE TEH WITH NOON FINAL FORM",
"ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE TEH WITH YEH FINAL FORM",
"ARABIC LIGATURE THEH WITH REH FINAL FORM",
"ARABIC LIGATURE THEH WITH ZAIN FINAL FORM",
"ARABIC LIGATURE THEH WITH MEEM FINAL FORM",
"ARABIC LIGATURE THEH WITH NOON FINAL FORM",
"ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE THEH WITH YEH FINAL FORM",
"ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE FEH WITH YEH FINAL FORM",
"ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE QAF WITH YEH FINAL FORM",
"ARABIC LIGATURE KAF WITH ALEF FINAL FORM",
"ARABIC LIGATURE KAF WITH LAM FINAL FORM",
"ARABIC LIGATURE KAF WITH MEEM FINAL FORM",
"ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE KAF WITH YEH FINAL FORM",
"ARABIC LIGATURE LAM WITH MEEM FINAL FORM",
"ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE LAM WITH YEH FINAL FORM",
"ARABIC LIGATURE MEEM WITH ALEF FINAL FORM",
"ARABIC LIGATURE MEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE NOON WITH REH FINAL FORM",
"ARABIC LIGATURE NOON WITH ZAIN FINAL FORM",
"ARABIC LIGATURE NOON WITH MEEM FINAL FORM",
"ARABIC LIGATURE NOON WITH NOON FINAL FORM",
"ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE NOON WITH YEH FINAL FORM",
"ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM",
"ARABIC LIGATURE YEH WITH REH FINAL FORM",
"ARABIC LIGATURE YEH WITH ZAIN FINAL FORM",
"ARABIC LIGATURE YEH WITH MEEM FINAL FORM",
"ARABIC LIGATURE YEH WITH NOON FINAL FORM",
"ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE YEH WITH YEH FINAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM",
"ARABIC LIGATURE BEH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE BEH WITH HAH INITIAL FORM",
"ARABIC LIGATURE BEH WITH KHAH INITIAL FORM",
"ARABIC LIGATURE BEH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE BEH WITH HEH INITIAL FORM",
"ARABIC LIGATURE TEH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE TEH WITH HAH INITIAL FORM",
"ARABIC LIGATURE TEH WITH KHAH INITIAL FORM",
"ARABIC LIGATURE TEH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE TEH WITH HEH INITIAL FORM",
"ARABIC LIGATURE THEH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE JEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE HAH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE HAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM",
"ARABIC LIGATURE SEEN WITH HAH INITIAL FORM",
"ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM",
"ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM",
"ARABIC LIGATURE SAD WITH HAH INITIAL FORM",
"ARABIC LIGATURE SAD WITH KHAH INITIAL FORM",
"ARABIC LIGATURE SAD WITH MEEM INITIAL FORM",
"ARABIC LIGATURE DAD WITH JEEM INITIAL FORM",
"ARABIC LIGATURE DAD WITH HAH INITIAL FORM",
"ARABIC LIGATURE DAD WITH KHAH INITIAL FORM",
"ARABIC LIGATURE DAD WITH MEEM INITIAL FORM",
"ARABIC LIGATURE TAH WITH HAH INITIAL FORM",
"ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE AIN WITH JEEM INITIAL FORM",
"ARABIC LIGATURE AIN WITH MEEM INITIAL FORM",
"ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM",
"ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM",
"ARABIC LIGATURE FEH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE FEH WITH HAH INITIAL FORM",
"ARABIC LIGATURE FEH WITH KHAH INITIAL FORM",
"ARABIC LIGATURE FEH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE QAF WITH HAH INITIAL FORM",
"ARABIC LIGATURE QAF WITH MEEM INITIAL FORM",
"ARABIC LIGATURE KAF WITH JEEM INITIAL FORM",
"ARABIC LIGATURE KAF WITH HAH INITIAL FORM",
"ARABIC LIGATURE KAF WITH KHAH INITIAL FORM",
"ARABIC LIGATURE KAF WITH LAM INITIAL FORM",
"ARABIC LIGATURE KAF WITH MEEM INITIAL FORM",
"ARABIC LIGATURE LAM WITH JEEM INITIAL FORM",
"ARABIC LIGATURE LAM WITH HAH INITIAL FORM",
"ARABIC LIGATURE LAM WITH KHAH INITIAL FORM",
"ARABIC LIGATURE LAM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE LAM WITH HEH INITIAL FORM",
"ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM",
"ARABIC LIGATURE MEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM",
"ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE NOON WITH JEEM INITIAL FORM",
"ARABIC LIGATURE NOON WITH HAH INITIAL FORM",
"ARABIC LIGATURE NOON WITH KHAH INITIAL FORM",
"ARABIC LIGATURE NOON WITH MEEM INITIAL FORM",
"ARABIC LIGATURE NOON WITH HEH INITIAL FORM",
"ARABIC LIGATURE HEH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE HEH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM",
"ARABIC LIGATURE YEH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE YEH WITH HAH INITIAL FORM",
"ARABIC LIGATURE YEH WITH KHAH INITIAL FORM",
"ARABIC LIGATURE YEH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE YEH WITH HEH INITIAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM",
"ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE BEH WITH HEH MEDIAL FORM",
"ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE TEH WITH HEH MEDIAL FORM",
"ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE THEH WITH HEH MEDIAL FORM",
"ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM",
"ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM",
"ARABIC LIGATURE KAF WITH LAM MEDIAL FORM",
"ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE NOON WITH HEH MEDIAL FORM",
"ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE YEH WITH HEH MEDIAL FORM",
"ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM",
"ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM",
"ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM",
"ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE TAH WITH YEH ISOLATED FORM",
"ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE AIN WITH YEH ISOLATED FORM",
"ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM",
"ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM",
"ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM",
"ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM"};
static const char * name_00fd[256] =
{
"ARABIC LIGATURE HAH WITH YEH ISOLATED FORM",
"ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM",
"ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM",
"ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE SAD WITH YEH ISOLATED FORM",
"ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM",
"ARABIC LIGATURE DAD WITH YEH ISOLATED FORM",
"ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM",
"ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM",
"ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM",
"ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM",
"ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM",
"ARABIC LIGATURE SEEN WITH REH ISOLATED FORM",
"ARABIC LIGATURE SAD WITH REH ISOLATED FORM",
"ARABIC LIGATURE DAD WITH REH ISOLATED FORM",
"ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE TAH WITH YEH FINAL FORM",
"ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE AIN WITH YEH FINAL FORM",
"ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE GHAIN WITH YEH FINAL FORM",
"ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE SEEN WITH YEH FINAL FORM",
"ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE SHEEN WITH YEH FINAL FORM",
"ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE JEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE KHAH WITH YEH FINAL FORM",
"ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE SAD WITH YEH FINAL FORM",
"ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE DAD WITH YEH FINAL FORM",
"ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM",
"ARABIC LIGATURE SHEEN WITH HAH FINAL FORM",
"ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM",
"ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM",
"ARABIC LIGATURE SHEEN WITH REH FINAL FORM",
"ARABIC LIGATURE SEEN WITH REH FINAL FORM",
"ARABIC LIGATURE SAD WITH REH FINAL FORM",
"ARABIC LIGATURE DAD WITH REH FINAL FORM",
"ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM",
"ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM",
"ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM",
"ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM",
"ARABIC LIGATURE SEEN WITH HEH INITIAL FORM",
"ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM",
"ARABIC LIGATURE TAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM",
"ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM",
"ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM",
"ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM",
"ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM",
"ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM",
"ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM",
"ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM",
"ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM",
"ORNATE LEFT PARENTHESIS",
"ORNATE RIGHT PARENTHESIS",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM",
"ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM",
"ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM",
"ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM",
"ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM",
"ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM",
"ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM",
"ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM",
"ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM",
"ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM",
"ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM",
"ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM",
"ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM",
"ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM",
"ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM",
"ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM",
"ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM",
"ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM",
"ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM",
"ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM",
"ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM",
"ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM",
name_reserved,
name_reserved,
"ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM",
"ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM",
"ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM",
"ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM",
"ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM",
"ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM",
"ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM",
"ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM",
"ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM",
"ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM",
"ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM",
"ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM",
"ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM",
"ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM",
"ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM",
"ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM",
"ARABIC LIGATURE ALLAH ISOLATED FORM",
"ARABIC LIGATURE AKBAR ISOLATED FORM",
"ARABIC LIGATURE MOHAMMAD ISOLATED FORM",
"ARABIC LIGATURE SALAM ISOLATED FORM",
"ARABIC LIGATURE RASOUL ISOLATED FORM",
"ARABIC LIGATURE ALAYHE ISOLATED FORM",
"ARABIC LIGATURE WASALLAM ISOLATED FORM",
"ARABIC LIGATURE SALLA ISOLATED FORM",
"ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM",
"ARABIC LIGATURE JALLAJALALOUHOU",
"RIAL SIGN",
"ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM",
name_reserved,
name_reserved};
static const char * name_00fe[256] =
{
"VARIATION SELECTOR-1",
"VARIATION SELECTOR-2",
"VARIATION SELECTOR-3",
"VARIATION SELECTOR-4",
"VARIATION SELECTOR-5",
"VARIATION SELECTOR-6",
"VARIATION SELECTOR-7",
"VARIATION SELECTOR-8",
"VARIATION SELECTOR-9",
"VARIATION SELECTOR-10",
"VARIATION SELECTOR-11",
"VARIATION SELECTOR-12",
"VARIATION SELECTOR-13",
"VARIATION SELECTOR-14",
"VARIATION SELECTOR-15",
"VARIATION SELECTOR-16",
"PRESENTATION FORM FOR VERTICAL COMMA",
"PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMA",
"PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOP",
"PRESENTATION FORM FOR VERTICAL COLON",
"PRESENTATION FORM FOR VERTICAL SEMICOLON",
"PRESENTATION FORM FOR VERTICAL EXCLAMATION MARK",
"PRESENTATION FORM FOR VERTICAL QUESTION MARK",
"PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET",
"PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET",
"PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"COMBINING LIGATURE LEFT HALF",
"COMBINING LIGATURE RIGHT HALF",
"COMBINING DOUBLE TILDE LEFT HALF",
"COMBINING DOUBLE TILDE RIGHT HALF",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"PRESENTATION FORM FOR VERTICAL TWO DOT LEADER",
"PRESENTATION FORM FOR VERTICAL EM DASH",
"PRESENTATION FORM FOR VERTICAL EN DASH",
"PRESENTATION FORM FOR VERTICAL LOW LINE",
"PRESENTATION FORM FOR VERTICAL WAVY LOW LINE",
"PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS",
"PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS",
"PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET",
"PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET",
"PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET",
"PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET",
"PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET",
"PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET",
"PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET",
"PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET",
"PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET",
"PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET",
"PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET",
"PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET",
"PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET",
"PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET",
"SESAME DOT",
"WHITE SESAME DOT",
"PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET",
"PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET",
"DASHED OVERLINE",
"CENTRELINE OVERLINE",
"WAVY OVERLINE",
"DOUBLE WAVY OVERLINE",
"DASHED LOW LINE",
"CENTRELINE LOW LINE",
"WAVY LOW LINE",
"SMALL COMMA",
"SMALL IDEOGRAPHIC COMMA",
"SMALL FULL STOP",
name_reserved,
"SMALL SEMICOLON",
"SMALL COLON",
"SMALL QUESTION MARK",
"SMALL EXCLAMATION MARK",
"SMALL EM DASH",
"SMALL LEFT PARENTHESIS",
"SMALL RIGHT PARENTHESIS",
"SMALL LEFT CURLY BRACKET",
"SMALL RIGHT CURLY BRACKET",
"SMALL LEFT TORTOISE SHELL BRACKET",
"SMALL RIGHT TORTOISE SHELL BRACKET",
"SMALL NUMBER SIGN",
"SMALL AMPERSAND",
"SMALL ASTERISK",
"SMALL PLUS SIGN",
"SMALL HYPHEN-MINUS",
"SMALL LESS-THAN SIGN",
"SMALL GREATER-THAN SIGN",
"SMALL EQUALS SIGN",
name_reserved,
"SMALL REVERSE SOLIDUS",
"SMALL DOLLAR SIGN",
"SMALL PERCENT SIGN",
"SMALL COMMERCIAL AT",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"ARABIC FATHATAN ISOLATED FORM",
"ARABIC TATWEEL WITH FATHATAN ABOVE",
"ARABIC DAMMATAN ISOLATED FORM",
"ARABIC TAIL FRAGMENT",
"ARABIC KASRATAN ISOLATED FORM",
name_reserved,
"ARABIC FATHA ISOLATED FORM",
"ARABIC FATHA MEDIAL FORM",
"ARABIC DAMMA ISOLATED FORM",
"ARABIC DAMMA MEDIAL FORM",
"ARABIC KASRA ISOLATED FORM",
"ARABIC KASRA MEDIAL FORM",
"ARABIC SHADDA ISOLATED FORM",
"ARABIC SHADDA MEDIAL FORM",
"ARABIC SUKUN ISOLATED FORM",
"ARABIC SUKUN MEDIAL FORM",
"ARABIC LETTER HAMZA ISOLATED FORM",
"ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM",
"ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM",
"ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM",
"ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM",
"ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM",
"ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM",
"ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM",
"ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM",
"ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM",
"ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM",
"ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM",
"ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM",
"ARABIC LETTER ALEF ISOLATED FORM",
"ARABIC LETTER ALEF FINAL FORM",
"ARABIC LETTER BEH ISOLATED FORM",
"ARABIC LETTER BEH FINAL FORM",
"ARABIC LETTER BEH INITIAL FORM",
"ARABIC LETTER BEH MEDIAL FORM",
"ARABIC LETTER TEH MARBUTA ISOLATED FORM",
"ARABIC LETTER TEH MARBUTA FINAL FORM",
"ARABIC LETTER TEH ISOLATED FORM",
"ARABIC LETTER TEH FINAL FORM",
"ARABIC LETTER TEH INITIAL FORM",
"ARABIC LETTER TEH MEDIAL FORM",
"ARABIC LETTER THEH ISOLATED FORM",
"ARABIC LETTER THEH FINAL FORM",
"ARABIC LETTER THEH INITIAL FORM",
"ARABIC LETTER THEH MEDIAL FORM",
"ARABIC LETTER JEEM ISOLATED FORM",
"ARABIC LETTER JEEM FINAL FORM",
"ARABIC LETTER JEEM INITIAL FORM",
"ARABIC LETTER JEEM MEDIAL FORM",
"ARABIC LETTER HAH ISOLATED FORM",
"ARABIC LETTER HAH FINAL FORM",
"ARABIC LETTER HAH INITIAL FORM",
"ARABIC LETTER HAH MEDIAL FORM",
"ARABIC LETTER KHAH ISOLATED FORM",
"ARABIC LETTER KHAH FINAL FORM",
"ARABIC LETTER KHAH INITIAL FORM",
"ARABIC LETTER KHAH MEDIAL FORM",
"ARABIC LETTER DAL ISOLATED FORM",
"ARABIC LETTER DAL FINAL FORM",
"ARABIC LETTER THAL ISOLATED FORM",
"ARABIC LETTER THAL FINAL FORM",
"ARABIC LETTER REH ISOLATED FORM",
"ARABIC LETTER REH FINAL FORM",
"ARABIC LETTER ZAIN ISOLATED FORM",
"ARABIC LETTER ZAIN FINAL FORM",
"ARABIC LETTER SEEN ISOLATED FORM",
"ARABIC LETTER SEEN FINAL FORM",
"ARABIC LETTER SEEN INITIAL FORM",
"ARABIC LETTER SEEN MEDIAL FORM",
"ARABIC LETTER SHEEN ISOLATED FORM",
"ARABIC LETTER SHEEN FINAL FORM",
"ARABIC LETTER SHEEN INITIAL FORM",
"ARABIC LETTER SHEEN MEDIAL FORM",
"ARABIC LETTER SAD ISOLATED FORM",
"ARABIC LETTER SAD FINAL FORM",
"ARABIC LETTER SAD INITIAL FORM",
"ARABIC LETTER SAD MEDIAL FORM",
"ARABIC LETTER DAD ISOLATED FORM",
"ARABIC LETTER DAD FINAL FORM",
"ARABIC LETTER DAD INITIAL FORM",
"ARABIC LETTER DAD MEDIAL FORM",
"ARABIC LETTER TAH ISOLATED FORM",
"ARABIC LETTER TAH FINAL FORM",
"ARABIC LETTER TAH INITIAL FORM",
"ARABIC LETTER TAH MEDIAL FORM",
"ARABIC LETTER ZAH ISOLATED FORM",
"ARABIC LETTER ZAH FINAL FORM",
"ARABIC LETTER ZAH INITIAL FORM",
"ARABIC LETTER ZAH MEDIAL FORM",
"ARABIC LETTER AIN ISOLATED FORM",
"ARABIC LETTER AIN FINAL FORM",
"ARABIC LETTER AIN INITIAL FORM",
"ARABIC LETTER AIN MEDIAL FORM",
"ARABIC LETTER GHAIN ISOLATED FORM",
"ARABIC LETTER GHAIN FINAL FORM",
"ARABIC LETTER GHAIN INITIAL FORM",
"ARABIC LETTER GHAIN MEDIAL FORM",
"ARABIC LETTER FEH ISOLATED FORM",
"ARABIC LETTER FEH FINAL FORM",
"ARABIC LETTER FEH INITIAL FORM",
"ARABIC LETTER FEH MEDIAL FORM",
"ARABIC LETTER QAF ISOLATED FORM",
"ARABIC LETTER QAF FINAL FORM",
"ARABIC LETTER QAF INITIAL FORM",
"ARABIC LETTER QAF MEDIAL FORM",
"ARABIC LETTER KAF ISOLATED FORM",
"ARABIC LETTER KAF FINAL FORM",
"ARABIC LETTER KAF INITIAL FORM",
"ARABIC LETTER KAF MEDIAL FORM",
"ARABIC LETTER LAM ISOLATED FORM",
"ARABIC LETTER LAM FINAL FORM",
"ARABIC LETTER LAM INITIAL FORM",
"ARABIC LETTER LAM MEDIAL FORM",
"ARABIC LETTER MEEM ISOLATED FORM",
"ARABIC LETTER MEEM FINAL FORM",
"ARABIC LETTER MEEM INITIAL FORM",
"ARABIC LETTER MEEM MEDIAL FORM",
"ARABIC LETTER NOON ISOLATED FORM",
"ARABIC LETTER NOON FINAL FORM",
"ARABIC LETTER NOON INITIAL FORM",
"ARABIC LETTER NOON MEDIAL FORM",
"ARABIC LETTER HEH ISOLATED FORM",
"ARABIC LETTER HEH FINAL FORM",
"ARABIC LETTER HEH INITIAL FORM",
"ARABIC LETTER HEH MEDIAL FORM",
"ARABIC LETTER WAW ISOLATED FORM",
"ARABIC LETTER WAW FINAL FORM",
"ARABIC LETTER ALEF MAKSURA ISOLATED FORM",
"ARABIC LETTER ALEF MAKSURA FINAL FORM",
"ARABIC LETTER YEH ISOLATED FORM",
"ARABIC LETTER YEH FINAL FORM",
"ARABIC LETTER YEH INITIAL FORM",
"ARABIC LETTER YEH MEDIAL FORM",
"ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM",
"ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM",
"ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM",
"ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM",
"ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM",
"ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM",
"ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM",
"ARABIC LIGATURE LAM WITH ALEF FINAL FORM",
name_reserved,
name_reserved,
"ZERO WIDTH NO-BREAK SPACE"};
static const char * name_00ff[256] =
{
name_reserved,
"FULLWIDTH EXCLAMATION MARK",
"FULLWIDTH QUOTATION MARK",
"FULLWIDTH NUMBER SIGN",
"FULLWIDTH DOLLAR SIGN",
"FULLWIDTH PERCENT SIGN",
"FULLWIDTH AMPERSAND",
"FULLWIDTH APOSTROPHE",
"FULLWIDTH LEFT PARENTHESIS",
"FULLWIDTH RIGHT PARENTHESIS",
"FULLWIDTH ASTERISK",
"FULLWIDTH PLUS SIGN",
"FULLWIDTH COMMA",
"FULLWIDTH HYPHEN-MINUS",
"FULLWIDTH FULL STOP",
"FULLWIDTH SOLIDUS",
"FULLWIDTH DIGIT ZERO",
"FULLWIDTH DIGIT ONE",
"FULLWIDTH DIGIT TWO",
"FULLWIDTH DIGIT THREE",
"FULLWIDTH DIGIT FOUR",
"FULLWIDTH DIGIT FIVE",
"FULLWIDTH DIGIT SIX",
"FULLWIDTH DIGIT SEVEN",
"FULLWIDTH DIGIT EIGHT",
"FULLWIDTH DIGIT NINE",
"FULLWIDTH COLON",
"FULLWIDTH SEMICOLON",
"FULLWIDTH LESS-THAN SIGN",
"FULLWIDTH EQUALS SIGN",
"FULLWIDTH GREATER-THAN SIGN",
"FULLWIDTH QUESTION MARK",
"FULLWIDTH COMMERCIAL AT",
"FULLWIDTH LATIN CAPITAL LETTER A",
"FULLWIDTH LATIN CAPITAL LETTER B",
"FULLWIDTH LATIN CAPITAL LETTER C",
"FULLWIDTH LATIN CAPITAL LETTER D",
"FULLWIDTH LATIN CAPITAL LETTER E",
"FULLWIDTH LATIN CAPITAL LETTER F",
"FULLWIDTH LATIN CAPITAL LETTER G",
"FULLWIDTH LATIN CAPITAL LETTER H",
"FULLWIDTH LATIN CAPITAL LETTER I",
"FULLWIDTH LATIN CAPITAL LETTER J",
"FULLWIDTH LATIN CAPITAL LETTER K",
"FULLWIDTH LATIN CAPITAL LETTER L",
"FULLWIDTH LATIN CAPITAL LETTER M",
"FULLWIDTH LATIN CAPITAL LETTER N",
"FULLWIDTH LATIN CAPITAL LETTER O",
"FULLWIDTH LATIN CAPITAL LETTER P",
"FULLWIDTH LATIN CAPITAL LETTER Q",
"FULLWIDTH LATIN CAPITAL LETTER R",
"FULLWIDTH LATIN CAPITAL LETTER S",
"FULLWIDTH LATIN CAPITAL LETTER T",
"FULLWIDTH LATIN CAPITAL LETTER U",
"FULLWIDTH LATIN CAPITAL LETTER V",
"FULLWIDTH LATIN CAPITAL LETTER W",
"FULLWIDTH LATIN CAPITAL LETTER X",
"FULLWIDTH LATIN CAPITAL LETTER Y",
"FULLWIDTH LATIN CAPITAL LETTER Z",
"FULLWIDTH LEFT SQUARE BRACKET",
"FULLWIDTH REVERSE SOLIDUS",
"FULLWIDTH RIGHT SQUARE BRACKET",
"FULLWIDTH CIRCUMFLEX ACCENT",
"FULLWIDTH LOW LINE",
"FULLWIDTH GRAVE ACCENT",
"FULLWIDTH LATIN SMALL LETTER A",
"FULLWIDTH LATIN SMALL LETTER B",
"FULLWIDTH LATIN SMALL LETTER C",
"FULLWIDTH LATIN SMALL LETTER D",
"FULLWIDTH LATIN SMALL LETTER E",
"FULLWIDTH LATIN SMALL LETTER F",
"FULLWIDTH LATIN SMALL LETTER G",
"FULLWIDTH LATIN SMALL LETTER H",
"FULLWIDTH LATIN SMALL LETTER I",
"FULLWIDTH LATIN SMALL LETTER J",
"FULLWIDTH LATIN SMALL LETTER K",
"FULLWIDTH LATIN SMALL LETTER L",
"FULLWIDTH LATIN SMALL LETTER M",
"FULLWIDTH LATIN SMALL LETTER N",
"FULLWIDTH LATIN SMALL LETTER O",
"FULLWIDTH LATIN SMALL LETTER P",
"FULLWIDTH LATIN SMALL LETTER Q",
"FULLWIDTH LATIN SMALL LETTER R",
"FULLWIDTH LATIN SMALL LETTER S",
"FULLWIDTH LATIN SMALL LETTER T",
"FULLWIDTH LATIN SMALL LETTER U",
"FULLWIDTH LATIN SMALL LETTER V",
"FULLWIDTH LATIN SMALL LETTER W",
"FULLWIDTH LATIN SMALL LETTER X",
"FULLWIDTH LATIN SMALL LETTER Y",
"FULLWIDTH LATIN SMALL LETTER Z",
"FULLWIDTH LEFT CURLY BRACKET",
"FULLWIDTH VERTICAL LINE",
"FULLWIDTH RIGHT CURLY BRACKET",
"FULLWIDTH TILDE",
"FULLWIDTH LEFT WHITE PARENTHESIS",
"FULLWIDTH RIGHT WHITE PARENTHESIS",
"HALFWIDTH IDEOGRAPHIC FULL STOP",
"HALFWIDTH LEFT CORNER BRACKET",
"HALFWIDTH RIGHT CORNER BRACKET",
"HALFWIDTH IDEOGRAPHIC COMMA",
"HALFWIDTH KATAKANA MIDDLE DOT",
"HALFWIDTH KATAKANA LETTER WO",
"HALFWIDTH KATAKANA LETTER SMALL A",
"HALFWIDTH KATAKANA LETTER SMALL I",
"HALFWIDTH KATAKANA LETTER SMALL U",
"HALFWIDTH KATAKANA LETTER SMALL E",
"HALFWIDTH KATAKANA LETTER SMALL O",
"HALFWIDTH KATAKANA LETTER SMALL YA",
"HALFWIDTH KATAKANA LETTER SMALL YU",
"HALFWIDTH KATAKANA LETTER SMALL YO",
"HALFWIDTH KATAKANA LETTER SMALL TU",
"HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK",
"HALFWIDTH KATAKANA LETTER A",
"HALFWIDTH KATAKANA LETTER I",
"HALFWIDTH KATAKANA LETTER U",
"HALFWIDTH KATAKANA LETTER E",
"HALFWIDTH KATAKANA LETTER O",
"HALFWIDTH KATAKANA LETTER KA",
"HALFWIDTH KATAKANA LETTER KI",
"HALFWIDTH KATAKANA LETTER KU",
"HALFWIDTH KATAKANA LETTER KE",
"HALFWIDTH KATAKANA LETTER KO",
"HALFWIDTH KATAKANA LETTER SA",
"HALFWIDTH KATAKANA LETTER SI",
"HALFWIDTH KATAKANA LETTER SU",
"HALFWIDTH KATAKANA LETTER SE",
"HALFWIDTH KATAKANA LETTER SO",
"HALFWIDTH KATAKANA LETTER TA",
"HALFWIDTH KATAKANA LETTER TI",
"HALFWIDTH KATAKANA LETTER TU",
"HALFWIDTH KATAKANA LETTER TE",
"HALFWIDTH KATAKANA LETTER TO",
"HALFWIDTH KATAKANA LETTER NA",
"HALFWIDTH KATAKANA LETTER NI",
"HALFWIDTH KATAKANA LETTER NU",
"HALFWIDTH KATAKANA LETTER NE",
"HALFWIDTH KATAKANA LETTER NO",
"HALFWIDTH KATAKANA LETTER HA",
"HALFWIDTH KATAKANA LETTER HI",
"HALFWIDTH KATAKANA LETTER HU",
"HALFWIDTH KATAKANA LETTER HE",
"HALFWIDTH KATAKANA LETTER HO",
"HALFWIDTH KATAKANA LETTER MA",
"HALFWIDTH KATAKANA LETTER MI",
"HALFWIDTH KATAKANA LETTER MU",
"HALFWIDTH KATAKANA LETTER ME",
"HALFWIDTH KATAKANA LETTER MO",
"HALFWIDTH KATAKANA LETTER YA",
"HALFWIDTH KATAKANA LETTER YU",
"HALFWIDTH KATAKANA LETTER YO",
"HALFWIDTH KATAKANA LETTER RA",
"HALFWIDTH KATAKANA LETTER RI",
"HALFWIDTH KATAKANA LETTER RU",
"HALFWIDTH KATAKANA LETTER RE",
"HALFWIDTH KATAKANA LETTER RO",
"HALFWIDTH KATAKANA LETTER WA",
"HALFWIDTH KATAKANA LETTER N",
"HALFWIDTH KATAKANA VOICED SOUND MARK",
"HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK",
"HALFWIDTH HANGUL FILLER",
"HALFWIDTH HANGUL LETTER KIYEOK",
"HALFWIDTH HANGUL LETTER SSANGKIYEOK",
"HALFWIDTH HANGUL LETTER KIYEOK-SIOS",
"HALFWIDTH HANGUL LETTER NIEUN",
"HALFWIDTH HANGUL LETTER NIEUN-CIEUC",
"HALFWIDTH HANGUL LETTER NIEUN-HIEUH",
"HALFWIDTH HANGUL LETTER TIKEUT",
"HALFWIDTH HANGUL LETTER SSANGTIKEUT",
"HALFWIDTH HANGUL LETTER RIEUL",
"HALFWIDTH HANGUL LETTER RIEUL-KIYEOK",
"HALFWIDTH HANGUL LETTER RIEUL-MIEUM",
"HALFWIDTH HANGUL LETTER RIEUL-PIEUP",
"HALFWIDTH HANGUL LETTER RIEUL-SIOS",
"HALFWIDTH HANGUL LETTER RIEUL-THIEUTH",
"HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH",
"HALFWIDTH HANGUL LETTER RIEUL-HIEUH",
"HALFWIDTH HANGUL LETTER MIEUM",
"HALFWIDTH HANGUL LETTER PIEUP",
"HALFWIDTH HANGUL LETTER SSANGPIEUP",
"HALFWIDTH HANGUL LETTER PIEUP-SIOS",
"HALFWIDTH HANGUL LETTER SIOS",
"HALFWIDTH HANGUL LETTER SSANGSIOS",
"HALFWIDTH HANGUL LETTER IEUNG",
"HALFWIDTH HANGUL LETTER CIEUC",
"HALFWIDTH HANGUL LETTER SSANGCIEUC",
"HALFWIDTH HANGUL LETTER CHIEUCH",
"HALFWIDTH HANGUL LETTER KHIEUKH",
"HALFWIDTH HANGUL LETTER THIEUTH",
"HALFWIDTH HANGUL LETTER PHIEUPH",
"HALFWIDTH HANGUL LETTER HIEUH",
name_reserved,
name_reserved,
name_reserved,
"HALFWIDTH HANGUL LETTER A",
"HALFWIDTH HANGUL LETTER AE",
"HALFWIDTH HANGUL LETTER YA",
"HALFWIDTH HANGUL LETTER YAE",
"HALFWIDTH HANGUL LETTER EO",
"HALFWIDTH HANGUL LETTER E",
name_reserved,
name_reserved,
"HALFWIDTH HANGUL LETTER YEO",
"HALFWIDTH HANGUL LETTER YE",
"HALFWIDTH HANGUL LETTER O",
"HALFWIDTH HANGUL LETTER WA",
"HALFWIDTH HANGUL LETTER WAE",
"HALFWIDTH HANGUL LETTER OE",
name_reserved,
name_reserved,
"HALFWIDTH HANGUL LETTER YO",
"HALFWIDTH HANGUL LETTER U",
"HALFWIDTH HANGUL LETTER WEO",
"HALFWIDTH HANGUL LETTER WE",
"HALFWIDTH HANGUL LETTER WI",
"HALFWIDTH HANGUL LETTER YU",
name_reserved,
name_reserved,
"HALFWIDTH HANGUL LETTER EU",
"HALFWIDTH HANGUL LETTER YI",
"HALFWIDTH HANGUL LETTER I",
name_reserved,
name_reserved,
name_reserved,
"FULLWIDTH CENT SIGN",
"FULLWIDTH POUND SIGN",
"FULLWIDTH NOT SIGN",
"FULLWIDTH MACRON",
"FULLWIDTH BROKEN BAR",
"FULLWIDTH YEN SIGN",
"FULLWIDTH WON SIGN",
name_reserved,
"HALFWIDTH FORMS LIGHT VERTICAL",
"HALFWIDTH LEFTWARDS ARROW",
"HALFWIDTH UPWARDS ARROW",
"HALFWIDTH RIGHTWARDS ARROW",
"HALFWIDTH DOWNWARDS ARROW",
"HALFWIDTH BLACK SQUARE",
"HALFWIDTH WHITE CIRCLE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"INTERLINEAR ANNOTATION ANCHOR",
"INTERLINEAR ANNOTATION SEPARATOR",
"INTERLINEAR ANNOTATION TERMINATOR",
"OBJECT REPLACEMENT CHARACTER",
"REPLACEMENT CHARACTER",
name_reserved,
name_reserved};
static const char * name_0100[256] =
{
"LINEAR B SYLLABLE B008 A",
"LINEAR B SYLLABLE B038 E",
"LINEAR B SYLLABLE B028 I",
"LINEAR B SYLLABLE B061 O",
"LINEAR B SYLLABLE B010 U",
"LINEAR B SYLLABLE B001 DA",
"LINEAR B SYLLABLE B045 DE",
"LINEAR B SYLLABLE B007 DI",
"LINEAR B SYLLABLE B014 DO",
"LINEAR B SYLLABLE B051 DU",
"LINEAR B SYLLABLE B057 JA",
"LINEAR B SYLLABLE B046 JE",
name_reserved,
"LINEAR B SYLLABLE B036 JO",
"LINEAR B SYLLABLE B065 JU",
"LINEAR B SYLLABLE B077 KA",
"LINEAR B SYLLABLE B044 KE",
"LINEAR B SYLLABLE B067 KI",
"LINEAR B SYLLABLE B070 KO",
"LINEAR B SYLLABLE B081 KU",
"LINEAR B SYLLABLE B080 MA",
"LINEAR B SYLLABLE B013 ME",
"LINEAR B SYLLABLE B073 MI",
"LINEAR B SYLLABLE B015 MO",
"LINEAR B SYLLABLE B023 MU",
"LINEAR B SYLLABLE B006 NA",
"LINEAR B SYLLABLE B024 NE",
"LINEAR B SYLLABLE B030 NI",
"LINEAR B SYLLABLE B052 NO",
"LINEAR B SYLLABLE B055 NU",
"LINEAR B SYLLABLE B003 PA",
"LINEAR B SYLLABLE B072 PE",
"LINEAR B SYLLABLE B039 PI",
"LINEAR B SYLLABLE B011 PO",
"LINEAR B SYLLABLE B050 PU",
"LINEAR B SYLLABLE B016 QA",
"LINEAR B SYLLABLE B078 QE",
"LINEAR B SYLLABLE B021 QI",
"LINEAR B SYLLABLE B032 QO",
name_reserved,
"LINEAR B SYLLABLE B060 RA",
"LINEAR B SYLLABLE B027 RE",
"LINEAR B SYLLABLE B053 RI",
"LINEAR B SYLLABLE B002 RO",
"LINEAR B SYLLABLE B026 RU",
"LINEAR B SYLLABLE B031 SA",
"LINEAR B SYLLABLE B009 SE",
"LINEAR B SYLLABLE B041 SI",
"LINEAR B SYLLABLE B012 SO",
"LINEAR B SYLLABLE B058 SU",
"LINEAR B SYLLABLE B059 TA",
"LINEAR B SYLLABLE B004 TE",
"LINEAR B SYLLABLE B037 TI",
"LINEAR B SYLLABLE B005 TO",
"LINEAR B SYLLABLE B069 TU",
"LINEAR B SYLLABLE B054 WA",
"LINEAR B SYLLABLE B075 WE",
"LINEAR B SYLLABLE B040 WI",
"LINEAR B SYLLABLE B042 WO",
name_reserved,
"LINEAR B SYLLABLE B017 ZA",
"LINEAR B SYLLABLE B074 ZE",
name_reserved,
"LINEAR B SYLLABLE B020 ZO",
"LINEAR B SYLLABLE B025 A2",
"LINEAR B SYLLABLE B043 A3",
"LINEAR B SYLLABLE B085 AU",
"LINEAR B SYLLABLE B071 DWE",
"LINEAR B SYLLABLE B090 DWO",
"LINEAR B SYLLABLE B048 NWA",
"LINEAR B SYLLABLE B029 PU2",
"LINEAR B SYLLABLE B062 PTE",
"LINEAR B SYLLABLE B076 RA2",
"LINEAR B SYLLABLE B033 RA3",
"LINEAR B SYLLABLE B068 RO2",
"LINEAR B SYLLABLE B066 TA2",
"LINEAR B SYLLABLE B087 TWE",
"LINEAR B SYLLABLE B091 TWO",
name_reserved,
name_reserved,
"LINEAR B SYMBOL B018",
"LINEAR B SYMBOL B019",
"LINEAR B SYMBOL B022",
"LINEAR B SYMBOL B034",
"LINEAR B SYMBOL B047",
"LINEAR B SYMBOL B049",
"LINEAR B SYMBOL B056",
"LINEAR B SYMBOL B063",
"LINEAR B SYMBOL B064",
"LINEAR B SYMBOL B079",
"LINEAR B SYMBOL B082",
"LINEAR B SYMBOL B083",
"LINEAR B SYMBOL B086",
"LINEAR B SYMBOL B089",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"LINEAR B IDEOGRAM B100 MAN",
"LINEAR B IDEOGRAM B102 WOMAN",
"LINEAR B IDEOGRAM B104 DEER",
"LINEAR B IDEOGRAM B105 EQUID",
"LINEAR B IDEOGRAM B105F MARE",
"LINEAR B IDEOGRAM B105M STALLION",
"LINEAR B IDEOGRAM B106F EWE",
"LINEAR B IDEOGRAM B106M RAM",
"LINEAR B IDEOGRAM B107F SHE-GOAT",
"LINEAR B IDEOGRAM B107M HE-GOAT",
"LINEAR B IDEOGRAM B108F SOW",
"LINEAR B IDEOGRAM B108M BOAR",
"LINEAR B IDEOGRAM B109F COW",
"LINEAR B IDEOGRAM B109M BULL",
"LINEAR B IDEOGRAM B120 WHEAT",
"LINEAR B IDEOGRAM B121 BARLEY",
"LINEAR B IDEOGRAM B122 OLIVE",
"LINEAR B IDEOGRAM B123 SPICE",
"LINEAR B IDEOGRAM B125 CYPERUS",
"LINEAR B MONOGRAM B127 KAPO",
"LINEAR B MONOGRAM B128 KANAKO",
"LINEAR B IDEOGRAM B130 OIL",
"LINEAR B IDEOGRAM B131 WINE",
"LINEAR B IDEOGRAM B132",
"LINEAR B MONOGRAM B133 AREPA",
"LINEAR B MONOGRAM B135 MERI",
"LINEAR B IDEOGRAM B140 BRONZE",
"LINEAR B IDEOGRAM B141 GOLD",
"LINEAR B IDEOGRAM B142",
"LINEAR B IDEOGRAM B145 WOOL",
"LINEAR B IDEOGRAM B146",
"LINEAR B IDEOGRAM B150",
"LINEAR B IDEOGRAM B151 HORN",
"LINEAR B IDEOGRAM B152",
"LINEAR B IDEOGRAM B153",
"LINEAR B IDEOGRAM B154",
"LINEAR B MONOGRAM B156 TURO2",
"LINEAR B IDEOGRAM B157",
"LINEAR B IDEOGRAM B158",
"LINEAR B IDEOGRAM B159 CLOTH",
"LINEAR B IDEOGRAM B160",
"LINEAR B IDEOGRAM B161",
"LINEAR B IDEOGRAM B162 GARMENT",
"LINEAR B IDEOGRAM B163 ARMOUR",
"LINEAR B IDEOGRAM B164",
"LINEAR B IDEOGRAM B165",
"LINEAR B IDEOGRAM B166",
"LINEAR B IDEOGRAM B167",
"LINEAR B IDEOGRAM B168",
"LINEAR B IDEOGRAM B169",
"LINEAR B IDEOGRAM B170",
"LINEAR B IDEOGRAM B171",
"LINEAR B IDEOGRAM B172",
"LINEAR B IDEOGRAM B173 MONTH",
"LINEAR B IDEOGRAM B174",
"LINEAR B IDEOGRAM B176 TREE",
"LINEAR B IDEOGRAM B177",
"LINEAR B IDEOGRAM B178",
"LINEAR B IDEOGRAM B179",
"LINEAR B IDEOGRAM B180",
"LINEAR B IDEOGRAM B181",
"LINEAR B IDEOGRAM B182",
"LINEAR B IDEOGRAM B183",
"LINEAR B IDEOGRAM B184",
"LINEAR B IDEOGRAM B185",
"LINEAR B IDEOGRAM B189",
"LINEAR B IDEOGRAM B190",
"LINEAR B IDEOGRAM B191 HELMET",
"LINEAR B IDEOGRAM B220 FOOTSTOOL",
"LINEAR B IDEOGRAM B225 BATHTUB",
"LINEAR B IDEOGRAM B230 SPEAR",
"LINEAR B IDEOGRAM B231 ARROW",
"LINEAR B IDEOGRAM B232",
"LINEAR B IDEOGRAM B233 SWORD",
"LINEAR B IDEOGRAM B234",
"LINEAR B IDEOGRAM B236",
"LINEAR B IDEOGRAM B240 WHEELED CHARIOT",
"LINEAR B IDEOGRAM B241 CHARIOT",
"LINEAR B IDEOGRAM B242 CHARIOT FRAME",
"LINEAR B IDEOGRAM B243 WHEEL",
"LINEAR B IDEOGRAM B245",
"LINEAR B IDEOGRAM B246",
"LINEAR B MONOGRAM B247 DIPTE",
"LINEAR B IDEOGRAM B248",
"LINEAR B IDEOGRAM B249",
"LINEAR B IDEOGRAM B251",
"LINEAR B IDEOGRAM B252",
"LINEAR B IDEOGRAM B253",
"LINEAR B IDEOGRAM B254 DART",
"LINEAR B IDEOGRAM B255",
"LINEAR B IDEOGRAM B256",
"LINEAR B IDEOGRAM B257",
"LINEAR B IDEOGRAM B258",
"LINEAR B IDEOGRAM B259",
"LINEAR B IDEOGRAM VESSEL B155",
"LINEAR B IDEOGRAM VESSEL B200",
"LINEAR B IDEOGRAM VESSEL B201",
"LINEAR B IDEOGRAM VESSEL B202",
"LINEAR B IDEOGRAM VESSEL B203",
"LINEAR B IDEOGRAM VESSEL B204",
"LINEAR B IDEOGRAM VESSEL B205",
"LINEAR B IDEOGRAM VESSEL B206",
"LINEAR B IDEOGRAM VESSEL B207",
"LINEAR B IDEOGRAM VESSEL B208",
"LINEAR B IDEOGRAM VESSEL B209",
"LINEAR B IDEOGRAM VESSEL B210",
"LINEAR B IDEOGRAM VESSEL B211",
"LINEAR B IDEOGRAM VESSEL B212",
"LINEAR B IDEOGRAM VESSEL B213",
"LINEAR B IDEOGRAM VESSEL B214",
"LINEAR B IDEOGRAM VESSEL B215",
"LINEAR B IDEOGRAM VESSEL B216",
"LINEAR B IDEOGRAM VESSEL B217",
"LINEAR B IDEOGRAM VESSEL B218",
"LINEAR B IDEOGRAM VESSEL B219",
"LINEAR B IDEOGRAM VESSEL B221",
"LINEAR B IDEOGRAM VESSEL B222",
"LINEAR B IDEOGRAM VESSEL B226",
"LINEAR B IDEOGRAM VESSEL B227",
"LINEAR B IDEOGRAM VESSEL B228",
"LINEAR B IDEOGRAM VESSEL B229",
"LINEAR B IDEOGRAM VESSEL B250",
"LINEAR B IDEOGRAM VESSEL B305",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0101[256] =
{
"AEGEAN WORD SEPARATOR LINE",
"AEGEAN WORD SEPARATOR DOT",
"AEGEAN CHECK MARK",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"AEGEAN NUMBER ONE",
"AEGEAN NUMBER TWO",
"AEGEAN NUMBER THREE",
"AEGEAN NUMBER FOUR",
"AEGEAN NUMBER FIVE",
"AEGEAN NUMBER SIX",
"AEGEAN NUMBER SEVEN",
"AEGEAN NUMBER EIGHT",
"AEGEAN NUMBER NINE",
"AEGEAN NUMBER TEN",
"AEGEAN NUMBER TWENTY",
"AEGEAN NUMBER THIRTY",
"AEGEAN NUMBER FORTY",
"AEGEAN NUMBER FIFTY",
"AEGEAN NUMBER SIXTY",
"AEGEAN NUMBER SEVENTY",
"AEGEAN NUMBER EIGHTY",
"AEGEAN NUMBER NINETY",
"AEGEAN NUMBER ONE HUNDRED",
"AEGEAN NUMBER TWO HUNDRED",
"AEGEAN NUMBER THREE HUNDRED",
"AEGEAN NUMBER FOUR HUNDRED",
"AEGEAN NUMBER FIVE HUNDRED",
"AEGEAN NUMBER SIX HUNDRED",
"AEGEAN NUMBER SEVEN HUNDRED",
"AEGEAN NUMBER EIGHT HUNDRED",
"AEGEAN NUMBER NINE HUNDRED",
"AEGEAN NUMBER ONE THOUSAND",
"AEGEAN NUMBER TWO THOUSAND",
"AEGEAN NUMBER THREE THOUSAND",
"AEGEAN NUMBER FOUR THOUSAND",
"AEGEAN NUMBER FIVE THOUSAND",
"AEGEAN NUMBER SIX THOUSAND",
"AEGEAN NUMBER SEVEN THOUSAND",
"AEGEAN NUMBER EIGHT THOUSAND",
"AEGEAN NUMBER NINE THOUSAND",
"AEGEAN NUMBER TEN THOUSAND",
"AEGEAN NUMBER TWENTY THOUSAND",
"AEGEAN NUMBER THIRTY THOUSAND",
"AEGEAN NUMBER FORTY THOUSAND",
"AEGEAN NUMBER FIFTY THOUSAND",
"AEGEAN NUMBER SIXTY THOUSAND",
"AEGEAN NUMBER SEVENTY THOUSAND",
"AEGEAN NUMBER EIGHTY THOUSAND",
"AEGEAN NUMBER NINETY THOUSAND",
name_reserved,
name_reserved,
name_reserved,
"AEGEAN WEIGHT BASE UNIT",
"AEGEAN WEIGHT FIRST SUBUNIT",
"AEGEAN WEIGHT SECOND SUBUNIT",
"AEGEAN WEIGHT THIRD SUBUNIT",
"AEGEAN WEIGHT FOURTH SUBUNIT",
"AEGEAN DRY MEASURE FIRST SUBUNIT",
"AEGEAN LIQUID MEASURE FIRST SUBUNIT",
"AEGEAN MEASURE SECOND SUBUNIT",
"AEGEAN MEASURE THIRD SUBUNIT",
"GREEK ACROPHONIC ATTIC ONE QUARTER",
"GREEK ACROPHONIC ATTIC ONE HALF",
"GREEK ACROPHONIC ATTIC ONE DRACHMA",
"GREEK ACROPHONIC ATTIC FIVE",
"GREEK ACROPHONIC ATTIC FIFTY",
"GREEK ACROPHONIC ATTIC FIVE HUNDRED",
"GREEK ACROPHONIC ATTIC FIVE THOUSAND",
"GREEK ACROPHONIC ATTIC FIFTY THOUSAND",
"GREEK ACROPHONIC ATTIC FIVE TALENTS",
"GREEK ACROPHONIC ATTIC TEN TALENTS",
"GREEK ACROPHONIC ATTIC FIFTY TALENTS",
"GREEK ACROPHONIC ATTIC ONE HUNDRED TALENTS",
"GREEK ACROPHONIC ATTIC FIVE HUNDRED TALENTS",
"GREEK ACROPHONIC ATTIC ONE THOUSAND TALENTS",
"GREEK ACROPHONIC ATTIC FIVE THOUSAND TALENTS",
"GREEK ACROPHONIC ATTIC FIVE STATERS",
"GREEK ACROPHONIC ATTIC TEN STATERS",
"GREEK ACROPHONIC ATTIC FIFTY STATERS",
"GREEK ACROPHONIC ATTIC ONE HUNDRED STATERS",
"GREEK ACROPHONIC ATTIC FIVE HUNDRED STATERS",
"GREEK ACROPHONIC ATTIC ONE THOUSAND STATERS",
"GREEK ACROPHONIC ATTIC TEN THOUSAND STATERS",
"GREEK ACROPHONIC ATTIC FIFTY THOUSAND STATERS",
"GREEK ACROPHONIC ATTIC TEN MNAS",
"GREEK ACROPHONIC HERAEUM ONE PLETHRON",
"GREEK ACROPHONIC THESPIAN ONE",
"GREEK ACROPHONIC HERMIONIAN ONE",
"GREEK ACROPHONIC EPIDAUREAN TWO",
"GREEK ACROPHONIC THESPIAN TWO",
"GREEK ACROPHONIC CYRENAIC TWO DRACHMAS",
"GREEK ACROPHONIC EPIDAUREAN TWO DRACHMAS",
"GREEK ACROPHONIC TROEZENIAN FIVE",
"GREEK ACROPHONIC TROEZENIAN TEN",
"GREEK ACROPHONIC TROEZENIAN TEN ALTERNATE FORM",
"GREEK ACROPHONIC HERMIONIAN TEN",
"GREEK ACROPHONIC MESSENIAN TEN",
"GREEK ACROPHONIC THESPIAN TEN",
"GREEK ACROPHONIC THESPIAN THIRTY",
"GREEK ACROPHONIC TROEZENIAN FIFTY",
"GREEK ACROPHONIC TROEZENIAN FIFTY ALTERNATE FORM",
"GREEK ACROPHONIC HERMIONIAN FIFTY",
"GREEK ACROPHONIC THESPIAN FIFTY",
"GREEK ACROPHONIC THESPIAN ONE HUNDRED",
"GREEK ACROPHONIC THESPIAN THREE HUNDRED",
"GREEK ACROPHONIC EPIDAUREAN FIVE HUNDRED",
"GREEK ACROPHONIC TROEZENIAN FIVE HUNDRED",
"GREEK ACROPHONIC THESPIAN FIVE HUNDRED",
"GREEK ACROPHONIC CARYSTIAN FIVE HUNDRED",
"GREEK ACROPHONIC NAXIAN FIVE HUNDRED",
"GREEK ACROPHONIC THESPIAN ONE THOUSAND",
"GREEK ACROPHONIC THESPIAN FIVE THOUSAND",
"GREEK ACROPHONIC DELPHIC FIVE MNAS",
"GREEK ACROPHONIC STRATIAN FIFTY MNAS",
"GREEK ONE HALF SIGN",
"GREEK ONE HALF SIGN ALTERNATE FORM",
"GREEK TWO THIRDS SIGN",
"GREEK THREE QUARTERS SIGN",
"GREEK YEAR SIGN",
"GREEK TALENT SIGN",
"GREEK DRACHMA SIGN",
"GREEK OBOL SIGN",
"GREEK TWO OBOLS SIGN",
"GREEK THREE OBOLS SIGN",
"GREEK FOUR OBOLS SIGN",
"GREEK FIVE OBOLS SIGN",
"GREEK METRETES SIGN",
"GREEK KYATHOS BASE SIGN",
"GREEK LITRA SIGN",
"GREEK OUNKIA SIGN",
"GREEK XESTES SIGN",
"GREEK ARTABE SIGN",
"GREEK AROURA SIGN",
"GREEK GRAMMA SIGN",
"GREEK TRYBLION BASE SIGN",
"GREEK ZERO SIGN",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0103[256] =
{
"OLD ITALIC LETTER A",
"OLD ITALIC LETTER BE",
"OLD ITALIC LETTER KE",
"OLD ITALIC LETTER DE",
"OLD ITALIC LETTER E",
"OLD ITALIC LETTER VE",
"OLD ITALIC LETTER ZE",
"OLD ITALIC LETTER HE",
"OLD ITALIC LETTER THE",
"OLD ITALIC LETTER I",
"OLD ITALIC LETTER KA",
"OLD ITALIC LETTER EL",
"OLD ITALIC LETTER EM",
"OLD ITALIC LETTER EN",
"OLD ITALIC LETTER ESH",
"OLD ITALIC LETTER O",
"OLD ITALIC LETTER PE",
"OLD ITALIC LETTER SHE",
"OLD ITALIC LETTER KU",
"OLD ITALIC LETTER ER",
"OLD ITALIC LETTER ES",
"OLD ITALIC LETTER TE",
"OLD ITALIC LETTER U",
"OLD ITALIC LETTER EKS",
"OLD ITALIC LETTER PHE",
"OLD ITALIC LETTER KHE",
"OLD ITALIC LETTER EF",
"OLD ITALIC LETTER ERS",
"OLD ITALIC LETTER CHE",
"OLD ITALIC LETTER II",
"OLD ITALIC LETTER UU",
name_reserved,
"OLD ITALIC NUMERAL ONE",
"OLD ITALIC NUMERAL FIVE",
"OLD ITALIC NUMERAL TEN",
"OLD ITALIC NUMERAL FIFTY",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"GOTHIC LETTER AHSA",
"GOTHIC LETTER BAIRKAN",
"GOTHIC LETTER GIBA",
"GOTHIC LETTER DAGS",
"GOTHIC LETTER AIHVUS",
"GOTHIC LETTER QAIRTHRA",
"GOTHIC LETTER IUJA",
"GOTHIC LETTER HAGL",
"GOTHIC LETTER THIUTH",
"GOTHIC LETTER EIS",
"GOTHIC LETTER KUSMA",
"GOTHIC LETTER LAGUS",
"GOTHIC LETTER MANNA",
"GOTHIC LETTER NAUTHS",
"GOTHIC LETTER JER",
"GOTHIC LETTER URUS",
"GOTHIC LETTER PAIRTHRA",
"GOTHIC LETTER NINETY",
"GOTHIC LETTER RAIDA",
"GOTHIC LETTER SAUIL",
"GOTHIC LETTER TEIWS",
"GOTHIC LETTER WINJA",
"GOTHIC LETTER FAIHU",
"GOTHIC LETTER IGGWS",
"GOTHIC LETTER HWAIR",
"GOTHIC LETTER OTHAL",
"GOTHIC LETTER NINE HUNDRED",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"UGARITIC LETTER ALPA",
"UGARITIC LETTER BETA",
"UGARITIC LETTER GAMLA",
"UGARITIC LETTER KHA",
"UGARITIC LETTER DELTA",
"UGARITIC LETTER HO",
"UGARITIC LETTER WO",
"UGARITIC LETTER ZETA",
"UGARITIC LETTER HOTA",
"UGARITIC LETTER TET",
"UGARITIC LETTER YOD",
"UGARITIC LETTER KAF",
"UGARITIC LETTER SHIN",
"UGARITIC LETTER LAMDA",
"UGARITIC LETTER MEM",
"UGARITIC LETTER DHAL",
"UGARITIC LETTER NUN",
"UGARITIC LETTER ZU",
"UGARITIC LETTER SAMKA",
"UGARITIC LETTER AIN",
"UGARITIC LETTER PU",
"UGARITIC LETTER SADE",
"UGARITIC LETTER QOPA",
"UGARITIC LETTER RASHA",
"UGARITIC LETTER THANNA",
"UGARITIC LETTER GHAIN",
"UGARITIC LETTER TO",
"UGARITIC LETTER I",
"UGARITIC LETTER U",
"UGARITIC LETTER SSU",
name_reserved,
"UGARITIC WORD DIVIDER",
"OLD PERSIAN SIGN A",
"OLD PERSIAN SIGN I",
"OLD PERSIAN SIGN U",
"OLD PERSIAN SIGN KA",
"OLD PERSIAN SIGN KU",
"OLD PERSIAN SIGN GA",
"OLD PERSIAN SIGN GU",
"OLD PERSIAN SIGN XA",
"OLD PERSIAN SIGN CA",
"OLD PERSIAN SIGN JA",
"OLD PERSIAN SIGN JI",
"OLD PERSIAN SIGN TA",
"OLD PERSIAN SIGN TU",
"OLD PERSIAN SIGN DA",
"OLD PERSIAN SIGN DI",
"OLD PERSIAN SIGN DU",
"OLD PERSIAN SIGN THA",
"OLD PERSIAN SIGN PA",
"OLD PERSIAN SIGN BA",
"OLD PERSIAN SIGN FA",
"OLD PERSIAN SIGN NA",
"OLD PERSIAN SIGN NU",
"OLD PERSIAN SIGN MA",
"OLD PERSIAN SIGN MI",
"OLD PERSIAN SIGN MU",
"OLD PERSIAN SIGN YA",
"OLD PERSIAN SIGN VA",
"OLD PERSIAN SIGN VI",
"OLD PERSIAN SIGN RA",
"OLD PERSIAN SIGN RU",
"OLD PERSIAN SIGN LA",
"OLD PERSIAN SIGN SA",
"OLD PERSIAN SIGN ZA",
"OLD PERSIAN SIGN SHA",
"OLD PERSIAN SIGN SSA",
"OLD PERSIAN SIGN HA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"OLD PERSIAN SIGN AURAMAZDAA",
"OLD PERSIAN SIGN AURAMAZDAA-2",
"OLD PERSIAN SIGN AURAMAZDAAHA",
"OLD PERSIAN SIGN XSHAAYATHIYA",
"OLD PERSIAN SIGN DAHYAAUSH",
"OLD PERSIAN SIGN DAHYAAUSH-2",
"OLD PERSIAN SIGN BAGA",
"OLD PERSIAN SIGN BUUMISH",
"OLD PERSIAN WORD DIVIDER",
"OLD PERSIAN NUMBER ONE",
"OLD PERSIAN NUMBER TWO",
"OLD PERSIAN NUMBER TEN",
"OLD PERSIAN NUMBER TWENTY",
"OLD PERSIAN NUMBER HUNDRED",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0104[256] =
{
"DESERET CAPITAL LETTER LONG I",
"DESERET CAPITAL LETTER LONG E",
"DESERET CAPITAL LETTER LONG A",
"DESERET CAPITAL LETTER LONG AH",
"DESERET CAPITAL LETTER LONG O",
"DESERET CAPITAL LETTER LONG OO",
"DESERET CAPITAL LETTER SHORT I",
"DESERET CAPITAL LETTER SHORT E",
"DESERET CAPITAL LETTER SHORT A",
"DESERET CAPITAL LETTER SHORT AH",
"DESERET CAPITAL LETTER SHORT O",
"DESERET CAPITAL LETTER SHORT OO",
"DESERET CAPITAL LETTER AY",
"DESERET CAPITAL LETTER OW",
"DESERET CAPITAL LETTER WU",
"DESERET CAPITAL LETTER YEE",
"DESERET CAPITAL LETTER H",
"DESERET CAPITAL LETTER PEE",
"DESERET CAPITAL LETTER BEE",
"DESERET CAPITAL LETTER TEE",
"DESERET CAPITAL LETTER DEE",
"DESERET CAPITAL LETTER CHEE",
"DESERET CAPITAL LETTER JEE",
"DESERET CAPITAL LETTER KAY",
"DESERET CAPITAL LETTER GAY",
"DESERET CAPITAL LETTER EF",
"DESERET CAPITAL LETTER VEE",
"DESERET CAPITAL LETTER ETH",
"DESERET CAPITAL LETTER THEE",
"DESERET CAPITAL LETTER ES",
"DESERET CAPITAL LETTER ZEE",
"DESERET CAPITAL LETTER ESH",
"DESERET CAPITAL LETTER ZHEE",
"DESERET CAPITAL LETTER ER",
"DESERET CAPITAL LETTER EL",
"DESERET CAPITAL LETTER EM",
"DESERET CAPITAL LETTER EN",
"DESERET CAPITAL LETTER ENG",
"DESERET CAPITAL LETTER OI",
"DESERET CAPITAL LETTER EW",
"DESERET SMALL LETTER LONG I",
"DESERET SMALL LETTER LONG E",
"DESERET SMALL LETTER LONG A",
"DESERET SMALL LETTER LONG AH",
"DESERET SMALL LETTER LONG O",
"DESERET SMALL LETTER LONG OO",
"DESERET SMALL LETTER SHORT I",
"DESERET SMALL LETTER SHORT E",
"DESERET SMALL LETTER SHORT A",
"DESERET SMALL LETTER SHORT AH",
"DESERET SMALL LETTER SHORT O",
"DESERET SMALL LETTER SHORT OO",
"DESERET SMALL LETTER AY",
"DESERET SMALL LETTER OW",
"DESERET SMALL LETTER WU",
"DESERET SMALL LETTER YEE",
"DESERET SMALL LETTER H",
"DESERET SMALL LETTER PEE",
"DESERET SMALL LETTER BEE",
"DESERET SMALL LETTER TEE",
"DESERET SMALL LETTER DEE",
"DESERET SMALL LETTER CHEE",
"DESERET SMALL LETTER JEE",
"DESERET SMALL LETTER KAY",
"DESERET SMALL LETTER GAY",
"DESERET SMALL LETTER EF",
"DESERET SMALL LETTER VEE",
"DESERET SMALL LETTER ETH",
"DESERET SMALL LETTER THEE",
"DESERET SMALL LETTER ES",
"DESERET SMALL LETTER ZEE",
"DESERET SMALL LETTER ESH",
"DESERET SMALL LETTER ZHEE",
"DESERET SMALL LETTER ER",
"DESERET SMALL LETTER EL",
"DESERET SMALL LETTER EM",
"DESERET SMALL LETTER EN",
"DESERET SMALL LETTER ENG",
"DESERET SMALL LETTER OI",
"DESERET SMALL LETTER EW",
"SHAVIAN LETTER PEEP",
"SHAVIAN LETTER TOT",
"SHAVIAN LETTER KICK",
"SHAVIAN LETTER FEE",
"SHAVIAN LETTER THIGH",
"SHAVIAN LETTER SO",
"SHAVIAN LETTER SURE",
"SHAVIAN LETTER CHURCH",
"SHAVIAN LETTER YEA",
"SHAVIAN LETTER HUNG",
"SHAVIAN LETTER BIB",
"SHAVIAN LETTER DEAD",
"SHAVIAN LETTER GAG",
"SHAVIAN LETTER VOW",
"SHAVIAN LETTER THEY",
"SHAVIAN LETTER ZOO",
"SHAVIAN LETTER MEASURE",
"SHAVIAN LETTER JUDGE",
"SHAVIAN LETTER WOE",
"SHAVIAN LETTER HA-HA",
"SHAVIAN LETTER LOLL",
"SHAVIAN LETTER MIME",
"SHAVIAN LETTER IF",
"SHAVIAN LETTER EGG",
"SHAVIAN LETTER ASH",
"SHAVIAN LETTER ADO",
"SHAVIAN LETTER ON",
"SHAVIAN LETTER WOOL",
"SHAVIAN LETTER OUT",
"SHAVIAN LETTER AH",
"SHAVIAN LETTER ROAR",
"SHAVIAN LETTER NUN",
"SHAVIAN LETTER EAT",
"SHAVIAN LETTER AGE",
"SHAVIAN LETTER ICE",
"SHAVIAN LETTER UP",
"SHAVIAN LETTER OAK",
"SHAVIAN LETTER OOZE",
"SHAVIAN LETTER OIL",
"SHAVIAN LETTER AWE",
"SHAVIAN LETTER ARE",
"SHAVIAN LETTER OR",
"SHAVIAN LETTER AIR",
"SHAVIAN LETTER ERR",
"SHAVIAN LETTER ARRAY",
"SHAVIAN LETTER EAR",
"SHAVIAN LETTER IAN",
"SHAVIAN LETTER YEW",
"OSMANYA LETTER ALEF",
"OSMANYA LETTER BA",
"OSMANYA LETTER TA",
"OSMANYA LETTER JA",
"OSMANYA LETTER XA",
"OSMANYA LETTER KHA",
"OSMANYA LETTER DEEL",
"OSMANYA LETTER RA",
"OSMANYA LETTER SA",
"OSMANYA LETTER SHIIN",
"OSMANYA LETTER DHA",
"OSMANYA LETTER CAYN",
"OSMANYA LETTER GA",
"OSMANYA LETTER FA",
"OSMANYA LETTER QAAF",
"OSMANYA LETTER KAAF",
"OSMANYA LETTER LAAN",
"OSMANYA LETTER MIIN",
"OSMANYA LETTER NUUN",
"OSMANYA LETTER WAW",
"OSMANYA LETTER HA",
"OSMANYA LETTER YA",
"OSMANYA LETTER A",
"OSMANYA LETTER E",
"OSMANYA LETTER I",
"OSMANYA LETTER O",
"OSMANYA LETTER U",
"OSMANYA LETTER AA",
"OSMANYA LETTER EE",
"OSMANYA LETTER OO",
name_reserved,
name_reserved,
"OSMANYA DIGIT ZERO",
"OSMANYA DIGIT ONE",
"OSMANYA DIGIT TWO",
"OSMANYA DIGIT THREE",
"OSMANYA DIGIT FOUR",
"OSMANYA DIGIT FIVE",
"OSMANYA DIGIT SIX",
"OSMANYA DIGIT SEVEN",
"OSMANYA DIGIT EIGHT",
"OSMANYA DIGIT NINE",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0108[256] =
{
"CYPRIOT SYLLABLE A",
"CYPRIOT SYLLABLE E",
"CYPRIOT SYLLABLE I",
"CYPRIOT SYLLABLE O",
"CYPRIOT SYLLABLE U",
"CYPRIOT SYLLABLE JA",
name_reserved,
name_reserved,
"CYPRIOT SYLLABLE JO",
name_reserved,
"CYPRIOT SYLLABLE KA",
"CYPRIOT SYLLABLE KE",
"CYPRIOT SYLLABLE KI",
"CYPRIOT SYLLABLE KO",
"CYPRIOT SYLLABLE KU",
"CYPRIOT SYLLABLE LA",
"CYPRIOT SYLLABLE LE",
"CYPRIOT SYLLABLE LI",
"CYPRIOT SYLLABLE LO",
"CYPRIOT SYLLABLE LU",
"CYPRIOT SYLLABLE MA",
"CYPRIOT SYLLABLE ME",
"CYPRIOT SYLLABLE MI",
"CYPRIOT SYLLABLE MO",
"CYPRIOT SYLLABLE MU",
"CYPRIOT SYLLABLE NA",
"CYPRIOT SYLLABLE NE",
"CYPRIOT SYLLABLE NI",
"CYPRIOT SYLLABLE NO",
"CYPRIOT SYLLABLE NU",
"CYPRIOT SYLLABLE PA",
"CYPRIOT SYLLABLE PE",
"CYPRIOT SYLLABLE PI",
"CYPRIOT SYLLABLE PO",
"CYPRIOT SYLLABLE PU",
"CYPRIOT SYLLABLE RA",
"CYPRIOT SYLLABLE RE",
"CYPRIOT SYLLABLE RI",
"CYPRIOT SYLLABLE RO",
"CYPRIOT SYLLABLE RU",
"CYPRIOT SYLLABLE SA",
"CYPRIOT SYLLABLE SE",
"CYPRIOT SYLLABLE SI",
"CYPRIOT SYLLABLE SO",
"CYPRIOT SYLLABLE SU",
"CYPRIOT SYLLABLE TA",
"CYPRIOT SYLLABLE TE",
"CYPRIOT SYLLABLE TI",
"CYPRIOT SYLLABLE TO",
"CYPRIOT SYLLABLE TU",
"CYPRIOT SYLLABLE WA",
"CYPRIOT SYLLABLE WE",
"CYPRIOT SYLLABLE WI",
"CYPRIOT SYLLABLE WO",
name_reserved,
"CYPRIOT SYLLABLE XA",
"CYPRIOT SYLLABLE XE",
name_reserved,
name_reserved,
name_reserved,
"CYPRIOT SYLLABLE ZA",
name_reserved,
name_reserved,
"CYPRIOT SYLLABLE ZO",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_010a[256] =
{
"KHAROSHTHI LETTER A",
"KHAROSHTHI VOWEL SIGN I",
"KHAROSHTHI VOWEL SIGN U",
"KHAROSHTHI VOWEL SIGN VOCALIC R",
name_reserved,
"KHAROSHTHI VOWEL SIGN E",
"KHAROSHTHI VOWEL SIGN O",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KHAROSHTHI VOWEL LENGTH MARK",
"KHAROSHTHI SIGN DOUBLE RING BELOW",
"KHAROSHTHI SIGN ANUSVARA",
"KHAROSHTHI SIGN VISARGA",
"KHAROSHTHI LETTER KA",
"KHAROSHTHI LETTER KHA",
"KHAROSHTHI LETTER GA",
"KHAROSHTHI LETTER GHA",
name_reserved,
"KHAROSHTHI LETTER CA",
"KHAROSHTHI LETTER CHA",
"KHAROSHTHI LETTER JA",
name_reserved,
"KHAROSHTHI LETTER NYA",
"KHAROSHTHI LETTER TTA",
"KHAROSHTHI LETTER TTHA",
"KHAROSHTHI LETTER DDA",
"KHAROSHTHI LETTER DDHA",
"KHAROSHTHI LETTER NNA",
"KHAROSHTHI LETTER TA",
"KHAROSHTHI LETTER THA",
"KHAROSHTHI LETTER DA",
"KHAROSHTHI LETTER DHA",
"KHAROSHTHI LETTER NA",
"KHAROSHTHI LETTER PA",
"KHAROSHTHI LETTER PHA",
"KHAROSHTHI LETTER BA",
"KHAROSHTHI LETTER BHA",
"KHAROSHTHI LETTER MA",
"KHAROSHTHI LETTER YA",
"KHAROSHTHI LETTER RA",
"KHAROSHTHI LETTER LA",
"KHAROSHTHI LETTER VA",
"KHAROSHTHI LETTER SHA",
"KHAROSHTHI LETTER SSA",
"KHAROSHTHI LETTER SA",
"KHAROSHTHI LETTER ZA",
"KHAROSHTHI LETTER HA",
"KHAROSHTHI LETTER KKA",
"KHAROSHTHI LETTER TTTHA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KHAROSHTHI SIGN BAR ABOVE",
"KHAROSHTHI SIGN CAUDA",
"KHAROSHTHI SIGN DOT BELOW",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KHAROSHTHI VIRAMA",
"KHAROSHTHI DIGIT ONE",
"KHAROSHTHI DIGIT TWO",
"KHAROSHTHI DIGIT THREE",
"KHAROSHTHI DIGIT FOUR",
"KHAROSHTHI NUMBER TEN",
"KHAROSHTHI NUMBER TWENTY",
"KHAROSHTHI NUMBER ONE HUNDRED",
"KHAROSHTHI NUMBER ONE THOUSAND",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"KHAROSHTHI PUNCTUATION DOT",
"KHAROSHTHI PUNCTUATION SMALL CIRCLE",
"KHAROSHTHI PUNCTUATION CIRCLE",
"KHAROSHTHI PUNCTUATION CRESCENT BAR",
"KHAROSHTHI PUNCTUATION MANGALAM",
"KHAROSHTHI PUNCTUATION LOTUS",
"KHAROSHTHI PUNCTUATION DANDA",
"KHAROSHTHI PUNCTUATION DOUBLE DANDA",
"KHAROSHTHI PUNCTUATION LINES",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_01d0[256] =
{
"BYZANTINE MUSICAL SYMBOL PSILI",
"BYZANTINE MUSICAL SYMBOL DASEIA",
"BYZANTINE MUSICAL SYMBOL PERISPOMENI",
"BYZANTINE MUSICAL SYMBOL OXEIA EKFONITIKON",
"BYZANTINE MUSICAL SYMBOL OXEIA DIPLI",
"BYZANTINE MUSICAL SYMBOL VAREIA EKFONITIKON",
"BYZANTINE MUSICAL SYMBOL VAREIA DIPLI",
"BYZANTINE MUSICAL SYMBOL KATHISTI",
"BYZANTINE MUSICAL SYMBOL SYRMATIKI",
"BYZANTINE MUSICAL SYMBOL PARAKLITIKI",
"BYZANTINE MUSICAL SYMBOL YPOKRISIS",
"BYZANTINE MUSICAL SYMBOL YPOKRISIS DIPLI",
"BYZANTINE MUSICAL SYMBOL KREMASTI",
"BYZANTINE MUSICAL SYMBOL APESO EKFONITIKON",
"BYZANTINE MUSICAL SYMBOL EXO EKFONITIKON",
"BYZANTINE MUSICAL SYMBOL TELEIA",
"BYZANTINE MUSICAL SYMBOL KENTIMATA",
"BYZANTINE MUSICAL SYMBOL APOSTROFOS",
"BYZANTINE MUSICAL SYMBOL APOSTROFOS DIPLI",
"BYZANTINE MUSICAL SYMBOL SYNEVMA",
"BYZANTINE MUSICAL SYMBOL THITA",
"BYZANTINE MUSICAL SYMBOL OLIGON ARCHAION",
"BYZANTINE MUSICAL SYMBOL GORGON ARCHAION",
"BYZANTINE MUSICAL SYMBOL PSILON",
"BYZANTINE MUSICAL SYMBOL CHAMILON",
"BYZANTINE MUSICAL SYMBOL VATHY",
"BYZANTINE MUSICAL SYMBOL ISON ARCHAION",
"BYZANTINE MUSICAL SYMBOL KENTIMA ARCHAION",
"BYZANTINE MUSICAL SYMBOL KENTIMATA ARCHAION",
"BYZANTINE MUSICAL SYMBOL SAXIMATA",
"BYZANTINE MUSICAL SYMBOL PARICHON",
"BYZANTINE MUSICAL SYMBOL STAVROS APODEXIA",
"BYZANTINE MUSICAL SYMBOL OXEIAI ARCHAION",
"BYZANTINE MUSICAL SYMBOL VAREIAI ARCHAION",
"BYZANTINE MUSICAL SYMBOL APODERMA ARCHAION",
"BYZANTINE MUSICAL SYMBOL APOTHEMA",
"BYZANTINE MUSICAL SYMBOL KLASMA",
"BYZANTINE MUSICAL SYMBOL REVMA",
"BYZANTINE MUSICAL SYMBOL PIASMA ARCHAION",
"BYZANTINE MUSICAL SYMBOL TINAGMA",
"BYZANTINE MUSICAL SYMBOL ANATRICHISMA",
"BYZANTINE MUSICAL SYMBOL SEISMA",
"BYZANTINE MUSICAL SYMBOL SYNAGMA ARCHAION",
"BYZANTINE MUSICAL SYMBOL SYNAGMA META STAVROU",
"BYZANTINE MUSICAL SYMBOL OYRANISMA ARCHAION",
"BYZANTINE MUSICAL SYMBOL THEMA",
"BYZANTINE MUSICAL SYMBOL LEMOI",
"BYZANTINE MUSICAL SYMBOL DYO",
"BYZANTINE MUSICAL SYMBOL TRIA",
"BYZANTINE MUSICAL SYMBOL TESSERA",
"BYZANTINE MUSICAL SYMBOL KRATIMATA",
"BYZANTINE MUSICAL SYMBOL APESO EXO NEO",
"BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION",
"BYZANTINE MUSICAL SYMBOL IMIFTHORA",
"BYZANTINE MUSICAL SYMBOL TROMIKON ARCHAION",
"BYZANTINE MUSICAL SYMBOL KATAVA TROMIKON",
"BYZANTINE MUSICAL SYMBOL PELASTON",
"BYZANTINE MUSICAL SYMBOL PSIFISTON",
"BYZANTINE MUSICAL SYMBOL KONTEVMA",
"BYZANTINE MUSICAL SYMBOL CHOREVMA ARCHAION",
"BYZANTINE MUSICAL SYMBOL RAPISMA",
"BYZANTINE MUSICAL SYMBOL PARAKALESMA ARCHAION",
"BYZANTINE MUSICAL SYMBOL PARAKLITIKI ARCHAION",
"BYZANTINE MUSICAL SYMBOL ICHADIN",
"BYZANTINE MUSICAL SYMBOL NANA",
"BYZANTINE MUSICAL SYMBOL PETASMA",
"BYZANTINE MUSICAL SYMBOL KONTEVMA ALLO",
"BYZANTINE MUSICAL SYMBOL TROMIKON ALLO",
"BYZANTINE MUSICAL SYMBOL STRAGGISMATA",
"BYZANTINE MUSICAL SYMBOL GRONTHISMATA",
"BYZANTINE MUSICAL SYMBOL ISON NEO",
"BYZANTINE MUSICAL SYMBOL OLIGON NEO",
"BYZANTINE MUSICAL SYMBOL OXEIA NEO",
"BYZANTINE MUSICAL SYMBOL PETASTI",
"BYZANTINE MUSICAL SYMBOL KOUFISMA",
"BYZANTINE MUSICAL SYMBOL PETASTOKOUFISMA",
"BYZANTINE MUSICAL SYMBOL KRATIMOKOUFISMA",
"BYZANTINE MUSICAL SYMBOL PELASTON NEO",
"BYZANTINE MUSICAL SYMBOL KENTIMATA NEO ANO",
"BYZANTINE MUSICAL SYMBOL KENTIMA NEO ANO",
"BYZANTINE MUSICAL SYMBOL YPSILI",
"BYZANTINE MUSICAL SYMBOL APOSTROFOS NEO",
"BYZANTINE MUSICAL SYMBOL APOSTROFOI SYNDESMOS NEO",
"BYZANTINE MUSICAL SYMBOL YPORROI",
"BYZANTINE MUSICAL SYMBOL KRATIMOYPORROON",
"BYZANTINE MUSICAL SYMBOL ELAFRON",
"BYZANTINE MUSICAL SYMBOL CHAMILI",
"BYZANTINE MUSICAL SYMBOL MIKRON ISON",
"BYZANTINE MUSICAL SYMBOL VAREIA NEO",
"BYZANTINE MUSICAL SYMBOL PIASMA NEO",
"BYZANTINE MUSICAL SYMBOL PSIFISTON NEO",
"BYZANTINE MUSICAL SYMBOL OMALON",
"BYZANTINE MUSICAL SYMBOL ANTIKENOMA",
"BYZANTINE MUSICAL SYMBOL LYGISMA",
"BYZANTINE MUSICAL SYMBOL PARAKLITIKI NEO",
"BYZANTINE MUSICAL SYMBOL PARAKALESMA NEO",
"BYZANTINE MUSICAL SYMBOL ETERON PARAKALESMA",
"BYZANTINE MUSICAL SYMBOL KYLISMA",
"BYZANTINE MUSICAL SYMBOL ANTIKENOKYLISMA",
"BYZANTINE MUSICAL SYMBOL TROMIKON NEO",
"BYZANTINE MUSICAL SYMBOL EKSTREPTON",
"BYZANTINE MUSICAL SYMBOL SYNAGMA NEO",
"BYZANTINE MUSICAL SYMBOL SYRMA",
"BYZANTINE MUSICAL SYMBOL CHOREVMA NEO",
"BYZANTINE MUSICAL SYMBOL EPEGERMA",
"BYZANTINE MUSICAL SYMBOL SEISMA NEO",
"BYZANTINE MUSICAL SYMBOL XIRON KLASMA",
"BYZANTINE MUSICAL SYMBOL TROMIKOPSIFISTON",
"BYZANTINE MUSICAL SYMBOL PSIFISTOLYGISMA",
"BYZANTINE MUSICAL SYMBOL TROMIKOLYGISMA",
"BYZANTINE MUSICAL SYMBOL TROMIKOPARAKALESMA",
"BYZANTINE MUSICAL SYMBOL PSIFISTOPARAKALESMA",
"BYZANTINE MUSICAL SYMBOL TROMIKOSYNAGMA",
"BYZANTINE MUSICAL SYMBOL PSIFISTOSYNAGMA",
"BYZANTINE MUSICAL SYMBOL GORGOSYNTHETON",
"BYZANTINE MUSICAL SYMBOL ARGOSYNTHETON",
"BYZANTINE MUSICAL SYMBOL ETERON ARGOSYNTHETON",
"BYZANTINE MUSICAL SYMBOL OYRANISMA NEO",
"BYZANTINE MUSICAL SYMBOL THEMATISMOS ESO",
"BYZANTINE MUSICAL SYMBOL THEMATISMOS EXO",
"BYZANTINE MUSICAL SYMBOL THEMA APLOUN",
"BYZANTINE MUSICAL SYMBOL THES KAI APOTHES",
"BYZANTINE MUSICAL SYMBOL KATAVASMA",
"BYZANTINE MUSICAL SYMBOL ENDOFONON",
"BYZANTINE MUSICAL SYMBOL YFEN KATO",
"BYZANTINE MUSICAL SYMBOL YFEN ANO",
"BYZANTINE MUSICAL SYMBOL STAVROS",
"BYZANTINE MUSICAL SYMBOL KLASMA ANO",
"BYZANTINE MUSICAL SYMBOL DIPLI ARCHAION",
"BYZANTINE MUSICAL SYMBOL KRATIMA ARCHAION",
"BYZANTINE MUSICAL SYMBOL KRATIMA ALLO",
"BYZANTINE MUSICAL SYMBOL KRATIMA NEO",
"BYZANTINE MUSICAL SYMBOL APODERMA NEO",
"BYZANTINE MUSICAL SYMBOL APLI",
"BYZANTINE MUSICAL SYMBOL DIPLI",
"BYZANTINE MUSICAL SYMBOL TRIPLI",
"BYZANTINE MUSICAL SYMBOL TETRAPLI",
"BYZANTINE MUSICAL SYMBOL KORONIS",
"BYZANTINE MUSICAL SYMBOL LEIMMA ENOS CHRONOU",
"BYZANTINE MUSICAL SYMBOL LEIMMA DYO CHRONON",
"BYZANTINE MUSICAL SYMBOL LEIMMA TRION CHRONON",
"BYZANTINE MUSICAL SYMBOL LEIMMA TESSARON CHRONON",
"BYZANTINE MUSICAL SYMBOL LEIMMA IMISEOS CHRONOU",
"BYZANTINE MUSICAL SYMBOL GORGON NEO ANO",
"BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON ARISTERA",
"BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON DEXIA",
"BYZANTINE MUSICAL SYMBOL DIGORGON",
"BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA KATO",
"BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA ANO",
"BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON DEXIA",
"BYZANTINE MUSICAL SYMBOL TRIGORGON",
"BYZANTINE MUSICAL SYMBOL ARGON",
"BYZANTINE MUSICAL SYMBOL IMIDIARGON",
"BYZANTINE MUSICAL SYMBOL DIARGON",
"BYZANTINE MUSICAL SYMBOL AGOGI POLI ARGI",
"BYZANTINE MUSICAL SYMBOL AGOGI ARGOTERI",
"BYZANTINE MUSICAL SYMBOL AGOGI ARGI",
"BYZANTINE MUSICAL SYMBOL AGOGI METRIA",
"BYZANTINE MUSICAL SYMBOL AGOGI MESI",
"BYZANTINE MUSICAL SYMBOL AGOGI GORGI",
"BYZANTINE MUSICAL SYMBOL AGOGI GORGOTERI",
"BYZANTINE MUSICAL SYMBOL AGOGI POLI GORGI",
"BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI PROTOS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA DEYTEROS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI DEYTEROS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA TRITOS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA TRIFONIAS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS LEGETOS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA LEGETOS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS ICHOS",
"BYZANTINE MUSICAL SYMBOL ISAKIA TELOUS ICHIMATOS",
"BYZANTINE MUSICAL SYMBOL APOSTROFOI TELOUS ICHIMATOS",
"BYZANTINE MUSICAL SYMBOL FANEROSIS TETRAFONIAS",
"BYZANTINE MUSICAL SYMBOL FANEROSIS MONOFONIAS",
"BYZANTINE MUSICAL SYMBOL FANEROSIS DIFONIAS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA VARYS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOVARYS ICHOS",
"BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS TETARTOS ICHOS",
"BYZANTINE MUSICAL SYMBOL GORTHMIKON N APLOUN",
"BYZANTINE MUSICAL SYMBOL GORTHMIKON N DIPLOUN",
"BYZANTINE MUSICAL SYMBOL ENARXIS KAI FTHORA VOU",
"BYZANTINE MUSICAL SYMBOL IMIFONON",
"BYZANTINE MUSICAL SYMBOL IMIFTHORON",
"BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION DEYTEROU ICHOU",
"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI PA",
"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NANA",
"BYZANTINE MUSICAL SYMBOL FTHORA NAOS ICHOS",
"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI DI",
"BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON DIATONON DI",
"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI KE",
"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI ZO",
"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI KATO",
"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI ANO",
"BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA DIFONIAS",
"BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA MONOFONIAS",
"BYZANTINE MUSICAL SYMBOL FHTORA SKLIRON CHROMA VASIS",
"BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA SYNAFI",
"BYZANTINE MUSICAL SYMBOL FTHORA NENANO",
"BYZANTINE MUSICAL SYMBOL CHROA ZYGOS",
"BYZANTINE MUSICAL SYMBOL CHROA KLITON",
"BYZANTINE MUSICAL SYMBOL CHROA SPATHI",
"BYZANTINE MUSICAL SYMBOL FTHORA I YFESIS TETARTIMORION",
"BYZANTINE MUSICAL SYMBOL FTHORA ENARMONIOS ANTIFONIA",
"BYZANTINE MUSICAL SYMBOL YFESIS TRITIMORION",
"BYZANTINE MUSICAL SYMBOL DIESIS TRITIMORION",
"BYZANTINE MUSICAL SYMBOL DIESIS TETARTIMORION",
"BYZANTINE MUSICAL SYMBOL DIESIS APLI DYO DODEKATA",
"BYZANTINE MUSICAL SYMBOL DIESIS MONOGRAMMOS TESSERA DODEKATA",
"BYZANTINE MUSICAL SYMBOL DIESIS DIGRAMMOS EX DODEKATA",
"BYZANTINE MUSICAL SYMBOL DIESIS TRIGRAMMOS OKTO DODEKATA",
"BYZANTINE MUSICAL SYMBOL YFESIS APLI DYO DODEKATA",
"BYZANTINE MUSICAL SYMBOL YFESIS MONOGRAMMOS TESSERA DODEKATA",
"BYZANTINE MUSICAL SYMBOL YFESIS DIGRAMMOS EX DODEKATA",
"BYZANTINE MUSICAL SYMBOL YFESIS TRIGRAMMOS OKTO DODEKATA",
"BYZANTINE MUSICAL SYMBOL GENIKI DIESIS",
"BYZANTINE MUSICAL SYMBOL GENIKI YFESIS",
"BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MIKRI",
"BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MEGALI",
"BYZANTINE MUSICAL SYMBOL DIASTOLI DIPLI",
"BYZANTINE MUSICAL SYMBOL DIASTOLI THESEOS",
"BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS",
"BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS DISIMOU",
"BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TRISIMOU",
"BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TETRASIMOU",
"BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS",
"BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS DISIMOU",
"BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TRISIMOU",
"BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TETRASIMOU",
"BYZANTINE MUSICAL SYMBOL DIGRAMMA GG",
"BYZANTINE MUSICAL SYMBOL DIFTOGGOS OU",
"BYZANTINE MUSICAL SYMBOL STIGMA",
"BYZANTINE MUSICAL SYMBOL ARKTIKO PA",
"BYZANTINE MUSICAL SYMBOL ARKTIKO VOU",
"BYZANTINE MUSICAL SYMBOL ARKTIKO GA",
"BYZANTINE MUSICAL SYMBOL ARKTIKO DI",
"BYZANTINE MUSICAL SYMBOL ARKTIKO KE",
"BYZANTINE MUSICAL SYMBOL ARKTIKO ZO",
"BYZANTINE MUSICAL SYMBOL ARKTIKO NI",
"BYZANTINE MUSICAL SYMBOL KENTIMATA NEO MESO",
"BYZANTINE MUSICAL SYMBOL KENTIMA NEO MESO",
"BYZANTINE MUSICAL SYMBOL KENTIMATA NEO KATO",
"BYZANTINE MUSICAL SYMBOL KENTIMA NEO KATO",
"BYZANTINE MUSICAL SYMBOL KLASMA KATO",
"BYZANTINE MUSICAL SYMBOL GORGON NEO KATO",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_01d1[256] =
{
"MUSICAL SYMBOL SINGLE BARLINE",
"MUSICAL SYMBOL DOUBLE BARLINE",
"MUSICAL SYMBOL FINAL BARLINE",
"MUSICAL SYMBOL REVERSE FINAL BARLINE",
"MUSICAL SYMBOL DASHED BARLINE",
"MUSICAL SYMBOL SHORT BARLINE",
"MUSICAL SYMBOL LEFT REPEAT SIGN",
"MUSICAL SYMBOL RIGHT REPEAT SIGN",
"MUSICAL SYMBOL REPEAT DOTS",
"MUSICAL SYMBOL DAL SEGNO",
"MUSICAL SYMBOL DA CAPO",
"MUSICAL SYMBOL SEGNO",
"MUSICAL SYMBOL CODA",
"MUSICAL SYMBOL REPEATED FIGURE-1",
"MUSICAL SYMBOL REPEATED FIGURE-2",
"MUSICAL SYMBOL REPEATED FIGURE-3",
"MUSICAL SYMBOL FERMATA",
"MUSICAL SYMBOL FERMATA BELOW",
"MUSICAL SYMBOL BREATH MARK",
"MUSICAL SYMBOL CAESURA",
"MUSICAL SYMBOL BRACE",
"MUSICAL SYMBOL BRACKET",
"MUSICAL SYMBOL ONE-LINE STAFF",
"MUSICAL SYMBOL TWO-LINE STAFF",
"MUSICAL SYMBOL THREE-LINE STAFF",
"MUSICAL SYMBOL FOUR-LINE STAFF",
"MUSICAL SYMBOL FIVE-LINE STAFF",
"MUSICAL SYMBOL SIX-LINE STAFF",
"MUSICAL SYMBOL SIX-STRING FRETBOARD",
"MUSICAL SYMBOL FOUR-STRING FRETBOARD",
"MUSICAL SYMBOL G CLEF",
"MUSICAL SYMBOL G CLEF OTTAVA ALTA",
"MUSICAL SYMBOL G CLEF OTTAVA BASSA",
"MUSICAL SYMBOL C CLEF",
"MUSICAL SYMBOL F CLEF",
"MUSICAL SYMBOL F CLEF OTTAVA ALTA",
"MUSICAL SYMBOL F CLEF OTTAVA BASSA",
"MUSICAL SYMBOL DRUM CLEF-1",
"MUSICAL SYMBOL DRUM CLEF-2",
name_reserved,
name_reserved,
name_reserved,
"MUSICAL SYMBOL DOUBLE SHARP",
"MUSICAL SYMBOL DOUBLE FLAT",
"MUSICAL SYMBOL FLAT UP",
"MUSICAL SYMBOL FLAT DOWN",
"MUSICAL SYMBOL NATURAL UP",
"MUSICAL SYMBOL NATURAL DOWN",
"MUSICAL SYMBOL SHARP UP",
"MUSICAL SYMBOL SHARP DOWN",
"MUSICAL SYMBOL QUARTER TONE SHARP",
"MUSICAL SYMBOL QUARTER TONE FLAT",
"MUSICAL SYMBOL COMMON TIME",
"MUSICAL SYMBOL CUT TIME",
"MUSICAL SYMBOL OTTAVA ALTA",
"MUSICAL SYMBOL OTTAVA BASSA",
"MUSICAL SYMBOL QUINDICESIMA ALTA",
"MUSICAL SYMBOL QUINDICESIMA BASSA",
"MUSICAL SYMBOL MULTI REST",
"MUSICAL SYMBOL WHOLE REST",
"MUSICAL SYMBOL HALF REST",
"MUSICAL SYMBOL QUARTER REST",
"MUSICAL SYMBOL EIGHTH REST",
"MUSICAL SYMBOL SIXTEENTH REST",
"MUSICAL SYMBOL THIRTY-SECOND REST",
"MUSICAL SYMBOL SIXTY-FOURTH REST",
"MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH REST",
"MUSICAL SYMBOL X NOTEHEAD",
"MUSICAL SYMBOL PLUS NOTEHEAD",
"MUSICAL SYMBOL CIRCLE X NOTEHEAD",
"MUSICAL SYMBOL SQUARE NOTEHEAD WHITE",
"MUSICAL SYMBOL SQUARE NOTEHEAD BLACK",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD UP WHITE",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD UP BLACK",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT WHITE",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT BLACK",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT WHITE",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT BLACK",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN WHITE",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN BLACK",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT WHITE",
"MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT BLACK",
"MUSICAL SYMBOL MOON NOTEHEAD WHITE",
"MUSICAL SYMBOL MOON NOTEHEAD BLACK",
"MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN WHITE",
"MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN BLACK",
"MUSICAL SYMBOL PARENTHESIS NOTEHEAD",
"MUSICAL SYMBOL VOID NOTEHEAD",
"MUSICAL SYMBOL NOTEHEAD BLACK",
"MUSICAL SYMBOL NULL NOTEHEAD",
"MUSICAL SYMBOL CLUSTER NOTEHEAD WHITE",
"MUSICAL SYMBOL CLUSTER NOTEHEAD BLACK",
"MUSICAL SYMBOL BREVE",
"MUSICAL SYMBOL WHOLE NOTE",
"MUSICAL SYMBOL HALF NOTE",
"MUSICAL SYMBOL QUARTER NOTE",
"MUSICAL SYMBOL EIGHTH NOTE",
"MUSICAL SYMBOL SIXTEENTH NOTE",
"MUSICAL SYMBOL THIRTY-SECOND NOTE",
"MUSICAL SYMBOL SIXTY-FOURTH NOTE",
"MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE",
"MUSICAL SYMBOL COMBINING STEM",
"MUSICAL SYMBOL COMBINING SPRECHGESANG STEM",
"MUSICAL SYMBOL COMBINING TREMOLO-1",
"MUSICAL SYMBOL COMBINING TREMOLO-2",
"MUSICAL SYMBOL COMBINING TREMOLO-3",
"MUSICAL SYMBOL FINGERED TREMOLO-1",
"MUSICAL SYMBOL FINGERED TREMOLO-2",
"MUSICAL SYMBOL FINGERED TREMOLO-3",
"MUSICAL SYMBOL COMBINING AUGMENTATION DOT",
"MUSICAL SYMBOL COMBINING FLAG-1",
"MUSICAL SYMBOL COMBINING FLAG-2",
"MUSICAL SYMBOL COMBINING FLAG-3",
"MUSICAL SYMBOL COMBINING FLAG-4",
"MUSICAL SYMBOL COMBINING FLAG-5",
"MUSICAL SYMBOL BEGIN BEAM",
"MUSICAL SYMBOL END BEAM",
"MUSICAL SYMBOL BEGIN TIE",
"MUSICAL SYMBOL END TIE",
"MUSICAL SYMBOL BEGIN SLUR",
"MUSICAL SYMBOL END SLUR",
"MUSICAL SYMBOL BEGIN PHRASE",
"MUSICAL SYMBOL END PHRASE",
"MUSICAL SYMBOL COMBINING ACCENT",
"MUSICAL SYMBOL COMBINING STACCATO",
"MUSICAL SYMBOL COMBINING TENUTO",
"MUSICAL SYMBOL COMBINING STACCATISSIMO",
"MUSICAL SYMBOL COMBINING MARCATO",
"MUSICAL SYMBOL COMBINING MARCATO-STACCATO",
"MUSICAL SYMBOL COMBINING ACCENT-STACCATO",
"MUSICAL SYMBOL COMBINING LOURE",
"MUSICAL SYMBOL ARPEGGIATO UP",
"MUSICAL SYMBOL ARPEGGIATO DOWN",
"MUSICAL SYMBOL COMBINING DOIT",
"MUSICAL SYMBOL COMBINING RIP",
"MUSICAL SYMBOL COMBINING FLIP",
"MUSICAL SYMBOL COMBINING SMEAR",
"MUSICAL SYMBOL COMBINING BEND",
"MUSICAL SYMBOL COMBINING DOUBLE TONGUE",
"MUSICAL SYMBOL COMBINING TRIPLE TONGUE",
"MUSICAL SYMBOL RINFORZANDO",
"MUSICAL SYMBOL SUBITO",
"MUSICAL SYMBOL Z",
"MUSICAL SYMBOL PIANO",
"MUSICAL SYMBOL MEZZO",
"MUSICAL SYMBOL FORTE",
"MUSICAL SYMBOL CRESCENDO",
"MUSICAL SYMBOL DECRESCENDO",
"MUSICAL SYMBOL GRACE NOTE SLASH",
"MUSICAL SYMBOL GRACE NOTE NO SLASH",
"MUSICAL SYMBOL TR",
"MUSICAL SYMBOL TURN",
"MUSICAL SYMBOL INVERTED TURN",
"MUSICAL SYMBOL TURN SLASH",
"MUSICAL SYMBOL TURN UP",
"MUSICAL SYMBOL ORNAMENT STROKE-1",
"MUSICAL SYMBOL ORNAMENT STROKE-2",
"MUSICAL SYMBOL ORNAMENT STROKE-3",
"MUSICAL SYMBOL ORNAMENT STROKE-4",
"MUSICAL SYMBOL ORNAMENT STROKE-5",
"MUSICAL SYMBOL ORNAMENT STROKE-6",
"MUSICAL SYMBOL ORNAMENT STROKE-7",
"MUSICAL SYMBOL ORNAMENT STROKE-8",
"MUSICAL SYMBOL ORNAMENT STROKE-9",
"MUSICAL SYMBOL ORNAMENT STROKE-10",
"MUSICAL SYMBOL ORNAMENT STROKE-11",
"MUSICAL SYMBOL HAUPTSTIMME",
"MUSICAL SYMBOL NEBENSTIMME",
"MUSICAL SYMBOL END OF STIMME",
"MUSICAL SYMBOL DEGREE SLASH",
"MUSICAL SYMBOL COMBINING DOWN BOW",
"MUSICAL SYMBOL COMBINING UP BOW",
"MUSICAL SYMBOL COMBINING HARMONIC",
"MUSICAL SYMBOL COMBINING SNAP PIZZICATO",
"MUSICAL SYMBOL PEDAL MARK",
"MUSICAL SYMBOL PEDAL UP MARK",
"MUSICAL SYMBOL HALF PEDAL MARK",
"MUSICAL SYMBOL GLISSANDO UP",
"MUSICAL SYMBOL GLISSANDO DOWN",
"MUSICAL SYMBOL WITH FINGERNAILS",
"MUSICAL SYMBOL DAMP",
"MUSICAL SYMBOL DAMP ALL",
"MUSICAL SYMBOL MAXIMA",
"MUSICAL SYMBOL LONGA",
"MUSICAL SYMBOL BREVIS",
"MUSICAL SYMBOL SEMIBREVIS WHITE",
"MUSICAL SYMBOL SEMIBREVIS BLACK",
"MUSICAL SYMBOL MINIMA",
"MUSICAL SYMBOL MINIMA BLACK",
"MUSICAL SYMBOL SEMIMINIMA WHITE",
"MUSICAL SYMBOL SEMIMINIMA BLACK",
"MUSICAL SYMBOL FUSA WHITE",
"MUSICAL SYMBOL FUSA BLACK",
"MUSICAL SYMBOL LONGA PERFECTA REST",
"MUSICAL SYMBOL LONGA IMPERFECTA REST",
"MUSICAL SYMBOL BREVIS REST",
"MUSICAL SYMBOL SEMIBREVIS REST",
"MUSICAL SYMBOL MINIMA REST",
"MUSICAL SYMBOL SEMIMINIMA REST",
"MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA",
"MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE IMPERFECTA",
"MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA DIMINUTION-1",
"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE PERFECTA",
"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA",
"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-1",
"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-2",
"MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-3",
"MUSICAL SYMBOL CROIX",
"MUSICAL SYMBOL GREGORIAN C CLEF",
"MUSICAL SYMBOL GREGORIAN F CLEF",
"MUSICAL SYMBOL SQUARE B",
"MUSICAL SYMBOL VIRGA",
"MUSICAL SYMBOL PODATUS",
"MUSICAL SYMBOL CLIVIS",
"MUSICAL SYMBOL SCANDICUS",
"MUSICAL SYMBOL CLIMACUS",
"MUSICAL SYMBOL TORCULUS",
"MUSICAL SYMBOL PORRECTUS",
"MUSICAL SYMBOL PORRECTUS FLEXUS",
"MUSICAL SYMBOL SCANDICUS FLEXUS",
"MUSICAL SYMBOL TORCULUS RESUPINUS",
"MUSICAL SYMBOL PES SUBPUNCTIS",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_01d2[256] =
{
"GREEK VOCAL NOTATION SYMBOL-1",
"GREEK VOCAL NOTATION SYMBOL-2",
"GREEK VOCAL NOTATION SYMBOL-3",
"GREEK VOCAL NOTATION SYMBOL-4",
"GREEK VOCAL NOTATION SYMBOL-5",
"GREEK VOCAL NOTATION SYMBOL-6",
"GREEK VOCAL NOTATION SYMBOL-7",
"GREEK VOCAL NOTATION SYMBOL-8",
"GREEK VOCAL NOTATION SYMBOL-9",
"GREEK VOCAL NOTATION SYMBOL-10",
"GREEK VOCAL NOTATION SYMBOL-11",
"GREEK VOCAL NOTATION SYMBOL-12",
"GREEK VOCAL NOTATION SYMBOL-13",
"GREEK VOCAL NOTATION SYMBOL-14",
"GREEK VOCAL NOTATION SYMBOL-15",
"GREEK VOCAL NOTATION SYMBOL-16",
"GREEK VOCAL NOTATION SYMBOL-17",
"GREEK VOCAL NOTATION SYMBOL-18",
"GREEK VOCAL NOTATION SYMBOL-19",
"GREEK VOCAL NOTATION SYMBOL-20",
"GREEK VOCAL NOTATION SYMBOL-21",
"GREEK VOCAL NOTATION SYMBOL-22",
"GREEK VOCAL NOTATION SYMBOL-23",
"GREEK VOCAL NOTATION SYMBOL-24",
"GREEK VOCAL NOTATION SYMBOL-50",
"GREEK VOCAL NOTATION SYMBOL-51",
"GREEK VOCAL NOTATION SYMBOL-52",
"GREEK VOCAL NOTATION SYMBOL-53",
"GREEK VOCAL NOTATION SYMBOL-54",
"GREEK INSTRUMENTAL NOTATION SYMBOL-1",
"GREEK INSTRUMENTAL NOTATION SYMBOL-2",
"GREEK INSTRUMENTAL NOTATION SYMBOL-4",
"GREEK INSTRUMENTAL NOTATION SYMBOL-5",
"GREEK INSTRUMENTAL NOTATION SYMBOL-7",
"GREEK INSTRUMENTAL NOTATION SYMBOL-8",
"GREEK INSTRUMENTAL NOTATION SYMBOL-11",
"GREEK INSTRUMENTAL NOTATION SYMBOL-12",
"GREEK INSTRUMENTAL NOTATION SYMBOL-13",
"GREEK INSTRUMENTAL NOTATION SYMBOL-14",
"GREEK INSTRUMENTAL NOTATION SYMBOL-17",
"GREEK INSTRUMENTAL NOTATION SYMBOL-18",
"GREEK INSTRUMENTAL NOTATION SYMBOL-19",
"GREEK INSTRUMENTAL NOTATION SYMBOL-23",
"GREEK INSTRUMENTAL NOTATION SYMBOL-24",
"GREEK INSTRUMENTAL NOTATION SYMBOL-25",
"GREEK INSTRUMENTAL NOTATION SYMBOL-26",
"GREEK INSTRUMENTAL NOTATION SYMBOL-27",
"GREEK INSTRUMENTAL NOTATION SYMBOL-29",
"GREEK INSTRUMENTAL NOTATION SYMBOL-30",
"GREEK INSTRUMENTAL NOTATION SYMBOL-32",
"GREEK INSTRUMENTAL NOTATION SYMBOL-36",
"GREEK INSTRUMENTAL NOTATION SYMBOL-37",
"GREEK INSTRUMENTAL NOTATION SYMBOL-38",
"GREEK INSTRUMENTAL NOTATION SYMBOL-39",
"GREEK INSTRUMENTAL NOTATION SYMBOL-40",
"GREEK INSTRUMENTAL NOTATION SYMBOL-42",
"GREEK INSTRUMENTAL NOTATION SYMBOL-43",
"GREEK INSTRUMENTAL NOTATION SYMBOL-45",
"GREEK INSTRUMENTAL NOTATION SYMBOL-47",
"GREEK INSTRUMENTAL NOTATION SYMBOL-48",
"GREEK INSTRUMENTAL NOTATION SYMBOL-49",
"GREEK INSTRUMENTAL NOTATION SYMBOL-50",
"GREEK INSTRUMENTAL NOTATION SYMBOL-51",
"GREEK INSTRUMENTAL NOTATION SYMBOL-52",
"GREEK INSTRUMENTAL NOTATION SYMBOL-53",
"GREEK INSTRUMENTAL NOTATION SYMBOL-54",
"COMBINING GREEK MUSICAL TRISEME",
"COMBINING GREEK MUSICAL TETRASEME",
"COMBINING GREEK MUSICAL PENTASEME",
"GREEK MUSICAL LEIMMA",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_01d3[256] =
{
"MONOGRAM FOR EARTH",
"DIGRAM FOR HEAVENLY EARTH",
"DIGRAM FOR HUMAN EARTH",
"DIGRAM FOR EARTHLY HEAVEN",
"DIGRAM FOR EARTHLY HUMAN",
"DIGRAM FOR EARTH",
"TETRAGRAM FOR CENTRE",
"TETRAGRAM FOR FULL CIRCLE",
"TETRAGRAM FOR MIRED",
"TETRAGRAM FOR BARRIER",
"TETRAGRAM FOR KEEPING SMALL",
"TETRAGRAM FOR CONTRARIETY",
"TETRAGRAM FOR ASCENT",
"TETRAGRAM FOR OPPOSITION",
"TETRAGRAM FOR BRANCHING OUT",
"TETRAGRAM FOR DEFECTIVENESS OR DISTORTION",
"TETRAGRAM FOR DIVERGENCE",
"TETRAGRAM FOR YOUTHFULNESS",
"TETRAGRAM FOR INCREASE",
"TETRAGRAM FOR PENETRATION",
"TETRAGRAM FOR REACH",
"TETRAGRAM FOR CONTACT",
"TETRAGRAM FOR HOLDING BACK",
"TETRAGRAM FOR WAITING",
"TETRAGRAM FOR FOLLOWING",
"TETRAGRAM FOR ADVANCE",
"TETRAGRAM FOR RELEASE",
"TETRAGRAM FOR RESISTANCE",
"TETRAGRAM FOR EASE",
"TETRAGRAM FOR JOY",
"TETRAGRAM FOR CONTENTION",
"TETRAGRAM FOR ENDEAVOUR",
"TETRAGRAM FOR DUTIES",
"TETRAGRAM FOR CHANGE",
"TETRAGRAM FOR DECISIVENESS",
"TETRAGRAM FOR BOLD RESOLUTION",
"TETRAGRAM FOR PACKING",
"TETRAGRAM FOR LEGION",
"TETRAGRAM FOR CLOSENESS",
"TETRAGRAM FOR KINSHIP",
"TETRAGRAM FOR GATHERING",
"TETRAGRAM FOR STRENGTH",
"TETRAGRAM FOR PURITY",
"TETRAGRAM FOR FULLNESS",
"TETRAGRAM FOR RESIDENCE",
"TETRAGRAM FOR LAW OR MODEL",
"TETRAGRAM FOR RESPONSE",
"TETRAGRAM FOR GOING TO MEET",
"TETRAGRAM FOR ENCOUNTERS",
"TETRAGRAM FOR STOVE",
"TETRAGRAM FOR GREATNESS",
"TETRAGRAM FOR ENLARGEMENT",
"TETRAGRAM FOR PATTERN",
"TETRAGRAM FOR RITUAL",
"TETRAGRAM FOR FLIGHT",
"TETRAGRAM FOR VASTNESS OR WASTING",
"TETRAGRAM FOR CONSTANCY",
"TETRAGRAM FOR MEASURE",
"TETRAGRAM FOR ETERNITY",
"TETRAGRAM FOR UNITY",
"TETRAGRAM FOR DIMINISHMENT",
"TETRAGRAM FOR CLOSED MOUTH",
"TETRAGRAM FOR GUARDEDNESS",
"TETRAGRAM FOR GATHERING IN",
"TETRAGRAM FOR MASSING",
"TETRAGRAM FOR ACCUMULATION",
"TETRAGRAM FOR EMBELLISHMENT",
"TETRAGRAM FOR DOUBT",
"TETRAGRAM FOR WATCH",
"TETRAGRAM FOR SINKING",
"TETRAGRAM FOR INNER",
"TETRAGRAM FOR DEPARTURE",
"TETRAGRAM FOR DARKENING",
"TETRAGRAM FOR DIMMING",
"TETRAGRAM FOR EXHAUSTION",
"TETRAGRAM FOR SEVERANCE",
"TETRAGRAM FOR STOPPAGE",
"TETRAGRAM FOR HARDNESS",
"TETRAGRAM FOR COMPLETION",
"TETRAGRAM FOR CLOSURE",
"TETRAGRAM FOR FAILURE",
"TETRAGRAM FOR AGGRAVATION",
"TETRAGRAM FOR COMPLIANCE",
"TETRAGRAM FOR ON THE VERGE",
"TETRAGRAM FOR DIFFICULTIES",
"TETRAGRAM FOR LABOURING",
"TETRAGRAM FOR FOSTERING",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_01d4[256] =
{
"MATHEMATICAL BOLD CAPITAL A",
"MATHEMATICAL BOLD CAPITAL B",
"MATHEMATICAL BOLD CAPITAL C",
"MATHEMATICAL BOLD CAPITAL D",
"MATHEMATICAL BOLD CAPITAL E",
"MATHEMATICAL BOLD CAPITAL F",
"MATHEMATICAL BOLD CAPITAL G",
"MATHEMATICAL BOLD CAPITAL H",
"MATHEMATICAL BOLD CAPITAL I",
"MATHEMATICAL BOLD CAPITAL J",
"MATHEMATICAL BOLD CAPITAL K",
"MATHEMATICAL BOLD CAPITAL L",
"MATHEMATICAL BOLD CAPITAL M",
"MATHEMATICAL BOLD CAPITAL N",
"MATHEMATICAL BOLD CAPITAL O",
"MATHEMATICAL BOLD CAPITAL P",
"MATHEMATICAL BOLD CAPITAL Q",
"MATHEMATICAL BOLD CAPITAL R",
"MATHEMATICAL BOLD CAPITAL S",
"MATHEMATICAL BOLD CAPITAL T",
"MATHEMATICAL BOLD CAPITAL U",
"MATHEMATICAL BOLD CAPITAL V",
"MATHEMATICAL BOLD CAPITAL W",
"MATHEMATICAL BOLD CAPITAL X",
"MATHEMATICAL BOLD CAPITAL Y",
"MATHEMATICAL BOLD CAPITAL Z",
"MATHEMATICAL BOLD SMALL A",
"MATHEMATICAL BOLD SMALL B",
"MATHEMATICAL BOLD SMALL C",
"MATHEMATICAL BOLD SMALL D",
"MATHEMATICAL BOLD SMALL E",
"MATHEMATICAL BOLD SMALL F",
"MATHEMATICAL BOLD SMALL G",
"MATHEMATICAL BOLD SMALL H",
"MATHEMATICAL BOLD SMALL I",
"MATHEMATICAL BOLD SMALL J",
"MATHEMATICAL BOLD SMALL K",
"MATHEMATICAL BOLD SMALL L",
"MATHEMATICAL BOLD SMALL M",
"MATHEMATICAL BOLD SMALL N",
"MATHEMATICAL BOLD SMALL O",
"MATHEMATICAL BOLD SMALL P",
"MATHEMATICAL BOLD SMALL Q",
"MATHEMATICAL BOLD SMALL R",
"MATHEMATICAL BOLD SMALL S",
"MATHEMATICAL BOLD SMALL T",
"MATHEMATICAL BOLD SMALL U",
"MATHEMATICAL BOLD SMALL V",
"MATHEMATICAL BOLD SMALL W",
"MATHEMATICAL BOLD SMALL X",
"MATHEMATICAL BOLD SMALL Y",
"MATHEMATICAL BOLD SMALL Z",
"MATHEMATICAL ITALIC CAPITAL A",
"MATHEMATICAL ITALIC CAPITAL B",
"MATHEMATICAL ITALIC CAPITAL C",
"MATHEMATICAL ITALIC CAPITAL D",
"MATHEMATICAL ITALIC CAPITAL E",
"MATHEMATICAL ITALIC CAPITAL F",
"MATHEMATICAL ITALIC CAPITAL G",
"MATHEMATICAL ITALIC CAPITAL H",
"MATHEMATICAL ITALIC CAPITAL I",
"MATHEMATICAL ITALIC CAPITAL J",
"MATHEMATICAL ITALIC CAPITAL K",
"MATHEMATICAL ITALIC CAPITAL L",
"MATHEMATICAL ITALIC CAPITAL M",
"MATHEMATICAL ITALIC CAPITAL N",
"MATHEMATICAL ITALIC CAPITAL O",
"MATHEMATICAL ITALIC CAPITAL P",
"MATHEMATICAL ITALIC CAPITAL Q",
"MATHEMATICAL ITALIC CAPITAL R",
"MATHEMATICAL ITALIC CAPITAL S",
"MATHEMATICAL ITALIC CAPITAL T",
"MATHEMATICAL ITALIC CAPITAL U",
"MATHEMATICAL ITALIC CAPITAL V",
"MATHEMATICAL ITALIC CAPITAL W",
"MATHEMATICAL ITALIC CAPITAL X",
"MATHEMATICAL ITALIC CAPITAL Y",
"MATHEMATICAL ITALIC CAPITAL Z",
"MATHEMATICAL ITALIC SMALL A",
"MATHEMATICAL ITALIC SMALL B",
"MATHEMATICAL ITALIC SMALL C",
"MATHEMATICAL ITALIC SMALL D",
"MATHEMATICAL ITALIC SMALL E",
"MATHEMATICAL ITALIC SMALL F",
"MATHEMATICAL ITALIC SMALL G",
name_reserved,
"MATHEMATICAL ITALIC SMALL I",
"MATHEMATICAL ITALIC SMALL J",
"MATHEMATICAL ITALIC SMALL K",
"MATHEMATICAL ITALIC SMALL L",
"MATHEMATICAL ITALIC SMALL M",
"MATHEMATICAL ITALIC SMALL N",
"MATHEMATICAL ITALIC SMALL O",
"MATHEMATICAL ITALIC SMALL P",
"MATHEMATICAL ITALIC SMALL Q",
"MATHEMATICAL ITALIC SMALL R",
"MATHEMATICAL ITALIC SMALL S",
"MATHEMATICAL ITALIC SMALL T",
"MATHEMATICAL ITALIC SMALL U",
"MATHEMATICAL ITALIC SMALL V",
"MATHEMATICAL ITALIC SMALL W",
"MATHEMATICAL ITALIC SMALL X",
"MATHEMATICAL ITALIC SMALL Y",
"MATHEMATICAL ITALIC SMALL Z",
"MATHEMATICAL BOLD ITALIC CAPITAL A",
"MATHEMATICAL BOLD ITALIC CAPITAL B",
"MATHEMATICAL BOLD ITALIC CAPITAL C",
"MATHEMATICAL BOLD ITALIC CAPITAL D",
"MATHEMATICAL BOLD ITALIC CAPITAL E",
"MATHEMATICAL BOLD ITALIC CAPITAL F",
"MATHEMATICAL BOLD ITALIC CAPITAL G",
"MATHEMATICAL BOLD ITALIC CAPITAL H",
"MATHEMATICAL BOLD ITALIC CAPITAL I",
"MATHEMATICAL BOLD ITALIC CAPITAL J",
"MATHEMATICAL BOLD ITALIC CAPITAL K",
"MATHEMATICAL BOLD ITALIC CAPITAL L",
"MATHEMATICAL BOLD ITALIC CAPITAL M",
"MATHEMATICAL BOLD ITALIC CAPITAL N",
"MATHEMATICAL BOLD ITALIC CAPITAL O",
"MATHEMATICAL BOLD ITALIC CAPITAL P",
"MATHEMATICAL BOLD ITALIC CAPITAL Q",
"MATHEMATICAL BOLD ITALIC CAPITAL R",
"MATHEMATICAL BOLD ITALIC CAPITAL S",
"MATHEMATICAL BOLD ITALIC CAPITAL T",
"MATHEMATICAL BOLD ITALIC CAPITAL U",
"MATHEMATICAL BOLD ITALIC CAPITAL V",
"MATHEMATICAL BOLD ITALIC CAPITAL W",
"MATHEMATICAL BOLD ITALIC CAPITAL X",
"MATHEMATICAL BOLD ITALIC CAPITAL Y",
"MATHEMATICAL BOLD ITALIC CAPITAL Z",
"MATHEMATICAL BOLD ITALIC SMALL A",
"MATHEMATICAL BOLD ITALIC SMALL B",
"MATHEMATICAL BOLD ITALIC SMALL C",
"MATHEMATICAL BOLD ITALIC SMALL D",
"MATHEMATICAL BOLD ITALIC SMALL E",
"MATHEMATICAL BOLD ITALIC SMALL F",
"MATHEMATICAL BOLD ITALIC SMALL G",
"MATHEMATICAL BOLD ITALIC SMALL H",
"MATHEMATICAL BOLD ITALIC SMALL I",
"MATHEMATICAL BOLD ITALIC SMALL J",
"MATHEMATICAL BOLD ITALIC SMALL K",
"MATHEMATICAL BOLD ITALIC SMALL L",
"MATHEMATICAL BOLD ITALIC SMALL M",
"MATHEMATICAL BOLD ITALIC SMALL N",
"MATHEMATICAL BOLD ITALIC SMALL O",
"MATHEMATICAL BOLD ITALIC SMALL P",
"MATHEMATICAL BOLD ITALIC SMALL Q",
"MATHEMATICAL BOLD ITALIC SMALL R",
"MATHEMATICAL BOLD ITALIC SMALL S",
"MATHEMATICAL BOLD ITALIC SMALL T",
"MATHEMATICAL BOLD ITALIC SMALL U",
"MATHEMATICAL BOLD ITALIC SMALL V",
"MATHEMATICAL BOLD ITALIC SMALL W",
"MATHEMATICAL BOLD ITALIC SMALL X",
"MATHEMATICAL BOLD ITALIC SMALL Y",
"MATHEMATICAL BOLD ITALIC SMALL Z",
"MATHEMATICAL SCRIPT CAPITAL A",
name_reserved,
"MATHEMATICAL SCRIPT CAPITAL C",
"MATHEMATICAL SCRIPT CAPITAL D",
name_reserved,
name_reserved,
"MATHEMATICAL SCRIPT CAPITAL G",
name_reserved,
name_reserved,
"MATHEMATICAL SCRIPT CAPITAL J",
"MATHEMATICAL SCRIPT CAPITAL K",
name_reserved,
name_reserved,
"MATHEMATICAL SCRIPT CAPITAL N",
"MATHEMATICAL SCRIPT CAPITAL O",
"MATHEMATICAL SCRIPT CAPITAL P",
"MATHEMATICAL SCRIPT CAPITAL Q",
name_reserved,
"MATHEMATICAL SCRIPT CAPITAL S",
"MATHEMATICAL SCRIPT CAPITAL T",
"MATHEMATICAL SCRIPT CAPITAL U",
"MATHEMATICAL SCRIPT CAPITAL V",
"MATHEMATICAL SCRIPT CAPITAL W",
"MATHEMATICAL SCRIPT CAPITAL X",
"MATHEMATICAL SCRIPT CAPITAL Y",
"MATHEMATICAL SCRIPT CAPITAL Z",
"MATHEMATICAL SCRIPT SMALL A",
"MATHEMATICAL SCRIPT SMALL B",
"MATHEMATICAL SCRIPT SMALL C",
"MATHEMATICAL SCRIPT SMALL D",
name_reserved,
"MATHEMATICAL SCRIPT SMALL F",
name_reserved,
"MATHEMATICAL SCRIPT SMALL H",
"MATHEMATICAL SCRIPT SMALL I",
"MATHEMATICAL SCRIPT SMALL J",
"MATHEMATICAL SCRIPT SMALL K",
"MATHEMATICAL SCRIPT SMALL L",
"MATHEMATICAL SCRIPT SMALL M",
"MATHEMATICAL SCRIPT SMALL N",
name_reserved,
"MATHEMATICAL SCRIPT SMALL P",
"MATHEMATICAL SCRIPT SMALL Q",
"MATHEMATICAL SCRIPT SMALL R",
"MATHEMATICAL SCRIPT SMALL S",
"MATHEMATICAL SCRIPT SMALL T",
"MATHEMATICAL SCRIPT SMALL U",
"MATHEMATICAL SCRIPT SMALL V",
"MATHEMATICAL SCRIPT SMALL W",
"MATHEMATICAL SCRIPT SMALL X",
"MATHEMATICAL SCRIPT SMALL Y",
"MATHEMATICAL SCRIPT SMALL Z",
"MATHEMATICAL BOLD SCRIPT CAPITAL A",
"MATHEMATICAL BOLD SCRIPT CAPITAL B",
"MATHEMATICAL BOLD SCRIPT CAPITAL C",
"MATHEMATICAL BOLD SCRIPT CAPITAL D",
"MATHEMATICAL BOLD SCRIPT CAPITAL E",
"MATHEMATICAL BOLD SCRIPT CAPITAL F",
"MATHEMATICAL BOLD SCRIPT CAPITAL G",
"MATHEMATICAL BOLD SCRIPT CAPITAL H",
"MATHEMATICAL BOLD SCRIPT CAPITAL I",
"MATHEMATICAL BOLD SCRIPT CAPITAL J",
"MATHEMATICAL BOLD SCRIPT CAPITAL K",
"MATHEMATICAL BOLD SCRIPT CAPITAL L",
"MATHEMATICAL BOLD SCRIPT CAPITAL M",
"MATHEMATICAL BOLD SCRIPT CAPITAL N",
"MATHEMATICAL BOLD SCRIPT CAPITAL O",
"MATHEMATICAL BOLD SCRIPT CAPITAL P",
"MATHEMATICAL BOLD SCRIPT CAPITAL Q",
"MATHEMATICAL BOLD SCRIPT CAPITAL R",
"MATHEMATICAL BOLD SCRIPT CAPITAL S",
"MATHEMATICAL BOLD SCRIPT CAPITAL T",
"MATHEMATICAL BOLD SCRIPT CAPITAL U",
"MATHEMATICAL BOLD SCRIPT CAPITAL V",
"MATHEMATICAL BOLD SCRIPT CAPITAL W",
"MATHEMATICAL BOLD SCRIPT CAPITAL X",
"MATHEMATICAL BOLD SCRIPT CAPITAL Y",
"MATHEMATICAL BOLD SCRIPT CAPITAL Z",
"MATHEMATICAL BOLD SCRIPT SMALL A",
"MATHEMATICAL BOLD SCRIPT SMALL B",
"MATHEMATICAL BOLD SCRIPT SMALL C",
"MATHEMATICAL BOLD SCRIPT SMALL D",
"MATHEMATICAL BOLD SCRIPT SMALL E",
"MATHEMATICAL BOLD SCRIPT SMALL F",
"MATHEMATICAL BOLD SCRIPT SMALL G",
"MATHEMATICAL BOLD SCRIPT SMALL H",
"MATHEMATICAL BOLD SCRIPT SMALL I",
"MATHEMATICAL BOLD SCRIPT SMALL J",
"MATHEMATICAL BOLD SCRIPT SMALL K",
"MATHEMATICAL BOLD SCRIPT SMALL L",
"MATHEMATICAL BOLD SCRIPT SMALL M",
"MATHEMATICAL BOLD SCRIPT SMALL N",
"MATHEMATICAL BOLD SCRIPT SMALL O",
"MATHEMATICAL BOLD SCRIPT SMALL P",
"MATHEMATICAL BOLD SCRIPT SMALL Q",
"MATHEMATICAL BOLD SCRIPT SMALL R",
"MATHEMATICAL BOLD SCRIPT SMALL S",
"MATHEMATICAL BOLD SCRIPT SMALL T",
"MATHEMATICAL BOLD SCRIPT SMALL U",
"MATHEMATICAL BOLD SCRIPT SMALL V"};
static const char * name_01d5[256] =
{
"MATHEMATICAL BOLD SCRIPT SMALL W",
"MATHEMATICAL BOLD SCRIPT SMALL X",
"MATHEMATICAL BOLD SCRIPT SMALL Y",
"MATHEMATICAL BOLD SCRIPT SMALL Z",
"MATHEMATICAL FRAKTUR CAPITAL A",
"MATHEMATICAL FRAKTUR CAPITAL B",
name_reserved,
"MATHEMATICAL FRAKTUR CAPITAL D",
"MATHEMATICAL FRAKTUR CAPITAL E",
"MATHEMATICAL FRAKTUR CAPITAL F",
"MATHEMATICAL FRAKTUR CAPITAL G",
name_reserved,
name_reserved,
"MATHEMATICAL FRAKTUR CAPITAL J",
"MATHEMATICAL FRAKTUR CAPITAL K",
"MATHEMATICAL FRAKTUR CAPITAL L",
"MATHEMATICAL FRAKTUR CAPITAL M",
"MATHEMATICAL FRAKTUR CAPITAL N",
"MATHEMATICAL FRAKTUR CAPITAL O",
"MATHEMATICAL FRAKTUR CAPITAL P",
"MATHEMATICAL FRAKTUR CAPITAL Q",
name_reserved,
"MATHEMATICAL FRAKTUR CAPITAL S",
"MATHEMATICAL FRAKTUR CAPITAL T",
"MATHEMATICAL FRAKTUR CAPITAL U",
"MATHEMATICAL FRAKTUR CAPITAL V",
"MATHEMATICAL FRAKTUR CAPITAL W",
"MATHEMATICAL FRAKTUR CAPITAL X",
"MATHEMATICAL FRAKTUR CAPITAL Y",
name_reserved,
"MATHEMATICAL FRAKTUR SMALL A",
"MATHEMATICAL FRAKTUR SMALL B",
"MATHEMATICAL FRAKTUR SMALL C",
"MATHEMATICAL FRAKTUR SMALL D",
"MATHEMATICAL FRAKTUR SMALL E",
"MATHEMATICAL FRAKTUR SMALL F",
"MATHEMATICAL FRAKTUR SMALL G",
"MATHEMATICAL FRAKTUR SMALL H",
"MATHEMATICAL FRAKTUR SMALL I",
"MATHEMATICAL FRAKTUR SMALL J",
"MATHEMATICAL FRAKTUR SMALL K",
"MATHEMATICAL FRAKTUR SMALL L",
"MATHEMATICAL FRAKTUR SMALL M",
"MATHEMATICAL FRAKTUR SMALL N",
"MATHEMATICAL FRAKTUR SMALL O",
"MATHEMATICAL FRAKTUR SMALL P",
"MATHEMATICAL FRAKTUR SMALL Q",
"MATHEMATICAL FRAKTUR SMALL R",
"MATHEMATICAL FRAKTUR SMALL S",
"MATHEMATICAL FRAKTUR SMALL T",
"MATHEMATICAL FRAKTUR SMALL U",
"MATHEMATICAL FRAKTUR SMALL V",
"MATHEMATICAL FRAKTUR SMALL W",
"MATHEMATICAL FRAKTUR SMALL X",
"MATHEMATICAL FRAKTUR SMALL Y",
"MATHEMATICAL FRAKTUR SMALL Z",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL A",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL B",
name_reserved,
"MATHEMATICAL DOUBLE-STRUCK CAPITAL D",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL E",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL F",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL G",
name_reserved,
"MATHEMATICAL DOUBLE-STRUCK CAPITAL I",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL J",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL K",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL L",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL M",
name_reserved,
"MATHEMATICAL DOUBLE-STRUCK CAPITAL O",
name_reserved,
name_reserved,
name_reserved,
"MATHEMATICAL DOUBLE-STRUCK CAPITAL S",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL T",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL U",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL V",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL W",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL X",
"MATHEMATICAL DOUBLE-STRUCK CAPITAL Y",
name_reserved,
"MATHEMATICAL DOUBLE-STRUCK SMALL A",
"MATHEMATICAL DOUBLE-STRUCK SMALL B",
"MATHEMATICAL DOUBLE-STRUCK SMALL C",
"MATHEMATICAL DOUBLE-STRUCK SMALL D",
"MATHEMATICAL DOUBLE-STRUCK SMALL E",
"MATHEMATICAL DOUBLE-STRUCK SMALL F",
"MATHEMATICAL DOUBLE-STRUCK SMALL G",
"MATHEMATICAL DOUBLE-STRUCK SMALL H",
"MATHEMATICAL DOUBLE-STRUCK SMALL I",
"MATHEMATICAL DOUBLE-STRUCK SMALL J",
"MATHEMATICAL DOUBLE-STRUCK SMALL K",
"MATHEMATICAL DOUBLE-STRUCK SMALL L",
"MATHEMATICAL DOUBLE-STRUCK SMALL M",
"MATHEMATICAL DOUBLE-STRUCK SMALL N",
"MATHEMATICAL DOUBLE-STRUCK SMALL O",
"MATHEMATICAL DOUBLE-STRUCK SMALL P",
"MATHEMATICAL DOUBLE-STRUCK SMALL Q",
"MATHEMATICAL DOUBLE-STRUCK SMALL R",
"MATHEMATICAL DOUBLE-STRUCK SMALL S",
"MATHEMATICAL DOUBLE-STRUCK SMALL T",
"MATHEMATICAL DOUBLE-STRUCK SMALL U",
"MATHEMATICAL DOUBLE-STRUCK SMALL V",
"MATHEMATICAL DOUBLE-STRUCK SMALL W",
"MATHEMATICAL DOUBLE-STRUCK SMALL X",
"MATHEMATICAL DOUBLE-STRUCK SMALL Y",
"MATHEMATICAL DOUBLE-STRUCK SMALL Z",
"MATHEMATICAL BOLD FRAKTUR CAPITAL A",
"MATHEMATICAL BOLD FRAKTUR CAPITAL B",
"MATHEMATICAL BOLD FRAKTUR CAPITAL C",
"MATHEMATICAL BOLD FRAKTUR CAPITAL D",
"MATHEMATICAL BOLD FRAKTUR CAPITAL E",
"MATHEMATICAL BOLD FRAKTUR CAPITAL F",
"MATHEMATICAL BOLD FRAKTUR CAPITAL G",
"MATHEMATICAL BOLD FRAKTUR CAPITAL H",
"MATHEMATICAL BOLD FRAKTUR CAPITAL I",
"MATHEMATICAL BOLD FRAKTUR CAPITAL J",
"MATHEMATICAL BOLD FRAKTUR CAPITAL K",
"MATHEMATICAL BOLD FRAKTUR CAPITAL L",
"MATHEMATICAL BOLD FRAKTUR CAPITAL M",
"MATHEMATICAL BOLD FRAKTUR CAPITAL N",
"MATHEMATICAL BOLD FRAKTUR CAPITAL O",
"MATHEMATICAL BOLD FRAKTUR CAPITAL P",
"MATHEMATICAL BOLD FRAKTUR CAPITAL Q",
"MATHEMATICAL BOLD FRAKTUR CAPITAL R",
"MATHEMATICAL BOLD FRAKTUR CAPITAL S",
"MATHEMATICAL BOLD FRAKTUR CAPITAL T",
"MATHEMATICAL BOLD FRAKTUR CAPITAL U",
"MATHEMATICAL BOLD FRAKTUR CAPITAL V",
"MATHEMATICAL BOLD FRAKTUR CAPITAL W",
"MATHEMATICAL BOLD FRAKTUR CAPITAL X",
"MATHEMATICAL BOLD FRAKTUR CAPITAL Y",
"MATHEMATICAL BOLD FRAKTUR CAPITAL Z",
"MATHEMATICAL BOLD FRAKTUR SMALL A",
"MATHEMATICAL BOLD FRAKTUR SMALL B",
"MATHEMATICAL BOLD FRAKTUR SMALL C",
"MATHEMATICAL BOLD FRAKTUR SMALL D",
"MATHEMATICAL BOLD FRAKTUR SMALL E",
"MATHEMATICAL BOLD FRAKTUR SMALL F",
"MATHEMATICAL BOLD FRAKTUR SMALL G",
"MATHEMATICAL BOLD FRAKTUR SMALL H",
"MATHEMATICAL BOLD FRAKTUR SMALL I",
"MATHEMATICAL BOLD FRAKTUR SMALL J",
"MATHEMATICAL BOLD FRAKTUR SMALL K",
"MATHEMATICAL BOLD FRAKTUR SMALL L",
"MATHEMATICAL BOLD FRAKTUR SMALL M",
"MATHEMATICAL BOLD FRAKTUR SMALL N",
"MATHEMATICAL BOLD FRAKTUR SMALL O",
"MATHEMATICAL BOLD FRAKTUR SMALL P",
"MATHEMATICAL BOLD FRAKTUR SMALL Q",
"MATHEMATICAL BOLD FRAKTUR SMALL R",
"MATHEMATICAL BOLD FRAKTUR SMALL S",
"MATHEMATICAL BOLD FRAKTUR SMALL T",
"MATHEMATICAL BOLD FRAKTUR SMALL U",
"MATHEMATICAL BOLD FRAKTUR SMALL V",
"MATHEMATICAL BOLD FRAKTUR SMALL W",
"MATHEMATICAL BOLD FRAKTUR SMALL X",
"MATHEMATICAL BOLD FRAKTUR SMALL Y",
"MATHEMATICAL BOLD FRAKTUR SMALL Z",
"MATHEMATICAL SANS-SERIF CAPITAL A",
"MATHEMATICAL SANS-SERIF CAPITAL B",
"MATHEMATICAL SANS-SERIF CAPITAL C",
"MATHEMATICAL SANS-SERIF CAPITAL D",
"MATHEMATICAL SANS-SERIF CAPITAL E",
"MATHEMATICAL SANS-SERIF CAPITAL F",
"MATHEMATICAL SANS-SERIF CAPITAL G",
"MATHEMATICAL SANS-SERIF CAPITAL H",
"MATHEMATICAL SANS-SERIF CAPITAL I",
"MATHEMATICAL SANS-SERIF CAPITAL J",
"MATHEMATICAL SANS-SERIF CAPITAL K",
"MATHEMATICAL SANS-SERIF CAPITAL L",
"MATHEMATICAL SANS-SERIF CAPITAL M",
"MATHEMATICAL SANS-SERIF CAPITAL N",
"MATHEMATICAL SANS-SERIF CAPITAL O",
"MATHEMATICAL SANS-SERIF CAPITAL P",
"MATHEMATICAL SANS-SERIF CAPITAL Q",
"MATHEMATICAL SANS-SERIF CAPITAL R",
"MATHEMATICAL SANS-SERIF CAPITAL S",
"MATHEMATICAL SANS-SERIF CAPITAL T",
"MATHEMATICAL SANS-SERIF CAPITAL U",
"MATHEMATICAL SANS-SERIF CAPITAL V",
"MATHEMATICAL SANS-SERIF CAPITAL W",
"MATHEMATICAL SANS-SERIF CAPITAL X",
"MATHEMATICAL SANS-SERIF CAPITAL Y",
"MATHEMATICAL SANS-SERIF CAPITAL Z",
"MATHEMATICAL SANS-SERIF SMALL A",
"MATHEMATICAL SANS-SERIF SMALL B",
"MATHEMATICAL SANS-SERIF SMALL C",
"MATHEMATICAL SANS-SERIF SMALL D",
"MATHEMATICAL SANS-SERIF SMALL E",
"MATHEMATICAL SANS-SERIF SMALL F",
"MATHEMATICAL SANS-SERIF SMALL G",
"MATHEMATICAL SANS-SERIF SMALL H",
"MATHEMATICAL SANS-SERIF SMALL I",
"MATHEMATICAL SANS-SERIF SMALL J",
"MATHEMATICAL SANS-SERIF SMALL K",
"MATHEMATICAL SANS-SERIF SMALL L",
"MATHEMATICAL SANS-SERIF SMALL M",
"MATHEMATICAL SANS-SERIF SMALL N",
"MATHEMATICAL SANS-SERIF SMALL O",
"MATHEMATICAL SANS-SERIF SMALL P",
"MATHEMATICAL SANS-SERIF SMALL Q",
"MATHEMATICAL SANS-SERIF SMALL R",
"MATHEMATICAL SANS-SERIF SMALL S",
"MATHEMATICAL SANS-SERIF SMALL T",
"MATHEMATICAL SANS-SERIF SMALL U",
"MATHEMATICAL SANS-SERIF SMALL V",
"MATHEMATICAL SANS-SERIF SMALL W",
"MATHEMATICAL SANS-SERIF SMALL X",
"MATHEMATICAL SANS-SERIF SMALL Y",
"MATHEMATICAL SANS-SERIF SMALL Z",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL A",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL B",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL C",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL D",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL E",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL F",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL G",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL H",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL I",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL J",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL K",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL L",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL M",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL N",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL O",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL P",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL Q",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL R",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL S",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL T",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL U",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL V",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL W",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL X",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL Y",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL Z",
"MATHEMATICAL SANS-SERIF BOLD SMALL A",
"MATHEMATICAL SANS-SERIF BOLD SMALL B",
"MATHEMATICAL SANS-SERIF BOLD SMALL C",
"MATHEMATICAL SANS-SERIF BOLD SMALL D",
"MATHEMATICAL SANS-SERIF BOLD SMALL E",
"MATHEMATICAL SANS-SERIF BOLD SMALL F",
"MATHEMATICAL SANS-SERIF BOLD SMALL G",
"MATHEMATICAL SANS-SERIF BOLD SMALL H",
"MATHEMATICAL SANS-SERIF BOLD SMALL I",
"MATHEMATICAL SANS-SERIF BOLD SMALL J",
"MATHEMATICAL SANS-SERIF BOLD SMALL K",
"MATHEMATICAL SANS-SERIF BOLD SMALL L",
"MATHEMATICAL SANS-SERIF BOLD SMALL M",
"MATHEMATICAL SANS-SERIF BOLD SMALL N",
"MATHEMATICAL SANS-SERIF BOLD SMALL O",
"MATHEMATICAL SANS-SERIF BOLD SMALL P",
"MATHEMATICAL SANS-SERIF BOLD SMALL Q",
"MATHEMATICAL SANS-SERIF BOLD SMALL R"};
static const char * name_01d6[256] =
{
"MATHEMATICAL SANS-SERIF BOLD SMALL S",
"MATHEMATICAL SANS-SERIF BOLD SMALL T",
"MATHEMATICAL SANS-SERIF BOLD SMALL U",
"MATHEMATICAL SANS-SERIF BOLD SMALL V",
"MATHEMATICAL SANS-SERIF BOLD SMALL W",
"MATHEMATICAL SANS-SERIF BOLD SMALL X",
"MATHEMATICAL SANS-SERIF BOLD SMALL Y",
"MATHEMATICAL SANS-SERIF BOLD SMALL Z",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL A",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL B",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL C",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL D",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL E",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL F",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL G",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL H",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL I",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL J",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL K",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL L",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL M",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL N",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL O",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL P",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL R",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL S",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL T",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL U",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL V",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL W",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL X",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y",
"MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z",
"MATHEMATICAL SANS-SERIF ITALIC SMALL A",
"MATHEMATICAL SANS-SERIF ITALIC SMALL B",
"MATHEMATICAL SANS-SERIF ITALIC SMALL C",
"MATHEMATICAL SANS-SERIF ITALIC SMALL D",
"MATHEMATICAL SANS-SERIF ITALIC SMALL E",
"MATHEMATICAL SANS-SERIF ITALIC SMALL F",
"MATHEMATICAL SANS-SERIF ITALIC SMALL G",
"MATHEMATICAL SANS-SERIF ITALIC SMALL H",
"MATHEMATICAL SANS-SERIF ITALIC SMALL I",
"MATHEMATICAL SANS-SERIF ITALIC SMALL J",
"MATHEMATICAL SANS-SERIF ITALIC SMALL K",
"MATHEMATICAL SANS-SERIF ITALIC SMALL L",
"MATHEMATICAL SANS-SERIF ITALIC SMALL M",
"MATHEMATICAL SANS-SERIF ITALIC SMALL N",
"MATHEMATICAL SANS-SERIF ITALIC SMALL O",
"MATHEMATICAL SANS-SERIF ITALIC SMALL P",
"MATHEMATICAL SANS-SERIF ITALIC SMALL Q",
"MATHEMATICAL SANS-SERIF ITALIC SMALL R",
"MATHEMATICAL SANS-SERIF ITALIC SMALL S",
"MATHEMATICAL SANS-SERIF ITALIC SMALL T",
"MATHEMATICAL SANS-SERIF ITALIC SMALL U",
"MATHEMATICAL SANS-SERIF ITALIC SMALL V",
"MATHEMATICAL SANS-SERIF ITALIC SMALL W",
"MATHEMATICAL SANS-SERIF ITALIC SMALL X",
"MATHEMATICAL SANS-SERIF ITALIC SMALL Y",
"MATHEMATICAL SANS-SERIF ITALIC SMALL Z",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z",
"MATHEMATICAL MONOSPACE CAPITAL A",
"MATHEMATICAL MONOSPACE CAPITAL B",
"MATHEMATICAL MONOSPACE CAPITAL C",
"MATHEMATICAL MONOSPACE CAPITAL D",
"MATHEMATICAL MONOSPACE CAPITAL E",
"MATHEMATICAL MONOSPACE CAPITAL F",
"MATHEMATICAL MONOSPACE CAPITAL G",
"MATHEMATICAL MONOSPACE CAPITAL H",
"MATHEMATICAL MONOSPACE CAPITAL I",
"MATHEMATICAL MONOSPACE CAPITAL J",
"MATHEMATICAL MONOSPACE CAPITAL K",
"MATHEMATICAL MONOSPACE CAPITAL L",
"MATHEMATICAL MONOSPACE CAPITAL M",
"MATHEMATICAL MONOSPACE CAPITAL N",
"MATHEMATICAL MONOSPACE CAPITAL O",
"MATHEMATICAL MONOSPACE CAPITAL P",
"MATHEMATICAL MONOSPACE CAPITAL Q",
"MATHEMATICAL MONOSPACE CAPITAL R",
"MATHEMATICAL MONOSPACE CAPITAL S",
"MATHEMATICAL MONOSPACE CAPITAL T",
"MATHEMATICAL MONOSPACE CAPITAL U",
"MATHEMATICAL MONOSPACE CAPITAL V",
"MATHEMATICAL MONOSPACE CAPITAL W",
"MATHEMATICAL MONOSPACE CAPITAL X",
"MATHEMATICAL MONOSPACE CAPITAL Y",
"MATHEMATICAL MONOSPACE CAPITAL Z",
"MATHEMATICAL MONOSPACE SMALL A",
"MATHEMATICAL MONOSPACE SMALL B",
"MATHEMATICAL MONOSPACE SMALL C",
"MATHEMATICAL MONOSPACE SMALL D",
"MATHEMATICAL MONOSPACE SMALL E",
"MATHEMATICAL MONOSPACE SMALL F",
"MATHEMATICAL MONOSPACE SMALL G",
"MATHEMATICAL MONOSPACE SMALL H",
"MATHEMATICAL MONOSPACE SMALL I",
"MATHEMATICAL MONOSPACE SMALL J",
"MATHEMATICAL MONOSPACE SMALL K",
"MATHEMATICAL MONOSPACE SMALL L",
"MATHEMATICAL MONOSPACE SMALL M",
"MATHEMATICAL MONOSPACE SMALL N",
"MATHEMATICAL MONOSPACE SMALL O",
"MATHEMATICAL MONOSPACE SMALL P",
"MATHEMATICAL MONOSPACE SMALL Q",
"MATHEMATICAL MONOSPACE SMALL R",
"MATHEMATICAL MONOSPACE SMALL S",
"MATHEMATICAL MONOSPACE SMALL T",
"MATHEMATICAL MONOSPACE SMALL U",
"MATHEMATICAL MONOSPACE SMALL V",
"MATHEMATICAL MONOSPACE SMALL W",
"MATHEMATICAL MONOSPACE SMALL X",
"MATHEMATICAL MONOSPACE SMALL Y",
"MATHEMATICAL MONOSPACE SMALL Z",
"MATHEMATICAL ITALIC SMALL DOTLESS I",
"MATHEMATICAL ITALIC SMALL DOTLESS J",
name_reserved,
name_reserved,
"MATHEMATICAL BOLD CAPITAL ALPHA",
"MATHEMATICAL BOLD CAPITAL BETA",
"MATHEMATICAL BOLD CAPITAL GAMMA",
"MATHEMATICAL BOLD CAPITAL DELTA",
"MATHEMATICAL BOLD CAPITAL EPSILON",
"MATHEMATICAL BOLD CAPITAL ZETA",
"MATHEMATICAL BOLD CAPITAL ETA",
"MATHEMATICAL BOLD CAPITAL THETA",
"MATHEMATICAL BOLD CAPITAL IOTA",
"MATHEMATICAL BOLD CAPITAL KAPPA",
"MATHEMATICAL BOLD CAPITAL LAMDA",
"MATHEMATICAL BOLD CAPITAL MU",
"MATHEMATICAL BOLD CAPITAL NU",
"MATHEMATICAL BOLD CAPITAL XI",
"MATHEMATICAL BOLD CAPITAL OMICRON",
"MATHEMATICAL BOLD CAPITAL PI",
"MATHEMATICAL BOLD CAPITAL RHO",
"MATHEMATICAL BOLD CAPITAL THETA SYMBOL",
"MATHEMATICAL BOLD CAPITAL SIGMA",
"MATHEMATICAL BOLD CAPITAL TAU",
"MATHEMATICAL BOLD CAPITAL UPSILON",
"MATHEMATICAL BOLD CAPITAL PHI",
"MATHEMATICAL BOLD CAPITAL CHI",
"MATHEMATICAL BOLD CAPITAL PSI",
"MATHEMATICAL BOLD CAPITAL OMEGA",
"MATHEMATICAL BOLD NABLA",
"MATHEMATICAL BOLD SMALL ALPHA",
"MATHEMATICAL BOLD SMALL BETA",
"MATHEMATICAL BOLD SMALL GAMMA",
"MATHEMATICAL BOLD SMALL DELTA",
"MATHEMATICAL BOLD SMALL EPSILON",
"MATHEMATICAL BOLD SMALL ZETA",
"MATHEMATICAL BOLD SMALL ETA",
"MATHEMATICAL BOLD SMALL THETA",
"MATHEMATICAL BOLD SMALL IOTA",
"MATHEMATICAL BOLD SMALL KAPPA",
"MATHEMATICAL BOLD SMALL LAMDA",
"MATHEMATICAL BOLD SMALL MU",
"MATHEMATICAL BOLD SMALL NU",
"MATHEMATICAL BOLD SMALL XI",
"MATHEMATICAL BOLD SMALL OMICRON",
"MATHEMATICAL BOLD SMALL PI",
"MATHEMATICAL BOLD SMALL RHO",
"MATHEMATICAL BOLD SMALL FINAL SIGMA",
"MATHEMATICAL BOLD SMALL SIGMA",
"MATHEMATICAL BOLD SMALL TAU",
"MATHEMATICAL BOLD SMALL UPSILON",
"MATHEMATICAL BOLD SMALL PHI",
"MATHEMATICAL BOLD SMALL CHI",
"MATHEMATICAL BOLD SMALL PSI",
"MATHEMATICAL BOLD SMALL OMEGA",
"MATHEMATICAL BOLD PARTIAL DIFFERENTIAL",
"MATHEMATICAL BOLD EPSILON SYMBOL",
"MATHEMATICAL BOLD THETA SYMBOL",
"MATHEMATICAL BOLD KAPPA SYMBOL",
"MATHEMATICAL BOLD PHI SYMBOL",
"MATHEMATICAL BOLD RHO SYMBOL",
"MATHEMATICAL BOLD PI SYMBOL",
"MATHEMATICAL ITALIC CAPITAL ALPHA",
"MATHEMATICAL ITALIC CAPITAL BETA",
"MATHEMATICAL ITALIC CAPITAL GAMMA",
"MATHEMATICAL ITALIC CAPITAL DELTA",
"MATHEMATICAL ITALIC CAPITAL EPSILON",
"MATHEMATICAL ITALIC CAPITAL ZETA",
"MATHEMATICAL ITALIC CAPITAL ETA",
"MATHEMATICAL ITALIC CAPITAL THETA",
"MATHEMATICAL ITALIC CAPITAL IOTA",
"MATHEMATICAL ITALIC CAPITAL KAPPA",
"MATHEMATICAL ITALIC CAPITAL LAMDA",
"MATHEMATICAL ITALIC CAPITAL MU",
"MATHEMATICAL ITALIC CAPITAL NU",
"MATHEMATICAL ITALIC CAPITAL XI",
"MATHEMATICAL ITALIC CAPITAL OMICRON",
"MATHEMATICAL ITALIC CAPITAL PI",
"MATHEMATICAL ITALIC CAPITAL RHO",
"MATHEMATICAL ITALIC CAPITAL THETA SYMBOL",
"MATHEMATICAL ITALIC CAPITAL SIGMA",
"MATHEMATICAL ITALIC CAPITAL TAU",
"MATHEMATICAL ITALIC CAPITAL UPSILON",
"MATHEMATICAL ITALIC CAPITAL PHI",
"MATHEMATICAL ITALIC CAPITAL CHI",
"MATHEMATICAL ITALIC CAPITAL PSI",
"MATHEMATICAL ITALIC CAPITAL OMEGA",
"MATHEMATICAL ITALIC NABLA",
"MATHEMATICAL ITALIC SMALL ALPHA",
"MATHEMATICAL ITALIC SMALL BETA",
"MATHEMATICAL ITALIC SMALL GAMMA",
"MATHEMATICAL ITALIC SMALL DELTA"};
static const char * name_01d7[256] =
{
"MATHEMATICAL ITALIC SMALL EPSILON",
"MATHEMATICAL ITALIC SMALL ZETA",
"MATHEMATICAL ITALIC SMALL ETA",
"MATHEMATICAL ITALIC SMALL THETA",
"MATHEMATICAL ITALIC SMALL IOTA",
"MATHEMATICAL ITALIC SMALL KAPPA",
"MATHEMATICAL ITALIC SMALL LAMDA",
"MATHEMATICAL ITALIC SMALL MU",
"MATHEMATICAL ITALIC SMALL NU",
"MATHEMATICAL ITALIC SMALL XI",
"MATHEMATICAL ITALIC SMALL OMICRON",
"MATHEMATICAL ITALIC SMALL PI",
"MATHEMATICAL ITALIC SMALL RHO",
"MATHEMATICAL ITALIC SMALL FINAL SIGMA",
"MATHEMATICAL ITALIC SMALL SIGMA",
"MATHEMATICAL ITALIC SMALL TAU",
"MATHEMATICAL ITALIC SMALL UPSILON",
"MATHEMATICAL ITALIC SMALL PHI",
"MATHEMATICAL ITALIC SMALL CHI",
"MATHEMATICAL ITALIC SMALL PSI",
"MATHEMATICAL ITALIC SMALL OMEGA",
"MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL",
"MATHEMATICAL ITALIC EPSILON SYMBOL",
"MATHEMATICAL ITALIC THETA SYMBOL",
"MATHEMATICAL ITALIC KAPPA SYMBOL",
"MATHEMATICAL ITALIC PHI SYMBOL",
"MATHEMATICAL ITALIC RHO SYMBOL",
"MATHEMATICAL ITALIC PI SYMBOL",
"MATHEMATICAL BOLD ITALIC CAPITAL ALPHA",
"MATHEMATICAL BOLD ITALIC CAPITAL BETA",
"MATHEMATICAL BOLD ITALIC CAPITAL GAMMA",
"MATHEMATICAL BOLD ITALIC CAPITAL DELTA",
"MATHEMATICAL BOLD ITALIC CAPITAL EPSILON",
"MATHEMATICAL BOLD ITALIC CAPITAL ZETA",
"MATHEMATICAL BOLD ITALIC CAPITAL ETA",
"MATHEMATICAL BOLD ITALIC CAPITAL THETA",
"MATHEMATICAL BOLD ITALIC CAPITAL IOTA",
"MATHEMATICAL BOLD ITALIC CAPITAL KAPPA",
"MATHEMATICAL BOLD ITALIC CAPITAL LAMDA",
"MATHEMATICAL BOLD ITALIC CAPITAL MU",
"MATHEMATICAL BOLD ITALIC CAPITAL NU",
"MATHEMATICAL BOLD ITALIC CAPITAL XI",
"MATHEMATICAL BOLD ITALIC CAPITAL OMICRON",
"MATHEMATICAL BOLD ITALIC CAPITAL PI",
"MATHEMATICAL BOLD ITALIC CAPITAL RHO",
"MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL",
"MATHEMATICAL BOLD ITALIC CAPITAL SIGMA",
"MATHEMATICAL BOLD ITALIC CAPITAL TAU",
"MATHEMATICAL BOLD ITALIC CAPITAL UPSILON",
"MATHEMATICAL BOLD ITALIC CAPITAL PHI",
"MATHEMATICAL BOLD ITALIC CAPITAL CHI",
"MATHEMATICAL BOLD ITALIC CAPITAL PSI",
"MATHEMATICAL BOLD ITALIC CAPITAL OMEGA",
"MATHEMATICAL BOLD ITALIC NABLA",
"MATHEMATICAL BOLD ITALIC SMALL ALPHA",
"MATHEMATICAL BOLD ITALIC SMALL BETA",
"MATHEMATICAL BOLD ITALIC SMALL GAMMA",
"MATHEMATICAL BOLD ITALIC SMALL DELTA",
"MATHEMATICAL BOLD ITALIC SMALL EPSILON",
"MATHEMATICAL BOLD ITALIC SMALL ZETA",
"MATHEMATICAL BOLD ITALIC SMALL ETA",
"MATHEMATICAL BOLD ITALIC SMALL THETA",
"MATHEMATICAL BOLD ITALIC SMALL IOTA",
"MATHEMATICAL BOLD ITALIC SMALL KAPPA",
"MATHEMATICAL BOLD ITALIC SMALL LAMDA",
"MATHEMATICAL BOLD ITALIC SMALL MU",
"MATHEMATICAL BOLD ITALIC SMALL NU",
"MATHEMATICAL BOLD ITALIC SMALL XI",
"MATHEMATICAL BOLD ITALIC SMALL OMICRON",
"MATHEMATICAL BOLD ITALIC SMALL PI",
"MATHEMATICAL BOLD ITALIC SMALL RHO",
"MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA",
"MATHEMATICAL BOLD ITALIC SMALL SIGMA",
"MATHEMATICAL BOLD ITALIC SMALL TAU",
"MATHEMATICAL BOLD ITALIC SMALL UPSILON",
"MATHEMATICAL BOLD ITALIC SMALL PHI",
"MATHEMATICAL BOLD ITALIC SMALL CHI",
"MATHEMATICAL BOLD ITALIC SMALL PSI",
"MATHEMATICAL BOLD ITALIC SMALL OMEGA",
"MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL",
"MATHEMATICAL BOLD ITALIC EPSILON SYMBOL",
"MATHEMATICAL BOLD ITALIC THETA SYMBOL",
"MATHEMATICAL BOLD ITALIC KAPPA SYMBOL",
"MATHEMATICAL BOLD ITALIC PHI SYMBOL",
"MATHEMATICAL BOLD ITALIC RHO SYMBOL",
"MATHEMATICAL BOLD ITALIC PI SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL MU",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL NU",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL XI",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL PI",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI",
"MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA",
"MATHEMATICAL SANS-SERIF BOLD NABLA",
"MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA",
"MATHEMATICAL SANS-SERIF BOLD SMALL BETA",
"MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA",
"MATHEMATICAL SANS-SERIF BOLD SMALL DELTA",
"MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON",
"MATHEMATICAL SANS-SERIF BOLD SMALL ZETA",
"MATHEMATICAL SANS-SERIF BOLD SMALL ETA",
"MATHEMATICAL SANS-SERIF BOLD SMALL THETA",
"MATHEMATICAL SANS-SERIF BOLD SMALL IOTA",
"MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA",
"MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA",
"MATHEMATICAL SANS-SERIF BOLD SMALL MU",
"MATHEMATICAL SANS-SERIF BOLD SMALL NU",
"MATHEMATICAL SANS-SERIF BOLD SMALL XI",
"MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON",
"MATHEMATICAL SANS-SERIF BOLD SMALL PI",
"MATHEMATICAL SANS-SERIF BOLD SMALL RHO",
"MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA",
"MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA",
"MATHEMATICAL SANS-SERIF BOLD SMALL TAU",
"MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON",
"MATHEMATICAL SANS-SERIF BOLD SMALL PHI",
"MATHEMATICAL SANS-SERIF BOLD SMALL CHI",
"MATHEMATICAL SANS-SERIF BOLD SMALL PSI",
"MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA",
"MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL",
"MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD PI SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI",
"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA",
"MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL",
"MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL",
"MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"MATHEMATICAL BOLD DIGIT ZERO",
"MATHEMATICAL BOLD DIGIT ONE",
"MATHEMATICAL BOLD DIGIT TWO",
"MATHEMATICAL BOLD DIGIT THREE",
"MATHEMATICAL BOLD DIGIT FOUR",
"MATHEMATICAL BOLD DIGIT FIVE",
"MATHEMATICAL BOLD DIGIT SIX",
"MATHEMATICAL BOLD DIGIT SEVEN",
"MATHEMATICAL BOLD DIGIT EIGHT",
"MATHEMATICAL BOLD DIGIT NINE",
"MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO",
"MATHEMATICAL DOUBLE-STRUCK DIGIT ONE",
"MATHEMATICAL DOUBLE-STRUCK DIGIT TWO",
"MATHEMATICAL DOUBLE-STRUCK DIGIT THREE",
"MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR",
"MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE",
"MATHEMATICAL DOUBLE-STRUCK DIGIT SIX",
"MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN",
"MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT",
"MATHEMATICAL DOUBLE-STRUCK DIGIT NINE",
"MATHEMATICAL SANS-SERIF DIGIT ZERO",
"MATHEMATICAL SANS-SERIF DIGIT ONE",
"MATHEMATICAL SANS-SERIF DIGIT TWO",
"MATHEMATICAL SANS-SERIF DIGIT THREE",
"MATHEMATICAL SANS-SERIF DIGIT FOUR",
"MATHEMATICAL SANS-SERIF DIGIT FIVE",
"MATHEMATICAL SANS-SERIF DIGIT SIX",
"MATHEMATICAL SANS-SERIF DIGIT SEVEN",
"MATHEMATICAL SANS-SERIF DIGIT EIGHT",
"MATHEMATICAL SANS-SERIF DIGIT NINE",
"MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO",
"MATHEMATICAL SANS-SERIF BOLD DIGIT ONE",
"MATHEMATICAL SANS-SERIF BOLD DIGIT TWO",
"MATHEMATICAL SANS-SERIF BOLD DIGIT THREE",
"MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR",
"MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE",
"MATHEMATICAL SANS-SERIF BOLD DIGIT SIX",
"MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN",
"MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT",
"MATHEMATICAL SANS-SERIF BOLD DIGIT NINE",
"MATHEMATICAL MONOSPACE DIGIT ZERO",
"MATHEMATICAL MONOSPACE DIGIT ONE",
"MATHEMATICAL MONOSPACE DIGIT TWO",
"MATHEMATICAL MONOSPACE DIGIT THREE",
"MATHEMATICAL MONOSPACE DIGIT FOUR",
"MATHEMATICAL MONOSPACE DIGIT FIVE",
"MATHEMATICAL MONOSPACE DIGIT SIX",
"MATHEMATICAL MONOSPACE DIGIT SEVEN",
"MATHEMATICAL MONOSPACE DIGIT EIGHT",
"MATHEMATICAL MONOSPACE DIGIT NINE"};
static const char * name_0200[256] =
{
"<CJK Ideograph Extension B, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_02a6[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<CJK Ideograph Extension B, Last>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_02f8[256] =
{
"CJK COMPATIBILITY IDEOGRAPH-2F800",
"CJK COMPATIBILITY IDEOGRAPH-2F801",
"CJK COMPATIBILITY IDEOGRAPH-2F802",
"CJK COMPATIBILITY IDEOGRAPH-2F803",
"CJK COMPATIBILITY IDEOGRAPH-2F804",
"CJK COMPATIBILITY IDEOGRAPH-2F805",
"CJK COMPATIBILITY IDEOGRAPH-2F806",
"CJK COMPATIBILITY IDEOGRAPH-2F807",
"CJK COMPATIBILITY IDEOGRAPH-2F808",
"CJK COMPATIBILITY IDEOGRAPH-2F809",
"CJK COMPATIBILITY IDEOGRAPH-2F80A",
"CJK COMPATIBILITY IDEOGRAPH-2F80B",
"CJK COMPATIBILITY IDEOGRAPH-2F80C",
"CJK COMPATIBILITY IDEOGRAPH-2F80D",
"CJK COMPATIBILITY IDEOGRAPH-2F80E",
"CJK COMPATIBILITY IDEOGRAPH-2F80F",
"CJK COMPATIBILITY IDEOGRAPH-2F810",
"CJK COMPATIBILITY IDEOGRAPH-2F811",
"CJK COMPATIBILITY IDEOGRAPH-2F812",
"CJK COMPATIBILITY IDEOGRAPH-2F813",
"CJK COMPATIBILITY IDEOGRAPH-2F814",
"CJK COMPATIBILITY IDEOGRAPH-2F815",
"CJK COMPATIBILITY IDEOGRAPH-2F816",
"CJK COMPATIBILITY IDEOGRAPH-2F817",
"CJK COMPATIBILITY IDEOGRAPH-2F818",
"CJK COMPATIBILITY IDEOGRAPH-2F819",
"CJK COMPATIBILITY IDEOGRAPH-2F81A",
"CJK COMPATIBILITY IDEOGRAPH-2F81B",
"CJK COMPATIBILITY IDEOGRAPH-2F81C",
"CJK COMPATIBILITY IDEOGRAPH-2F81D",
"CJK COMPATIBILITY IDEOGRAPH-2F81E",
"CJK COMPATIBILITY IDEOGRAPH-2F81F",
"CJK COMPATIBILITY IDEOGRAPH-2F820",
"CJK COMPATIBILITY IDEOGRAPH-2F821",
"CJK COMPATIBILITY IDEOGRAPH-2F822",
"CJK COMPATIBILITY IDEOGRAPH-2F823",
"CJK COMPATIBILITY IDEOGRAPH-2F824",
"CJK COMPATIBILITY IDEOGRAPH-2F825",
"CJK COMPATIBILITY IDEOGRAPH-2F826",
"CJK COMPATIBILITY IDEOGRAPH-2F827",
"CJK COMPATIBILITY IDEOGRAPH-2F828",
"CJK COMPATIBILITY IDEOGRAPH-2F829",
"CJK COMPATIBILITY IDEOGRAPH-2F82A",
"CJK COMPATIBILITY IDEOGRAPH-2F82B",
"CJK COMPATIBILITY IDEOGRAPH-2F82C",
"CJK COMPATIBILITY IDEOGRAPH-2F82D",
"CJK COMPATIBILITY IDEOGRAPH-2F82E",
"CJK COMPATIBILITY IDEOGRAPH-2F82F",
"CJK COMPATIBILITY IDEOGRAPH-2F830",
"CJK COMPATIBILITY IDEOGRAPH-2F831",
"CJK COMPATIBILITY IDEOGRAPH-2F832",
"CJK COMPATIBILITY IDEOGRAPH-2F833",
"CJK COMPATIBILITY IDEOGRAPH-2F834",
"CJK COMPATIBILITY IDEOGRAPH-2F835",
"CJK COMPATIBILITY IDEOGRAPH-2F836",
"CJK COMPATIBILITY IDEOGRAPH-2F837",
"CJK COMPATIBILITY IDEOGRAPH-2F838",
"CJK COMPATIBILITY IDEOGRAPH-2F839",
"CJK COMPATIBILITY IDEOGRAPH-2F83A",
"CJK COMPATIBILITY IDEOGRAPH-2F83B",
"CJK COMPATIBILITY IDEOGRAPH-2F83C",
"CJK COMPATIBILITY IDEOGRAPH-2F83D",
"CJK COMPATIBILITY IDEOGRAPH-2F83E",
"CJK COMPATIBILITY IDEOGRAPH-2F83F",
"CJK COMPATIBILITY IDEOGRAPH-2F840",
"CJK COMPATIBILITY IDEOGRAPH-2F841",
"CJK COMPATIBILITY IDEOGRAPH-2F842",
"CJK COMPATIBILITY IDEOGRAPH-2F843",
"CJK COMPATIBILITY IDEOGRAPH-2F844",
"CJK COMPATIBILITY IDEOGRAPH-2F845",
"CJK COMPATIBILITY IDEOGRAPH-2F846",
"CJK COMPATIBILITY IDEOGRAPH-2F847",
"CJK COMPATIBILITY IDEOGRAPH-2F848",
"CJK COMPATIBILITY IDEOGRAPH-2F849",
"CJK COMPATIBILITY IDEOGRAPH-2F84A",
"CJK COMPATIBILITY IDEOGRAPH-2F84B",
"CJK COMPATIBILITY IDEOGRAPH-2F84C",
"CJK COMPATIBILITY IDEOGRAPH-2F84D",
"CJK COMPATIBILITY IDEOGRAPH-2F84E",
"CJK COMPATIBILITY IDEOGRAPH-2F84F",
"CJK COMPATIBILITY IDEOGRAPH-2F850",
"CJK COMPATIBILITY IDEOGRAPH-2F851",
"CJK COMPATIBILITY IDEOGRAPH-2F852",
"CJK COMPATIBILITY IDEOGRAPH-2F853",
"CJK COMPATIBILITY IDEOGRAPH-2F854",
"CJK COMPATIBILITY IDEOGRAPH-2F855",
"CJK COMPATIBILITY IDEOGRAPH-2F856",
"CJK COMPATIBILITY IDEOGRAPH-2F857",
"CJK COMPATIBILITY IDEOGRAPH-2F858",
"CJK COMPATIBILITY IDEOGRAPH-2F859",
"CJK COMPATIBILITY IDEOGRAPH-2F85A",
"CJK COMPATIBILITY IDEOGRAPH-2F85B",
"CJK COMPATIBILITY IDEOGRAPH-2F85C",
"CJK COMPATIBILITY IDEOGRAPH-2F85D",
"CJK COMPATIBILITY IDEOGRAPH-2F85E",
"CJK COMPATIBILITY IDEOGRAPH-2F85F",
"CJK COMPATIBILITY IDEOGRAPH-2F860",
"CJK COMPATIBILITY IDEOGRAPH-2F861",
"CJK COMPATIBILITY IDEOGRAPH-2F862",
"CJK COMPATIBILITY IDEOGRAPH-2F863",
"CJK COMPATIBILITY IDEOGRAPH-2F864",
"CJK COMPATIBILITY IDEOGRAPH-2F865",
"CJK COMPATIBILITY IDEOGRAPH-2F866",
"CJK COMPATIBILITY IDEOGRAPH-2F867",
"CJK COMPATIBILITY IDEOGRAPH-2F868",
"CJK COMPATIBILITY IDEOGRAPH-2F869",
"CJK COMPATIBILITY IDEOGRAPH-2F86A",
"CJK COMPATIBILITY IDEOGRAPH-2F86B",
"CJK COMPATIBILITY IDEOGRAPH-2F86C",
"CJK COMPATIBILITY IDEOGRAPH-2F86D",
"CJK COMPATIBILITY IDEOGRAPH-2F86E",
"CJK COMPATIBILITY IDEOGRAPH-2F86F",
"CJK COMPATIBILITY IDEOGRAPH-2F870",
"CJK COMPATIBILITY IDEOGRAPH-2F871",
"CJK COMPATIBILITY IDEOGRAPH-2F872",
"CJK COMPATIBILITY IDEOGRAPH-2F873",
"CJK COMPATIBILITY IDEOGRAPH-2F874",
"CJK COMPATIBILITY IDEOGRAPH-2F875",
"CJK COMPATIBILITY IDEOGRAPH-2F876",
"CJK COMPATIBILITY IDEOGRAPH-2F877",
"CJK COMPATIBILITY IDEOGRAPH-2F878",
"CJK COMPATIBILITY IDEOGRAPH-2F879",
"CJK COMPATIBILITY IDEOGRAPH-2F87A",
"CJK COMPATIBILITY IDEOGRAPH-2F87B",
"CJK COMPATIBILITY IDEOGRAPH-2F87C",
"CJK COMPATIBILITY IDEOGRAPH-2F87D",
"CJK COMPATIBILITY IDEOGRAPH-2F87E",
"CJK COMPATIBILITY IDEOGRAPH-2F87F",
"CJK COMPATIBILITY IDEOGRAPH-2F880",
"CJK COMPATIBILITY IDEOGRAPH-2F881",
"CJK COMPATIBILITY IDEOGRAPH-2F882",
"CJK COMPATIBILITY IDEOGRAPH-2F883",
"CJK COMPATIBILITY IDEOGRAPH-2F884",
"CJK COMPATIBILITY IDEOGRAPH-2F885",
"CJK COMPATIBILITY IDEOGRAPH-2F886",
"CJK COMPATIBILITY IDEOGRAPH-2F887",
"CJK COMPATIBILITY IDEOGRAPH-2F888",
"CJK COMPATIBILITY IDEOGRAPH-2F889",
"CJK COMPATIBILITY IDEOGRAPH-2F88A",
"CJK COMPATIBILITY IDEOGRAPH-2F88B",
"CJK COMPATIBILITY IDEOGRAPH-2F88C",
"CJK COMPATIBILITY IDEOGRAPH-2F88D",
"CJK COMPATIBILITY IDEOGRAPH-2F88E",
"CJK COMPATIBILITY IDEOGRAPH-2F88F",
"CJK COMPATIBILITY IDEOGRAPH-2F890",
"CJK COMPATIBILITY IDEOGRAPH-2F891",
"CJK COMPATIBILITY IDEOGRAPH-2F892",
"CJK COMPATIBILITY IDEOGRAPH-2F893",
"CJK COMPATIBILITY IDEOGRAPH-2F894",
"CJK COMPATIBILITY IDEOGRAPH-2F895",
"CJK COMPATIBILITY IDEOGRAPH-2F896",
"CJK COMPATIBILITY IDEOGRAPH-2F897",
"CJK COMPATIBILITY IDEOGRAPH-2F898",
"CJK COMPATIBILITY IDEOGRAPH-2F899",
"CJK COMPATIBILITY IDEOGRAPH-2F89A",
"CJK COMPATIBILITY IDEOGRAPH-2F89B",
"CJK COMPATIBILITY IDEOGRAPH-2F89C",
"CJK COMPATIBILITY IDEOGRAPH-2F89D",
"CJK COMPATIBILITY IDEOGRAPH-2F89E",
"CJK COMPATIBILITY IDEOGRAPH-2F89F",
"CJK COMPATIBILITY IDEOGRAPH-2F8A0",
"CJK COMPATIBILITY IDEOGRAPH-2F8A1",
"CJK COMPATIBILITY IDEOGRAPH-2F8A2",
"CJK COMPATIBILITY IDEOGRAPH-2F8A3",
"CJK COMPATIBILITY IDEOGRAPH-2F8A4",
"CJK COMPATIBILITY IDEOGRAPH-2F8A5",
"CJK COMPATIBILITY IDEOGRAPH-2F8A6",
"CJK COMPATIBILITY IDEOGRAPH-2F8A7",
"CJK COMPATIBILITY IDEOGRAPH-2F8A8",
"CJK COMPATIBILITY IDEOGRAPH-2F8A9",
"CJK COMPATIBILITY IDEOGRAPH-2F8AA",
"CJK COMPATIBILITY IDEOGRAPH-2F8AB",
"CJK COMPATIBILITY IDEOGRAPH-2F8AC",
"CJK COMPATIBILITY IDEOGRAPH-2F8AD",
"CJK COMPATIBILITY IDEOGRAPH-2F8AE",
"CJK COMPATIBILITY IDEOGRAPH-2F8AF",
"CJK COMPATIBILITY IDEOGRAPH-2F8B0",
"CJK COMPATIBILITY IDEOGRAPH-2F8B1",
"CJK COMPATIBILITY IDEOGRAPH-2F8B2",
"CJK COMPATIBILITY IDEOGRAPH-2F8B3",
"CJK COMPATIBILITY IDEOGRAPH-2F8B4",
"CJK COMPATIBILITY IDEOGRAPH-2F8B5",
"CJK COMPATIBILITY IDEOGRAPH-2F8B6",
"CJK COMPATIBILITY IDEOGRAPH-2F8B7",
"CJK COMPATIBILITY IDEOGRAPH-2F8B8",
"CJK COMPATIBILITY IDEOGRAPH-2F8B9",
"CJK COMPATIBILITY IDEOGRAPH-2F8BA",
"CJK COMPATIBILITY IDEOGRAPH-2F8BB",
"CJK COMPATIBILITY IDEOGRAPH-2F8BC",
"CJK COMPATIBILITY IDEOGRAPH-2F8BD",
"CJK COMPATIBILITY IDEOGRAPH-2F8BE",
"CJK COMPATIBILITY IDEOGRAPH-2F8BF",
"CJK COMPATIBILITY IDEOGRAPH-2F8C0",
"CJK COMPATIBILITY IDEOGRAPH-2F8C1",
"CJK COMPATIBILITY IDEOGRAPH-2F8C2",
"CJK COMPATIBILITY IDEOGRAPH-2F8C3",
"CJK COMPATIBILITY IDEOGRAPH-2F8C4",
"CJK COMPATIBILITY IDEOGRAPH-2F8C5",
"CJK COMPATIBILITY IDEOGRAPH-2F8C6",
"CJK COMPATIBILITY IDEOGRAPH-2F8C7",
"CJK COMPATIBILITY IDEOGRAPH-2F8C8",
"CJK COMPATIBILITY IDEOGRAPH-2F8C9",
"CJK COMPATIBILITY IDEOGRAPH-2F8CA",
"CJK COMPATIBILITY IDEOGRAPH-2F8CB",
"CJK COMPATIBILITY IDEOGRAPH-2F8CC",
"CJK COMPATIBILITY IDEOGRAPH-2F8CD",
"CJK COMPATIBILITY IDEOGRAPH-2F8CE",
"CJK COMPATIBILITY IDEOGRAPH-2F8CF",
"CJK COMPATIBILITY IDEOGRAPH-2F8D0",
"CJK COMPATIBILITY IDEOGRAPH-2F8D1",
"CJK COMPATIBILITY IDEOGRAPH-2F8D2",
"CJK COMPATIBILITY IDEOGRAPH-2F8D3",
"CJK COMPATIBILITY IDEOGRAPH-2F8D4",
"CJK COMPATIBILITY IDEOGRAPH-2F8D5",
"CJK COMPATIBILITY IDEOGRAPH-2F8D6",
"CJK COMPATIBILITY IDEOGRAPH-2F8D7",
"CJK COMPATIBILITY IDEOGRAPH-2F8D8",
"CJK COMPATIBILITY IDEOGRAPH-2F8D9",
"CJK COMPATIBILITY IDEOGRAPH-2F8DA",
"CJK COMPATIBILITY IDEOGRAPH-2F8DB",
"CJK COMPATIBILITY IDEOGRAPH-2F8DC",
"CJK COMPATIBILITY IDEOGRAPH-2F8DD",
"CJK COMPATIBILITY IDEOGRAPH-2F8DE",
"CJK COMPATIBILITY IDEOGRAPH-2F8DF",
"CJK COMPATIBILITY IDEOGRAPH-2F8E0",
"CJK COMPATIBILITY IDEOGRAPH-2F8E1",
"CJK COMPATIBILITY IDEOGRAPH-2F8E2",
"CJK COMPATIBILITY IDEOGRAPH-2F8E3",
"CJK COMPATIBILITY IDEOGRAPH-2F8E4",
"CJK COMPATIBILITY IDEOGRAPH-2F8E5",
"CJK COMPATIBILITY IDEOGRAPH-2F8E6",
"CJK COMPATIBILITY IDEOGRAPH-2F8E7",
"CJK COMPATIBILITY IDEOGRAPH-2F8E8",
"CJK COMPATIBILITY IDEOGRAPH-2F8E9",
"CJK COMPATIBILITY IDEOGRAPH-2F8EA",
"CJK COMPATIBILITY IDEOGRAPH-2F8EB",
"CJK COMPATIBILITY IDEOGRAPH-2F8EC",
"CJK COMPATIBILITY IDEOGRAPH-2F8ED",
"CJK COMPATIBILITY IDEOGRAPH-2F8EE",
"CJK COMPATIBILITY IDEOGRAPH-2F8EF",
"CJK COMPATIBILITY IDEOGRAPH-2F8F0",
"CJK COMPATIBILITY IDEOGRAPH-2F8F1",
"CJK COMPATIBILITY IDEOGRAPH-2F8F2",
"CJK COMPATIBILITY IDEOGRAPH-2F8F3",
"CJK COMPATIBILITY IDEOGRAPH-2F8F4",
"CJK COMPATIBILITY IDEOGRAPH-2F8F5",
"CJK COMPATIBILITY IDEOGRAPH-2F8F6",
"CJK COMPATIBILITY IDEOGRAPH-2F8F7",
"CJK COMPATIBILITY IDEOGRAPH-2F8F8",
"CJK COMPATIBILITY IDEOGRAPH-2F8F9",
"CJK COMPATIBILITY IDEOGRAPH-2F8FA",
"CJK COMPATIBILITY IDEOGRAPH-2F8FB",
"CJK COMPATIBILITY IDEOGRAPH-2F8FC",
"CJK COMPATIBILITY IDEOGRAPH-2F8FD",
"CJK COMPATIBILITY IDEOGRAPH-2F8FE",
"CJK COMPATIBILITY IDEOGRAPH-2F8FF"};
static const char * name_02f9[256] =
{
"CJK COMPATIBILITY IDEOGRAPH-2F900",
"CJK COMPATIBILITY IDEOGRAPH-2F901",
"CJK COMPATIBILITY IDEOGRAPH-2F902",
"CJK COMPATIBILITY IDEOGRAPH-2F903",
"CJK COMPATIBILITY IDEOGRAPH-2F904",
"CJK COMPATIBILITY IDEOGRAPH-2F905",
"CJK COMPATIBILITY IDEOGRAPH-2F906",
"CJK COMPATIBILITY IDEOGRAPH-2F907",
"CJK COMPATIBILITY IDEOGRAPH-2F908",
"CJK COMPATIBILITY IDEOGRAPH-2F909",
"CJK COMPATIBILITY IDEOGRAPH-2F90A",
"CJK COMPATIBILITY IDEOGRAPH-2F90B",
"CJK COMPATIBILITY IDEOGRAPH-2F90C",
"CJK COMPATIBILITY IDEOGRAPH-2F90D",
"CJK COMPATIBILITY IDEOGRAPH-2F90E",
"CJK COMPATIBILITY IDEOGRAPH-2F90F",
"CJK COMPATIBILITY IDEOGRAPH-2F910",
"CJK COMPATIBILITY IDEOGRAPH-2F911",
"CJK COMPATIBILITY IDEOGRAPH-2F912",
"CJK COMPATIBILITY IDEOGRAPH-2F913",
"CJK COMPATIBILITY IDEOGRAPH-2F914",
"CJK COMPATIBILITY IDEOGRAPH-2F915",
"CJK COMPATIBILITY IDEOGRAPH-2F916",
"CJK COMPATIBILITY IDEOGRAPH-2F917",
"CJK COMPATIBILITY IDEOGRAPH-2F918",
"CJK COMPATIBILITY IDEOGRAPH-2F919",
"CJK COMPATIBILITY IDEOGRAPH-2F91A",
"CJK COMPATIBILITY IDEOGRAPH-2F91B",
"CJK COMPATIBILITY IDEOGRAPH-2F91C",
"CJK COMPATIBILITY IDEOGRAPH-2F91D",
"CJK COMPATIBILITY IDEOGRAPH-2F91E",
"CJK COMPATIBILITY IDEOGRAPH-2F91F",
"CJK COMPATIBILITY IDEOGRAPH-2F920",
"CJK COMPATIBILITY IDEOGRAPH-2F921",
"CJK COMPATIBILITY IDEOGRAPH-2F922",
"CJK COMPATIBILITY IDEOGRAPH-2F923",
"CJK COMPATIBILITY IDEOGRAPH-2F924",
"CJK COMPATIBILITY IDEOGRAPH-2F925",
"CJK COMPATIBILITY IDEOGRAPH-2F926",
"CJK COMPATIBILITY IDEOGRAPH-2F927",
"CJK COMPATIBILITY IDEOGRAPH-2F928",
"CJK COMPATIBILITY IDEOGRAPH-2F929",
"CJK COMPATIBILITY IDEOGRAPH-2F92A",
"CJK COMPATIBILITY IDEOGRAPH-2F92B",
"CJK COMPATIBILITY IDEOGRAPH-2F92C",
"CJK COMPATIBILITY IDEOGRAPH-2F92D",
"CJK COMPATIBILITY IDEOGRAPH-2F92E",
"CJK COMPATIBILITY IDEOGRAPH-2F92F",
"CJK COMPATIBILITY IDEOGRAPH-2F930",
"CJK COMPATIBILITY IDEOGRAPH-2F931",
"CJK COMPATIBILITY IDEOGRAPH-2F932",
"CJK COMPATIBILITY IDEOGRAPH-2F933",
"CJK COMPATIBILITY IDEOGRAPH-2F934",
"CJK COMPATIBILITY IDEOGRAPH-2F935",
"CJK COMPATIBILITY IDEOGRAPH-2F936",
"CJK COMPATIBILITY IDEOGRAPH-2F937",
"CJK COMPATIBILITY IDEOGRAPH-2F938",
"CJK COMPATIBILITY IDEOGRAPH-2F939",
"CJK COMPATIBILITY IDEOGRAPH-2F93A",
"CJK COMPATIBILITY IDEOGRAPH-2F93B",
"CJK COMPATIBILITY IDEOGRAPH-2F93C",
"CJK COMPATIBILITY IDEOGRAPH-2F93D",
"CJK COMPATIBILITY IDEOGRAPH-2F93E",
"CJK COMPATIBILITY IDEOGRAPH-2F93F",
"CJK COMPATIBILITY IDEOGRAPH-2F940",
"CJK COMPATIBILITY IDEOGRAPH-2F941",
"CJK COMPATIBILITY IDEOGRAPH-2F942",
"CJK COMPATIBILITY IDEOGRAPH-2F943",
"CJK COMPATIBILITY IDEOGRAPH-2F944",
"CJK COMPATIBILITY IDEOGRAPH-2F945",
"CJK COMPATIBILITY IDEOGRAPH-2F946",
"CJK COMPATIBILITY IDEOGRAPH-2F947",
"CJK COMPATIBILITY IDEOGRAPH-2F948",
"CJK COMPATIBILITY IDEOGRAPH-2F949",
"CJK COMPATIBILITY IDEOGRAPH-2F94A",
"CJK COMPATIBILITY IDEOGRAPH-2F94B",
"CJK COMPATIBILITY IDEOGRAPH-2F94C",
"CJK COMPATIBILITY IDEOGRAPH-2F94D",
"CJK COMPATIBILITY IDEOGRAPH-2F94E",
"CJK COMPATIBILITY IDEOGRAPH-2F94F",
"CJK COMPATIBILITY IDEOGRAPH-2F950",
"CJK COMPATIBILITY IDEOGRAPH-2F951",
"CJK COMPATIBILITY IDEOGRAPH-2F952",
"CJK COMPATIBILITY IDEOGRAPH-2F953",
"CJK COMPATIBILITY IDEOGRAPH-2F954",
"CJK COMPATIBILITY IDEOGRAPH-2F955",
"CJK COMPATIBILITY IDEOGRAPH-2F956",
"CJK COMPATIBILITY IDEOGRAPH-2F957",
"CJK COMPATIBILITY IDEOGRAPH-2F958",
"CJK COMPATIBILITY IDEOGRAPH-2F959",
"CJK COMPATIBILITY IDEOGRAPH-2F95A",
"CJK COMPATIBILITY IDEOGRAPH-2F95B",
"CJK COMPATIBILITY IDEOGRAPH-2F95C",
"CJK COMPATIBILITY IDEOGRAPH-2F95D",
"CJK COMPATIBILITY IDEOGRAPH-2F95E",
"CJK COMPATIBILITY IDEOGRAPH-2F95F",
"CJK COMPATIBILITY IDEOGRAPH-2F960",
"CJK COMPATIBILITY IDEOGRAPH-2F961",
"CJK COMPATIBILITY IDEOGRAPH-2F962",
"CJK COMPATIBILITY IDEOGRAPH-2F963",
"CJK COMPATIBILITY IDEOGRAPH-2F964",
"CJK COMPATIBILITY IDEOGRAPH-2F965",
"CJK COMPATIBILITY IDEOGRAPH-2F966",
"CJK COMPATIBILITY IDEOGRAPH-2F967",
"CJK COMPATIBILITY IDEOGRAPH-2F968",
"CJK COMPATIBILITY IDEOGRAPH-2F969",
"CJK COMPATIBILITY IDEOGRAPH-2F96A",
"CJK COMPATIBILITY IDEOGRAPH-2F96B",
"CJK COMPATIBILITY IDEOGRAPH-2F96C",
"CJK COMPATIBILITY IDEOGRAPH-2F96D",
"CJK COMPATIBILITY IDEOGRAPH-2F96E",
"CJK COMPATIBILITY IDEOGRAPH-2F96F",
"CJK COMPATIBILITY IDEOGRAPH-2F970",
"CJK COMPATIBILITY IDEOGRAPH-2F971",
"CJK COMPATIBILITY IDEOGRAPH-2F972",
"CJK COMPATIBILITY IDEOGRAPH-2F973",
"CJK COMPATIBILITY IDEOGRAPH-2F974",
"CJK COMPATIBILITY IDEOGRAPH-2F975",
"CJK COMPATIBILITY IDEOGRAPH-2F976",
"CJK COMPATIBILITY IDEOGRAPH-2F977",
"CJK COMPATIBILITY IDEOGRAPH-2F978",
"CJK COMPATIBILITY IDEOGRAPH-2F979",
"CJK COMPATIBILITY IDEOGRAPH-2F97A",
"CJK COMPATIBILITY IDEOGRAPH-2F97B",
"CJK COMPATIBILITY IDEOGRAPH-2F97C",
"CJK COMPATIBILITY IDEOGRAPH-2F97D",
"CJK COMPATIBILITY IDEOGRAPH-2F97E",
"CJK COMPATIBILITY IDEOGRAPH-2F97F",
"CJK COMPATIBILITY IDEOGRAPH-2F980",
"CJK COMPATIBILITY IDEOGRAPH-2F981",
"CJK COMPATIBILITY IDEOGRAPH-2F982",
"CJK COMPATIBILITY IDEOGRAPH-2F983",
"CJK COMPATIBILITY IDEOGRAPH-2F984",
"CJK COMPATIBILITY IDEOGRAPH-2F985",
"CJK COMPATIBILITY IDEOGRAPH-2F986",
"CJK COMPATIBILITY IDEOGRAPH-2F987",
"CJK COMPATIBILITY IDEOGRAPH-2F988",
"CJK COMPATIBILITY IDEOGRAPH-2F989",
"CJK COMPATIBILITY IDEOGRAPH-2F98A",
"CJK COMPATIBILITY IDEOGRAPH-2F98B",
"CJK COMPATIBILITY IDEOGRAPH-2F98C",
"CJK COMPATIBILITY IDEOGRAPH-2F98D",
"CJK COMPATIBILITY IDEOGRAPH-2F98E",
"CJK COMPATIBILITY IDEOGRAPH-2F98F",
"CJK COMPATIBILITY IDEOGRAPH-2F990",
"CJK COMPATIBILITY IDEOGRAPH-2F991",
"CJK COMPATIBILITY IDEOGRAPH-2F992",
"CJK COMPATIBILITY IDEOGRAPH-2F993",
"CJK COMPATIBILITY IDEOGRAPH-2F994",
"CJK COMPATIBILITY IDEOGRAPH-2F995",
"CJK COMPATIBILITY IDEOGRAPH-2F996",
"CJK COMPATIBILITY IDEOGRAPH-2F997",
"CJK COMPATIBILITY IDEOGRAPH-2F998",
"CJK COMPATIBILITY IDEOGRAPH-2F999",
"CJK COMPATIBILITY IDEOGRAPH-2F99A",
"CJK COMPATIBILITY IDEOGRAPH-2F99B",
"CJK COMPATIBILITY IDEOGRAPH-2F99C",
"CJK COMPATIBILITY IDEOGRAPH-2F99D",
"CJK COMPATIBILITY IDEOGRAPH-2F99E",
"CJK COMPATIBILITY IDEOGRAPH-2F99F",
"CJK COMPATIBILITY IDEOGRAPH-2F9A0",
"CJK COMPATIBILITY IDEOGRAPH-2F9A1",
"CJK COMPATIBILITY IDEOGRAPH-2F9A2",
"CJK COMPATIBILITY IDEOGRAPH-2F9A3",
"CJK COMPATIBILITY IDEOGRAPH-2F9A4",
"CJK COMPATIBILITY IDEOGRAPH-2F9A5",
"CJK COMPATIBILITY IDEOGRAPH-2F9A6",
"CJK COMPATIBILITY IDEOGRAPH-2F9A7",
"CJK COMPATIBILITY IDEOGRAPH-2F9A8",
"CJK COMPATIBILITY IDEOGRAPH-2F9A9",
"CJK COMPATIBILITY IDEOGRAPH-2F9AA",
"CJK COMPATIBILITY IDEOGRAPH-2F9AB",
"CJK COMPATIBILITY IDEOGRAPH-2F9AC",
"CJK COMPATIBILITY IDEOGRAPH-2F9AD",
"CJK COMPATIBILITY IDEOGRAPH-2F9AE",
"CJK COMPATIBILITY IDEOGRAPH-2F9AF",
"CJK COMPATIBILITY IDEOGRAPH-2F9B0",
"CJK COMPATIBILITY IDEOGRAPH-2F9B1",
"CJK COMPATIBILITY IDEOGRAPH-2F9B2",
"CJK COMPATIBILITY IDEOGRAPH-2F9B3",
"CJK COMPATIBILITY IDEOGRAPH-2F9B4",
"CJK COMPATIBILITY IDEOGRAPH-2F9B5",
"CJK COMPATIBILITY IDEOGRAPH-2F9B6",
"CJK COMPATIBILITY IDEOGRAPH-2F9B7",
"CJK COMPATIBILITY IDEOGRAPH-2F9B8",
"CJK COMPATIBILITY IDEOGRAPH-2F9B9",
"CJK COMPATIBILITY IDEOGRAPH-2F9BA",
"CJK COMPATIBILITY IDEOGRAPH-2F9BB",
"CJK COMPATIBILITY IDEOGRAPH-2F9BC",
"CJK COMPATIBILITY IDEOGRAPH-2F9BD",
"CJK COMPATIBILITY IDEOGRAPH-2F9BE",
"CJK COMPATIBILITY IDEOGRAPH-2F9BF",
"CJK COMPATIBILITY IDEOGRAPH-2F9C0",
"CJK COMPATIBILITY IDEOGRAPH-2F9C1",
"CJK COMPATIBILITY IDEOGRAPH-2F9C2",
"CJK COMPATIBILITY IDEOGRAPH-2F9C3",
"CJK COMPATIBILITY IDEOGRAPH-2F9C4",
"CJK COMPATIBILITY IDEOGRAPH-2F9C5",
"CJK COMPATIBILITY IDEOGRAPH-2F9C6",
"CJK COMPATIBILITY IDEOGRAPH-2F9C7",
"CJK COMPATIBILITY IDEOGRAPH-2F9C8",
"CJK COMPATIBILITY IDEOGRAPH-2F9C9",
"CJK COMPATIBILITY IDEOGRAPH-2F9CA",
"CJK COMPATIBILITY IDEOGRAPH-2F9CB",
"CJK COMPATIBILITY IDEOGRAPH-2F9CC",
"CJK COMPATIBILITY IDEOGRAPH-2F9CD",
"CJK COMPATIBILITY IDEOGRAPH-2F9CE",
"CJK COMPATIBILITY IDEOGRAPH-2F9CF",
"CJK COMPATIBILITY IDEOGRAPH-2F9D0",
"CJK COMPATIBILITY IDEOGRAPH-2F9D1",
"CJK COMPATIBILITY IDEOGRAPH-2F9D2",
"CJK COMPATIBILITY IDEOGRAPH-2F9D3",
"CJK COMPATIBILITY IDEOGRAPH-2F9D4",
"CJK COMPATIBILITY IDEOGRAPH-2F9D5",
"CJK COMPATIBILITY IDEOGRAPH-2F9D6",
"CJK COMPATIBILITY IDEOGRAPH-2F9D7",
"CJK COMPATIBILITY IDEOGRAPH-2F9D8",
"CJK COMPATIBILITY IDEOGRAPH-2F9D9",
"CJK COMPATIBILITY IDEOGRAPH-2F9DA",
"CJK COMPATIBILITY IDEOGRAPH-2F9DB",
"CJK COMPATIBILITY IDEOGRAPH-2F9DC",
"CJK COMPATIBILITY IDEOGRAPH-2F9DD",
"CJK COMPATIBILITY IDEOGRAPH-2F9DE",
"CJK COMPATIBILITY IDEOGRAPH-2F9DF",
"CJK COMPATIBILITY IDEOGRAPH-2F9E0",
"CJK COMPATIBILITY IDEOGRAPH-2F9E1",
"CJK COMPATIBILITY IDEOGRAPH-2F9E2",
"CJK COMPATIBILITY IDEOGRAPH-2F9E3",
"CJK COMPATIBILITY IDEOGRAPH-2F9E4",
"CJK COMPATIBILITY IDEOGRAPH-2F9E5",
"CJK COMPATIBILITY IDEOGRAPH-2F9E6",
"CJK COMPATIBILITY IDEOGRAPH-2F9E7",
"CJK COMPATIBILITY IDEOGRAPH-2F9E8",
"CJK COMPATIBILITY IDEOGRAPH-2F9E9",
"CJK COMPATIBILITY IDEOGRAPH-2F9EA",
"CJK COMPATIBILITY IDEOGRAPH-2F9EB",
"CJK COMPATIBILITY IDEOGRAPH-2F9EC",
"CJK COMPATIBILITY IDEOGRAPH-2F9ED",
"CJK COMPATIBILITY IDEOGRAPH-2F9EE",
"CJK COMPATIBILITY IDEOGRAPH-2F9EF",
"CJK COMPATIBILITY IDEOGRAPH-2F9F0",
"CJK COMPATIBILITY IDEOGRAPH-2F9F1",
"CJK COMPATIBILITY IDEOGRAPH-2F9F2",
"CJK COMPATIBILITY IDEOGRAPH-2F9F3",
"CJK COMPATIBILITY IDEOGRAPH-2F9F4",
"CJK COMPATIBILITY IDEOGRAPH-2F9F5",
"CJK COMPATIBILITY IDEOGRAPH-2F9F6",
"CJK COMPATIBILITY IDEOGRAPH-2F9F7",
"CJK COMPATIBILITY IDEOGRAPH-2F9F8",
"CJK COMPATIBILITY IDEOGRAPH-2F9F9",
"CJK COMPATIBILITY IDEOGRAPH-2F9FA",
"CJK COMPATIBILITY IDEOGRAPH-2F9FB",
"CJK COMPATIBILITY IDEOGRAPH-2F9FC",
"CJK COMPATIBILITY IDEOGRAPH-2F9FD",
"CJK COMPATIBILITY IDEOGRAPH-2F9FE",
"CJK COMPATIBILITY IDEOGRAPH-2F9FF"};
static const char * name_02fa[256] =
{
"CJK COMPATIBILITY IDEOGRAPH-2FA00",
"CJK COMPATIBILITY IDEOGRAPH-2FA01",
"CJK COMPATIBILITY IDEOGRAPH-2FA02",
"CJK COMPATIBILITY IDEOGRAPH-2FA03",
"CJK COMPATIBILITY IDEOGRAPH-2FA04",
"CJK COMPATIBILITY IDEOGRAPH-2FA05",
"CJK COMPATIBILITY IDEOGRAPH-2FA06",
"CJK COMPATIBILITY IDEOGRAPH-2FA07",
"CJK COMPATIBILITY IDEOGRAPH-2FA08",
"CJK COMPATIBILITY IDEOGRAPH-2FA09",
"CJK COMPATIBILITY IDEOGRAPH-2FA0A",
"CJK COMPATIBILITY IDEOGRAPH-2FA0B",
"CJK COMPATIBILITY IDEOGRAPH-2FA0C",
"CJK COMPATIBILITY IDEOGRAPH-2FA0D",
"CJK COMPATIBILITY IDEOGRAPH-2FA0E",
"CJK COMPATIBILITY IDEOGRAPH-2FA0F",
"CJK COMPATIBILITY IDEOGRAPH-2FA10",
"CJK COMPATIBILITY IDEOGRAPH-2FA11",
"CJK COMPATIBILITY IDEOGRAPH-2FA12",
"CJK COMPATIBILITY IDEOGRAPH-2FA13",
"CJK COMPATIBILITY IDEOGRAPH-2FA14",
"CJK COMPATIBILITY IDEOGRAPH-2FA15",
"CJK COMPATIBILITY IDEOGRAPH-2FA16",
"CJK COMPATIBILITY IDEOGRAPH-2FA17",
"CJK COMPATIBILITY IDEOGRAPH-2FA18",
"CJK COMPATIBILITY IDEOGRAPH-2FA19",
"CJK COMPATIBILITY IDEOGRAPH-2FA1A",
"CJK COMPATIBILITY IDEOGRAPH-2FA1B",
"CJK COMPATIBILITY IDEOGRAPH-2FA1C",
"CJK COMPATIBILITY IDEOGRAPH-2FA1D",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0e00[256] =
{
name_reserved,
"LANGUAGE TAG",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"TAG SPACE",
"TAG EXCLAMATION MARK",
"TAG QUOTATION MARK",
"TAG NUMBER SIGN",
"TAG DOLLAR SIGN",
"TAG PERCENT SIGN",
"TAG AMPERSAND",
"TAG APOSTROPHE",
"TAG LEFT PARENTHESIS",
"TAG RIGHT PARENTHESIS",
"TAG ASTERISK",
"TAG PLUS SIGN",
"TAG COMMA",
"TAG HYPHEN-MINUS",
"TAG FULL STOP",
"TAG SOLIDUS",
"TAG DIGIT ZERO",
"TAG DIGIT ONE",
"TAG DIGIT TWO",
"TAG DIGIT THREE",
"TAG DIGIT FOUR",
"TAG DIGIT FIVE",
"TAG DIGIT SIX",
"TAG DIGIT SEVEN",
"TAG DIGIT EIGHT",
"TAG DIGIT NINE",
"TAG COLON",
"TAG SEMICOLON",
"TAG LESS-THAN SIGN",
"TAG EQUALS SIGN",
"TAG GREATER-THAN SIGN",
"TAG QUESTION MARK",
"TAG COMMERCIAL AT",
"TAG LATIN CAPITAL LETTER A",
"TAG LATIN CAPITAL LETTER B",
"TAG LATIN CAPITAL LETTER C",
"TAG LATIN CAPITAL LETTER D",
"TAG LATIN CAPITAL LETTER E",
"TAG LATIN CAPITAL LETTER F",
"TAG LATIN CAPITAL LETTER G",
"TAG LATIN CAPITAL LETTER H",
"TAG LATIN CAPITAL LETTER I",
"TAG LATIN CAPITAL LETTER J",
"TAG LATIN CAPITAL LETTER K",
"TAG LATIN CAPITAL LETTER L",
"TAG LATIN CAPITAL LETTER M",
"TAG LATIN CAPITAL LETTER N",
"TAG LATIN CAPITAL LETTER O",
"TAG LATIN CAPITAL LETTER P",
"TAG LATIN CAPITAL LETTER Q",
"TAG LATIN CAPITAL LETTER R",
"TAG LATIN CAPITAL LETTER S",
"TAG LATIN CAPITAL LETTER T",
"TAG LATIN CAPITAL LETTER U",
"TAG LATIN CAPITAL LETTER V",
"TAG LATIN CAPITAL LETTER W",
"TAG LATIN CAPITAL LETTER X",
"TAG LATIN CAPITAL LETTER Y",
"TAG LATIN CAPITAL LETTER Z",
"TAG LEFT SQUARE BRACKET",
"TAG REVERSE SOLIDUS",
"TAG RIGHT SQUARE BRACKET",
"TAG CIRCUMFLEX ACCENT",
"TAG LOW LINE",
"TAG GRAVE ACCENT",
"TAG LATIN SMALL LETTER A",
"TAG LATIN SMALL LETTER B",
"TAG LATIN SMALL LETTER C",
"TAG LATIN SMALL LETTER D",
"TAG LATIN SMALL LETTER E",
"TAG LATIN SMALL LETTER F",
"TAG LATIN SMALL LETTER G",
"TAG LATIN SMALL LETTER H",
"TAG LATIN SMALL LETTER I",
"TAG LATIN SMALL LETTER J",
"TAG LATIN SMALL LETTER K",
"TAG LATIN SMALL LETTER L",
"TAG LATIN SMALL LETTER M",
"TAG LATIN SMALL LETTER N",
"TAG LATIN SMALL LETTER O",
"TAG LATIN SMALL LETTER P",
"TAG LATIN SMALL LETTER Q",
"TAG LATIN SMALL LETTER R",
"TAG LATIN SMALL LETTER S",
"TAG LATIN SMALL LETTER T",
"TAG LATIN SMALL LETTER U",
"TAG LATIN SMALL LETTER V",
"TAG LATIN SMALL LETTER W",
"TAG LATIN SMALL LETTER X",
"TAG LATIN SMALL LETTER Y",
"TAG LATIN SMALL LETTER Z",
"TAG LEFT CURLY BRACKET",
"TAG VERTICAL LINE",
"TAG RIGHT CURLY BRACKET",
"TAG TILDE",
"CANCEL TAG",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0e01[256] =
{
"VARIATION SELECTOR-17",
"VARIATION SELECTOR-18",
"VARIATION SELECTOR-19",
"VARIATION SELECTOR-20",
"VARIATION SELECTOR-21",
"VARIATION SELECTOR-22",
"VARIATION SELECTOR-23",
"VARIATION SELECTOR-24",
"VARIATION SELECTOR-25",
"VARIATION SELECTOR-26",
"VARIATION SELECTOR-27",
"VARIATION SELECTOR-28",
"VARIATION SELECTOR-29",
"VARIATION SELECTOR-30",
"VARIATION SELECTOR-31",
"VARIATION SELECTOR-32",
"VARIATION SELECTOR-33",
"VARIATION SELECTOR-34",
"VARIATION SELECTOR-35",
"VARIATION SELECTOR-36",
"VARIATION SELECTOR-37",
"VARIATION SELECTOR-38",
"VARIATION SELECTOR-39",
"VARIATION SELECTOR-40",
"VARIATION SELECTOR-41",
"VARIATION SELECTOR-42",
"VARIATION SELECTOR-43",
"VARIATION SELECTOR-44",
"VARIATION SELECTOR-45",
"VARIATION SELECTOR-46",
"VARIATION SELECTOR-47",
"VARIATION SELECTOR-48",
"VARIATION SELECTOR-49",
"VARIATION SELECTOR-50",
"VARIATION SELECTOR-51",
"VARIATION SELECTOR-52",
"VARIATION SELECTOR-53",
"VARIATION SELECTOR-54",
"VARIATION SELECTOR-55",
"VARIATION SELECTOR-56",
"VARIATION SELECTOR-57",
"VARIATION SELECTOR-58",
"VARIATION SELECTOR-59",
"VARIATION SELECTOR-60",
"VARIATION SELECTOR-61",
"VARIATION SELECTOR-62",
"VARIATION SELECTOR-63",
"VARIATION SELECTOR-64",
"VARIATION SELECTOR-65",
"VARIATION SELECTOR-66",
"VARIATION SELECTOR-67",
"VARIATION SELECTOR-68",
"VARIATION SELECTOR-69",
"VARIATION SELECTOR-70",
"VARIATION SELECTOR-71",
"VARIATION SELECTOR-72",
"VARIATION SELECTOR-73",
"VARIATION SELECTOR-74",
"VARIATION SELECTOR-75",
"VARIATION SELECTOR-76",
"VARIATION SELECTOR-77",
"VARIATION SELECTOR-78",
"VARIATION SELECTOR-79",
"VARIATION SELECTOR-80",
"VARIATION SELECTOR-81",
"VARIATION SELECTOR-82",
"VARIATION SELECTOR-83",
"VARIATION SELECTOR-84",
"VARIATION SELECTOR-85",
"VARIATION SELECTOR-86",
"VARIATION SELECTOR-87",
"VARIATION SELECTOR-88",
"VARIATION SELECTOR-89",
"VARIATION SELECTOR-90",
"VARIATION SELECTOR-91",
"VARIATION SELECTOR-92",
"VARIATION SELECTOR-93",
"VARIATION SELECTOR-94",
"VARIATION SELECTOR-95",
"VARIATION SELECTOR-96",
"VARIATION SELECTOR-97",
"VARIATION SELECTOR-98",
"VARIATION SELECTOR-99",
"VARIATION SELECTOR-100",
"VARIATION SELECTOR-101",
"VARIATION SELECTOR-102",
"VARIATION SELECTOR-103",
"VARIATION SELECTOR-104",
"VARIATION SELECTOR-105",
"VARIATION SELECTOR-106",
"VARIATION SELECTOR-107",
"VARIATION SELECTOR-108",
"VARIATION SELECTOR-109",
"VARIATION SELECTOR-110",
"VARIATION SELECTOR-111",
"VARIATION SELECTOR-112",
"VARIATION SELECTOR-113",
"VARIATION SELECTOR-114",
"VARIATION SELECTOR-115",
"VARIATION SELECTOR-116",
"VARIATION SELECTOR-117",
"VARIATION SELECTOR-118",
"VARIATION SELECTOR-119",
"VARIATION SELECTOR-120",
"VARIATION SELECTOR-121",
"VARIATION SELECTOR-122",
"VARIATION SELECTOR-123",
"VARIATION SELECTOR-124",
"VARIATION SELECTOR-125",
"VARIATION SELECTOR-126",
"VARIATION SELECTOR-127",
"VARIATION SELECTOR-128",
"VARIATION SELECTOR-129",
"VARIATION SELECTOR-130",
"VARIATION SELECTOR-131",
"VARIATION SELECTOR-132",
"VARIATION SELECTOR-133",
"VARIATION SELECTOR-134",
"VARIATION SELECTOR-135",
"VARIATION SELECTOR-136",
"VARIATION SELECTOR-137",
"VARIATION SELECTOR-138",
"VARIATION SELECTOR-139",
"VARIATION SELECTOR-140",
"VARIATION SELECTOR-141",
"VARIATION SELECTOR-142",
"VARIATION SELECTOR-143",
"VARIATION SELECTOR-144",
"VARIATION SELECTOR-145",
"VARIATION SELECTOR-146",
"VARIATION SELECTOR-147",
"VARIATION SELECTOR-148",
"VARIATION SELECTOR-149",
"VARIATION SELECTOR-150",
"VARIATION SELECTOR-151",
"VARIATION SELECTOR-152",
"VARIATION SELECTOR-153",
"VARIATION SELECTOR-154",
"VARIATION SELECTOR-155",
"VARIATION SELECTOR-156",
"VARIATION SELECTOR-157",
"VARIATION SELECTOR-158",
"VARIATION SELECTOR-159",
"VARIATION SELECTOR-160",
"VARIATION SELECTOR-161",
"VARIATION SELECTOR-162",
"VARIATION SELECTOR-163",
"VARIATION SELECTOR-164",
"VARIATION SELECTOR-165",
"VARIATION SELECTOR-166",
"VARIATION SELECTOR-167",
"VARIATION SELECTOR-168",
"VARIATION SELECTOR-169",
"VARIATION SELECTOR-170",
"VARIATION SELECTOR-171",
"VARIATION SELECTOR-172",
"VARIATION SELECTOR-173",
"VARIATION SELECTOR-174",
"VARIATION SELECTOR-175",
"VARIATION SELECTOR-176",
"VARIATION SELECTOR-177",
"VARIATION SELECTOR-178",
"VARIATION SELECTOR-179",
"VARIATION SELECTOR-180",
"VARIATION SELECTOR-181",
"VARIATION SELECTOR-182",
"VARIATION SELECTOR-183",
"VARIATION SELECTOR-184",
"VARIATION SELECTOR-185",
"VARIATION SELECTOR-186",
"VARIATION SELECTOR-187",
"VARIATION SELECTOR-188",
"VARIATION SELECTOR-189",
"VARIATION SELECTOR-190",
"VARIATION SELECTOR-191",
"VARIATION SELECTOR-192",
"VARIATION SELECTOR-193",
"VARIATION SELECTOR-194",
"VARIATION SELECTOR-195",
"VARIATION SELECTOR-196",
"VARIATION SELECTOR-197",
"VARIATION SELECTOR-198",
"VARIATION SELECTOR-199",
"VARIATION SELECTOR-200",
"VARIATION SELECTOR-201",
"VARIATION SELECTOR-202",
"VARIATION SELECTOR-203",
"VARIATION SELECTOR-204",
"VARIATION SELECTOR-205",
"VARIATION SELECTOR-206",
"VARIATION SELECTOR-207",
"VARIATION SELECTOR-208",
"VARIATION SELECTOR-209",
"VARIATION SELECTOR-210",
"VARIATION SELECTOR-211",
"VARIATION SELECTOR-212",
"VARIATION SELECTOR-213",
"VARIATION SELECTOR-214",
"VARIATION SELECTOR-215",
"VARIATION SELECTOR-216",
"VARIATION SELECTOR-217",
"VARIATION SELECTOR-218",
"VARIATION SELECTOR-219",
"VARIATION SELECTOR-220",
"VARIATION SELECTOR-221",
"VARIATION SELECTOR-222",
"VARIATION SELECTOR-223",
"VARIATION SELECTOR-224",
"VARIATION SELECTOR-225",
"VARIATION SELECTOR-226",
"VARIATION SELECTOR-227",
"VARIATION SELECTOR-228",
"VARIATION SELECTOR-229",
"VARIATION SELECTOR-230",
"VARIATION SELECTOR-231",
"VARIATION SELECTOR-232",
"VARIATION SELECTOR-233",
"VARIATION SELECTOR-234",
"VARIATION SELECTOR-235",
"VARIATION SELECTOR-236",
"VARIATION SELECTOR-237",
"VARIATION SELECTOR-238",
"VARIATION SELECTOR-239",
"VARIATION SELECTOR-240",
"VARIATION SELECTOR-241",
"VARIATION SELECTOR-242",
"VARIATION SELECTOR-243",
"VARIATION SELECTOR-244",
"VARIATION SELECTOR-245",
"VARIATION SELECTOR-246",
"VARIATION SELECTOR-247",
"VARIATION SELECTOR-248",
"VARIATION SELECTOR-249",
"VARIATION SELECTOR-250",
"VARIATION SELECTOR-251",
"VARIATION SELECTOR-252",
"VARIATION SELECTOR-253",
"VARIATION SELECTOR-254",
"VARIATION SELECTOR-255",
"VARIATION SELECTOR-256",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0f00[256] =
{
"<Plane 15 Private Use, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_0fff[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<Plane 15 Private Use, Last>",
name_reserved,
name_reserved};
static const char * name_1000[256] =
{
"<Plane 16 Private Use, First>",
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char * name_10ff[256] =
{
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
"<Plane 16 Private Use, Last>",
name_reserved,
name_reserved};
static const char * name_xxxx[256] = {
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved,
name_reserved};
static const char ** name_table[] = { name_0000, name_0001, name_0002, name_0003, name_0004, name_0005, name_0006, name_0007, name_xxxx, name_0009, name_000a, name_000b, name_000c, name_000d, name_000e, name_000f, name_0010, name_0011, name_0012, name_0013, name_0014, name_0015, name_0016, name_0017, name_0018, name_0019, name_001a, name_xxxx, name_xxxx, name_001d, name_001e, name_001f, name_0020, name_0021, name_0022, name_0023, name_0024, name_0025, name_0026, name_0027, name_0028, name_0029, name_002a, name_002b, name_002c, name_002d, name_002e, name_002f, name_0030, name_0031, name_0032, name_0033, name_0034, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_004d, name_004e, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_009f, name_00a0, name_00a1, name_00a2, name_00a3, name_00a4, name_xxxx, name_xxxx, name_00a7, name_00a8, name_xxxx, name_xxxx, name_xxxx, name_00ac, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_00d7, name_00d8, name_xxxx, name_xxxx, name_00db, name_00dc, name_xxxx, name_xxxx, name_00df, name_00e0, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_00f8, name_00f9, name_00fa, name_00fb, name_00fc, name_00fd, name_00fe, name_00ff, name_0100, name_0101, name_xxxx, name_0103, name_0104, name_xxxx, name_xxxx, name_xxxx, name_0108, name_xxxx, name_010a, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_01d0, name_01d1, name_01d2, name_01d3, name_01d4, name_01d5, name_01d6, name_01d7, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_0200, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_02a6, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_02f8, name_02f9, name_02fa, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_0e00, name_0e01, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_0f00, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_0fff, name_1000, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_xxxx, name_10ff};
static unsigned char category_0000[256] =
{
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Zs,
Po,
Po,
Po,
Sc,
Po,
Po,
Po,
Ps,
Pe,
Po,
Sm,
Po,
Pd,
Po,
Po,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Po,
Po,
Sm,
Sm,
Sm,
Po,
Po,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ps,
Po,
Pe,
Sk,
Pc,
Sk,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ps,
Sm,
Pe,
Sm,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Cc,
Zs,
Po,
Sc,
Sc,
Sc,
Sc,
So,
So,
Sk,
So,
Ll,
Pi,
Sm,
Cf,
So,
Sk,
So,
Sm,
No,
No,
Sk,
Ll,
So,
Po,
Sk,
No,
Ll,
Pf,
No,
No,
No,
Po,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Sm,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll};
static unsigned char category_0001[256] =
{
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Ll,
Ll,
Lu,
Lu,
Ll,
Lu,
Ll,
Lu,
Lu,
Ll,
Lu,
Lu,
Lu,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Ll,
Lu,
Lu,
Ll,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Lu,
Lu,
Ll,
Lu,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Lu,
Ll,
Lu,
Ll,
Ll,
Lu,
Ll,
Lu,
Lu,
Ll,
Lu,
Lu,
Lu,
Ll,
Lu,
Ll,
Lu,
Lu,
Ll,
Ll,
Lo,
Lu,
Ll,
Ll,
Ll,
Lo,
Lo,
Lo,
Lo,
Lu,
Lt,
Ll,
Lu,
Lt,
Ll,
Lu,
Lt,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Ll,
Lu,
Lt,
Ll,
Lu,
Ll,
Lu,
Lu,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll};
static unsigned char category_0002[256] =
{
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Ll,
Lu,
Lu,
Ll,
Ll,
Lu,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Sk,
Sk,
Sk,
Sk,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Lm,
Lm,
Lm,
Lm,
Lm,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Lm,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk};
static unsigned char category_0003[256] =
{
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Sk,
Sk,
Cn,
Cn,
Cn,
Cn,
Lm,
Cn,
Cn,
Cn,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Sk,
Sk,
Lu,
Po,
Lu,
Lu,
Lu,
Cn,
Lu,
Cn,
Lu,
Lu,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Ll,
Ll,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Ll,
Sm,
Lu,
Ll,
Lu,
Lu,
Ll,
Ll,
Lu,
Lu,
Lu};
static unsigned char category_0004[256] =
{
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
So,
Mn,
Mn,
Mn,
Mn,
Cn,
Me,
Me,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Cn,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0005[256] =
{
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Cn,
Lm,
Po,
Po,
Po,
Po,
Po,
Po,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Po,
Pd,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Mn,
Mn,
Mn,
Po,
Mn,
Po,
Mn,
Mn,
Po,
Mn,
Mn,
Po,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Po,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0006[256] =
{
Cf,
Cf,
Cf,
Cf,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Sc,
Po,
Po,
So,
So,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Po,
Cn,
Cn,
Po,
Po,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Lm,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Po,
Po,
Po,
Po,
Lo,
Lo,
Mn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Po,
Lo,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cf,
Me,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Lm,
Lm,
Mn,
Mn,
So,
Mn,
Mn,
Mn,
Mn,
Lo,
Lo,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Lo,
Lo,
Lo,
So,
So,
Lo};
static unsigned char category_0007[256] =
{
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Cn,
Cf,
Lo,
Mn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0009[256] =
{
Cn,
Mn,
Mn,
Mc,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Mn,
Lo,
Mc,
Mc,
Mc,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mc,
Mc,
Mc,
Mc,
Mn,
Cn,
Cn,
Lo,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mn,
Mn,
Po,
Po,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Cn,
Cn,
Cn,
Mn,
Mc,
Mc,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Mn,
Lo,
Mc,
Mc,
Mc,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Mc,
Mc,
Cn,
Cn,
Mc,
Mc,
Mn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mc,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Mn,
Mn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Lo,
Lo,
Sc,
Sc,
No,
No,
No,
No,
No,
No,
So,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_000a[256] =
{
Cn,
Mn,
Mn,
Mc,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Cn,
Cn,
Mn,
Cn,
Mc,
Mc,
Mc,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Cn,
Cn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Mn,
Mn,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mc,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Mn,
Lo,
Mc,
Mc,
Mc,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Mn,
Mn,
Mc,
Cn,
Mc,
Mc,
Mn,
Cn,
Cn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Mn,
Mn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Cn,
Sc,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_000b[256] =
{
Cn,
Mn,
Mc,
Mc,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Mn,
Lo,
Mc,
Mn,
Mc,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Mc,
Mc,
Cn,
Cn,
Mc,
Mc,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mn,
Mc,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
So,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mn,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Lo,
Lo,
Cn,
Lo,
Cn,
Lo,
Lo,
Cn,
Cn,
Cn,
Lo,
Lo,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Mc,
Mc,
Mn,
Mc,
Mc,
Cn,
Cn,
Cn,
Mc,
Mc,
Mc,
Cn,
Mc,
Mc,
Mc,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mc,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
No,
No,
No,
So,
So,
So,
So,
So,
So,
Sc,
So,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_000c[256] =
{
Cn,
Mc,
Mc,
Mc,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mn,
Mc,
Mc,
Mc,
Mc,
Cn,
Mn,
Mn,
Mn,
Cn,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mc,
Mc,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Mn,
Lo,
Mc,
Mn,
Mc,
Mc,
Mc,
Mc,
Mc,
Cn,
Mn,
Mc,
Mc,
Cn,
Mc,
Mc,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mc,
Mc,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Cn,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_000d[256] =
{
Cn,
Cn,
Mc,
Mc,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Mc,
Mc,
Mc,
Mn,
Mn,
Mn,
Cn,
Cn,
Mc,
Mc,
Mc,
Cn,
Mc,
Mc,
Mc,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mc,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mc,
Mc,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Mn,
Cn,
Cn,
Cn,
Cn,
Mc,
Mc,
Mc,
Mn,
Mn,
Mn,
Cn,
Mn,
Cn,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mc,
Mc,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_000e[256] =
{
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mn,
Lo,
Lo,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Sc,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lm,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Po,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Po,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Cn,
Lo,
Cn,
Cn,
Lo,
Lo,
Cn,
Lo,
Cn,
Cn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Cn,
Lo,
Cn,
Lo,
Cn,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Mn,
Lo,
Lo,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Mn,
Mn,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lm,
Cn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Cn,
Cn,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_000f[256] =
{
Lo,
So,
So,
So,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
So,
So,
So,
So,
So,
Mn,
Mn,
So,
So,
So,
So,
So,
So,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
So,
Mn,
So,
Mn,
So,
Mn,
Ps,
Pe,
Ps,
Pe,
Mc,
Mc,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mc,
Mn,
Mn,
Mn,
Mn,
Mn,
Po,
Mn,
Mn,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
Mn,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
So,
Po,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0010[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Cn,
Mc,
Mn,
Mn,
Mn,
Mn,
Mc,
Mn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mc,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Po,
Po,
Po,
Po,
Po,
Po,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mc,
Mc,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Po,
Lm,
Cn,
Cn,
Cn};
static unsigned char category_0011[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0012[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_0013[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Mn,
So,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0014[256] =
{
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_0015[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_0016[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Po,
Po,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Zs,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Ps,
Pe,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Po,
Po,
Po,
Nl,
Nl,
Nl,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0017[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mn,
Mn,
Mn,
Po,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Cn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cf,
Cf,
Mc,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mn,
Mc,
Mc,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Po,
Po,
Po,
Lm,
Po,
Po,
Po,
Sc,
Lo,
Mn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0018[256] =
{
Po,
Po,
Po,
Po,
Po,
Po,
Pd,
Po,
Po,
Po,
Po,
Mn,
Mn,
Mn,
Zs,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lm,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0019[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Mn,
Mn,
Mn,
Mc,
Mc,
Mc,
Mc,
Mn,
Mn,
Mc,
Mc,
Mc,
Cn,
Cn,
Cn,
Cn,
Mc,
Mc,
Mn,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
So,
Cn,
Cn,
Cn,
Po,
Po,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mc,
Mc,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Cn,
Cn,
Cn,
Cn,
Po,
Po,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So};
static unsigned char category_001a[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mn,
Mn,
Mc,
Mc,
Mc,
Cn,
Cn,
Po,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_001d[256] =
{
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Lm,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_001e[256] =
{
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Cn,
Cn,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_001f[256] =
{
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Lu,
Cn,
Lu,
Cn,
Lu,
Cn,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lt,
Lt,
Lt,
Lt,
Lt,
Lt,
Lt,
Lt,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lt,
Lt,
Lt,
Lt,
Lt,
Lt,
Lt,
Lt,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lt,
Lt,
Lt,
Lt,
Lt,
Lt,
Lt,
Lt,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lt,
Sk,
Ll,
Sk,
Sk,
Sk,
Ll,
Ll,
Ll,
Cn,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lt,
Sk,
Sk,
Sk,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Cn,
Sk,
Sk,
Sk,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Sk,
Sk,
Sk,
Cn,
Cn,
Ll,
Ll,
Ll,
Cn,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lt,
Sk,
Sk,
Cn};
static unsigned char category_0020[256] =
{
Zs,
Zs,
Zs,
Zs,
Zs,
Zs,
Zs,
Zs,
Zs,
Zs,
Zs,
Cf,
Cf,
Cf,
Cf,
Cf,
Pd,
Pd,
Pd,
Pd,
Pd,
Pd,
Po,
Po,
Pi,
Pf,
Ps,
Pi,
Pi,
Pf,
Ps,
Pi,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Zl,
Zp,
Cf,
Cf,
Cf,
Cf,
Cf,
Zs,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Pi,
Pf,
Po,
Po,
Po,
Po,
Pc,
Pc,
Po,
Po,
Po,
Sm,
Ps,
Pe,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Sm,
Po,
Pc,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Zs,
Cf,
Cf,
Cf,
Cf,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
No,
Ll,
Cn,
Cn,
No,
No,
No,
No,
No,
No,
Sm,
Sm,
Sm,
Ps,
Pe,
Ll,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
Sm,
Sm,
Sm,
Ps,
Pe,
Cn,
Lm,
Lm,
Lm,
Lm,
Lm,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Sc,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Me,
Me,
Me,
Me,
Mn,
Me,
Me,
Me,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0021[256] =
{
So,
So,
Lu,
So,
So,
So,
So,
Lu,
So,
So,
Ll,
Lu,
Lu,
Lu,
Ll,
Ll,
Lu,
Lu,
Lu,
Ll,
So,
Lu,
So,
So,
So,
Lu,
Lu,
Lu,
Lu,
Lu,
So,
So,
So,
So,
So,
So,
Lu,
So,
Lu,
So,
Lu,
So,
Lu,
Lu,
Lu,
Lu,
So,
Ll,
Lu,
Lu,
So,
Lu,
Ll,
Lo,
Lo,
Lo,
Lo,
Ll,
So,
So,
Ll,
Ll,
Lu,
Lu,
Sm,
Sm,
Sm,
Sm,
Sm,
Lu,
Ll,
Ll,
Ll,
Ll,
So,
Sm,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Sm,
Sm,
Sm,
Sm,
Sm,
So,
So,
So,
So,
So,
Sm,
Sm,
So,
So,
So,
So,
Sm,
So,
So,
Sm,
So,
So,
Sm,
So,
So,
So,
So,
So,
So,
So,
Sm,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
Sm,
So,
So,
Sm,
So,
Sm,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm};
static unsigned char category_0022[256] =
{
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm};
static unsigned char category_0023[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
Sm,
Sm,
Sm,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
Sm,
So,
So,
So,
So,
So,
So,
So,
Ps,
Pe,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Ps,
Pe,
Po,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0024[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No};
static unsigned char category_0025[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm};
static unsigned char category_0026[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Sm,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0027[256] =
{
Cn,
So,
So,
So,
So,
Cn,
So,
So,
So,
So,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
So,
Cn,
So,
So,
So,
So,
Cn,
Cn,
Cn,
So,
Cn,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
So,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Sm,
Sm,
Sm,
Sm,
Sm,
Ps,
Pe,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Cn,
Cn,
Cn,
Cn,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm};
static unsigned char category_0028[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So};
static unsigned char category_0029[256] =
{
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Ps,
Pe,
Ps,
Pe,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Ps,
Pe,
Sm,
Sm};
static unsigned char category_002a[256] =
{
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm,
Sm};
static unsigned char category_002b[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_002c[256] =
{
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Lu,
Ll,
Ll,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Po,
Po,
Po,
Po,
No,
Po,
Po};
static unsigned char category_002d[256] =
{
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lm,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_002e[256] =
{
Po,
Po,
Pi,
Pf,
Pi,
Pf,
Po,
Po,
Po,
Pi,
Pf,
Po,
Pi,
Pf,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Pd,
Cn,
Cn,
Cn,
Cn,
Pi,
Pf,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_002f[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0030[256] =
{
Zs,
Po,
Po,
Po,
So,
Lm,
Lo,
Nl,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
So,
So,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Pd,
Ps,
Pe,
Pe,
So,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Pd,
Lm,
Lm,
Lm,
Lm,
Lm,
So,
So,
Nl,
Nl,
Nl,
Lm,
Lo,
Po,
So,
So,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Mn,
Mn,
Sk,
Sk,
Lm,
Lm,
Lo,
Pd,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Po,
Lm,
Lm,
Lm,
Lo};
static unsigned char category_0031[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
So,
So,
No,
No,
No,
No,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_0032[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
So,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn};
static unsigned char category_0033[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So};
static unsigned char category_0034[256] =
{
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_004d[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So};
static unsigned char category_004e[256] =
{
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_009f[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00a0[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lm,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_00a1[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_00a2[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_00a3[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_00a4[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00a7[256] =
{
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Sk,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00a8[256] =
{
Lo,
Lo,
Mc,
Lo,
Lo,
Lo,
Mn,
Lo,
Lo,
Lo,
Lo,
Mn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Mc,
Mc,
Mn,
Mn,
Mc,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00ac[256] =
{
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00d7[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00d8[256] =
{
Cs,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00db[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cs,
Cs,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cs};
static unsigned char category_00dc[256] =
{
Cs,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00df[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cs};
static unsigned char category_00e0[256] =
{
Co,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00f8[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Co};
static unsigned char category_00f9[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_00fa[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_00fb[256] =
{
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Mn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Sm,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_00fc[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_00fd[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Ps,
Pe,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Sc,
So,
Cn,
Cn};
static unsigned char category_00fe[256] =
{
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Ps,
Pe,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Po,
Pd,
Pd,
Pc,
Pc,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Po,
Po,
Ps,
Pe,
Po,
Po,
Po,
Po,
Pc,
Pc,
Pc,
Po,
Po,
Po,
Cn,
Po,
Po,
Po,
Po,
Pd,
Ps,
Pe,
Ps,
Pe,
Ps,
Pe,
Po,
Po,
Po,
Sm,
Pd,
Sm,
Sm,
Sm,
Cn,
Po,
Sc,
Po,
Po,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cf};
static unsigned char category_00ff[256] =
{
Cn,
Po,
Po,
Po,
Sc,
Po,
Po,
Po,
Ps,
Pe,
Po,
Sm,
Po,
Pd,
Po,
Po,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Po,
Po,
Sm,
Sm,
Sm,
Po,
Po,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ps,
Po,
Pe,
Sk,
Pc,
Sk,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ps,
Sm,
Pe,
Sm,
Ps,
Pe,
Po,
Ps,
Pe,
Po,
Po,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lm,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lm,
Lm,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Sc,
Sc,
Sm,
Sk,
So,
Sc,
Sc,
Cn,
So,
Sm,
Sm,
Sm,
Sm,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cf,
Cf,
Cf,
So,
So,
Cn,
Cn};
static unsigned char category_0100[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0101[256] =
{
Po,
Po,
So,
Cn,
Cn,
Cn,
Cn,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
No,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
Nl,
No,
No,
No,
No,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
No,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0103[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
No,
No,
No,
No,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Nl,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Po,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
So,
Nl,
Nl,
Nl,
Nl,
Nl,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0104[256] =
{
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0108[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Cn,
Cn,
Cn,
Lo,
Cn,
Cn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_010a[256] =
{
Lo,
Mn,
Mn,
Mn,
Cn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mn,
Mn,
Lo,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Cn,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Mn,
No,
No,
No,
No,
No,
No,
No,
No,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Po,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_01d0[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_01d1[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Mc,
Mc,
Mn,
Mn,
Mn,
So,
So,
So,
Mc,
Mc,
Mc,
Mc,
Mc,
Mc,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
So,
So,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Mn,
Mn,
Mn,
Mn,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_01d2[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Mn,
Mn,
Mn,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_01d3[256] =
{
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
So,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_01d4[256] =
{
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Cn,
Lu,
Lu,
Cn,
Cn,
Lu,
Cn,
Cn,
Lu,
Lu,
Cn,
Cn,
Lu,
Lu,
Lu,
Lu,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Cn,
Ll,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll};
static unsigned char category_01d5[256] =
{
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Cn,
Lu,
Lu,
Lu,
Lu,
Cn,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Cn,
Lu,
Lu,
Lu,
Lu,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Lu,
Cn,
Cn,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Cn,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll};
static unsigned char category_01d6[256] =
{
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Sm,
Ll,
Ll,
Ll,
Ll};
static unsigned char category_01d7[256] =
{
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Lu,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Sm,
Ll,
Ll,
Ll,
Ll,
Ll,
Ll,
Cn,
Cn,
Cn,
Cn,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd,
Nd};
static unsigned char category_0200[256] =
{
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_02a6[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_02f8[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_02f9[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo};
static unsigned char category_02fa[256] =
{
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Lo,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0e00[256] =
{
Cn,
Cf,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cf,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0e01[256] =
{
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Mn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0f00[256] =
{
Co,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_0fff[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Co,
Cn,
Cn};
static unsigned char category_1000[256] =
{
Co,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char category_10ff[256] =
{
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Co,
Cn,
Cn};
static unsigned char category_xxxx[256] = {
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn,
Cn};
static unsigned char* category_table[] = { category_0000, category_0001, category_0002, category_0003, category_0004, category_0005, category_0006, category_0007, category_xxxx, category_0009, category_000a, category_000b, category_000c, category_000d, category_000e, category_000f, category_0010, category_0011, category_0012, category_0013, category_0014, category_0015, category_0016, category_0017, category_0018, category_0019, category_001a, category_xxxx, category_xxxx, category_001d, category_001e, category_001f, category_0020, category_0021, category_0022, category_0023, category_0024, category_0025, category_0026, category_0027, category_0028, category_0029, category_002a, category_002b, category_002c, category_002d, category_002e, category_002f, category_0030, category_0031, category_0032, category_0033, category_0034, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_004d, category_004e, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_009f, category_00a0, category_00a1, category_00a2, category_00a3, category_00a4, category_xxxx, category_xxxx, category_00a7, category_00a8, category_xxxx, category_xxxx, category_xxxx, category_00ac, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_00d7, category_00d8, category_xxxx, category_xxxx, category_00db, category_00dc, category_xxxx, category_xxxx, category_00df, category_00e0, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_00f8, category_00f9, category_00fa, category_00fb, category_00fc, category_00fd, category_00fe, category_00ff, category_0100, category_0101, category_xxxx, category_0103, category_0104, category_xxxx, category_xxxx, category_xxxx, category_0108, category_xxxx, category_010a, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_01d0, category_01d1, category_01d2, category_01d3, category_01d4, category_01d5, category_01d6, category_01d7, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_0200, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_02a6, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_02f8, category_02f9, category_02fa, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_0e00, category_0e01, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_0f00, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_0fff, category_1000, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_xxxx, category_10ff};
static unsigned char combining_class_0003[256] =
{
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
232,
220,
220,
220,
220,
232,
216,
220,
220,
220,
220,
220,
202,
202,
220,
220,
220,
220,
202,
202,
220,
220,
220,
220,
220,
220,
220,
220,
220,
220,
220,
1,
1,
1,
1,
1,
220,
220,
220,
220,
230,
230,
230,
230,
230,
230,
230,
230,
240,
230,
220,
220,
220,
230,
230,
230,
220,
220,
0,
230,
230,
230,
220,
220,
220,
220,
230,
232,
220,
220,
230,
233,
234,
234,
233,
234,
234,
233,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0004[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
230,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0005[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
220,
230,
230,
230,
230,
220,
230,
230,
230,
222,
220,
230,
230,
230,
230,
230,
230,
220,
220,
220,
220,
220,
220,
230,
230,
220,
230,
230,
222,
228,
230,
10,
11,
12,
13,
14,
15,
16,
17,
18,
19,
0,
20,
21,
22,
0,
23,
0,
24,
25,
0,
230,
220,
0,
18,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0006[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
230,
230,
230,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
27,
28,
29,
30,
31,
32,
33,
34,
230,
230,
220,
220,
230,
230,
230,
230,
230,
220,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
35,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
230,
230,
230,
230,
230,
230,
0,
0,
230,
230,
230,
230,
220,
230,
0,
0,
230,
230,
0,
220,
230,
230,
220,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0007[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
36,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
220,
230,
230,
220,
230,
230,
220,
220,
220,
230,
220,
220,
230,
220,
230,
230,
230,
220,
230,
220,
230,
220,
230,
220,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0009[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
7,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
230,
220,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
7,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_000a[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
7,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
7,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_000b[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
7,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_000c[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
84,
91,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
7,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_000d[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_000e[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
103,
103,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
107,
107,
107,
107,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
118,
118,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
122,
122,
122,
122,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_000f[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
220,
220,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
220,
0,
220,
0,
216,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
129,
130,
0,
132,
0,
0,
0,
0,
0,
130,
130,
130,
130,
0,
0,
130,
0,
230,
230,
9,
0,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
220,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0010[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
7,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0013[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0017[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0018[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
228,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0019[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
222,
230,
220,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_001a[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
220,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_001d[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
230,
220,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0020[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
230,
1,
1,
230,
230,
230,
230,
1,
1,
1,
230,
230,
0,
0,
0,
0,
230,
0,
0,
0,
1,
1,
230,
220,
230,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_0030[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
218,
228,
232,
222,
224,
224,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
8,
8,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_00a8[256] =
{
0,
0,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_00fb[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
26,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_00fe[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
230,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_010a[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
220,
0,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
1,
220,
0,
0,
0,
0,
9,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_01d1[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
216,
216,
1,
1,
1,
0,
0,
0,
226,
216,
216,
216,
216,
216,
0,
0,
0,
0,
0,
0,
0,
0,
220,
220,
220,
220,
220,
220,
220,
220,
0,
0,
230,
230,
230,
230,
230,
220,
220,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
230,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_01d2[256] =
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
230,
230,
230,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char combining_class_xxxx[256] = {
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
static unsigned char* combining_class_table[] = { combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_0003, combining_class_0004, combining_class_0005, combining_class_0006, combining_class_0007, combining_class_xxxx, combining_class_0009, combining_class_000a, combining_class_000b, combining_class_000c, combining_class_000d, combining_class_000e, combining_class_000f, combining_class_0010, combining_class_xxxx, combining_class_xxxx, combining_class_0013, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_0017, combining_class_0018, combining_class_0019, combining_class_001a, combining_class_xxxx, combining_class_xxxx, combining_class_001d, combining_class_xxxx, combining_class_xxxx, combining_class_0020, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_0030, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_00a8, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_00fb, combining_class_xxxx, combining_class_xxxx, combining_class_00fe, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_010a, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_01d1, combining_class_01d2, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx, combining_class_xxxx};
static unsigned char bidi_0000[256] =
{
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
S,
B,
S,
WS,
B,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
B,
B,
B,
S,
WS,
ON,
ON,
ET,
ET,
ET,
ON,
ON,
ON,
ON,
ON,
ES,
CS,
ES,
CS,
CS,
EN,
EN,
EN,
EN,
EN,
EN,
EN,
EN,
EN,
EN,
CS,
ON,
ON,
ON,
ON,
ON,
ON,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ON,
ON,
ON,
ON,
ON,
ON,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ON,
ON,
ON,
ON,
BN,
BN,
BN,
BN,
BN,
BN,
B,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
BN,
CS,
ON,
ET,
ET,
ET,
ET,
ON,
ON,
ON,
ON,
L,
ON,
ON,
BN,
ON,
ON,
ET,
ET,
EN,
EN,
ON,
L,
ON,
ON,
ON,
EN,
L,
ON,
ON,
ON,
ON,
ON,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ON,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ON,
L,
L,
L,
L,
L,
L,
L,
L};
static unsigned char bidi_0002[256] =
{
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ON,
ON,
L,
L,
L,
L,
L,
L,
L,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
L,
L,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
L,
L,
L,
L,
L,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
L,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON,
ON};
static unsigned char bidi_0003[256] =
{
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
L,
L,
L,
L,
ON,
ON,
L,
L,
L,
L,
L,
L,
L,
L,
ON,
L,
L,
L,
L,
L,
ON,
ON,
L,
ON,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ON,
L,
L,
L,
L,
L,
L,
L,
L,
L};
static unsigned char bidi_0004[256] =
{
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
NSM,
NSM,
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L};
static unsigned char bidi_0005[256] =
{
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ON,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
L,
NSM,
NSM,
NSM,
R,
NSM,
R,
NSM,
NSM,
R,
NSM,
NSM,
R,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
R,
L,
L,
L,
L,
L,
R,
R,
R,
R,
R,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L};
static unsigned char bidi_0006[256] =
{
AL,
AL,
AL,
AL,
L,
L,
L,
L,
L,
L,
L,
AL,
CS,
AL,
ON,
ON,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
L,
L,
L,
L,
L,
AL,
L,
L,
AL,
AL,
L,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
L,
L,
L,
L,
L,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
L,
AN,
AN,
AN,
AN,
AN,
AN,
AN,
AN,
AN,
AN,
ET,
AN,
AN,
AL,
AL,
AL,
NSM,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
AL,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
AL,
AL,
NSM,
NSM,
ON,
NSM,
NSM,
NSM,
NSM,
AL,
AL,
EN,
EN,
EN,
EN,
EN,
EN,
EN,
EN,
EN,
EN,
AL,
AL,
AL,
AL,
AL,
AL};
static unsigned char bidi_0007[256] =
{
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
L,
BN,
AL,
NSM,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
L,
L,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
AL,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
AL,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L};
static unsigned char bidi_0009[256] =
{
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
L,
L,
L,
L,
NSM,
L,
L,
L,
NSM,
NSM,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
NSM,
NSM,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ET,
ET,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L};
static unsigned char bidi_000a[256] =
{
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
NSM,
NSM,
L,
L,
L,
L,
NSM,
NSM,
L,
L,
NSM,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
NSM,
NSM,
NSM,
NSM,
NSM,
L,
NSM,
NSM,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ET,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L};
static unsigned char bidi_000b[256] =
{
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
NSM,
L,
NSM,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
ON,
ON,
ON,
ON,
ON,
ON,
ET,
ON,
L,
L,
L,
L,
L};
static unsigned char bidi_000c[256] =
{
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
NSM,
L,
L,
L,
L,
L,
NSM,
NSM,
NSM,
L,
NSM,
NSM,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L};
static unsigned char bidi_000d[256] =
{
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
NSM,
L,
NSM,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L};
static unsigned char bidi_000e[256] =
{
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
L,
NSM,
L,
L,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
NSM,
L,
L,
L,
L,
ET,
L,
L,
L,
L,
L,
L,
L,
NSM,
NSM,
NSM,
N