#===============================================================================
# Color menu and support routines
#

alpha::menu colorMenu 0.1 "137" global "" uninstall this-file

proc colorMenu {} {}

Menu -n $colorMenu -p colorMenuProc {
	{Menu -n Color -p colorMenuProc {
		black
		blue
		cyan
		green
		magenta
		red
		white
		yellow
		"(-"
		color_9
		color_10
		color_11
		color_12
		color_13
		color_14
		color_15
	}}

	{Menu -n Style -p colorMenuProc {
		"/B<U<Obold"
		condense
		extend
		italic
		normal
		outline
		shadow
		"underline"
	}}
	"(-"
	"/f<SredWord"
	"/f<S<IredMark"
	"/g<SblueWord"
	"/g<S<IblueMark"
	"/h<SgreenWord"
	"/h<S<IgreenMark"
	"underlineWord"
	"(-"
	"/H<UhyperText"
	"urlLink"
	"mailtoLink"
	"linkToFile"
	"/k<SlinkToMark"
	"/k<S<IlinkToFile&Mark"
	"(-"
	"listColors"
	"removeColors"
}
	
proc redWord {} { colorSelect 5 0 ; refresh }

proc blueWord {} { colorSelect 1 0 ; refresh }

proc greenWord {} { colorSelect 3 0 ; refresh }

proc redMark {} {
	colorSelect 5 0
	setNamedMark
	refresh
}
proc blueMark {} {
	colorSelect 1 0
	setNamedMark
	refresh
}
proc greenMark {} {
	colorSelect 3 0
	setNamedMark
	refresh
}

proc underlineWord {} {
	insertColorEscape [getPos] 15
	insertColorEscape [selEnd] 12
	refresh
}

proc colorMenuProc {menu item} {

	switch $item {
		black   {colorSelect $item 0}
		blue    {colorSelect $item 0}
		cyan    {colorSelect $item 0}
		green   {colorSelect $item 0}
		magenta {colorSelect $item 0}
		red     {colorSelect $item 0}
		white   {colorSelect $item 0}
		yellow  {colorSelect $item 0}
	
		bold      {colorSelect  $item 12}
		condense  {colorSelect  $item 12}
		extend    {colorSelect $item 12}
		italic    {colorSelect $item 12}
		normal    {colorSelect $item 12}
		outline   {colorSelect $item 12}
		shadow    {colorSelect $item 12}
		underline {colorSelect $item 12}	

		hyperText     {markAsHyper}
		listColors    {listColorEscapes}
		removeColors  {removeColorEscapes}
		
		default {eval $item}
	}
}

proc listColorEscapes {} {
	set colors [getColors]
	
	set res "    Pos  Code  Hypertext\n"
	foreach item $colors {
		set off [lindex $item 0]
		set code [lindex $item 1]
		set cmd [lreplace $item 0 1]
		if {[string length $cmd]>1} {
			append res [format "%7d  %3d  %s\n" $off $code $cmd]
		} else {
			append res [format "%7d  %3d\n" $off $code]
		}
	}
	
	if {[llength $colors]>0} {		
		new -n "* Color Codes *"
		insertText $res
		goto [minPos]
		catch {shrinkWindow 2}
		set win [win::Current]
		setWinInfo -w $win dirty 0
		setWinInfo -w $win read-only 1
	
	} else {
		message "No color codes found"
	}
}
	

#===============================================================================

set lastHyper {} 

proc markAsHyper {} {
	global lastHyper
	
	set from [getPos]
	set to [selEnd]
	if {$from == $to} {
		beep
		return
	}
	set lastHyper [prompt "Hyper-text?" $lastHyper]
	insertColorEscape $from 3
	insertColorEscape $from 15 $lastHyper
	insertColorEscape $to 12
	insertColorEscape $to 0
	refresh
}

proc colorSelect {ind ind2} {
	set from [getPos]
	set to [selEnd]
	
	insertColorEscape $from $ind
	insertColorEscape $to $ind2
}


proc linkToFile {{path {}} {from {}} {to {}}} {	
	global HOME
	if {$from == {}} { set from [getPos] }
	if {$to == {}} { set to [selEnd] }
	if {$from == $to} {
		beep
		return
	}

	if {$path == {}} {
		set path [getfile "Choose target of hyperlink:"]
		# make path relative to Alpha's home folder
		set qHome [quote::Regfind $HOME]
		regsub -- "$qHome" $path {$HOME} path
	}

	set cmd "edit -r -c \"$path\""
	insertColorEscape $from 3
	insertColorEscape $from 15 $cmd
	insertColorEscape $to 12
	insertColorEscape $to 0
	refresh
}

proc linkToMark {{mark {}} {from {}} {to {}}} {	
	if {$from == {}} { set from [getPos] }
	if {$to == {}} { set to [selEnd] }
	if {$from == $to} {
		beep
		return
	}
	
	set mark [listpick -p "Choose a Mark:" -L [list $mark] [getNamedMarks -n]]

	set cmd "gotoMark \"$mark\""
	insertColorEscape $from 3
	insertColorEscape $from 15 $cmd
	insertColorEscape $to 12
	insertColorEscape $to 0
	refresh
}

proc urlLink {{from {}} {to {}}} {	
	if {$from == {}} { set from [getPos] }
	if {$to == {}} { set to [selEnd] }
	if {$from == $to} {
		beep
		return
	}

	set text [getText $from $to]

	set cmd "icURL \"$text\""
	insertColorEscape $from 3
	insertColorEscape $from 15 $cmd
	insertColorEscape $to 12
	insertColorEscape $to 0
	refresh
}

proc mailtoLink {{from {}} {to {}}} {	
	if {$from == {}} { set from [getPos] }
	if {$to == {}} { set to [selEnd] }
	if {$from == $to} {
		beep
		return
	}

	set text [getText $from $to]

	set cmd "icURL \"mailto:$text\""
	insertColorEscape $from 3
	insertColorEscape $from 15 $cmd
	insertColorEscape $to 12
	insertColorEscape $to 0
	refresh
}

proc linkToFile&Mark {{path {}} {mark {}} {from {}} {to {}}} {
	global HOME
	if {$from == {}} { set from [getPos] }
	if {$to == {}} { set to [selEnd] }
	if {$from == $to} {
		beep
		return
	}
	
	if {$path == {}} {
		set path [getfile "Choose a file:"]
		# make path relative to Alpha's home folder
		set qHome [quote::Regfind $HOME]
		regsub -- "$qHome" $path [quote::Regsub $HOME] fpath
		regsub -- "$qHome" $path {$HOME} path
	}

	set current [win::Current]
	
	if {![catch {file::openQuietly $fpath}]} {
		
		set mark [listpick -p "Choose a mark in that file:" -L [list $mark] [getNamedMarks -n -w $fpath]]
		
		bringToFront $current
		
		set cmd "edit -r -c \"$path\" ; gotoMark \"$mark\""
		insertColorEscape $from 3
		insertColorEscape $from 15 $cmd
		insertColorEscape $to 12
		insertColorEscape $to 0
		refresh
	}
}

proc listNamedMarks {} {

	set nm [win::Current]
	
	set res "    Pos    Disp     End  Name\n"
	append res "------- ------- -------  --------------------\n"
	foreach mk [getNamedMarks] {
		set name [lindex $mk 0]
		set disp [lindex $mk 2]
		set pos [lindex $mk 3]
		set end [lindex $mk 4]
		append res [format "%7d %7d %7d  %s\n" $pos $disp $end $name]
	}
	
	if {[llength [getNamedMarks]]>0} {		
		new -n "* Named Marks *"
		insertText $res
		goto [minPos]
		catch {shrinkWindow 2}
		set win [win::Current]
		setWinInfo -w $win dirty 0
		setWinInfo -w $win read-only 1
	
	} else {
		message "No color codes found"
	}
}

