## -*-Tcl-*- (install)
 # ###################################################################
 # 
 #  FILE: "copyRing.tcl"
 #				    created: 3/11/94 {9:52:00 am} 
 #				last update: 13/4/1999 {1:53:39 pm} 
 #				
 # Implementation of Emacs's kill ring. This is a paste ring.
 # 
 # Package modified by Dominique d'Humieres
 # E-mail: <dominiq@physique.ens.fr>
 # following ideas from Juan Falgueras
 # E-mail: <juanfc@lcc.uma.es>
 # 
 # Various notes:
 # 
 # 1) To get the new 'smartCutPaste' behavior in TeX mode, the 'wordBreak'
 # must be set to '([\w:-]+|\\(\\|[a-zA-Z]+)\*?|\\[^a-zA-Z*\t\r\n\s])'.
 #
 # 2) If you prefer the old 'smartCutPaste' behavior, uncomment the last
 # commented paragraph at the end of the file. 
 # If you want to remove it, delete the code between '' and the lines:
 # 
 #  # To insert/remove spaces to ensure a single space between words when
 #  # cutting or pasting, click this box||To cut/paste precisely what is 
 #  # selected, click this box.
 #  newPref flag smartCutPaste 1
 #  lappend flagPrefs(Text) smartCutPaste
 #  
 # ###################################################################
 ##

alpha::feature copyRing 0.1.7 global {
    # To insert/remove spaces to ensure a single space between words when
    # cutting or pasting, click this box||To cut/paste precisely what is 
    # selected, click this box.
    newPref flag smartCutPaste 1
    lappend flagPrefs(Text) smartCutPaste
} {
    menu::replaceWith Edit "/X<Scut" items "/X<Scut" "/X<S<I<Ocut&Append"
    menu::replaceWith Edit "/C<Scopy" items "/C<Scopy" "/C<S<I<Ocopy&Append"
    menu::replaceWith Edit "/V<Spaste" items "/V<Spaste" "/V<S<I<OpastePop"
    if {[info commands copyringCopy] == ""} {
	set renamedRing 1
	rename copy copyringCopy
	rename cut copyringCut
	rename paste copyringPaste
    }
    # to force loading of procs below
    auto_load copy&Append
    hook::register requireOpenWindowsHook [list Edit cut&Append] 1
    hook::register requireOpenWindowsHook [list Edit copy&Append] 1
    hook::register requireOpenWindowsHook [list Edit pastePop] 1
} {
    set renamedRing 0
    rename copy ""
    rename paste ""
    rename cut ""
    rename copyringCopy copy
    rename copyringCut cut
    rename copyringPaste paste
    # so if we turn it on again we reload this file
    rename copy&Append ""
    hook::deregister requireOpenWindowsHook [list Edit cut&Append] 1
    hook::deregister requireOpenWindowsHook [list Edit copy&Append] 1
    hook::deregister requireOpenWindowsHook [list Edit pastePop] 1
} help {
    Provides an implementation of a copy/paste ring.
}

set ringDepth	5
set ringIn	0
set ringOut	0
set pasteStart	0
set pasteFinish	0

proc copy&Append {} {
    set old [getScrap]
    putScrap "$old[getSelect]"
    message "Appended"
}

proc cut&Append {} {
    global smartCutPaste

    set old [getScrap]
    set text [getSelect]
    putScrap "$old[getSelect]"
    deleteText [getPos] [selEnd]

#  If you don't want 'smartCutPaste' delete text from the previous bullet
#   to the next one
#
    if {[string trim "$text"] == "$text"} {
	set gP [getPos]
	if {$smartCutPaste} {
	    if {[isNoWord $gP]} {
		if {[isWhite [pos::math $gP - 1]] && \
		    [isWordPrev  [pos::math $gP - 2]]} {
		    backSpace
		} else {
		    if {[isWhite $gP]} {
			deleteChar
		    }
		}
	    }
	}
    }
# 
    message "Appended"
}

proc cut {{rect 0}} {
    global copyring ringDepth ringIn smartCutPaste

    if {[pos::compare [getPos] == [selEnd]]} {
	if {[pos::compare [getMark] < [getPos]]} {
	    set text [getText [getMark] [getPos]]
	} else {
	    set text [getText [getPos] [getMark]]
	}
	if {![string length $text]} return
    } else {
	set text [getSelect]
    }

    set copyring([expr {$ringIn % $ringDepth}]) $text
    incr ringIn

    copyringCut

#  If you don't want 'smartCutPaste' delete text from the previous bullet
#   to the next one
#
    if {[string trim "$text"] == "$text"} {
	set gP [getPos]
	if {$smartCutPaste && !$rect} {
	    if {[isNoWord $gP]} {
		if {[isWhite [pos::math $gP - 1]] && \
		    [isWordPrev  [pos::math $gP - 2]]} {
		    backSpace
		} else {
		    if {[isWhite $gP]} {
			deleteChar
		    }
		}
	    }
	}
    }
# 
}

proc copy {} {
    global copyring ringDepth ringIn
    
    if {[pos::compare [getPos] == [selEnd]]} {
	if {[pos::compare [getMark] < [getPos]]} {
	    set text [getText [getMark] [getPos]]
	} else {
	    set text [getText [getPos] [getMark]]
	}
	if {![string length $text]} return
    } else {
	set text [getSelect]
    }
    
    set copyring([expr {$ringIn % $ringDepth}]) $text
    incr ringIn
    
    copyringCopy
}

proc paste {{rect 0}} {
    global copyring ringDepth ringIn ringOut smartCutPaste pasteStart \
      pasteFinish
    set intel 0
    set ins 0
    set ringOut [expr {($ringIn - 1) % $ringDepth}]
    
#  If you don't want 'smartCutPaste' delete text from the previous bullet
#   to the next one
#
    if {!$rect && $smartCutPaste} {
	set scrap [getScrap]
	if {[isWhite [selEnd]] && [isWordPrev [pos::math [getPos] - 1]]\
	  && ([string trimleft $scrap] == $scrap)} {
	    clear
	    insertText " "
	    set ins 1
	} elseif {[isWhite [pos::math [getPos] -1]] && [isWordNext [selEnd]]\
	  && ([string trimright $scrap] == $scrap)} {
	    set intel 1
	}
    }
# 
    copyringPaste
    set pasteStart [pos::math [getMark] - $ins]
    if {$intel} {insertText " "}
    set pasteFinish [getPos]
}
   
proc pastePop {} {
    global copyring ringDepth ringIn ringOut pasteFinish pasteStart \
      pasteScrap smartCutPaste
    
    if {!$ringIn} { beep; return}
    
    set ringOut [expr {$ringOut-1}]
    if {$ringOut < 0} {
	set ringOut [expr {(($ringDepth > $ringIn) ? $ringIn : $ringDepth) -1}]
    }
    
    set scrap $copyring($ringOut)
    
#  If you don't want 'smartCutPaste' delete text from the previous bullet
#   to the next one
#
    if {$smartCutPaste} {
	if {[isWhite $pasteFinish] && [isWordPrev [pos::math $pasteStart - 1]]\
	  && ([string trimleft $scrap] == $scrap)} {
	    set scrap " $scrap"
	} elseif {[isWhite [pos::math $pasteStart -1]] \
	  && [isWordNext $pasteFinish]\
	  && ([string trimright $scrap] == $scrap)} {
	    set scrap "$scrap "
	}
    }
# 
    set pasteScrap $scrap
    copyringReplace
    set pasteStart [getMark]
    set pasteFinish [getPos]
}

proc copyringReplace {} {
    global pasteFinish pasteStart pasteScrap
    
    replaceText $pasteStart $pasteFinish $pasteScrap
}
	       
	       
proc isWhite {p} {
    if {[pos::compare $p < [minPos]]} {
	set scrap [getScrap]
	if {([string trimright $scrap] == $scrap)} {
	    return 1
	} else {
	    return 0
	}
    } else {
	return [expr {([lookAt $p] == " ") || ([lookAt $p] == "\t")}]
    }
}

proc isChar {p} {
    return [expr {[string match {[a-z]} [lookAt $p]]}]
}

proc isWord {p} {
    global wordBreak
    return [regexp "$wordBreak" [lookAt $p]]
}

proc isNoWord {p} {
    global wordBreakPreface
    return [regexp "$wordBreakPreface" [lookAt $p]]
}

proc isWordNext {p} {
    global wordBreak
    if {[pos::compare $p < [maxPos]]} {
	if {[regexp "$wordBreak" [lookAt $p]]} {
	    return 1
	} elseif {[pos::compare [pos::math $p + 1] < [maxPos]]} {
	    set txt [getText $p [pos::math $p + 2]]	
	    if {[regexp "^$wordBreak" $txt]} {
		return 1
	    } elseif {[pos::compare [pos::math $p + 2] < [maxPos]]} {
		set txt [getText $p [pos::math $p + 3]]	
		return [regexp "^$wordBreak" $txt]
	    }
	}
    }
    return 0
}

proc isWordPrev {p} {
    global wordBreak
    global wordBreak
    if {[pos::compare $p > [minPos]]} {
	if {[regexp "$wordBreak" [lookAt $p]]} {
	    return 1
	} elseif {[pos::compare [pos::math $p] > [minPos]]} {
	    set txt [getText [pos::math $p - 1] [pos::math $p + 1]]	
	    if {[regexp "^$wordBreak\$" $txt]} {
		return 1
	    } elseif {[pos::compare [pos::math $p - 1] > [minPos]]} {
		set txt [getText [pos::math $p - 2] [pos::math $p + 1]]	
		return [regexp "^$wordBreak\$" $txt]
	    }
	}
    }
    return 0
}

#
#   If you prefer the previous 'smartCutPaste' behavior uncomment the 
#   following paragraphs.
#

## 
 # proc isNoWord {p} {
 #     return [isWhite $p]
 # }
 # 
 # proc isWordNext {p} {
 #     return [isChar $p]
 # }
 # 
 # proc isWordPrev {p} {
 #     return [isChar $p]
 # }
 ##

