## -*-Tcl-*- (install)
 # ###################################################################
 #  Alpha - new Tcl folder configuration
 #
 #  FILE: "recentFiles.tcl"
 #                                    created: 21/9/97 {9:14:38 pm}
 #                                last update: 09/02/1999 {12:07:40 PM}
 #
 # Reorganisation carried out by Vince Darley with much help from Tom
 # Fetherston, Johan Linde and suggestions from the Alpha-D mailing list.
 # Alpha is shareware; please register with the author using the register
 # button in the about box.
 #
 # original author probably Pete Keleher.  Vince added a bunch of
 # code to work-around some Alpha-menu problems, and made it a
 # package.
 #
 # Version 0.2 builds the menu about a zillion times faster than
 # the original which built the menu once for every item at
 # startup!  Also removed two unnecessary procs, since that stuff
 # can be done elsewhere automatically.  Recently added lots of
 # nice new features, and placed all prefs in the packages menu.
 # ###################################################################
 ##

alpha::extension recentFilesMenu 0.4b6 {
    namespace eval recent {}
    ensureset recent::Files ""
    hook::register saveasHook recent::push
    hook::register openHook recent::push
    hook::register closeHook recent::push
    menu::buildProc recent recent::makeMenu
    menu::insert File submenu 2 recent
    lappend modifiedVars recent::Files
    # declare the fileset
    set "gfileSetsType(Recent Files)" "procedural"
    set "gfileSets(Recent Files)" recent::listFiles
    lunion filesetsNotInMenu "Recent Files"
    package::addPrefsDialog recentFilesMenu
} help {
    Adds a menu of recent files to the files menu, and a recent files fileset
}

foreach var {numberOfRecentFiles orderRecentFilesBy editLastUsedFile} {
    if {[info exists $var]} {
	set recentFilesMenumodeVars($var) [set $var]
	lappend modifiedVars $var
	lappend modifiedArrayElements [list $var recentFilesMenumodeVars]
	unset $var
    }
}
unset var

# The number of files to list in the 'Files->Recent' menu.
newPref variable numberOfRecentFiles 15 recentFilesMenu
# The ordering scheme for items in the recent files menu.
newPref variable orderRecentFilesBy 0 recentFilesMenu recent::makeMenu [list \
  "Alphabetical Order" "Date"] index
# Use this key binding to edit the most recently used file.
newPref binding editLastUsedFile "" recentFilesMenu "" recent::editLastFile

# To show each copy of files with the same name, by identifying them with
# their disk location, click this box.||To list only the most recent version
# of all files with the same name, click this box.
newPref flag showDistinctDuplicates 1 recentFilesMenu

##
 # -------------------------------------------------------------------------
 #
 # "recent::push" --
 #
 #  Works with files whose name contained '[' or ']' which didn't before.
 #  Doesn't add any file which fails 'file exists' to the menu.
 # -------------------------------------------------------------------------
 ##
proc recent::push {name {name2 ""}} {
    if {$name2 != ""} { set name $name2 }
    global recent::Files recentFilesMenumodeVars file::separator

    regsub { <[0-9]+>$} $name {} name
    if {![file exists $name]} { return }
    set name [file nativename $name]
    if {$recentFilesMenumodeVars(showDistinctDuplicates)} {
	if {[set ind [lsearch -exact ${recent::Files} $name]] >= 0} {
	    set recent::Files [lreplace ${recent::Files} $ind $ind]
	    lappend recent::Files $name
	    if {$recentFilesMenumodeVars(orderRecentFilesBy)} {recent::makeMenu}
	    return
	}
    } else {
	if {[info tclversion] < 8.0} {
	    regsub -all {\\([][])} $name {\1} name
	    # this weird search handles a variety of unusual problems with
	    # Alpha's interpretation of menu items.
	    if {[info exists recent::Files] \
	      && ([set ind [lsearch -regexp ${recent::Files} "${file::separator}[quote::Regfind [file tail $name]]?$"]] >= 0)} {
		set recent::Files [lreplace ${recent::Files} $ind $ind]
		lappend recent::Files $name
		if {$recentFilesMenumodeVars(orderRecentFilesBy)} {recent::makeMenu}
		return
	    }
	} else {
	    if {[info exists recent::Files] \
	      && ([set ind [lsearch -exact ${recent::Files} $name]] >= 0)} {
		set recent::Files [lreplace ${recent::Files} $ind $ind]
		lappend recent::Files $name
		if {$recentFilesMenumodeVars(orderRecentFilesBy)} {recent::makeMenu}
		return
	    }
	    set ind 0
	    foreach f $recent::Files {
		# perhaps we ought to test also for complications due to
		# files which end in ''.
		if {[file tail $f] == [file tail $name]} {
		    set recent::Files [lreplace ${recent::Files} $ind $ind]
		    lappend recent::Files $name
		    if {$recentFilesMenumodeVars(orderRecentFilesBy)} {recent::makeMenu}
		    return
		}
		incr ind
	    }
	}
    }

    lappend recent::Files $name
    if {[llength ${recent::Files}] > $recentFilesMenumodeVars(numberOfRecentFiles)} {
	set recent::Files [lrange ${recent::Files} 1 end]
    }
    recent::makeMenu
}

proc recent::makeMenu {args} {
    global recentFilesMenumodeVars recent::Files file::separator
    set menulist {}

    if {$recentFilesMenumodeVars(showDistinctDuplicates)} {
	set filelist [set recent::Files]
	set level 1
	while {1} {
	    foreach t $filelist {
		if {![file exists $t]} {continue}
		set llen [llength [set tail [file split $t]]]
		if {$llen < $level} {
		    # We've exceeded the top-level.  Must be an odd problem!
		    # Discard this problematic file.
		    continue
		}
		set tail [join [lrange $tail [expr {$llen - $level}] end] ${file::separator}]
		if {[info exists name($tail)]} {
		    lappend remaining $name($tail)
		    lappend remaining $t
		    set dup($tail) 1
		    set first [lsearch -exact $menulist $tail]
		    set menulist [lreplace $menulist $first $first $name($tail)]
		    if {$level==1} {
			lappend menulist $t
		    }
		    unset name($tail)
		} elseif {[info exists dup($tail)]} {
		    lappend remaining $t
		    if {$level==1} {
			lappend menulist $t
		    }
		} else {
		    set name($tail) $t
		    if {$level==1} {
			lappend menulist $tail
		    } else {
			set toolong [lsearch -exact $menulist $t]
			set menulist [lreplace $menulist $toolong $toolong $tail]
		    }
		}
	    }
	    if {![info exists remaining]} {
		break
	    }
	    incr level
	    set filelist $remaining
	    unset remaining
	    unset dup
	}

    } else {
	foreach t ${recent::Files} {
	    if {[file exists $t]} {
		lappend menulist [file tail $t]
	    }
	    # else we just let the file disappear through lack of use
	}
    }

    if {$recentFilesMenumodeVars(orderRecentFilesBy)} {
	Menu -m -c -n recent -p recent::menuProc \
	  [concat [lreverse $menulist] [list "(-" "Reset List"]]
    } else {
	Menu -m -c -n recent -p recent::menuProc \
	  [concat [lsort -ignore $menulist] [list "(-" "Reset List"]]
    }
    set enable [expr [llength $menulist] ? 1 : 0]
    enableMenuItem File recent $enable
}

##
 # -------------------------------------------------------------------------
 #
 # "recent::menuProc" --
 #
 #  Works with menu items which contain '[', ']' and '' which didn't work
 #  before.
 # -------------------------------------------------------------------------
 ##
proc recent::menuProc {menu name} {
    global recent::Files file::separator

    if {$name == "Reset List"} {
	set recent::Files {}
	Menu -m -n recent -p recent::menuProc {}
	recent::makeMenu
    } else {
	set f [file::pathEndsWith $name ${recent::Files}]
	if {$f != ""} {
	    edit $f
	    return
	}
	dialog::errorAlert "Couldn't find a file '$name'.  Weird!"
    }
}

##
 # -------------------------------------------------------------------------
 #
 # "recent::listFiles" --
 #
 #  Used to retrieve the list of files in the 'recent files' fileset
 # -------------------------------------------------------------------------
 ##
proc recent::listFiles {} {
    global recent::Files
    return ${recent::Files}
}

proc recent::editLastFile {} {
    global recent::Files
    if {[set rl [llength ${recent::Files}]]} {
	incr rl -1
	edit -c -w [lindex ${recent::Files} $rl]
    }
}
