/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl	 
 * 
 *	FILE: "cpptclextraInt.h"
 *								   created:	28/5/96 {8:42:37 pm}
 *								   last	update:	31/10/97 {4:56:00 pm}
 *	 Author:  Vince	Darley 
 *	 E-mail:  darley@fas.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 		Basic definitions and typedefs.
 * 
 * ###################################################################
 */

#ifndef _Cpptcl_cpptclextraInt_
#define _Cpptcl_cpptclextraInt_

//#define DEBUG_PRINT
/* #define NDEBUG */

#include "cpptclInt.h"

// not really used right now
/*
typedef int object_list;
typedef int object_text_id;
const int empty_object_list = 0;

class cpx_base;
	class tcl_object;
	class cpx_object;

class cpx_error;

class info_base;
	class info_event;
	class info_socket;
	class info_gatherer;
	class info_source;
*/

//@Section: Cpptclextra library
//@Man: Simple macros and typedefs
//@{

///
struct cpx_error  {
	/// Error return for cpx
	#ifdef MAC_TCL
	typedef enum error_type  { OK=0, WARNING =1, ERROR=2, BIG_PROBLEM=3 } error_type;
	#else
	enum error_type  { OK=0, WARNING =1, ERRORR=2, BIG_PROBLEM=3 };
	typedef error_type error_type;
	#endif
	
	///
	error_type error;
	///
	char* problem;
	///
	char* more_detail;

	///
	operator error_type () { return error;}
	///
	operator int () { return (int) error;}
	///
	cpx_error(error_type e);
	///
	cpx_error(error_type e, char* problem, char *more_detail=0);	
};

class tcl_object;

//@Man: Events and sockets
//@{
/** 
 * Types of	pointer	to member functions
 * for events and sockets.
 */
///
typedef void (tcl_object::*event_fn)(void);
///
typedef void (tcl_object::*socket_fn) (tcl_object*);
//@}

/// Used for turning archival on or off.
typedef enum archive_type { ARCHIVE=0, ON, OFF } archive_type;


//@}

//typedef int object_text_list;

#ifdef __MWERKS__
#ifdef __MACOS__
#pragma cpp_extensions on
#include <ansi_prefix.mac.h>
#endif
#endif

//const double Pi = 3.14159265358979323846264338327950288;

//void time_consuming_operation(void);

#endif
