/*	-*-C++-*-
 *	###################################################################
 *  Cpptcl - integrating C++ with Tcl
 *	
 *	 FILE: "cpptcl_type_t.cc"
 *												  created: 24/7/96 {3:23:03 pm} 
 *											 last update: 19/11/97 {1:57:22 pm} 
 *	 Author:	Vince	Darley
 *	 E-mail:	<darley@fas.harvard.edu>
 *		mail:	Division	of	Applied Sciences,	Harvard University
 *				Oxford Street,	Cambridge MA 02138, USA
 *		 www:	<http://www.fas.harvard.edu/~darley/>
 *	 
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *	###################################################################
 */


// This lets us read directly into any cpx type.  You'll have to
// make sure the template function is generated for each type you
// use in this way. 'T' can be cpx_object, info_event, topology, ...
// and any class you derive yourself.  Now you can do this:
// 		my_class* m;  arg >> m >> done; 
// and you can assume 'm' is a real meta_object of type 'my_class'
// because otherwise an error will have been generated!
#ifdef __MWERKS__
template <class T> tcl_args& operator >> (tcl_args& arg, T*& t);
#else
template <class T> tcl_args& cpx_args_read(tcl_args& arg, T*& into, const char*);

template <class T> tcl_args& operator >> (tcl_args& arg, T*& t){
	return cpx_args_read(arg, t, T::_type);
}
#endif