/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "tcl_args_ts.cc"
 *									  created: 11/5/96 {8:46:56 pm}	
 *								  last update: 16/12/97 {10:26:22 am}	
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Template Specialisations:   See	header file	for	further	information
 * ###################################################################
 */

#include "tcl_args.h"

// to be replaced by RTTI eventually.
const char* GETTYPE(int&);
const char* GETTYPE(bool&);
const char* GETTYPE(long&);
const char* GETTYPE(float&);
const char* GETTYPE(double&);
const char* GETTYPE(char&);
const char* GETTYPE(Tcl_Obj*&);

const char* GETTYPE(int&) {return "int";}
const char* GETTYPE(bool&) {return "bool";}
const char* GETTYPE(long&) {return "long";}
const char* GETTYPE(float&) {return "float";}
const char* GETTYPE(double&) {return "double";}
const char* GETTYPE(char&) {return "char";}
const char* GETTYPE(Tcl_Obj*&) {return "Tcl_Obj";}

tcl_args& operator >> (tcl_args& arg, bool& v){
	arg.set_conversion_type("bool");
	const char* buf = 0;
	arg.const_string_read(buf);

	if(buf){
		int readbool;
		int res = Tcl_GetBoolean(arg.interpreter(),(char*) buf, &readbool);
		if(res == TCL_ERROR) {
			arg.signal_error(tcl_args::Conversion);
		}
		v = (readbool ? true : false);
	}
	arg.read_done();
	return arg;
}

tcl_args& operator >> (tcl_args& arg, char*& v){
	arg.set_conversion_type("char*");
	if(arg.is_optional_arg() && !arg.args_left()) {
		v = 0;
		arg.pretend_read_from_me();
	} else {
		arg.check_read().copy_arg(v);
		arg.check_after();
		arg.parsed_so_far << v;
	}	
	arg.read_done();
	return arg;
}	

tcl_args& operator >> (tcl_args& arg ,const char*& v){
	arg.set_conversion_type("const char*");
	arg.const_string_read(v);
	if(v){
		arg.parsed_so_far << v;
	}	
	arg.read_done();
	return arg;
}	

#ifdef __MWERKS__
// mwerks gives me absolutely crazy link errors using dll's on windows
// when I only use the template versions of these functions!
tcl_args& operator>> (tcl_args& arg, int& into){
	arg.set_conversion_type(GETTYPE(into));
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		arg.check_read() >> into;
		arg.check_after();
		arg.parsed_so_far << into;
		arg.read_done();
	}
	
	return arg;
}

tcl_args& operator>> (tcl_args& arg, float& into){
	arg.set_conversion_type(GETTYPE(into));
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		arg.check_read() >> into;
		arg.check_after();
		arg.parsed_so_far << into;
		arg.read_done();
	}
	
	return arg;
}

tcl_args& operator>> (tcl_args& arg, double& into){
	arg.set_conversion_type(GETTYPE(into));
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		arg.check_read() >> into;
		arg.check_after();
		arg.parsed_so_far << into;
		arg.read_done();
	}
	
	return arg;
}

tcl_args& operator>> (tcl_args& arg, long& into){
	arg.set_conversion_type(GETTYPE(into));
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		arg.check_read() >> into;
		arg.check_after();
		arg.parsed_so_far << into;
		arg.read_done();
	}
	
	return arg;
}

tcl_args& operator>> (tcl_args& arg, char& into){
	arg.set_conversion_type(GETTYPE(into));
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		arg.check_read() >> into;
		arg.check_after();
		arg.parsed_so_far << into;
		arg.read_done();
	}
	
	return arg;
}
tcl_args& operator>> (tcl_args& arg, Tcl_Obj*& into){
	arg.set_conversion_type(GETTYPE(into));
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		arg.check_read() >> into;
		arg.check_after();
		arg.parsed_so_far << into;
		arg.read_done();
	}
	
	return arg;
}

#endif
