		What has changed in GDB?
	     (Organized release by release)

*** Changes in GDB-4.16:

* New native configurations

Windows 95, x86 Windows NT			i[345]86-*-cygwin32
M68K NetBSD					m68k-*-netbsd*
PowerPC AIX 4.x					powerpc-*-aix*
PowerPC MacOS					powerpc-*-macos*
PowerPC Windows NT				powerpcle-*-cygwin32
RS/6000 AIX 4.x					rs6000-*-aix4*

* New targets

ARM with RDP protocol				arm-*-*
I960 with MON960				i960-*-coff
MIPS VxWorks					mips*-*-vxworks*
MIPS VR4300 with PMON				mips64*vr4300{,el}-*-elf*
PowerPC with PPCBUG monitor			powerpc{,le}-*-eabi*
Hitachi SH3					sh-*-*
Matra Sparclet					sparclet-*-*

* PowerPC simulator

The powerpc-eabi configuration now includes the PSIM simulator,
contributed by Andrew Cagney, with assistance from Mike Meissner.
PSIM is a very elaborate model of the PowerPC, including not only
basic instruction set execution, but also details of execution unit
performance and I/O hardware.  See sim/ppc/README for more details.

* Solaris 2.5

GDB now works with Solaris 2.5.

* Windows 95/NT native

GDB will now work as a native debugger on Windows 95 and Windows NT.
To build it from source, you must use the "gnu-win32" environment,
which uses a DLL to emulate enough of Unix to run the GNU tools.
Further information, binaries, and sources are available at
ftp.cygnus.com, under pub/gnu-win32.

* dont-repeat command

If a user-defined command includes the command `dont-repeat', then the
command will not be repeated if the user just types return.  This is
useful if the command is time-consuming to run, so that accidental
extra keystrokes don't run the same command many times.

* Send break instead of ^C

The standard remote protocol now includes an option to send a break
rather than a ^C to the target in order to interrupt it.  By default,
GDB will send ^C; to send a break, set the variable `remotebreak' to 1.

* Remote protocol timeout

The standard remote protocol includes a new variable `remotetimeout'
that allows you to set the number of seconds before GDB gives up trying
to read from the target.  The default value is 2.

* Automatic tracking of dynamic object loading (HPUX and Solaris only)

By default GDB will automatically keep track of objects as they are
loaded and unloaded by the dynamic linker.  By using the command `set
stop-on-solib-events 1' you can arrange for GDB to stop the inferior
when shared library events occur, thus allowing you to set breakpoints
in shared libraries which are explicitly loaded by the inferior.

Note this feature does not work on hpux8.  On hpux9 you must link
/usr/lib/end.o into your program.  This feature should work
automatically on hpux10.

* Irix 5.x hardware watchpoint support

Irix 5 configurations now support the use of hardware watchpoints.

* Mips protocol "SYN garbage limit"

When debugging a Mips target using the `target mips' protocol, you
may set the number of characters that GDB will ignore by setting
the `syn-garbage-limit'.  A value of -1 means that GDB will ignore
every character.  The default value is 1050.

* Recording and replaying remote debug sessions

If you set `remotelogfile' to the name of a file, gdb will write to it
a recording of a remote debug session.  This recording may then be
replayed back to gdb using "gdbreplay".  See gdbserver/README for
details.  This is useful when you have a problem with GDB while doing
remote debugging; you can make a recording of the session and send it
to someone else, who can then recreate the problem.

* Speedups for remote debugging

GDB includes speedups for downloading and stepping MIPS systems using
the IDT monitor, fast downloads to the Hitachi SH E7000 emulator,
and more efficient S-record downloading.

* Memory use reductions and statistics collection

GDB now uses less memory and reports statistics about memory usage.
Try the `maint print statistics' command, for example.

*** Changes in GDB-4.15:

* Psymtabs for XCOFF

The symbol reader for AIX GDB now uses partial symbol tables.  This
can greatly improve startup time, especially for large executables.

* Remote targets use caching

Remote targets now use a data cache to speed up communication with the
remote side.  The data cache could lead to incorrect results because
it doesn't know about volatile variables, thus making it impossible to
debug targets which use memory mapped I/O devices. `set remotecache
off' turns the the data cache off.

* Remote targets may have threads

The standard remote protocol now includes support for multiple threads
in the target system, using new protocol commands 'H' and 'T'.  See
gdb/remote.c for details.

* NetROM support

If GDB is configured with `--enable-netrom', then it will include
support for the NetROM ROM emulator from XLNT Designs.  The NetROM
acts as though it is a bank of ROM on the target board, but you can
write into it over the network.  GDB's support consists only of
support for fast loading into the emulated ROM; to debug, you must use
another protocol, such as standard remote protocol.  The usual
sequence is something like

	target nrom <netrom-hostname>
	load <prog>
	target remote <netrom-hostname>:1235

* Macintosh host

GDB now includes support for the Apple Macintosh, as a host only.  It
may be run as either an MPW tool or as a standalone application, and
it can debug through the serial port.  All the usual GDB commands are
available, but to the target command, you must supply "serial" as the
device type instead of "/dev/ttyXX".  See mpw-README in the main
directory for more information on how to build.  The MPW configuration
scripts */mpw-config.in support only a few targets, and only the
mips-idt-ecoff target has been tested.

* Autoconf

GDB configuration now uses autoconf.  This is not user-visible,
but does simplify configuration and building.

* hpux10

GDB now supports hpux10.

*** Changes in GDB-4.14:

* New native configurations

x86 FreeBSD					i[345]86-*-freebsd
x86 NetBSD					i[345]86-*-netbsd
NS32k NetBSD					ns32k-*-netbsd
Sparc NetBSD					sparc-*-netbsd

* New targets

A29K VxWorks					a29k-*-vxworks
HP PA PRO embedded (WinBond W89K & Oki OP50N)	hppa*-*-pro*
CPU32 EST-300 emulator				m68*-*-est*
PowerPC ELF					powerpc-*-elf
WDC 65816					w65-*-*

* Alpha OSF/1 support for procfs

GDB now supports procfs under OSF/1-2.x and higher, which makes it
possible to attach to running processes.  As the mounting of the /proc
filesystem is optional on the Alpha, GDB automatically determines
the availability of /proc during startup.  This can lead to problems
if /proc is unmounted after GDB has been started.

* Arguments to user-defined commands

User commands may accept up to 10 arguments separated by whitespace.
Arguments are accessed within the user command via $arg0..$arg9.  A
trivial example:
define adder
  print $arg0 + $arg1 + $arg2

To execute the command use:
adder 1 2 3

Defines the command "adder" which prints the sum of its three arguments.
Note the arguments are text substitutions, so they may reference variables,
use complex expressions, or even perform inferior function calls.

* New `if' and `while' commands

This makes it possible to write more sophisticated user-defined
commands.  Both commands take a single argument, which is the
expression to evaluate, and must be followed by the commands to
execute, one per line, if the expression is nonzero, the list being
terminated by the word `end'.  The `if' command list may include an
`else' word, which causes the following commands to be executed only
if the expression is zero.

* Fortran source language mode

GDB now includes partial support for Fortran 77.  It will recognize
Fortran programs and can evaluate a subset of Fortran expressions, but
variables and functions may not be handled correctly.  GDB will work
with G77, but does not yet know much about symbols emitted by other
Fortran compilers.

* Better HPUX support

Most debugging facilities now work on dynamic executables for HPPAs
running hpux9 or later.  You can attach to running dynamically linked
processes, but by default the dynamic libraries will be read-only, so
for instance you won't be able to put breakpoints in them.  To change
that behavior do the following before running the program:

	adb -w a.out
	__dld_flags?W 0x5
	control-d

This will cause the libraries to be mapped private and read-write.
To revert to the normal behavior, do this:

	adb -w a.out
	__dld_flags?W 0x4
	control-d

You cannot set breakpoints or examine data in the library until after
the library is loaded if the function/data symbols do not have
external linkage.

GDB can now also read debug symbols produced by the HP C compiler on
HPPAs (sorry, no C++, Fortran or 68k support).

* Target byte order now dynamically selectable

You can choose which byte order to use with a target system, via the
commands "set endian big" and "set endian little", and you can see the
current setting by using "show endian".  You can also give the command
"set endian auto", in which case GDB will use the byte order
associated with the executable.  Currently, only embedded MIPS
configurations support dynamic selection of target byte order.

* New DOS host serial code

This version uses DPMI interrupts to handle buffered I/O, so you
no longer need to run asynctsr when debugging boards connected to
a PC's serial port.

*** Changes in GDB-4.13:

* New "complete" command

This lists all the possible completions for the rest of the line, if it
were to be given as a command itself.  This is intended for use by emacs.

* Trailing space optional in prompt

"set prompt" no longer adds a space for you after the prompt you set.  This
allows you to set a prompt which ends in a space or one that does not.

* Breakpoint hit counts

"info break" now displays a count of the number of times the breakpoint
has been hit.  This is especially useful in conjunction with "ignore"; you
can ignore a large number of breakpoint hits, look at the breakpoint info
to see how many times the breakpoint was hit, then run again, ignoring one
less than that number, and this will get you quickly to the last hit of
that breakpoint.

* Ability to stop printing at NULL character

"set print null-stop" will cause GDB to stop printing the characters of
an array when the first NULL is encountered.  This is useful when large
arrays actually contain only short strings.

* Shared library breakpoints

In SunOS 4.x, SVR4, and Alpha OSF/1 configurations, you can now set
breakpoints in shared libraries before the executable is run.

* Hardware watchpoints

There is a new hardware breakpoint for the watch command for sparclite
targets.  See gdb/sparclite/hw_breakpoint.note.

Hardware watchpoints are also now supported under Linux.
 
* Annotations

Annotations have been added.  These are for use with graphical interfaces,
and are still experimental.  Currently only gdba.el uses these.

* Improved Irix 5 support

GDB now works properly with Irix 5.2.

* Improved HPPA support

GDB now works properly with the latest GCC and GAS.

* New native configurations

Sequent PTX4				i[34]86-sequent-ptx4
HPPA running OSF/1			hppa*-*-osf*
Atari TT running SVR4			m68*-*-sysv4*
RS/6000 LynxOS				rs6000-*-lynxos*

* New targets

OS/9000					i[34]86-*-os9k
MIPS R4000				mips64*{,el}-*-{ecoff,elf}
Sparc64					sparc64-*-*

* Hitachi SH7000 and E7000-PC ICE support

There is now support for communicating with the Hitachi E7000-PC ICE.
This is available automatically when GDB is configured for the SH.

* Fixes

As usual, a variety of small fixes and improvements, both generic
and configuration-specific.  See the ChangeLog for more detail.

*** Changes in GDB-4.12:

* Irix 5 is now supported

* HPPA support

GDB-4.12 on the HPPA has a number of changes which make it unable
to debug the output from the currently released versions of GCC and
GAS (GCC 2.5.8 and GAS-2.2 or PAGAS-1.36).  Until the next major release
of GCC and GAS, versions of these tools designed to work with GDB-4.12
can be retrieved via anonymous ftp from jaguar.cs.utah.edu:/dist.


*** Changes in GDB-4.11:

* User visible changes:

* Remote Debugging

The "set remotedebug" option is now consistent between the mips remote
target, remote targets using the gdb-specific protocol, UDI (AMD's
debug protocol for the 29k) and the 88k bug monitor.  It is now an
integer specifying a debug level (normally 0 or 1, but 2 means more
debugging info for the mips target).

* DEC Alpha native support

GDB now works on the DEC Alpha.  GCC 2.4.5 does not produce usable
debug info, but GDB works fairly well with the DEC compiler and should
work with a future GCC release.  See the README file for a few
Alpha-specific notes.

* Preliminary thread implementation

GDB now has preliminary thread support for both SGI/Irix and LynxOS.

* LynxOS native and target support for 386

This release has been hosted on LynxOS 2.2, and also can be configured
to remotely debug programs running under LynxOS (see gdb/gdbserver/README
for details).

* Improvements in C++ mangling/demangling.

This release has much better g++ debugging, specifically in name 
mangling/demangling, virtual function calls, print virtual table,
call methods, ...etc.

*** Changes in GDB-4.10:

 * User visible changes:

Remote debugging using the GDB-specific (`target remote') protocol now
supports the `load' command.  This is only useful if you have some
other way of getting the stub to the target system, and you can put it
somewhere in memory where it won't get clobbered by the download.

Filename completion now works.

When run under emacs mode, the "info line" command now causes the
arrow to point to the line specified.  Also, "info line" prints
addresses in symbolic form (as well as hex).

All vxworks based targets now support a user settable option, called
vxworks-timeout.  This option represents the number of seconds gdb
should wait for responses to rpc's.  You might want to use this if
your vxworks target is, perhaps, a slow software simulator or happens
to be on the far side of a thin network line.

 * DEC alpha support

This release contains support for using a DEC alpha as a GDB host for
cross debugging.  Native alpha debugging is not supported yet.


*** Changes in GDB-4.9:

 * Testsuite

This is the first GDB release which is accompanied by a matching testsuite.
The testsuite requires installation of dejagnu, which should be available
via ftp from most sites that carry GNU software.

 * C++ demangling

'Cfront' style demangling has had its name changed to 'ARM' style, to
emphasize that it was written from the specifications in the C++ Annotated
Reference Manual, not necessarily to be compatible with AT&T cfront.  Despite
disclaimers, it still generated too much confusion with users attempting to
use gdb with AT&T cfront.

 * Simulators

GDB now uses a standard remote interface to a simulator library.
So far, the library contains simulators for the Zilog Z8001/2, the
Hitachi H8/300, H8/500 and Super-H.

 * New targets supported

H8/300 simulator 			h8300-hitachi-hms or h8300hms
H8/500 simulator 			h8500-hitachi-hms or h8500hms
SH simulator				sh-hitachi-hms    or sh
Z8000 simulator		  		z8k-zilog-none 	  or z8ksim
IDT MIPS board over serial line		mips-idt-ecoff

Cross-debugging to GO32 targets is supported.  It requires a custom
version of the i386-stub.c module which is integrated with the 
GO32 memory extender.

 * New remote protocols

MIPS remote debugging protocol.

 * New source languages supported

This version includes preliminary support for Chill, a Pascal like language
used by telecommunications companies.  Chill support is also being integrated
into the GNU compiler, but we don't know when it will be publically available.


*** Changes in GDB-4.8:

 * HP Precision Architecture supported

GDB now supports HP PA-RISC machines running HPUX.  A preliminary
version of this support was available as a set of patches from the
University of Utah.  GDB does not support debugging of programs
compiled with the HP compiler, because HP will not document their file
format.  Instead, you must use GCC (version 2.3.2 or later) and PA-GAS
(as available from jaguar.cs.utah.edu:/dist/pa-gas.u4.tar.Z).

Many problems in the preliminary version have been fixed.

 * Faster and better demangling

We have improved template demangling and fixed numerous bugs in the GNU style
demangler.  It can now handle type modifiers such as `static' or `const'.  Wide
character types (wchar_t) are now supported.  Demangling of each symbol is now
only done once, and is cached when the symbol table for a file is read in.
This results in a small increase in memory usage for C programs, a moderate
increase in memory usage for C++ programs, and a fantastic speedup in
symbol lookups.

`Cfront' style demangling still doesn't work with AT&T cfront.  It was written
from the specifications in the Annotated Reference Manual, which AT&T's
compiler does not actually implement.

 * G++ multiple inheritance compiler problem

In the 2.3.2 release of gcc/g++, how the compiler resolves multiple
inheritance lattices was reworked to properly discover ambiguities.  We
recently found an example which causes this new algorithm to fail in a
very subtle way, producing bad debug information for those classes.
The file 'gcc.patch' (in this directory) can be applied to gcc to
circumvent the problem.  A future GCC release will contain a complete
fix.

The previous G++ debug info problem (mentioned below for the gdb-4.7
release) is fixed in gcc version 2.3.2.

 * Improved configure script

The `configure' script will now attempt to guess your system type if
you don't supply a host system type.  The old scheme of supplying a
host system triplet is preferable over using this.  All the magic is
done in the new `config.guess' script.  Examine it for details.

We have also brought our configure script much more in line with the FSF's
version.  It now supports the --with-xxx options.  In particular,
`--with-minimal-bfd' can be used to make the GDB binary image smaller.
The resulting GDB will not be able to read arbitrary object file formats --
only the format ``expected'' to be used on the configured target system.
We hope to make this the default in a future release.

 * Documentation improvements

There's new internal documentation on how to modify GDB, and how to
produce clean changes to the code.  We implore people to read it
before submitting changes.

The GDB manual uses new, sexy Texinfo conditionals, rather than arcane
M4 macros.  The new texinfo.tex is provided in this release.  Pre-built
`info' files are also provided.  To build `info' files from scratch,
you will need the latest `makeinfo' release, which will be available in
a future texinfo-X.Y release.

*NOTE*  The new texinfo.tex can cause old versions of TeX to hang.
We're not sure exactly which versions have this problem, but it has
been seen in 3.0.  We highly recommend upgrading to TeX version 3.141
or better.  If that isn't possible, there is a patch in
`texinfo/tex3patch' that will modify `texinfo/texinfo.tex' to work
around this problem.

 * New features

GDB now supports array constants that can be used in expressions typed in by
the user.  The syntax is `{element, element, ...}'.  Ie: you can now type
`print {1, 2, 3}', and it will build up an array in memory malloc'd in
the target program.

The new directory `gdb/sparclite' contains a program that demonstrates
how the sparc-stub.c remote stub runs on a Fujitsu SPARClite processor.

 * New native hosts supported

HP/PA-RISC under HPUX using GNU tools	hppa1.1-hp-hpux
386 CPUs running SCO Unix 3.2v4		i386-unknown-sco3.2v4

 * New targets supported

AMD 29k family via UDI			a29k-amd-udi  or  udi29k

 * New file formats supported

BFD now supports reading HP/PA-RISC executables (SOM file format?),
HPUX core files, and SCO 3.2v2 core files.

 * Major bug fixes

Attaching to processes now works again; thanks for the many bug reports.

We have also stomped on a bunch of core dumps caused by
printf_filtered("%s") problems.

We eliminated a copyright problem on the rpc and ptrace header files
for VxWorks, which was discovered at the last minute during the 4.7
release.  You should now be able to build a VxWorks GDB.

You can now interrupt gdb while an attached process is running.  This
will cause the attached process to stop, and give control back to GDB.

We fixed problems caused by using too many file descriptors
for reading symbols from object files and libraries.  This was
especially a problem for programs that used many (~100) shared
libraries.

The `step' command now only enters a subroutine if there is line number
information for the subroutine.  Otherwise it acts like the `next'
command.  Previously, `step' would enter subroutines if there was
any debugging information about the routine.  This avoids problems
when using `cc -g1' on MIPS machines.

 * Internal improvements

GDB's internal interfaces have been improved to make it easier to support
debugging of multiple languages in the future.

GDB now uses a common structure for symbol information internally.
Minimal symbols (derived from linkage symbols in object files), partial
symbols (from a quick scan of debug information), and full symbols
contain a common subset of information, making it easier to write
shared code that handles any of them.

 * New command line options

We now accept --silent as an alias for --quiet.

 * Mmalloc licensing

The memory-mapped-malloc library is now licensed under the GNU Library
General Public License.

*** Changes in GDB-4.7:

 * Host/native/target split

GDB has had some major internal surgery to untangle the support for
hosts and remote targets.  Now, when you configure GDB for a remote
target, it will no longer load in all of the support for debugging
local programs on the host.  When fully completed and tested, this will
ensure that arbitrary host/target combinations are possible.

The primary conceptual shift is to separate the non-portable code in
GDB into three categories.  Host specific code is required any time GDB
is compiled on that host, regardless of the target.  Target specific
code relates to the peculiarities of the target, but can be compiled on
any host.  Native specific code is everything else:  it can only be
built when the host and target are the same system.  Child process
handling and core file support are two common `native' examples.

GDB's use of /proc for controlling Unix child processes is now cleaner.
It has been split out into a single module under the `target_ops' vector,
plus two native-dependent functions for each system that uses /proc.

 * New hosts supported

HP/Apollo 68k (under the BSD domain)	m68k-apollo-bsd  or  apollo68bsd
386 CPUs running various BSD ports	i386-unknown-bsd  or  386bsd
386 CPUs running SCO Unix		i386-unknown-scosysv322  or  i386sco

 * New targets supported

Fujitsu SPARClite 			sparclite-fujitsu-none  or  sparclite
68030 and CPU32				m68030-*-*, m68332-*-*

 * New native hosts supported

386 CPUs running various BSD ports	i386-unknown-bsd  or  386bsd
    (386bsd is not well tested yet)
386 CPUs running SCO Unix		i386-unknown-scosysv322  or  sco

 * New file formats supported

BFD now supports COFF files for the Zilog Z8000 microprocessor.  It
supports reading of `a.out.adobe' object files, which are an a.out
format extended with minimal information about multiple sections.

 * New commands

`show copying' is the same as the old `info copying'.
`show warranty' is the same as `info warrantee'.
These were renamed for consistency.  The old commands continue to work.

`info handle' is a new alias for `info signals'.

You can now define pre-command hooks, which attach arbitrary command
scripts to any command.  The commands in the hook will be executed
prior to the user's command.  You can also create a hook which will be
executed whenever the program stops.  See gdb.texinfo.

 * C++ improvements

We now deal with Cfront style name mangling, and can even extract type
info from mangled symbols.  GDB can automatically figure out which
symbol mangling style your C++ compiler uses.

Calling of methods and virtual functions has been improved as well.

 * Major bug fixes

The crash that occured when debugging Sun Ansi-C compiled binaries is
fixed.  This was due to mishandling of the extra N_SO stabs output
by the compiler.

We also finally got Ultrix 4.2 running in house, and fixed core file
support, with help from a dozen people on the net.

John M. Farrell discovered that the reason that single-stepping was so
slow on all of the Mips based platforms (primarily SGI and DEC) was
that we were trying to demangle and lookup a symbol used for internal
purposes on every instruction that was being stepped through.  Changing
the name of that symbol so that it couldn't be mistaken for a C++
mangled symbol sped things up a great deal.

Rich Pixley sped up symbol lookups in general by getting much smarter
about when C++ symbol mangling is necessary.  This should make symbol
completion (TAB on the command line) much faster.  It's not as fast as
we'd like, but it's significantly faster than gdb-4.6.

 * AMD 29k support

A new user controllable variable 'call_scratch_address' can
specify the location of a scratch area to be used when GDB
calls a function in the target.  This is necessary because the
usual method of putting the scratch area on the stack does not work
in systems that have separate instruction and data spaces.

We integrated changes to support the 29k UDI (Universal Debugger
Interface), but discovered at the last minute that we didn't have all
of the appropriate copyright paperwork.  We are working with AMD to
resolve this, and hope to have it available soon.

 * Remote interfaces

We have sped up the remote serial line protocol, especially for targets
with lots of registers.  It now supports a new `expedited status' ('T')
message which can be used in place of the existing 'S' status message.
This allows the remote stub to send only the registers that GDB
needs to make a quick decision about single-stepping or conditional
breakpoints, eliminating the need to fetch the entire register set for
each instruction being stepped through.

The GDB remote serial protocol now implements a write-through cache for
registers, only re-reading the registers if the target has run.

There is also a new remote serial stub for SPARC processors.  You can
find it in gdb-4.7/gdb/sparc-stub.c.  This was written to support the
Fujitsu SPARClite processor, but will run on any stand-alone SPARC
processor with a serial port.

 * Configuration

Configure.in files have become much easier to read and modify.  A new
`table driven' format makes it more obvious what configurations are
supported, and what files each one uses.

 * Library changes

There is a new opcodes library which will eventually contain all of the
disassembly routines and opcode tables.  At present, it only contains
Sparc and Z8000 routines.  This will allow the assembler, debugger, and
disassembler (binutils/objdump) to share these routines.

The libiberty library is now copylefted under the GNU Library General
Public License.  This allows more liberal use, and was done so libg++
can use it.  This makes no difference to GDB, since the Library License
grants all the rights from the General Public License.

 * Documentation

The file gdb-4.7/gdb/doc/stabs.texinfo is a (relatively) complete
reference to the stabs symbol info used by the debugger.  It is (as far
as we know) the only published document on this fascinating topic.  We
encourage you to read it, compare it to the stabs information on your
system, and send improvements on the document in general (to
bug-gdb@prep.ai.mit.edu).

And, of course, many bugs have been fixed.


*** Changes in GDB-4.6:

 * Better support for C++ function names

GDB now accepts as input the "demangled form" of C++ overloaded function
names and member function names, and can do command completion on such names
(using TAB, TAB-TAB, and ESC-?).  The names have to be quoted with a pair of
single quotes.  Examples are 'func (int, long)' and 'obj::operator==(obj&)'.
Make use of command completion, it is your friend.

GDB also now accepts a variety of C++ mangled symbol formats.  They are
the GNU g++ style, the Cfront (ARM) style, and the Lucid (lcc) style.
You can tell GDB which format to use by doing a 'set demangle-style {gnu,
lucid, cfront, auto}'.  'gnu' is the default.  Do a 'set demangle-style foo'
for the list of formats.

 * G++ symbol mangling problem

Recent versions of gcc have a bug in how they emit debugging information for
C++ methods (when using dbx-style stabs).  The file 'gcc.patch' (in this
directory) can be applied to gcc to fix the problem.  Alternatively, if you
can't fix gcc, you can #define GCC_MANGLE_BUG when compling gdb/symtab.c. The
usual symptom is difficulty with setting breakpoints on methods.  GDB complains
about the method being non-existent.  (We believe that version 2.2.2 of GCC has
this problem.)

 * New 'maintenance' command

All of the commands related to hacking GDB internals have been moved out of
the main command set, and now live behind the 'maintenance' command.  This
can also be abbreviated as 'mt'.  The following changes were made:

	dump-me ->		maintenance dump-me
	info all-breakpoints ->	maintenance info breakpoints
	printmsyms ->		maintenance print msyms
	printobjfiles ->	maintenance print objfiles
	printpsyms ->		maintenance print psymbols
	printsyms ->		maintenance print symbols

The following commands are new:

	maintenance demangle	Call internal GDB demangler routine to
				demangle a C++ link name and prints the result.
	maintenance print type	Print a type chain for a given symbol

 * Change to .gdbinit file processing

We now read the $HOME/.gdbinit file before processing the argv arguments
(e.g. reading symbol files or core files).  This allows global parameters to
be set, which will apply during the symbol reading.  The ./.gdbinit is still
read after argv processing.

 * New hosts supported

Solaris-2.0 !!!				sparc-sun-solaris2  or  sun4sol2

Linux support				i386-unknown-linux  or  linux

We are also including code to support the HP/PA running BSD and HPUX.  This
is almost guaranteed not to work, as we didn't have time to test or build it
for this release.  We are including it so that the more adventurous (or
masochistic) of you can play with it.  We also had major problems with the
fact that the compiler that we got from HP doesn't support the -g option.
It costs extra.

 * New targets supported

Hitachi H8/300				h8300-hitachi-hms  or  h8300hms

 * More smarts about finding #include files

GDB now remembers the compilation directory for all include files, and for
all files from which C is generated (like yacc and lex sources).  This
greatly improves GDB's ability to find yacc/lex sources, and include files,
especially if you are debugging your program from a directory different from
the one that contains your sources.

We also fixed a bug which caused difficulty with listing and setting
breakpoints in include files which contain C code.  (In the past, you had to
try twice in order to list an include file that you hadn't looked at before.)

 * Interesting infernals change

GDB now deals with arbitrary numbers of sections, where the symbols for each
section must be relocated relative to that section's landing place in the
target's address space.  This work was needed to support ELF with embedded
stabs used by Solaris-2.0.

 * Bug fixes (of course!)

There have been loads of fixes for the following things:
	mips, rs6000, 29k/udi, m68k, g++, type handling, elf/dwarf, m88k,
	i960, stabs, DOS(GO32), procfs, etc...

See the ChangeLog for details.

*** Changes in GDB-4.5:

 * New machines supported (host and target)

IBM RS6000 running AIX			rs6000-ibm-aix	or rs6000

SGI Irix-4.x				mips-sgi-irix4	or iris4

 * New malloc package

GDB now uses a new memory manager called mmalloc, based on gmalloc.
Mmalloc is capable of handling mutiple heaps of memory.  It is also
capable of saving a heap to a file, and then mapping it back in later.
This can be used to greatly speedup the startup of GDB by using a
pre-parsed symbol table which lives in a mmalloc managed heap.  For
more details, please read mmalloc/mmalloc.texi.

 * info proc

The 'info proc' command (SVR4 only) has been enhanced quite a bit.  See
'help info proc' for details.

 * MIPS ecoff symbol table format

The code that reads MIPS symbol table format is now supported on all hosts.
Thanks to MIPS for releasing the sym.h and symconst.h files to make this
possible.

 * File name changes for MS-DOS

Many files in the config directories have been renamed to make it easier to
support GDB on MS-DOSe systems (which have very restrictive file name
conventions :-( ).  MS-DOSe host support (under DJ Delorie's GO32
environment) is close to working but has some remaining problems.  Note
that debugging of DOS programs is not supported, due to limitations
in the ``operating system'', but it can be used to host cross-debugging.

 * Cross byte order fixes

Many fixes have been made to support cross debugging of Sparc and MIPS
targets from hosts whose byte order differs.

 * New -mapped and -readnow options

If memory-mapped files are available on your system through the 'mmap'
system call, you can use the -mapped option on the `file' or
`symbol-file' commands to cause GDB to write the symbols from your
program into a reusable file.  If the program you are debugging is
called `/path/fred', the mapped symbol file will be `./fred.syms'.
Future GDB debugging sessions will notice the presence of this file,
and will quickly map in symbol information from it, rather than reading
the symbol table from the executable program.  Using the '-mapped'
option in a GDB `file' or `symbol-file' command has the same effect as
starting GDB with the '-mapped' command-line option.

You can cause GDB to read the entire symbol table immediately by using
the '-readnow' option with any of the commands that load symbol table
information (or on the GDB command line).  This makes the command
slower, but makes future operations faster.

The -mapped and -readnow options are typically combined in order to
build a `fred.syms' file that contains complete symbol information.
A simple GDB invocation to do nothing but build a `.syms' file for future
use is:

	gdb -batch -nx -mapped -readnow programname

The `.syms' file is specific to the host machine on which GDB is run.
It holds an exact image of GDB's internal symbol table.  It cannot be
shared across multiple host platforms.

 * longjmp() handling

GDB is now capable of stepping and nexting over longjmp(), _longjmp(), and
siglongjmp() without losing control.  This feature has not yet been ported to
all systems.  It currently works on many 386 platforms, all MIPS-based
platforms (SGI, DECstation, etc), and Sun3/4.

 * Solaris 2.0

Preliminary work has been put in to support the new Solaris OS from Sun.  At
this time, it can control and debug processes, but it is not capable of
reading symbols.

 * Bug fixes

As always, many many bug fixes.  The major areas were with g++, and mipsread.
People using the MIPS-based platforms should experience fewer mysterious
crashes and trashed symbol tables.

*** Changes in GDB-4.4:

 * New machines supported (host and target)

SCO Unix on i386 IBM PC clones		i386-sco-sysv	or  i386sco
	(except core files)
BSD Reno on Vax				vax-dec-bsd
Ultrix on Vax				vax-dec-ultrix

 * New machines supported (target)

AMD 29000 embedded, using EBMON		a29k-none-none

 * C++ support

GDB continues to improve its handling of C++.  `References' work better.
The demangler has also been improved, and now deals with symbols mangled as
per the Annotated C++ Reference Guide.

GDB also now handles `stabs' symbol information embedded in MIPS
`ecoff' symbol tables.  Since the ecoff format was not easily
extensible to handle new languages such as C++, this appeared to be a
good way to put C++ debugging info into MIPS binaries.  This option
will be supported in the GNU C compiler, version 2, when it is
released.

 * New features for SVR4

GDB now handles SVR4 shared libraries, in the same fashion as SunOS
shared libraries.  Debugging dynamically linked programs should present
only minor differences from debugging statically linked programs.

The `info proc' command will print out information about any process
on an SVR4 system (including the one you are debugging).  At the moment,
it prints the address mappings of the process.

If you bring up GDB on another SVR4 system, please send mail to
bug-gdb@prep.ai.mit.edu to let us know what changes were reqired (if any).

 * Better dynamic linking support in SunOS

Reading symbols from shared libraries which contain debugging symbols
now works properly.  However, there remain issues such as automatic
skipping of `transfer vector' code during function calls, which
make it harder to debug code in a shared library, than to debug the
same code linked statically.

 * New Getopt

GDB is now using the latest `getopt' routines from the FSF.  This
version accepts the -- prefix for options with long names.  GDB will
continue to accept the old forms (-option and +option) as well.
Various single letter abbreviations for options have been explicity
added to the option table so that they won't get overshadowed in the
future by other options that begin with the same letter.

 * Bugs fixed

The `cleanup_undefined_types' bug that many of you noticed has been squashed.
Many assorted bugs have been handled.  Many more remain to be handled.
See the various ChangeLog files (primarily in gdb and bfd) for details.


*** Changes in GDB-4.3:

 * New machines supported (host and target)

Amiga 3000 running Amix			m68k-cbm-svr4	or  amix
NCR 3000 386 running SVR4		i386-ncr-svr4	or  ncr3000
Motorola Delta 88000 running Sys V	m88k-motorola-sysv  or  delta88

 * Almost SCO Unix support

We had hoped to support:
SCO Unix on i386 IBM PC clones		i386-sco-sysv	or  i386sco
(except for core file support), but we discovered very late in the release
that it has problems with process groups that render gdb unusable.  Sorry
about that.  I encourage people to fix it and post the fixes.

 * Preliminary ELF and DWARF support

GDB can read ELF object files on System V Release 4, and can handle
debugging records for C, in DWARF format, in ELF files.  This support
is preliminary.  If you bring up GDB on another SVR4 system, please
send mail to bug-gdb@prep.ai.mit.edu to let us know what changes were
reqired (if any).

 * New Readline

GDB now uses the latest `readline' library.  One user-visible change
is that two tabs will list possible command completions, which previously
required typing M-? (meta-question mark, or ESC ?).

 * Bugs fixed

The `stepi' bug that many of you noticed has been squashed.
Many bugs in C++ have been handled.  Many more remain to be handled.
See the various ChangeLog files (primarily in gdb and bfd) for details.

 * State of the MIPS world (in case you wondered):

GDB can understand the symbol tables emitted by the compilers
supplied by most vendors of MIPS-based machines, including DEC.  These
symbol tables are in a format that essentially nobody else uses.

Some versions of gcc come with an assembler post-processor called
mips-tfile.  This program is required if you want to do source-level
debugging of gcc-compiled programs.  I believe FSF does not ship
mips-tfile with gcc version 1, but it will eventually come with gcc
version 2.

Debugging of g++ output remains a problem.  g++ version 1.xx does not
really support it at all.  (If you're lucky, you should be able to get
line numbers and stack traces to work, but no parameters or local
variables.)  With some work it should be possible to improve the
situation somewhat.

When gcc version 2 is released, you will have somewhat better luck.
However, even then you will get confusing results for inheritance and
methods.

We will eventually provide full debugging of g++ output on
DECstations.  This will probably involve some kind of stabs-in-ecoff
encapulation, but the details have not been worked out yet.


*** Changes in GDB-4.2:

 *  Improved configuration

Only one copy of `configure' exists now, and it is not self-modifying.
Porting BFD is simpler.  

 *  Stepping improved

The `step' and `next' commands now only stop at the first instruction
of a source line.  This prevents the multiple stops that used to occur
in switch statements, for-loops, etc.  `Step' continues to stop if a
function that has debugging information is called within the line.

 *  Bug fixing

Lots of small bugs fixed.  More remain.

 *  New host supported (not target)

Intel 386 PC clone running Mach		i386-none-mach


*** Changes in GDB-4.1:

 *  Multiple source language support

GDB now has internal scaffolding to handle several source languages.
It determines the type of each source file from its filename extension,
and will switch expression parsing and number formatting to match the
language of the function in the currently selected stack frame.
You can also specifically set the language to be used, with
`set language c' or `set language modula-2'.

 *  GDB and Modula-2

GDB now has preliminary support for the GNU Modula-2 compiler,
currently under development at the State University of New York at
Buffalo.  Development of both GDB and the GNU Modula-2 compiler will
continue through the fall of 1991 and into 1992.

Other Modula-2 compilers are currently not supported, and attempting to
debug programs compiled with them will likely result in an error as the
symbol table is read.  Feel free to work on it, though!

There are hooks in GDB for strict type checking and range checking,
in the `Modula-2 philosophy', but they do not currently work.

 * set write on/off

GDB can now write to executable and core files (e.g. patch
a variable's value).   You must turn this switch on, specify
the file ("exec foo" or "core foo"), *then* modify it, e.g.
by assigning a new value to a variable.  Modifications take
effect immediately.

 * Automatic SunOS shared library reading

When you run your program, GDB automatically determines where its
shared libraries (if any) have been loaded, and reads their symbols.
The `share' command is no longer needed.  This also works when
examining core files.

 * set listsize

You can specify the number of lines that the `list' command shows.
The default is 10.

 * New machines supported (host and target)

SGI Iris (MIPS) running Irix V3:  	mips-sgi-irix   or  iris
Sony NEWS (68K) running NEWSOS 3.x:	m68k-sony-sysv	or  news
Ultracomputer (29K) running Sym1:	a29k-nyu-sym1	or  ultra3

 * New hosts supported (not targets)

IBM RT/PC:				romp-ibm-aix 	or  rtpc

 * New targets supported (not hosts)

AMD 29000 embedded with COFF		a29k-none-coff
AMD 29000 embedded with a.out		a29k-none-aout
Ultracomputer remote kernel debug	a29k-nyu-kern

 * New remote interfaces

AMD 29000 Adapt
AMD 29000 Minimon


*** Changes in GDB-4.0:

 *  New Facilities

Wide output is wrapped at good places to make the output more readable.

Gdb now supports cross-debugging from a host machine of one type to a
target machine of another type.  Communication with the target system
is over serial lines.  The ``target'' command handles connecting to the
remote system; the ``load'' command will download a program into the
remote system.  Serial stubs for the m68k and i386 are provided.  Gdb
also supports debugging of realtime processes running under VxWorks,
using SunRPC Remote Procedure Calls over TCP/IP to talk to a debugger
stub on the target system.

New CPUs supported include the AMD 29000 and Intel 960.

GDB now reads object files and symbol tables via a ``binary file'' 
library, which allows a single copy of GDB to debug programs of multiple
object file types such as a.out and coff.

There is now a GDB reference card in "doc/refcard.tex".  (Make targets
refcard.dvi and refcard.ps are available to format it).


 *  Control-Variable user interface simplified

All variables that control the operation of the debugger can be set
by the ``set'' command, and displayed by the ``show'' command.

For example, ``set prompt new-gdb=>'' will change your prompt to new-gdb=>.
``Show prompt'' produces the response:
Gdb's prompt is new-gdb=>.

What follows are the NEW set commands.  The command ``help set'' will
print a complete list of old and new set commands.  ``help set FOO''
will give a longer description of the variable FOO.  ``show'' will show
all of the variable descriptions and their current settings.

confirm on/off:  Enables warning questions for operations that are
		 hard to recover from, e.g. rerunning the program while
		 it is already running.  Default is ON.

editing on/off:  Enables EMACS style command line editing 
                 of input.  Previous lines can be recalled with 
		 control-P, the current line can be edited with control-B,
		 you can search for commands with control-R, etc.
		 Default is ON.

history filename NAME:  NAME is where the gdb command history 
			will be stored.  The default is .gdb_history,
			or the value of the environment variable
			GDBHISTFILE.

history size N:  The size, in commands, of the command history.  The 
		 default is 256, or the value of the environment variable
		 HISTSIZE.

history save on/off: If this value is set to ON, the history file will
		      be saved after exiting gdb.  If set to OFF, the 
		      file will not be saved.  The default is OFF.

history expansion on/off: If this value is set to ON, then csh-like 
			  history expansion will be performed  on 
			  command line input.  The default is OFF.

radix N:  Sets the default radix for input and output.  It can be set
	  to 8, 10, or 16.  Note that the argument to "radix" is interpreted
	  in the current radix, so "set radix 10" is always a no-op.

height N: This integer value is the number of lines on a page. Default
          is 24, the current `stty rows'' setting, or the ``li#''
	  setting from the termcap entry matching the environment
	  variable TERM.

width N:  This integer value is the number of characters on a line.
	  Default is 80, the current `stty cols'' setting, or the ``co#''
	  setting from the termcap entry matching the environment
	  variable TERM.

Note: ``set screensize'' is obsolete. Use ``set height'' and
``set width'' instead.

print address on/off:  Print memory addresses in various command displays,
		      such as stack traces and structure values.  Gdb looks
		      more ``symbolic'' if you turn this off; it looks more
		      ``machine level'' with it on.  Default is ON.

print array on/off:  Prettyprint arrays.  New convenient format!  Default 
                    is OFF.

print demangle on/off:   Print C++ symbols in "source" form if on,
			"raw" form if off.

print asm-demangle on/off:  Same, for assembler level printouts
			like instructions.

print vtbl on/off:  Prettyprint C++ virtual function tables.  Default is OFF.


 *  Support for Epoch Environment.

The epoch environment is a version of Emacs v18 with windowing.  One
new command, ``inspect'', is identical to ``print'', except that if you
are running in the epoch environment, the value is printed in its own
window.


 *  Support for Shared Libraries

GDB can now debug programs and core files that use SunOS shared libraries.
Symbols from a shared library cannot be referenced
before the shared library has been linked with the program (this
happens after you type ``run'' and before the function main() is entered).
At any time after this linking (including when examining core files
from dynamically linked programs), gdb reads the symbols from each
shared library when you type the ``sharedlibrary'' command.
It can be abbreviated ``share''.

sharedlibrary REGEXP:  Load shared object library symbols for files 
                       matching a unix regular expression.  No argument
		       indicates to load symbols for all shared libraries.

info sharedlibrary:  Status of loaded shared libraries.


 *  Watchpoints

A watchpoint stops execution of a program whenever the value of an
expression changes.  Checking for this slows down execution
tremendously whenever you are in the scope of the expression, but is
quite useful for catching tough ``bit-spreader'' or pointer misuse
problems.  Some machines such as the 386 have hardware for doing this
more quickly, and future versions of gdb will use this hardware.

watch EXP:  Set a watchpoint (breakpoint) for an expression.

info watchpoints:  Information about your watchpoints.

delete N:   Deletes watchpoint number N (same as breakpoints).
disable N:  Temporarily turns off watchpoint number N (same as breakpoints).
enable N:   Re-enables watchpoint number N (same as breakpoints).


 *  C++ multiple inheritance

When used with a GCC version 2 compiler, GDB supports multiple inheritance
for C++ programs.

 *  C++ exception handling

Gdb now supports limited C++ exception handling.  Besides the existing
ability to breakpoint on an exception handler, gdb can breakpoint on
the raising of an exception (before the stack is peeled back to the
handler's context).

catch FOO:  If there is a FOO exception handler in the dynamic scope,
	    set a breakpoint to catch exceptions which may be raised there.
	    Multiple exceptions (``catch foo bar baz'') may be caught.

info catch:  Lists all exceptions which may be caught in the
             current stack frame.


 *  Minor command changes

The command ``call func (arg, arg, ...)'' now acts like the print
command, except it does not print or save a value if the function's result
is void.  This is similar to dbx usage.

The ``up'' and ``down'' commands now always print the frame they end up
at; ``up-silently'' and `down-silently'' can be used in scripts to change
frames without printing.

 *  New directory command

'dir' now adds directories to the FRONT of the source search path.
The path starts off empty.  Source files that contain debug information
about the directory in which they were compiled can be found even
with an empty path; Sun CC and GCC include this information.  If GDB can't
find your source file in the current directory, type "dir .".

 * Configuring GDB for compilation

For normal use, type ``./configure host''.  See README or gdb.texinfo
for more details.

GDB now handles cross debugging.  If you are remotely debugging between 
two different machines, type ``./configure host -target=targ''.
Host is the machine where GDB will run; targ is the machine
where the program that you are debugging will run.
