/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import nts.base.Dimen;
import nts.io.CharCode;
import nts.io.CntxLog;
import nts.io.CntxLoggable;
import nts.io.Log;
import nts.io.Loggable;
import nts.noad.Converter;
import nts.noad.Egg;
import nts.noad.Field;
import nts.noad.Operator;
import nts.noad.OperatorEgg;
import nts.node.Box;
import nts.node.HBoxNode;
import nts.node.HShiftNode;
import nts.node.MathWordBuilder;
import nts.node.Node;
import nts.node.TreatNode;

public class CharField
extends Field
implements Loggable,
CntxLoggable {
    public static final CharField NULL;
    private byte fam;
    private CharCode code;

    public void addOn(Log log) {
        log.addEsc("fam").add(this.fam).add(' ').add(this.code);
    }

    public void addOn(Log log, CntxLog cntx) {
        this.addOn(log);
    }

    public void addOn(Log log, CntxLog cntx, char p) {
        cntx.addOn(log, this, p);
    }

    public boolean isJustChar() {
        return true;
    }

    public Dimen skewAmount(Converter conv) {
        return conv.skewAmount(this.fam, this.code);
    }

    public Node convertedBy(Converter conv) {
        return conv.fetchCharNode(this.fam, this.code);
    }

    public Box fittingTo(Converter conv, Dimen width) {
        return conv.fetchFittingWidthBox(this.fam, this.code, width);
    }

    public Dimen xHeight(Converter conv) {
        return conv.getXHeight(this.fam);
    }

    public Node cleanBox(Converter conv, byte how) {
        return CharField.packedWithItalCorr(conv.fetchCharNode(this.fam, this.code, how));
    }

    private static Node packedWithItalCorr(Node node) {
        if (node == null) {
            return HBoxNode.EMPTY;
        }
        HBoxNode box = HBoxNode.packedOf(node);
        Dimen ital = node.getItalCorr();
        return ital == null ? box : box.pretendingWidth(box.getWidth().plus(ital));
    }

    private static Operator makeOperator(Node node, Converter conv) {
        Dimen middle = conv.getDimPar(16);
        Dimen shift = (node == null ? Dimen.ZERO : node.getHeight().max(Dimen.ZERO).minus(node.getDepth().max(Dimen.ZERO)).halved()).minus(middle);
        return new CharOperator(node, shift);
    }

    public Operator makeOperator(Converter conv, boolean larger) {
        return CharField.makeOperator(larger ? conv.fetchLargerNode(this.fam, this.code) : conv.fetchCharNode(this.fam, this.code), conv);
    }

    public MathWordBuilder getMathWordBuilder(Converter conv, TreatNode proc) {
        return conv.getWordBuilder(this.fam, proc);
    }

    public byte wordFamily() {
        return this.fam;
    }

    public void contributeToWord(MathWordBuilder word) {
        word.add(this.code);
    }

    public Operator takeLastOperator(MathWordBuilder word, Converter conv, boolean larger) {
        return CharField.makeOperator(larger ? word.takeLastLargerNode() : word.takeLastNode(), conv);
    }

    public CharField(byte fam, CharCode code) {
        this.fam = fam;
        this.code = code;
    }

    protected static class CharOperator
    implements Operator {
        private final Node node;
        private final Dimen shift;

        public Node getNodeToBeLimited() {
            Node box = CharField.packedWithItalCorr(this.node);
            return this.shift.isZero() ? box : HBoxNode.packedOf(HShiftNode.shiftingDown(box, this.shift));
        }

        public Egg getEggToBeScripted(byte spType) {
            return new OperatorEgg(this.node, this.shift, spType);
        }

        public Dimen getItalCorr() {
            return this.node == null ? null : this.node.getItalCorr();
        }

        public CharOperator(Node node, Dimen shift) {
            this.node = node;
            this.shift = shift;
        }
    }
}

