/*
 * Decompiled with CFR 0.152.
 */
package nts.tex;

import nts.command.CommandBase;
import nts.command.ContextDisplay;
import nts.io.BufferLineOutput;
import nts.io.CharCode;
import nts.io.Log;
import nts.io.StandardLog;
import nts.tex.TeXIOHandler;

class TeXContextDisplay
implements ContextDisplay {
    private TeXIOHandler.Config config;
    private BufferLineOutput leftOut;
    private BufferLineOutput rightOut;
    private Log leftLog;
    private Log rightLog;
    private int origin = 0;

    public void reset() {
        this.leftOut.reset();
        this.rightOut.reset();
        this.origin = this.normal().getCount();
    }

    public int lines() {
        return this.config.errContextLines();
    }

    public Log normal() {
        return CommandBase.normLog;
    }

    public Log left() {
        return this.leftLog;
    }

    public Log right() {
        return this.rightLog;
    }

    public void show() {
        int n;
        int intro = this.normal().getCount() - this.origin;
        int half = intro + this.leftOut.size();
        if (half <= 50) {
            this.leftOut.addOn(this.normal());
        } else {
            this.normal().add("...");
            half = 50;
            n = half - intro - 3;
            if (n > 0) {
                this.leftOut.addOn(this.normal(), this.leftOut.size() - n, this.leftOut.size());
            }
        }
        this.normal().endLine().add(' ', half);
        if (half + this.rightOut.size() <= 79) {
            this.rightOut.addOn(this.normal());
        } else {
            n = 79 - half - 3;
            if (n > 0) {
                this.rightOut.addOn(this.normal(), 0, n);
            }
            this.normal().add("...");
        }
    }

    public TeXContextDisplay(TeXIOHandler.Config config, CharCode.Maker maker, StandardLog.Escape esc) {
        this.config = config;
        this.leftOut = new BufferLineOutput(50, 0, maker);
        this.rightOut = new BufferLineOutput(79, 79, maker);
        this.leftLog = new StandardLog(this.leftOut, esc);
        this.rightLog = new StandardLog(this.rightOut, esc);
        if (this.normal() != null) {
            this.origin = this.normal().getCount();
        }
    }
}

