/*
 * Decompiled with CFR 0.152.
 */
package nts.tex;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.ContextDisplay;
import nts.command.FileName;
import nts.command.FilePos;
import nts.command.InputLineTokenizer;
import nts.command.InteractionPrim;
import nts.command.LineInputReadInput;
import nts.command.LineInputTokenizer;
import nts.command.ReadInput;
import nts.command.Token;
import nts.command.TokenList;
import nts.command.Tokenizer;
import nts.dvi.DviTypeSetter;
import nts.io.CharCode;
import nts.io.InputLine;
import nts.io.LineInput;
import nts.io.LineOutput;
import nts.io.Log;
import nts.io.Loggable;
import nts.io.Name;
import nts.io.StandardLog;
import nts.io.StringLog;
import nts.io.WriterLineOutput;
import nts.node.TypeSetter;
import nts.tex.EditException;
import nts.tex.FatalError;
import nts.tex.FileOpener;
import nts.tex.StdinReadInput;
import nts.tex.TeXCharMapper;
import nts.tex.TeXContextDisplay;
import nts.tex.TeXError;
import nts.tex.TeXErrorPool;
import nts.tex.TeXTokenMaker;
import nts.typo.TypoCommand;

public class TeXIOHandler
implements CommandBase.IOHandler,
LineInputTokenizer.InputHandler,
LineInputReadInput.InputHandler,
TeXTokenMaker.ErrHandler {
    private Config config;
    private InputLine firstLine;
    private TeXCharMapper mapper;
    private FileOpener opener;
    private TeXTokenMaker maker;
    private ContextDisplay contextDisplay;
    private TeXErrorPool errPool;
    private Name jobName = null;
    private boolean afterEnd = false;
    private transient String shownBuilderName = null;
    private int errorCount = 0;
    private FileName dviName = null;
    private DviTypeSetter dviSetter = null;
    private FileName fmtName = null;
    private ObjectOutputStream dumper = null;
    private FileName logName = null;
    private LineOutput logFile = null;

    public TeXTokenMaker getTokenMaker() {
        return this.maker;
    }

    public Name getJobName() {
        if (this.jobName == null) {
            this.jobName = Token.makeName("texput");
            this.openLogFile();
        }
        return this.jobName;
    }

    public void ensureOpenLog() {
        this.getJobName();
    }

    public void openInput(FileName name) {
        Reader in;
        FileName fullName;
        while (true) {
            fullName = name.copy();
            try {
                in = this.openReader(fullName, "tex", true);
            }
            catch (IOException e) {
                this.cantOpen(name, true, true);
                name = this.promptFileName("input file name");
                continue;
            }
            break;
        }
        if (this.jobName == null) {
            this.jobName = name.baseName();
            this.openLogFile();
        }
        int len = CommandBase.normLog.voidCounter().add(fullName).getCount();
        CommandBase.normLog.sepRoom(len + 2).add('(').add(fullName).flush();
        CommandBase.getTokStack().push(new LineInputTokenizer(new LineInput(in, (InputLine.Mapper)this.mapper), this, name));
    }

    public void setAfterEnd() {
        this.afterEnd = true;
    }

    public void closeInput() {
        if (this.afterEnd) {
            CommandBase.normLog.add(' ');
        }
        CommandBase.normLog.add(')').flush();
    }

    /*
     * WARNING - void declaration
     */
    public ReadInput openRead(FileName name, int num) {
        void in;
        try {
            Reader reader = this.openReader(name, "tex", false);
        }
        catch (IOException e) {
            return null;
        }
        return new LineInputReadInput(new LineInput((Reader)in, (InputLine.Mapper)this.mapper), this, num);
    }

    public ReadInput defaultRead(int num) {
        return new StdinReadInput(this, num);
    }

    public Log openWrite(FileName name, int num) {
        Writer wr;
        while (true) {
            try {
                wr = this.openWriter(name, "tex");
            }
            catch (IOException e) {
                this.cantOpen(name, false, true);
                name = this.promptFileName("output file name");
                continue;
            }
            break;
        }
        if (this.jobName != null) {
            CommandBase.diagLog.startLine().addEsc("openout").add(num).add(" = `").add(name).add("'.").startLine().endLine();
        }
        return new StandardLog(new WriterLineOutput(wr, this.mapper), this.mapper);
    }

    public Log makeLog(LineOutput out) {
        return new StandardLog(out, this.mapper);
    }

    public Log makeStringLog() {
        return new StringLog(this.mapper);
    }

    public FileName makeFileName() {
        return new TeXCharMapper.TeXFileName();
    }

    public void error(String ident, Loggable[] params, boolean delAllowed) {
        this.error(this.errPool.get(ident), params, true, delAllowed);
    }

    public void fatalError(String ident) {
        this.ensureOpenLog();
        InteractionPrim.setScroll();
        TeXError err = this.errPool.get(ident);
        if (CommandBase.isFileLogActive()) {
            this.error(err, null, true, false);
        } else {
            err.addText(CommandBase.normLog.startLine().add("! "), null);
        }
        throw new FatalError(ident);
    }

    public void errMessage(TokenList message) {
        this.error(this.errPool.get(message, this.config.errHelp()), null, true, true);
    }

    public void logMode() {
        String name = TypoCommand.getBld().modeName();
        if (!name.equals(this.shownBuilderName)) {
            CommandBase.diagLog.add(TypoCommand.getBld()).add(": ");
            this.shownBuilderName = name;
        }
    }

    public void completeShow() {
        String ident = !InteractionPrim.isErrStopping() ? "Void" : (CommandBase.termDiagActive() ? "ShortShow" : "LongShow");
        this.error(this.errPool.get(ident), null, false, true);
    }

    public void illegalCommand(Command cmd) {
        TypoCommand.illegalCase(cmd, TypoCommand.getBld());
    }

    public void resetErrorCount() {
        this.errorCount = 0;
    }

    private void error(TeXError err, Loggable[] params, boolean counting, boolean delAllowed) {
        Log log = CommandBase.normLog;
        if (counting) {
            log.startLine().add("! ");
            err.addText(log, params);
        }
        log.add('.');
        CommandBase.getTokStack().show(this.contextDisplay);
        if (InteractionPrim.isErrStopping()) {
            int currHelp = 0;
            block14: while (true) {
                log.endLine();
                CommandBase.getTokStack().cleanFinishedInserts();
                InputLine line = CommandBase.promptInput("? ");
                CharCode cmd = line.getNextRawCode();
                if (cmd != null) {
                    char c = cmd.toChar();
                    FilePos pos = CommandBase.getTokStack().filePos();
                    switch (Character.toUpperCase(c)) {
                        case 'S': {
                            this.setInteraction("scrollmode");
                            return;
                        }
                        case 'R': {
                            this.setInteraction("nonstopmode");
                            return;
                        }
                        case 'Q': {
                            this.setInteraction("batchmode");
                            return;
                        }
                        case 'I': {
                            String desc;
                            if (line.empty()) {
                                line = CommandBase.promptInput("insert>");
                                String string = "<insert>  ";
                            } else {
                                line = line.pureRest();
                                desc = "<insert>   ";
                            }
                            InputLineTokenizer tokenizer = new InputLineTokenizer(line, this.maker, desc);
                            tokenizer.setMidLine();
                            CommandBase.getTokStack().push(tokenizer);
                            return;
                        }
                        case 'E': {
                            if (pos == null) break;
                            InteractionPrim.setScroll();
                            throw new EditException(pos);
                        }
                        default: {
                            if (!delAllowed || !Character.isDigit(c)) break;
                            int count = Character.digit(c, 10);
                            cmd = line.getNextRawCode();
                            if (cmd != null && Character.isDigit(c = cmd.toChar())) {
                                count = count * 10 + Character.digit(c, 10);
                            }
                            while (count-- > 0) {
                                CommandBase.nextRawToken();
                            }
                            CommandBase.getTokStack().show(this.contextDisplay);
                            currHelp = 2;
                            continue block14;
                        }
                        case 'H': {
                            switch (currHelp) {
                                case 0: {
                                    err.addHelp(log, params);
                                    break;
                                }
                                case 1: {
                                    this.errPool.addHelpAfterHelp(log);
                                    break;
                                }
                                case 2: {
                                    this.errPool.addHelpAfterDel(log);
                                    break;
                                }
                            }
                            currHelp = 1;
                            continue block14;
                        }
                        case 'X': {
                            InteractionPrim.setScroll();
                            throw new FatalError("User stop");
                        }
                    }
                    log.add("Type <return> to proceed, ").add("S to scroll future error messages,").endLine().add("R to run without stopping, ").add("Q to run quietly,").endLine().add("I to insert something, ");
                    if (pos != null) {
                        log.add("E to edit your file,");
                    }
                    if (delAllowed) {
                        log.startLine().add("1 or ... or 9 to ignore ").add("the next 1 to 9 tokens of input,");
                    }
                    log.startLine().add("H for help, X to quit.");
                    continue;
                }
                break;
            }
        } else {
            if (counting && ++this.errorCount >= 100) {
                log.startLine().add("(That makes " + this.errorCount + " errors; please try again.)");
                throw new FatalError("Too many errors");
            }
            err.addDesc(CommandBase.fileLog, params);
            CommandBase.fileLog.endLine();
            log.endLine();
        }
    }

    private void setInteraction(String mode) {
        this.errorCount = 0;
        InteractionPrim.set(mode);
        CommandBase.normLog.add("OK, entering ").add(mode).add("...").endLine();
    }

    public TypeSetter getTypeSetter(DviTypeSetter.FontInformator fontInf) {
        if (this.dviSetter == null) {
            BufferedOutputStream out;
            FileName name = new TeXCharMapper.TeXFileName(this.getJobName());
            String ext = System.getProperty("nts.dvi.extension", "dvi");
            name.append('.');
            name.append(ext);
            while (true) {
                try {
                    out = new BufferedOutputStream(this.opener.openForWriting(name, ext));
                }
                catch (IOException e) {
                    this.cantOpen(name, false, false);
                    name = this.promptFileName("file name for output");
                    name.addDefaultExt(ext);
                    continue;
                }
                break;
            }
            this.dviName = name;
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd:HHmm", Locale.ENGLISH);
            Calendar cal = this.config.date();
            cal.setLenient(true);
            fmt.setCalendar(cal);
            String comment = " TeX output " + fmt.format(cal.getTime());
            this.dviSetter = new DviTypeSetter(out, fontInf, this.config.magnification(), comment.getBytes());
        }
        return this.dviSetter;
    }

    public void finishDvi() {
        if (this.dviSetter != null) {
            this.config.magnification();
            this.dviSetter.close();
            int pages = this.dviSetter.pageCount();
            CommandBase.normLog.startLine().add("Output written on ").add(this.dviName).add(" (").add(pages).add(' ').add(pages != 1 ? "pages" : "page").add(", ").add(this.dviSetter.byteCount()).add(" bytes).");
            this.dviName = null;
            this.dviSetter = null;
        } else {
            CommandBase.normLog.startLine().add("No pages of output.");
        }
    }

    public ObjectOutputStream getDumper() throws IOException {
        if (this.dumper == null) {
            BufferedOutputStream out;
            FileName name = new TeXCharMapper.TeXFileName(this.getJobName());
            name.append('.');
            name.append("nfmt");
            while (true) {
                try {
                    out = new BufferedOutputStream(this.opener.openForWriting(name, "fmt"));
                }
                catch (IOException e) {
                    this.cantOpen(name, false, false);
                    name = this.promptFileName("format file name");
                    name.addDefaultExt("nfmt");
                    continue;
                }
                break;
            }
            this.fmtName = name;
            this.dumper = new ObjectOutputStream(out);
        }
        return this.dumper;
    }

    public FileName getLogName() {
        return this.logName;
    }

    public void closeLogFile() {
        if (this.logFile != null) {
            this.logFile.endLine();
            this.logFile.close();
        }
        this.logName = null;
        this.logFile = null;
    }

    private void openLogFile() {
        Writer wr;
        FileName name = new TeXCharMapper.TeXFileName(this.jobName);
        String ext = System.getProperty("nts.log.extension", "log");
        name.append('.');
        name.append(ext);
        while (true) {
            try {
                wr = this.openWriter(name, ext);
            }
            catch (IOException e) {
                this.cantOpen(name, false, false);
                name = this.promptFileName("transcript file name");
                name.addDefaultExt(ext);
                continue;
            }
            break;
        }
        WriterLineOutput out = new WriterLineOutput(wr, this.mapper, false, 79);
        out.addRaw("This is NTS, Version 1.00-beta");
        SimpleDateFormat fmt = new SimpleDateFormat("d MMM yyyy HH:mm", Locale.ENGLISH);
        Calendar cal = this.config.date();
        cal.setLenient(true);
        fmt.setCalendar(cal);
        out.add("  " + fmt.format(cal.getTime()).toUpperCase());
        out.startLine();
        out.add("**");
        StandardLog log = new StandardLog(out, this.mapper);
        this.firstLine.addContext(log, log, true);
        out.endLine();
        this.logName = name;
        this.logFile = out;
        CommandBase.setLogFile(this.logFile);
    }

    private FileName promptFileName(String prompt) {
        CharCode code;
        CommandBase.normLog.startLine().add("Please type another ").add(prompt);
        if (!InteractionPrim.isInteractive()) {
            this.fatalError("MissingFile");
        }
        InputLine line = CommandBase.promptInput(": ");
        TeXCharMapper.TeXFileName name = new TeXCharMapper.TeXFileName();
        line.skipSpaces();
        while ((code = line.getNextRawCode()) != null && name.accept(code) > 0) {
        }
        return name;
    }

    private void cantOpen(FileName name, boolean inp, boolean cntx) {
        CommandBase.normLog.startLine().add(inp ? "! I can't find file `" : "! I can't write on file `");
        CommandBase.normLog.add(name).add("'.");
        if (cntx) {
            CommandBase.getTokStack().show(this.contextDisplay);
        }
    }

    public InputLine emptyLine() {
        return new InputLine(this.mapper);
    }

    public InputLine confirmLine(InputLine line) {
        if (this.config.confirmingLines() && InteractionPrim.isInteractive()) {
            CommandBase.normLog.endLine().add(line);
            InputLine instead = CommandBase.promptInput("=>");
            if (instead != null && !instead.empty()) {
                return instead;
            }
        }
        return line;
    }

    public Tokenizer makeTokenizer(InputLine line, String desc, boolean addEolc) {
        if (addEolc) {
            line = line.addEndOfLineChar();
        }
        return new InputLineTokenizer(line, this.maker, desc);
    }

    public static Reader makeReader(InputStream in) {
        try {
            return new InputStreamReader(in, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Can't happen");
        }
    }

    private Reader openReader(FileName name, String format, boolean mustExist) throws IOException {
        return TeXIOHandler.makeReader(new BufferedInputStream(this.opener.openForReading(name, format, mustExist)));
    }

    public static Writer makeWriter(OutputStream out) {
        try {
            return new OutputStreamWriter(out, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Can't happen");
        }
    }

    private Writer openWriter(FileName name, String format) throws IOException {
        return TeXIOHandler.makeWriter(new BufferedOutputStream(this.opener.openForWriting(name, format)));
    }

    public InputStream openTeXFm(FileName name) throws IOException {
        return new BufferedInputStream(this.opener.openForReading(name, "tfm", true));
    }

    public TeXIOHandler(Config config, InputLine firstLine, TeXCharMapper mapper, FileOpener opener) {
        this.config = config;
        this.firstLine = firstLine;
        this.mapper = mapper;
        this.opener = opener;
        this.maker = new TeXTokenMaker(config, this);
        this.contextDisplay = new TeXContextDisplay(config, mapper, mapper);
        this.errPool = new TeXErrorPool();
    }

    public static interface Config
    extends TeXTokenMaker.Categorizer {
        public Calendar date();

        public TokenList errHelp();

        public int errContextLines();

        public boolean confirmingLines();

        public int magnification();
    }
}

