---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, caractères, mâle, femelle, symboles de genres
---

# Comment obtenir les symboles "mâle" et "femelle" ?

## Avec l'extension <ctanpkg:marvosym>

L'extension <ctanpkg:marvosym> fournit les commandes `\Female`, `\Male` 
et quelques autres sur la même thématique. En voici les différentes possibilités :


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{marvosym}

\begin{document}
Voici de la variété : \Male (ou \MALE), \Female (ou \FEMALE), \Hermaphrodite
(ou \HERMAPHRODITE), \Neutral, \FemaleFemale, \FemaleMale ou bien encore 
\MaleMale.
\end{document}
```


## Avec l'extension <ctanpkg:fontawesome> ou <ctanpkg:fontawesome5>

L'extension <ctanpkg:fontawesome> fournit tout autant de variété avec `\faVenus`, 
`\faMars` et quelques autres sur la même thématique. 
En voici les différentes possibilités :

```
%!TEX engine=pdflatex
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{fontawesome}

\begin{document}
Voici de la variété : \faVenus, \faMars, \faTransgender, \faNeuter, 
\faGenderless, \faMarsStroke, \faMarsStrokeH, \faMarsStrokeV, 
\faMarsDouble, \faVenusDouble, \faVenusMars\ ou bien \faTransgenderAlt.
\end{document}
```

Notez que cet exemple ne fonctionnerait pas avec lualatex.

Le package <ctanpkg:fontawesome5> fournit encore plus de caractères et des
caractères un peu différents. 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{fontawesome5}

\begin{document}
Voici de la variété : \faVenus, \faMars, \faTransgender, \faNeuter, 
\faGenderless, \faMarsStroke, \faMarsStrokeH, \faMarsStrokeV, 
\faMarsDouble, \faVenusDouble, \faVenusMars\ ou bien \faTransgender*.
\end{document}
```


## Avec l'extension <ctanpkg:stix>

L'extension <ctanpkg:stix> présente quatre symboles mathématiques 
sur ce thème dont `\female` et `\male`. En voici un exemple :


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{stix}

\begin{document}
Voici un peu moins de variété : $\female$, $\male$, 
$\Hermaphrodite$ et $\neuter$.
\end{document}
```


## Avec l'extension <ctanpkg:wasysym>

L'extension <ctanpkg:wasysym> donne deux symboles : `\female` et `\male`. 
En voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{wasysym}

\begin{document}
Voici encore moins de variété : \female{} et \male.
\end{document}
```


## Avec l'extension <ctanpkg:mathabx>

L'extension <ctanpkg:mathabx> se limite également à deux symboles 
à mettre en mode mathématique : `\girl` et `\boy`. En voici un exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{mathabx}

\begin{document}
Voici encore moins de variété : $\girl$ et $\boy$.
\end{document}
```