---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, installation
---

# Comment trouver de nouvelles fontes ?

## Pour XeTeX et LuaTeX  

Les **polices TrueType et OpenType** sont le lot de [XeTeX](/1_generalites/glossaire/xetex) 
et [LuaTeX](/1_generalites/glossaire/luatex). Bien que leur utilisation directe soit assez facile, 
il est conseillé d'utiliser l'extension <ctanpkg:fontspec> 
pour avoir accès à la gamme complète des possibilités offertes par une police.

Daniel Flipo dresse un catalogue de fontes Opentype utilisables dans ce cadre : 
<http://daniel.flipo.free.fr/doc/luatex/>.


## Pour pdf(La)TeX

De nos jours, les nouvelles polices sont rarement développées par des personnes dévouées utilisant MetaFont, 
mais si elles apparaissent, 
elles seront distribuées de la même manière que toute autre partie des collections (La)TeX. 
Le site du CTAN permet d'obtenir une [liste de ces fontes](https://www.ctan.org/topic/font-mf)

De nos jours, la plupart des nouvelles polices qui apparaissent ne sont disponibles 
que sous forme redimensionnable (*scalable*), 
et une grande partie est distribuée sous des conditions commerciales. 
Ces polices ne sont intégrées dans les distributions libres (au moins TeX Live et MiKTeX) 
que si leur licence respecte les conditions posées par ces distributions. 
Les polices commerciales (celles qui sont payantes) ne sont pas intégrées aux distributions, 
bien que le CTAN assure le support de certaines d'entre elles.

Faire en sorte qu'une nouvelle police soit utilisable par (La)TeX peut demander des méthodes très différentes,
selon le type de police et le moteur TeX que vous utilisez. Grosso modo : 
- les **polices MetaFont** fonctionneront sans trop de problèmes 
  (à condition que leurs sources soient placées au bon endroit dans l'arborescence d'installation).
  De fait, TeX associé à  `dvips` tout comme pdfTeX ne poseront pas de difficultés. 
  Bien qu'une nouvelle police doive être "générée" (en exécutant MetaFont, etc.), 
  les distributions sont configurées pour le faire "à la volée" et pour sauvegarder les résultats 
  (pour la prochaine fois).
- Les **polices Adobe Type 1** peuvent fonctionner, 
  après que les fichiers `tfm` et (habituellement) `vf` aient été créés à partir de leurs fichiers métriques (`afm`).
  Les fichiers `map` doivent également être créés. De telles polices fonctionneront avec pdfTeX 
  ainsi qu'avec la combinaison de (La)TeX et `dvips`.
- Les **polices TrueType** peuvent fonctionner avec pdfTeX. Sur ce point, vous pouvez consulter la page anglaise 
  [Using TrueType fonts with TeX...](http://www.radamir.com/tex/ttf-tex.htm) (un document assez ancien, 
  traitant de l'utilisation avec MiKTeX 1.11).

:::{seealso}
La question "[](/5_fichiers/formats/fontes/fontes_t1_pour_les_mathematiques)" traite des polices configurées 
pour une utilisation générale (à la fois textuelle et mathématique) avec (La)TeX. 
La liste de ces polices est suffisamment courte pour qu'elles puissent toutes être abordées dans une seule réponse.
:::


:::{sources}
[Finding new fonts](faquk:FAQ-findfont)
:::