# Contributing to MiKTeX

## Reporting a bug

### Check list

Please review this check list, before you click the `Submit` button:

1. the bug report is self-contained: it does not contain links to questions/reports on external sites (e.g., Stack Exchange Network)
2. step-by-step reproduction instructions
3. configuration report (`initexmf --report`) attached
4. input files attached
5. log files attached

### How to write a good bug report

Before creating a bug report, please check this list:

1. check the [MiKTeX FAQ](https://miktex.org/faq)
2. write down a one-liner which summarizes the problem
3. perform an Internet search with the one-liner as the query

Make sure that others will be able to reproduce the bug by providing:

1. **step-by-step reproduction instructions**:
  describe the exact steps which reproduce the problem in as many details
  as possible
2. **input files which are necessary to reproduce the bug**: aka a [minimal working example](https://en.wikipedia.org/wiki/Minimal_working_example)
3. **your observations**: command output, screenshots

**Most importantly**: include information about your MiKTeX setup:

1. **installation report**: let MiKTeX Console create
  an installation report (on the `Diagnose` page)
2. **contents of the MiKTeX log directory**: MiKTeX Console tells
  you the location of log directory on the `Diagnose` page

### What happens next

A MiKTeX developer will receive a notification. If the bug is
reproducible, it will be a attached to a milestone with an estimated
fix date.

Unreproducible bugs usually lead to queries. So be prepared to make
available additional information.

Sloppy bug reports will be closed (or deleted) without comment.

## Proposing a feature

- open an issue with a detailed description of your proposed feature

Thanks!
