---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              délimiteurs, simplifier une équation, \phantom et espacement, 
              \phantom et alignement, classes de symboles mathématiques
---

# Comment masquer des parenthèses dans une expression mathématique ?

Pour aligner des expressions mathématiques contenant des parenthèses 
qui disparaissent d'une ligne à l'autre, il faut pouvoir indiquer à LaTeX
qu'il doit réserver une place vide là où se tenaient des parenthèses.

Ce type de manipulation peut se faire usuellement avec la commande 
`\phantom`, présentée à la question 
"[](/3_composition/texte/boites/exploiter_les_fantomes)" 

Cependant, si vous essayez d'utiliser `\phantom` dans un tel cas, 
vous obtiendrez un alignement incorrect :

```
\documentclass[12pt]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}

\begin{document}
$ N = (-9) + (+5) $

$ N = \phantom{(}-9\phantom{)} + \phantom{(+}5\phantom{)} $
\end{document}
```

Dans ce cas, vous pouvez avoir l'impression que le problème vient 
des parenthèses, mais il vient surtout des `+` et `-` qui, suivant le contexte,
peuvent être des opérateurs binaires (symboles de l'addition 
et de la soustraction), ou des opérateurs unaires (signes de nombres). 
Suivant le cas, les espacements autour d'eux ne sont pas les mêmes. 
LaTeX se débrouille en général bien pour identifier le contexte, 
mais la commande `\phantom` l'en empêche ici.

Vous avez ici deux solutions :
- utiliser la commande `\mathord` pour forcer manuellement la classe 
  des opérateurs unaires (si besoin, il existe aussi `\mathopen` 
  et `\mathclose` pour forcer la classe des délimiteurs ouvrants et fermants.
  Il se trouve que les parenthèses de cet exemple n'en ont pas besoin ici) ;
- utiliser des accolades `{}` pour aider LaTeX à deviner les bons contextes
  (sûrement la solution la plus simple).

L'exemple suivant illustre ces deux possibilités.

```
\documentclass[12pt]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}

\begin{document}
$ N = (-\tikz[overlay]\draw[red] (0pt,2ex) -- ++(0ex,-8.5ex);9) %
      + (+\tikz[overlay]\draw[red] (0pt,2ex) -- ++(0ex,-8.5ex);5) $

$ N = \phantom{(}\mathord{-}9\phantom{)} %
      + \phantom{(}\mathord{\phantom{+}}5\phantom{)} $

$ N = \phantom{(}{-}9\phantom{)} + \phantom{({+}}5\phantom{)} $
\end{document}
```


:::{seealso}
La question 
"[](/4_domaines_specialises/mathematiques/structures/operateurs/masquer_des_operateurs)"
illustre un autre cas courant en mathématiques.
:::


:::{sources}
- [How to add phantom space in math mode without losing "natural" spacing?](https://tex.stackexchange.com/q/330845),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::