#! /usr/bin/env python

"""
mkovp.py
-----------------------------------------------------------------
Copyright (c) 1999  Matthew C. Gushee
[see below for license info]

This script generates an Omega Virtual Property list (OVP) file.
While future versions may be applicable to a variety of fonts and
encodings, this version has the following restrictions:

1) It produces a single OVP file called ommincho.ovp, which maps
   a single series of character codes (up to a theoretical maximum
   of 65,536) to glyph indexes in multiple TeX Font Metric (TFM)
   files.
   
2) It requires that you have certain data files for input. You need:

   * ommincho.ovp-head: contains all global information for an
     OVP file, including MAPFONT entries for all subfonts to be
     included. The OVP file format is essentially the same as that
     of TeX's VPL format, but OVP expands the capabilities of VPL.
     While some of the additional functions are probably necessary
     to provide a fully usable virtual font for CJK, you can make
     a rough approximation for experimental purposes simply by using
     the header of a VPL file and adding appropriate MAPFONT entries.

   * ommincho.ovp-data: specifies character numbers for a series of
     subfonts, using the following syntax:
     
      ommincho.ovp-data: (subfontspec NEWLINE separator NEWLINE)* 
                             subfontspec
      subfontspec: subfontid COLON NEWLINE (glyphnum NEWLINE)+
      (subfontid | glyphnum): hexnum
      hexnum: hexdigit+
      separator: HYPHEN
      
     Extra white space is ignored.  Note that <hexnum> should not
     include any prefix or suffix sucha as '0x' or 'h'. Note also that
     this is my first attempt at a formal syntax description, so if
     you see a problem with it, please let me know.

   * ommincho??.gil (one for each .tfm file): GIL stands for
     Glyph Index List. Each GIL file consists of a series of
     glyph indexes corresponding to those in a VPL file. You
     can create a series of GIL files using the following UNIX
     shell commands:

     $ for pl in *.vpl; do
     > grep "^(CHAR" $pl >temp
     > sed 's/(CHARACTER \(. .*\)/\1/g' temp >${pl%vpl}gil
     > done

3) You must execute the script from the directory containing the
   above files.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

please send comments, praise, bug reports to mgushee@havenrock.com
"""
import os, sys, string

src0 = "msmin.ovp-head"
src1 = "msmin.ovp-data"
tgt = "omsmin.ovp"

fi0 = open(src0, 'r')
fo = open(tgt, 'w')
fo.write(fi0.read())
fi0.close()

fi1 = open(src1, 'r')

fontid = string.strip(fi1.readline())[:-1]
fo.write("(COMMENT Begin msmin%s)\n\n" % fontid)
fi = open('msmin%s.gil' % fontid, 'r')

fontnum = 0
width = 0.5

for line in fi1.readlines():
    line = string.strip(line)
    if line == '-':
        fontnum = fontnum + 1
        fi.close()
    elif line[-1] == ':':
        fontid = line[:-1]
        fo.write("\n\n(COMMENT Begin msmin%s)\n\n" % fontid)
        fi = open('msmin%s.gil' % fontid, 'r')
    else:
        charspec = string.strip(fi.readline())
        if line == "00a7":
            width = "1.0"
        line = string.upper(line)
        fo.write("(CHARACTER H %s\n   (CHARWD R %s)\n" % (line, width))
        fo.write("   (CHARHT R 1.0)\n   (MAP\n")
        fo.write("      (SELECTFONT D %d)(SETCHAR %s)\n" % (fontnum, charspec))
        fo.write("      )\n   )\n")

try: fi.close()
except: pass
fi1.close()
fo.close()
