/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.MidControlSequence;
import com.dickimawbooks.texparserlib.StackMarker;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import java.io.IOException;

public class Group
extends TeXObjectList {
    public Group() {
    }

    public Group(int n) {
        super(n);
    }

    public Group(TeXParserListener teXParserListener, String string) {
        super(teXParserListener, string);
    }

    public TeXObjectList toList() {
        TeXObjectList teXObjectList = new TeXObjectList(this.size());
        teXObjectList.addAll(this);
        return teXObjectList;
    }

    @Override
    public TeXObjectList createList() {
        return new Group(this.capacity());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        StackMarker stackMarker = null;
        if (teXObjectList != teXParser && teXObjectList != null) {
            stackMarker = new StackMarker();
            this.add(stackMarker);
            this.addAll(teXObjectList);
            teXObjectList.clear();
        }
        this.startGroup(teXParser);
        this.processList(teXParser, stackMarker);
        this.endGroup(teXParser);
        if (!this.isEmpty()) {
            teXObjectList.addAll(this);
            this.clear();
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.startGroup(teXParser);
        this.processList(teXParser, null);
        this.endGroup(teXParser);
    }

    public void startGroup(TeXParser teXParser) throws IOException {
        teXParser.startGroup();
    }

    public void endGroup(TeXParser teXParser) throws IOException {
        teXParser.endGroup();
    }

    protected void processList(TeXParser teXParser, StackMarker stackMarker) throws IOException {
        TeXObject teXObject;
        TeXObjectList teXObjectList = new TeXObjectList();
        TeXObjectList teXObjectList2 = new TeXObjectList();
        MidControlSequence midControlSequence = null;
        for (int i = 0; i < this.size() && !(teXObject = (TeXObject)this.get(i)).equals(stackMarker); ++i) {
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject == null) break;
            if (teXObject instanceof MidControlSequence) {
                midControlSequence = (MidControlSequence)teXObject;
                continue;
            }
            if (midControlSequence == null) {
                teXObjectList.add(teXObject);
                continue;
            }
            teXObjectList2.add(teXObject);
        }
        if (midControlSequence == null) {
            TeXObject teXObject2;
            teXObjectList = null;
            teXObjectList2 = null;
            while (this.size() != 0 && !(teXObject2 = (TeXObject)this.remove(0)).equals(stackMarker) && teXObject2 != null) {
                if (teXObject2 instanceof TeXCsRef) {
                    teXObject2 = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject2).getName());
                }
                if (teXObject2 instanceof Declaration) {
                    this.pushDeclaration((Declaration)teXObject2);
                }
                teXObject2.process(teXParser, this);
            }
        } else {
            this.clear();
            midControlSequence.process(teXParser, teXObjectList, teXObjectList2);
        }
        this.processEndDeclarations(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(this.getBegin(teXParser));
        teXObjectList.addAll(this);
        teXObjectList.add(this.getEnd(teXParser));
        return teXObjectList.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        teXObjectList2.add(this.getBegin(teXParser));
        teXObjectList2.addAll(this);
        teXObjectList2.add(this.getEnd(teXParser));
        if (teXObjectList != null && teXObjectList != teXParser) {
            while (teXObjectList.size() > 0) {
                teXObjectList2.add((TeXObject)teXObjectList.remove(0));
            }
        }
        return teXObjectList2.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(this.getBegin(teXParser));
        teXObjectList.addAll(this);
        teXObjectList.add(this.getEnd(teXParser));
        return teXObjectList.expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        teXObjectList2.add(this.getBegin(teXParser));
        teXObjectList2.addAll(this);
        teXObjectList2.add(this.getEnd(teXParser));
        if (teXObjectList != null && teXObjectList != teXParser) {
            while (teXObjectList.size() > 0) {
                teXObjectList2.add((TeXObject)teXObjectList.remove(0));
            }
        }
        return teXObjectList2.expandfully(teXParser);
    }

    @Override
    public String toString(TeXParser teXParser) {
        return String.format("%s%s%s", this.getBegin(teXParser).toString(teXParser), super.toString(teXParser), this.getEnd(teXParser).toString(teXParser));
    }

    @Override
    public String toString() {
        return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
    }

    @Override
    public String format() {
        return "{" + super.format() + "}";
    }

    public TeXObject getBegin(TeXParser teXParser) {
        return teXParser.getListener().getBgChar(teXParser.getBgChar());
    }

    public TeXObject getEnd(TeXParser teXParser) {
        return teXParser.getListener().getEgChar(teXParser.getEgChar());
    }
}

