/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  fsm_class_phrase_th.lex
Dates:		  2 Mar 2004
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |fsm_class_phrase_th| Thread.\fbreak
Parse fsm-class phrase along with its directives.\fbreak
\fbreak
|cweave| coughs so forgive it until i correct |cweave|.\fbreak
\fbreak
Example of a fsm's class to parse:\fbreak
\listing{"/usr/local/yacco2/diagrams+etc/fsmclass.txt"}
@/
fsm	
(fsm-id "fsm_class_phrase_th.lex",fsm-filename	fsm_class_phrase_th,fsm-namespace NS_fsm_class_phrase_th
,fsm-class Cfsm_class_phrase_th{
  user-prefix-declaration
using namespace NS_yacco2_terminals;
#include "lint_balls.h"
#include "cweb_or_c_k.h"
#include "identifier.h"
#include "o2_sdc.h"
  ***
  user-declaration
    public:
    T_fsm_class_phrase* fsm_class_phrase_;
    std::map<std::string,yacco2::CAbs_lr1_sym*> directives_map_;
    void remove_directives_from_map();
    yacco2::CAbs_lr1_sym* add_directive_to_map(yacco2::CAbs_lr1_sym* Directive);
    void add_sdc_to_directive(yacco2::CAbs_lr1_sym* Dir,T_syntax_code* Sdc);
  ***
  constructor
    fsm_class_phrase_ = 0;
  ***
  user-implementation
    void Cfsm_class_phrase_th::remove_directives_from_map(){
      delete fsm_class_phrase_;
      fsm_class_phrase_ = 0;
    }
    
/@
@*3 |add_directive_to_map|.
@/
   yacco2::CAbs_lr1_sym* // 0 - ok, or error 
    Cfsm_class_phrase_th::
    add_directive_to_map(yacco2::CAbs_lr1_sym* Directive){
      CAbs_lr1_sym* sym = 
	fsm_class_phrase_->add_directive_to_map(Directive,parser__);
      return sym; 
    }
/@
@*3 |add_sdc_to_directive|.
@/
    void Cfsm_class_phrase_th::
    add_sdc_to_directive(yacco2::CAbs_lr1_sym* Dr,T_syntax_code* Sdc){
      using namespace NS_yacco2_T_enum;
      int eid = Dr->enumerated_id__;
      switch (eid){
		case T_Enum::T_T_user_declaration_: {
		  T_user_declaration* k = (T_user_declaration*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_user_prefix_declaration_: {
		  T_user_prefix_declaration* k = (T_user_prefix_declaration*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_user_suffix_declaration_: {
		  T_user_suffix_declaration* k = (T_user_suffix_declaration*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_constructor_: {
		  T_constructor* k = (T_constructor*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_destructor_: {
		  T_destructor* k = (T_destructor*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_op_: {
		  T_op* k = (T_op*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_failed_: {
		  T_failed* k = (T_failed*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_user_implementation_: {
		  T_user_implementation* k = (T_user_implementation*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_user_imp_tbl_: {
		  T_user_imp_tbl* k = (T_user_imp_tbl*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_user_imp_sym_: {
		  T_user_imp_sym* k = (T_user_imp_sym*)Dr;
		  k->syntax_code(Sdc);
		  break;
		}
		default: {
          CAbs_lr1_sym* sym = new Err_improper_directive;
          sym->set_rc(*Dr,__FILE__,__LINE__);
          RSVP_FSM(sym);
          parser__->set_stop_parse(true);
		}      
      }    
    }
  ***
  op
    if(fsm_class_phrase_ != 0){
      delete fsm_class_phrase_;
      fsm_class_phrase_ = 0;
    }
    fsm_class_phrase_ = new T_fsm_class_phrase;
    fsm_class_phrase_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    AST* t = new AST(*fsm_class_phrase_);
    fsm_class_phrase_->phrase_tree(t);
  ***
}
,fsm-version "1.0",fsm-date "2 mar 2004",fsm-debug "false"
,fsm-comments "Parse the fsm-class grammar construct.")
parallel-parser	
(	
  parallel-thread-function
    TH_fsm_class_phrase_th
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rfsm_class_phrase_th  (){
  -> Rid Rlint Rpotential_code_blk {
    op
      Cfsm_class_phrase_th* fsm = 
	(Cfsm_class_phrase_th*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->fsm_class_phrase_);
      fsm->fsm_class_phrase_ = 0;
    ***
    }	
}

Rid  (){
  ->  ||| identifier NS_identifier::TH_identifier {
      op 
        Cfsm_class_phrase_th* fsm = 
		(Cfsm_class_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->fsm_class_phrase_->identifier(sf->p2__);
      ***
      }
  ->  ||| |?| NULL {
    op
      sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_identifier_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_identifier_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rpotential_code_blk  (){
  ->  Rpotential_directives
}

Rpotential_directives  (){
  ->  |.| 
  ->  "{" Rlint Rmust_directive_phrase 
		Rmaybe_more_directives Rclosing_brace Rlint
}

Rmust_directive_phrase  (){ 
  ->  Rdirective_cweb_k Rlint Rmust_directive Rsyntax_code Rlint {
    op
      AST* cwebt = sf->p1__->cweb_t_;
      Rmust_directive* dir = sf->p3__;
      Rsyntax_code* sdc = sf->p4__;
      if(cwebt != 0)
        sdc->syntax_code_->add_cweb_marker(cwebt);
      Cfsm_class_phrase_th* fsm = 
	(Cfsm_class_phrase_th*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
}

Rmust_directive  (
lhs {
  user-declaration
    CAbs_lr1_sym* directive_;
  ***
  op
    if(directive_ == 0) return;
    Cfsm_class_phrase_th* fsm = (
	Cfsm_class_phrase_th*)rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* result = fsm->add_directive_to_map(directive_);
    if(result == 0) return;// ok added
    directive_->set_auto_delete(true);//dup: delete when popped from stack
    RSVP(result);
    rule_info__.parser__->set_stop_parse(true);
  ***
 } 
){ 
  ->  ||| "#user-declaration" NS_identifier::TH_identifier { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-implementation" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-prefix-declaration" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-suffix-declaration" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#constructor" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#destructor" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#op" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#failed" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-imp-tbl" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-imp-sym" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| |?| NULL {
    op
        directive_ = 0;
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  -> |?| {
    op
        directive_ = 0;
        CAbs_lr1_sym* sym = new Err_no_directive_present;
        sym->set_rc(*sf->p1__,__FILE__,__LINE__);
       RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
}

Rmaybe_more_directives  (){ 
  -> //|+| // force the reduce
  ->  Rmaybe_directive_phrases 
}

Rmaybe_directive_phrases  (){ 
  ->  Rmaybe_directive_phrase 
  ->  Rmaybe_directive_phrases Rmaybe_directive_phrase 
}

Rmaybe_directive_phrase  (){ 
  ->  Rcweb_k Rlint Rdirective Rsyntax_code Rlint {
    op
      AST* cwebt = sf->p1__->cweb_t_;
      Rdirective* dir = sf->p3__;
      Rsyntax_code* sdc = sf->p4__;
      if(cwebt != 0)
        sdc->syntax_code_->add_cweb_marker(cwebt);
      Cfsm_class_phrase_th* fsm = 
	(Cfsm_class_phrase_th*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
  ->  Rdirective Rsyntax_code Rlint {
    op
      Rdirective* dir = sf->p1__;
      Rsyntax_code* sdc = sf->p2__;
      Cfsm_class_phrase_th* fsm = 
	(Cfsm_class_phrase_th*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
}

Rdirective  (
lhs {
  user-declaration
    CAbs_lr1_sym* directive_;
  ***
  op
    if(directive_ == 0) return;
    Cfsm_class_phrase_th* fsm = (
	Cfsm_class_phrase_th*)rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* result = fsm->add_directive_to_map(directive_);
    if(result == 0) return;// ok added
    directive_->set_auto_delete(true);//dup: delete when popped from stack
    RSVP(result);
    rule_info__.parser__->set_stop_parse(true);
  ***
 } 
){ 
  ->  ||| "#user-declaration" NS_identifier::TH_identifier { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-implementation" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-prefix-declaration" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-suffix-declaration" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#constructor" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#destructor" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#op" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#failed" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-imp-tbl" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-imp-sym" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| |?| NULL {
    op
        directive_ = 0;
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
}

Rclosing_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_brace;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "}"
}

Rsyntax_code  (
lhs {
  user-declaration
    T_syntax_code* syntax_code_;
  ***
 } 
){
  -> ||| "syntax-code" NS_o2_sdc::TH_o2_sdc {
      op
        syntax_code_ = sf->p2__;
      ***
      }
  -> ||| |?| NULL { // catcher in the Rye? These are errors
      op
        syntax_code_ = 0;
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  -> 
}

Rdirective_cweb_k  (
lhs {
	user-declaration
	  AST* cweb_t_;
	***
	constructor
	  cweb_t_ = 0;
	***
	}
){
  -> 
 ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
	op
        T_cweb_comment* k = sf->p2__;
        AST* cwebk_t_ = new AST(*k);
        cweb_t_ = new AST();
        T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
        AST::set_content(*cweb_t_,*cw);

        cw->set_rc(*k,__FILE__,__LINE__);
        AST::join_pts(*cweb_t_,*cwebk_t_);
	***
	}
  ->  ||| "comment-overrun" NULL {
      op 
		RSVP(sf->p2__);
		rule_info__.parser__->set_stop_parse(true); 
      ***
      }      
}

Rcweb_k  (
lhs {
	user-declaration
	  AST* cweb_t_;
	***
	constructor
	  cweb_t_ = 0;
	***
	}
){
 ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
	op
        T_cweb_comment* k = sf->p2__;
        AST* cwebk_t_ = new AST(*k);
        cweb_t_ = new AST();
        T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
        AST::set_content(*cweb_t_,*cw);
        cw->set_rc(*k,__FILE__,__LINE__);
        AST::join_pts(*cweb_t_,*cwebk_t_);
	***
	}
  ->  ||| "comment-overrun" NULL {
      op 
		RSVP(sf->p2__);
		rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
}
}// end of rules
