/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  rhs_bnd.lex
Dates:		  10 Jun 2004
Purpose:	  finds the end-of-a-subrule's expression
              The stoppers are:
               { start of a syntax directed code block
               } end of the rule's subrules
               -> start of a new subrule expression
Output:       Err_subrule_overrun
              eosubrule 
Note:		Lookahead pair < token, pos > is the same start token
			of this thread cuz an end-of-subrule is invisible
			caused by either the start of another subrule definition 
			or the end of a rule definition.
			
			To properly parse these other junction points, the token
			stream must stay aligned at the point of invocation.
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |rhs_bnd| thread.\fbreak
Finds the end-of-a-subrule's expression.
The stoppers are:\fbreak
\ptindent{\prtobrace --- start of a syntax directed code block}
\ptindent{\prtcbrace --- end of the rule's subrules}
\ptindent{\prtstartsr start of a new subrule expression}
\fbreak
Note:\fbreak
Lookahead pair $<$ token, pos $>$ is the same start token
of this thread cuz an end-of-subrule is invisible
caused by either the start of another subrule definition 
or the end of a rule definition.
			
To properly parse these other junction points, the token
stream must stay aligned at the point of invocation.
@/
fsm	
(fsm-id "rhs_bnd.lex"
,fsm-filename rhs_bnd
,fsm-namespace NS_rhs_bnd
,fsm-class Crhs_bnd
,fsm-version "1.0",fsm-date "24 mar 2004",fsm-debug "false"
,fsm-comments "Determine end-of-subrule expression within a rule.")
parallel-parser	
(	
  parallel-thread-function
    TH_rhs_bnd
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rrhs_bnd (
lhs{
  op 
    CAbs_lr1_sym* sym = new T_eosubrule;
    sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
    // pass back lookahead as start of thread 
  RSVP_WLA(sym,rule_info__.parser__->start_token__,sym->tok_co_ords__.rc_pos__);
  ***
}
){
  -> "{"
  -> "}"
  -> "-" ">"	
  -> eog {
	op
		CAbs_lr1_sym* sym = new Err_subrule_overrun;
		sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
		RSVP(sym);
		rule_info__.parser__->set_stop_parse(true);  
	***
	}
}
}// end of rules
